/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.PackageDefinitionStrategy;
import net.bytebuddy.utility.RandomString;

public interface ClassInjector {
    public static final ProtectionDomain DEFAULT_PROTECTION_DOMAIN = null;

    public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> var1);

    public static class UsingInstrumentation
    implements ClassInjector {
        private static final String PREFIX = "jar";
        private static final String CLASS_FILE_EXTENSION = ".class";
        private final Instrumentation instrumentation;
        private final Target target;
        private final File folder;
        private final RandomString randomString;

        public UsingInstrumentation(File folder, Target target, Instrumentation instrumentation) {
            this.folder = folder;
            this.target = target;
            this.instrumentation = instrumentation;
            this.randomString = new RandomString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> types) {
            File jarFile = new File(this.folder, String.format("%s%s.jar", PREFIX, this.randomString.nextString()));
            try {
                if (!jarFile.createNewFile()) {
                    throw new IllegalStateException("Cannot create file " + jarFile);
                }
                JarOutputStream jarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(jarFile)));
                try {
                    for (Map.Entry<? extends TypeDescription, byte[]> entry : types.entrySet()) {
                        jarOutputStream.putNextEntry(new JarEntry(entry.getKey().getInternalName() + CLASS_FILE_EXTENSION));
                        jarOutputStream.write(entry.getValue());
                    }
                }
                finally {
                    jarOutputStream.close();
                }
                this.target.inject(this.instrumentation, new JarFile(jarFile));
                HashMap loaded = new HashMap(types.size());
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                for (TypeDescription typeDescription : types.keySet()) {
                    loaded.put(typeDescription, classLoader.loadClass(typeDescription.getName()));
                }
                return loaded;
            }
            catch (IOException exception) {
                throw new IllegalStateException("Cannot write jar file to disk", exception);
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalStateException("Cannot load injected class", exception);
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            UsingInstrumentation that = (UsingInstrumentation)other;
            return this.folder.equals(that.folder) && this.instrumentation.equals(that.instrumentation) && this.target == that.target;
        }

        public int hashCode() {
            int result = this.instrumentation.hashCode();
            result = 31 * result + this.target.hashCode();
            result = 31 * result + this.folder.hashCode();
            return result;
        }

        public String toString() {
            return "ClassInjector.UsingInstrumentation{instrumentation=" + this.instrumentation + ", target=" + (Object)((Object)this.target) + ", folder=" + this.folder + ", randomString=" + this.randomString + '}';
        }

        public static enum Target {
            BOOTSTRAP{

                @Override
                protected void inject(Instrumentation instrumentation, JarFile jarFile) {
                    instrumentation.appendToBootstrapClassLoaderSearch(jarFile);
                }
            }
            ,
            SYSTEM{

                @Override
                protected void inject(Instrumentation instrumentation, JarFile jarFile) {
                    instrumentation.appendToSystemClassLoaderSearch(jarFile);
                }
            };


            protected abstract void inject(Instrumentation var1, JarFile var2);

            public String toString() {
                return "ClassInjector.UsingInstrumentation.Target." + this.name();
            }
        }
    }

    public static class UsingReflection
    implements ClassInjector {
        private static final ReflectionStore REFLECTION_STORE;
        private final ClassLoader classLoader;
        private final ProtectionDomain protectionDomain;
        private final AccessControlContext accessControlContext;
        private final PackageDefinitionStrategy packageDefinitionStrategy;

        public UsingReflection(ClassLoader classLoader) {
            this(classLoader, DEFAULT_PROTECTION_DOMAIN, PackageDefinitionStrategy.Trivial.INSTANCE);
        }

        public UsingReflection(ClassLoader classLoader, ProtectionDomain protectionDomain, PackageDefinitionStrategy packageDefinitionStrategy) {
            if (classLoader == null) {
                throw new IllegalArgumentException("Cannot inject classes into the bootstrap class loader");
            }
            this.classLoader = classLoader;
            this.protectionDomain = protectionDomain;
            this.packageDefinitionStrategy = packageDefinitionStrategy;
            this.accessControlContext = AccessController.getContext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> types) {
            try {
                HashMap loaded = new HashMap(types.size());
                ClassLoader classLoader = this.classLoader;
                synchronized (classLoader) {
                    for (Map.Entry<? extends TypeDescription, byte[]> entry : types.entrySet()) {
                        Class type = REFLECTION_STORE.findClass(this.classLoader, entry.getKey().getName());
                        if (type == null) {
                            try {
                                type = (Class)AccessController.doPrivileged(new ClassLoadingAction(entry.getKey().getName(), entry.getValue()), this.accessControlContext);
                            }
                            catch (PrivilegedActionException exception) {
                                if (exception.getCause() instanceof IllegalAccessException) {
                                    throw (IllegalAccessException)exception.getCause();
                                }
                                if (exception.getCause() instanceof InvocationTargetException) {
                                    throw (InvocationTargetException)exception.getCause();
                                }
                                if (exception.getCause() instanceof IOException) {
                                    throw new IllegalStateException("Exception on IO operation", exception.getCause());
                                }
                                throw (RuntimeException)exception.getCause();
                            }
                        }
                        loaded.put(entry.getKey(), type);
                    }
                }
                return loaded;
            }
            catch (IllegalAccessException exception) {
                throw new IllegalStateException("Could not access injection method", exception);
            }
            catch (InvocationTargetException exception) {
                throw new IllegalStateException("Exception on invoking loader method", exception.getCause());
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            UsingReflection that = (UsingReflection)other;
            return this.accessControlContext.equals(that.accessControlContext) && this.classLoader.equals(that.classLoader) && this.packageDefinitionStrategy.equals(that.packageDefinitionStrategy) && !(this.protectionDomain == null ? that.protectionDomain != null : !this.protectionDomain.equals(that.protectionDomain));
        }

        public int hashCode() {
            int result = this.classLoader.hashCode();
            result = 31 * result + (this.protectionDomain != null ? this.protectionDomain.hashCode() : 0);
            result = 31 * result + this.packageDefinitionStrategy.hashCode();
            result = 31 * result + this.accessControlContext.hashCode();
            return result;
        }

        public String toString() {
            return "ClassInjector.UsingReflection{classLoader=" + this.classLoader + ", protectionDomain=" + this.protectionDomain + ", packageDefinitionStrategy=" + this.packageDefinitionStrategy + ", accessControlContext=" + this.accessControlContext + '}';
        }

        static {
            ReflectionStore reflectionStore;
            try {
                Method findLoadedClass = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
                findLoadedClass.setAccessible(true);
                Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                defineClass.setAccessible(true);
                Method getPackage = ClassLoader.class.getDeclaredMethod("getPackage", String.class);
                getPackage.setAccessible(true);
                Method definePackage = ClassLoader.class.getDeclaredMethod("definePackage", String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class);
                definePackage.setAccessible(true);
                reflectionStore = new ReflectionStore.Resolved(findLoadedClass, defineClass, getPackage, definePackage);
            }
            catch (Exception exception) {
                reflectionStore = new ReflectionStore.Faulty(exception);
            }
            REFLECTION_STORE = reflectionStore;
        }

        protected class ClassLoadingAction
        implements PrivilegedExceptionAction<Class<?>> {
            private static final int FROM_BEGINNING = 0;
            private final String typeName;
            private final byte[] binaryRepresentation;

            protected ClassLoadingAction(String typeName, byte[] binaryRepresentation) {
                this.typeName = typeName;
                this.binaryRepresentation = binaryRepresentation;
            }

            @Override
            public Class<?> run() throws IllegalAccessException, InvocationTargetException, IOException {
                int packageIndex = this.typeName.lastIndexOf(46);
                if (packageIndex != -1) {
                    String packageName = this.typeName.substring(0, packageIndex);
                    PackageDefinitionStrategy.Definition definition = UsingReflection.this.packageDefinitionStrategy.define(UsingReflection.this.classLoader, packageName, this.typeName);
                    if (definition.isDefined()) {
                        Package definedPackage = REFLECTION_STORE.getPackage(UsingReflection.this.classLoader, packageName);
                        if (definedPackage == null) {
                            REFLECTION_STORE.definePackage(UsingReflection.this.classLoader, packageName, definition.getSpecificationTitle(), definition.getSpecificationVersion(), definition.getSpecificationVendor(), definition.getImplementationTitle(), definition.getImplementationVersion(), definition.getImplementationVendor(), definition.getSealBase());
                        } else if (!definition.isCompatibleTo(definedPackage)) {
                            throw new SecurityException("Sealing violation for package " + packageName);
                        }
                    }
                }
                return REFLECTION_STORE.loadClass(UsingReflection.this.classLoader, this.typeName, this.binaryRepresentation, 0, this.binaryRepresentation.length, UsingReflection.this.protectionDomain);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                ClassLoadingAction that = (ClassLoadingAction)other;
                return Arrays.equals(this.binaryRepresentation, that.binaryRepresentation) && UsingReflection.this.equals(that.getOuter()) && this.typeName.equals(that.typeName);
            }

            private UsingReflection getOuter() {
                return UsingReflection.this;
            }

            public int hashCode() {
                int result = this.typeName.hashCode();
                result = 31 * result + UsingReflection.this.hashCode();
                result = 31 * result + Arrays.hashCode(this.binaryRepresentation);
                return result;
            }

            public String toString() {
                return "ClassInjector.UsingReflection.ClassLoadingAction{injector=" + UsingReflection.this + ", typeName='" + this.typeName + '\'' + ", binaryRepresentation=<" + this.binaryRepresentation.length + " bytes>" + '}';
            }
        }

        protected static interface ReflectionStore {
            public Class<?> findClass(ClassLoader var1, String var2) throws IllegalAccessException, InvocationTargetException;

            public Class<?> loadClass(ClassLoader var1, String var2, byte[] var3, int var4, int var5, ProtectionDomain var6) throws InvocationTargetException, IllegalAccessException;

            public Package getPackage(ClassLoader var1, String var2) throws InvocationTargetException, IllegalAccessException;

            public Package definePackage(ClassLoader var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, URL var9) throws InvocationTargetException, IllegalAccessException;

            public static class Faulty
            implements ReflectionStore {
                private static final String MESSAGE = "Cannot access reflection API for class loading";
                private final Exception exception;

                protected Faulty(Exception exception) {
                    this.exception = exception;
                }

                @Override
                public Class<?> findClass(ClassLoader classLoader, String name) {
                    throw new IllegalStateException(MESSAGE, this.exception);
                }

                @Override
                public Class<?> loadClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, int startIndex, int endIndex, ProtectionDomain protectionDomain) {
                    throw new IllegalStateException(MESSAGE, this.exception);
                }

                @Override
                public Package getPackage(ClassLoader classLoader, String name) {
                    throw new IllegalStateException(MESSAGE, this.exception);
                }

                @Override
                public Package definePackage(ClassLoader classLoader, String packageName, String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, URL sealBase) {
                    throw new IllegalStateException(MESSAGE, this.exception);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.exception.equals(((Faulty)other).exception);
                }

                public int hashCode() {
                    return this.exception.hashCode();
                }

                public String toString() {
                    return "ClassInjector.UsingReflection.ReflectionStore.Faulty{exception=" + this.exception + '}';
                }
            }

            public static class Resolved
            implements ReflectionStore {
                private final Method findLoadedClass;
                private final Method loadClass;
                private final Method getPackage;
                private final Method definePackage;

                protected Resolved(Method findLoadedClass, Method loadClass, Method getPackage, Method definePackage) {
                    this.findLoadedClass = findLoadedClass;
                    this.loadClass = loadClass;
                    this.getPackage = getPackage;
                    this.definePackage = definePackage;
                }

                @Override
                public Class<?> findClass(ClassLoader classLoader, String name) throws IllegalAccessException, InvocationTargetException {
                    return (Class)this.findLoadedClass.invoke((Object)classLoader, name);
                }

                @Override
                public Class<?> loadClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, int startIndex, int endIndex, ProtectionDomain protectionDomain) throws InvocationTargetException, IllegalAccessException {
                    return (Class)this.loadClass.invoke((Object)classLoader, name, binaryRepresentation, startIndex, endIndex, protectionDomain);
                }

                @Override
                public Package getPackage(ClassLoader classLoader, String name) throws InvocationTargetException, IllegalAccessException {
                    return (Package)this.getPackage.invoke((Object)classLoader, name);
                }

                @Override
                public Package definePackage(ClassLoader classLoader, String packageName, String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, URL sealBase) throws InvocationTargetException, IllegalAccessException {
                    return (Package)this.definePackage.invoke((Object)classLoader, packageName, specificationTitle, specificationVersion, specificationVendor, implementationTitle, implementationVersion, implementationVendor, sealBase);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Resolved resolved = (Resolved)other;
                    return this.findLoadedClass.equals(resolved.findLoadedClass) && this.loadClass.equals(resolved.loadClass) && this.getPackage.equals(resolved.getPackage) && this.definePackage.equals(resolved.definePackage);
                }

                public int hashCode() {
                    int result = this.findLoadedClass.hashCode();
                    result = 31 * result + this.loadClass.hashCode();
                    result = 31 * result + this.getPackage.hashCode();
                    result = 31 * result + this.definePackage.hashCode();
                    return result;
                }

                public String toString() {
                    return "ClassInjector.UsingReflection.ReflectionStore.Resolved{findLoadedClass=" + this.findLoadedClass + ", loadClass=" + this.loadClass + ", getPackage=" + this.getPackage + ", definePackage=" + this.definePackage + '}';
                }
            }
        }
    }
}

