/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.inline;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.generic.GenericTypeDescription;
import net.bytebuddy.description.type.generic.GenericTypeList;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.auxiliary.AuxiliaryType;
import net.bytebuddy.implementation.auxiliary.TrivialType;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.ByteBuddyCommons;

public interface MethodRebaseResolver {
    public static final int REBASED_METHOD_MODIFIER = 4098;

    public Resolution resolve(MethodDescription.InDefinedShape var1);

    public List<DynamicType> getAuxiliaryTypes();

    public static class Enabled
    extends AbstractBase {
        private final DynamicType placeholderType;
        private final MethodNameTransformer methodNameTransformer;

        protected Enabled(Set<? extends MethodDescription> instrumentedMethods, DynamicType placeholderType, MethodNameTransformer methodNameTransformer) {
            super(instrumentedMethods);
            this.placeholderType = placeholderType;
            this.methodNameTransformer = methodNameTransformer;
        }

        public static MethodRebaseResolver make(MethodList<?> instrumentedMethods, TypeDescription instrumentedType, ClassFileVersion classFileVersion, AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy, MethodNameTransformer methodNameTransformer) {
            return ((MethodList)instrumentedMethods.filter(ElementMatchers.isConstructor())).isEmpty() ? MethodsOnly.of(instrumentedMethods, methodNameTransformer) : Enabled.of(instrumentedMethods, TrivialType.INSTANCE.make(auxiliaryTypeNamingStrategy.name(TrivialType.INSTANCE, instrumentedType), classFileVersion, AuxiliaryType.MethodAccessorFactory.Illegal.INSTANCE), methodNameTransformer);
        }

        protected static MethodRebaseResolver of(MethodList<?> instrumentedMethods, DynamicType placeholderType, MethodNameTransformer methodNameTransformer) {
            return new Enabled(new HashSet(instrumentedMethods), placeholderType, methodNameTransformer);
        }

        @Override
        protected Resolution rebase(MethodDescription.InDefinedShape methodDescription) {
            return methodDescription.isConstructor() ? Resolution.ForRebasedConstructor.of(methodDescription, this.placeholderType.getTypeDescription()) : Resolution.ForRebasedMethod.of(methodDescription, this.methodNameTransformer);
        }

        @Override
        public List<DynamicType> getAuxiliaryTypes() {
            return Collections.singletonList(this.placeholderType);
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.placeholderType.equals(((Enabled)other).placeholderType) && this.methodNameTransformer.equals(((Enabled)other).methodNameTransformer);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.placeholderType.hashCode();
            result = 31 * result + this.methodNameTransformer.hashCode();
            return result;
        }

        public String toString() {
            return "MethodRebaseResolver.Enabled{instrumentedMethods=" + this.instrumentedMethods + ", placeholderType=" + this.placeholderType + ", methodNameTransformer=" + this.methodNameTransformer + '}';
        }
    }

    public static class MethodsOnly
    extends AbstractBase {
        private final MethodNameTransformer methodNameTransformer;

        protected MethodsOnly(Set<? extends MethodDescription> instrumentedMethods, MethodNameTransformer methodNameTransformer) {
            super(instrumentedMethods);
            this.methodNameTransformer = methodNameTransformer;
        }

        protected static MethodRebaseResolver of(MethodList<?> instrumentedMethods, MethodNameTransformer methodNameTransformer) {
            return new MethodsOnly(new HashSet(instrumentedMethods), methodNameTransformer);
        }

        @Override
        protected Resolution rebase(MethodDescription.InDefinedShape methodDescription) {
            if (methodDescription.isConstructor()) {
                throw new IllegalArgumentException("Cannot rebase constructor without preparation");
            }
            return Resolution.ForRebasedMethod.of(methodDescription, this.methodNameTransformer);
        }

        @Override
        public List<DynamicType> getAuxiliaryTypes() {
            return Collections.emptyList();
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.methodNameTransformer.equals(((MethodsOnly)other).methodNameTransformer);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.methodNameTransformer.hashCode();
            return result;
        }

        public String toString() {
            return "MethodRebaseResolver.MethodsOnly{instrumentedMethods=" + this.instrumentedMethods + ", methodNameTransformer=" + this.methodNameTransformer + '}';
        }
    }

    public static abstract class AbstractBase
    implements MethodRebaseResolver {
        protected final Set<? extends MethodDescription> instrumentedMethods;

        protected AbstractBase(Set<? extends MethodDescription> instrumentedMethods) {
            this.instrumentedMethods = instrumentedMethods;
        }

        @Override
        public Resolution resolve(MethodDescription.InDefinedShape methodDescription) {
            return this.instrumentedMethods.contains(methodDescription) ? this.rebase(methodDescription) : new Resolution.Preserved(methodDescription);
        }

        protected abstract Resolution rebase(MethodDescription.InDefinedShape var1);

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedMethods.equals(((AbstractBase)other).instrumentedMethods);
        }

        public int hashCode() {
            return this.instrumentedMethods.hashCode();
        }
    }

    public static interface Resolution {
        public boolean isRebased();

        public MethodDescription.InDefinedShape getResolvedMethod();

        public StackManipulation getAdditionalArguments();

        public static class ForRebasedConstructor
        implements Resolution {
            private final MethodDescription.InDefinedShape methodDescription;

            protected ForRebasedConstructor(MethodDescription.InDefinedShape methodDescription) {
                this.methodDescription = methodDescription;
            }

            public static Resolution of(MethodDescription.InDefinedShape methodDescription, TypeDescription placeholderType) {
                return new ForRebasedConstructor(new RebasedConstructor(methodDescription, placeholderType));
            }

            @Override
            public boolean isRebased() {
                return true;
            }

            @Override
            public MethodDescription.InDefinedShape getResolvedMethod() {
                return this.methodDescription;
            }

            @Override
            public StackManipulation getAdditionalArguments() {
                return NullConstant.INSTANCE;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.methodDescription.equals(((ForRebasedConstructor)other).methodDescription);
            }

            public int hashCode() {
                return this.methodDescription.hashCode();
            }

            public String toString() {
                return "MethodRebaseResolver.Resolution.ForRebasedConstructor{methodDescription=" + this.methodDescription + '}';
            }

            protected static class RebasedConstructor
            extends MethodDescription.InDefinedShape.AbstractBase {
                private final MethodDescription.InDefinedShape methodDescription;
                private final TypeDescription placeholderType;

                protected RebasedConstructor(MethodDescription.InDefinedShape methodDescription, TypeDescription placeholderType) {
                    this.methodDescription = methodDescription;
                    this.placeholderType = placeholderType;
                }

                @Override
                public GenericTypeDescription getReturnType() {
                    return TypeDescription.VOID;
                }

                @Override
                public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
                    return new ParameterList.Explicit.ForTypes(this, ByteBuddyCommons.join(this.methodDescription.getParameters().asTypeList().asRawTypes(), this.placeholderType));
                }

                @Override
                public GenericTypeList getExceptionTypes() {
                    return this.methodDescription.getExceptionTypes().asRawTypes().asGenericTypes();
                }

                @Override
                public Object getDefaultValue() {
                    return MethodDescription.NO_DEFAULT_VALUE;
                }

                @Override
                public GenericTypeList getTypeVariables() {
                    return new GenericTypeList.Empty();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return new AnnotationList.Empty();
                }

                @Override
                public TypeDescription getDeclaringType() {
                    return this.methodDescription.getDeclaringType();
                }

                @Override
                public int getModifiers() {
                    return 4098;
                }

                @Override
                public String getInternalName() {
                    return "<init>";
                }
            }
        }

        public static class ForRebasedMethod
        implements Resolution {
            private final MethodDescription.InDefinedShape methodDescription;

            protected ForRebasedMethod(MethodDescription.InDefinedShape methodDescription) {
                this.methodDescription = methodDescription;
            }

            public static Resolution of(MethodDescription.InDefinedShape methodDescription, MethodNameTransformer methodNameTransformer) {
                return new ForRebasedMethod(new RebasedMethod(methodDescription, methodNameTransformer));
            }

            @Override
            public boolean isRebased() {
                return true;
            }

            @Override
            public MethodDescription.InDefinedShape getResolvedMethod() {
                return this.methodDescription;
            }

            @Override
            public StackManipulation getAdditionalArguments() {
                return StackManipulation.LegalTrivial.INSTANCE;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.methodDescription.equals(((ForRebasedMethod)other).methodDescription);
            }

            public int hashCode() {
                return this.methodDescription.hashCode();
            }

            public String toString() {
                return "MethodRebaseResolver.Resolution.ForRebasedMethod{methodDescription=" + this.methodDescription + '}';
            }

            protected static class RebasedMethod
            extends MethodDescription.InDefinedShape.AbstractBase {
                private final MethodDescription.InDefinedShape methodDescription;
                private final MethodNameTransformer methodNameTransformer;

                protected RebasedMethod(MethodDescription.InDefinedShape methodDescription, MethodNameTransformer methodNameTransformer) {
                    this.methodDescription = methodDescription;
                    this.methodNameTransformer = methodNameTransformer;
                }

                @Override
                public GenericTypeDescription getReturnType() {
                    return this.methodDescription.getReturnType().asRawType();
                }

                @Override
                public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
                    return new ParameterList.Explicit.ForTypes(this, this.methodDescription.getParameters().asTypeList().asRawTypes());
                }

                @Override
                public GenericTypeList getExceptionTypes() {
                    return this.methodDescription.getExceptionTypes().asRawTypes().asGenericTypes();
                }

                @Override
                public Object getDefaultValue() {
                    return MethodDescription.NO_DEFAULT_VALUE;
                }

                @Override
                public GenericTypeList getTypeVariables() {
                    return new GenericTypeList.Empty();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return new AnnotationList.Empty();
                }

                @Override
                public TypeDescription getDeclaringType() {
                    return this.methodDescription.getDeclaringType();
                }

                @Override
                public int getModifiers() {
                    return 0x1002 | (this.methodDescription.isStatic() ? 8 : 0) | (this.methodDescription.isNative() ? 256 : 0);
                }

                @Override
                public String getInternalName() {
                    return this.methodNameTransformer.transform(this.methodDescription);
                }
            }
        }

        public static class Preserved
        implements Resolution {
            private final MethodDescription.InDefinedShape methodDescription;

            public Preserved(MethodDescription.InDefinedShape methodDescription) {
                this.methodDescription = methodDescription;
            }

            @Override
            public boolean isRebased() {
                return false;
            }

            @Override
            public MethodDescription.InDefinedShape getResolvedMethod() {
                return this.methodDescription;
            }

            @Override
            public StackManipulation getAdditionalArguments() {
                return StackManipulation.LegalTrivial.INSTANCE;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.methodDescription.equals(((Preserved)other).methodDescription);
            }

            public int hashCode() {
                return this.methodDescription.hashCode();
            }

            public String toString() {
                return "MethodRebaseResolver.Resolution.Preserved{methodDescription=" + this.methodDescription + '}';
            }
        }
    }

    public static interface MethodNameTransformer {
        public String transform(MethodDescription var1);

        public static class Prefixing
        implements MethodNameTransformer {
            private static final String DEFAULT_PREFIX = "original";
            private final String prefix;

            public Prefixing() {
                this(DEFAULT_PREFIX);
            }

            public Prefixing(String prefix) {
                this.prefix = prefix;
            }

            @Override
            public String transform(MethodDescription methodDescription) {
                return String.format("%s%s", this.prefix, methodDescription.getInternalName());
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.prefix.equals(((Prefixing)other).prefix);
            }

            public int hashCode() {
                return this.prefix.hashCode();
            }

            public String toString() {
                return "MethodRebaseResolver.MethodNameTransformer.Prefixing{prefix='" + this.prefix + '\'' + '}';
            }
        }

        public static class Suffixing
        implements MethodNameTransformer {
            private static final String DEFAULT_SUFFIX = "original";
            private final String suffix;

            public Suffixing() {
                this(DEFAULT_SUFFIX);
            }

            public Suffixing(String suffix) {
                this.suffix = suffix;
            }

            @Override
            public String transform(MethodDescription methodDescription) {
                return String.format("%s$%s", methodDescription.getInternalName(), this.suffix);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.suffix.equals(((Suffixing)other).suffix);
            }

            public int hashCode() {
                return this.suffix.hashCode();
            }

            public String toString() {
                return "MethodRebaseResolver.MethodNameTransformer.Suffixing{suffix='" + this.suffix + '\'' + '}';
            }
        }
    }

    public static enum Disabled implements MethodRebaseResolver
    {
        INSTANCE;


        @Override
        public Resolution resolve(MethodDescription.InDefinedShape methodDescription) {
            return new Resolution.Preserved(methodDescription);
        }

        @Override
        public List<DynamicType> getAuxiliaryTypes() {
            return Collections.emptyList();
        }

        public String toString() {
            return "MethodRebaseResolver.Disabled." + this.name();
        }
    }
}

