/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.constant.MethodConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.ByteBuddyCommons;

public abstract class InvocationHandlerAdapter
implements Implementation {
    private static final boolean NO_CACHING = false;
    private static final String PREFIX = "invocationHandler";
    private static final TypeDescription INVOCATION_HANDLER_TYPE = new TypeDescription.ForLoadedType(InvocationHandler.class);
    protected final String fieldName;
    protected final Assigner assigner;
    protected final boolean cacheMethods;

    protected InvocationHandlerAdapter(String fieldName, boolean cacheMethods, Assigner assigner) {
        this.fieldName = fieldName;
        this.cacheMethods = cacheMethods;
        this.assigner = assigner;
    }

    public static InvocationHandlerAdapter of(InvocationHandler invocationHandler) {
        return InvocationHandlerAdapter.of(invocationHandler, String.format("%s$%d", PREFIX, Math.abs(invocationHandler.hashCode())));
    }

    public static InvocationHandlerAdapter of(InvocationHandler invocationHandler, String fieldName) {
        return new ForStaticDelegation(ByteBuddyCommons.isValidIdentifier(fieldName), false, Assigner.DEFAULT, ByteBuddyCommons.nonNull(invocationHandler));
    }

    public static InvocationHandlerAdapter toInstanceField(String fieldName) {
        return new ForInstanceDelegation(ByteBuddyCommons.isValidIdentifier(fieldName), false, Assigner.DEFAULT);
    }

    private List<StackManipulation> argumentValuesOf(MethodDescription instrumentedMethod) {
        TypeList parameterTypes = instrumentedMethod.getParameters().asTypeList().asRawTypes();
        ArrayList<StackManipulation> instruction = new ArrayList<StackManipulation>(parameterTypes.size());
        TypeDescription objectType = TypeDescription.OBJECT;
        int currentIndex = 1;
        for (TypeDescription parameterType : parameterTypes) {
            instruction.add(new StackManipulation.Compound(MethodVariableAccess.forType(parameterType).loadOffset(currentIndex), this.assigner.assign(parameterType, objectType, Assigner.Typing.STATIC)));
            currentIndex += parameterType.getStackSize().getSize();
        }
        return instruction;
    }

    public abstract AssignerConfigurable withMethodCache();

    protected ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod, TypeDescription instrumentedType, StackManipulation preparingManipulation) {
        StackManipulation.Size stackSize = new StackManipulation.Compound(preparingManipulation, FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName))).getOnly()).getter(), MethodVariableAccess.forType(TypeDescription.OBJECT).loadOffset(0), this.cacheMethods ? MethodConstant.forMethod((MethodDescription.InDefinedShape)instrumentedMethod.asDefined()).cached() : MethodConstant.forMethod((MethodDescription.InDefinedShape)instrumentedMethod.asDefined()), ArrayFactory.forType(TypeDescription.OBJECT).withValues(this.argumentValuesOf(instrumentedMethod)), MethodInvocation.invoke((MethodDescription.InDefinedShape)INVOCATION_HANDLER_TYPE.getDeclaredMethods().getOnly()), this.assigner.assign(TypeDescription.OBJECT, instrumentedMethod.getReturnType().asRawType(), Assigner.Typing.DYNAMIC), MethodReturn.returning(instrumentedMethod.getReturnType().asRawType())).apply(methodVisitor, implementationContext);
        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        InvocationHandlerAdapter that = (InvocationHandlerAdapter)other;
        return this.cacheMethods == that.cacheMethods && this.assigner.equals(that.assigner) && this.fieldName.equals(that.fieldName);
    }

    public int hashCode() {
        int result = this.fieldName.hashCode();
        result = 31 * result + this.assigner.hashCode();
        result = 31 * result + (this.cacheMethods ? 1 : 0);
        return result;
    }

    protected static class ForInstanceDelegation
    extends InvocationHandlerAdapter
    implements AssignerConfigurable {
        protected ForInstanceDelegation(String fieldName, boolean cacheMethods, Assigner assigner) {
            super(fieldName, cacheMethods, assigner);
        }

        @Override
        public AssignerConfigurable withMethodCache() {
            return new ForInstanceDelegation(this.fieldName, true, this.assigner);
        }

        @Override
        public Implementation withAssigner(Assigner assigner) {
            return new ForInstanceDelegation(this.fieldName, this.cacheMethods, ByteBuddyCommons.nonNull(assigner));
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(new FieldDescription.Token(this.fieldName, 1, INVOCATION_HANDLER_TYPE));
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(implementationTarget.getTypeDescription());
        }

        public String toString() {
            return "InvocationHandlerAdapter.ForInstanceDelegation{fieldName=" + this.fieldName + "cacheMethods=" + this.cacheMethods + '}';
        }

        protected class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            protected Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                return ForInstanceDelegation.this.apply(methodVisitor, implementationContext, instrumentedMethod, this.instrumentedType, MethodVariableAccess.forType(this.instrumentedType).loadOffset(0));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && ForInstanceDelegation.this.equals(((Appender)other).getInvocationHandlerAdapter());
            }

            private InvocationHandlerAdapter getInvocationHandlerAdapter() {
                return ForInstanceDelegation.this;
            }

            public int hashCode() {
                return 31 * ForInstanceDelegation.this.hashCode() + this.instrumentedType.hashCode();
            }

            public String toString() {
                return "InvocationHandlerAdapter.ForInstanceDelegation.Appender{invocationHandlerAdapter=" + ForInstanceDelegation.this + "instrumentedType=" + this.instrumentedType + '}';
            }
        }
    }

    protected static class ForStaticDelegation
    extends InvocationHandlerAdapter
    implements AssignerConfigurable {
        protected final InvocationHandler invocationHandler;

        protected ForStaticDelegation(String fieldName, boolean cacheMethods, Assigner assigner, InvocationHandler invocationHandler) {
            super(fieldName, cacheMethods, assigner);
            this.invocationHandler = invocationHandler;
        }

        @Override
        public AssignerConfigurable withMethodCache() {
            return new ForStaticDelegation(this.fieldName, true, this.assigner, this.invocationHandler);
        }

        @Override
        public Implementation withAssigner(Assigner assigner) {
            return new ForStaticDelegation(this.fieldName, this.cacheMethods, ByteBuddyCommons.nonNull(assigner), this.invocationHandler);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(new FieldDescription.Token(this.fieldName, 8, INVOCATION_HANDLER_TYPE)).withInitializer(LoadedTypeInitializer.ForStaticField.nonAccessible(this.fieldName, this.invocationHandler));
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(implementationTarget.getTypeDescription());
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.invocationHandler.equals(((ForStaticDelegation)other).invocationHandler);
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + this.invocationHandler.hashCode();
        }

        public String toString() {
            return "InvocationHandlerAdapter.ForStaticDelegation{fieldName=" + this.fieldName + ", cacheMethods=" + this.cacheMethods + ", invocationHandler=" + this.invocationHandler + '}';
        }

        protected class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            protected Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                return ForStaticDelegation.this.apply(methodVisitor, implementationContext, instrumentedMethod, this.instrumentedType, StackManipulation.LegalTrivial.INSTANCE);
            }

            private InvocationHandlerAdapter getInvocationHandlerAdapter() {
                return ForStaticDelegation.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && ForStaticDelegation.this.equals(((Appender)other).getInvocationHandlerAdapter());
            }

            public int hashCode() {
                return 31 * ForStaticDelegation.this.hashCode() + this.instrumentedType.hashCode();
            }

            public String toString() {
                return "InvocationHandlerAdapter.ForStaticDelegation.Appender{invocationHandlerAdapter=" + ForStaticDelegation.this + "instrumentedType=" + this.instrumentedType + '}';
            }
        }
    }

    protected static interface AssignerConfigurable
    extends Implementation {
        public Implementation withAssigner(Assigner var1);
    }
}

