/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.bind.MethodDelegationBinder;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.ByteBuddyCommons;

public class MethodDelegation
implements Implementation {
    private static final String NO_METHODS_ERROR_MESSAGE = "The target type does not define any methods for delegation";
    private final ImplementationDelegate implementationDelegate;
    private final List<TargetMethodAnnotationDrivenBinder.ParameterBinder<?>> parameterBinders;
    private final TargetMethodAnnotationDrivenBinder.DefaultsProvider defaultsProvider;
    private final TargetMethodAnnotationDrivenBinder.TerminationHandler terminationHandler;
    private final MethodDelegationBinder.AmbiguityResolver ambiguityResolver;
    private final Assigner assigner;
    private final MethodList<?> targetCandidates;

    protected MethodDelegation(ImplementationDelegate implementationDelegate, List<TargetMethodAnnotationDrivenBinder.ParameterBinder<?>> parameterBinders, TargetMethodAnnotationDrivenBinder.DefaultsProvider defaultsProvider, TargetMethodAnnotationDrivenBinder.TerminationHandler terminationHandler, MethodDelegationBinder.AmbiguityResolver ambiguityResolver, Assigner assigner, MethodList<?> targetCandidates) {
        this.implementationDelegate = implementationDelegate;
        this.parameterBinders = parameterBinders;
        this.defaultsProvider = defaultsProvider;
        this.terminationHandler = terminationHandler;
        this.ambiguityResolver = ambiguityResolver;
        this.assigner = assigner;
        this.targetCandidates = ByteBuddyCommons.isNotEmpty(targetCandidates, NO_METHODS_ERROR_MESSAGE);
    }

    public static MethodDelegation to(Class<?> type) {
        return MethodDelegation.to(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
    }

    public static MethodDelegation to(TypeDescription typeDescription) {
        if (typeDescription.isArray()) {
            throw new IllegalArgumentException("Cannot delegate to array " + typeDescription);
        }
        if (typeDescription.isPrimitive()) {
            throw new IllegalArgumentException("Cannot delegate to primitive " + typeDescription);
        }
        return new MethodDelegation(ImplementationDelegate.ForStaticMethod.INSTANCE, TargetMethodAnnotationDrivenBinder.ParameterBinder.DEFAULTS, Argument.NextUnboundAsDefaultsProvider.INSTANCE, TargetMethodAnnotationDrivenBinder.TerminationHandler.Returning.INSTANCE, MethodDelegationBinder.AmbiguityResolver.DEFAULT, Assigner.DEFAULT, (MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.isStatic().and(ElementMatchers.not(ElementMatchers.isPrivate()))));
    }

    public static MethodDelegation to(Object delegate) {
        return MethodDelegation.to(ByteBuddyCommons.nonNull(delegate), MethodGraph.Compiler.DEFAULT);
    }

    public static MethodDelegation to(Object delegate, MethodGraph.Compiler methodGraphCompiler) {
        return new MethodDelegation(new ImplementationDelegate.ForStaticField(ByteBuddyCommons.nonNull(delegate)), TargetMethodAnnotationDrivenBinder.ParameterBinder.DEFAULTS, Argument.NextUnboundAsDefaultsProvider.INSTANCE, TargetMethodAnnotationDrivenBinder.TerminationHandler.Returning.INSTANCE, MethodDelegationBinder.AmbiguityResolver.DEFAULT, Assigner.DEFAULT, (MethodList)methodGraphCompiler.compile(new TypeDescription.ForLoadedType(delegate.getClass())).listNodes().asMethodList().filter(ElementMatchers.not(ElementMatchers.isStatic().or(ElementMatchers.isPrivate()).or(ElementMatchers.isConstructor()))));
    }

    public static MethodDelegation to(Object delegate, String fieldName) {
        return MethodDelegation.to(delegate, fieldName, MethodGraph.Compiler.DEFAULT);
    }

    public static MethodDelegation to(Object delegate, String fieldName, MethodGraph.Compiler methodGraphCompiler) {
        return new MethodDelegation(new ImplementationDelegate.ForStaticField(ByteBuddyCommons.nonNull(delegate), ByteBuddyCommons.isValidIdentifier(fieldName)), TargetMethodAnnotationDrivenBinder.ParameterBinder.DEFAULTS, Argument.NextUnboundAsDefaultsProvider.INSTANCE, TargetMethodAnnotationDrivenBinder.TerminationHandler.Returning.INSTANCE, MethodDelegationBinder.AmbiguityResolver.DEFAULT, Assigner.DEFAULT, (MethodList)methodGraphCompiler.compile(new TypeDescription.ForLoadedType(delegate.getClass())).listNodes().asMethodList().filter(ElementMatchers.not(ElementMatchers.isStatic().or(ElementMatchers.isPrivate()).or(ElementMatchers.isConstructor()))));
    }

    public static MethodDelegation toInstanceField(Class<?> type, String fieldName) {
        return MethodDelegation.toInstanceField(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)), fieldName);
    }

    public static MethodDelegation toInstanceField(TypeDescription typeDescription, String fieldName) {
        return MethodDelegation.toInstanceField(ByteBuddyCommons.nonNull(typeDescription), ByteBuddyCommons.isValidIdentifier(fieldName), MethodGraph.Compiler.DEFAULT);
    }

    public static MethodDelegation toInstanceField(Class<?> type, String fieldName, MethodGraph.Compiler methodGraphCompiler) {
        return MethodDelegation.toInstanceField(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)), fieldName, methodGraphCompiler);
    }

    public static MethodDelegation toInstanceField(TypeDescription typeDescription, String fieldName, MethodGraph.Compiler methodGraphCompiler) {
        return new MethodDelegation(new ImplementationDelegate.ForInstanceField(ByteBuddyCommons.nonNull(typeDescription), ByteBuddyCommons.isValidIdentifier(fieldName)), TargetMethodAnnotationDrivenBinder.ParameterBinder.DEFAULTS, Argument.NextUnboundAsDefaultsProvider.INSTANCE, TargetMethodAnnotationDrivenBinder.TerminationHandler.Returning.INSTANCE, MethodDelegationBinder.AmbiguityResolver.DEFAULT, Assigner.DEFAULT, (MethodList)methodGraphCompiler.compile(typeDescription).listNodes().asMethodList().filter(ElementMatchers.isVirtual()));
    }

    public static MethodDelegation toConstructor(Class<?> type) {
        return MethodDelegation.toConstructor(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
    }

    public static MethodDelegation toConstructor(TypeDescription typeDescription) {
        return new MethodDelegation(new ImplementationDelegate.ForConstruction(ByteBuddyCommons.nonNull(typeDescription)), TargetMethodAnnotationDrivenBinder.ParameterBinder.DEFAULTS, Argument.NextUnboundAsDefaultsProvider.INSTANCE, TargetMethodAnnotationDrivenBinder.TerminationHandler.Returning.INSTANCE, MethodDelegationBinder.AmbiguityResolver.DEFAULT, Assigner.DEFAULT, (MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.isConstructor()));
    }

    public MethodDelegation appendParameterBinder(TargetMethodAnnotationDrivenBinder.ParameterBinder<?> parameterBinder) {
        return new MethodDelegation(this.implementationDelegate, ByteBuddyCommons.join(this.parameterBinders, ByteBuddyCommons.nonNull(parameterBinder)), this.defaultsProvider, this.terminationHandler, this.ambiguityResolver, this.assigner, this.targetCandidates);
    }

    public MethodDelegation defineParameterBinder(TargetMethodAnnotationDrivenBinder.ParameterBinder<?> ... parameterBinder) {
        return new MethodDelegation(this.implementationDelegate, Arrays.asList(ByteBuddyCommons.nonNull(parameterBinder)), this.defaultsProvider, this.terminationHandler, this.ambiguityResolver, this.assigner, this.targetCandidates);
    }

    public MethodDelegation withDefaultsProvider(TargetMethodAnnotationDrivenBinder.DefaultsProvider defaultsProvider) {
        return new MethodDelegation(this.implementationDelegate, this.parameterBinders, ByteBuddyCommons.nonNull(defaultsProvider), this.terminationHandler, this.ambiguityResolver, this.assigner, this.targetCandidates);
    }

    public MethodDelegation appendAmbiguityResolver(MethodDelegationBinder.AmbiguityResolver ambiguityResolver) {
        return this.defineAmbiguityResolver(new MethodDelegationBinder.AmbiguityResolver.Chain(this.ambiguityResolver, ByteBuddyCommons.nonNull(ambiguityResolver)));
    }

    public MethodDelegation defineAmbiguityResolver(MethodDelegationBinder.AmbiguityResolver ... ambiguityResolver) {
        return new MethodDelegation(this.implementationDelegate, this.parameterBinders, this.defaultsProvider, this.terminationHandler, new MethodDelegationBinder.AmbiguityResolver.Chain(ByteBuddyCommons.nonNull(ambiguityResolver)), this.assigner, this.targetCandidates);
    }

    public MethodDelegation withAssigner(Assigner assigner) {
        return new MethodDelegation(this.implementationDelegate, this.parameterBinders, this.defaultsProvider, this.terminationHandler, this.ambiguityResolver, ByteBuddyCommons.nonNull(assigner), this.targetCandidates);
    }

    public MethodDelegation filter(ElementMatcher<? super MethodDescription> methodMatcher) {
        return new MethodDelegation(this.implementationDelegate, this.parameterBinders, this.defaultsProvider, this.terminationHandler, this.ambiguityResolver, this.assigner, (MethodList)ByteBuddyCommons.isNotEmpty(this.targetCandidates.filter(ByteBuddyCommons.nonNull(methodMatcher)), NO_METHODS_ERROR_MESSAGE));
    }

    public Implementation andThen(Implementation implementation) {
        return new Implementation.Compound(new MethodDelegation(this.implementationDelegate, this.parameterBinders, this.defaultsProvider, TargetMethodAnnotationDrivenBinder.TerminationHandler.Dropping.INSTANCE, this.ambiguityResolver, this.assigner, this.targetCandidates), ByteBuddyCommons.nonNull(implementation));
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return this.implementationDelegate.prepare(instrumentedType);
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new Appender(this.implementationDelegate.getPreparingStackAssignment(implementationTarget.getTypeDescription()), implementationTarget, this.targetCandidates, new MethodDelegationBinder.Processor(new TargetMethodAnnotationDrivenBinder(this.parameterBinders, this.defaultsProvider, this.terminationHandler, this.assigner, this.implementationDelegate.getMethodInvoker(implementationTarget.getTypeDescription())), this.ambiguityResolver));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MethodDelegation that = (MethodDelegation)other;
        return this.ambiguityResolver.equals(that.ambiguityResolver) && this.assigner.equals(that.assigner) && this.defaultsProvider.equals(that.defaultsProvider) && this.terminationHandler.equals(that.terminationHandler) && this.implementationDelegate.equals(that.implementationDelegate) && this.targetCandidates.equals(that.targetCandidates) && this.parameterBinders.equals(that.parameterBinders);
    }

    public int hashCode() {
        int result = this.implementationDelegate.hashCode();
        result = 31 * result + this.parameterBinders.hashCode();
        result = 31 * result + this.defaultsProvider.hashCode();
        result = 31 * result + this.terminationHandler.hashCode();
        result = 31 * result + this.ambiguityResolver.hashCode();
        result = 31 * result + this.assigner.hashCode();
        result = 31 * result + this.targetCandidates.hashCode();
        return result;
    }

    public String toString() {
        return "MethodDelegation{implementationDelegate=" + this.implementationDelegate + ", parameterBinders=" + this.parameterBinders + ", defaultsProvider=" + this.defaultsProvider + ", terminationHandler=" + this.terminationHandler + ", ambiguityResolver=" + this.ambiguityResolver + ", assigner=" + this.assigner + ", targetCandidates=" + this.targetCandidates + '}';
    }

    protected static class Appender
    implements ByteCodeAppender {
        private final StackManipulation preparingStackAssignment;
        private final Implementation.Target implementationTarget;
        private final MethodList targetCandidates;
        private final MethodDelegationBinder.Processor processor;

        protected Appender(StackManipulation preparingStackAssignment, Implementation.Target implementationTarget, MethodList targetCandidates, MethodDelegationBinder.Processor processor) {
            this.preparingStackAssignment = preparingStackAssignment;
            this.implementationTarget = implementationTarget;
            this.targetCandidates = targetCandidates;
            this.processor = processor;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            StackManipulation.Size stackSize = new StackManipulation.Compound(this.preparingStackAssignment, this.processor.process(this.implementationTarget, instrumentedMethod, this.targetCandidates)).apply(methodVisitor, implementationContext);
            return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Appender that = (Appender)other;
            return this.implementationTarget.equals(that.implementationTarget) && this.preparingStackAssignment.equals(that.preparingStackAssignment) && this.processor.equals(that.processor) && this.targetCandidates.equals(that.targetCandidates);
        }

        public int hashCode() {
            int result = this.preparingStackAssignment.hashCode();
            result = 31 * result + this.implementationTarget.hashCode();
            result = 31 * result + this.targetCandidates.hashCode();
            result = 31 * result + this.processor.hashCode();
            return result;
        }

        public String toString() {
            return "MethodDelegation.Appender{preparingStackAssignment=" + this.preparingStackAssignment + ", implementationTarget=" + this.implementationTarget + ", targetCandidates=" + this.targetCandidates + ", processor=" + this.processor + '}';
        }
    }

    protected static interface ImplementationDelegate {
        public InstrumentedType prepare(InstrumentedType var1);

        public StackManipulation getPreparingStackAssignment(TypeDescription var1);

        public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription var1);

        public static class ForConstruction
        implements ImplementationDelegate {
            private final TypeDescription typeDescription;

            public ForConstruction(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public StackManipulation getPreparingStackAssignment(TypeDescription instrumentedType) {
                return new StackManipulation.Compound(TypeCreation.forType(this.typeDescription), Duplication.SINGLE);
            }

            @Override
            public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription instrumentedType) {
                return MethodDelegationBinder.MethodInvoker.Simple.INSTANCE;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((ForConstruction)other).typeDescription);
            }

            public int hashCode() {
                return this.typeDescription.hashCode();
            }

            public String toString() {
                return "MethodDelegation.ImplementationDelegate.ForConstruction{typeDescription=" + this.typeDescription + '}';
            }
        }

        public static class ForInstanceField
        implements ImplementationDelegate {
            private final String fieldName;
            private final TypeDescription fieldType;

            public ForInstanceField(TypeDescription fieldType, String fieldName) {
                this.fieldType = fieldType;
                this.fieldName = fieldName;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withField(new FieldDescription.Token(this.fieldName, 1, this.fieldType));
            }

            @Override
            public StackManipulation getPreparingStackAssignment(TypeDescription instrumentedType) {
                return new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadOffset(0), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName))).getOnly()).getter());
            }

            @Override
            public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription instrumentedType) {
                return new MethodDelegationBinder.MethodInvoker.Virtual(this.fieldType);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.fieldName.equals(((ForInstanceField)other).fieldName) && this.fieldType.equals(((ForInstanceField)other).fieldType);
            }

            public int hashCode() {
                return 31 * this.fieldName.hashCode() + this.fieldType.hashCode();
            }

            public String toString() {
                return "MethodDelegation.ImplementationDelegate.ForInstanceField{fieldName='" + this.fieldName + '\'' + ", fieldType=" + this.fieldType + '}';
            }
        }

        public static class ForStaticField
        implements ImplementationDelegate {
            private static final int FIELD_MODIFIERS = 4106;
            private static final String PREFIX = "methodDelegate";
            private final String fieldName;
            private final Object delegate;

            public ForStaticField(Object delegate) {
                this(delegate, String.format("%s$%d", PREFIX, delegate.hashCode()));
            }

            public ForStaticField(Object delegate, String fieldName) {
                this.delegate = delegate;
                this.fieldName = fieldName;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withField(new FieldDescription.Token(this.fieldName, 4106, new TypeDescription.ForLoadedType(this.delegate.getClass()))).withInitializer(LoadedTypeInitializer.ForStaticField.nonAccessible(this.fieldName, this.delegate));
            }

            @Override
            public StackManipulation getPreparingStackAssignment(TypeDescription instrumentedType) {
                return FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName))).getOnly()).getter();
            }

            @Override
            public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription instrumentedType) {
                return new MethodDelegationBinder.MethodInvoker.Virtual(new TypeDescription.ForLoadedType(this.delegate.getClass()));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.delegate.equals(((ForStaticField)other).delegate) && this.fieldName.equals(((ForStaticField)other).fieldName);
            }

            public int hashCode() {
                return 31 * this.fieldName.hashCode() + this.delegate.hashCode();
            }

            public String toString() {
                return "MethodDelegation.ImplementationDelegate.ForStaticField{fieldName='" + this.fieldName + '\'' + ", delegate=" + this.delegate + '}';
            }
        }

        public static enum ForStaticMethod implements ImplementationDelegate
        {
            INSTANCE;


            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public StackManipulation getPreparingStackAssignment(TypeDescription instrumentedType) {
                return StackManipulation.LegalTrivial.INSTANCE;
            }

            @Override
            public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription instrumentedType) {
                return MethodDelegationBinder.MethodInvoker.Simple.INSTANCE;
            }

            public String toString() {
                return "MethodDelegation.ImplementationDelegate.ForStaticMethod." + this.name();
            }
        }
    }
}

