/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.attribute;

import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.generic.GenericTypeDescription;
import net.bytebuddy.implementation.attribute.AnnotationAppender;
import net.bytebuddy.jar.asm.ClassVisitor;

public interface TypeAttributeAppender {
    public void apply(ClassVisitor var1, TypeDescription var2, GenericTypeDescription var3);

    public static class Compound
    implements TypeAttributeAppender {
        private final TypeAttributeAppender[] typeAttributeAppender;

        public Compound(TypeAttributeAppender ... typeAttributeAppender) {
            this.typeAttributeAppender = typeAttributeAppender;
        }

        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, GenericTypeDescription targetType) {
            for (TypeAttributeAppender typeAttributeAppender : this.typeAttributeAppender) {
                typeAttributeAppender.apply(classVisitor, instrumentedType, targetType);
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.typeAttributeAppender, ((Compound)other).typeAttributeAppender);
        }

        public int hashCode() {
            return Arrays.hashCode(this.typeAttributeAppender);
        }

        public String toString() {
            return "TypeAttributeAppender.Compound{typeAttributeAppender=" + Arrays.toString(this.typeAttributeAppender) + '}';
        }
    }

    public static class ForAnnotation
    implements TypeAttributeAppender {
        private final List<? extends AnnotationDescription> annotations;
        private final AnnotationAppender.ValueFilter valueFilter;

        public ForAnnotation(List<? extends AnnotationDescription> annotations, AnnotationAppender.ValueFilter valueFilter) {
            this.annotations = annotations;
            this.valueFilter = valueFilter;
        }

        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, GenericTypeDescription targetType) {
            AnnotationAppender.Default annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnType(classVisitor), this.valueFilter);
            for (AnnotationDescription annotationDescription : this.annotations) {
                annotationAppender.append(annotationDescription, AnnotationAppender.AnnotationVisibility.of(annotationDescription));
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.annotations.equals(((ForAnnotation)other).annotations) && this.valueFilter.equals(((ForAnnotation)other).valueFilter);
        }

        public int hashCode() {
            return this.annotations.hashCode() + 31 * this.valueFilter.hashCode();
        }

        public String toString() {
            return "TypeAttributeAppender.ForAnnotation{annotations=" + this.annotations + ", valueFilter=" + this.valueFilter + '}';
        }
    }

    public static class ForType
    implements TypeAttributeAppender {
        private final TypeDescription typeDescription;
        private final AnnotationAppender.ValueFilter valueFilter;

        public ForType(Class<?> type, AnnotationAppender.ValueFilter valueFilter) {
            this(new TypeDescription.ForLoadedType(type), valueFilter);
        }

        public ForType(TypeDescription typeDescription, AnnotationAppender.ValueFilter valueFilter) {
            this.typeDescription = typeDescription;
            this.valueFilter = valueFilter;
        }

        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, GenericTypeDescription targetType) {
            AnnotationAppender.Default annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnType(classVisitor), this.valueFilter);
            for (AnnotationDescription annotation : this.typeDescription.getDeclaredAnnotations()) {
                annotationAppender.append(annotation, AnnotationAppender.AnnotationVisibility.of(annotation));
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((ForType)other).typeDescription) && this.valueFilter.equals(((ForType)other).valueFilter);
        }

        public int hashCode() {
            return this.typeDescription.hashCode() + 31 * this.valueFilter.hashCode();
        }

        public String toString() {
            return "TypeAttributeAppender.ForType{typeDescription=" + this.typeDescription + ", valueFilter=" + this.valueFilter + '}';
        }
    }

    public static class ForInstrumentedType
    implements TypeAttributeAppender {
        private final AnnotationAppender.ValueFilter valueFilter;

        public ForInstrumentedType(AnnotationAppender.ValueFilter valueFilter) {
            this.valueFilter = valueFilter;
        }

        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, GenericTypeDescription targetType) {
            if (!instrumentedType.getSuperType().equals(targetType)) {
                return;
            }
            AnnotationAppender.Default annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnType(classVisitor), this.valueFilter);
            for (AnnotationDescription annotation : targetType.asRawType().getDeclaredAnnotations()) {
                annotationAppender.append(annotation, AnnotationAppender.AnnotationVisibility.of(annotation));
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.valueFilter.equals(((ForInstrumentedType)other).valueFilter);
        }

        public int hashCode() {
            return this.valueFilter.hashCode();
        }

        public String toString() {
            return "TypeAttributeAppender.ForInstrumentedType{valueFilter=" + this.valueFilter + "}";
        }
    }

    public static enum NoOp implements TypeAttributeAppender
    {
        INSTANCE;


        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, GenericTypeDescription targetType) {
        }

        public String toString() {
            return "TypeAttributeAppender.NoOp." + this.name();
        }
    }
}

