/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bind.annotation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bind.MethodDelegationBinder;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.Default;
import net.bytebuddy.implementation.bind.annotation.DefaultCall;
import net.bytebuddy.implementation.bind.annotation.Empty;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.implementation.bind.annotation.IgnoreForBinding;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.StubValue;
import net.bytebuddy.implementation.bind.annotation.Super;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;

public class TargetMethodAnnotationDrivenBinder
implements MethodDelegationBinder {
    private final DelegationProcessor delegationProcessor;
    private final DefaultsProvider defaultsProvider;
    private final TerminationHandler terminationHandler;
    private final Assigner assigner;
    private final MethodDelegationBinder.MethodInvoker methodInvoker;

    public TargetMethodAnnotationDrivenBinder(List<ParameterBinder<?>> parameterBinders, DefaultsProvider defaultsProvider, TerminationHandler terminationHandler, Assigner assigner, MethodDelegationBinder.MethodInvoker methodInvoker) {
        this.delegationProcessor = DelegationProcessor.of(parameterBinders);
        this.defaultsProvider = defaultsProvider;
        this.terminationHandler = terminationHandler;
        this.assigner = assigner;
        this.methodInvoker = methodInvoker;
    }

    @Override
    public MethodDelegationBinder.MethodBinding bind(Implementation.Target implementationTarget, MethodDescription source, MethodDescription target) {
        if (IgnoreForBinding.Verifier.check(target)) {
            return MethodDelegationBinder.MethodBinding.Illegal.INSTANCE;
        }
        StackManipulation methodTermination = this.terminationHandler.resolve(this.assigner, source, target);
        if (!methodTermination.isValid()) {
            return MethodDelegationBinder.MethodBinding.Illegal.INSTANCE;
        }
        MethodDelegationBinder.MethodBinding.Builder methodDelegationBindingBuilder = new MethodDelegationBinder.MethodBinding.Builder(this.methodInvoker, target);
        Iterator<AnnotationDescription> defaults = this.defaultsProvider.makeIterator(implementationTarget, source, target);
        for (ParameterDescription parameterDescription : target.getParameters()) {
            MethodDelegationBinder.ParameterBinding<?> parameterBinding = this.delegationProcessor.handler(parameterDescription.getDeclaredAnnotations(), defaults).bind(source, parameterDescription, implementationTarget, this.assigner);
            if (parameterBinding.isValid() && methodDelegationBindingBuilder.append(parameterBinding)) continue;
            return MethodDelegationBinder.MethodBinding.Illegal.INSTANCE;
        }
        return methodDelegationBindingBuilder.build(methodTermination);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TargetMethodAnnotationDrivenBinder that = (TargetMethodAnnotationDrivenBinder)other;
        return this.assigner.equals(that.assigner) && this.defaultsProvider.equals(that.defaultsProvider) && this.terminationHandler.equals(that.terminationHandler) && this.delegationProcessor.equals(that.delegationProcessor) && this.methodInvoker.equals(that.methodInvoker);
    }

    public int hashCode() {
        int result = this.delegationProcessor.hashCode();
        result = 31 * result + this.defaultsProvider.hashCode();
        result = 31 * result + this.terminationHandler.hashCode();
        result = 31 * result + this.assigner.hashCode();
        result = 31 * result + this.methodInvoker.hashCode();
        return result;
    }

    public String toString() {
        return "TargetMethodAnnotationDrivenBinder{delegationProcessor=" + this.delegationProcessor + ", defaultsProvider=" + this.defaultsProvider + ", terminationHandler=" + this.terminationHandler + ", assigner=" + this.assigner + ", methodInvoker=" + this.methodInvoker + '}';
    }

    protected static class DelegationProcessor {
        private final Map<TypeDescription, ParameterBinder<?>> parameterBinders;

        protected DelegationProcessor(Map<TypeDescription, ParameterBinder<?>> parameterBinders) {
            this.parameterBinders = parameterBinders;
        }

        protected static DelegationProcessor of(List<ParameterBinder<?>> parameterBinders) {
            HashMap parameterBinderMap = new HashMap();
            for (ParameterBinder<?> parameterBinder : parameterBinders) {
                if (parameterBinderMap.put(new TypeDescription.ForLoadedType(parameterBinder.getHandledType()), parameterBinder) == null) continue;
                throw new IllegalArgumentException("Attempt to bind two handlers to " + parameterBinder.getHandledType());
            }
            return new DelegationProcessor(parameterBinderMap);
        }

        private Handler handler(List<AnnotationDescription> annotations, Iterator<AnnotationDescription> defaults) {
            Handler handler = null;
            for (AnnotationDescription annotation : annotations) {
                ParameterBinder<?> parameterBinder = this.parameterBinders.get(annotation.getAnnotationType());
                if (parameterBinder != null && handler != null) {
                    throw new IllegalStateException("Ambiguous binding for parameter annotated with two handled annotation types");
                }
                if (parameterBinder == null) continue;
                handler = this.makeHandler(parameterBinder, annotation);
            }
            if (handler == null) {
                if (defaults.hasNext()) {
                    AnnotationDescription defaultAnnotation = defaults.next();
                    ParameterBinder<?> parameterBinder = this.parameterBinders.get(defaultAnnotation.getAnnotationType());
                    if (parameterBinder == null) {
                        return Handler.Unbound.INSTANCE;
                    }
                    handler = this.makeHandler(parameterBinder, defaultAnnotation);
                } else {
                    return Handler.Unbound.INSTANCE;
                }
            }
            return handler;
        }

        private Handler makeHandler(ParameterBinder<?> parameterBinder, AnnotationDescription annotation) {
            return new Handler.Bound(parameterBinder, annotation.prepare(parameterBinder.getHandledType()));
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.parameterBinders.equals(((DelegationProcessor)other).parameterBinders);
        }

        public int hashCode() {
            return this.parameterBinders.hashCode();
        }

        public String toString() {
            return "TargetMethodAnnotationDrivenBinder.DelegationProcessor{parameterBinders=" + this.parameterBinders + '}';
        }

        protected static interface Handler {
            public MethodDelegationBinder.ParameterBinding<?> bind(MethodDescription var1, ParameterDescription var2, Implementation.Target var3, Assigner var4);

            public static class Bound<T extends Annotation>
            implements Handler {
                private final ParameterBinder<T> parameterBinder;
                private final AnnotationDescription.Loadable<T> annotation;

                public Bound(ParameterBinder<T> parameterBinder, AnnotationDescription.Loadable<T> annotation) {
                    this.parameterBinder = parameterBinder;
                    this.annotation = annotation;
                }

                @Override
                public MethodDelegationBinder.ParameterBinding<?> bind(MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner) {
                    return this.parameterBinder.bind(this.annotation, source, target, implementationTarget, assigner);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.parameterBinder.equals(((Bound)other).parameterBinder) && this.annotation.equals(((Bound)other).annotation);
                }

                public int hashCode() {
                    int result = this.parameterBinder.hashCode();
                    result = 31 * result + this.annotation.hashCode();
                    return result;
                }

                public String toString() {
                    return "TargetMethodAnnotationDrivenBinder.DelegationProcessor.Handler.Bound{parameterBinder=" + this.parameterBinder + ", annotation=" + this.annotation + '}';
                }
            }

            public static enum Unbound implements Handler
            {
                INSTANCE;


                @Override
                public MethodDelegationBinder.ParameterBinding<?> bind(MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner) {
                    return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
                }

                public String toString() {
                    return "TargetMethodAnnotationDrivenBinder.DelegationProcessor.Handler.Unbound." + this.name();
                }
            }
        }
    }

    public static interface TerminationHandler {
        public StackManipulation resolve(Assigner var1, MethodDescription var2, MethodDescription var3);

        public static enum Dropping implements TerminationHandler
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(Assigner assigner, MethodDescription source, MethodDescription target) {
                return Removal.pop(target.isConstructor() ? target.getDeclaringType().asRawType() : target.getReturnType().asRawType());
            }

            public String toString() {
                return "TargetMethodAnnotationDrivenBinder.TerminationHandler.Dropping." + this.name();
            }
        }

        public static enum Returning implements TerminationHandler
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(Assigner assigner, MethodDescription source, MethodDescription target) {
                return new StackManipulation.Compound(assigner.assign(target.isConstructor() ? target.getDeclaringType().asRawType() : target.getReturnType().asRawType(), source.getReturnType().asRawType(), RuntimeType.Verifier.check(target)), MethodReturn.returning(source.getReturnType().asRawType()));
            }

            public String toString() {
                return "TargetMethodAnnotationDrivenBinder.TerminationHandler.Returning." + this.name();
            }
        }
    }

    public static interface DefaultsProvider {
        public Iterator<AnnotationDescription> makeIterator(Implementation.Target var1, MethodDescription var2, MethodDescription var3);

        public static enum Empty implements DefaultsProvider
        {
            INSTANCE;


            @Override
            public Iterator<AnnotationDescription> makeIterator(Implementation.Target implementationTarget, MethodDescription source, MethodDescription target) {
                return EmptyIterator.INSTANCE;
            }

            public String toString() {
                return "TargetMethodAnnotationDrivenBinder.DefaultsProvider.Empty." + this.name();
            }

            protected static enum EmptyIterator implements Iterator<AnnotationDescription>
            {
                INSTANCE;


                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public AnnotationDescription next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new NoSuchElementException();
                }

                public String toString() {
                    return "TargetMethodAnnotationDrivenBinder.DefaultsProvider.Empty.EmptyIterator." + this.name();
                }
            }
        }
    }

    public static interface ParameterBinder<T extends Annotation> {
        public static final List<ParameterBinder<?>> DEFAULTS = Collections.unmodifiableList(Arrays.asList(Argument.Binder.INSTANCE, AllArguments.Binder.INSTANCE, Origin.Binder.INSTANCE, This.Binder.INSTANCE, Super.Binder.INSTANCE, Default.Binder.INSTANCE, SuperCall.Binder.INSTANCE, DefaultCall.Binder.INSTANCE, FieldValue.Binder.INSTANCE, StubValue.Binder.INSTANCE, Empty.Binder.INSTANCE));

        public Class<T> getHandledType();

        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<T> var1, MethodDescription var2, ParameterDescription var3, Implementation.Target var4, Assigner var5);
    }
}

