/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.assign;

import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveTypeAwareAssigner;
import net.bytebuddy.implementation.bytecode.assign.primitive.VoidAwareAssigner;
import net.bytebuddy.implementation.bytecode.assign.reference.ReferenceTypeAwareAssigner;

public interface Assigner {
    public static final Assigner DEFAULT = new VoidAwareAssigner(new PrimitiveTypeAwareAssigner(ReferenceTypeAwareAssigner.INSTANCE));

    public StackManipulation assign(TypeDescription var1, TypeDescription var2, Typing var3);

    public static enum Refusing implements Assigner
    {
        INSTANCE;


        @Override
        public StackManipulation assign(TypeDescription sourceType, TypeDescription targetType, Typing typing) {
            return StackManipulation.Illegal.INSTANCE;
        }

        public String toString() {
            return "Assigner.Refusing." + this.name();
        }
    }

    public static enum EqualTypesOnly implements Assigner
    {
        INSTANCE;


        @Override
        public StackManipulation assign(TypeDescription sourceType, TypeDescription targetType, Typing typing) {
            return (StackManipulation)((Object)(sourceType.equals(targetType) ? StackManipulation.LegalTrivial.INSTANCE : StackManipulation.Illegal.INSTANCE));
        }

        public String toString() {
            return "Assigner.EqualTypesOnly." + this.name();
        }
    }

    public static enum Typing {
        STATIC(false),
        DYNAMIC(true);

        private final boolean dynamic;

        private Typing(boolean dynamic) {
            this.dynamic = dynamic;
        }

        public static Typing of(boolean dynamic) {
            return dynamic ? DYNAMIC : STATIC;
        }

        public boolean isDynamic() {
            return this.dynamic;
        }

        public String toString() {
            return "Assigner.Typing." + this.name();
        }
    }
}

