/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.constant;

import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.jar.asm.Handle;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.utility.JavaInstance;

public class MethodHandleConstant
implements StackManipulation {
    private static final StackManipulation.Size SIZE = StackSize.SINGLE.toIncreasingSize();
    private final Handle handle;

    private MethodHandleConstant(Handle handle) {
        this.handle = handle;
    }

    public static StackManipulation of(MethodDescription.InDefinedShape methodDescription) {
        return methodDescription.isTypeInitializer() ? StackManipulation.Illegal.INSTANCE : new MethodHandleConstant(new Handle(MethodHandleConstant.tagFor(methodDescription), methodDescription.getDeclaringType().asRawType().getInternalName(), methodDescription.getInternalName(), methodDescription.getDescriptor()));
    }

    public static StackManipulation of(JavaInstance.MethodHandle methodHandle) {
        Type[] parameterType = new Type[methodHandle.getParameterTypes().size()];
        int index = 0;
        for (TypeDescription typeDescription : methodHandle.getParameterTypes()) {
            parameterType[index++] = Type.getType(typeDescription.getDescriptor());
        }
        return new MethodHandleConstant(new Handle(methodHandle.getHandleType().getIdentifier(), methodHandle.getOwnerType().getInternalName(), methodHandle.getName(), Type.getMethodDescriptor(Type.getType(methodHandle.getReturnType().getDescriptor()), parameterType)));
    }

    private static int tagFor(MethodDescription methodDescription) {
        if (methodDescription.isConstructor()) {
            return 8;
        }
        if (methodDescription.isStatic()) {
            return 6;
        }
        if (methodDescription.isPrivate() || methodDescription.isDefaultMethod()) {
            return 7;
        }
        if (methodDescription.isInterface()) {
            return 9;
        }
        return 5;
    }

    public static StackManipulation ofGetter(FieldDescription fieldDescription) {
        return MethodHandleConstant.of(fieldDescription, fieldDescription.isStatic() ? 2 : 1);
    }

    public static StackManipulation ofPutter(FieldDescription fieldDescription) {
        return MethodHandleConstant.of(fieldDescription, fieldDescription.isStatic() ? 4 : 3);
    }

    private static StackManipulation of(FieldDescription fieldDescription, int tag) {
        return new MethodHandleConstant(new Handle(tag, fieldDescription.getDeclaringType().asRawType().getInternalName(), fieldDescription.getInternalName(), fieldDescription.getDescriptor()));
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitLdcInsn(this.handle);
        return SIZE;
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.handle.equals(((MethodHandleConstant)other).handle);
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public String toString() {
        return "MethodHandleConstant{handle=" + this.handle + '}';
    }
}

