/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.constant.MethodHandleConstant;
import net.bytebuddy.implementation.bytecode.constant.MethodTypeConstant;
import net.bytebuddy.jar.asm.Handle;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.utility.ByteBuddyCommons;
import net.bytebuddy.utility.JavaMethod;
import net.bytebuddy.utility.JavaType;

public interface JavaInstance {
    public Object asConstantPoolValue();

    public StackManipulation asStackManipulation();

    public TypeDescription getInstanceType();

    public static class MethodHandle
    implements JavaInstance {
        private static final JavaMethod REVEAL_DIRECT;
        private static final JavaMethod NEW_METHOD_HANDLE_INFO;
        private static final JavaMethod LOOKUP;
        private static final JavaMethod GET_NAME;
        private static final JavaMethod GET_DECLARING_CLASS;
        private static final JavaMethod GET_REFERENCE_KIND;
        private static final JavaMethod GET_METHOD_TYPE;
        private static final JavaMethod RETURN_TYPE;
        private static final JavaMethod PARAMETER_ARRAY;
        private final HandleType handleType;
        private final TypeDescription ownerType;
        private final String name;
        private final TypeDescription returnType;
        private final List<? extends TypeDescription> parameterTypes;

        protected MethodHandle(HandleType handleType, TypeDescription ownerType, String name, TypeDescription returnType, List<? extends TypeDescription> parameterTypes) {
            this.handleType = handleType;
            this.ownerType = ownerType;
            this.name = name;
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
        }

        public static MethodHandle of(Object methodHandle) {
            return MethodHandle.of(methodHandle, LOOKUP.invokeStatic(new Object[0]));
        }

        public static MethodHandle of(Object methodHandle, Object lookup) {
            if (!JavaType.METHOD_HANDLE.getTypeStub().isInstance(methodHandle)) {
                throw new IllegalArgumentException("Expected method handle object: " + methodHandle);
            }
            if (!JavaType.METHOD_HANDLES_LOOKUP.getTypeStub().isInstance(lookup)) {
                throw new IllegalArgumentException("Expected method handle lookup object: " + lookup);
            }
            Object methodHandleInfo = REVEAL_DIRECT.isInvokable() ? REVEAL_DIRECT.invoke(lookup, methodHandle) : NEW_METHOD_HANDLE_INFO.invokeStatic(methodHandle);
            Object methodType = GET_METHOD_TYPE.invoke(methodHandleInfo, new Object[0]);
            return new MethodHandle(HandleType.of((Integer)GET_REFERENCE_KIND.invoke(methodHandleInfo, new Object[0])), new TypeDescription.ForLoadedType((Class)GET_DECLARING_CLASS.invoke(methodHandleInfo, new Object[0])), (String)GET_NAME.invoke(methodHandleInfo, new Object[0]), new TypeDescription.ForLoadedType((Class)RETURN_TYPE.invoke(methodType, new Object[0])), new TypeList.ForLoadedType((Class[])PARAMETER_ARRAY.invoke(methodType, new Object[0])));
        }

        public static MethodHandle of(Method method) {
            return MethodHandle.of(new MethodDescription.ForLoadedMethod(ByteBuddyCommons.nonNull(method)));
        }

        public static MethodHandle of(Constructor<?> constructor) {
            return MethodHandle.of(new MethodDescription.ForLoadedConstructor(ByteBuddyCommons.nonNull(constructor)));
        }

        public static MethodHandle of(MethodDescription methodDescription) {
            return new MethodHandle(HandleType.of(methodDescription), methodDescription.getDeclaringType().asRawType(), methodDescription.getInternalName(), methodDescription.getReturnType().asRawType(), methodDescription.getParameters().asTypeList().asRawTypes());
        }

        public static MethodHandle ofSpecial(Method method, Class<?> type) {
            return MethodHandle.ofSpecial(new MethodDescription.ForLoadedMethod(ByteBuddyCommons.nonNull(method)), new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
        }

        public static MethodHandle ofSpecial(MethodDescription methodDescription, TypeDescription typeDescription) {
            if (!methodDescription.isSpecializableFor(typeDescription)) {
                throw new IllegalArgumentException("Cannot specialize " + methodDescription + " for " + typeDescription);
            }
            return new MethodHandle(HandleType.ofSpecial(methodDescription), typeDescription, methodDescription.getInternalName(), methodDescription.getReturnType().asRawType(), methodDescription.getParameters().asTypeList().asRawTypes());
        }

        public static MethodHandle ofGetter(Field field) {
            return MethodHandle.ofGetter(new FieldDescription.ForLoadedField(field));
        }

        public static MethodHandle ofGetter(FieldDescription fieldDescription) {
            return new MethodHandle(HandleType.ofGetter(fieldDescription), fieldDescription.getDeclaringType().asRawType(), fieldDescription.getInternalName(), fieldDescription.getType().asRawType(), Collections.emptyList());
        }

        public static MethodHandle ofSetter(Field field) {
            return MethodHandle.ofSetter(new FieldDescription.ForLoadedField(field));
        }

        public static MethodHandle ofSetter(FieldDescription fieldDescription) {
            return new MethodHandle(HandleType.ofSetter(fieldDescription), fieldDescription.getDeclaringType().asRawType(), fieldDescription.getInternalName(), TypeDescription.VOID, Collections.singletonList(fieldDescription.getType().asRawType()));
        }

        @Override
        public Object asConstantPoolValue() {
            StringBuilder stringBuilder = new StringBuilder("(");
            for (TypeDescription parameterType : this.getParameterTypes()) {
                stringBuilder.append(parameterType.getDescriptor());
            }
            String descriptor = stringBuilder.append(")").append(this.getReturnType().getDescriptor()).toString();
            return new Handle(this.getHandleType().getIdentifier(), this.getOwnerType().getInternalName(), this.getName(), descriptor);
        }

        @Override
        public StackManipulation asStackManipulation() {
            return MethodHandleConstant.of(this);
        }

        @Override
        public TypeDescription getInstanceType() {
            return JavaType.METHOD_HANDLE.getTypeStub();
        }

        public HandleType getHandleType() {
            return this.handleType;
        }

        public TypeDescription getOwnerType() {
            return this.ownerType;
        }

        public String getName() {
            return this.name;
        }

        public TypeDescription getReturnType() {
            return this.returnType;
        }

        public List<TypeDescription> getParameterTypes() {
            return new ArrayList<TypeDescription>(this.parameterTypes);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            MethodHandle aDefault = (MethodHandle)other;
            return this.handleType == aDefault.handleType && this.name.equals(aDefault.name) && this.ownerType.equals(aDefault.ownerType) && this.parameterTypes.equals(aDefault.parameterTypes) && this.returnType.equals(aDefault.returnType);
        }

        public int hashCode() {
            int result = this.handleType.hashCode();
            result = 31 * result + this.ownerType.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.returnType.hashCode();
            result = 31 * result + this.parameterTypes.hashCode();
            return result;
        }

        public String toString() {
            return "JavaInstance.MethodHandle{handleType=" + (Object)((Object)this.handleType) + ", ownerType=" + this.ownerType + ", name='" + this.name + '\'' + ", returnType=" + this.returnType + ", parameterTypes=" + this.parameterTypes + '}';
        }

        static {
            JavaMethod parameterArray;
            JavaMethod returnType;
            JavaMethod getMethodType;
            JavaMethod getReferenceKind;
            JavaMethod getDeclaringClass;
            JavaMethod getName;
            JavaMethod newMethodHandleInfo;
            JavaMethod lookup;
            JavaMethod revealDirect;
            try {
                Class<?> methodHandlesLookup = JavaType.METHOD_HANDLES_LOOKUP.load();
                try {
                    revealDirect = new JavaMethod.ForLoadedMethod(methodHandlesLookup.getDeclaredMethod("revealDirect", JavaType.METHOD_HANDLE.load()));
                }
                catch (Exception ignored) {
                    revealDirect = JavaMethod.ForUnavailableMethod.INSTANCE;
                }
                Class<?> methodHandles = Class.forName("java.lang.invoke.MethodHandles");
                lookup = new JavaMethod.ForLoadedMethod(methodHandles.getDeclaredMethod("publicLookup", new Class[0]));
                Class<?> methodHandleInfo = Class.forName("java.lang.invoke.MethodHandleInfo");
                if (revealDirect.isInvokable()) {
                    newMethodHandleInfo = JavaMethod.ForUnavailableMethod.INSTANCE;
                } else {
                    Constructor<?> newMethodHandleInfoConstructor = methodHandleInfo.getDeclaredConstructor(JavaType.METHOD_HANDLE.load());
                    newMethodHandleInfoConstructor.setAccessible(true);
                    newMethodHandleInfo = new JavaMethod.ForLoadedConstructor(newMethodHandleInfoConstructor);
                }
                Method getNameMethod = methodHandleInfo.getDeclaredMethod("getName", new Class[0]);
                Method getDeclaringClassMethod = methodHandleInfo.getDeclaredMethod("getDeclaringClass", new Class[0]);
                Method getReferenceKindMethod = methodHandleInfo.getDeclaredMethod("getReferenceKind", new Class[0]);
                Method getMethodTypeMethod = methodHandleInfo.getDeclaredMethod("getMethodType", new Class[0]);
                getName = new JavaMethod.ForLoadedMethod(getNameMethod);
                getDeclaringClass = new JavaMethod.ForLoadedMethod(getDeclaringClassMethod);
                getReferenceKind = new JavaMethod.ForLoadedMethod(getReferenceKindMethod);
                getMethodType = new JavaMethod.ForLoadedMethod(getMethodTypeMethod);
                if (!revealDirect.isInvokable()) {
                    getNameMethod.setAccessible(true);
                    getDeclaringClassMethod.setAccessible(true);
                    getReferenceKindMethod.setAccessible(true);
                    getMethodTypeMethod.setAccessible(true);
                }
                Class<?> methodType = JavaType.METHOD_TYPE.load();
                returnType = new JavaMethod.ForLoadedMethod(methodType.getDeclaredMethod("returnType", new Class[0]));
                parameterArray = new JavaMethod.ForLoadedMethod(methodType.getDeclaredMethod("parameterArray", new Class[0]));
            }
            catch (Exception ignored) {
                revealDirect = JavaMethod.ForUnavailableMethod.INSTANCE;
                newMethodHandleInfo = JavaMethod.ForUnavailableMethod.INSTANCE;
                lookup = JavaMethod.ForUnavailableMethod.INSTANCE;
                getName = JavaMethod.ForUnavailableMethod.INSTANCE;
                getDeclaringClass = JavaMethod.ForUnavailableMethod.INSTANCE;
                getReferenceKind = JavaMethod.ForUnavailableMethod.INSTANCE;
                getMethodType = JavaMethod.ForUnavailableMethod.INSTANCE;
                returnType = JavaMethod.ForUnavailableMethod.INSTANCE;
                parameterArray = JavaMethod.ForUnavailableMethod.INSTANCE;
            }
            REVEAL_DIRECT = revealDirect;
            NEW_METHOD_HANDLE_INFO = newMethodHandleInfo;
            LOOKUP = lookup;
            GET_NAME = getName;
            GET_DECLARING_CLASS = getDeclaringClass;
            GET_REFERENCE_KIND = getReferenceKind;
            GET_METHOD_TYPE = getMethodType;
            RETURN_TYPE = returnType;
            PARAMETER_ARRAY = parameterArray;
        }

        public static enum HandleType {
            INVOKE_VIRTUAL(5),
            INVOKE_STATIC(6),
            INVOKE_SPECIAL(7),
            INVOKE_INTERFACE(9),
            INVOKE_SPECIAL_CONSTRUCTOR(8),
            PUT_FIELD(3),
            GET_FIELD(1),
            PUT_STATIC_FIELD(4),
            GET_STATIC_FIELD(2);

            private final int identifier;

            private HandleType(int identifier) {
                this.identifier = identifier;
            }

            protected static HandleType of(MethodDescription methodDescription) {
                if (methodDescription.isStatic()) {
                    return INVOKE_STATIC;
                }
                if (methodDescription.isPrivate()) {
                    return INVOKE_SPECIAL;
                }
                if (methodDescription.isConstructor()) {
                    return INVOKE_SPECIAL_CONSTRUCTOR;
                }
                if (methodDescription.getDeclaringType().asRawType().isInterface()) {
                    return INVOKE_INTERFACE;
                }
                return INVOKE_VIRTUAL;
            }

            protected static HandleType of(int identifier) {
                for (HandleType handleType : HandleType.values()) {
                    if (handleType.getIdentifier() != identifier) continue;
                    return handleType;
                }
                throw new IllegalArgumentException("Unknown handle type: " + identifier);
            }

            protected static HandleType ofSpecial(MethodDescription methodDescription) {
                if (methodDescription.isStatic() || methodDescription.isAbstract()) {
                    throw new IllegalArgumentException("Cannot invoke " + methodDescription + " via invokespecial");
                }
                return methodDescription.isConstructor() ? INVOKE_SPECIAL_CONSTRUCTOR : INVOKE_SPECIAL;
            }

            protected static HandleType ofGetter(FieldDescription fieldDescription) {
                return fieldDescription.isStatic() ? GET_STATIC_FIELD : GET_FIELD;
            }

            protected static HandleType ofSetter(FieldDescription fieldDescription) {
                return fieldDescription.isStatic() ? PUT_STATIC_FIELD : PUT_FIELD;
            }

            public int getIdentifier() {
                return this.identifier;
            }

            public String toString() {
                return "JavaInstance.MethodHandle.HandleType." + this.name();
            }
        }
    }

    public static class MethodType
    implements JavaInstance {
        private static final JavaMethod RETURN_TYPE;
        private static final JavaMethod PARAMETER_ARRAY;
        private final TypeDescription returnType;
        private final List<? extends TypeDescription> parameterTypes;

        protected MethodType(TypeDescription returnType, List<? extends TypeDescription> parameterTypes) {
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
        }

        public static MethodType of(Object methodType) {
            if (!JavaType.METHOD_TYPE.getTypeStub().isInstance(methodType)) {
                throw new IllegalArgumentException("Excpected method type object: " + methodType);
            }
            return MethodType.of((Class)RETURN_TYPE.invoke(methodType, new Object[0]), (Class[])PARAMETER_ARRAY.invoke(methodType, new Object[0]));
        }

        public static MethodType of(Class<?> returnType, Class<?> ... parameterType) {
            return MethodType.of(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(returnType)), new TypeList.ForLoadedType(ByteBuddyCommons.nonNull(parameterType)));
        }

        public static MethodType of(TypeDescription returnType, List<? extends TypeDescription> parameterTypes) {
            return new MethodType(ByteBuddyCommons.nonNull(returnType), ByteBuddyCommons.isActualType(parameterTypes));
        }

        public static MethodType of(Method method) {
            return MethodType.of(new MethodDescription.ForLoadedMethod(ByteBuddyCommons.nonNull(method)));
        }

        public static MethodType of(Constructor<?> constructor) {
            return MethodType.of(new MethodDescription.ForLoadedConstructor(ByteBuddyCommons.nonNull(constructor)));
        }

        public static MethodType of(MethodDescription methodDescription) {
            return new MethodType(methodDescription.getReturnType().asRawType(), methodDescription.getParameters().asTypeList().asRawTypes());
        }

        public static MethodType ofSetter(Field field) {
            return MethodType.ofSetter(new FieldDescription.ForLoadedField(ByteBuddyCommons.nonNull(field)));
        }

        public static MethodType ofSetter(FieldDescription fieldDescription) {
            return new MethodType(TypeDescription.VOID, Collections.singletonList(fieldDescription.getType().asRawType()));
        }

        public static MethodType ofGetter(Field field) {
            return MethodType.ofGetter(new FieldDescription.ForLoadedField(ByteBuddyCommons.nonNull(field)));
        }

        public static MethodType ofGetter(FieldDescription fieldDescription) {
            return new MethodType(fieldDescription.getType().asRawType(), Collections.emptyList());
        }

        public static MethodType ofConstant(Object instance) {
            return MethodType.ofConstant(instance.getClass());
        }

        public static MethodType ofConstant(Class<?> type) {
            return MethodType.ofConstant(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
        }

        public static MethodType ofConstant(TypeDescription typeDescription) {
            return new MethodType(typeDescription, Collections.emptyList());
        }

        public TypeDescription getReturnType() {
            return this.returnType;
        }

        public List<TypeDescription> getParameterTypes() {
            return new ArrayList<TypeDescription>(this.parameterTypes);
        }

        @Override
        public Object asConstantPoolValue() {
            StringBuilder stringBuilder = new StringBuilder("(");
            for (TypeDescription parameterType : this.getParameterTypes()) {
                stringBuilder.append(parameterType.getDescriptor());
            }
            return Type.getMethodType(stringBuilder.append(")").append(this.getReturnType().getDescriptor()).toString());
        }

        @Override
        public StackManipulation asStackManipulation() {
            return MethodTypeConstant.of(this);
        }

        @Override
        public TypeDescription getInstanceType() {
            return JavaType.METHOD_TYPE.getTypeStub();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            MethodType that = (MethodType)other;
            return this.parameterTypes.equals(that.parameterTypes) && this.returnType.equals(that.returnType);
        }

        public int hashCode() {
            int result = this.returnType.hashCode();
            result = 31 * result + this.parameterTypes.hashCode();
            return result;
        }

        public String toString() {
            return "JavaInstance.MethodType{returnType=" + this.returnType + ", parameterTypes=" + this.parameterTypes + '}';
        }

        static {
            JavaMethod parameterArray;
            JavaMethod returnType;
            try {
                Class<?> methodType = JavaType.METHOD_TYPE.load();
                returnType = new JavaMethod.ForLoadedMethod(methodType.getDeclaredMethod("returnType", new Class[0]));
                parameterArray = new JavaMethod.ForLoadedMethod(methodType.getDeclaredMethod("parameterArray", new Class[0]));
            }
            catch (Exception ignored) {
                returnType = JavaMethod.ForUnavailableMethod.INSTANCE;
                parameterArray = JavaMethod.ForUnavailableMethod.INSTANCE;
            }
            RETURN_TYPE = returnType;
            PARAMETER_ARRAY = parameterArray;
        }
    }
}

