/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public interface JavaMethod {
    public boolean isInvokable();

    public Object invoke(Object var1, Object ... var2);

    public Object invokeStatic(Object ... var1);

    public static class ForLoadedConstructor
    implements JavaMethod {
        private final Constructor<?> constructor;

        public ForLoadedConstructor(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public boolean isInvokable() {
            return true;
        }

        @Override
        public Object invoke(Object instance, Object ... argument) {
            throw new IllegalStateException("Cannot invoke constructor on an instance");
        }

        @Override
        public Object invokeStatic(Object ... argument) {
            try {
                return this.constructor.newInstance(argument);
            }
            catch (InstantiationException exception) {
                throw new IllegalStateException("Cannot initiate class", exception);
            }
            catch (IllegalAccessException exception) {
                throw new IllegalStateException("Cannot invoke dynamically-linked method", exception);
            }
            catch (InvocationTargetException exception) {
                throw new IllegalStateException("Exception when invoking method", exception.getCause());
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.constructor.equals(((ForLoadedConstructor)other).constructor);
        }

        public int hashCode() {
            return this.constructor.hashCode();
        }

        public String toString() {
            return "JavaMethod.ForLoadedConstructor{constructor=" + this.constructor + '}';
        }
    }

    public static class ForLoadedMethod
    implements JavaMethod {
        private final Method method;

        public ForLoadedMethod(Method method) {
            this.method = method;
        }

        @Override
        public boolean isInvokable() {
            return true;
        }

        @Override
        public Object invoke(Object instance, Object ... argument) {
            try {
                return this.method.invoke(instance, argument);
            }
            catch (IllegalAccessException exception) {
                throw new IllegalStateException("Cannot invoke dynamically-linked method", exception);
            }
            catch (InvocationTargetException exception) {
                throw new IllegalStateException("Exception when invoking method", exception.getCause());
            }
        }

        @Override
        public Object invokeStatic(Object ... argument) {
            return this.invoke(null, argument);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.method.equals(((ForLoadedMethod)other).method);
        }

        public int hashCode() {
            return this.method.hashCode();
        }

        public String toString() {
            return "JavaMethod.ForLoadedMethod{method=" + this.method + '}';
        }
    }

    public static enum ForUnavailableMethod implements JavaMethod
    {
        INSTANCE;


        @Override
        public boolean isInvokable() {
            return false;
        }

        @Override
        public Object invoke(Object instance, Object ... argument) {
            throw new IllegalStateException("This feature is not available for current version / configuration of the Java virtual machine");
        }

        @Override
        public Object invokeStatic(Object ... argument) {
            return this.invoke(null, argument);
        }

        public String toString() {
            return "JavaMethod.ForUnavailableMethod." + this.name();
        }
    }
}

