/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.type.generic;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.description.type.generic.GenericTypeDescription;
import net.bytebuddy.description.type.generic.TypeVariableSource;
import net.bytebuddy.matcher.FilterableList;

public interface GenericTypeList
extends FilterableList<GenericTypeDescription, GenericTypeList> {
    public TypeList asErasures();

    public GenericTypeList accept(GenericTypeDescription.Visitor<? extends GenericTypeDescription> var1);

    public int getStackSize();

    public static abstract class LazyProjection
    extends AbstractBase {

        public static class OfMethodExceptionTypes
        extends LazyProjection {
            private final Method method;

            public OfMethodExceptionTypes(Method method) {
                this.method = method;
            }

            @Override
            public GenericTypeDescription get(int index) {
                return new TypeProjection(this.method, index, this.method.getExceptionTypes()[index]);
            }

            @Override
            public int size() {
                return this.method.getExceptionTypes().length;
            }

            @Override
            public TypeList asErasures() {
                return new TypeList.ForLoadedType(this.method.getExceptionTypes());
            }

            private static class TypeProjection
            extends GenericTypeDescription.LazyProjection {
                private final Method method;
                private final int index;
                private final Class<?> erasure;

                public TypeProjection(Method method, int index, Class<?> erasure) {
                    this.method = method;
                    this.index = index;
                    this.erasure = erasure;
                }

                @Override
                protected GenericTypeDescription resolve() {
                    return GenericTypeDescription.Sort.describe(this.method.getGenericExceptionTypes()[this.index]);
                }

                @Override
                public TypeDescription asErasure() {
                    return new TypeDescription.ForLoadedType(this.erasure);
                }
            }
        }

        public static class OfConstructorExceptionTypes
        extends LazyProjection {
            private final Constructor<?> constructor;

            public OfConstructorExceptionTypes(Constructor<?> constructor) {
                this.constructor = constructor;
            }

            @Override
            public GenericTypeDescription get(int index) {
                return new TypeProjection(this.constructor, index, this.constructor.getExceptionTypes()[index]);
            }

            @Override
            public int size() {
                return this.constructor.getExceptionTypes().length;
            }

            @Override
            public TypeList asErasures() {
                return new TypeList.ForLoadedType(this.constructor.getExceptionTypes());
            }

            private static class TypeProjection
            extends GenericTypeDescription.LazyProjection {
                private final Constructor<?> constructor;
                private final int index;
                private final Class<?> erasure;

                private TypeProjection(Constructor<?> constructor, int index, Class<?> erasure) {
                    this.constructor = constructor;
                    this.index = index;
                    this.erasure = erasure;
                }

                @Override
                protected GenericTypeDescription resolve() {
                    return GenericTypeDescription.Sort.describe(this.constructor.getGenericExceptionTypes()[this.index]);
                }

                @Override
                public TypeDescription asErasure() {
                    return new TypeDescription.ForLoadedType(this.erasure);
                }
            }
        }

        public static class OfInterfaces
        extends LazyProjection {
            private final Class<?> type;

            public OfInterfaces(Class<?> type) {
                this.type = type;
            }

            @Override
            public GenericTypeDescription get(int index) {
                return new TypeProjection(this.type, index, this.type.getInterfaces()[index]);
            }

            @Override
            public int size() {
                return this.type.getInterfaces().length;
            }

            @Override
            public TypeList asErasures() {
                return new TypeList.ForLoadedType(this.type.getInterfaces());
            }

            private static class TypeProjection
            extends GenericTypeDescription.LazyProjection {
                private final Class<?> type;
                private final int index;
                private final Class<?> erasure;

                private TypeProjection(Class<?> type, int index, Class<?> erasure) {
                    this.type = type;
                    this.index = index;
                    this.erasure = erasure;
                }

                @Override
                protected GenericTypeDescription resolve() {
                    return GenericTypeDescription.Sort.describe(this.type.getGenericInterfaces()[this.index]);
                }

                @Override
                public TypeDescription asErasure() {
                    return new TypeDescription.ForLoadedType(this.erasure);
                }
            }
        }
    }

    public static class OfPotentiallyRawType
    extends AbstractBase {
        private final List<? extends GenericTypeDescription> typeDescriptions;
        private final GenericTypeDescription.Visitor<? extends GenericTypeDescription> transformer;

        public OfPotentiallyRawType(List<? extends GenericTypeDescription> typeDescriptions, GenericTypeDescription.Visitor<? extends GenericTypeDescription> transformer) {
            this.typeDescriptions = typeDescriptions;
            this.transformer = transformer;
        }

        @Override
        public GenericTypeDescription get(int index) {
            return GenericTypeDescription.LazyProjection.OfPotentiallyRawType.of(this.typeDescriptions.get(index), this.transformer);
        }

        @Override
        public int size() {
            return this.typeDescriptions.size();
        }
    }

    public static class Empty
    extends FilterableList.Empty<GenericTypeDescription, GenericTypeList>
    implements GenericTypeList {
        @Override
        public TypeList asErasures() {
            return new TypeList.Empty();
        }

        @Override
        public GenericTypeList accept(GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor) {
            return new Empty();
        }

        @Override
        public int getStackSize() {
            return 0;
        }
    }

    public static class ForDetachedTypes
    extends AbstractBase {
        private final GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor;
        private final List<? extends GenericTypeDescription> detachedTypes;

        protected ForDetachedTypes(GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor, List<? extends GenericTypeDescription> detachedTypes) {
            this.visitor = visitor;
            this.detachedTypes = detachedTypes;
        }

        public static GenericTypeList attach(TypeDescription typeDescription, List<? extends GenericTypeDescription> detachedTypes) {
            return new ForDetachedTypes(GenericTypeDescription.Visitor.Substitutor.ForAttachment.of(typeDescription), detachedTypes);
        }

        public static GenericTypeList attach(FieldDescription fieldDescription, List<? extends GenericTypeDescription> detachedTypes) {
            return new ForDetachedTypes(GenericTypeDescription.Visitor.Substitutor.ForAttachment.of(fieldDescription), detachedTypes);
        }

        public static GenericTypeList attach(MethodDescription methodDescription, List<? extends GenericTypeDescription> detachedTypes) {
            return new ForDetachedTypes(GenericTypeDescription.Visitor.Substitutor.ForAttachment.of(methodDescription), detachedTypes);
        }

        public static GenericTypeList attach(ParameterDescription parameterDescription, List<? extends GenericTypeDescription> detachedTypes) {
            return new ForDetachedTypes(GenericTypeDescription.Visitor.Substitutor.ForAttachment.of(parameterDescription), detachedTypes);
        }

        @Override
        public GenericTypeDescription get(int index) {
            return this.detachedTypes.get(index).accept(this.visitor);
        }

        @Override
        public int size() {
            return this.detachedTypes.size();
        }

        public static class OfTypeVariable
        extends AbstractBase {
            private final TypeVariableSource typeVariableSource;
            private final GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor;
            private final List<? extends GenericTypeDescription> detachedTypes;

            protected OfTypeVariable(TypeVariableSource typeVariableSource, GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor, List<? extends GenericTypeDescription> detachedTypes) {
                this.typeVariableSource = typeVariableSource;
                this.visitor = visitor;
                this.detachedTypes = detachedTypes;
            }

            public static GenericTypeList attach(TypeDescription typeDescription, List<? extends GenericTypeDescription> detachedTypes) {
                return new OfTypeVariable(typeDescription, GenericTypeDescription.Visitor.Substitutor.ForAttachment.of(typeDescription), detachedTypes);
            }

            public static GenericTypeList attach(MethodDescription methodDescription, List<? extends GenericTypeDescription> detachedTypes) {
                return new OfTypeVariable(methodDescription, GenericTypeDescription.Visitor.Substitutor.ForAttachment.of(methodDescription), detachedTypes);
            }

            @Override
            public GenericTypeDescription get(int index) {
                return LazyTypeVariable.of(this.detachedTypes.get(index), this.typeVariableSource, this.visitor);
            }

            @Override
            public int size() {
                return this.detachedTypes.size();
            }

            protected static class LazyTypeVariable
            extends GenericTypeDescription.ForTypeVariable {
                private final String symbol;
                private final TypeVariableSource typeVariableSource;
                private final GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor;
                private final List<? extends GenericTypeDescription> detachedBounds;

                protected LazyTypeVariable(String symbol, TypeVariableSource typeVariableSource, GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor, List<? extends GenericTypeDescription> detachedBounds) {
                    this.symbol = symbol;
                    this.typeVariableSource = typeVariableSource;
                    this.visitor = visitor;
                    this.detachedBounds = detachedBounds;
                }

                public static GenericTypeDescription of(GenericTypeDescription detachedVariable, TypeVariableSource typeVariableSource, GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor) {
                    return new LazyTypeVariable(detachedVariable.getSymbol(), typeVariableSource, visitor, detachedVariable.getUpperBounds());
                }

                @Override
                public GenericTypeList getUpperBounds() {
                    return new ForDetachedTypes(this.visitor, this.detachedBounds);
                }

                @Override
                public TypeVariableSource getVariableSource() {
                    return this.typeVariableSource;
                }

                @Override
                public String getSymbol() {
                    return this.symbol;
                }
            }
        }
    }

    public static class ForLoadedType
    extends AbstractBase {
        private final List<? extends Type> types;

        public ForLoadedType(Type ... type) {
            this(Arrays.asList(type));
        }

        public ForLoadedType(List<? extends Type> types) {
            this.types = types;
        }

        @Override
        public GenericTypeDescription get(int index) {
            return GenericTypeDescription.Sort.describe(this.types.get(index));
        }

        @Override
        public int size() {
            return this.types.size();
        }
    }

    public static class Explicit
    extends AbstractBase {
        private final List<? extends GenericTypeDescription> genericTypes;

        public Explicit(List<? extends GenericTypeDescription> genericTypes) {
            this.genericTypes = genericTypes;
        }

        @Override
        public GenericTypeDescription get(int index) {
            return this.genericTypes.get(index);
        }

        @Override
        public int size() {
            return this.genericTypes.size();
        }
    }

    public static abstract class AbstractBase
    extends FilterableList.AbstractBase<GenericTypeDescription, GenericTypeList>
    implements GenericTypeList {
        @Override
        protected GenericTypeList wrap(List<GenericTypeDescription> values) {
            return new Explicit(values);
        }

        @Override
        public GenericTypeList accept(GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor) {
            ArrayList<GenericTypeDescription> visited = new ArrayList<GenericTypeDescription>(this.size());
            for (GenericTypeDescription genericTypeDescription : this) {
                visited.add(genericTypeDescription.accept(visitor));
            }
            return new Explicit(visited);
        }

        @Override
        public int getStackSize() {
            int stackSize = 0;
            for (GenericTypeDescription genericTypeDescription : this) {
                stackSize += genericTypeDescription.getStackSize().getSize();
            }
            return stackSize;
        }

        @Override
        public TypeList asErasures() {
            ArrayList<TypeDescription> typeDescriptions = new ArrayList<TypeDescription>(this.size());
            for (GenericTypeDescription genericTypeDescription : this) {
                typeDescriptions.add(genericTypeDescription.asErasure());
            }
            return new TypeList.Explicit(typeDescriptions);
        }
    }
}

