/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.Map;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ByteArrayClassLoader;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.PackageDefinitionStrategy;

public interface ClassLoadingStrategy {
    public Map<TypeDescription, Class<?>> load(ClassLoader var1, Map<TypeDescription, byte[]> var2);

    public static class ForBootstrapInjection
    implements ClassLoadingStrategy {
        private final Instrumentation instrumentation;
        private final File folder;

        public ForBootstrapInjection(Instrumentation instrumentation, File folder) {
            this.instrumentation = instrumentation;
            this.folder = folder;
        }

        @Override
        public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            ClassInjector classInjector = classLoader == null ? new ClassInjector.UsingInstrumentation(this.folder, ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, this.instrumentation) : new ClassInjector.UsingReflection(classLoader);
            return classInjector.inject(types);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ForBootstrapInjection that = (ForBootstrapInjection)other;
            return this.folder.equals(that.folder) && this.instrumentation.equals(that.instrumentation);
        }

        public int hashCode() {
            int result = this.instrumentation.hashCode();
            result = 31 * result + this.folder.hashCode();
            return result;
        }

        public String toString() {
            return "ClassLoadingStrategy.ForBootstrapInjection{instrumentation=" + this.instrumentation + ", folder=" + this.folder + '}';
        }
    }

    public static interface Configurable
    extends ClassLoadingStrategy {
        public Configurable withProtectionDomain(ProtectionDomain var1);

        public Configurable withPackageDefinitionStrategy(PackageDefinitionStrategy var1);

        public Configurable withAccessControlContext(AccessControlContext var1);
    }

    public static enum Default implements Configurable
    {
        WRAPPER(new WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler.LATENT, false)),
        WRAPPER_PERSISTENT(new WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler.MANIFEST, false)),
        CHILD_FIRST(new WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler.LATENT, true)),
        CHILD_FIRST_PERSISTENT(new WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler.MANIFEST, true)),
        INJECTION(new InjectionDispatcher());

        private static final ProtectionDomain DEFAULT_PROTECTION_DOMAIN;
        private final Configurable dispatcher;

        private Default(Configurable dispatcher) {
            this.dispatcher = dispatcher;
        }

        @Override
        public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            return this.dispatcher.load(classLoader, types);
        }

        @Override
        public Configurable withProtectionDomain(ProtectionDomain protectionDomain) {
            return this.dispatcher.withProtectionDomain(protectionDomain);
        }

        @Override
        public Configurable withPackageDefinitionStrategy(PackageDefinitionStrategy packageDefinitionStrategy) {
            return this.dispatcher.withPackageDefinitionStrategy(packageDefinitionStrategy);
        }

        @Override
        public Configurable withAccessControlContext(AccessControlContext accessControlContext) {
            return this.dispatcher.withAccessControlContext(accessControlContext);
        }

        public String toString() {
            return "ClassLoadingStrategy.Default." + this.name();
        }

        static {
            DEFAULT_PROTECTION_DOMAIN = null;
        }

        protected static class WrappingDispatcher
        implements Configurable {
            private static final boolean CHILD_FIRST = true;
            private static final boolean PARENT_FIRST = false;
            private final ProtectionDomain protectionDomain;
            private final AccessControlContext accessControlContext;
            private final ByteArrayClassLoader.PersistenceHandler persistenceHandler;
            private final PackageDefinitionStrategy packageDefinitionStrategy;
            private final boolean childFirst;

            protected WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler persistenceHandler, boolean childFirst) {
                this(DEFAULT_PROTECTION_DOMAIN, AccessController.getContext(), PackageDefinitionStrategy.Trivial.INSTANCE, persistenceHandler, childFirst);
            }

            private WrappingDispatcher(ProtectionDomain protectionDomain, AccessControlContext accessControlContext, PackageDefinitionStrategy packageDefinitionStrategy, ByteArrayClassLoader.PersistenceHandler persistenceHandler, boolean childFirst) {
                this.protectionDomain = protectionDomain;
                this.accessControlContext = accessControlContext;
                this.packageDefinitionStrategy = packageDefinitionStrategy;
                this.persistenceHandler = persistenceHandler;
                this.childFirst = childFirst;
            }

            @Override
            public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
                return ByteArrayClassLoader.load(classLoader, types, this.protectionDomain, this.accessControlContext, this.persistenceHandler, this.packageDefinitionStrategy, this.childFirst);
            }

            @Override
            public Configurable withProtectionDomain(ProtectionDomain protectionDomain) {
                return new WrappingDispatcher(protectionDomain, this.accessControlContext, this.packageDefinitionStrategy, this.persistenceHandler, this.childFirst);
            }

            @Override
            public Configurable withPackageDefinitionStrategy(PackageDefinitionStrategy packageDefinitionStrategy) {
                return new WrappingDispatcher(this.protectionDomain, this.accessControlContext, packageDefinitionStrategy, this.persistenceHandler, this.childFirst);
            }

            @Override
            public Configurable withAccessControlContext(AccessControlContext accessControlContext) {
                return new WrappingDispatcher(this.protectionDomain, accessControlContext, this.packageDefinitionStrategy, this.persistenceHandler, this.childFirst);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null) return false;
                if (this.getClass() != other.getClass()) {
                    return false;
                }
                WrappingDispatcher that = (WrappingDispatcher)other;
                if (this.childFirst != that.childFirst) return false;
                if (this.protectionDomain != null) {
                    if (!this.protectionDomain.equals(that.protectionDomain)) {
                        return false;
                    }
                } else if (that.protectionDomain != null) return false;
                if (this.persistenceHandler != that.persistenceHandler) return false;
                if (!this.accessControlContext.equals(that.accessControlContext)) return false;
                if (!this.packageDefinitionStrategy.equals(that.packageDefinitionStrategy)) return false;
                return true;
            }

            public int hashCode() {
                int result = this.protectionDomain != null ? this.protectionDomain.hashCode() : 0;
                result = 31 * result + this.accessControlContext.hashCode();
                result = 31 * result + this.persistenceHandler.hashCode();
                result = 31 * result + this.packageDefinitionStrategy.hashCode();
                result = 31 * result + (this.childFirst ? 1 : 0);
                return result;
            }

            public String toString() {
                return "ClassLoadingStrategy.Default.WrappingDispatcher{packageDefinitionStrategy=" + this.packageDefinitionStrategy + ", protectionDomain=" + this.protectionDomain + ", accessControlContext=" + this.accessControlContext + ", childFirst=" + this.childFirst + ", persistenceHandler=" + (Object)((Object)this.persistenceHandler) + '}';
            }
        }

        protected static class InjectionDispatcher
        implements Configurable {
            private final ProtectionDomain protectionDomain;
            private final AccessControlContext accessControlContext;
            private final PackageDefinitionStrategy packageDefinitionStrategy;

            protected InjectionDispatcher() {
                this(DEFAULT_PROTECTION_DOMAIN, AccessController.getContext(), PackageDefinitionStrategy.NoOp.INSTANCE);
            }

            private InjectionDispatcher(ProtectionDomain protectionDomain, AccessControlContext accessControlContext, PackageDefinitionStrategy packageDefinitionStrategy) {
                this.protectionDomain = protectionDomain;
                this.accessControlContext = accessControlContext;
                this.packageDefinitionStrategy = packageDefinitionStrategy;
            }

            @Override
            public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
                return new ClassInjector.UsingReflection(classLoader, this.protectionDomain, this.accessControlContext, this.packageDefinitionStrategy).inject(types);
            }

            @Override
            public Configurable withProtectionDomain(ProtectionDomain protectionDomain) {
                return new InjectionDispatcher(protectionDomain, this.accessControlContext, this.packageDefinitionStrategy);
            }

            @Override
            public Configurable withPackageDefinitionStrategy(PackageDefinitionStrategy packageDefinitionStrategy) {
                return new InjectionDispatcher(this.protectionDomain, this.accessControlContext, packageDefinitionStrategy);
            }

            @Override
            public Configurable withAccessControlContext(AccessControlContext accessControlContext) {
                return new InjectionDispatcher(this.protectionDomain, accessControlContext, this.packageDefinitionStrategy);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null) return false;
                if (this.getClass() != other.getClass()) {
                    return false;
                }
                InjectionDispatcher that = (InjectionDispatcher)other;
                if (this.protectionDomain != null) {
                    if (!this.protectionDomain.equals(that.protectionDomain)) {
                        return false;
                    }
                } else if (that.protectionDomain != null) return false;
                if (!this.accessControlContext.equals(that.accessControlContext)) return false;
                if (!this.packageDefinitionStrategy.equals(that.packageDefinitionStrategy)) return false;
                return true;
            }

            public int hashCode() {
                int result = this.protectionDomain != null ? this.protectionDomain.hashCode() : 0;
                result = 31 * result + this.packageDefinitionStrategy.hashCode();
                result = 31 * result + this.accessControlContext.hashCode();
                return result;
            }

            public String toString() {
                return "ClassLoadingStrategy.Default.InjectionDispatcher{protectionDomain=" + this.protectionDomain + "accessControlContext=" + this.accessControlContext + "packageDefinitionStrategy=" + this.packageDefinitionStrategy + '}';
            }
        }
    }
}

