/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.generic.GenericTypeDescription;

public final class ByteBuddyCommons {
    public static final int VISIBILITY_MODIFIER_MASK = 7;
    public static final int GENERAL_MODIFIER_MASK = 135168;
    public static final int TYPE_MODIFIER_MASK = 163383;
    public static final int MEMBER_MODIFIER_MASK = 163391;
    public static final int FIELD_MODIFIER_MASK = 163583;
    public static final int METHOD_MODIFIER_MASK = 163839;
    public static final int PARAMETER_MODIFIER_MASK = 36880;
    private static final Set<String> JAVA_KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "double", "do", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while")));
    private static final Set<GenericTypeDescription.Sort> EXTENDABLE_TYPES = EnumSet.of(GenericTypeDescription.Sort.NON_GENERIC, GenericTypeDescription.Sort.PARAMETERIZED);

    private ByteBuddyCommons() {
        throw new UnsupportedOperationException("This type describes a utility and is not supposed to be instantiated");
    }

    public static <T> T nonNull(T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return value;
    }

    public static <T> T[] nonNull(T[] value) {
        for (T object : value) {
            ByteBuddyCommons.nonNull(object);
        }
        return value;
    }

    public static <T extends TypeDescription> T isAnnotation(T typeDescription) {
        if (!typeDescription.isAnnotation()) {
            throw new IllegalArgumentException(typeDescription + " is not an annotation type");
        }
        return typeDescription;
    }

    public static <T extends GenericTypeDescription> T isThrowable(T typeDescription) {
        if (!ByteBuddyCommons.isActualType(typeDescription).asErasure().isAssignableTo(Throwable.class)) {
            throw new IllegalArgumentException("Cannot throw instances of: " + typeDescription);
        }
        return typeDescription;
    }

    public static <T extends Collection<? extends GenericTypeDescription>> T isThrowable(T typeDescriptions) {
        for (GenericTypeDescription typeDescription : typeDescriptions) {
            ByteBuddyCommons.isThrowable(typeDescription);
        }
        return typeDescriptions;
    }

    public static <T extends TypeDescription> T isDefineable(T typeDescription) {
        if (typeDescription.isArray()) {
            throw new IllegalArgumentException("Cannot explicitly define an array type: " + typeDescription);
        }
        if (typeDescription.isPrimitive()) {
            throw new IllegalArgumentException("Cannot explicitly define a primitive type: " + typeDescription);
        }
        return typeDescription;
    }

    public static <T extends GenericTypeDescription> T isExtendable(T typeDescription) {
        if (!EXTENDABLE_TYPES.contains((Object)typeDescription.getSort())) {
            throw new IllegalArgumentException("Cannot extend generic type: " + typeDescription);
        }
        if (ByteBuddyCommons.isDefineable(typeDescription.asErasure()).isFinal()) {
            throw new IllegalArgumentException("Cannot extend a final type: " + typeDescription);
        }
        return typeDescription;
    }

    public static <T extends GenericTypeDescription> T isImplementable(T typeDescription) {
        if (!ByteBuddyCommons.isExtendable(typeDescription).asErasure().isInterface()) {
            throw new IllegalArgumentException("Not an interface: " + typeDescription);
        }
        return typeDescription;
    }

    public static <T extends Collection<? extends GenericTypeDescription>> T isImplementable(T typeDescriptions) {
        for (GenericTypeDescription typeDescription : typeDescriptions) {
            ByteBuddyCommons.isImplementable(typeDescription);
        }
        return typeDescriptions;
    }

    public static <T extends GenericTypeDescription> T isActualType(T typeDescription) {
        if (ByteBuddyCommons.isActualTypeOrVoid(typeDescription).represents(Void.TYPE)) {
            throw new IllegalArgumentException("The void non-type cannot be assigned a value");
        }
        return typeDescription;
    }

    public static <T extends Collection<? extends GenericTypeDescription>> T isActualType(T typeDescriptions) {
        for (GenericTypeDescription typeDescription : typeDescriptions) {
            ByteBuddyCommons.isActualType(typeDescription);
        }
        return typeDescriptions;
    }

    public static <T extends GenericTypeDescription> T isActualTypeOrVoid(T typeDescription) {
        if (typeDescription.getSort().isWildcard()) {
            throw new IllegalArgumentException("Not a top-level type: " + typeDescription);
        }
        return typeDescription;
    }

    public static <T extends Collection<? extends GenericTypeDescription>> T isActualTypeOrVoid(T typeDescriptions) {
        for (GenericTypeDescription typeDescription : typeDescriptions) {
            ByteBuddyCommons.isActualTypeOrVoid(typeDescription);
        }
        return typeDescriptions;
    }

    public static <T extends Collection<?>> T unique(T elements) {
        HashSet found = new HashSet(elements.size());
        for (Object element : elements) {
            if (found.add(element)) continue;
            throw new IllegalArgumentException("Duplicate element: " + element);
        }
        return elements;
    }

    public static <T> List<T> join(List<? extends T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list.size() + 1);
        result.addAll(list);
        result.add(element);
        return result;
    }

    public static <T> List<T> join(T element, List<? extends T> list) {
        ArrayList<T> result = new ArrayList<T>(list.size() + 1);
        result.add(element);
        result.addAll(list);
        return result;
    }

    public static <T> List<T> join(List<? extends T> leftList, List<? extends T> rightList) {
        ArrayList<T> result = new ArrayList<T>(leftList.size() + rightList.size());
        result.addAll(leftList);
        result.addAll(rightList);
        return result;
    }

    public static <T> List<T> filterUnique(List<? extends T> left, List<? extends T> right) {
        ArrayList<T> result = new ArrayList<T>(left.size() + right.size());
        result.addAll(left);
        for (T element : right) {
            if (result.contains(element)) continue;
            result.add(element);
        }
        return result;
    }

    public static <T> List<T> joinUnique(List<? extends T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list.size() + 1);
        for (T listElement : list) {
            if (listElement.equals(element)) {
                throw new IllegalArgumentException("Conflicting elements: " + listElement + " and " + element);
            }
            result.add(listElement);
        }
        result.add(element);
        return result;
    }

    public static <T extends Collection<? extends GenericTypeDescription>> T uniqueRaw(T typeDescriptions) {
        HashMap<TypeDescription, GenericTypeDescription> types = new HashMap<TypeDescription, GenericTypeDescription>(typeDescriptions.size());
        for (GenericTypeDescription typeDescription : typeDescriptions) {
            GenericTypeDescription conflictingType = types.put(typeDescription.asErasure(), typeDescription);
            if (conflictingType == null) continue;
            throw new IllegalArgumentException("Duplicate types: " + typeDescription + " and " + conflictingType);
        }
        return typeDescriptions;
    }

    public static <T extends GenericTypeDescription> List<T> joinUniqueRaw(Collection<? extends T> left, Collection<? extends T> right) {
        ArrayList<GenericTypeDescription> result = new ArrayList<GenericTypeDescription>(left.size() + right.size());
        HashMap<TypeDescription, GenericTypeDescription> types = new HashMap<TypeDescription, GenericTypeDescription>();
        for (GenericTypeDescription typeDescription : left) {
            types.put(typeDescription.asErasure(), typeDescription);
            result.add(typeDescription);
        }
        for (GenericTypeDescription typeDescription : right) {
            GenericTypeDescription conflictingType = types.put(typeDescription.asErasure(), typeDescription);
            if (conflictingType != null && !conflictingType.equals(typeDescription)) {
                throw new IllegalArgumentException("Conflicting type erasures: " + conflictingType + " and " + typeDescription);
            }
            if (conflictingType != null) continue;
            result.add(typeDescription);
        }
        return result;
    }

    public static String isValidIdentifier(String identifier) {
        if (JAVA_KEYWORDS.contains(ByteBuddyCommons.nonNull(identifier))) {
            throw new IllegalArgumentException("Keyword cannot be used as Java identifier: " + identifier);
        }
        if (identifier.isEmpty()) {
            throw new IllegalArgumentException("An empty string is not a valid Java identifier");
        }
        if (!Character.isJavaIdentifierStart(identifier.charAt(0))) {
            throw new IllegalArgumentException("Not a valid Java identifier: " + identifier);
        }
        for (char character : identifier.toCharArray()) {
            if (Character.isJavaIdentifierPart(character)) continue;
            throw new IllegalArgumentException("Not a valid Java identifier: " + identifier);
        }
        return identifier;
    }

    public static String isValidTypeName(String typeName) {
        String[] segments;
        for (String segment : segments = ByteBuddyCommons.nonNull(typeName).split("\\.")) {
            ByteBuddyCommons.isValidIdentifier(segment);
        }
        return typeName;
    }

    public static <T extends Collection<?>> T isNotEmpty(T collection, String exceptionMessage) {
        if (collection.size() == 0) {
            throw new IllegalArgumentException(exceptionMessage);
        }
        return collection;
    }

    public static <T extends Collection<?>> T isEmpty(T collection, String exceptionMessage) {
        if (collection.size() > 0) {
            throw new IllegalArgumentException(exceptionMessage);
        }
        return collection;
    }

    public static int resolveModifierContributors(int mask, ModifierContributor ... modifierContributor) {
        int modifiers = 0;
        HashSet modifierContributorTypes = new HashSet(modifierContributor.length);
        for (ModifierContributor contributor : modifierContributor) {
            if (!modifierContributorTypes.add(contributor.getClass())) {
                throw new IllegalArgumentException(contributor + " is already registered with a different value");
            }
            modifiers |= contributor.getMask();
        }
        if ((modifiers & ~(mask | 0x1000)) != 0) {
            throw new IllegalArgumentException("Illegal modifiers: " + Arrays.asList(modifierContributor));
        }
        return modifiers;
    }

    public static <T> List<T> toList(Collection<T> collection) {
        return collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection);
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return ByteBuddyCommons.toList((Collection)iterable);
        }
        LinkedList<T> list = new LinkedList<T>();
        for (T element : iterable) {
            list.add(element);
        }
        return list;
    }
}

