/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.jar.asm.ClassVisitor;

public interface ClassVisitorWrapper {
    public int mergeWriter(int var1);

    public int mergeReader(int var1);

    public ClassVisitor wrap(ClassVisitor var1);

    public static class Chain
    implements ClassVisitorWrapper {
        private final List<ClassVisitorWrapper> classVisitorWrappers;

        public Chain() {
            this.classVisitorWrappers = Collections.emptyList();
        }

        protected Chain(List<ClassVisitorWrapper> classVisitorWrappers) {
            this.classVisitorWrappers = classVisitorWrappers;
        }

        public Chain prepend(ClassVisitorWrapper classVisitorWrapper) {
            ArrayList<ClassVisitorWrapper> appendedList = new ArrayList<ClassVisitorWrapper>(this.classVisitorWrappers.size() + 1);
            appendedList.add(classVisitorWrapper);
            appendedList.addAll(this.classVisitorWrappers);
            return new Chain(appendedList);
        }

        public Chain append(ClassVisitorWrapper classVisitorWrapper) {
            ArrayList<ClassVisitorWrapper> appendedList = new ArrayList<ClassVisitorWrapper>(this.classVisitorWrappers.size() + 1);
            appendedList.addAll(this.classVisitorWrappers);
            appendedList.add(classVisitorWrapper);
            return new Chain(appendedList);
        }

        @Override
        public int mergeWriter(int hint) {
            for (ClassVisitorWrapper classVisitorWrapper : this.classVisitorWrappers) {
                hint = classVisitorWrapper.mergeWriter(hint);
            }
            return hint;
        }

        @Override
        public int mergeReader(int hint) {
            for (ClassVisitorWrapper classVisitorWrapper : this.classVisitorWrappers) {
                hint = classVisitorWrapper.mergeReader(hint);
            }
            return hint;
        }

        @Override
        public ClassVisitor wrap(ClassVisitor classVisitor) {
            for (ClassVisitorWrapper classVisitorWrapper : this.classVisitorWrappers) {
                classVisitor = classVisitorWrapper.wrap(classVisitor);
            }
            return classVisitor;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.classVisitorWrappers.equals(((Chain)other).classVisitorWrappers);
        }

        public int hashCode() {
            return this.classVisitorWrappers.hashCode();
        }

        public String toString() {
            return "ClassVisitorWrapper.Chain{classVisitorWrappers=" + this.classVisitorWrappers + '}';
        }
    }
}

