/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.agent.builder;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.inline.MethodRebaseResolver;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.ByteBuddyCommons;
import net.bytebuddy.utility.StreamDrainer;

public interface AgentBuilder {
    public Identified type(RawMatcher var1);

    public Identified type(ElementMatcher<? super TypeDescription> var1);

    public Identified type(ElementMatcher<? super TypeDescription> var1, ElementMatcher<? super ClassLoader> var2);

    public AgentBuilder withByteBuddy(ByteBuddy var1);

    public AgentBuilder withListener(Listener var1);

    public AgentBuilder withBinaryLocator(BinaryLocator var1);

    public AgentBuilder withTypeStrategy(TypeStrategy var1);

    public AgentBuilder withNativeMethodPrefix(String var1);

    public AgentBuilder withoutNativeMethodPrefix();

    public AgentBuilder withAccessControlContext(AccessControlContext var1);

    public AgentBuilder withInitializationStrategy(InitializationStrategy var1);

    public AgentBuilder withRedefinitionStrategy(RedefinitionStrategy var1);

    public AgentBuilder enableBootstrapInjection(File var1, Instrumentation var2);

    public AgentBuilder disableBootstrapInjection();

    public ClassFileTransformer makeRaw();

    public ClassFileTransformer installOn(Instrumentation var1);

    public ClassFileTransformer installOnByteBuddyAgent();

    public static class Default
    implements AgentBuilder {
        private static final String BYTE_BUDDY_AGENT_TYPE = "net.bytebuddy.agent.ByteBuddyAgent";
        private static final String GET_INSTRUMENTATION_METHOD = "getInstrumentation";
        private static final Object STATIC_METHOD = null;
        private static final byte[] NO_TRANSFORMATION = null;
        private final ByteBuddy byteBuddy;
        private final BinaryLocator binaryLocator;
        private final TypeStrategy typeStrategy;
        private final Listener listener;
        private final NativeMethodStrategy nativeMethodStrategy;
        private final AccessControlContext accessControlContext;
        private final InitializationStrategy initializationStrategy;
        private final RedefinitionStrategy redefinitionStrategy;
        private final BootstrapInjectionStrategy bootstrapInjectionStrategy;
        private final Transformation transformation;

        public Default() {
            this(new ByteBuddy());
        }

        public Default(ByteBuddy byteBuddy) {
            this(ByteBuddyCommons.nonNull(byteBuddy), BinaryLocator.Default.FAST, TypeStrategy.Default.REBASE, Listener.NoOp.INSTANCE, NativeMethodStrategy.Disabled.INSTANCE, AccessController.getContext(), InitializationStrategy.SelfInjection.INSTANCE, RedefinitionStrategy.DISABLED, BootstrapInjectionStrategy.Disabled.INSTANCE, Transformation.Ignored.INSTANCE);
        }

        protected Default(ByteBuddy byteBuddy, BinaryLocator binaryLocator, TypeStrategy typeStrategy, Listener listener, NativeMethodStrategy nativeMethodStrategy, AccessControlContext accessControlContext, InitializationStrategy initializationStrategy, RedefinitionStrategy redefinitionStrategy, BootstrapInjectionStrategy bootstrapInjectionStrategy, Transformation transformation) {
            this.byteBuddy = byteBuddy;
            this.binaryLocator = binaryLocator;
            this.typeStrategy = typeStrategy;
            this.listener = listener;
            this.nativeMethodStrategy = nativeMethodStrategy;
            this.accessControlContext = accessControlContext;
            this.initializationStrategy = initializationStrategy;
            this.redefinitionStrategy = redefinitionStrategy;
            this.bootstrapInjectionStrategy = bootstrapInjectionStrategy;
            this.transformation = transformation;
        }

        @Override
        public Identified type(RawMatcher matcher) {
            return new Matched(ByteBuddyCommons.nonNull(matcher), Transformer.NoOp.INSTANCE);
        }

        @Override
        public Identified type(ElementMatcher<? super TypeDescription> typeMatcher) {
            return this.type(typeMatcher, ElementMatchers.any());
        }

        @Override
        public Identified type(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher) {
            return this.type(new RawMatcher.ForElementMatcherPair(ByteBuddyCommons.nonNull(typeMatcher), ByteBuddyCommons.nonNull(classLoaderMatcher)));
        }

        @Override
        public AgentBuilder withByteBuddy(ByteBuddy byteBuddy) {
            return new Default(ByteBuddyCommons.nonNull(byteBuddy), this.binaryLocator, this.typeStrategy, this.listener, this.nativeMethodStrategy, this.accessControlContext, this.initializationStrategy, this.redefinitionStrategy, this.bootstrapInjectionStrategy, this.transformation);
        }

        @Override
        public AgentBuilder withListener(Listener listener) {
            return new Default(this.byteBuddy, this.binaryLocator, this.typeStrategy, new Listener.Compound(this.listener, ByteBuddyCommons.nonNull(listener)), this.nativeMethodStrategy, this.accessControlContext, this.initializationStrategy, this.redefinitionStrategy, this.bootstrapInjectionStrategy, this.transformation);
        }

        @Override
        public AgentBuilder withTypeStrategy(TypeStrategy typeStrategy) {
            return new Default(this.byteBuddy, this.binaryLocator, ByteBuddyCommons.nonNull(typeStrategy), this.listener, this.nativeMethodStrategy, this.accessControlContext, this.initializationStrategy, this.redefinitionStrategy, this.bootstrapInjectionStrategy, this.transformation);
        }

        @Override
        public AgentBuilder withBinaryLocator(BinaryLocator binaryLocator) {
            return new Default(this.byteBuddy, ByteBuddyCommons.nonNull(binaryLocator), this.typeStrategy, this.listener, this.nativeMethodStrategy, this.accessControlContext, this.initializationStrategy, this.redefinitionStrategy, this.bootstrapInjectionStrategy, this.transformation);
        }

        @Override
        public AgentBuilder withNativeMethodPrefix(String prefix) {
            return new Default(this.byteBuddy, this.binaryLocator, this.typeStrategy, this.listener, NativeMethodStrategy.ForPrefix.of(prefix), this.accessControlContext, this.initializationStrategy, this.redefinitionStrategy, this.bootstrapInjectionStrategy, this.transformation);
        }

        @Override
        public AgentBuilder withoutNativeMethodPrefix() {
            return new Default(this.byteBuddy, this.binaryLocator, this.typeStrategy, this.listener, NativeMethodStrategy.Disabled.INSTANCE, this.accessControlContext, this.initializationStrategy, this.redefinitionStrategy, this.bootstrapInjectionStrategy, this.transformation);
        }

        @Override
        public AgentBuilder withAccessControlContext(AccessControlContext accessControlContext) {
            return new Default(this.byteBuddy, this.binaryLocator, this.typeStrategy, this.listener, this.nativeMethodStrategy, accessControlContext, this.initializationStrategy, this.redefinitionStrategy, this.bootstrapInjectionStrategy, this.transformation);
        }

        @Override
        public AgentBuilder withRedefinitionStrategy(RedefinitionStrategy redefinitionStrategy) {
            return new Default(this.byteBuddy, this.binaryLocator, this.typeStrategy, this.listener, this.nativeMethodStrategy, this.accessControlContext, this.initializationStrategy, ByteBuddyCommons.nonNull(redefinitionStrategy), this.bootstrapInjectionStrategy, this.transformation);
        }

        @Override
        public AgentBuilder withInitializationStrategy(InitializationStrategy initializationStrategy) {
            return new Default(this.byteBuddy, this.binaryLocator, this.typeStrategy, this.listener, this.nativeMethodStrategy, this.accessControlContext, ByteBuddyCommons.nonNull(initializationStrategy), this.redefinitionStrategy, this.bootstrapInjectionStrategy, this.transformation);
        }

        @Override
        public AgentBuilder enableBootstrapInjection(File folder, Instrumentation instrumentation) {
            return new Default(this.byteBuddy, this.binaryLocator, this.typeStrategy, this.listener, this.nativeMethodStrategy, this.accessControlContext, this.initializationStrategy, this.redefinitionStrategy, new BootstrapInjectionStrategy.Enabled(ByteBuddyCommons.nonNull(folder), ByteBuddyCommons.nonNull(instrumentation)), this.transformation);
        }

        @Override
        public AgentBuilder disableBootstrapInjection() {
            return new Default(this.byteBuddy, this.binaryLocator, this.typeStrategy, this.listener, this.nativeMethodStrategy, this.accessControlContext, this.initializationStrategy, this.redefinitionStrategy, BootstrapInjectionStrategy.Disabled.INSTANCE, this.transformation);
        }

        @Override
        public ClassFileTransformer makeRaw() {
            return new ExecutingTransformer(this.byteBuddy, this.binaryLocator, this.typeStrategy, this.listener, this.nativeMethodStrategy, this.accessControlContext, this.initializationStrategy, this.bootstrapInjectionStrategy, this.transformation);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClassFileTransformer installOn(Instrumentation instrumentation) {
            ClassFileTransformer classFileTransformer = this.makeRaw();
            instrumentation.addTransformer(classFileTransformer, this.redefinitionStrategy.isRetransforming(instrumentation));
            if (this.nativeMethodStrategy.isEnabled(instrumentation)) {
                instrumentation.setNativeMethodPrefix(classFileTransformer, this.nativeMethodStrategy.getPrefix());
            }
            if (this.redefinitionStrategy.isEnabled()) {
                RedefinitionStrategy.Collector collector = this.redefinitionStrategy.makeCollector(this.transformation);
                for (Class type : instrumentation.getAllLoadedClasses()) {
                    try {
                        if (instrumentation.isModifiableClass(type) && collector.consider(type)) continue;
                        try {
                            try {
                                this.listener.onIgnored(new TypeDescription.ForLoadedType(type));
                            }
                            finally {
                                this.listener.onComplete(type.getName());
                            }
                        }
                        catch (Throwable ignored) {}
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                this.listener.onError(type.getName(), throwable);
                            }
                            finally {
                                this.listener.onComplete(type.getName());
                            }
                        }
                        catch (Throwable ignored) {
                            // empty catch block
                        }
                    }
                }
                try {
                    collector.apply(instrumentation, this.byteBuddy, this.binaryLocator, this.typeStrategy, this.listener, this.nativeMethodStrategy, this.accessControlContext, this.initializationStrategy, this.bootstrapInjectionStrategy);
                }
                catch (UnmodifiableClassException exception) {
                    throw new IllegalStateException("Cannot modify at least one class: " + collector, exception);
                }
                catch (ClassNotFoundException exception) {
                    throw new IllegalStateException("Cannot find at least one class class: " + collector, exception);
                }
            }
            return classFileTransformer;
        }

        @Override
        public ClassFileTransformer installOnByteBuddyAgent() {
            try {
                return this.installOn((Instrumentation)ClassLoader.getSystemClassLoader().loadClass(BYTE_BUDDY_AGENT_TYPE).getDeclaredMethod(GET_INSTRUMENTATION_METHOD, new Class[0]).invoke(STATIC_METHOD, new Object[0]));
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", exception);
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Default aDefault = (Default)other;
            return this.binaryLocator.equals(aDefault.binaryLocator) && this.byteBuddy.equals(aDefault.byteBuddy) && this.listener.equals(aDefault.listener) && this.nativeMethodStrategy.equals(aDefault.nativeMethodStrategy) && this.typeStrategy.equals(aDefault.typeStrategy) && this.accessControlContext.equals(aDefault.accessControlContext) && this.initializationStrategy == aDefault.initializationStrategy && this.redefinitionStrategy == aDefault.redefinitionStrategy && this.bootstrapInjectionStrategy.equals(aDefault.bootstrapInjectionStrategy) && this.transformation.equals(aDefault.transformation);
        }

        public int hashCode() {
            int result = this.byteBuddy.hashCode();
            result = 31 * result + this.binaryLocator.hashCode();
            result = 31 * result + this.listener.hashCode();
            result = 31 * result + this.typeStrategy.hashCode();
            result = 31 * result + this.nativeMethodStrategy.hashCode();
            result = 31 * result + this.accessControlContext.hashCode();
            result = 31 * result + this.initializationStrategy.hashCode();
            result = 31 * result + this.redefinitionStrategy.hashCode();
            result = 31 * result + this.bootstrapInjectionStrategy.hashCode();
            result = 31 * result + this.transformation.hashCode();
            return result;
        }

        public String toString() {
            return "AgentBuilder.Default{byteBuddy=" + this.byteBuddy + ", binaryLocator=" + this.binaryLocator + ", typeStrategy=" + this.typeStrategy + ", listener=" + this.listener + ", nativeMethodStrategy=" + this.nativeMethodStrategy + ", accessControlContext=" + this.accessControlContext + ", initializationStrategy=" + this.initializationStrategy + ", redefinitionStrategy=" + (Object)((Object)this.redefinitionStrategy) + ", bootstrapInjectionStrategy=" + this.bootstrapInjectionStrategy + ", transformation=" + this.transformation + '}';
        }

        protected class Matched
        implements Identified.Extendable {
            private final RawMatcher rawMatcher;
            private final Transformer transformer;

            protected Matched(RawMatcher rawMatcher, Transformer transformer) {
                this.rawMatcher = rawMatcher;
                this.transformer = transformer;
            }

            @Override
            public Identified.Extendable transform(Transformer transformer) {
                return new Matched(this.rawMatcher, new Transformer.Compound(this.transformer, ByteBuddyCommons.nonNull(transformer)));
            }

            @Override
            public Identified type(RawMatcher matcher) {
                return this.materialize().type(matcher);
            }

            @Override
            public Identified type(ElementMatcher<? super TypeDescription> typeMatcher) {
                return this.materialize().type(typeMatcher);
            }

            @Override
            public Identified type(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher) {
                return this.materialize().type(typeMatcher, classLoaderMatcher);
            }

            @Override
            public AgentBuilder withByteBuddy(ByteBuddy byteBuddy) {
                return this.materialize().withByteBuddy(byteBuddy);
            }

            @Override
            public AgentBuilder withListener(Listener listener) {
                return this.materialize().withListener(listener);
            }

            @Override
            public AgentBuilder withTypeStrategy(TypeStrategy typeStrategy) {
                return this.materialize().withTypeStrategy(typeStrategy);
            }

            @Override
            public AgentBuilder withBinaryLocator(BinaryLocator binaryLocator) {
                return this.materialize().withBinaryLocator(binaryLocator);
            }

            @Override
            public AgentBuilder withNativeMethodPrefix(String prefix) {
                return this.materialize().withNativeMethodPrefix(prefix);
            }

            @Override
            public AgentBuilder withoutNativeMethodPrefix() {
                return this.materialize().withoutNativeMethodPrefix();
            }

            @Override
            public AgentBuilder withAccessControlContext(AccessControlContext accessControlContext) {
                return this.materialize().withAccessControlContext(accessControlContext);
            }

            @Override
            public AgentBuilder withInitializationStrategy(InitializationStrategy initializationStrategy) {
                return this.materialize().withInitializationStrategy(initializationStrategy);
            }

            @Override
            public AgentBuilder withRedefinitionStrategy(RedefinitionStrategy redefinitionStrategy) {
                return this.materialize().withRedefinitionStrategy(redefinitionStrategy);
            }

            @Override
            public AgentBuilder enableBootstrapInjection(File folder, Instrumentation instrumentation) {
                return this.materialize().enableBootstrapInjection(folder, instrumentation);
            }

            @Override
            public AgentBuilder disableBootstrapInjection() {
                return this.materialize().disableBootstrapInjection();
            }

            @Override
            public ClassFileTransformer makeRaw() {
                return this.materialize().makeRaw();
            }

            @Override
            public ClassFileTransformer installOn(Instrumentation instrumentation) {
                return this.materialize().installOn(instrumentation);
            }

            @Override
            public ClassFileTransformer installOnByteBuddyAgent() {
                return this.materialize().installOnByteBuddyAgent();
            }

            protected AgentBuilder materialize() {
                return new Default(Default.this.byteBuddy, Default.this.binaryLocator, Default.this.typeStrategy, Default.this.listener, Default.this.nativeMethodStrategy, Default.this.accessControlContext, Default.this.initializationStrategy, Default.this.redefinitionStrategy, Default.this.bootstrapInjectionStrategy, new Transformation.Compound(new Transformation.Simple(this.rawMatcher, this.transformer), Default.this.transformation));
            }

            private Default getOuter() {
                return Default.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.rawMatcher.equals(((Matched)other).rawMatcher) && this.transformer.equals(((Matched)other).transformer) && Default.this.equals(((Matched)other).getOuter());
            }

            public int hashCode() {
                int result = this.rawMatcher.hashCode();
                result = 31 * result + this.transformer.hashCode();
                result = 31 * result + Default.this.hashCode();
                return result;
            }

            public String toString() {
                return "AgentBuilder.Default.Matched{rawMatcher=" + this.rawMatcher + ", transformer=" + this.transformer + ", agentBuilder=" + Default.this + '}';
            }
        }

        protected static class ExecutingTransformer
        implements ClassFileTransformer {
            private final ByteBuddy byteBuddy;
            private final BinaryLocator binaryLocator;
            private final TypeStrategy typeStrategy;
            private final Listener listener;
            private final NativeMethodStrategy nativeMethodStrategy;
            private final AccessControlContext accessControlContext;
            private final InitializationStrategy initializationStrategy;
            private final BootstrapInjectionStrategy bootstrapInjectionStrategy;
            private final Transformation transformation;

            public ExecutingTransformer(ByteBuddy byteBuddy, BinaryLocator binaryLocator, TypeStrategy typeStrategy, Listener listener, NativeMethodStrategy nativeMethodStrategy, AccessControlContext accessControlContext, InitializationStrategy initializationStrategy, BootstrapInjectionStrategy bootstrapInjectionStrategy, Transformation transformation) {
                this.binaryLocator = binaryLocator;
                this.initializationStrategy = initializationStrategy;
                this.typeStrategy = typeStrategy;
                this.byteBuddy = byteBuddy;
                this.nativeMethodStrategy = nativeMethodStrategy;
                this.bootstrapInjectionStrategy = bootstrapInjectionStrategy;
                this.accessControlContext = accessControlContext;
                this.listener = listener;
                this.transformation = transformation;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] transform(ClassLoader classLoader, String internalTypeName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] binaryRepresentation) {
                String binaryTypeName = internalTypeName.replace('/', '.');
                try {
                    InstrumentedTypeLocator classFileLocator = new InstrumentedTypeLocator(this.binaryLocator.classFileLocator(classLoader), binaryTypeName, binaryRepresentation);
                    byte[] byArray = this.transformation.resolve(classBeingRedefined == null ? this.binaryLocator.typePool(classFileLocator).describe(binaryTypeName).resolve() : new TypeDescription.ForLoadedType(classBeingRedefined), classLoader, classBeingRedefined, protectionDomain).apply(this.initializationStrategy, classFileLocator, this.typeStrategy, this.byteBuddy, this.nativeMethodStrategy.resolve(), this.bootstrapInjectionStrategy, this.accessControlContext, this.listener);
                    return byArray;
                }
                catch (Throwable throwable) {
                    this.listener.onError(binaryTypeName, throwable);
                    byte[] byArray = NO_TRANSFORMATION;
                    return byArray;
                }
                finally {
                    this.listener.onComplete(binaryTypeName);
                }
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                ExecutingTransformer that = (ExecutingTransformer)other;
                return this.byteBuddy.equals(that.byteBuddy) && this.binaryLocator.equals(that.binaryLocator) && this.typeStrategy.equals(that.typeStrategy) && this.initializationStrategy.equals(that.initializationStrategy) && this.listener.equals(that.listener) && this.nativeMethodStrategy.equals(that.nativeMethodStrategy) && this.bootstrapInjectionStrategy.equals(that.bootstrapInjectionStrategy) && this.accessControlContext.equals(that.accessControlContext) && this.transformation.equals(that.transformation);
            }

            public int hashCode() {
                int result = this.byteBuddy.hashCode();
                result = 31 * result + this.binaryLocator.hashCode();
                result = 31 * result + this.typeStrategy.hashCode();
                result = 31 * result + this.initializationStrategy.hashCode();
                result = 31 * result + this.listener.hashCode();
                result = 31 * result + this.nativeMethodStrategy.hashCode();
                result = 31 * result + this.bootstrapInjectionStrategy.hashCode();
                result = 31 * result + this.accessControlContext.hashCode();
                result = 31 * result + this.transformation.hashCode();
                return result;
            }

            public String toString() {
                return "AgentBuilder.Default.ExecutingTransformer{byteBuddy=" + this.byteBuddy + ", binaryLocator=" + this.binaryLocator + ", typeStrategy=" + this.typeStrategy + ", initializationStrategy=" + this.initializationStrategy + ", listener=" + this.listener + ", nativeMethodStrategy=" + this.nativeMethodStrategy + ", bootstrapInjectionStrategy=" + this.bootstrapInjectionStrategy + ", accessControlContext=" + this.accessControlContext + ", transformation=" + this.transformation + '}';
            }

            protected static class InstrumentedTypeLocator
            implements ClassFileLocator {
                private final ClassFileLocator delegate;
                private final String typeName;
                private final byte[] binaryRepresentation;

                @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="The received value is never modified by contract")
                protected InstrumentedTypeLocator(ClassFileLocator delegate, String typeName, byte[] binaryRepresentation) {
                    this.delegate = delegate;
                    this.typeName = typeName;
                    this.binaryRepresentation = binaryRepresentation;
                }

                @Override
                public ClassFileLocator.Resolution locate(String typeName) throws IOException {
                    return typeName.equals(this.typeName) ? new ClassFileLocator.Resolution.Explicit(this.binaryRepresentation) : this.delegate.locate(typeName);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    InstrumentedTypeLocator that = (InstrumentedTypeLocator)other;
                    return this.delegate.equals(that.delegate) && this.typeName.equals(that.typeName) && Arrays.equals(this.binaryRepresentation, that.binaryRepresentation);
                }

                public int hashCode() {
                    int result = this.delegate.hashCode();
                    result = 31 * result + this.typeName.hashCode();
                    result = 31 * result + Arrays.hashCode(this.binaryRepresentation);
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.Default.ExecutingTransformer.InstrumentedTypeLocator{delegate=" + this.delegate + ", typeName='" + this.typeName + '\'' + ", binaryRepresentation=<" + this.binaryRepresentation.length + " bytes>" + '}';
                }
            }
        }

        protected static interface Transformation {
            public Resolution resolve(TypeDescription var1, ClassLoader var2, Class<?> var3, ProtectionDomain var4);

            public static class Compound
            implements Transformation {
                private final List<? extends Transformation> transformations;

                protected Compound(Transformation ... transformation) {
                    this(Arrays.asList(transformation));
                }

                protected Compound(List<? extends Transformation> transformations) {
                    this.transformations = transformations;
                }

                @Override
                public Resolution resolve(TypeDescription typeDescription, ClassLoader classLoader, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                    for (Transformation transformation : this.transformations) {
                        Resolution resolution = transformation.resolve(typeDescription, classLoader, classBeingRedefined, protectionDomain);
                        if (!resolution.isResolved()) continue;
                        return resolution;
                    }
                    return new Resolution.Unresolved(typeDescription);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.transformations.equals(((Compound)other).transformations);
                }

                public int hashCode() {
                    return this.transformations.hashCode();
                }

                public String toString() {
                    return "AgentBuilder.Default.Transformation.Compound{transformations=" + this.transformations + '}';
                }
            }

            public static class Simple
            implements Transformation {
                private final RawMatcher rawMatcher;
                private final Transformer transformer;

                protected Simple(RawMatcher rawMatcher, Transformer transformer) {
                    this.rawMatcher = rawMatcher;
                    this.transformer = transformer;
                }

                @Override
                public net.bytebuddy.agent.builder.AgentBuilder$Default$Transformation$Resolution resolve(TypeDescription typeDescription, ClassLoader classLoader, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                    return this.rawMatcher.matches(typeDescription, classLoader, classBeingRedefined, protectionDomain) ? new Resolution(typeDescription, classLoader, protectionDomain, this.transformer) : new Resolution.Unresolved(typeDescription);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.rawMatcher.equals(((Simple)other).rawMatcher) && this.transformer.equals(((Simple)other).transformer);
                }

                public int hashCode() {
                    int result = this.rawMatcher.hashCode();
                    result = 31 * result + this.transformer.hashCode();
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.Default.Transformation.Simple{rawMatcher=" + this.rawMatcher + ", transformer=" + this.transformer + '}';
                }

                protected static class Resolution
                implements net.bytebuddy.agent.builder.AgentBuilder$Default$Transformation$Resolution {
                    private final TypeDescription typeDescription;
                    private final ClassLoader classLoader;
                    private final ProtectionDomain protectionDomain;
                    private final Transformer transformer;

                    protected Resolution(TypeDescription typeDescription, ClassLoader classLoader, ProtectionDomain protectionDomain, Transformer transformer) {
                        this.typeDescription = typeDescription;
                        this.classLoader = classLoader;
                        this.protectionDomain = protectionDomain;
                        this.transformer = transformer;
                    }

                    @Override
                    public boolean isResolved() {
                        return true;
                    }

                    @Override
                    public byte[] apply(InitializationStrategy initializationStrategy, ClassFileLocator classFileLocator, TypeStrategy typeStrategy, ByteBuddy byteBuddy, MethodRebaseResolver.MethodNameTransformer methodNameTransformer, BootstrapInjectionStrategy bootstrapInjectionStrategy, AccessControlContext accessControlContext, Listener listener) {
                        DynamicType.Unloaded<?> dynamicType = initializationStrategy.apply(this.transformer.transform(typeStrategy.builder(this.typeDescription, byteBuddy, classFileLocator, methodNameTransformer), this.typeDescription)).make();
                        Map<TypeDescription, LoadedTypeInitializer> loadedTypeInitializers = dynamicType.getLoadedTypeInitializers();
                        if (loadedTypeInitializers.size() > 1) {
                            ClassInjector classInjector = this.classLoader == null ? bootstrapInjectionStrategy.make(this.protectionDomain) : new ClassInjector.UsingReflection(this.classLoader, this.protectionDomain, accessControlContext);
                            for (Map.Entry<TypeDescription, Class<?>> auxiliary : classInjector.inject(dynamicType.getRawAuxiliaryTypes()).entrySet()) {
                                initializationStrategy.initialize(auxiliary.getValue(), loadedTypeInitializers.get(auxiliary.getKey()));
                            }
                        }
                        initializationStrategy.register(this.typeDescription.getName(), this.classLoader, loadedTypeInitializers.get(dynamicType.getTypeDescription()));
                        listener.onTransformation(this.typeDescription, dynamicType);
                        return dynamicType.getBytes();
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        Resolution that = (Resolution)other;
                        return this.typeDescription.equals(that.typeDescription) && !(this.classLoader == null ? that.classLoader != null : !this.classLoader.equals(that.classLoader)) && !(this.protectionDomain == null ? that.protectionDomain != null : !this.protectionDomain.equals(that.protectionDomain)) && this.transformer.equals(that.transformer);
                    }

                    public int hashCode() {
                        int result = this.typeDescription.hashCode();
                        result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
                        result = 31 * result + (this.protectionDomain != null ? this.protectionDomain.hashCode() : 0);
                        result = 31 * result + this.transformer.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "AgentBuilder.Default.Transformation.Simple.Resolution{typeDescription=" + this.typeDescription + ", classLoader=" + this.classLoader + ", protectionDomain=" + this.protectionDomain + ", transformer=" + this.transformer + '}';
                    }
                }
            }

            public static enum Ignored implements Transformation
            {
                INSTANCE;


                @Override
                public Resolution resolve(TypeDescription typeDescription, ClassLoader classLoader, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                    return new Resolution.Unresolved(typeDescription);
                }

                public String toString() {
                    return "AgentBuilder.Default.Transformation.Ignored." + this.name();
                }
            }

            public static interface Resolution {
                public boolean isResolved();

                public byte[] apply(InitializationStrategy var1, ClassFileLocator var2, TypeStrategy var3, ByteBuddy var4, MethodRebaseResolver.MethodNameTransformer var5, BootstrapInjectionStrategy var6, AccessControlContext var7, Listener var8);

                public static class Unresolved
                implements Resolution {
                    private final TypeDescription typeDescription;

                    protected Unresolved(TypeDescription typeDescription) {
                        this.typeDescription = typeDescription;
                    }

                    @Override
                    public boolean isResolved() {
                        return false;
                    }

                    @Override
                    public byte[] apply(InitializationStrategy initializationStrategy, ClassFileLocator classFileLocator, TypeStrategy typeStrategy, ByteBuddy byteBuddy, MethodRebaseResolver.MethodNameTransformer methodNameTransformer, BootstrapInjectionStrategy bootstrapInjectionStrategy, AccessControlContext accessControlContext, Listener listener) {
                        listener.onIgnored(this.typeDescription);
                        return NO_TRANSFORMATION;
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((Unresolved)other).typeDescription);
                    }

                    public int hashCode() {
                        return this.typeDescription.hashCode();
                    }

                    public String toString() {
                        return "AgentBuilder.Default.Transformation.Resolution.Unresolved{typeDescription=" + this.typeDescription + '}';
                    }
                }
            }
        }

        protected static interface NativeMethodStrategy {
            public boolean isEnabled(Instrumentation var1);

            public MethodRebaseResolver.MethodNameTransformer resolve();

            public String getPrefix();

            public static class ForPrefix
            implements NativeMethodStrategy {
                private final String prefix;

                protected ForPrefix(String prefix) {
                    this.prefix = prefix;
                }

                protected static NativeMethodStrategy of(String prefix) {
                    if (prefix.length() == 0) {
                        throw new IllegalArgumentException("A method name prefix must not be the empty string");
                    }
                    return new ForPrefix(prefix);
                }

                @Override
                public MethodRebaseResolver.MethodNameTransformer resolve() {
                    return new MethodRebaseResolver.MethodNameTransformer.Prefixing(this.prefix);
                }

                @Override
                public boolean isEnabled(Instrumentation instrumentation) {
                    if (!instrumentation.isNativeMethodPrefixSupported()) {
                        throw new IllegalArgumentException("A prefix for native methods is not supported: " + instrumentation);
                    }
                    return true;
                }

                @Override
                public String getPrefix() {
                    return this.prefix;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.prefix.equals(((ForPrefix)other).prefix);
                }

                public int hashCode() {
                    return this.prefix.hashCode();
                }

                public String toString() {
                    return "AgentBuilder.Default.NativeMethodStrategy.ForPrefix{prefix='" + this.prefix + '\'' + '}';
                }
            }

            public static enum Disabled implements NativeMethodStrategy
            {
                INSTANCE;


                @Override
                public MethodRebaseResolver.MethodNameTransformer resolve() {
                    return MethodRebaseResolver.MethodNameTransformer.Suffixing.withRandomSuffix();
                }

                @Override
                public boolean isEnabled(Instrumentation instrumentation) {
                    return false;
                }

                @Override
                public String getPrefix() {
                    throw new IllegalStateException("A disabled native method strategy does not define a method name prefix");
                }

                public String toString() {
                    return "AgentBuilder.Default.NativeMethodStrategy.Disabled." + this.name();
                }
            }
        }

        protected static interface BootstrapInjectionStrategy {
            public ClassInjector make(ProtectionDomain var1);

            public static class Enabled
            implements BootstrapInjectionStrategy {
                private final File folder;
                private final Instrumentation instrumentation;

                public Enabled(File folder, Instrumentation instrumentation) {
                    this.folder = folder;
                    this.instrumentation = instrumentation;
                }

                @Override
                public ClassInjector make(ProtectionDomain protectionDomain) {
                    return ClassInjector.UsingInstrumentation.of(this.folder, ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, this.instrumentation);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Enabled enabled = (Enabled)other;
                    return this.folder.equals(enabled.folder) && this.instrumentation.equals(enabled.instrumentation);
                }

                public int hashCode() {
                    int result = this.folder.hashCode();
                    result = 31 * result + this.instrumentation.hashCode();
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.Default.BootstrapInjectionStrategy.Enabled{folder=" + this.folder + ", instrumentation=" + this.instrumentation + '}';
                }
            }

            public static enum Disabled implements BootstrapInjectionStrategy
            {
                INSTANCE;


                @Override
                public ClassInjector make(ProtectionDomain protectionDomain) {
                    throw new IllegalStateException("Injecting classes into the bootstrap class loader was not enabled");
                }

                public String toString() {
                    return "AgentBuilder.Default.BootstrapInjectionStrategy.Disabled." + this.name();
                }
            }
        }
    }

    public static enum RedefinitionStrategy {
        DISABLED{

            @Override
            protected boolean isRetransforming(Instrumentation instrumentation) {
                return false;
            }

            @Override
            protected Collector makeCollector(Default.Transformation transformation) {
                throw new IllegalStateException("A disabled redefinition strategy cannot create a collector");
            }
        }
        ,
        REDEFINITION{

            @Override
            protected boolean isRetransforming(Instrumentation instrumentation) {
                if (!instrumentation.isRedefineClassesSupported()) {
                    throw new IllegalArgumentException("Cannot redefine classes: " + instrumentation);
                }
                return false;
            }

            @Override
            protected Collector makeCollector(Default.Transformation transformation) {
                return new Collector.ForRedefinition(transformation);
            }
        }
        ,
        RETRANSFORMATION{

            @Override
            protected boolean isRetransforming(Instrumentation instrumentation) {
                if (!instrumentation.isRetransformClassesSupported()) {
                    throw new IllegalArgumentException("Cannot retransform classes: " + instrumentation);
                }
                return true;
            }

            @Override
            protected Collector makeCollector(Default.Transformation transformation) {
                return new Collector.ForRetransformation(transformation);
            }
        };


        protected abstract boolean isRetransforming(Instrumentation var1);

        protected boolean isEnabled() {
            return this != DISABLED;
        }

        protected abstract Collector makeCollector(Default.Transformation var1);

        public String toString() {
            return "AgentBuilder.RedefinitionStrategy." + this.name();
        }

        protected static interface Collector {
            public boolean consider(Class<?> var1);

            public void apply(Instrumentation var1, ByteBuddy var2, BinaryLocator var3, TypeStrategy var4, Listener var5, Default.NativeMethodStrategy var6, AccessControlContext var7, InitializationStrategy var8, Default.BootstrapInjectionStrategy var9) throws UnmodifiableClassException, ClassNotFoundException;

            public static class ForRetransformation
            implements Collector {
                private final Default.Transformation transformation;
                private final List<Class<?>> types;

                protected ForRetransformation(Default.Transformation transformation) {
                    this.transformation = transformation;
                    this.types = new LinkedList();
                }

                @Override
                public boolean consider(Class<?> type) {
                    return this.transformation.resolve(new TypeDescription.ForLoadedType(type), type.getClassLoader(), type, type.getProtectionDomain()).isResolved() && this.types.add(type);
                }

                @Override
                public void apply(Instrumentation instrumentation, ByteBuddy byteBuddy, BinaryLocator binaryLocator, TypeStrategy typeStrategy, Listener listener, Default.NativeMethodStrategy nativeMethodStrategy, AccessControlContext accessControlContext, InitializationStrategy initializationStrategy, Default.BootstrapInjectionStrategy bootstrapInjectionStrategy) throws UnmodifiableClassException {
                    if (!this.types.isEmpty()) {
                        instrumentation.retransformClasses(this.types.toArray(new Class[this.types.size()]));
                    }
                }

                public String toString() {
                    return "AgentBuilder.RedefinitionStrategy.Collector.ForRetransformation{transformation=" + this.transformation + ", types=" + this.types + '}';
                }
            }

            public static class ForRedefinition
            implements Collector {
                private final Default.Transformation transformation;
                private final List<Entry> entries;

                protected ForRedefinition(Default.Transformation transformation) {
                    this.transformation = transformation;
                    this.entries = new LinkedList<Entry>();
                }

                @Override
                public boolean consider(Class<?> type) {
                    Default.Transformation.Resolution resolution = this.transformation.resolve(new TypeDescription.ForLoadedType(type), type.getClassLoader(), type, type.getProtectionDomain());
                    return resolution.isResolved() && this.entries.add(new Entry(type, resolution));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void apply(Instrumentation instrumentation, ByteBuddy byteBuddy, BinaryLocator binaryLocator, TypeStrategy typeStrategy, Listener listener, Default.NativeMethodStrategy nativeMethodStrategy, AccessControlContext accessControlContext, InitializationStrategy initializationStrategy, Default.BootstrapInjectionStrategy bootstrapInjectionStrategy) throws UnmodifiableClassException, ClassNotFoundException {
                    ArrayList<ClassDefinition> classDefinitions = new ArrayList<ClassDefinition>(this.entries.size());
                    for (Entry entry : this.entries) {
                        try {
                            classDefinitions.add(entry.resolve(initializationStrategy, binaryLocator.classFileLocator(entry.getType().getClassLoader()), typeStrategy, byteBuddy, nativeMethodStrategy.resolve(), bootstrapInjectionStrategy, accessControlContext, listener));
                        }
                        catch (Throwable throwable) {
                            listener.onError(entry.getType().getName(), throwable);
                        }
                        finally {
                            listener.onComplete(entry.getType().getName());
                        }
                    }
                    if (!classDefinitions.isEmpty()) {
                        instrumentation.redefineClasses(classDefinitions.toArray(new ClassDefinition[classDefinitions.size()]));
                    }
                }

                public String toString() {
                    return "AgentBuilder.RedefinitionStrategy.Collector.ForRedefinition{transformation=" + this.transformation + ", entries=" + this.entries + '}';
                }

                protected static class Entry {
                    private final Class<?> type;
                    private final Default.Transformation.Resolution resolution;

                    protected Entry(Class<?> type, Default.Transformation.Resolution resolution) {
                        this.type = type;
                        this.resolution = resolution;
                    }

                    public Class<?> getType() {
                        return this.type;
                    }

                    protected ClassDefinition resolve(InitializationStrategy initializationStrategy, ClassFileLocator classFileLocator, TypeStrategy typeStrategy, ByteBuddy byteBuddy, MethodRebaseResolver.MethodNameTransformer methodNameTransformer, Default.BootstrapInjectionStrategy bootstrapInjectionStrategy, AccessControlContext accessControlContext, Listener listener) {
                        return new ClassDefinition(this.type, this.resolution.apply(initializationStrategy, classFileLocator, typeStrategy, byteBuddy, methodNameTransformer, bootstrapInjectionStrategy, accessControlContext, listener));
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        Entry entry = (Entry)other;
                        return this.type.equals(entry.type) && this.resolution.equals(entry.resolution);
                    }

                    public int hashCode() {
                        int result = this.type.hashCode();
                        result = 31 * result + this.resolution.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "AgentBuilder.RedefinitionStrategy.Collector.ForRedefinition.Entry{type=" + this.type + ", resolution=" + this.resolution + '}';
                    }
                }
            }
        }
    }

    public static interface InitializationStrategy {
        public void initialize(Class<?> var1, LoadedTypeInitializer var2);

        public DynamicType.Builder<?> apply(DynamicType.Builder<?> var1);

        public void register(String var1, ClassLoader var2, LoadedTypeInitializer var3);

        public static enum SelfInjection implements InitializationStrategy,
        Implementation,
        ByteCodeAppender
        {
            INSTANCE;


            @Override
            public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder) {
                return builder.invokable(ElementMatchers.none()).intercept(this);
            }

            @Override
            public void initialize(Class<?> type, LoadedTypeInitializer loadedTypeInitializer) {
                loadedTypeInitializer.onLoad(type);
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withInitializer(Nexus.Accessor.INSTANCE.initializerFor(instrumentedType));
            }

            @Override
            public ByteCodeAppender appender(Implementation.Target implementationTarget) {
                return this;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                throw new IllegalStateException("Initialization strategy illegally applied to " + instrumentedMethod);
            }

            @Override
            public void register(String name, ClassLoader classLoader, LoadedTypeInitializer loadedTypeInitializer) {
                if (loadedTypeInitializer.isAlive()) {
                    Nexus.Accessor.INSTANCE.register(name, classLoader, loadedTypeInitializer);
                }
            }

            public String toString() {
                return "AgentBuilder.InitializationStrategy.SelfInjection." + this.name();
            }

            public static class Nexus {
                private static final ConcurrentMap<Nexus, Object> TYPE_INITIALIZERS = new ConcurrentHashMap<Nexus, Object>();
                private final String name;
                private final ClassLoader classLoader;

                private Nexus(Class<?> type) {
                    this.name = type.getName();
                    this.classLoader = type.getClassLoader();
                }

                private Nexus(String name, ClassLoader classLoader) {
                    this.name = name;
                    this.classLoader = classLoader;
                }

                public static void initialize(Class<?> type) throws Exception {
                    Object typeInitializer = TYPE_INITIALIZERS.remove(new Nexus(type));
                    if (typeInitializer != null) {
                        typeInitializer.getClass().getMethod("onLoad", Class.class).invoke(typeInitializer, type);
                    }
                }

                public static void register(String name, ClassLoader classLoader, Object typeInitializer) {
                    TYPE_INITIALIZERS.put(new Nexus(name, classLoader), typeInitializer);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Nexus nexus = (Nexus)other;
                    return !(this.classLoader == null ? nexus.classLoader != null : !this.classLoader.equals(nexus.classLoader)) && this.name.equals(nexus.name);
                }

                public int hashCode() {
                    int result = this.name.hashCode();
                    result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.InitializationStrategy.SelfInjection.Nexus{name='" + this.name + '\'' + ", classLoader=" + this.classLoader + '}';
                }

                protected static enum Accessor {
                    INSTANCE;

                    private static final Object STATIC_METHOD;
                    private final Method registration;
                    private final MethodDescription systemClassLoader;
                    private final MethodDescription loadClass;
                    private final MethodDescription getDeclaredMethod;
                    private final MethodDescription invokeMethod;

                    private Accessor() {
                        try {
                            TypeDescription.ForLoadedType nexusType = new TypeDescription.ForLoadedType(Nexus.class);
                            Class<?> nexus = new ClassInjector.UsingReflection(ClassLoader.getSystemClassLoader()).inject(Collections.singletonMap(nexusType, new StreamDrainer().drain(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(Nexus.class.getName().replace('.', '/') + ".class")))).get(nexusType);
                            this.registration = nexus.getDeclaredMethod("register", String.class, ClassLoader.class, Object.class);
                            this.systemClassLoader = (MethodDescription)((MethodList)new TypeDescription.ForLoadedType(ClassLoader.class).getDeclaredMethods().filter(ElementMatchers.named("getSystemClassLoader"))).getOnly();
                            this.loadClass = (MethodDescription)((MethodList)new TypeDescription.ForLoadedType(ClassLoader.class).getDeclaredMethods().filter(ElementMatchers.named("loadClass").and(ElementMatchers.takesArguments(String.class)))).getOnly();
                            this.getDeclaredMethod = (MethodDescription)((MethodList)new TypeDescription.ForLoadedType(Class.class).getDeclaredMethods().filter(ElementMatchers.named("getDeclaredMethod").and(ElementMatchers.takesArguments(String.class, Class[].class)))).getOnly();
                            this.invokeMethod = (MethodDescription)((MethodList)new TypeDescription.ForLoadedType(Method.class).getDeclaredMethods().filter(ElementMatchers.named("invoke").and(ElementMatchers.takesArguments(Object.class, Object[].class)))).getOnly();
                        }
                        catch (RuntimeException exception) {
                            throw exception;
                        }
                        catch (Exception exception) {
                            throw new IllegalStateException("Cannot create type initialization accessor", exception);
                        }
                    }

                    public void register(String name, ClassLoader classLoader, Object typeInitializer) {
                        try {
                            this.registration.invoke(STATIC_METHOD, name, classLoader, typeInitializer);
                        }
                        catch (IllegalAccessException exception) {
                            throw new IllegalStateException("Cannot register type initializer for " + name, exception);
                        }
                        catch (InvocationTargetException exception) {
                            throw new IllegalStateException("Cannot register type initializer for " + name, exception.getCause());
                        }
                    }

                    public ByteCodeAppender initializerFor(TypeDescription instrumentedType) {
                        return new ByteCodeAppender.Simple(new StackManipulation.Compound(MethodInvocation.invoke(this.systemClassLoader), new TextConstant(Nexus.class.getName()), MethodInvocation.invoke(this.loadClass), new TextConstant("initialize"), ArrayFactory.forType(TypeDescription.CLASS).withValues(Collections.singletonList(ClassConstant.of(TypeDescription.CLASS))), MethodInvocation.invoke(this.getDeclaredMethod), NullConstant.INSTANCE, ArrayFactory.forType(TypeDescription.OBJECT).withValues(Collections.singletonList(ClassConstant.of(instrumentedType))), MethodInvocation.invoke(this.invokeMethod), Removal.SINGLE));
                    }

                    public String toString() {
                        return "AgentBuilder.InitializationStrategy.SelfInjection.Nexus.Accessor." + this.name();
                    }

                    static {
                        STATIC_METHOD = null;
                    }
                }
            }
        }

        public static enum NoOp implements InitializationStrategy
        {
            INSTANCE;


            @Override
            public void initialize(Class<?> type, LoadedTypeInitializer loadedTypeInitializer) {
            }

            @Override
            public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder) {
                return builder;
            }

            @Override
            public void register(String name, ClassLoader classLoader, LoadedTypeInitializer loadedTypeInitializer) {
            }

            public String toString() {
                return "AgentBuilder.InitializationStrategy.NoOp." + this.name();
            }
        }
    }

    public static interface Listener {
        public void onTransformation(TypeDescription var1, DynamicType var2);

        public void onIgnored(TypeDescription var1);

        public void onError(String var1, Throwable var2);

        public void onComplete(String var1);

        public static class Compound
        implements Listener {
            private final List<? extends Listener> listeners;

            public Compound(Listener ... listener) {
                this(Arrays.asList(listener));
            }

            public Compound(List<? extends Listener> listeners) {
                this.listeners = listeners;
            }

            @Override
            public void onTransformation(TypeDescription typeDescription, DynamicType dynamicType) {
                for (Listener listener : this.listeners) {
                    listener.onTransformation(typeDescription, dynamicType);
                }
            }

            @Override
            public void onIgnored(TypeDescription typeDescription) {
                for (Listener listener : this.listeners) {
                    listener.onIgnored(typeDescription);
                }
            }

            @Override
            public void onError(String typeName, Throwable throwable) {
                for (Listener listener : this.listeners) {
                    listener.onError(typeName, throwable);
                }
            }

            @Override
            public void onComplete(String typeName) {
                for (Listener listener : this.listeners) {
                    listener.onComplete(typeName);
                }
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.listeners.equals(((Compound)other).listeners);
            }

            public int hashCode() {
                return this.listeners.hashCode();
            }

            public String toString() {
                return "AgentBuilder.Listener.Compound{listeners=" + this.listeners + '}';
            }
        }

        public static enum NoOp implements Listener
        {
            INSTANCE;


            @Override
            public void onTransformation(TypeDescription typeDescription, DynamicType dynamicType) {
            }

            @Override
            public void onIgnored(TypeDescription typeDescription) {
            }

            @Override
            public void onError(String typeName, Throwable throwable) {
            }

            @Override
            public void onComplete(String typeName) {
            }

            public String toString() {
                return "AgentBuilder.Listener.NoOp." + this.name();
            }
        }
    }

    public static interface BinaryLocator {
        public ClassFileLocator classFileLocator(ClassLoader var1);

        public TypePool typePool(ClassFileLocator var1);

        public static enum Default implements BinaryLocator
        {
            EXTENDED(TypePool.Default.ReaderMode.EXTENDED),
            FAST(TypePool.Default.ReaderMode.FAST);

            private final TypePool.Default.ReaderMode readerMode;

            private Default(TypePool.Default.ReaderMode readerMode) {
                this.readerMode = readerMode;
            }

            @Override
            public ClassFileLocator classFileLocator(ClassLoader classLoader) {
                return ClassFileLocator.ForClassLoader.of(classLoader);
            }

            @Override
            public TypePool typePool(ClassFileLocator classFileLocator) {
                return new TypePool.LazyFacade(new TypePool.Default(new TypePool.CacheProvider.Simple(), classFileLocator, this.readerMode));
            }

            public String toString() {
                return "AgentBuilder.BinaryLocator.Default." + this.name();
            }
        }
    }

    public static interface Transformer {
        public DynamicType.Builder<?> transform(DynamicType.Builder<?> var1, TypeDescription var2);

        public static class Compound
        implements Transformer {
            private final Transformer[] transformer;

            public Compound(Transformer ... transformer) {
                this.transformer = transformer;
            }

            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription) {
                for (Transformer transformer : this.transformer) {
                    builder = transformer.transform(builder, typeDescription);
                }
                return builder;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.transformer, ((Compound)other).transformer);
            }

            public int hashCode() {
                return Arrays.hashCode(this.transformer);
            }

            public String toString() {
                return "AgentBuilder.Transformer.Compound{transformer=" + Arrays.toString(this.transformer) + '}';
            }
        }

        public static enum NoOp implements Transformer
        {
            INSTANCE;


            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription) {
                return builder;
            }

            public String toString() {
                return "AgentBuilder.Transformer.NoOp." + this.name();
            }
        }
    }

    public static interface TypeStrategy {
        public DynamicType.Builder<?> builder(TypeDescription var1, ByteBuddy var2, ClassFileLocator var3, MethodRebaseResolver.MethodNameTransformer var4);

        public static enum Default implements TypeStrategy
        {
            REBASE{

                @Override
                public DynamicType.Builder<?> builder(TypeDescription typeDescription, ByteBuddy byteBuddy, ClassFileLocator classFileLocator, MethodRebaseResolver.MethodNameTransformer methodNameTransformer) {
                    return byteBuddy.rebase(typeDescription, classFileLocator, methodNameTransformer);
                }
            }
            ,
            REDEFINE{

                @Override
                public DynamicType.Builder<?> builder(TypeDescription typeDescription, ByteBuddy byteBuddy, ClassFileLocator classFileLocator, MethodRebaseResolver.MethodNameTransformer methodNameTransformer) {
                    return byteBuddy.redefine(typeDescription, classFileLocator);
                }
            };


            public String toString() {
                return "AgentBuilder.TypeStrategy.Default." + this.name();
            }
        }
    }

    public static interface RawMatcher {
        public boolean matches(TypeDescription var1, ClassLoader var2, Class<?> var3, ProtectionDomain var4);

        public static class ForElementMatcherPair
        implements RawMatcher {
            private final ElementMatcher<? super TypeDescription> typeMatcher;
            private final ElementMatcher<? super ClassLoader> classLoaderMatcher;

            public ForElementMatcherPair(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher) {
                this.typeMatcher = typeMatcher;
                this.classLoaderMatcher = classLoaderMatcher;
            }

            @Override
            public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                return this.classLoaderMatcher.matches(classLoader) && this.typeMatcher.matches(typeDescription);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.classLoaderMatcher.equals(((ForElementMatcherPair)other).classLoaderMatcher) && this.typeMatcher.equals(((ForElementMatcherPair)other).typeMatcher);
            }

            public int hashCode() {
                int result = this.typeMatcher.hashCode();
                result = 31 * result + this.classLoaderMatcher.hashCode();
                return result;
            }

            public String toString() {
                return "AgentBuilder.RawMatcher.ForElementMatcherPair{typeMatcher=" + this.typeMatcher + ", classLoaderMatcher=" + this.classLoaderMatcher + '}';
            }
        }
    }

    public static interface Identified {
        public Extendable transform(Transformer var1);

        public static interface Extendable
        extends AgentBuilder,
        Identified {
        }
    }
}

