/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.pool;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.PackageDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.description.type.generic.GenericTypeDescription;
import net.bytebuddy.description.type.generic.GenericTypeList;
import net.bytebuddy.description.type.generic.TypeVariableSource;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.jar.asm.AnnotationVisitor;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.jar.asm.signature.SignatureReader;
import net.bytebuddy.jar.asm.signature.SignatureVisitor;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.PropertyDispatcher;

public interface TypePool {
    public Resolution describe(String var1);

    public void clear();

    public static class LazyTypeDescription
    extends TypeDescription.AbstractBase.OfSimpleType {
        private static final String NO_SUPER_TYPE = null;
        private final TypePool typePool;
        private final int modifiers;
        private final String name;
        private final String superTypeDescriptor;
        private final GenericTypeToken.Resolution.ForType signatureResolution;
        private final List<String> interfaceTypeDescriptors;
        private final DeclarationContext declarationContext;
        private final boolean anonymousType;
        private final List<AnnotationDescription> declaredAnnotations;
        private final List<FieldDescription.InDefinedShape> declaredFields;
        private final List<MethodDescription.InDefinedShape> declaredMethods;

        protected LazyTypeDescription(TypePool typePool, int modifiers, String name, String superTypeInternalName, String[] interfaceInternalName, GenericTypeToken.Resolution.ForType signatureResolution, DeclarationContext declarationContext, boolean anonymousType, List<AnnotationToken> annotationTokens, List<FieldToken> fieldTokens, List<MethodToken> methodTokens) {
            this.typePool = typePool;
            this.modifiers = modifiers;
            this.name = Type.getObjectType(name).getClassName();
            this.superTypeDescriptor = superTypeInternalName == null ? NO_SUPER_TYPE : Type.getObjectType(superTypeInternalName).getDescriptor();
            this.signatureResolution = signatureResolution;
            if (interfaceInternalName == null) {
                this.interfaceTypeDescriptors = Collections.emptyList();
            } else {
                this.interfaceTypeDescriptors = new ArrayList<String>(interfaceInternalName.length);
                for (String internalName : interfaceInternalName) {
                    this.interfaceTypeDescriptors.add(Type.getObjectType(internalName).getDescriptor());
                }
            }
            this.declarationContext = declarationContext;
            this.anonymousType = anonymousType;
            this.declaredAnnotations = new ArrayList<AnnotationDescription>(annotationTokens.size());
            for (AnnotationToken annotationToken : annotationTokens) {
                this.declaredAnnotations.add(annotationToken.toAnnotationDescription(typePool));
            }
            this.declaredFields = new ArrayList<FieldDescription.InDefinedShape>(fieldTokens.size());
            for (FieldToken fieldToken : fieldTokens) {
                this.declaredFields.add(fieldToken.toFieldDescription(this));
            }
            this.declaredMethods = new ArrayList<MethodDescription.InDefinedShape>(methodTokens.size());
            for (MethodToken methodToken : methodTokens) {
                this.declaredMethods.add(methodToken.toMethodDescription(this));
            }
        }

        @Override
        protected GenericTypeDescription getDeclaredSuperType() {
            return this.superTypeDescriptor == null || this.isInterface() ? TypeDescription.UNDEFINED : this.signatureResolution.resolveSuperType(this.superTypeDescriptor, this.typePool, this);
        }

        @Override
        protected GenericTypeList getDeclaredInterfaces() {
            return this.signatureResolution.resolveInterfaceTypes(this.interfaceTypeDescriptors, this.typePool, this);
        }

        @Override
        public MethodDescription getEnclosingMethod() {
            return this.declarationContext.getEnclosingMethod(this.typePool);
        }

        @Override
        public TypeDescription getEnclosingType() {
            return this.declarationContext.getEnclosingType(this.typePool);
        }

        @Override
        public boolean isAnonymousClass() {
            return this.anonymousType;
        }

        @Override
        public boolean isLocalClass() {
            return !this.anonymousType && this.declarationContext.isDeclaredInMethod();
        }

        @Override
        public boolean isMemberClass() {
            return this.declarationContext.isDeclaredInType();
        }

        @Override
        public FieldList<FieldDescription.InDefinedShape> getDeclaredFields() {
            return new FieldList.Explicit<FieldDescription.InDefinedShape>(this.declaredFields);
        }

        @Override
        public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods() {
            return new MethodList.Explicit<MethodDescription.InDefinedShape>(this.declaredMethods);
        }

        @Override
        public PackageDescription getPackage() {
            String name = this.getName();
            int index = name.lastIndexOf(46);
            return index == -1 ? PackageDescription.UNDEFINED : new LazyPackageDescription(this.typePool, name.substring(0, index));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return this.declarationContext.isDeclaredInType() ? this.declarationContext.getEnclosingType(this.typePool) : TypeDescription.UNDEFINED;
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Explicit(this.declaredAnnotations);
        }

        @Override
        public GenericTypeList getTypeVariables() {
            return this.signatureResolution.resolveTypeVariables(this.typePool, this);
        }

        private class LazyMethodDescription
        extends MethodDescription.InDefinedShape.AbstractBase {
            private final String internalName;
            private final int modifiers;
            private final String returnTypeDescriptor;
            private final GenericTypeToken.Resolution.ForMethod signatureResolution;
            private final List<String> parameterTypeDescriptors;
            private final List<String> exceptionTypeDescriptors;
            private final List<AnnotationDescription> declaredAnnotations;
            private final List<List<AnnotationDescription>> declaredParameterAnnotations;
            private final String[] parameterNames;
            private final Integer[] parameterModifiers;
            private final AnnotationDescription.AnnotationValue<?, ?> defaultValue;

            private LazyMethodDescription(String internalName, int modifiers, String methodDescriptor, GenericTypeToken.Resolution.ForMethod signatureResolution, String[] exceptionTypeInternalName, List<AnnotationToken> annotationTokens, Map<Integer, List<AnnotationToken>> parameterAnnotationTokens, List<MethodToken.ParameterToken> parameterTokens, AnnotationDescription.AnnotationValue<?, ?> defaultValue) {
                int index;
                this.modifiers = modifiers;
                this.internalName = internalName;
                Type methodType = Type.getMethodType(methodDescriptor);
                Type returnType = methodType.getReturnType();
                Type[] parameterType = methodType.getArgumentTypes();
                this.returnTypeDescriptor = returnType.getDescriptor();
                this.parameterTypeDescriptors = new ArrayList<String>(parameterType.length);
                for (Type type : parameterType) {
                    this.parameterTypeDescriptors.add(type.getDescriptor());
                }
                this.signatureResolution = signatureResolution;
                if (exceptionTypeInternalName == null) {
                    this.exceptionTypeDescriptors = Collections.emptyList();
                } else {
                    this.exceptionTypeDescriptors = new ArrayList<String>(exceptionTypeInternalName.length);
                    for (String anExceptionTypeInternalName : exceptionTypeInternalName) {
                        this.exceptionTypeDescriptors.add(Type.getObjectType(anExceptionTypeInternalName).getDescriptor());
                    }
                }
                this.declaredAnnotations = new ArrayList<AnnotationDescription>(annotationTokens.size());
                for (AnnotationToken annotationToken : annotationTokens) {
                    this.declaredAnnotations.add(annotationToken.toAnnotationDescription(LazyTypeDescription.this.typePool));
                }
                this.declaredParameterAnnotations = new ArrayList<List<AnnotationDescription>>(parameterType.length);
                for (index = 0; index < parameterType.length; ++index) {
                    List<AnnotationToken> tokens = parameterAnnotationTokens.get(index);
                    ArrayList<AnnotationDescription> annotationDescriptions = new ArrayList<AnnotationDescription>(tokens.size());
                    for (AnnotationToken annotationToken : tokens) {
                        annotationDescriptions.add(annotationToken.toAnnotationDescription(LazyTypeDescription.this.typePool));
                    }
                    this.declaredParameterAnnotations.add(annotationDescriptions);
                }
                this.parameterNames = new String[parameterType.length];
                this.parameterModifiers = new Integer[parameterType.length];
                if (parameterTokens.size() == parameterType.length) {
                    index = 0;
                    for (MethodToken.ParameterToken parameterToken : parameterTokens) {
                        this.parameterNames[index] = parameterToken.getName();
                        this.parameterModifiers[index] = parameterToken.getModifiers();
                        ++index;
                    }
                }
                this.defaultValue = defaultValue;
            }

            @Override
            public GenericTypeDescription getReturnType() {
                return this.signatureResolution.resolveReturnType(this.returnTypeDescriptor, LazyTypeDescription.this.typePool, this);
            }

            @Override
            public GenericTypeList getExceptionTypes() {
                return this.signatureResolution.resolveExceptionTypes(this.exceptionTypeDescriptors, LazyTypeDescription.this.typePool, this);
            }

            @Override
            public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
                return new LazyParameterList();
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.Explicit(this.declaredAnnotations);
            }

            @Override
            public String getInternalName() {
                return this.internalName;
            }

            @Override
            public TypeDescription getDeclaringType() {
                return LazyTypeDescription.this;
            }

            @Override
            public int getModifiers() {
                return this.modifiers;
            }

            @Override
            public GenericTypeList getTypeVariables() {
                return this.signatureResolution.resolveTypeVariables(LazyTypeDescription.this.typePool, this);
            }

            @Override
            public Object getDefaultValue() {
                return this.defaultValue == null ? NO_DEFAULT_VALUE : this.defaultValue.resolve();
            }

            private class LazyParameterDescription
            extends ParameterDescription.InDefinedShape.AbstractBase {
                private final int index;

                protected LazyParameterDescription(int index) {
                    this.index = index;
                }

                @Override
                public MethodDescription.InDefinedShape getDeclaringMethod() {
                    return LazyMethodDescription.this;
                }

                @Override
                public int getIndex() {
                    return this.index;
                }

                @Override
                public boolean isNamed() {
                    return LazyMethodDescription.this.parameterNames[this.index] != null;
                }

                @Override
                public boolean hasModifiers() {
                    return LazyMethodDescription.this.parameterModifiers[this.index] != null;
                }

                @Override
                public String getName() {
                    return this.isNamed() ? LazyMethodDescription.this.parameterNames[this.index] : super.getName();
                }

                @Override
                public int getModifiers() {
                    return this.hasModifiers() ? LazyMethodDescription.this.parameterModifiers[this.index].intValue() : super.getModifiers();
                }

                @Override
                public GenericTypeDescription getType() {
                    return (GenericTypeDescription)LazyMethodDescription.this.signatureResolution.resolveParameterTypes(LazyMethodDescription.this.parameterTypeDescriptors, LazyTypeDescription.this.typePool, LazyMethodDescription.this).get(this.index);
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return new AnnotationList.Explicit((List)LazyMethodDescription.this.declaredParameterAnnotations.get(this.index));
                }
            }

            private class LazyParameterList
            extends ParameterList.AbstractBase<ParameterDescription.InDefinedShape> {
                private LazyParameterList() {
                }

                @Override
                public ParameterDescription.InDefinedShape get(int index) {
                    return new LazyParameterDescription(index);
                }

                @Override
                public boolean hasExplicitMetaData() {
                    for (int i = 0; i < this.size(); ++i) {
                        if (LazyMethodDescription.this.parameterNames[i] != null && LazyMethodDescription.this.parameterModifiers[i] != null) continue;
                        return false;
                    }
                    return true;
                }

                @Override
                public int size() {
                    return LazyMethodDescription.this.parameterTypeDescriptors.size();
                }

                @Override
                public GenericTypeList asTypeList() {
                    return LazyMethodDescription.this.signatureResolution.resolveParameterTypes(LazyMethodDescription.this.parameterTypeDescriptors, LazyTypeDescription.this.typePool, LazyMethodDescription.this);
                }
            }
        }

        private class LazyFieldDescription
        extends FieldDescription.InDefinedShape.AbstractBase {
            private final String name;
            private final int modifiers;
            private final String fieldTypeDescriptor;
            private final GenericTypeToken.Resolution.ForField signatureResolution;
            private final List<AnnotationDescription> declaredAnnotations;

            private LazyFieldDescription(String name, int modifiers, String descriptor, GenericTypeToken.Resolution.ForField signatureResolution, List<AnnotationToken> annotationTokens) {
                this.modifiers = modifiers;
                this.name = name;
                this.fieldTypeDescriptor = descriptor;
                this.signatureResolution = signatureResolution;
                this.declaredAnnotations = new ArrayList<AnnotationDescription>(annotationTokens.size());
                for (AnnotationToken annotationToken : annotationTokens) {
                    this.declaredAnnotations.add(annotationToken.toAnnotationDescription(LazyTypeDescription.this.typePool));
                }
            }

            @Override
            public GenericTypeDescription getType() {
                return this.signatureResolution.resolveFieldType(this.fieldTypeDescriptor, LazyTypeDescription.this.typePool, this);
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.Explicit(this.declaredAnnotations);
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public TypeDescription getDeclaringType() {
                return LazyTypeDescription.this;
            }

            @Override
            public int getModifiers() {
                return this.modifiers;
            }
        }

        private static class TokenizedGenericType
        extends GenericTypeDescription.LazyProjection {
            private final TypePool typePool;
            private final GenericTypeToken genericTypeToken;
            private final String rawTypeDescriptor;
            private final TypeVariableSource typeVariableSource;

            protected TokenizedGenericType(TypePool typePool, GenericTypeToken genericTypeToken, String rawTypeDescriptor, TypeVariableSource typeVariableSource) {
                this.typePool = typePool;
                this.genericTypeToken = genericTypeToken;
                this.rawTypeDescriptor = rawTypeDescriptor;
                this.typeVariableSource = typeVariableSource;
            }

            protected static TypeDescription toErasure(TypePool typePool, String descriptor) {
                Type type = Type.getType(descriptor);
                return typePool.describe(type.getSort() == 9 ? type.getInternalName().replace('/', '.') : type.getClassName()).resolve();
            }

            @Override
            public GenericTypeDescription.Sort getSort() {
                return this.genericTypeToken.getSort();
            }

            @Override
            protected GenericTypeDescription resolve() {
                return this.genericTypeToken.toGenericType(this.typePool, this.typeVariableSource);
            }

            @Override
            public TypeDescription asErasure() {
                return TokenizedGenericType.toErasure(this.typePool, this.rawTypeDescriptor);
            }

            protected static class Malformed
            extends GenericTypeDescription.LazyProjection {
                private final TypePool typePool;
                private final String rawTypeDescriptor;

                protected Malformed(TypePool typePool, String rawTypeDescriptor) {
                    this.typePool = typePool;
                    this.rawTypeDescriptor = rawTypeDescriptor;
                }

                @Override
                protected GenericTypeDescription resolve() {
                    throw new GenericSignatureFormatError();
                }

                @Override
                public TypeDescription asErasure() {
                    return TokenizedGenericType.toErasure(this.typePool, this.rawTypeDescriptor);
                }

                protected static class TokenList
                extends GenericTypeList.AbstractBase {
                    private final TypePool typePool;
                    private final List<String> rawTypeDescriptors;

                    protected TokenList(TypePool typePool, List<String> rawTypeDescriptors) {
                        this.typePool = typePool;
                        this.rawTypeDescriptors = rawTypeDescriptors;
                    }

                    @Override
                    public GenericTypeDescription get(int index) {
                        return new Malformed(this.typePool, this.rawTypeDescriptors.get(index));
                    }

                    @Override
                    public int size() {
                        return this.rawTypeDescriptors.size();
                    }

                    @Override
                    public TypeList asErasures() {
                        return new LazyTypeList(this.typePool, this.rawTypeDescriptors);
                    }
                }
            }

            protected static class TypeVariableList
            extends GenericTypeList.AbstractBase {
                private final TypePool typePool;
                private final List<GenericTypeToken> typeVariables;
                private final TypeVariableSource typeVariableSource;

                protected TypeVariableList(TypePool typePool, List<GenericTypeToken> typeVariables, TypeVariableSource typeVariableSource) {
                    this.typePool = typePool;
                    this.typeVariables = typeVariables;
                    this.typeVariableSource = typeVariableSource;
                }

                @Override
                public GenericTypeDescription get(int index) {
                    return this.typeVariables.get(index).toGenericType(this.typePool, this.typeVariableSource);
                }

                @Override
                public int size() {
                    return this.typeVariables.size();
                }
            }

            protected static class TokenList
            extends GenericTypeList.AbstractBase {
                private final TypePool typePool;
                private final List<GenericTypeToken> genericTypeTokens;
                private final List<String> rawTypeDescriptors;
                private final TypeVariableSource typeVariableSource;

                private TokenList(TypePool typePool, List<GenericTypeToken> genericTypeTokens, List<String> rawTypeDescriptors, TypeVariableSource typeVariableSource) {
                    this.typePool = typePool;
                    this.genericTypeTokens = genericTypeTokens;
                    this.rawTypeDescriptors = rawTypeDescriptors;
                    this.typeVariableSource = typeVariableSource;
                }

                @Override
                public GenericTypeDescription get(int index) {
                    return new TokenizedGenericType(this.typePool, this.genericTypeTokens.get(index), this.rawTypeDescriptors.get(index), this.typeVariableSource);
                }

                @Override
                public int size() {
                    return this.rawTypeDescriptors.size();
                }

                @Override
                public TypeList asErasures() {
                    return new LazyTypeList(this.typePool, this.rawTypeDescriptors);
                }
            }
        }

        private static class LazyTypeList
        extends TypeList.AbstractBase {
            private final TypePool typePool;
            private final List<String> descriptors;

            private LazyTypeList(TypePool typePool, List<String> descriptors) {
                this.typePool = typePool;
                this.descriptors = descriptors;
            }

            @Override
            public TypeDescription get(int index) {
                return TokenizedGenericType.toErasure(this.typePool, this.descriptors.get(index));
            }

            @Override
            public int size() {
                return this.descriptors.size();
            }

            @Override
            public String[] toInternalNames() {
                String[] internalName = new String[this.descriptors.size()];
                int index = 0;
                for (String descriptor : this.descriptors) {
                    internalName[index++] = Type.getType(descriptor).getInternalName();
                }
                return internalName.length == 0 ? NO_INTERFACES : internalName;
            }

            @Override
            public int getStackSize() {
                int stackSize = 0;
                for (String descriptor : this.descriptors) {
                    stackSize += Type.getType(descriptor).getSize();
                }
                return stackSize;
            }

            @Override
            public GenericTypeList asGenericTypes() {
                return new Generified();
            }

            private class Generified
            extends GenericTypeList.AbstractBase {
                private Generified() {
                }

                @Override
                public GenericTypeDescription get(int index) {
                    return LazyTypeList.this.get(index);
                }

                @Override
                public int size() {
                    return LazyTypeList.this.size();
                }

                @Override
                public TypeList asErasures() {
                    return LazyTypeList.this;
                }
            }
        }

        private static class LazyPackageDescription
        extends PackageDescription.AbstractBase {
            private final TypePool typePool;
            private final String name;

            private LazyPackageDescription(TypePool typePool, String name) {
                this.typePool = typePool;
                this.name = name;
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                Resolution resolution = this.typePool.describe(this.name + "." + "package-info");
                return resolution.isResolved() ? resolution.resolve().getDeclaredAnnotations() : new AnnotationList.Empty();
            }

            @Override
            public String getName() {
                return this.name;
            }
        }

        private static class LazyAnnotationDescription
        extends AnnotationDescription.AbstractBase {
            protected final TypePool typePool;
            protected final Map<String, AnnotationDescription.AnnotationValue<?, ?>> values;
            private final String descriptor;

            private LazyAnnotationDescription(TypePool typePool, String descriptor, Map<String, AnnotationDescription.AnnotationValue<?, ?>> values) {
                this.typePool = typePool;
                this.descriptor = descriptor;
                this.values = values;
            }

            @Override
            public Object getValue(MethodDescription.InDefinedShape methodDescription) {
                Object value;
                if (!methodDescription.getDeclaringType().asErasure().getDescriptor().equals(this.descriptor)) {
                    throw new IllegalArgumentException(methodDescription + " is not declared by " + this.getAnnotationType());
                }
                AnnotationDescription.AnnotationValue<?, ?> annotationValue = this.values.get(methodDescription.getName());
                Object object = value = annotationValue == null ? ((MethodDescription.InDefinedShape)((MethodList)this.getAnnotationType().getDeclaredMethods().filter(ElementMatchers.is(methodDescription))).getOnly()).getDefaultValue() : annotationValue.resolve();
                if (value == null) {
                    throw new IllegalStateException(methodDescription + " is not defined on annotation");
                }
                return PropertyDispatcher.of(value.getClass()).conditionalClone(value);
            }

            @Override
            public TypeDescription getAnnotationType() {
                return this.typePool.describe(this.descriptor.substring(1, this.descriptor.length() - 1).replace('/', '.')).resolve();
            }

            public <T extends Annotation> Loadable<T> prepare(Class<T> annotationType) {
                return new Loadable(this.typePool, this.descriptor, this.values, annotationType);
            }

            private static class Loadable<S extends Annotation>
            extends LazyAnnotationDescription
            implements AnnotationDescription.Loadable<S> {
                private final Class<S> annotationType;

                private Loadable(TypePool typePool, String descriptor, Map<String, AnnotationDescription.AnnotationValue<?, ?>> values, Class<S> annotationType) {
                    super(typePool, descriptor, values);
                    if (!Type.getDescriptor(annotationType).equals(descriptor)) {
                        throw new IllegalArgumentException(annotationType + " does not correspond to " + descriptor);
                    }
                    this.annotationType = annotationType;
                }

                @Override
                public S load() throws ClassNotFoundException {
                    return this.load(this.annotationType.getClassLoader());
                }

                @Override
                public S load(ClassLoader classLoader) throws ClassNotFoundException {
                    return (S)((Annotation)Proxy.newProxyInstance(classLoader, new Class[]{this.annotationType}, AnnotationDescription.AnnotationInvocationHandler.of(classLoader, this.annotationType, this.values)));
                }

                @Override
                public S loadSilent() {
                    try {
                        return this.load();
                    }
                    catch (ClassNotFoundException exception) {
                        throw new IllegalStateException("Could not load a type that is linked by the annotation value", exception);
                    }
                }

                @Override
                public S loadSilent(ClassLoader classLoader) {
                    try {
                        return this.load(classLoader);
                    }
                    catch (ClassNotFoundException exception) {
                        throw new IllegalStateException("Could not load a type that is linked by the annotation value", exception);
                    }
                }
            }
        }

        protected static class MethodToken {
            private final String name;
            private final int modifiers;
            private final String descriptor;
            private final GenericTypeToken.Resolution.ForMethod signatureResolution;
            private final String[] exceptionName;
            private final List<AnnotationToken> annotationTokens;
            private final Map<Integer, List<AnnotationToken>> parameterAnnotationTokens;
            private final List<ParameterToken> parameterTokens;
            private final AnnotationDescription.AnnotationValue<?, ?> defaultValue;

            protected MethodToken(String name, int modifiers, String descriptor, GenericTypeToken.Resolution.ForMethod signatureResolution, String[] exceptionName, List<AnnotationToken> annotationTokens, Map<Integer, List<AnnotationToken>> parameterAnnotationTokens, List<ParameterToken> parameterTokens, AnnotationDescription.AnnotationValue<?, ?> defaultValue) {
                this.modifiers = modifiers;
                this.name = name;
                this.descriptor = descriptor;
                this.signatureResolution = signatureResolution;
                this.exceptionName = exceptionName;
                this.annotationTokens = annotationTokens;
                this.parameterAnnotationTokens = parameterAnnotationTokens;
                this.parameterTokens = parameterTokens;
                this.defaultValue = defaultValue;
            }

            protected int getModifiers() {
                return this.modifiers;
            }

            protected String getName() {
                return this.name;
            }

            protected String getDescriptor() {
                return this.descriptor;
            }

            protected GenericTypeToken.Resolution.ForMethod getSignatureResolution() {
                return this.signatureResolution;
            }

            protected String[] getExceptionName() {
                return this.exceptionName;
            }

            protected List<AnnotationToken> getAnnotationTokens() {
                return this.annotationTokens;
            }

            protected Map<Integer, List<AnnotationToken>> getParameterAnnotationTokens() {
                return this.parameterAnnotationTokens;
            }

            protected List<ParameterToken> getParameterTokens() {
                return this.parameterTokens;
            }

            protected AnnotationDescription.AnnotationValue<?, ?> getDefaultValue() {
                return this.defaultValue;
            }

            private MethodDescription.InDefinedShape toMethodDescription(LazyTypeDescription lazyTypeDescription) {
                LazyTypeDescription lazyTypeDescription2 = lazyTypeDescription;
                lazyTypeDescription2.getClass();
                return lazyTypeDescription2.new LazyMethodDescription(this.getName(), this.getModifiers(), this.getDescriptor(), this.getSignatureResolution(), this.getExceptionName(), this.getAnnotationTokens(), this.getParameterAnnotationTokens(), this.getParameterTokens(), this.getDefaultValue());
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                MethodToken that = (MethodToken)other;
                return this.modifiers == that.modifiers && this.annotationTokens.equals(that.annotationTokens) && this.defaultValue.equals(that.defaultValue) && this.descriptor.equals(that.descriptor) && this.parameterTokens.equals(that.parameterTokens) && this.signatureResolution.equals(that.signatureResolution) && Arrays.equals(this.exceptionName, that.exceptionName) && this.name.equals(that.name) && this.parameterAnnotationTokens.equals(that.parameterAnnotationTokens);
            }

            public int hashCode() {
                int result = this.modifiers;
                result = 31 * result + this.name.hashCode();
                result = 31 * result + this.descriptor.hashCode();
                result = 31 * result + this.signatureResolution.hashCode();
                result = 31 * result + Arrays.hashCode(this.exceptionName);
                result = 31 * result + this.annotationTokens.hashCode();
                result = 31 * result + this.parameterAnnotationTokens.hashCode();
                result = 31 * result + this.parameterTokens.hashCode();
                result = 31 * result + this.defaultValue.hashCode();
                return result;
            }

            public String toString() {
                return "TypePool.LazyTypeDescription.MethodToken{modifiers=" + this.modifiers + ", name='" + this.name + '\'' + ", descriptor='" + this.descriptor + '\'' + ", signatureResolution=" + this.signatureResolution + ", exceptionName=" + Arrays.toString(this.exceptionName) + ", annotationTokens=" + this.annotationTokens + ", parameterAnnotationTokens=" + this.parameterAnnotationTokens + ", parameterTokens=" + this.parameterTokens + ", defaultValue=" + this.defaultValue + '}';
            }

            protected static class ParameterToken {
                protected static final String NO_NAME = null;
                protected static final Integer NO_MODIFIERS = null;
                private final String name;
                private final Integer modifiers;

                protected ParameterToken() {
                    this(NO_NAME);
                }

                protected ParameterToken(String name) {
                    this(name, NO_MODIFIERS);
                }

                protected ParameterToken(String name, Integer modifiers) {
                    this.name = name;
                    this.modifiers = modifiers;
                }

                protected String getName() {
                    return this.name;
                }

                protected Integer getModifiers() {
                    return this.modifiers;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ParameterToken that = (ParameterToken)other;
                    return !(this.modifiers == null ? that.modifiers != null : !this.modifiers.equals(that.modifiers)) && !(this.name == null ? that.name != null : !this.name.equals(that.name));
                }

                public int hashCode() {
                    int result = this.name != null ? this.name.hashCode() : 0;
                    result = 31 * result + (this.modifiers != null ? this.modifiers.hashCode() : 0);
                    return result;
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.MethodToken.ParameterToken{name='" + this.name + '\'' + ", modifiers=" + this.modifiers + '}';
                }
            }
        }

        protected static class FieldToken {
            private final String name;
            private final int modifiers;
            private final String descriptor;
            private final GenericTypeToken.Resolution.ForField signatureResolution;
            private final List<AnnotationToken> annotationTokens;

            protected FieldToken(String name, int modifiers, String descriptor, GenericTypeToken.Resolution.ForField signatureResolution, List<AnnotationToken> annotationTokens) {
                this.modifiers = modifiers;
                this.name = name;
                this.descriptor = descriptor;
                this.signatureResolution = signatureResolution;
                this.annotationTokens = annotationTokens;
            }

            protected int getModifiers() {
                return this.modifiers;
            }

            protected String getName() {
                return this.name;
            }

            protected String getDescriptor() {
                return this.descriptor;
            }

            protected GenericTypeToken.Resolution.ForField getSignatureResolution() {
                return this.signatureResolution;
            }

            protected List<AnnotationToken> getAnnotationTokens() {
                return this.annotationTokens;
            }

            private FieldDescription.InDefinedShape toFieldDescription(LazyTypeDescription lazyTypeDescription) {
                LazyTypeDescription lazyTypeDescription2 = lazyTypeDescription;
                lazyTypeDescription2.getClass();
                return lazyTypeDescription2.new LazyFieldDescription(this.getName(), this.getModifiers(), this.getDescriptor(), this.getSignatureResolution(), this.getAnnotationTokens());
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                FieldToken that = (FieldToken)other;
                return this.modifiers == that.modifiers && this.annotationTokens.equals(that.annotationTokens) && this.descriptor.equals(that.descriptor) && this.signatureResolution.equals(that.signatureResolution) && this.name.equals(that.name);
            }

            public int hashCode() {
                int result = this.modifiers;
                result = 31 * result + this.name.hashCode();
                result = 31 * result + this.descriptor.hashCode();
                result = 31 * result + this.signatureResolution.hashCode();
                result = 31 * result + this.annotationTokens.hashCode();
                return result;
            }

            public String toString() {
                return "TypePool.LazyTypeDescription.FieldToken{modifiers=" + this.modifiers + ", name='" + this.name + '\'' + ", descriptor='" + this.descriptor + '\'' + ", signatureResolution=" + this.signatureResolution + ", annotationTokens=" + this.annotationTokens + '}';
            }
        }

        protected static class AnnotationToken {
            private final String descriptor;
            private final Map<String, AnnotationDescription.AnnotationValue<?, ?>> values;

            protected AnnotationToken(String descriptor, Map<String, AnnotationDescription.AnnotationValue<?, ?>> values) {
                this.descriptor = descriptor;
                this.values = values;
            }

            public String getDescriptor() {
                return this.descriptor;
            }

            public Map<String, AnnotationDescription.AnnotationValue<?, ?>> getValues() {
                return this.values;
            }

            private AnnotationDescription toAnnotationDescription(TypePool typePool) {
                return new LazyAnnotationDescription(typePool, this.descriptor, this.values);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                AnnotationToken that = (AnnotationToken)other;
                return this.descriptor.equals(that.descriptor) && this.values.equals(that.values);
            }

            public int hashCode() {
                int result = this.descriptor.hashCode();
                result = 31 * result + this.values.hashCode();
                return result;
            }

            public String toString() {
                return "TypePool.LazyTypeDescription.AnnotationToken{descriptor='" + this.descriptor + '\'' + ", values=" + this.values + '}';
            }
        }

        protected static interface GenericTypeToken {
            public GenericTypeDescription.Sort getSort();

            public GenericTypeDescription toGenericType(TypePool var1, TypeVariableSource var2);

            public static class ForParameterizedType
            implements GenericTypeToken {
                private final String name;
                private final List<GenericTypeToken> parameters;

                public ForParameterizedType(String name, List<GenericTypeToken> parameters) {
                    this.name = name;
                    this.parameters = parameters;
                }

                @Override
                public GenericTypeDescription.Sort getSort() {
                    return GenericTypeDescription.Sort.PARAMETERIZED;
                }

                @Override
                public GenericTypeDescription toGenericType(TypePool typePool, TypeVariableSource typeVariableSource) {
                    return new LazyParameterizedType(typePool, typeVariableSource);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.name.equals(((ForParameterizedType)other).name) && this.parameters.equals(((ForParameterizedType)other).parameters);
                }

                public int hashCode() {
                    return this.name.hashCode() + 31 * this.parameters.hashCode();
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.GenericTypeToken.ForParameterizedType{name='" + this.name + '\'' + "parameters=" + this.parameters + '}';
                }

                protected class LazyParameterizedType
                extends GenericTypeDescription.ForParameterizedType {
                    private final TypePool typePool;
                    private final TypeVariableSource typeVariableSource;

                    public LazyParameterizedType(TypePool typePool, TypeVariableSource typeVariableSource) {
                        this.typePool = typePool;
                        this.typeVariableSource = typeVariableSource;
                    }

                    @Override
                    public TypeDescription asErasure() {
                        return this.typePool.describe(ForParameterizedType.this.name).resolve();
                    }

                    @Override
                    public GenericTypeList getParameters() {
                        ArrayList<GenericTypeDescription> genericTypeDescriptions = new ArrayList<GenericTypeDescription>(ForParameterizedType.this.parameters.size());
                        for (GenericTypeToken parameter : ForParameterizedType.this.parameters) {
                            genericTypeDescriptions.add(parameter.toGenericType(this.typePool, this.typeVariableSource));
                        }
                        return new GenericTypeList.Explicit(genericTypeDescriptions);
                    }

                    @Override
                    public GenericTypeDescription getOwnerType() {
                        return this.typePool.describe(ForParameterizedType.this.name).resolve().getEnclosingType();
                    }
                }

                public static class Nested
                implements GenericTypeToken {
                    private final String name;
                    private final List<GenericTypeToken> parameters;
                    private final GenericTypeToken ownerType;

                    public Nested(String name, List<GenericTypeToken> parameters, GenericTypeToken ownerType) {
                        this.name = name;
                        this.parameters = parameters;
                        this.ownerType = ownerType;
                    }

                    @Override
                    public GenericTypeDescription.Sort getSort() {
                        return GenericTypeDescription.Sort.PARAMETERIZED;
                    }

                    @Override
                    public GenericTypeDescription toGenericType(TypePool typePool, TypeVariableSource typeVariableSource) {
                        return new LazyParameterizedType(typePool, typeVariableSource);
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.name.equals(((Nested)other).name) && this.ownerType.equals(((Nested)other).ownerType) && this.parameters.equals(((Nested)other).parameters);
                    }

                    public int hashCode() {
                        return this.name.hashCode() + 31 * this.parameters.hashCode();
                    }

                    public String toString() {
                        return "TypePool.LazyTypeDescription.GenericTypeToken.ForParameterizedType.Nested{name='" + this.name + '\'' + "parameters=" + this.parameters + "ownerType=" + this.ownerType + '}';
                    }

                    protected class LazyParameterizedType
                    extends GenericTypeDescription.ForParameterizedType {
                        private final TypePool typePool;
                        private final TypeVariableSource typeVariableSource;

                        public LazyParameterizedType(TypePool typePool, TypeVariableSource typeVariableSource) {
                            this.typePool = typePool;
                            this.typeVariableSource = typeVariableSource;
                        }

                        @Override
                        public TypeDescription asErasure() {
                            return this.typePool.describe(Nested.this.name).resolve();
                        }

                        @Override
                        public GenericTypeList getParameters() {
                            ArrayList<GenericTypeDescription> genericTypeDescriptions = new ArrayList<GenericTypeDescription>(Nested.this.parameters.size());
                            for (GenericTypeToken parameter : Nested.this.parameters) {
                                genericTypeDescriptions.add(parameter.toGenericType(this.typePool, this.typeVariableSource));
                            }
                            return new GenericTypeList.Explicit(genericTypeDescriptions);
                        }

                        @Override
                        public GenericTypeDescription getOwnerType() {
                            return Nested.this.ownerType.toGenericType(this.typePool, this.typeVariableSource);
                        }
                    }
                }
            }

            public static class ForUpperBoundWildcard
            implements GenericTypeToken {
                private final GenericTypeToken baseType;

                public ForUpperBoundWildcard(GenericTypeToken baseType) {
                    this.baseType = baseType;
                }

                @Override
                public GenericTypeDescription.Sort getSort() {
                    return GenericTypeDescription.Sort.WILDCARD;
                }

                @Override
                public GenericTypeDescription toGenericType(TypePool typePool, TypeVariableSource typeVariableSource) {
                    return GenericTypeDescription.ForWildcardType.Latent.boundedAbove(this.baseType.toGenericType(typePool, typeVariableSource));
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.baseType.equals(((ForUpperBoundWildcard)other).baseType);
                }

                public int hashCode() {
                    return this.baseType.hashCode();
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.GenericTypeToken.ForUpperBoundWildcard{baseType=" + this.baseType + '}';
                }
            }

            public static class ForLowerBoundWildcard
            implements GenericTypeToken {
                private final GenericTypeToken baseType;

                public ForLowerBoundWildcard(GenericTypeToken baseType) {
                    this.baseType = baseType;
                }

                @Override
                public GenericTypeDescription.Sort getSort() {
                    return GenericTypeDescription.Sort.WILDCARD;
                }

                @Override
                public GenericTypeDescription toGenericType(TypePool typePool, TypeVariableSource typeVariableSource) {
                    return GenericTypeDescription.ForWildcardType.Latent.boundedBelow(this.baseType.toGenericType(typePool, typeVariableSource));
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.baseType.equals(((ForLowerBoundWildcard)other).baseType);
                }

                public int hashCode() {
                    return this.baseType.hashCode();
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.GenericTypeToken.ForLowerBoundWildcard{baseType=" + this.baseType + '}';
                }
            }

            public static class ForGenericArray
            implements GenericTypeToken {
                private final GenericTypeToken componentTypeToken;

                public ForGenericArray(GenericTypeToken componentTypeToken) {
                    this.componentTypeToken = componentTypeToken;
                }

                @Override
                public GenericTypeDescription.Sort getSort() {
                    return GenericTypeDescription.Sort.GENERIC_ARRAY;
                }

                @Override
                public GenericTypeDescription toGenericType(TypePool typePool, TypeVariableSource typeVariableSource) {
                    return GenericTypeDescription.ForGenericArray.Latent.of(this.componentTypeToken.toGenericType(typePool, typeVariableSource), 1);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.componentTypeToken.equals(((ForGenericArray)other).componentTypeToken);
                }

                public int hashCode() {
                    return this.componentTypeToken.hashCode();
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.GenericTypeToken.ForGenericArray{componentTypeToken='" + this.componentTypeToken + '\'' + '}';
                }
            }

            public static class ForTypeVariable
            implements GenericTypeToken {
                private final String symbol;

                public ForTypeVariable(String symbol) {
                    this.symbol = symbol;
                }

                @Override
                public GenericTypeDescription.Sort getSort() {
                    return GenericTypeDescription.Sort.VARIABLE;
                }

                @Override
                public GenericTypeDescription toGenericType(TypePool typePool, TypeVariableSource typeVariableSource) {
                    GenericTypeDescription typeVariable = typeVariableSource.findVariable(this.symbol);
                    if (typeVariable == null) {
                        throw new IllegalStateException("Cannot resolve type variable '" + this.symbol + "' for " + typeVariableSource);
                    }
                    return typeVariable;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.symbol.equals(((ForTypeVariable)other).symbol);
                }

                public int hashCode() {
                    return this.symbol.hashCode();
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.GenericTypeToken.ForTypeVariable{symbol='" + this.symbol + '\'' + '}';
                }

                public static class Formal
                implements GenericTypeToken {
                    private final String symbol;
                    private final List<GenericTypeToken> bounds;

                    public Formal(String symbol, List<GenericTypeToken> bounds) {
                        this.symbol = symbol;
                        this.bounds = bounds;
                    }

                    @Override
                    public GenericTypeDescription.Sort getSort() {
                        return GenericTypeDescription.Sort.VARIABLE;
                    }

                    @Override
                    public GenericTypeDescription toGenericType(TypePool typePool, TypeVariableSource typeVariableSource) {
                        return new LazyTypeVariable(typePool, typeVariableSource);
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.symbol.equals(((Formal)other).symbol) && this.bounds.equals(((Formal)other).bounds);
                    }

                    public int hashCode() {
                        return this.symbol.hashCode() + 31 * this.bounds.hashCode();
                    }

                    public String toString() {
                        return "TypePool.LazyTypeDescription.GenericTypeToken.ForTypeVariable.Formal{symbol='" + this.symbol + '\'' + "bounds='" + this.bounds + '\'' + '}';
                    }

                    protected class LazyTypeVariable
                    extends GenericTypeDescription.ForTypeVariable {
                        private final TypePool typePool;
                        private final TypeVariableSource typeVariableSource;

                        protected LazyTypeVariable(TypePool typePool, TypeVariableSource typeVariableSource) {
                            this.typePool = typePool;
                            this.typeVariableSource = typeVariableSource;
                        }

                        @Override
                        public GenericTypeList getUpperBounds() {
                            ArrayList<GenericTypeDescription> genericTypeDescriptions = new ArrayList<GenericTypeDescription>(Formal.this.bounds.size());
                            for (GenericTypeToken bound : Formal.this.bounds) {
                                genericTypeDescriptions.add(bound.toGenericType(this.typePool, this.typeVariableSource));
                            }
                            return new GenericTypeList.Explicit(genericTypeDescriptions);
                        }

                        @Override
                        public TypeVariableSource getVariableSource() {
                            return this.typeVariableSource;
                        }

                        @Override
                        public String getSymbol() {
                            return Formal.this.symbol;
                        }
                    }
                }
            }

            public static class ForRawType
            implements GenericTypeToken {
                private final String name;

                public ForRawType(String name) {
                    this.name = name;
                }

                @Override
                public GenericTypeDescription.Sort getSort() {
                    return GenericTypeDescription.Sort.NON_GENERIC;
                }

                @Override
                public GenericTypeDescription toGenericType(TypePool typePool, TypeVariableSource typeVariableSource) {
                    return typePool.describe(this.name).resolve();
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.name.equals(((ForRawType)other).name);
                }

                public int hashCode() {
                    return this.name.hashCode();
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.GenericTypeToken.ForRawType{name='" + this.name + '\'' + '}';
                }
            }

            public static interface Resolution {
                public GenericTypeList resolveTypeVariables(TypePool var1, TypeVariableSource var2);

                public static interface ForField {
                    public GenericTypeDescription resolveFieldType(String var1, TypePool var2, FieldDescription var3);

                    public static class Tokenized
                    implements ForField {
                        private final GenericTypeToken fieldTypeToken;

                        public Tokenized(GenericTypeToken fieldTypeToken) {
                            this.fieldTypeToken = fieldTypeToken;
                        }

                        @Override
                        public GenericTypeDescription resolveFieldType(String fieldTypeDescriptor, TypePool typePool, FieldDescription definingField) {
                            return new TokenizedGenericType(typePool, this.fieldTypeToken, fieldTypeDescriptor, definingField.getDeclaringType().asErasure());
                        }

                        public boolean equals(Object other) {
                            return this == other || other != null && this.getClass() == other.getClass() && this.fieldTypeToken.equals(((Tokenized)other).fieldTypeToken);
                        }

                        public int hashCode() {
                            return this.fieldTypeToken.hashCode();
                        }

                        public String toString() {
                            return "TypePool.LazyTypeDescription.GenericTypeToken.Resolution.ForField.Tokenized{fieldTypeToken=" + this.fieldTypeToken + '}';
                        }
                    }
                }

                public static interface ForMethod
                extends Resolution {
                    public GenericTypeDescription resolveReturnType(String var1, TypePool var2, MethodDescription var3);

                    public GenericTypeList resolveParameterTypes(List<String> var1, TypePool var2, MethodDescription var3);

                    public GenericTypeList resolveExceptionTypes(List<String> var1, TypePool var2, MethodDescription var3);

                    public static class Tokenized
                    implements ForMethod {
                        private final GenericTypeToken returnTypeToken;
                        private final List<GenericTypeToken> parameterTypeTokens;
                        private final List<GenericTypeToken> exceptionTypeTokens;
                        private final List<GenericTypeToken> typeVariableTokens;

                        public Tokenized(GenericTypeToken returnTypeToken, List<GenericTypeToken> parameterTypeTokens, List<GenericTypeToken> exceptionTypeTokens, List<GenericTypeToken> typeVariableTokens) {
                            this.returnTypeToken = returnTypeToken;
                            this.parameterTypeTokens = parameterTypeTokens;
                            this.exceptionTypeTokens = exceptionTypeTokens;
                            this.typeVariableTokens = typeVariableTokens;
                        }

                        @Override
                        public GenericTypeDescription resolveReturnType(String returnTypeDescriptor, TypePool typePool, MethodDescription definingMethod) {
                            return new TokenizedGenericType(typePool, this.returnTypeToken, returnTypeDescriptor, definingMethod);
                        }

                        @Override
                        public GenericTypeList resolveParameterTypes(List<String> parameterTypeDescriptors, TypePool typePool, MethodDescription definingMethod) {
                            return new TokenizedGenericType.TokenList(typePool, this.parameterTypeTokens, parameterTypeDescriptors, definingMethod);
                        }

                        @Override
                        public GenericTypeList resolveExceptionTypes(List<String> exceptionTypeDescriptors, TypePool typePool, MethodDescription definingMethod) {
                            return this.exceptionTypeTokens.isEmpty() ? new LazyTypeList(typePool, exceptionTypeDescriptors).asGenericTypes() : new TokenizedGenericType.TokenList(typePool, this.exceptionTypeTokens, exceptionTypeDescriptors, definingMethod);
                        }

                        @Override
                        public GenericTypeList resolveTypeVariables(TypePool typePool, TypeVariableSource typeVariableSource) {
                            return new TokenizedGenericType.TypeVariableList(typePool, this.typeVariableTokens, typeVariableSource);
                        }

                        public boolean equals(Object other) {
                            if (this == other) {
                                return true;
                            }
                            if (other == null || this.getClass() != other.getClass()) {
                                return false;
                            }
                            Tokenized tokenized = (Tokenized)other;
                            return this.returnTypeToken.equals(tokenized.returnTypeToken) && this.parameterTypeTokens.equals(tokenized.parameterTypeTokens) && this.exceptionTypeTokens.equals(tokenized.exceptionTypeTokens) && this.typeVariableTokens.equals(tokenized.typeVariableTokens);
                        }

                        public int hashCode() {
                            int result = this.returnTypeToken.hashCode();
                            result = 31 * result + this.parameterTypeTokens.hashCode();
                            result = 31 * result + this.exceptionTypeTokens.hashCode();
                            result = 31 * result + this.typeVariableTokens.hashCode();
                            return result;
                        }

                        public String toString() {
                            return "TypePool.LazyTypeDescription.GenericTypeToken.Resolution.ForMethod.Tokenized{returnTypeToken=" + this.returnTypeToken + ", parameterTypeTokens=" + this.parameterTypeTokens + ", exceptionTypeTokens=" + this.exceptionTypeTokens + ", typeVariableTokens=" + this.typeVariableTokens + '}';
                        }
                    }
                }

                public static interface ForType
                extends Resolution {
                    public GenericTypeDescription resolveSuperType(String var1, TypePool var2, TypeDescription var3);

                    public GenericTypeList resolveInterfaceTypes(List<String> var1, TypePool var2, TypeDescription var3);

                    public static class Tokenized
                    implements ForType {
                        private final GenericTypeToken superTypeToken;
                        private final List<GenericTypeToken> interfaceTypeTokens;
                        private final List<GenericTypeToken> typeVariableTokens;

                        public Tokenized(GenericTypeToken superTypeToken, List<GenericTypeToken> interfaceTypeTokens, List<GenericTypeToken> typeVariableTokens) {
                            this.superTypeToken = superTypeToken;
                            this.interfaceTypeTokens = interfaceTypeTokens;
                            this.typeVariableTokens = typeVariableTokens;
                        }

                        @Override
                        public GenericTypeDescription resolveSuperType(String superTypeDescriptor, TypePool typePool, TypeDescription definingType) {
                            return new TokenizedGenericType(typePool, this.superTypeToken, superTypeDescriptor, definingType);
                        }

                        @Override
                        public GenericTypeList resolveInterfaceTypes(List<String> interfaceTypeDescriptors, TypePool typePool, TypeDescription definingType) {
                            return new TokenizedGenericType.TokenList(typePool, this.interfaceTypeTokens, interfaceTypeDescriptors, definingType);
                        }

                        @Override
                        public GenericTypeList resolveTypeVariables(TypePool typePool, TypeVariableSource typeVariableSource) {
                            return new TokenizedGenericType.TypeVariableList(typePool, this.typeVariableTokens, typeVariableSource);
                        }

                        public boolean equals(Object other) {
                            if (this == other) {
                                return true;
                            }
                            if (other == null || this.getClass() != other.getClass()) {
                                return false;
                            }
                            Tokenized tokenized = (Tokenized)other;
                            return this.superTypeToken.equals(tokenized.superTypeToken) && this.interfaceTypeTokens.equals(tokenized.interfaceTypeTokens) && this.typeVariableTokens.equals(tokenized.typeVariableTokens);
                        }

                        public int hashCode() {
                            int result = this.superTypeToken.hashCode();
                            result = 31 * result + this.interfaceTypeTokens.hashCode();
                            result = 31 * result + this.typeVariableTokens.hashCode();
                            return result;
                        }

                        public String toString() {
                            return "TypePool.LazyTypeDescription.GenericTypeToken.Resolution.ForType.Tokenized{superTypeToken=" + this.superTypeToken + ", interfaceTypeTokens=" + this.interfaceTypeTokens + ", typeVariableTokens=" + this.typeVariableTokens + '}';
                        }
                    }
                }

                public static enum Malformed implements ForType,
                ForMethod,
                ForField
                {
                    INSTANCE;


                    @Override
                    public GenericTypeDescription resolveFieldType(String fieldTypeDescriptor, TypePool typePool, FieldDescription definingField) {
                        return new TokenizedGenericType.Malformed(typePool, fieldTypeDescriptor);
                    }

                    @Override
                    public GenericTypeDescription resolveReturnType(String returnTypeDescriptor, TypePool typePool, MethodDescription definingMethod) {
                        return new TokenizedGenericType.Malformed(typePool, returnTypeDescriptor);
                    }

                    @Override
                    public GenericTypeList resolveParameterTypes(List<String> parameterTypeDescriptors, TypePool typePool, MethodDescription definingMethod) {
                        return new TokenizedGenericType.Malformed.TokenList(typePool, parameterTypeDescriptors);
                    }

                    @Override
                    public GenericTypeList resolveExceptionTypes(List<String> exceptionTypeDescriptors, TypePool typePool, MethodDescription definingMethod) {
                        return new TokenizedGenericType.Malformed.TokenList(typePool, exceptionTypeDescriptors);
                    }

                    @Override
                    public GenericTypeDescription resolveSuperType(String superTypeDescriptor, TypePool typePool, TypeDescription definingType) {
                        return new TokenizedGenericType.Malformed(typePool, superTypeDescriptor);
                    }

                    @Override
                    public GenericTypeList resolveInterfaceTypes(List<String> interfaceTypeDescriptors, TypePool typePool, TypeDescription definingType) {
                        return new TokenizedGenericType.Malformed.TokenList(typePool, interfaceTypeDescriptors);
                    }

                    @Override
                    public GenericTypeList resolveTypeVariables(TypePool typePool, TypeVariableSource typeVariableSource) {
                        throw new GenericSignatureFormatError();
                    }

                    public String toString() {
                        return "TypePool.LazyTypeDescription.GenericTypeToken.Resolution.Malformed." + this.name();
                    }
                }

                public static enum Raw implements ForType,
                ForMethod,
                ForField
                {
                    INSTANCE;


                    @Override
                    public GenericTypeDescription resolveFieldType(String fieldTypeDescriptor, TypePool typePool, FieldDescription definingField) {
                        return TokenizedGenericType.toErasure(typePool, fieldTypeDescriptor);
                    }

                    @Override
                    public GenericTypeDescription resolveReturnType(String returnTypeDescriptor, TypePool typePool, MethodDescription definingMethod) {
                        return TokenizedGenericType.toErasure(typePool, returnTypeDescriptor);
                    }

                    @Override
                    public GenericTypeList resolveParameterTypes(List<String> parameterTypeDescriptors, TypePool typePool, MethodDescription definingMethod) {
                        return new LazyTypeList(typePool, parameterTypeDescriptors).asGenericTypes();
                    }

                    @Override
                    public GenericTypeList resolveExceptionTypes(List<String> exceptionTypeDescriptors, TypePool typePool, MethodDescription definingMethod) {
                        return new LazyTypeList(typePool, exceptionTypeDescriptors).asGenericTypes();
                    }

                    @Override
                    public GenericTypeDescription resolveSuperType(String superTypeDescriptor, TypePool typePool, TypeDescription definingType) {
                        return TokenizedGenericType.toErasure(typePool, superTypeDescriptor);
                    }

                    @Override
                    public GenericTypeList resolveInterfaceTypes(List<String> interfaceTypeDescriptors, TypePool typePool, TypeDescription definingType) {
                        return new LazyTypeList(typePool, interfaceTypeDescriptors).asGenericTypes();
                    }

                    @Override
                    public GenericTypeList resolveTypeVariables(TypePool typePool, TypeVariableSource typeVariableSource) {
                        return new GenericTypeList.Empty();
                    }

                    public String toString() {
                        return "TypePool.LazyTypeDescription.GenericTypeToken.Resolution.Raw." + this.name();
                    }
                }
            }

            public static enum ForUnboundWildcard implements GenericTypeToken
            {
                INSTANCE;


                @Override
                public GenericTypeDescription.Sort getSort() {
                    return GenericTypeDescription.Sort.WILDCARD;
                }

                @Override
                public GenericTypeDescription toGenericType(TypePool typePool, TypeVariableSource typeVariableSource) {
                    return GenericTypeDescription.ForWildcardType.Latent.unbounded();
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.GenericTypeToken.ForUnboundWildcard." + this.name();
                }
            }

            public static enum ForPrimitiveType implements GenericTypeToken
            {
                BOOLEAN(Boolean.TYPE),
                BYTE(Byte.TYPE),
                SHORT(Short.TYPE),
                CHAR(Character.TYPE),
                INTEGER(Integer.TYPE),
                LONG(Long.TYPE),
                FLOAT(Float.TYPE),
                DOUBLE(Double.TYPE),
                VOID(Void.TYPE);

                private final TypeDescription typeDescription;

                private ForPrimitiveType(Class<?> type) {
                    this.typeDescription = new TypeDescription.ForLoadedType(type);
                }

                public static GenericTypeToken of(char descriptor) {
                    switch (descriptor) {
                        case 'V': {
                            return VOID;
                        }
                        case 'Z': {
                            return BOOLEAN;
                        }
                        case 'B': {
                            return BYTE;
                        }
                        case 'S': {
                            return SHORT;
                        }
                        case 'C': {
                            return CHAR;
                        }
                        case 'I': {
                            return INTEGER;
                        }
                        case 'J': {
                            return LONG;
                        }
                        case 'F': {
                            return FLOAT;
                        }
                        case 'D': {
                            return DOUBLE;
                        }
                    }
                    throw new IllegalArgumentException("Not a valid primitive type descriptor: " + descriptor);
                }

                @Override
                public GenericTypeDescription.Sort getSort() {
                    return GenericTypeDescription.Sort.NON_GENERIC;
                }

                @Override
                public GenericTypeDescription toGenericType(TypePool typePool, TypeVariableSource typeVariableSource) {
                    return this.typeDescription;
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.GenericTypeToken.ForPrimitiveType." + this.name();
                }
            }
        }

        protected static interface DeclarationContext {
            public MethodDescription getEnclosingMethod(TypePool var1);

            public TypeDescription getEnclosingType(TypePool var1);

            public boolean isSelfDeclared();

            public boolean isDeclaredInType();

            public boolean isDeclaredInMethod();

            public static class DeclaredInMethod
            implements DeclarationContext {
                private final String name;
                private final String methodName;
                private final String methodDescriptor;

                public DeclaredInMethod(String internalName, String methodName, String methodDescriptor) {
                    this.name = internalName.replace('/', '.');
                    this.methodName = methodName;
                    this.methodDescriptor = methodDescriptor;
                }

                @Override
                public MethodDescription getEnclosingMethod(TypePool typePool) {
                    return (MethodDescription)((MethodList)this.getEnclosingType(typePool).getDeclaredMethods().filter(ElementMatchers.hasMethodName(this.methodName).and(ElementMatchers.hasDescriptor(this.methodDescriptor)))).getOnly();
                }

                @Override
                public TypeDescription getEnclosingType(TypePool typePool) {
                    return typePool.describe(this.name).resolve();
                }

                @Override
                public boolean isSelfDeclared() {
                    return false;
                }

                @Override
                public boolean isDeclaredInType() {
                    return false;
                }

                @Override
                public boolean isDeclaredInMethod() {
                    return true;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    DeclaredInMethod that = (DeclaredInMethod)other;
                    return this.methodDescriptor.equals(that.methodDescriptor) && this.methodName.equals(that.methodName) && this.name.equals(that.name);
                }

                public int hashCode() {
                    int result = this.name.hashCode();
                    result = 31 * result + this.methodName.hashCode();
                    result = 31 * result + this.methodDescriptor.hashCode();
                    return result;
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.DeclarationContext.DeclaredInMethod{name='" + this.name + '\'' + ", methodName='" + this.methodName + '\'' + ", methodDescriptor='" + this.methodDescriptor + '\'' + '}';
                }
            }

            public static class DeclaredInType
            implements DeclarationContext {
                private final String name;

                public DeclaredInType(String internalName) {
                    this.name = internalName.replace('/', '.');
                }

                @Override
                public MethodDescription getEnclosingMethod(TypePool typePool) {
                    return MethodDescription.UNDEFINED;
                }

                @Override
                public TypeDescription getEnclosingType(TypePool typePool) {
                    return typePool.describe(this.name).resolve();
                }

                @Override
                public boolean isSelfDeclared() {
                    return false;
                }

                @Override
                public boolean isDeclaredInType() {
                    return true;
                }

                @Override
                public boolean isDeclaredInMethod() {
                    return false;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.name.equals(((DeclaredInType)other).name);
                }

                public int hashCode() {
                    return this.name.hashCode();
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.DeclarationContext.DeclaredInType{name='" + this.name + '\'' + '}';
                }
            }

            public static enum SelfDeclared implements DeclarationContext
            {
                INSTANCE;


                @Override
                public MethodDescription getEnclosingMethod(TypePool typePool) {
                    return MethodDescription.UNDEFINED;
                }

                @Override
                public TypeDescription getEnclosingType(TypePool typePool) {
                    return TypeDescription.UNDEFINED;
                }

                @Override
                public boolean isSelfDeclared() {
                    return true;
                }

                @Override
                public boolean isDeclaredInType() {
                    return false;
                }

                @Override
                public boolean isDeclaredInMethod() {
                    return false;
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.DeclarationContext.SelfDeclared." + this.name();
                }
            }
        }
    }

    public static class LazyFacade
    extends AbstractBase {
        private final TypePool typePool;

        public LazyFacade(TypePool typePool) {
            super(CacheProvider.NoOp.INSTANCE);
            this.typePool = typePool;
        }

        @Override
        protected Resolution doDescribe(String name) {
            return new LazyResolution(this.typePool, name);
        }

        @Override
        public void clear() {
            this.typePool.clear();
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.typePool.equals(((LazyFacade)other).typePool);
        }

        @Override
        public int hashCode() {
            return this.typePool.hashCode();
        }

        public String toString() {
            return "TypePool.LazyFacade{typePool=" + this.typePool + '}';
        }

        protected static class LazyResolution
        implements Resolution {
            private final TypePool typePool;
            private final String name;

            protected LazyResolution(TypePool typePool, String name) {
                this.typePool = typePool;
                this.name = name;
            }

            @Override
            public boolean isResolved() {
                return this.typePool.describe(this.name).isResolved();
            }

            @Override
            public TypeDescription resolve() {
                return new LazyTypeDescription(this.typePool, this.name);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                LazyResolution that = (LazyResolution)other;
                return this.typePool.equals(that.typePool) && this.name.equals(that.name);
            }

            public int hashCode() {
                int result = this.typePool.hashCode();
                result = 31 * result + this.name.hashCode();
                return result;
            }

            public String toString() {
                return "TypePool.LazyFacade.LazyResolution{typePool=" + this.typePool + ", name=" + this.name + '}';
            }

            protected static class LazyTypeDescription
            extends TypeDescription.AbstractBase.OfSimpleType {
                private final TypePool typePool;
                private final String name;

                protected LazyTypeDescription(TypePool typePool, String name) {
                    this.typePool = typePool;
                    this.name = name;
                }

                private TypeDescription resolve() {
                    return this.typePool.describe(this.name).resolve();
                }

                @Override
                public GenericTypeDescription getSuperType() {
                    return this.resolve().getSuperType();
                }

                @Override
                protected GenericTypeDescription getDeclaredSuperType() {
                    throw new IllegalStateException("Cannot resolve declared super type for lazy facade: " + this);
                }

                @Override
                public GenericTypeList getInterfaces() {
                    return this.resolve().getInterfaces();
                }

                @Override
                protected GenericTypeList getDeclaredInterfaces() {
                    throw new IllegalStateException("Cannot resolve declared interfaces for lazy facade: " + this);
                }

                @Override
                public FieldList<FieldDescription.InDefinedShape> getDeclaredFields() {
                    return this.resolve().getDeclaredFields();
                }

                @Override
                public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods() {
                    return this.resolve().getDeclaredMethods();
                }

                @Override
                public TypeDescription getDeclaringType() {
                    return this.resolve().getDeclaringType();
                }

                @Override
                public MethodDescription getEnclosingMethod() {
                    return this.resolve().getEnclosingMethod();
                }

                @Override
                public TypeDescription getEnclosingType() {
                    return this.resolve().getEnclosingType();
                }

                @Override
                public boolean isAnonymousClass() {
                    return this.resolve().isAnonymousClass();
                }

                @Override
                public boolean isLocalClass() {
                    return this.resolve().isLocalClass();
                }

                @Override
                public boolean isMemberClass() {
                    return this.resolve().isMemberClass();
                }

                @Override
                public PackageDescription getPackage() {
                    return this.resolve().getPackage();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return this.resolve().getDeclaredAnnotations();
                }

                @Override
                public GenericTypeList getTypeVariables() {
                    return this.resolve().getTypeVariables();
                }

                @Override
                public int getModifiers() {
                    return this.resolve().getModifiers();
                }

                @Override
                public String getName() {
                    return this.name;
                }
            }
        }
    }

    public static class Default
    extends AbstractBase {
        private static final MethodVisitor IGNORE_METHOD = null;
        private static final int ASM_API_VERSION = 327680;
        private final ClassFileLocator classFileLocator;
        private final ReaderMode readerMode;

        public Default(CacheProvider cacheProvider, ClassFileLocator classFileLocator, ReaderMode readerMode) {
            super(cacheProvider);
            this.classFileLocator = classFileLocator;
            this.readerMode = readerMode;
        }

        public static TypePool ofClassPath() {
            return new Default(new CacheProvider.Simple(), ClassFileLocator.ForClassLoader.ofClassPath(), ReaderMode.FAST);
        }

        @Override
        protected Resolution doDescribe(String name) {
            try {
                ClassFileLocator.Resolution resolution = this.classFileLocator.locate(name);
                return resolution.isResolved() ? new Resolution.Simple(this.parse(resolution.resolve())) : new Resolution.Illegal(name);
            }
            catch (IOException exception) {
                throw new IllegalStateException("Error while reading class file", exception);
            }
        }

        private TypeDescription parse(byte[] binaryRepresentation) {
            ClassReader classReader = new ClassReader(binaryRepresentation);
            TypeExtractor typeExtractor = new TypeExtractor();
            classReader.accept(typeExtractor, this.readerMode.getFlags());
            return typeExtractor.toTypeDescription();
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.classFileLocator.equals(((Default)other).classFileLocator) && this.readerMode.equals((Object)((Default)other).readerMode);
        }

        @Override
        public int hashCode() {
            return 31 * (31 * super.hashCode() + this.classFileLocator.hashCode()) + this.readerMode.hashCode();
        }

        public String toString() {
            return "TypePool.Default{classFileLocator=" + this.classFileLocator + ", cacheProvider=" + this.cacheProvider + ", readerMode=" + (Object)((Object)this.readerMode) + '}';
        }

        public static enum ReaderMode {
            EXTENDED(4),
            FAST(1);

            private final int flags;

            private ReaderMode(int flags) {
                this.flags = flags;
            }

            protected int getFlags() {
                return this.flags;
            }

            public boolean isExtended() {
                return this == EXTENDED;
            }

            public String toString() {
                return "TypePool.Default.ReaderMode." + this.name();
            }
        }

        protected class TypeExtractor
        extends ClassVisitor {
            private final List<LazyTypeDescription.AnnotationToken> annotationTokens;
            private final List<LazyTypeDescription.FieldToken> fieldTokens;
            private final List<LazyTypeDescription.MethodToken> methodTokens;
            private int modifiers;
            private String internalName;
            private String superTypeName;
            private String genericSignature;
            private String[] interfaceName;
            private boolean anonymousType;
            private LazyTypeDescription.DeclarationContext declarationContext;

            protected TypeExtractor() {
                super(327680);
                this.annotationTokens = new LinkedList<LazyTypeDescription.AnnotationToken>();
                this.fieldTokens = new LinkedList<LazyTypeDescription.FieldToken>();
                this.methodTokens = new LinkedList<LazyTypeDescription.MethodToken>();
                this.anonymousType = false;
                this.declarationContext = LazyTypeDescription.DeclarationContext.SelfDeclared.INSTANCE;
            }

            @Override
            @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="The received value is never modified")
            public void visit(int classFileVersion, int modifiers, String internalName, String genericSignature, String superTypeName, String[] interfaceName) {
                this.modifiers = modifiers;
                this.internalName = internalName;
                this.genericSignature = genericSignature;
                this.superTypeName = superTypeName;
                this.interfaceName = interfaceName;
            }

            @Override
            public void visitOuterClass(String typeName, String methodName, String methodDescriptor) {
                if (methodName != null) {
                    this.declarationContext = new LazyTypeDescription.DeclarationContext.DeclaredInMethod(typeName, methodName, methodDescriptor);
                } else if (typeName != null) {
                    this.declarationContext = new LazyTypeDescription.DeclarationContext.DeclaredInType(typeName);
                }
            }

            @Override
            public void visitInnerClass(String internalName, String outerName, String innerName, int modifiers) {
                if (internalName.equals(this.internalName)) {
                    this.modifiers = modifiers;
                    if (innerName == null) {
                        this.anonymousType = true;
                    }
                    if (outerName != null && this.declarationContext.isSelfDeclared()) {
                        this.declarationContext = new LazyTypeDescription.DeclarationContext.DeclaredInType(outerName);
                    }
                }
            }

            @Override
            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                return new AnnotationExtractor(new OnTypeCollector(descriptor), new ComponentTypeLocator.ForAnnotationProperty(Default.this, descriptor));
            }

            @Override
            public FieldVisitor visitField(int modifiers, String internalName, String descriptor, String genericSignature, Object defaultValue) {
                return new FieldExtractor(modifiers, internalName, descriptor, genericSignature);
            }

            @Override
            public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String genericSignature, String[] exceptionName) {
                return internalName.equals("<clinit>") ? IGNORE_METHOD : new MethodExtractor(modifiers, internalName, descriptor, genericSignature, exceptionName);
            }

            protected TypeDescription toTypeDescription() {
                return new LazyTypeDescription(Default.this, this.modifiers, this.internalName, this.superTypeName, this.interfaceName, GenericTypeExtractor.ForSignature.OfType.extract(this.genericSignature), this.declarationContext, this.anonymousType, this.annotationTokens, this.fieldTokens, this.methodTokens);
            }

            public String toString() {
                return "TypePool.Default.TypeExtractor{typePool=" + Default.this + ", annotationTokens=" + this.annotationTokens + ", fieldTokens=" + this.fieldTokens + ", methodTokens=" + this.methodTokens + ", modifiers=" + this.modifiers + ", internalName='" + this.internalName + '\'' + ", superTypeName='" + this.superTypeName + '\'' + ", genericSignature='" + this.genericSignature + '\'' + ", interfaceName=" + Arrays.toString(this.interfaceName) + ", anonymousType=" + this.anonymousType + ", declarationContext=" + this.declarationContext + '}';
            }

            protected class MethodExtractor
            extends MethodVisitor
            implements AnnotationRegistrant {
                private final int modifiers;
                private final String internalName;
                private final String descriptor;
                private final String genericSignature;
                private final String[] exceptionName;
                private final List<LazyTypeDescription.AnnotationToken> annotationTokens;
                private final Map<Integer, List<LazyTypeDescription.AnnotationToken>> parameterAnnotationTokens;
                private final List<LazyTypeDescription.MethodToken.ParameterToken> parameterTokens;
                private final ParameterBag legacyParameterBag;
                private Label firstLabel;
                private AnnotationDescription.AnnotationValue<?, ?> defaultValue;

                protected MethodExtractor(int modifiers, String internalName, String descriptor, String genericSignature, String[] exceptionName) {
                    super(327680);
                    this.modifiers = modifiers;
                    this.internalName = internalName;
                    this.descriptor = descriptor;
                    this.genericSignature = genericSignature;
                    this.exceptionName = exceptionName;
                    this.annotationTokens = new LinkedList<LazyTypeDescription.AnnotationToken>();
                    Type[] parameterTypes = Type.getMethodType(descriptor).getArgumentTypes();
                    this.parameterAnnotationTokens = new HashMap<Integer, List<LazyTypeDescription.AnnotationToken>>(parameterTypes.length);
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        this.parameterAnnotationTokens.put(i, new LinkedList());
                    }
                    this.parameterTokens = new ArrayList<LazyTypeDescription.MethodToken.ParameterToken>(parameterTypes.length);
                    this.legacyParameterBag = new ParameterBag(parameterTypes);
                }

                @Override
                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    return new AnnotationExtractor(new OnMethodCollector(descriptor), new ComponentTypeLocator.ForAnnotationProperty(Default.this, descriptor));
                }

                @Override
                public AnnotationVisitor visitParameterAnnotation(int index, String descriptor, boolean visible) {
                    return new AnnotationExtractor(new OnMethodParameterCollector(descriptor, index), new ComponentTypeLocator.ForAnnotationProperty(Default.this, descriptor));
                }

                @Override
                public void visitLabel(Label label) {
                    if (Default.this.readerMode.isExtended() && this.firstLabel == null) {
                        this.firstLabel = label;
                    }
                }

                @Override
                public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
                    if (Default.this.readerMode.isExtended() && start == this.firstLabel) {
                        this.legacyParameterBag.register(index, name);
                    }
                }

                @Override
                public void visitParameter(String name, int modifiers) {
                    this.parameterTokens.add(new LazyTypeDescription.MethodToken.ParameterToken(name, modifiers));
                }

                @Override
                public AnnotationVisitor visitAnnotationDefault() {
                    return new AnnotationExtractor(this, new ComponentTypeLocator.ForArrayType(this.descriptor));
                }

                @Override
                public void register(String ignored, AnnotationDescription.AnnotationValue<?, ?> annotationValue) {
                    this.defaultValue = annotationValue;
                }

                @Override
                public void onComplete() {
                }

                @Override
                public void visitEnd() {
                    TypeExtractor.this.methodTokens.add(new LazyTypeDescription.MethodToken(this.internalName, this.modifiers, this.descriptor, GenericTypeExtractor.ForSignature.OfMethod.extract(this.genericSignature), this.exceptionName, this.annotationTokens, this.parameterAnnotationTokens, this.parameterTokens.isEmpty() ? this.legacyParameterBag.resolve((this.modifiers & 8) != 0) : this.parameterTokens, this.defaultValue));
                }

                public String toString() {
                    return "TypePool.Default.TypeExtractor.MethodExtractor{typeExtractor=" + TypeExtractor.this + ", modifiers=" + this.modifiers + ", internalName='" + this.internalName + '\'' + ", descriptor='" + this.descriptor + '\'' + ", genericSignature='" + this.genericSignature + '\'' + ", exceptionName=" + Arrays.toString(this.exceptionName) + ", annotationTokens=" + this.annotationTokens + ", parameterAnnotationTokens=" + this.parameterAnnotationTokens + ", parameterTokens=" + this.parameterTokens + ", legacyParameterBag=" + this.legacyParameterBag + ", firstLabel=" + this.firstLabel + ", defaultValue=" + this.defaultValue + '}';
                }

                protected class OnMethodParameterCollector
                implements AnnotationRegistrant {
                    private final String descriptor;
                    private final int index;
                    private final Map<String, AnnotationDescription.AnnotationValue<?, ?>> values;

                    protected OnMethodParameterCollector(String descriptor, int index) {
                        this.descriptor = descriptor;
                        this.index = index;
                        this.values = new HashMap();
                    }

                    @Override
                    public void register(String name, AnnotationDescription.AnnotationValue<?, ?> annotationValue) {
                        this.values.put(name, annotationValue);
                    }

                    @Override
                    public void onComplete() {
                        ((List)MethodExtractor.this.parameterAnnotationTokens.get(this.index)).add(new LazyTypeDescription.AnnotationToken(this.descriptor, this.values));
                    }

                    public String toString() {
                        return "TypePool.Default.TypeExtractor.MethodExtractor.OnMethodParameterCollector{methodExtractor=" + MethodExtractor.this + ", descriptor='" + this.descriptor + '\'' + ", index=" + this.index + ", values=" + this.values + '}';
                    }
                }

                protected class OnMethodCollector
                implements AnnotationRegistrant {
                    private final String descriptor;
                    private final Map<String, AnnotationDescription.AnnotationValue<?, ?>> values;

                    protected OnMethodCollector(String descriptor) {
                        this.descriptor = descriptor;
                        this.values = new HashMap();
                    }

                    @Override
                    public void register(String name, AnnotationDescription.AnnotationValue<?, ?> annotationValue) {
                        this.values.put(name, annotationValue);
                    }

                    @Override
                    public void onComplete() {
                        MethodExtractor.this.annotationTokens.add(new LazyTypeDescription.AnnotationToken(this.descriptor, this.values));
                    }

                    public String toString() {
                        return "TypePool.Default.TypeExtractor.MethodExtractor.OnMethodCollector{methodExtractor=" + MethodExtractor.this + ", descriptor='" + this.descriptor + '\'' + ", values=" + this.values + '}';
                    }
                }
            }

            protected class FieldExtractor
            extends FieldVisitor {
                private final int modifiers;
                private final String internalName;
                private final String descriptor;
                private final String genericSignature;
                private final List<LazyTypeDescription.AnnotationToken> annotationTokens;

                protected FieldExtractor(int modifiers, String internalName, String descriptor, String genericSignature) {
                    super(327680);
                    this.modifiers = modifiers;
                    this.internalName = internalName;
                    this.descriptor = descriptor;
                    this.genericSignature = genericSignature;
                    this.annotationTokens = new LinkedList<LazyTypeDescription.AnnotationToken>();
                }

                @Override
                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    return new AnnotationExtractor(new OnFieldCollector(descriptor), new ComponentTypeLocator.ForAnnotationProperty(Default.this, descriptor));
                }

                @Override
                public void visitEnd() {
                    TypeExtractor.this.fieldTokens.add(new LazyTypeDescription.FieldToken(this.internalName, this.modifiers, this.descriptor, GenericTypeExtractor.ForSignature.OfField.extract(this.genericSignature), this.annotationTokens));
                }

                public String toString() {
                    return "TypePool.Default.TypeExtractor.FieldExtractor{typeExtractor=" + TypeExtractor.this + ", modifiers=" + this.modifiers + ", internalName='" + this.internalName + '\'' + ", descriptor='" + this.descriptor + '\'' + ", genericSignature='" + this.genericSignature + '\'' + ", annotationTokens=" + this.annotationTokens + '}';
                }

                protected class OnFieldCollector
                implements AnnotationRegistrant {
                    private final String descriptor;
                    private final Map<String, AnnotationDescription.AnnotationValue<?, ?>> values;

                    protected OnFieldCollector(String descriptor) {
                        this.descriptor = descriptor;
                        this.values = new HashMap();
                    }

                    @Override
                    public void register(String name, AnnotationDescription.AnnotationValue<?, ?> annotationValue) {
                        this.values.put(name, annotationValue);
                    }

                    @Override
                    public void onComplete() {
                        FieldExtractor.this.annotationTokens.add(new LazyTypeDescription.AnnotationToken(this.descriptor, this.values));
                    }

                    public String toString() {
                        return "TypePool.Default.TypeExtractor.FieldExtractor.OnFieldCollector{fieldExtractor=" + FieldExtractor.this + ", descriptor='" + this.descriptor + '\'' + ", values=" + this.values + '}';
                    }
                }
            }

            protected class AnnotationExtractor
            extends AnnotationVisitor {
                private final AnnotationRegistrant annotationRegistrant;
                private final ComponentTypeLocator componentTypeLocator;

                protected AnnotationExtractor(AnnotationRegistrant annotationRegistrant, ComponentTypeLocator componentTypeLocator) {
                    super(327680);
                    this.annotationRegistrant = annotationRegistrant;
                    this.componentTypeLocator = componentTypeLocator;
                }

                @Override
                public void visit(String name, Object value) {
                    this.annotationRegistrant.register(name, value instanceof Type ? new AbstractBase.RawTypeValue(Default.this, (Type)value) : new AnnotationDescription.AnnotationValue.Trivial<Object>(value));
                }

                @Override
                public void visitEnum(String name, String descriptor, String value) {
                    this.annotationRegistrant.register(name, new AbstractBase.RawEnumerationValue(Default.this, descriptor, value));
                }

                @Override
                public AnnotationVisitor visitAnnotation(String name, String descriptor) {
                    return new AnnotationExtractor(new AnnotationLookup(name, descriptor), new ComponentTypeLocator.ForAnnotationProperty(Default.this, descriptor));
                }

                @Override
                public AnnotationVisitor visitArray(String name) {
                    return new AnnotationExtractor(new ArrayLookup(name, this.componentTypeLocator.bind(name)), ComponentTypeLocator.Illegal.INSTANCE);
                }

                @Override
                public void visitEnd() {
                    this.annotationRegistrant.onComplete();
                }

                public String toString() {
                    return "TypePool.Default.TypeExtractor.AnnotationExtractor{typeExtractor=" + TypeExtractor.this + "annotationRegistrant=" + this.annotationRegistrant + ", componentTypeLocator=" + this.componentTypeLocator + '}';
                }

                protected class AnnotationLookup
                implements AnnotationRegistrant {
                    private final String name;
                    private final String descriptor;
                    private final Map<String, AnnotationDescription.AnnotationValue<?, ?>> values;

                    protected AnnotationLookup(String name, String descriptor) {
                        this.name = name;
                        this.descriptor = descriptor;
                        this.values = new HashMap();
                    }

                    @Override
                    public void register(String name, AnnotationDescription.AnnotationValue<?, ?> annotationValue) {
                        this.values.put(name, annotationValue);
                    }

                    @Override
                    public void onComplete() {
                        AnnotationExtractor.this.annotationRegistrant.register(this.name, new AbstractBase.RawAnnotationValue(Default.this, new LazyTypeDescription.AnnotationToken(this.descriptor, this.values)));
                    }

                    public String toString() {
                        return "TypePool.Default.TypeExtractor.AnnotationExtractor.AnnotationLookup{annotationExtractor=" + AnnotationExtractor.this + ", name='" + this.name + '\'' + ", descriptor='" + this.descriptor + '\'' + ", values=" + this.values + '}';
                    }
                }

                protected class ArrayLookup
                implements AnnotationRegistrant {
                    private final String name;
                    private final AbstractBase.RawNonPrimitiveArray.ComponentTypeReference componentTypeReference;
                    private final List<AnnotationDescription.AnnotationValue<?, ?>> values;

                    protected ArrayLookup(String name, AbstractBase.RawNonPrimitiveArray.ComponentTypeReference componentTypeReference) {
                        this.name = name;
                        this.componentTypeReference = componentTypeReference;
                        this.values = new LinkedList();
                    }

                    @Override
                    public void register(String ignored, AnnotationDescription.AnnotationValue<?, ?> annotationValue) {
                        this.values.add(annotationValue);
                    }

                    @Override
                    public void onComplete() {
                        AnnotationExtractor.this.annotationRegistrant.register(this.name, new AbstractBase.RawNonPrimitiveArray(Default.this, this.componentTypeReference, this.values));
                    }

                    public String toString() {
                        return "TypePool.Default.TypeExtractor.AnnotationExtractor.ArrayLookup{annotationExtractor=" + AnnotationExtractor.this + ", name='" + this.name + '\'' + ", componentTypeReference=" + this.componentTypeReference + ", values=" + this.values + '}';
                    }
                }
            }

            protected class OnTypeCollector
            implements AnnotationRegistrant {
                private final String descriptor;
                private final Map<String, AnnotationDescription.AnnotationValue<?, ?>> values;

                protected OnTypeCollector(String descriptor) {
                    this.descriptor = descriptor;
                    this.values = new HashMap();
                }

                @Override
                public void register(String name, AnnotationDescription.AnnotationValue<?, ?> annotationValue) {
                    this.values.put(name, annotationValue);
                }

                @Override
                public void onComplete() {
                    TypeExtractor.this.annotationTokens.add(new LazyTypeDescription.AnnotationToken(this.descriptor, this.values));
                }

                public String toString() {
                    return "TypePool.Default.TypeExtractor.OnTypeCollector{typeExtractor=" + TypeExtractor.this + ", descriptor='" + this.descriptor + '\'' + ", values=" + this.values + '}';
                }
            }
        }

        protected static class GenericTypeExtractor
        extends GenericTypeRegistrant.RejectingSignatureVisitor
        implements GenericTypeRegistrant {
            private final GenericTypeRegistrant genericTypeRegistrant;
            private IncompleteToken incompleteToken;

            protected GenericTypeExtractor(GenericTypeRegistrant genericTypeRegistrant) {
                this.genericTypeRegistrant = genericTypeRegistrant;
            }

            @Override
            public void visitBaseType(char descriptor) {
                this.genericTypeRegistrant.register(LazyTypeDescription.GenericTypeToken.ForPrimitiveType.of(descriptor));
            }

            @Override
            public void visitTypeVariable(String name) {
                this.genericTypeRegistrant.register(new LazyTypeDescription.GenericTypeToken.ForTypeVariable(name));
            }

            @Override
            public SignatureVisitor visitArrayType() {
                return new GenericTypeExtractor(this);
            }

            @Override
            public void register(LazyTypeDescription.GenericTypeToken componentTypeToken) {
                this.genericTypeRegistrant.register(new LazyTypeDescription.GenericTypeToken.ForGenericArray(componentTypeToken));
            }

            @Override
            public void visitClassType(String name) {
                this.incompleteToken = new IncompleteToken.ForTopLevelType(name);
            }

            @Override
            public void visitInnerClassType(String name) {
                this.incompleteToken = new IncompleteToken.ForInnerClass(name, this.incompleteToken);
            }

            @Override
            public void visitTypeArgument() {
                this.incompleteToken.appendPlaceholder();
            }

            @Override
            public SignatureVisitor visitTypeArgument(char wildcard) {
                switch (wildcard) {
                    case '-': {
                        return this.incompleteToken.appendLowerBound();
                    }
                    case '+': {
                        return this.incompleteToken.appendUpperBound();
                    }
                    case '=': {
                        return this.incompleteToken.appendDirectBound();
                    }
                }
                throw new IllegalArgumentException("Unknown wildcard: " + wildcard);
            }

            @Override
            public void visitEnd() {
                this.genericTypeRegistrant.register(this.incompleteToken.toToken());
            }

            @Override
            public String toString() {
                return "TypePool.Default.GenericTypeExtractor{genericTypeRegistrant=" + this.genericTypeRegistrant + ", incompleteToken=" + this.incompleteToken + '}';
            }

            protected static abstract class ForSignature<T extends LazyTypeDescription.GenericTypeToken.Resolution>
            extends GenericTypeRegistrant.RejectingSignatureVisitor
            implements GenericTypeRegistrant {
                protected final List<LazyTypeDescription.GenericTypeToken> typeVariableTokens = new LinkedList<LazyTypeDescription.GenericTypeToken>();
                protected String currentTypeParameter;
                protected List<LazyTypeDescription.GenericTypeToken> currentBounds;

                protected static <S extends LazyTypeDescription.GenericTypeToken.Resolution> S extract(String genericSignature, ForSignature<S> visitor) {
                    SignatureReader signatureReader = new SignatureReader(genericSignature);
                    signatureReader.accept(visitor);
                    return visitor.resolve();
                }

                @Override
                public void visitFormalTypeParameter(String name) {
                    this.collectTypeParameter();
                    this.currentTypeParameter = name;
                    this.currentBounds = new LinkedList<LazyTypeDescription.GenericTypeToken>();
                }

                @Override
                public SignatureVisitor visitClassBound() {
                    return new GenericTypeExtractor(this);
                }

                @Override
                public SignatureVisitor visitInterfaceBound() {
                    return new GenericTypeExtractor(this);
                }

                @Override
                public void register(LazyTypeDescription.GenericTypeToken token) {
                    if (this.currentBounds == null) {
                        throw new IllegalStateException("Did not expect " + token + " before finding formal parameter");
                    }
                    this.currentBounds.add(token);
                }

                protected void collectTypeParameter() {
                    if (this.currentTypeParameter != null) {
                        this.typeVariableTokens.add(new LazyTypeDescription.GenericTypeToken.ForTypeVariable.Formal(this.currentTypeParameter, this.currentBounds));
                    }
                }

                public abstract T resolve();

                protected static class OfField
                implements GenericTypeRegistrant {
                    private LazyTypeDescription.GenericTypeToken fieldTypeToken;

                    protected OfField() {
                    }

                    public static LazyTypeDescription.GenericTypeToken.Resolution.ForField extract(String genericSignature) {
                        if (genericSignature == null) {
                            return LazyTypeDescription.GenericTypeToken.Resolution.Raw.INSTANCE;
                        }
                        SignatureReader signatureReader = new SignatureReader(genericSignature);
                        OfField visitor = new OfField();
                        try {
                            signatureReader.acceptType(new GenericTypeExtractor(visitor));
                            return visitor.resolve();
                        }
                        catch (RuntimeException ignored) {
                            return LazyTypeDescription.GenericTypeToken.Resolution.Malformed.INSTANCE;
                        }
                    }

                    @Override
                    public void register(LazyTypeDescription.GenericTypeToken token) {
                        this.fieldTypeToken = token;
                    }

                    protected LazyTypeDescription.GenericTypeToken.Resolution.ForField resolve() {
                        return new LazyTypeDescription.GenericTypeToken.Resolution.ForField.Tokenized(this.fieldTypeToken);
                    }

                    public String toString() {
                        return "TypePool.Default.GenericTypeExtractor.ForSignature.OfField{fieldTypeToken=" + this.fieldTypeToken + '}';
                    }
                }

                protected static class OfMethod
                extends ForSignature<LazyTypeDescription.GenericTypeToken.Resolution.ForMethod> {
                    private final List<LazyTypeDescription.GenericTypeToken> parameterTypeTokens = new LinkedList<LazyTypeDescription.GenericTypeToken>();
                    private final List<LazyTypeDescription.GenericTypeToken> exceptionTypeTokens = new LinkedList<LazyTypeDescription.GenericTypeToken>();
                    private LazyTypeDescription.GenericTypeToken returnTypeToken;

                    public static LazyTypeDescription.GenericTypeToken.Resolution.ForMethod extract(String genericSignature) {
                        try {
                            return genericSignature == null ? LazyTypeDescription.GenericTypeToken.Resolution.Raw.INSTANCE : ForSignature.extract(genericSignature, new OfMethod());
                        }
                        catch (RuntimeException ignored) {
                            return LazyTypeDescription.GenericTypeToken.Resolution.Malformed.INSTANCE;
                        }
                    }

                    @Override
                    public SignatureVisitor visitParameterType() {
                        return new GenericTypeExtractor(new ParameterTypeRegistrant());
                    }

                    @Override
                    public SignatureVisitor visitReturnType() {
                        this.collectTypeParameter();
                        return new GenericTypeExtractor(new ReturnTypeTypeRegistrant());
                    }

                    @Override
                    public SignatureVisitor visitExceptionType() {
                        return new GenericTypeExtractor(new ExceptionTypeRegistrant());
                    }

                    @Override
                    public LazyTypeDescription.GenericTypeToken.Resolution.ForMethod resolve() {
                        return new LazyTypeDescription.GenericTypeToken.Resolution.ForMethod.Tokenized(this.returnTypeToken, this.parameterTypeTokens, this.exceptionTypeTokens, this.typeVariableTokens);
                    }

                    @Override
                    public String toString() {
                        return "TypePool.Default.GenericTypeExtractor.ForSignature.OfMethod{currentTypeParameter='" + this.currentTypeParameter + '\'' + ", currentBounds=" + this.currentBounds + ", typeVariableTokens=" + this.typeVariableTokens + ", returnTypeToken=" + this.returnTypeToken + ", parameterTypeTokens=" + this.parameterTypeTokens + ", exceptionTypeTokens=" + this.exceptionTypeTokens + '}';
                    }

                    protected class ExceptionTypeRegistrant
                    implements GenericTypeRegistrant {
                        protected ExceptionTypeRegistrant() {
                        }

                        @Override
                        public void register(LazyTypeDescription.GenericTypeToken token) {
                            OfMethod.this.exceptionTypeTokens.add(token);
                        }

                        public int hashCode() {
                            return OfMethod.this.hashCode();
                        }

                        public boolean equals(Object other) {
                            return other != null && this.getClass() == other.getClass() && OfMethod.this.equals(((ExceptionTypeRegistrant)other).getOuter());
                        }

                        private OfMethod getOuter() {
                            return OfMethod.this;
                        }

                        public String toString() {
                            return "TypePool.Default.GenericTypeExtractor.ForSignature.OfMethod.ExceptionTypeRegistrant{outer=" + OfMethod.this + '}';
                        }
                    }

                    protected class ReturnTypeTypeRegistrant
                    implements GenericTypeRegistrant {
                        protected ReturnTypeTypeRegistrant() {
                        }

                        @Override
                        public void register(LazyTypeDescription.GenericTypeToken token) {
                            OfMethod.this.returnTypeToken = token;
                        }

                        public int hashCode() {
                            return OfMethod.this.hashCode();
                        }

                        public boolean equals(Object other) {
                            return other != null && this.getClass() == other.getClass() && OfMethod.this.equals(((ReturnTypeTypeRegistrant)other).getOuter());
                        }

                        private OfMethod getOuter() {
                            return OfMethod.this;
                        }

                        public String toString() {
                            return "TypePool.Default.GenericTypeExtractor.ForSignature.OfMethod.ReturnTypeTypeRegistrant{outer=" + OfMethod.this + '}';
                        }
                    }

                    protected class ParameterTypeRegistrant
                    implements GenericTypeRegistrant {
                        protected ParameterTypeRegistrant() {
                        }

                        @Override
                        public void register(LazyTypeDescription.GenericTypeToken token) {
                            OfMethod.this.parameterTypeTokens.add(token);
                        }

                        public int hashCode() {
                            return OfMethod.this.hashCode();
                        }

                        public boolean equals(Object other) {
                            return other != null && this.getClass() == other.getClass() && OfMethod.this.equals(((ParameterTypeRegistrant)other).getOuter());
                        }

                        private OfMethod getOuter() {
                            return OfMethod.this;
                        }

                        public String toString() {
                            return "TypePool.Default.GenericTypeExtractor.ForSignature.OfMethod.ParameterTypeRegistrant{outer=" + OfMethod.this + '}';
                        }
                    }
                }

                protected static class OfType
                extends ForSignature<LazyTypeDescription.GenericTypeToken.Resolution.ForType> {
                    private final List<LazyTypeDescription.GenericTypeToken> interfaceTypeTokens = new LinkedList<LazyTypeDescription.GenericTypeToken>();
                    private LazyTypeDescription.GenericTypeToken superTypeToken;

                    protected OfType() {
                    }

                    public static LazyTypeDescription.GenericTypeToken.Resolution.ForType extract(String genericSignature) {
                        try {
                            return genericSignature == null ? LazyTypeDescription.GenericTypeToken.Resolution.Raw.INSTANCE : ForSignature.extract(genericSignature, new OfType());
                        }
                        catch (RuntimeException ignored) {
                            return LazyTypeDescription.GenericTypeToken.Resolution.Malformed.INSTANCE;
                        }
                    }

                    @Override
                    public SignatureVisitor visitSuperclass() {
                        this.collectTypeParameter();
                        return new GenericTypeExtractor(new SuperTypeRegistrant());
                    }

                    @Override
                    public SignatureVisitor visitInterface() {
                        return new GenericTypeExtractor(new InterfaceTypeRegistrant());
                    }

                    @Override
                    public LazyTypeDescription.GenericTypeToken.Resolution.ForType resolve() {
                        return new LazyTypeDescription.GenericTypeToken.Resolution.ForType.Tokenized(this.superTypeToken, this.interfaceTypeTokens, this.typeVariableTokens);
                    }

                    @Override
                    public String toString() {
                        return "TypePool.Default.GenericTypeExtractor.ForSignature.OfType{currentTypeParameter='" + this.currentTypeParameter + '\'' + ", currentBounds=" + this.currentBounds + ", typeVariableTokens=" + this.typeVariableTokens + ", superTypeToken=" + this.superTypeToken + ", interfaceTypeTokens=" + this.interfaceTypeTokens + '}';
                    }

                    protected class InterfaceTypeRegistrant
                    implements GenericTypeRegistrant {
                        protected InterfaceTypeRegistrant() {
                        }

                        @Override
                        public void register(LazyTypeDescription.GenericTypeToken token) {
                            OfType.this.interfaceTypeTokens.add(token);
                        }

                        public int hashCode() {
                            return OfType.this.hashCode();
                        }

                        public boolean equals(Object other) {
                            return other != null && this.getClass() == other.getClass() && OfType.this.equals(((InterfaceTypeRegistrant)other).getOuter());
                        }

                        private OfType getOuter() {
                            return OfType.this;
                        }

                        public String toString() {
                            return "TypePool.Default.GenericTypeExtractor.ForSignature.OfType.InterfaceTypeRegistrant{outer=" + OfType.this + '}';
                        }
                    }

                    protected class SuperTypeRegistrant
                    implements GenericTypeRegistrant {
                        protected SuperTypeRegistrant() {
                        }

                        @Override
                        public void register(LazyTypeDescription.GenericTypeToken token) {
                            OfType.this.superTypeToken = token;
                        }

                        public int hashCode() {
                            return OfType.this.hashCode();
                        }

                        public boolean equals(Object other) {
                            return other != null && this.getClass() == other.getClass() && OfType.this.equals(((SuperTypeRegistrant)other).getOuter());
                        }

                        private OfType getOuter() {
                            return OfType.this;
                        }

                        public String toString() {
                            return "TypePool.Default.GenericTypeExtractor.ForSignature.OfType.SuperTypeRegistrant{outer=" + OfType.this + '}';
                        }
                    }
                }
            }

            protected static interface IncompleteToken {
                public SignatureVisitor appendLowerBound();

                public SignatureVisitor appendUpperBound();

                public SignatureVisitor appendDirectBound();

                public void appendPlaceholder();

                public boolean isParameterized();

                public String getName();

                public LazyTypeDescription.GenericTypeToken toToken();

                public static class ForInnerClass
                extends AbstractBase {
                    private static final char INNER_CLASS_SEPERATOR = '$';
                    private final String internalName;
                    private final IncompleteToken outerTypeToken;

                    public ForInnerClass(String internalName, IncompleteToken outerTypeToken) {
                        this.internalName = internalName;
                        this.outerTypeToken = outerTypeToken;
                    }

                    @Override
                    public LazyTypeDescription.GenericTypeToken toToken() {
                        return this.isParameterized() || this.outerTypeToken.isParameterized() ? new LazyTypeDescription.GenericTypeToken.ForParameterizedType.Nested(this.getName(), this.parameters, this.outerTypeToken.toToken()) : new LazyTypeDescription.GenericTypeToken.ForRawType(this.getName());
                    }

                    @Override
                    public boolean isParameterized() {
                        return !this.parameters.isEmpty() || !this.outerTypeToken.isParameterized();
                    }

                    @Override
                    public String getName() {
                        return this.outerTypeToken.getName() + '$' + this.internalName.replace('/', '.');
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.internalName.equals(((ForInnerClass)other).internalName) && this.outerTypeToken.equals(((ForInnerClass)other).outerTypeToken);
                    }

                    public int hashCode() {
                        return this.internalName.hashCode() + 31 * this.outerTypeToken.hashCode();
                    }

                    public String toString() {
                        return "TypePool.Default.GenericTypeExtractor.IncompleteToken.ForInnerClass{internalName='" + this.internalName + '\'' + "outerTypeToken=" + this.outerTypeToken + '}';
                    }
                }

                public static class ForTopLevelType
                extends AbstractBase {
                    private final String internalName;

                    public ForTopLevelType(String internalName) {
                        this.internalName = internalName;
                    }

                    @Override
                    public LazyTypeDescription.GenericTypeToken toToken() {
                        return this.isParameterized() ? new LazyTypeDescription.GenericTypeToken.ForParameterizedType(this.getName(), this.parameters) : new LazyTypeDescription.GenericTypeToken.ForRawType(this.getName());
                    }

                    @Override
                    public boolean isParameterized() {
                        return !this.parameters.isEmpty();
                    }

                    @Override
                    public String getName() {
                        return this.internalName.replace('/', '.');
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.internalName.equals(((ForTopLevelType)other).internalName);
                    }

                    public int hashCode() {
                        return this.internalName.hashCode();
                    }

                    public String toString() {
                        return "TypePool.Default.GenericTypeExtractor.IncompleteToken.ForTopLevelType{internalName='" + this.internalName + '\'' + '}';
                    }
                }

                public static abstract class AbstractBase
                implements IncompleteToken {
                    protected final List<LazyTypeDescription.GenericTypeToken> parameters = new LinkedList<LazyTypeDescription.GenericTypeToken>();

                    @Override
                    public SignatureVisitor appendDirectBound() {
                        return new GenericTypeExtractor(new ForDirectBound());
                    }

                    @Override
                    public SignatureVisitor appendUpperBound() {
                        return new GenericTypeExtractor(new ForUpperBound());
                    }

                    @Override
                    public SignatureVisitor appendLowerBound() {
                        return new GenericTypeExtractor(new ForLowerBound());
                    }

                    @Override
                    public void appendPlaceholder() {
                        this.parameters.add(LazyTypeDescription.GenericTypeToken.ForUnboundWildcard.INSTANCE);
                    }

                    protected class ForLowerBound
                    implements GenericTypeRegistrant {
                        protected ForLowerBound() {
                        }

                        @Override
                        public void register(LazyTypeDescription.GenericTypeToken token) {
                            AbstractBase.this.parameters.add(new LazyTypeDescription.GenericTypeToken.ForLowerBoundWildcard(token));
                        }

                        public String toString() {
                            return "TypePool.Default.GenericTypeExtractor.IncompleteToken.AbstractBase.ForLowerBound{outer=" + AbstractBase.this + '}';
                        }
                    }

                    protected class ForUpperBound
                    implements GenericTypeRegistrant {
                        protected ForUpperBound() {
                        }

                        @Override
                        public void register(LazyTypeDescription.GenericTypeToken token) {
                            AbstractBase.this.parameters.add(new LazyTypeDescription.GenericTypeToken.ForUpperBoundWildcard(token));
                        }

                        public String toString() {
                            return "TypePool.Default.GenericTypeExtractor.IncompleteToken.AbstractBase.ForUpperBound{outer=" + AbstractBase.this + '}';
                        }
                    }

                    protected class ForDirectBound
                    implements GenericTypeRegistrant {
                        protected ForDirectBound() {
                        }

                        @Override
                        public void register(LazyTypeDescription.GenericTypeToken token) {
                            AbstractBase.this.parameters.add(token);
                        }

                        public String toString() {
                            return "TypePool.Default.GenericTypeExtractor.IncompleteToken.AbstractBase.ForDirectBound{outer=" + AbstractBase.this + '}';
                        }
                    }
                }
            }
        }

        protected static class ParameterBag {
            private final Type[] parameterType;
            private final Map<Integer, String> parameterRegistry;

            protected ParameterBag(Type[] parameterType) {
                this.parameterType = parameterType;
                this.parameterRegistry = new HashMap<Integer, String>(parameterType.length);
            }

            protected void register(int offset, String name) {
                this.parameterRegistry.put(offset, name);
            }

            protected List<LazyTypeDescription.MethodToken.ParameterToken> resolve(boolean isStatic) {
                ArrayList<LazyTypeDescription.MethodToken.ParameterToken> parameterTokens = new ArrayList<LazyTypeDescription.MethodToken.ParameterToken>(this.parameterType.length);
                int offset = isStatic ? StackSize.ZERO.getSize() : StackSize.SINGLE.getSize();
                for (Type aParameterType : this.parameterType) {
                    String name = this.parameterRegistry.get(offset);
                    parameterTokens.add(name == null ? new LazyTypeDescription.MethodToken.ParameterToken() : new LazyTypeDescription.MethodToken.ParameterToken(name));
                    offset += aParameterType.getSize();
                }
                return parameterTokens;
            }

            public String toString() {
                return "TypePool.Default.ParameterBag{parameterType=" + Arrays.toString(this.parameterType) + ", parameterRegistry=" + this.parameterRegistry + '}';
            }
        }

        protected static interface GenericTypeRegistrant {
            public void register(LazyTypeDescription.GenericTypeToken var1);

            public static class RejectingSignatureVisitor
            extends SignatureVisitor {
                private static final String MESSAGE = "Unexpected token in generic signature";

                public RejectingSignatureVisitor() {
                    super(327680);
                }

                @Override
                public void visitFormalTypeParameter(String name) {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public SignatureVisitor visitClassBound() {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public SignatureVisitor visitInterfaceBound() {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public SignatureVisitor visitSuperclass() {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public SignatureVisitor visitInterface() {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public SignatureVisitor visitParameterType() {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public SignatureVisitor visitReturnType() {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public SignatureVisitor visitExceptionType() {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public void visitBaseType(char descriptor) {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public void visitTypeVariable(String name) {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public SignatureVisitor visitArrayType() {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public void visitClassType(String name) {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public void visitInnerClassType(String name) {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public void visitTypeArgument() {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public SignatureVisitor visitTypeArgument(char wildcard) {
                    throw new IllegalStateException(MESSAGE);
                }

                @Override
                public void visitEnd() {
                    throw new IllegalStateException(MESSAGE);
                }

                public String toString() {
                    return "TypePool.Default.GenericTypeRegistrant.RejectingSignatureVisitor{}";
                }
            }
        }

        protected static interface ComponentTypeLocator {
            public AbstractBase.RawNonPrimitiveArray.ComponentTypeReference bind(String var1);

            public static class ForArrayType
            implements ComponentTypeLocator,
            AbstractBase.RawNonPrimitiveArray.ComponentTypeReference {
                private final String componentType;

                public ForArrayType(String methodDescriptor) {
                    String arrayType = Type.getMethodType(methodDescriptor).getReturnType().getClassName();
                    this.componentType = arrayType.substring(0, arrayType.length() - 2);
                }

                @Override
                public AbstractBase.RawNonPrimitiveArray.ComponentTypeReference bind(String name) {
                    return this;
                }

                @Override
                public String lookup() {
                    return this.componentType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.componentType.equals(((ForArrayType)other).componentType);
                }

                public int hashCode() {
                    return this.componentType.hashCode();
                }

                public String toString() {
                    return "TypePool.Default.ComponentTypeLocator.ForArrayType{componentType='" + this.componentType + '\'' + '}';
                }
            }

            public static class ForAnnotationProperty
            implements ComponentTypeLocator {
                private final TypePool typePool;
                private final String annotationName;

                public ForAnnotationProperty(TypePool typePool, String annotationDescriptor) {
                    this.typePool = typePool;
                    this.annotationName = annotationDescriptor.substring(1, annotationDescriptor.length() - 1).replace('/', '.');
                }

                @Override
                public AbstractBase.RawNonPrimitiveArray.ComponentTypeReference bind(String name) {
                    return new Bound(name);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.annotationName.equals(((ForAnnotationProperty)other).annotationName) && this.typePool.equals(((ForAnnotationProperty)other).typePool);
                }

                public int hashCode() {
                    int result = this.typePool.hashCode();
                    result = 31 * result + this.annotationName.hashCode();
                    return result;
                }

                public String toString() {
                    return "TypePool.Default.ComponentTypeLocator.ForAnnotationProperty{typePool=" + this.typePool + ", annotationName='" + this.annotationName + '\'' + '}';
                }

                protected class Bound
                implements AbstractBase.RawNonPrimitiveArray.ComponentTypeReference {
                    private final String name;

                    protected Bound(String name) {
                        this.name = name;
                    }

                    @Override
                    public String lookup() {
                        return ((MethodDescription.InDefinedShape)((MethodList)ForAnnotationProperty.this.typePool.describe(ForAnnotationProperty.this.annotationName).resolve().getDeclaredMethods().filter(ElementMatchers.named(this.name))).getOnly()).getReturnType().asErasure().getComponentType().getName();
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.name.equals(((Bound)other).name) && ForAnnotationProperty.this.equals(((Bound)other).getOuter());
                    }

                    public int hashCode() {
                        return this.name.hashCode() + 31 * ForAnnotationProperty.this.hashCode();
                    }

                    private ForAnnotationProperty getOuter() {
                        return ForAnnotationProperty.this;
                    }

                    public String toString() {
                        return "TypePool.Default.ComponentTypeLocator.ForAnnotationProperty.Bound{name='" + this.name + '\'' + '}';
                    }
                }
            }

            public static enum Illegal implements ComponentTypeLocator
            {
                INSTANCE;


                @Override
                public AbstractBase.RawNonPrimitiveArray.ComponentTypeReference bind(String name) {
                    throw new IllegalStateException("Unexpected lookup of component type for " + name);
                }

                public String toString() {
                    return "TypePool.Default.ComponentTypeLocator.Illegal." + this.name();
                }
            }
        }

        protected static interface AnnotationRegistrant {
            public void register(String var1, AnnotationDescription.AnnotationValue<?, ?> var2);

            public void onComplete();
        }
    }

    public static abstract class AbstractBase
    implements TypePool {
        protected static final Map<String, TypeDescription> PRIMITIVE_TYPES;
        protected static final Map<String, String> PRIMITIVE_DESCRIPTORS;
        private static final String ARRAY_SYMBOL = "[";
        protected final CacheProvider cacheProvider;

        protected AbstractBase(CacheProvider cacheProvider) {
            this.cacheProvider = cacheProvider;
        }

        @Override
        public Resolution describe(String name) {
            TypeDescription typeDescription;
            Resolution resolution;
            if (name.contains("/")) {
                throw new IllegalArgumentException(name + " contains the illegal character '/'");
            }
            int arity = 0;
            while (name.startsWith(ARRAY_SYMBOL)) {
                ++arity;
                name = name.substring(1);
            }
            if (arity > 0) {
                String primitiveName = PRIMITIVE_DESCRIPTORS.get(name);
                name = primitiveName == null ? name.substring(1, name.length() - 1) : primitiveName;
            }
            Resolution resolution2 = resolution = (typeDescription = PRIMITIVE_TYPES.get(name)) == null ? this.cacheProvider.find(name) : new Resolution.Simple(typeDescription);
            if (resolution == null) {
                resolution = this.cacheProvider.register(name, this.doDescribe(name));
            }
            return ArrayTypeResolution.of(resolution, arity);
        }

        @Override
        public void clear() {
            this.cacheProvider.clear();
        }

        protected abstract Resolution doDescribe(String var1);

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.cacheProvider.equals(((AbstractBase)other).cacheProvider);
        }

        public int hashCode() {
            return this.cacheProvider.hashCode();
        }

        static {
            HashMap<String, TypeDescription.ForLoadedType> primitiveTypes = new HashMap<String, TypeDescription.ForLoadedType>();
            HashMap<String, String> primitiveDescriptors = new HashMap<String, String>();
            for (Class primitiveType : new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE}) {
                primitiveTypes.put(primitiveType.getName(), new TypeDescription.ForLoadedType(primitiveType));
                primitiveDescriptors.put(Type.getDescriptor(primitiveType), primitiveType.getName());
            }
            PRIMITIVE_TYPES = Collections.unmodifiableMap(primitiveTypes);
            PRIMITIVE_DESCRIPTORS = Collections.unmodifiableMap(primitiveDescriptors);
        }

        protected static class RawNonPrimitiveArray
        implements AnnotationDescription.AnnotationValue<Object[], Object[]> {
            private final TypePool typePool;
            private final ComponentTypeReference componentTypeReference;
            private List<AnnotationDescription.AnnotationValue<?, ?>> value;

            public RawNonPrimitiveArray(TypePool typePool, ComponentTypeReference componentTypeReference, List<AnnotationDescription.AnnotationValue<?, ?>> value) {
                this.typePool = typePool;
                this.value = value;
                this.componentTypeReference = componentTypeReference;
            }

            @Override
            public Object[] resolve() {
                Class componentType;
                TypeDescription componentTypeDescription = this.typePool.describe(this.componentTypeReference.lookup()).resolve();
                if (componentTypeDescription.represents((java.lang.reflect.Type)((Object)Class.class))) {
                    componentType = TypeDescription.class;
                } else if (componentTypeDescription.isAssignableTo(Enum.class)) {
                    componentType = EnumerationDescription.class;
                } else if (componentTypeDescription.isAssignableTo(Annotation.class)) {
                    componentType = AnnotationDescription.class;
                } else if (componentTypeDescription.represents((java.lang.reflect.Type)((Object)String.class))) {
                    componentType = String.class;
                } else {
                    throw new IllegalStateException("Unexpected complex array component type " + componentTypeDescription);
                }
                Object[] array = (Object[])Array.newInstance(componentType, this.value.size());
                int index = 0;
                for (AnnotationDescription.AnnotationValue<?, ?> annotationValue : this.value) {
                    Array.set(array, index++, annotationValue.resolve());
                }
                return array;
            }

            @Override
            public AnnotationDescription.AnnotationValue.Loaded<Object[]> load(ClassLoader classLoader) throws ClassNotFoundException {
                ArrayList loadedValues = new ArrayList(this.value.size());
                for (AnnotationDescription.AnnotationValue<?, ?> value : this.value) {
                    loadedValues.add(value.load(classLoader));
                }
                return new Loaded(classLoader.loadClass(this.componentTypeReference.lookup()), loadedValues);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.componentTypeReference.equals(((RawNonPrimitiveArray)other).componentTypeReference) && this.value.equals(((RawNonPrimitiveArray)other).value);
            }

            public int hashCode() {
                return 31 * this.value.hashCode() + this.componentTypeReference.hashCode();
            }

            public String toString() {
                return "TypePool.LazyTypeDescription.AnnotationValue.ForComplexArray{value=" + this.value + ", componentTypeReference=" + this.componentTypeReference + '}';
            }

            protected static class Loaded
            implements AnnotationDescription.AnnotationValue.Loaded<Object[]> {
                private final Class<?> componentType;
                private final List<AnnotationDescription.AnnotationValue.Loaded<?>> values;

                public Loaded(Class<?> componentType, List<AnnotationDescription.AnnotationValue.Loaded<?>> values) {
                    this.componentType = componentType;
                    this.values = values;
                }

                @Override
                public AnnotationDescription.AnnotationValue.Loaded.State getState() {
                    for (AnnotationDescription.AnnotationValue.Loaded<?> value : this.values) {
                        if (value.getState().isResolved()) continue;
                        return AnnotationDescription.AnnotationValue.Loaded.State.NON_RESOLVED;
                    }
                    return AnnotationDescription.AnnotationValue.Loaded.State.RESOLVED;
                }

                @Override
                public Object[] resolve() {
                    Object[] array = (Object[])Array.newInstance(this.componentType, this.values.size());
                    int index = 0;
                    for (AnnotationDescription.AnnotationValue.Loaded<?> annotationValue : this.values) {
                        Array.set(array, index++, annotationValue.resolve());
                    }
                    return array;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof AnnotationDescription.AnnotationValue.Loaded)) {
                        return false;
                    }
                    AnnotationDescription.AnnotationValue.Loaded loadedOther = (AnnotationDescription.AnnotationValue.Loaded)other;
                    if (!loadedOther.getState().isResolved()) {
                        return false;
                    }
                    Object otherValue = loadedOther.resolve();
                    if (!(otherValue instanceof Object[])) {
                        return false;
                    }
                    Object[] otherArrayValue = (Object[])otherValue;
                    if (this.values.size() != otherArrayValue.length) {
                        return false;
                    }
                    Iterator<AnnotationDescription.AnnotationValue.Loaded<?>> iterator = this.values.iterator();
                    for (Object value : otherArrayValue) {
                        AnnotationDescription.AnnotationValue.Loaded<?> self = iterator.next();
                        if (self.getState().isResolved() && self.resolve().equals(value)) continue;
                        return false;
                    }
                    return true;
                }

                public int hashCode() {
                    int result = 1;
                    for (AnnotationDescription.AnnotationValue.Loaded<?> value : this.values) {
                        result = 31 * result + value.hashCode();
                    }
                    return result;
                }

                public String toString() {
                    StringBuilder stringBuilder = new StringBuilder(AbstractBase.ARRAY_SYMBOL);
                    for (AnnotationDescription.AnnotationValue.Loaded<?> value : this.values) {
                        stringBuilder.append(value.toString());
                    }
                    return stringBuilder.append("]").toString();
                }
            }

            public static interface ComponentTypeReference {
                public String lookup();
            }
        }

        protected static class RawTypeValue
        implements AnnotationDescription.AnnotationValue<TypeDescription, Class<?>> {
            private static final boolean NO_INITIALIZATION = false;
            private final TypePool typePool;
            private final String name;

            public RawTypeValue(TypePool typePool, Type type) {
                this.typePool = typePool;
                this.name = type.getSort() == 9 ? type.getInternalName().replace('/', '.') : type.getClassName();
            }

            @Override
            public TypeDescription resolve() {
                return this.typePool.describe(this.name).resolve();
            }

            @Override
            public AnnotationDescription.AnnotationValue.Loaded<Class<?>> load(ClassLoader classLoader) throws ClassNotFoundException {
                return new Loaded(Class.forName(this.name, false, classLoader));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.name.equals(((RawTypeValue)other).name);
            }

            public int hashCode() {
                return this.name.hashCode();
            }

            public String toString() {
                return "TypePool.LazyTypeDescription.AnnotationValue.ForType{name='" + this.name + '\'' + '}';
            }

            protected static class Loaded
            implements AnnotationDescription.AnnotationValue.Loaded<Class<?>> {
                private final Class<?> type;

                public Loaded(Class<?> type) {
                    this.type = type;
                }

                @Override
                public AnnotationDescription.AnnotationValue.Loaded.State getState() {
                    return AnnotationDescription.AnnotationValue.Loaded.State.RESOLVED;
                }

                @Override
                public Class<?> resolve() {
                    return this.type;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof AnnotationDescription.AnnotationValue.Loaded)) {
                        return false;
                    }
                    AnnotationDescription.AnnotationValue.Loaded loadedOther = (AnnotationDescription.AnnotationValue.Loaded)other;
                    return loadedOther.getState().isResolved() && this.type.equals(loadedOther.resolve());
                }

                public int hashCode() {
                    return this.type.hashCode();
                }

                public String toString() {
                    return this.type.toString();
                }
            }
        }

        protected static class RawEnumerationValue
        implements AnnotationDescription.AnnotationValue<EnumerationDescription, Enum<?>> {
            private final TypePool typePool;
            private final String descriptor;
            private final String value;

            public RawEnumerationValue(TypePool typePool, String descriptor, String value) {
                this.typePool = typePool;
                this.descriptor = descriptor;
                this.value = value;
            }

            @Override
            public EnumerationDescription resolve() {
                return new LazyEnumerationDescription();
            }

            @Override
            public AnnotationDescription.AnnotationValue.Loaded<Enum<?>> load(ClassLoader classLoader) throws ClassNotFoundException {
                Class<?> type = classLoader.loadClass(this.descriptor.substring(1, this.descriptor.length() - 1).replace('/', '.'));
                try {
                    return type.isEnum() ? new AnnotationDescription.AnnotationValue.ForEnumeration.Loaded(Enum.valueOf(type, this.value)) : new AnnotationDescription.AnnotationValue.ForEnumeration.IncompatibleRuntimeType(type);
                }
                catch (IllegalArgumentException ignored) {
                    return new AnnotationDescription.AnnotationValue.ForEnumeration.UnknownRuntimeEnumeration(type, this.value);
                }
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.descriptor.equals(((RawEnumerationValue)other).descriptor) && this.value.equals(((RawEnumerationValue)other).value);
            }

            public int hashCode() {
                return 31 * this.descriptor.hashCode() + this.value.hashCode();
            }

            public String toString() {
                return "TypePool.LazyTypeDescription.AnnotationValue.ForEnumeration{descriptor='" + this.descriptor + '\'' + ", value='" + this.value + '\'' + '}';
            }

            protected class LazyEnumerationDescription
            extends EnumerationDescription.AbstractBase {
                protected LazyEnumerationDescription() {
                }

                @Override
                public String getValue() {
                    return RawEnumerationValue.this.value;
                }

                @Override
                public TypeDescription getEnumerationType() {
                    return RawEnumerationValue.this.typePool.describe(RawEnumerationValue.this.descriptor.substring(1, RawEnumerationValue.this.descriptor.length() - 1).replace('/', '.')).resolve();
                }

                @Override
                public <T extends Enum<T>> T load(Class<T> type) {
                    return Enum.valueOf(type, RawEnumerationValue.this.value);
                }
            }
        }

        protected static class RawAnnotationValue
        implements AnnotationDescription.AnnotationValue<AnnotationDescription, Annotation> {
            private final TypePool typePool;
            private final LazyTypeDescription.AnnotationToken annotationToken;

            public RawAnnotationValue(TypePool typePool, LazyTypeDescription.AnnotationToken annotationToken) {
                this.typePool = typePool;
                this.annotationToken = annotationToken;
            }

            @Override
            public AnnotationDescription resolve() {
                return this.annotationToken.toAnnotationDescription(this.typePool);
            }

            @Override
            public AnnotationDescription.AnnotationValue.Loaded<Annotation> load(ClassLoader classLoader) throws ClassNotFoundException {
                Class<?> type = classLoader.loadClass(this.annotationToken.getDescriptor().substring(1, this.annotationToken.getDescriptor().length() - 1).replace('/', '.'));
                if (type.isAnnotation()) {
                    return new AnnotationDescription.AnnotationValue.ForAnnotation.Loaded<Annotation>((Annotation)Proxy.newProxyInstance(classLoader, new Class[]{type}, AnnotationDescription.AnnotationInvocationHandler.of(classLoader, type, this.annotationToken.getValues())));
                }
                return new AnnotationDescription.AnnotationValue.ForAnnotation.IncompatibleRuntimeType(type);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.annotationToken.equals(((RawAnnotationValue)other).annotationToken);
            }

            public int hashCode() {
                return this.annotationToken.hashCode();
            }

            public String toString() {
                return "TypePool.AbstractBase.RawAnnotationValue{annotationToken=" + this.annotationToken + '}';
            }
        }

        protected static class ArrayTypeResolution
        implements Resolution {
            private final Resolution resolution;
            private final int arity;

            protected ArrayTypeResolution(Resolution resolution, int arity) {
                this.resolution = resolution;
                this.arity = arity;
            }

            protected static Resolution of(Resolution resolution, int arity) {
                return arity == 0 ? resolution : new ArrayTypeResolution(resolution, arity);
            }

            @Override
            public boolean isResolved() {
                return this.resolution.isResolved();
            }

            @Override
            public TypeDescription resolve() {
                return TypeDescription.ArrayProjection.of(this.resolution.resolve(), this.arity);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.arity == ((ArrayTypeResolution)other).arity && this.resolution.equals(((ArrayTypeResolution)other).resolution);
            }

            public int hashCode() {
                int result = this.resolution.hashCode();
                result = 31 * result + this.arity;
                return result;
            }

            public String toString() {
                return "TypePool.AbstractBase.ArrayTypeResolution{resolution=" + this.resolution + ", arity=" + this.arity + '}';
            }
        }
    }

    public static interface CacheProvider {
        public static final Resolution UNRESOLVED = null;

        public Resolution find(String var1);

        public Resolution register(String var1, Resolution var2);

        public void clear();

        public static class Simple
        implements CacheProvider {
            private final ConcurrentMap<String, Resolution> cache = new ConcurrentHashMap<String, Resolution>();

            @Override
            public Resolution find(String name) {
                return (Resolution)this.cache.get(name);
            }

            @Override
            public Resolution register(String name, Resolution resolution) {
                Resolution cached = this.cache.putIfAbsent(name, resolution);
                return cached == null ? resolution : cached;
            }

            @Override
            public void clear() {
                this.cache.clear();
            }

            public String toString() {
                return "TypePool.CacheProvider.Simple{cache=" + this.cache + '}';
            }
        }

        public static enum NoOp implements CacheProvider
        {
            INSTANCE;


            @Override
            public Resolution find(String name) {
                return UNRESOLVED;
            }

            @Override
            public Resolution register(String name, Resolution resolution) {
                return resolution;
            }

            @Override
            public void clear() {
            }

            public String toString() {
                return "TypePool.CacheProvider.NoOp." + this.name();
            }
        }
    }

    public static interface Resolution {
        public boolean isResolved();

        public TypeDescription resolve();

        public static class Illegal
        implements Resolution {
            private final String name;

            public Illegal(String name) {
                this.name = name;
            }

            @Override
            public boolean isResolved() {
                return false;
            }

            @Override
            public TypeDescription resolve() {
                throw new IllegalStateException("Cannot resolve type description for " + this.name);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.name.equals(((Illegal)other).name);
            }

            public int hashCode() {
                return this.name.hashCode();
            }

            public String toString() {
                return "TypePool.Resolution.Illegal{name='" + this.name + '\'' + '}';
            }
        }

        public static class Simple
        implements Resolution {
            private final TypeDescription typeDescription;

            public Simple(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            @Override
            public boolean isResolved() {
                return true;
            }

            @Override
            public TypeDescription resolve() {
                return this.typeDescription;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((Simple)other).typeDescription);
            }

            public int hashCode() {
                return this.typeDescription.hashCode();
            }

            public String toString() {
                return "TypePool.Resolution.Simple{typeDescription=" + this.typeDescription + '}';
            }
        }
    }
}

