/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.io.File;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;

public class ClassReloadingStrategy
implements ClassLoadingStrategy {
    private static final String INSTALLER_TYPE = "net.bytebuddy.agent.Installer";
    private static final String INSTRUMENTATION_FIELD = "instrumentation";
    private static final Object STATIC_FIELD = null;
    private final Instrumentation instrumentation;
    private final Engine engine;
    private final BootstrapInjection bootstrapInjection;
    private final Map<String, Class<?>> preregisteredTypes;

    public ClassReloadingStrategy(Instrumentation instrumentation, Engine engine) {
        this(instrumentation, engine.validate(instrumentation), BootstrapInjection.Disabled.INSTANCE, Collections.emptyMap());
    }

    protected ClassReloadingStrategy(Instrumentation instrumentation, Engine engine, BootstrapInjection bootstrapInjection, Map<String, Class<?>> preregisteredTypes) {
        this.instrumentation = instrumentation;
        this.engine = engine;
        this.bootstrapInjection = bootstrapInjection;
        this.preregisteredTypes = preregisteredTypes;
    }

    public static ClassReloadingStrategy of(Instrumentation instrumentation) {
        Engine engine;
        if (instrumentation.isRedefineClassesSupported()) {
            engine = Engine.REDEFINITION;
        } else if (instrumentation.isRetransformClassesSupported()) {
            engine = Engine.RETRANSFORMATION;
        } else {
            throw new IllegalArgumentException("Instrumentation does not support manipulation of loaded classes: " + instrumentation);
        }
        return new ClassReloadingStrategy(instrumentation, engine);
    }

    public static ClassReloadingStrategy fromInstalledAgent() {
        try {
            Instrumentation instrumentation = (Instrumentation)ClassLoader.getSystemClassLoader().loadClass(INSTALLER_TYPE).getDeclaredField(INSTRUMENTATION_FIELD).get(STATIC_FIELD);
            if (instrumentation == null) {
                throw new IllegalStateException("The Byte Buddy agent is not installed");
            }
            return ClassReloadingStrategy.of(instrumentation);
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", exception);
        }
    }

    @Override
    public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
        HashMap availableTypes = new HashMap(this.preregisteredTypes);
        for (Class type : this.instrumentation.getInitiatedClasses(classLoader)) {
            int n = type.getName().indexOf(47);
            availableTypes.put(n == -1 ? type.getName() : type.getName().substring(0, n), type);
        }
        ConcurrentHashMap classDefinitions = new ConcurrentHashMap();
        HashMap loadedClasses = new HashMap();
        LinkedHashMap unloadedClasses = new LinkedHashMap();
        for (Map.Entry entry : types.entrySet()) {
            Class type = (Class)availableTypes.get(((TypeDescription)entry.getKey()).getName());
            if (type != null) {
                classDefinitions.put(type, new ClassDefinition(type, (byte[])entry.getValue()));
                loadedClasses.put((TypeDescription)entry.getKey(), type);
                continue;
            }
            unloadedClasses.put(entry.getKey(), entry.getValue());
        }
        try {
            this.engine.apply(this.instrumentation, classDefinitions);
            ClassInjector classInjector = classLoader == null ? this.bootstrapInjection.make(this.instrumentation) : new ClassInjector.UsingReflection(classLoader);
            loadedClasses.putAll(classInjector.inject(unloadedClasses));
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalArgumentException("Could not locate classes for redefinition", exception);
        }
        catch (UnmodifiableClassException exception) {
            throw new IllegalStateException("Cannot redefine specified class", exception);
        }
        return loadedClasses;
    }

    public ClassReloadingStrategy reset(Class<?> ... type) {
        if (!this.instrumentation.isRedefineClassesSupported()) {
            throw new IllegalStateException("Classes can only be reset when redefinition is supported");
        }
        ConcurrentHashMap classDefinitions = new ConcurrentHashMap(type.length);
        for (Class<?> aType : type) {
            classDefinitions.put(aType, new ClassDefinition(aType, ClassFileLocator.ForClassLoader.read(aType).resolve()));
        }
        try {
            this.engine.apply(this.instrumentation, classDefinitions);
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalArgumentException("Cannot locate types " + Arrays.toString(type), exception);
        }
        catch (UnmodifiableClassException exception) {
            throw new IllegalStateException("Cannot reset types " + Arrays.toString(type), exception);
        }
        return this;
    }

    public ClassReloadingStrategy enableBootstrapInjection(File folder) {
        return new ClassReloadingStrategy(this.instrumentation, this.engine, new BootstrapInjection.Enabled(folder), this.preregisteredTypes);
    }

    public ClassReloadingStrategy preregistered(Class<?> ... type) {
        HashMap preregisteredTypes = new HashMap(this.preregisteredTypes);
        for (Class<?> aType : type) {
            String typeName = aType.getName();
            int anonymousLoaderIndex = typeName.indexOf(47);
            preregisteredTypes.put(anonymousLoaderIndex == -1 ? typeName : typeName.substring(0, anonymousLoaderIndex), aType);
        }
        return new ClassReloadingStrategy(this.instrumentation, this.engine, this.bootstrapInjection, preregisteredTypes);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClassReloadingStrategy that = (ClassReloadingStrategy)other;
        return this.instrumentation.equals(that.instrumentation) && this.engine == that.engine && this.bootstrapInjection.equals(that.bootstrapInjection) && this.preregisteredTypes.equals(that.preregisteredTypes);
    }

    public int hashCode() {
        int result = this.instrumentation.hashCode();
        result = 31 * result + this.engine.hashCode();
        result = 31 * result + this.bootstrapInjection.hashCode();
        result = 31 * result + this.preregisteredTypes.hashCode();
        return result;
    }

    public String toString() {
        return "ClassReloadingStrategy{instrumentation=" + this.instrumentation + ", engine=" + (Object)((Object)this.engine) + ", bootstrapInjection=" + this.bootstrapInjection + ", preregisteredTypes=" + this.preregisteredTypes + '}';
    }

    protected static interface BootstrapInjection {
        public ClassInjector make(Instrumentation var1);

        public static class Enabled
        implements BootstrapInjection {
            private final File folder;

            protected Enabled(File folder) {
                this.folder = folder;
            }

            @Override
            public ClassInjector make(Instrumentation instrumentation) {
                return ClassInjector.UsingInstrumentation.of(this.folder, ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, instrumentation);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.folder.equals(((Enabled)other).folder);
            }

            public int hashCode() {
                return this.folder.hashCode();
            }

            public String toString() {
                return "ClassReloadingStrategy.BootstrapInjection.Enabled{folder=" + this.folder + '}';
            }
        }

        public static enum Disabled implements BootstrapInjection
        {
            INSTANCE;


            @Override
            public ClassInjector make(Instrumentation instrumentation) {
                throw new IllegalStateException("Bootstrap injection is not enabled");
            }

            public String toString() {
                return "ClassReloadingStrategy.BootstrapInjection.Disabled." + this.name();
            }
        }
    }

    public static enum Engine {
        REDEFINITION(true){

            @Override
            protected void apply(Instrumentation instrumentation, Map<Class<?>, ClassDefinition> classDefinitions) throws UnmodifiableClassException, ClassNotFoundException {
                instrumentation.redefineClasses(classDefinitions.values().toArray(new ClassDefinition[classDefinitions.size()]));
            }

            @Override
            protected Engine validate(Instrumentation instrumentation) {
                if (!instrumentation.isRedefineClassesSupported()) {
                    throw new IllegalArgumentException("Does not support redefinition: " + instrumentation);
                }
                return this;
            }
        }
        ,
        RETRANSFORMATION(false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void apply(Instrumentation instrumentation, Map<Class<?>, ClassDefinition> classDefinitions) throws UnmodifiableClassException {
                ClassRedefinitionTransformer classRedefinitionTransformer = new ClassRedefinitionTransformer(classDefinitions);
                2 var4_4 = this;
                synchronized (var4_4) {
                    instrumentation.addTransformer(classRedefinitionTransformer, true);
                    try {
                        instrumentation.retransformClasses(classDefinitions.keySet().toArray(new Class[classDefinitions.size()]));
                    }
                    finally {
                        instrumentation.removeTransformer(classRedefinitionTransformer);
                    }
                }
                classRedefinitionTransformer.assertTransformation();
            }

            @Override
            protected Engine validate(Instrumentation instrumentation) {
                if (!instrumentation.isRetransformClassesSupported()) {
                    throw new IllegalArgumentException("Does not support retransformation: " + instrumentation);
                }
                return this;
            }
        };

        private static final boolean REDEFINE_CLASSES = true;
        private final boolean redefinition;

        private Engine(boolean redefinition) {
            this.redefinition = redefinition;
        }

        protected abstract void apply(Instrumentation var1, Map<Class<?>, ClassDefinition> var2) throws UnmodifiableClassException, ClassNotFoundException;

        protected abstract Engine validate(Instrumentation var1);

        public boolean isRedefinition() {
            return this.redefinition;
        }

        public String toString() {
            return "ClassReloadingStrategy.Engine." + this.name();
        }

        protected static class ClassRedefinitionTransformer
        implements ClassFileTransformer {
            private static final byte[] NO_REDEFINITION = null;
            private final Map<Class<?>, ClassDefinition> redefinedClasses;

            protected ClassRedefinitionTransformer(Map<Class<?>, ClassDefinition> redefinedClasses) {
                this.redefinedClasses = redefinedClasses;
            }

            @Override
            public byte[] transform(ClassLoader classLoader, String internalTypeName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                ClassDefinition redefinedClass = this.redefinedClasses.remove(classBeingRedefined);
                return redefinedClass == null ? NO_REDEFINITION : redefinedClass.getDefinitionClassFile();
            }

            public void assertTransformation() {
                if (!this.redefinedClasses.isEmpty()) {
                    throw new IllegalStateException("Could not transform: " + this.redefinedClasses.keySet());
                }
            }

            public String toString() {
                return "ClassReloadingStrategy.Engine.ClassRedefinitionTransformer{redefinedClasses=" + this.redefinedClasses + '}';
            }
        }
    }
}

