/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.generic.GenericTypeDescription;
import net.bytebuddy.description.type.generic.GenericTypeList;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.matcher.FilterableList;

public interface ParameterList<T extends ParameterDescription>
extends FilterableList<T, ParameterList<T>> {
    public GenericTypeList asTypeList();

    public ByteCodeElement.Token.TokenList<ParameterDescription.Token> asTokenList();

    public ByteCodeElement.Token.TokenList<ParameterDescription.Token> asTokenList(ElementMatcher<? super GenericTypeDescription> var1);

    public ParameterList<ParameterDescription.InDefinedShape> asDefined();

    public boolean hasExplicitMetaData();

    public static class Empty
    extends FilterableList.Empty<ParameterDescription.InDefinedShape, ParameterList<ParameterDescription.InDefinedShape>>
    implements ParameterList<ParameterDescription.InDefinedShape> {
        @Override
        public boolean hasExplicitMetaData() {
            return true;
        }

        @Override
        public GenericTypeList asTypeList() {
            return new GenericTypeList.Empty();
        }

        @Override
        public ByteCodeElement.Token.TokenList<ParameterDescription.Token> asTokenList() {
            return new ByteCodeElement.Token.TokenList<ParameterDescription.Token>(Collections.emptyList());
        }

        @Override
        public ByteCodeElement.Token.TokenList<ParameterDescription.Token> asTokenList(ElementMatcher<? super GenericTypeDescription> targetTypeMatcher) {
            return new ByteCodeElement.Token.TokenList<ParameterDescription.Token>(Collections.emptyList());
        }

        @Override
        public ParameterList<ParameterDescription.InDefinedShape> asDefined() {
            return this;
        }
    }

    public static class TypeSubstituting
    extends AbstractBase<ParameterDescription> {
        private final MethodDescription declaringMethod;
        private final List<? extends ParameterDescription> parameterDescriptions;
        private final GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor;

        public TypeSubstituting(MethodDescription declaringMethod, List<? extends ParameterDescription> parameterDescriptions, GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor) {
            this.declaringMethod = declaringMethod;
            this.parameterDescriptions = parameterDescriptions;
            this.visitor = visitor;
        }

        @Override
        public ParameterDescription get(int index) {
            return new ParameterDescription.TypeSubstituting(this.declaringMethod, this.parameterDescriptions.get(index), this.visitor);
        }

        @Override
        public int size() {
            return this.parameterDescriptions.size();
        }
    }

    public static class ForTokens
    extends AbstractBase<ParameterDescription.InDefinedShape> {
        private final MethodDescription.InDefinedShape declaringMethod;
        private final List<? extends ParameterDescription.Token> tokens;

        public ForTokens(MethodDescription.InDefinedShape declaringMethod, List<? extends ParameterDescription.Token> tokens) {
            this.declaringMethod = declaringMethod;
            this.tokens = tokens;
        }

        @Override
        public ParameterDescription.InDefinedShape get(int index) {
            int offset = this.declaringMethod.isStatic() ? 0 : 1;
            for (ParameterDescription.Token token : this.tokens.subList(0, index)) {
                offset += token.getType().getStackSize().getSize();
            }
            return new ParameterDescription.Latent(this.declaringMethod, this.tokens.get(index), index, offset);
        }

        @Override
        public int size() {
            return this.tokens.size();
        }
    }

    public static class Explicit<S extends ParameterDescription>
    extends AbstractBase<S> {
        private final List<? extends S> parameterDescriptions;

        public Explicit(List<? extends S> parameterDescriptions) {
            this.parameterDescriptions = Collections.unmodifiableList(parameterDescriptions);
        }

        @Override
        public S get(int index) {
            return (S)((ParameterDescription)this.parameterDescriptions.get(index));
        }

        @Override
        public int size() {
            return this.parameterDescriptions.size();
        }

        public static class ForTypes
        extends AbstractBase<ParameterDescription.InDefinedShape> {
            private final MethodDescription.InDefinedShape methodDescription;
            private final List<? extends GenericTypeDescription> typeDescriptions;

            public ForTypes(MethodDescription.InDefinedShape methodDescription, List<? extends GenericTypeDescription> typeDescriptions) {
                this.methodDescription = methodDescription;
                this.typeDescriptions = typeDescriptions;
            }

            @Override
            public ParameterDescription.InDefinedShape get(int index) {
                int offset = this.methodDescription.isStatic() ? 0 : 1;
                for (GenericTypeDescription genericTypeDescription : this.typeDescriptions.subList(0, index)) {
                    offset += genericTypeDescription.getStackSize().getSize();
                }
                return new ParameterDescription.Latent(this.methodDescription, this.typeDescriptions.get(index), index, offset);
            }

            @Override
            public int size() {
                return this.typeDescriptions.size();
            }
        }
    }

    public static abstract class ForLoadedExecutable<T>
    extends AbstractBase<ParameterDescription.InDefinedShape> {
        private static final Dispatcher DISPATCHER;
        protected final T executable;

        protected ForLoadedExecutable(T executable) {
            this.executable = executable;
        }

        public static ParameterList<ParameterDescription.InDefinedShape> of(Method method) {
            return DISPATCHER.describe(method);
        }

        public static ParameterList<ParameterDescription.InDefinedShape> of(Constructor<?> constructor) {
            return DISPATCHER.describe(constructor);
        }

        @Override
        public int size() {
            return DISPATCHER.getParameterCount(this.executable);
        }

        static {
            Dispatcher dispatcher;
            try {
                dispatcher = new Dispatcher.ForModernVm(Class.forName("java.lang.reflect.Executable").getDeclaredMethod("getParameterCount", new Class[0]));
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Exception ignored) {
                dispatcher = Dispatcher.ForLegacyVm.INSTANCE;
            }
            DISPATCHER = dispatcher;
        }

        protected static class OfLegacyVmConstructor
        extends AbstractBase<ParameterDescription.InDefinedShape> {
            private final Constructor<?> constructor;
            private final Class<?>[] parameterType;
            private final Annotation[][] parameterAnnotation;

            public OfLegacyVmConstructor(Constructor<?> constructor) {
                this.constructor = constructor;
                this.parameterType = constructor.getParameterTypes();
                this.parameterAnnotation = constructor.getParameterAnnotations();
            }

            @Override
            public ParameterDescription.InDefinedShape get(int index) {
                return new ParameterDescription.ForLoadedParameter.OfLegacyVmConstructor(this.constructor, index, this.parameterType[index], this.parameterAnnotation[index]);
            }

            @Override
            public int size() {
                return this.parameterType.length;
            }
        }

        protected static class OfLegacyVmMethod
        extends AbstractBase<ParameterDescription.InDefinedShape> {
            private final Method method;
            private final Class<?>[] parameterType;
            private final Annotation[][] parameterAnnotation;

            protected OfLegacyVmMethod(Method method) {
                this.method = method;
                this.parameterType = method.getParameterTypes();
                this.parameterAnnotation = method.getParameterAnnotations();
            }

            @Override
            public ParameterDescription.InDefinedShape get(int index) {
                return new ParameterDescription.ForLoadedParameter.OfLegacyVmMethod(this.method, index, this.parameterType[index], this.parameterAnnotation[index]);
            }

            @Override
            public int size() {
                return this.parameterType.length;
            }
        }

        protected static class OfConstructor
        extends ForLoadedExecutable<Constructor<?>> {
            protected OfConstructor(Constructor<?> constructor) {
                super(constructor);
            }

            @Override
            public ParameterDescription.InDefinedShape get(int index) {
                return new ParameterDescription.ForLoadedParameter.OfConstructor((Constructor)this.executable, index);
            }
        }

        protected static class OfMethod
        extends ForLoadedExecutable<Method> {
            protected OfMethod(Method method) {
                super(method);
            }

            @Override
            public ParameterDescription.InDefinedShape get(int index) {
                return new ParameterDescription.ForLoadedParameter.OfMethod((Method)this.executable, index);
            }
        }

        protected static interface Dispatcher {
            public int getParameterCount(Object var1);

            public ParameterList<ParameterDescription.InDefinedShape> describe(Method var1);

            public ParameterList<ParameterDescription.InDefinedShape> describe(Constructor<?> var1);

            public static class ForModernVm
            implements Dispatcher {
                private final Method getParameterCount;

                protected ForModernVm(Method getParameterCount) {
                    this.getParameterCount = getParameterCount;
                }

                @Override
                public int getParameterCount(Object executable) {
                    try {
                        return (Integer)this.getParameterCount.invoke(executable, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.Parameter#getModifiers", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.Parameter#getModifiers", exception.getCause());
                    }
                }

                @Override
                public ParameterList<ParameterDescription.InDefinedShape> describe(Method method) {
                    return new OfMethod(method);
                }

                @Override
                public ParameterList<ParameterDescription.InDefinedShape> describe(Constructor<?> constructor) {
                    return new OfConstructor(constructor);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.getParameterCount.equals(((ForModernVm)other).getParameterCount);
                }

                public int hashCode() {
                    return this.getParameterCount.hashCode();
                }

                public String toString() {
                    return "ParameterList.ForLoadedExecutable.Dispatcher.ForModernVm{getParameterCount=" + this.getParameterCount + '}';
                }
            }

            public static enum ForLegacyVm implements Dispatcher
            {
                INSTANCE;


                @Override
                public int getParameterCount(Object executable) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.reflect.Executable");
                }

                @Override
                public ParameterList<ParameterDescription.InDefinedShape> describe(Method method) {
                    return new OfLegacyVmMethod(method);
                }

                @Override
                public ParameterList<ParameterDescription.InDefinedShape> describe(Constructor<?> constructor) {
                    return new OfLegacyVmConstructor(constructor);
                }

                public String toString() {
                    return "ParameterList.ForLoadedExecutable.Dispatcher.ForLegacyVm." + this.name();
                }
            }
        }
    }

    public static abstract class AbstractBase<S extends ParameterDescription>
    extends FilterableList.AbstractBase<S, ParameterList<S>>
    implements ParameterList<S> {
        @Override
        public boolean hasExplicitMetaData() {
            for (ParameterDescription parameterDescription : this) {
                if (parameterDescription.isNamed() && parameterDescription.hasModifiers()) continue;
                return false;
            }
            return true;
        }

        @Override
        public ByteCodeElement.Token.TokenList<ParameterDescription.Token> asTokenList() {
            return this.asTokenList(ElementMatchers.none());
        }

        @Override
        public ByteCodeElement.Token.TokenList<ParameterDescription.Token> asTokenList(ElementMatcher<? super GenericTypeDescription> targetTypeMatcher) {
            ArrayList tokens = new ArrayList(this.size());
            for (ParameterDescription parameterDescription : this) {
                tokens.add(parameterDescription.asToken(targetTypeMatcher));
            }
            return new ByteCodeElement.Token.TokenList<ParameterDescription.Token>(tokens);
        }

        @Override
        public GenericTypeList asTypeList() {
            ArrayList<GenericTypeDescription> types = new ArrayList<GenericTypeDescription>(this.size());
            for (ParameterDescription parameterDescription : this) {
                types.add(parameterDescription.getType());
            }
            return new GenericTypeList.Explicit(types);
        }

        @Override
        public ParameterList<ParameterDescription.InDefinedShape> asDefined() {
            ArrayList declaredForms = new ArrayList(this.size());
            for (ParameterDescription parameterDescription : this) {
                declaredForms.add(parameterDescription.asDefined());
            }
            return new Explicit<ParameterDescription.InDefinedShape>(declaredForms);
        }

        @Override
        protected ParameterList<S> wrap(List<S> values) {
            return new Explicit<S>(values);
        }
    }
}

