/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode;

import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.jar.asm.MethodVisitor;

public enum Removal implements StackManipulation
{
    ZERO(StackSize.ZERO, 0){

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return new StackManipulation.Size(0, 0);
        }
    }
    ,
    SINGLE(StackSize.SINGLE, 87),
    DOUBLE(StackSize.DOUBLE, 88);

    private final StackManipulation.Size size;
    private final int opcode;

    private Removal(StackSize stackSize, int opcode) {
        this.size = stackSize.toDecreasingSize();
        this.opcode = opcode;
    }

    public static StackManipulation pop(TypeDescription typeDescription) {
        switch (typeDescription.getStackSize()) {
            case SINGLE: {
                return SINGLE;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case ZERO: {
                return ZERO;
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitInsn(this.opcode);
        return this.size;
    }

    public String toString() {
        return "Removal." + this.name();
    }
}

