/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.bytebuddy.utility.StreamDrainer;

public interface ClassFileLocator {
    public static final String CLASS_FILE_EXTENSION = ".class";

    public Resolution locate(String var1) throws IOException;

    public static class Compound
    implements ClassFileLocator {
        private final ClassFileLocator[] classFileLocator;

        public Compound(ClassFileLocator ... classFileLocator) {
            this.classFileLocator = classFileLocator;
        }

        @Override
        public Resolution locate(String typeName) throws IOException {
            for (ClassFileLocator classFileLocator : this.classFileLocator) {
                Resolution resolution = classFileLocator.locate(typeName);
                if (!resolution.isResolved()) continue;
                return resolution;
            }
            return Resolution.Illegal.INSTANCE;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.classFileLocator, ((Compound)other).classFileLocator);
        }

        public int hashCode() {
            return Arrays.hashCode(this.classFileLocator);
        }

        public String toString() {
            return "ClassFileLocator.Compound{classFileLocator=" + Arrays.toString(this.classFileLocator) + '}';
        }
    }

    public static class AgentBased
    implements ClassFileLocator {
        private static final String INSTALLER_TYPE = "net.bytebuddy.agent.Installer";
        private static final String INSTRUMENTATION_FIELD = "instrumentation";
        private static final Object STATIC_FIELD = null;
        private final Instrumentation instrumentation;
        private final ClassLoadingDelegate classLoadingDelegate;

        public AgentBased(Instrumentation instrumentation, ClassLoader classLoader) {
            this(instrumentation, ClassLoadingDelegate.Default.of(classLoader));
        }

        public AgentBased(Instrumentation instrumentation, ClassLoadingDelegate classLoadingDelegate) {
            if (!instrumentation.isRetransformClassesSupported()) {
                throw new IllegalArgumentException(instrumentation + " does not support retransformation");
            }
            this.instrumentation = instrumentation;
            this.classLoadingDelegate = classLoadingDelegate;
        }

        public static ClassFileLocator fromInstalledAgent(ClassLoader classLoader) {
            try {
                Instrumentation instrumentation = (Instrumentation)ClassLoader.getSystemClassLoader().loadClass(INSTALLER_TYPE).getDeclaredField(INSTRUMENTATION_FIELD).get(STATIC_FIELD);
                if (instrumentation == null) {
                    throw new IllegalStateException("The Byte Buddy agent is not installed");
                }
                return new AgentBased(instrumentation, classLoader);
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", exception);
            }
        }

        public static ClassFileLocator of(Instrumentation instrumentation, Class<?> type) {
            return new AgentBased(instrumentation, ClassLoadingDelegate.Explicit.of(type));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resolution locate(String typeName) {
            Resolution resolution;
            ExtractionClassFileTransformer classFileTransformer = new ExtractionClassFileTransformer(this.classLoadingDelegate.getClassLoader(), typeName);
            try {
                this.instrumentation.addTransformer(classFileTransformer, true);
                this.instrumentation.retransformClasses(this.classLoadingDelegate.locate(typeName));
                byte[] binaryRepresentation = classFileTransformer.getBinaryRepresentation();
                resolution = binaryRepresentation == null ? Resolution.Illegal.INSTANCE : new Resolution.Explicit(binaryRepresentation);
                this.instrumentation.removeTransformer(classFileTransformer);
            }
            catch (Throwable throwable) {
                try {
                    this.instrumentation.removeTransformer(classFileTransformer);
                    throw throwable;
                }
                catch (RuntimeException exception) {
                    throw exception;
                }
                catch (Exception ignored) {
                    return Resolution.Illegal.INSTANCE;
                }
            }
            return resolution;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.classLoadingDelegate.equals(((AgentBased)other).classLoadingDelegate) && this.instrumentation.equals(((AgentBased)other).instrumentation);
        }

        public int hashCode() {
            return 31 * this.instrumentation.hashCode() + this.classLoadingDelegate.hashCode();
        }

        public String toString() {
            return "ClassFileLocator.AgentBased{instrumentation=" + this.instrumentation + ", classLoadingDelegate=" + this.classLoadingDelegate + '}';
        }

        protected static class ExtractionClassFileTransformer
        implements ClassFileTransformer {
            private static final byte[] DO_NOT_TRANSFORM = null;
            private final ClassLoader classLoader;
            private final String typeName;
            @SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"}, justification="By contract, the referenced array is not to be modified")
            private volatile byte[] binaryRepresentation;

            protected ExtractionClassFileTransformer(ClassLoader classLoader, String typeName) {
                this.classLoader = classLoader;
                this.typeName = typeName;
            }

            @Override
            @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="Return value is always null; received value is never modified")
            public byte[] transform(ClassLoader classLoader, String internalName, Class<?> redefinedType, ProtectionDomain protectionDomain, byte[] classFile) throws IllegalClassFormatException {
                if (internalName != null && this.isChild(classLoader) && this.typeName.equals(internalName.replace('/', '.'))) {
                    this.binaryRepresentation = classFile;
                }
                return DO_NOT_TRANSFORM;
            }

            private boolean isChild(ClassLoader classLoader) {
                if (this.classLoader == null) {
                    return true;
                }
                do {
                    if (classLoader != this.classLoader) continue;
                    return true;
                } while ((classLoader = classLoader.getParent()) != null);
                return false;
            }

            @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Return value must never be modified by contract")
            protected byte[] getBinaryRepresentation() {
                return this.binaryRepresentation;
            }

            public String toString() {
                return "ClassFileLocator.AgentBased.ExtractionClassFileTransformer{classLoader=" + this.classLoader + ", typeName=" + this.typeName + ", binaryRepresentation=" + (this.binaryRepresentation != null ? "<" + this.binaryRepresentation.length + " bytes>" : "null") + '}';
            }
        }

        public static interface ClassLoadingDelegate {
            public Class<?> locate(String var1) throws ClassNotFoundException;

            public ClassLoader getClassLoader();

            public static class Explicit
            implements ClassLoadingDelegate {
                private final ClassLoadingDelegate fallbackDelegate;
                private final Map<String, Class<?>> types;

                public Explicit(ClassLoader classLoader, Collection<? extends Class<?>> types) {
                    this(Default.of(classLoader), types);
                }

                public Explicit(ClassLoadingDelegate fallbackDelegate, Collection<? extends Class<?>> types) {
                    this.fallbackDelegate = fallbackDelegate;
                    this.types = new HashMap();
                    for (Class<?> type : types) {
                        String typeName = type.getName();
                        int anonymousLoaderIndex = typeName.indexOf(47);
                        this.types.put(anonymousLoaderIndex == -1 ? typeName : typeName.substring(0, anonymousLoaderIndex), type);
                    }
                }

                public static ClassLoadingDelegate of(Class<?> type) {
                    return new Explicit(type.getClassLoader(), Collections.singleton(type));
                }

                @Override
                public Class<?> locate(String name) throws ClassNotFoundException {
                    Class<?> type = this.types.get(name);
                    return type == null ? this.fallbackDelegate.locate(name) : type;
                }

                @Override
                public ClassLoader getClassLoader() {
                    return this.fallbackDelegate.getClassLoader();
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.fallbackDelegate.equals(((Explicit)other).fallbackDelegate) && this.types.equals(((Explicit)other).types);
                }

                public int hashCode() {
                    int result = this.fallbackDelegate.hashCode();
                    result = 31 * result + this.types.hashCode();
                    return result;
                }

                public String toString() {
                    return "ClassFileLocator.AgentBased.ClassLoadingDelegate.Explicit{fallbackDelegate=" + this.fallbackDelegate + ", types=" + this.types + '}';
                }
            }

            public static class ForDelegatingClassLoader
            extends Default {
                private static final String DELEGATING_CLASS_LOADER_NAME = "sun.reflect.DelegatingClassLoader";
                private static final int ONLY = 0;
                private static final Dispatcher.Initializable DISPATCHER;
                private final AccessControlContext accessControlContext;

                protected ForDelegatingClassLoader(ClassLoader classLoader, AccessControlContext accessControlContext) {
                    super(classLoader);
                    this.accessControlContext = accessControlContext;
                }

                protected static boolean isDelegating(ClassLoader classLoader) {
                    return classLoader != null && classLoader.getClass().getName().equals(DELEGATING_CLASS_LOADER_NAME);
                }

                private static String nonAnonymous(String typeName) {
                    int anonymousLoaderIndex = typeName.indexOf(47);
                    return anonymousLoaderIndex == -1 ? typeName : typeName.substring(0, anonymousLoaderIndex);
                }

                @Override
                public Class<?> locate(String name) throws ClassNotFoundException {
                    Vector<Class<?>> classes;
                    try {
                        classes = DISPATCHER.initialize(this.accessControlContext).extract(this.classLoader);
                    }
                    catch (RuntimeException ignored) {
                        return super.locate(name);
                    }
                    if (classes.size() != 1) {
                        return super.locate(name);
                    }
                    Class<?> type = classes.get(0);
                    return ForDelegatingClassLoader.nonAnonymous(type.getName()).equals(name) ? type : super.locate(name);
                }

                @Override
                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    if (!super.equals(other)) {
                        return false;
                    }
                    ForDelegatingClassLoader that = (ForDelegatingClassLoader)other;
                    return this.accessControlContext.equals(that.accessControlContext);
                }

                @Override
                public int hashCode() {
                    int result = super.hashCode();
                    result = 31 * result + this.accessControlContext.hashCode();
                    return result;
                }

                @Override
                public String toString() {
                    return "ClassFileLocator.AgentBased.ClassLoadingDelegate.ForDelegatingClassLoader{classLoader=" + this.classLoader + ", accessControlContext=" + this.accessControlContext + '}';
                }

                static {
                    Dispatcher.Initializable dispatcher;
                    try {
                        dispatcher = new Dispatcher.Resolved(ClassLoader.class.getDeclaredField("classes"));
                    }
                    catch (Exception exception) {
                        dispatcher = new Dispatcher.Unresolved(exception);
                    }
                    DISPATCHER = dispatcher;
                }

                protected static interface Dispatcher {
                    public Vector<Class<?>> extract(ClassLoader var1);

                    public static class Unresolved
                    implements Initializable {
                        private final Exception exception;

                        public Unresolved(Exception exception) {
                            this.exception = exception;
                        }

                        @Override
                        public Dispatcher initialize(AccessControlContext accessControlContext) {
                            throw new IllegalStateException("Could not locate classes vector", this.exception);
                        }

                        public boolean equals(Object other) {
                            return this == other || other != null && this.getClass() == other.getClass() && this.exception.equals(((Unresolved)other).exception);
                        }

                        public int hashCode() {
                            return this.exception.hashCode();
                        }

                        public String toString() {
                            return "ClassFileLocator.AgentBased.ClassLoadingDelegate.ForDelegatingClassLoader.Dispatcher.Unresolved{exception=" + this.exception + '}';
                        }
                    }

                    public static class Resolved
                    implements Dispatcher,
                    Initializable,
                    PrivilegedAction<Dispatcher> {
                        private final Field field;

                        public Resolved(Field field) {
                            this.field = field;
                        }

                        @Override
                        public Dispatcher initialize(AccessControlContext accessControlContext) {
                            return AccessController.doPrivileged(this, accessControlContext);
                        }

                        @Override
                        public Dispatcher run() {
                            this.field.setAccessible(true);
                            return this;
                        }

                        @Override
                        public Vector<Class<?>> extract(ClassLoader classLoader) {
                            try {
                                return (Vector)this.field.get(classLoader);
                            }
                            catch (IllegalAccessException exception) {
                                throw new IllegalStateException("Cannot access field", exception);
                            }
                        }

                        public boolean equals(Object other) {
                            return this == other || other != null && this.getClass() == other.getClass() && this.field.equals(((Resolved)other).field);
                        }

                        public int hashCode() {
                            return this.field.hashCode();
                        }

                        public String toString() {
                            return "ClassFileLocator.AgentBased.ClassLoadingDelegate.ForDelegatingClassLoader.Dispatcher.Resolved{field=" + this.field + '}';
                        }
                    }

                    public static interface Initializable {
                        public Dispatcher initialize(AccessControlContext var1);
                    }
                }
            }

            public static class Default
            implements ClassLoadingDelegate {
                protected final ClassLoader classLoader;

                protected Default(ClassLoader classLoader) {
                    this.classLoader = classLoader;
                }

                public static ClassLoadingDelegate of(ClassLoader classLoader) {
                    return Default.of(classLoader, AccessController.getContext());
                }

                public static ClassLoadingDelegate of(ClassLoader classLoader, AccessControlContext accessControlContext) {
                    return ForDelegatingClassLoader.isDelegating(classLoader) ? new ForDelegatingClassLoader(classLoader, accessControlContext) : new Default(classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader);
                }

                @Override
                public Class<?> locate(String name) throws ClassNotFoundException {
                    return this.classLoader.loadClass(name);
                }

                @Override
                public ClassLoader getClassLoader() {
                    return this.classLoader;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Default aDefault = (Default)other;
                    return !(this.classLoader == null ? aDefault.classLoader != null : !this.classLoader.equals(aDefault.classLoader));
                }

                public int hashCode() {
                    return this.classLoader != null ? this.classLoader.hashCode() : 0;
                }

                public String toString() {
                    return "ClassFileLocator.AgentBased.ClassLoadingDelegate.Default{classLoader=" + this.classLoader + '}';
                }
            }
        }
    }

    public static class ForFolder
    implements ClassFileLocator {
        private final File folder;

        public ForFolder(File folder) {
            this.folder = folder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resolution locate(String typeName) throws IOException {
            File file = new File(this.folder, typeName.replace('.', File.separatorChar) + ClassFileLocator.CLASS_FILE_EXTENSION);
            if (file.exists()) {
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
                try {
                    Resolution.Explicit explicit = new Resolution.Explicit(StreamDrainer.DEFAULT.drain(inputStream));
                    return explicit;
                }
                finally {
                    ((InputStream)inputStream).close();
                }
            }
            return Resolution.Illegal.INSTANCE;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof ForFolder && this.folder.equals(((ForFolder)other).folder);
        }

        public int hashCode() {
            return this.folder.hashCode();
        }

        public String toString() {
            return "ClassFileLocator.ForFolder{folder=" + this.folder + '}';
        }
    }

    public static class ForJarFile
    implements ClassFileLocator,
    Closeable {
        private final JarFile jarFile;

        public ForJarFile(JarFile jarFile) {
            this.jarFile = jarFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resolution locate(String typeName) throws IOException {
            ZipEntry zipEntry = this.jarFile.getEntry(typeName.replace('.', '/') + ClassFileLocator.CLASS_FILE_EXTENSION);
            if (zipEntry == null) {
                return Resolution.Illegal.INSTANCE;
            }
            InputStream inputStream = this.jarFile.getInputStream(zipEntry);
            try {
                Resolution.Explicit explicit = new Resolution.Explicit(StreamDrainer.DEFAULT.drain(inputStream));
                return explicit;
            }
            finally {
                inputStream.close();
            }
        }

        @Override
        public void close() throws IOException {
            this.jarFile.close();
        }

        public boolean equals(Object other) {
            return this == other || other instanceof ForJarFile && this.jarFile.equals(((ForJarFile)other).jarFile);
        }

        public int hashCode() {
            return this.jarFile.hashCode();
        }

        public String toString() {
            return "ClassFileLocator.ForJarFile{jarFile=" + this.jarFile + '}';
        }
    }

    public static class ForClassLoader
    implements ClassFileLocator {
        private final ClassLoader classLoader;

        protected ForClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public static ClassFileLocator ofClassPath() {
            return new ForClassLoader(ClassLoader.getSystemClassLoader());
        }

        public static ClassFileLocator of(ClassLoader classLoader) {
            return new ForClassLoader(classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader);
        }

        public static Resolution read(Class<?> type) {
            try {
                return ForClassLoader.of(type.getClassLoader()).locate(type.getName());
            }
            catch (IOException exception) {
                throw new IllegalStateException("Cannot read class file for " + type, exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resolution locate(String typeName) throws IOException {
            InputStream inputStream = this.classLoader.getResourceAsStream(typeName.replace('.', '/') + ClassFileLocator.CLASS_FILE_EXTENSION);
            if (inputStream != null) {
                try {
                    Resolution.Explicit explicit = new Resolution.Explicit(StreamDrainer.DEFAULT.drain(inputStream));
                    return explicit;
                }
                finally {
                    inputStream.close();
                }
            }
            return Resolution.Illegal.INSTANCE;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.classLoader.equals(((ForClassLoader)other).classLoader);
        }

        public int hashCode() {
            return this.classLoader.hashCode();
        }

        public String toString() {
            return "ClassFileLocator.ForClassLoader{classLoader=" + this.classLoader + '}';
        }
    }

    public static class Simple
    implements ClassFileLocator {
        private final Map<String, byte[]> classFiles;

        public Simple(Map<String, byte[]> classFiles) {
            this.classFiles = classFiles;
        }

        public static ClassFileLocator of(String typeName, byte[] binaryRepresentation) {
            return new Simple(Collections.singletonMap(typeName, binaryRepresentation));
        }

        public static ClassFileLocator of(String typeName, byte[] binaryRepresentation, ClassFileLocator fallback) {
            return new Compound(new Simple(Collections.singletonMap(typeName, binaryRepresentation)), fallback);
        }

        @Override
        public Resolution locate(String typeName) {
            byte[] binaryRepresentation = this.classFiles.get(typeName);
            return binaryRepresentation == null ? Resolution.Illegal.INSTANCE : new Resolution.Explicit(binaryRepresentation);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.classFiles.equals(((Simple)other).classFiles);
        }

        public int hashCode() {
            return this.classFiles.hashCode();
        }

        public String toString() {
            return "ClassFileLocator.Simple{classFiles=" + this.classFiles + '}';
        }
    }

    public static enum NoOp implements ClassFileLocator
    {
        INSTANCE;


        @Override
        public Resolution locate(String typeName) {
            return Resolution.Illegal.INSTANCE;
        }

        public String toString() {
            return "ClassFileLocator.NoOp." + this.name();
        }
    }

    public static interface Resolution {
        public boolean isResolved();

        public byte[] resolve();

        public static class Explicit
        implements Resolution {
            private final byte[] binaryRepresentation;

            @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="The received value is never modified by contract")
            public Explicit(byte[] binaryRepresentation) {
                this.binaryRepresentation = binaryRepresentation;
            }

            @Override
            public boolean isResolved() {
                return true;
            }

            @Override
            @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Return value must never be modified by contract")
            public byte[] resolve() {
                return this.binaryRepresentation;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.binaryRepresentation, ((Explicit)other).binaryRepresentation);
            }

            public int hashCode() {
                return Arrays.hashCode(this.binaryRepresentation);
            }

            public String toString() {
                return "ClassFileLocator.Resolution.Explicit{binaryRepresentation=<" + this.binaryRepresentation.length + " bytes>" + '}';
            }
        }

        public static enum Illegal implements Resolution
        {
            INSTANCE;


            @Override
            public boolean isResolved() {
                return false;
            }

            @Override
            public byte[] resolve() {
                throw new IllegalStateException("Could not read binary data");
            }

            public String toString() {
                return "ClassFileLocator.Resolution.Illegal." + this.name();
            }
        }
    }
}

