/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.constant.MethodHandleConstant;
import net.bytebuddy.implementation.bytecode.constant.MethodTypeConstant;
import net.bytebuddy.jar.asm.Handle;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.utility.JavaType;

public interface JavaInstance {
    public Object asConstantPoolValue();

    public StackManipulation asStackManipulation();

    public TypeDescription getInstanceType();

    public static class MethodHandle
    implements JavaInstance {
        private static final Dispatcher.Initializable DISPATCHER;
        private final HandleType handleType;
        private final TypeDescription ownerType;
        private final String name;
        private final TypeDescription returnType;
        private final List<? extends TypeDescription> parameterTypes;

        protected MethodHandle(HandleType handleType, TypeDescription ownerType, String name, TypeDescription returnType, List<? extends TypeDescription> parameterTypes) {
            this.handleType = handleType;
            this.ownerType = ownerType;
            this.name = name;
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
        }

        public static MethodHandle of(Object methodHandle) {
            return MethodHandle.of(methodHandle, DISPATCHER.publicLookup(), AccessController.getContext());
        }

        public static MethodHandle of(Object methodHandle, Object lookup) {
            return MethodHandle.of(methodHandle, lookup, AccessController.getContext());
        }

        public static MethodHandle of(Object methodHandle, AccessControlContext accessControlContext) {
            return MethodHandle.of(methodHandle, DISPATCHER.publicLookup(), accessControlContext);
        }

        public static MethodHandle of(Object methodHandle, Object lookup, AccessControlContext accessControlContext) {
            if (!JavaType.METHOD_HANDLE.getTypeStub().isInstance(methodHandle)) {
                throw new IllegalArgumentException("Expected method handle object: " + methodHandle);
            }
            if (!JavaType.METHOD_HANDLES_LOOKUP.getTypeStub().isInstance(lookup)) {
                throw new IllegalArgumentException("Expected method handle lookup object: " + lookup);
            }
            Dispatcher dispatcher = DISPATCHER.initialize(accessControlContext);
            Object methodHandleInfo = dispatcher.reveal(lookup, methodHandle);
            Object methodType = dispatcher.getMethodType(methodHandleInfo);
            return new MethodHandle(HandleType.of(dispatcher.getReferenceKind(methodHandleInfo)), new TypeDescription.ForLoadedType(dispatcher.getDeclaringClass(methodHandleInfo)), dispatcher.getName(methodHandleInfo), new TypeDescription.ForLoadedType(dispatcher.returnType(methodType)), new TypeList.ForLoadedTypes(dispatcher.parameterArray(methodType)));
        }

        public static MethodHandle of(Method method) {
            return MethodHandle.of(new MethodDescription.ForLoadedMethod(method));
        }

        public static MethodHandle of(Constructor<?> constructor) {
            return MethodHandle.of(new MethodDescription.ForLoadedConstructor(constructor));
        }

        public static MethodHandle of(MethodDescription methodDescription) {
            return new MethodHandle(HandleType.of(methodDescription), methodDescription.getDeclaringType().asErasure(), methodDescription.getInternalName(), methodDescription.getReturnType().asErasure(), methodDescription.getParameters().asTypeList().asErasures());
        }

        public static MethodHandle ofSpecial(Method method, Class<?> type) {
            return MethodHandle.ofSpecial(new MethodDescription.ForLoadedMethod(method), new TypeDescription.ForLoadedType(type));
        }

        public static MethodHandle ofSpecial(MethodDescription methodDescription, TypeDescription typeDescription) {
            if (!methodDescription.isSpecializableFor(typeDescription)) {
                throw new IllegalArgumentException("Cannot specialize " + methodDescription + " for " + typeDescription);
            }
            return new MethodHandle(HandleType.ofSpecial(methodDescription), typeDescription, methodDescription.getInternalName(), methodDescription.getReturnType().asErasure(), methodDescription.getParameters().asTypeList().asErasures());
        }

        public static MethodHandle ofGetter(Field field) {
            return MethodHandle.ofGetter(new FieldDescription.ForLoadedField(field));
        }

        public static MethodHandle ofGetter(FieldDescription fieldDescription) {
            return new MethodHandle(HandleType.ofGetter(fieldDescription), fieldDescription.getDeclaringType().asErasure(), fieldDescription.getInternalName(), fieldDescription.getType().asErasure(), Collections.emptyList());
        }

        public static MethodHandle ofSetter(Field field) {
            return MethodHandle.ofSetter(new FieldDescription.ForLoadedField(field));
        }

        public static MethodHandle ofSetter(FieldDescription fieldDescription) {
            return new MethodHandle(HandleType.ofSetter(fieldDescription), fieldDescription.getDeclaringType().asErasure(), fieldDescription.getInternalName(), TypeDescription.VOID, Collections.singletonList(fieldDescription.getType().asErasure()));
        }

        @Override
        public Object asConstantPoolValue() {
            StringBuilder stringBuilder = new StringBuilder("(");
            for (TypeDescription parameterType : this.getParameterTypes()) {
                stringBuilder.append(parameterType.getDescriptor());
            }
            String descriptor = stringBuilder.append(")").append(this.getReturnType().getDescriptor()).toString();
            return new Handle(this.getHandleType().getIdentifier(), this.getOwnerType().getInternalName(), this.getName(), descriptor);
        }

        @Override
        public StackManipulation asStackManipulation() {
            return MethodHandleConstant.of(this);
        }

        @Override
        public TypeDescription getInstanceType() {
            return JavaType.METHOD_HANDLE.getTypeStub();
        }

        public HandleType getHandleType() {
            return this.handleType;
        }

        public TypeDescription getOwnerType() {
            return this.ownerType;
        }

        public String getName() {
            return this.name;
        }

        public TypeDescription getReturnType() {
            return this.returnType;
        }

        public List<TypeDescription> getParameterTypes() {
            return new ArrayList<TypeDescription>(this.parameterTypes);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            MethodHandle aDefault = (MethodHandle)other;
            return this.handleType == aDefault.handleType && this.name.equals(aDefault.name) && this.ownerType.equals(aDefault.ownerType) && this.parameterTypes.equals(aDefault.parameterTypes) && this.returnType.equals(aDefault.returnType);
        }

        public int hashCode() {
            int result = this.handleType.hashCode();
            result = 31 * result + this.ownerType.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.returnType.hashCode();
            result = 31 * result + this.parameterTypes.hashCode();
            return result;
        }

        public String toString() {
            return "JavaInstance.MethodHandle{handleType=" + (Object)((Object)this.handleType) + ", ownerType=" + this.ownerType + ", name='" + this.name + '\'' + ", returnType=" + this.returnType + ", parameterTypes=" + this.parameterTypes + '}';
        }

        static {
            Dispatcher.Initializable dispatcher;
            try {
                Class<?> methodHandleInfo = Class.forName("java.lang.invoke.MethodHandleInfo");
                Class<?> methodType = JavaType.METHOD_TYPE.load();
                try {
                    dispatcher = new Dispatcher.ForJava8CapableVm(Class.forName("java.lang.invoke.MethodHandles").getDeclaredMethod("publicLookup", new Class[0]), methodHandleInfo.getDeclaredMethod("getName", new Class[0]), methodHandleInfo.getDeclaredMethod("getDeclaringClass", new Class[0]), methodHandleInfo.getDeclaredMethod("getReferenceKind", new Class[0]), methodHandleInfo.getDeclaredMethod("getMethodType", new Class[0]), methodType.getDeclaredMethod("returnType", new Class[0]), methodType.getDeclaredMethod("parameterArray", new Class[0]), JavaType.METHOD_HANDLES_LOOKUP.load().getDeclaredMethod("revealDirect", JavaType.METHOD_HANDLE.load()));
                }
                catch (RuntimeException exception) {
                    throw exception;
                }
                catch (Exception ignored) {
                    dispatcher = new Dispatcher.ForJava7CapableVm(Class.forName("java.lang.invoke.MethodHandles").getDeclaredMethod("publicLookup", new Class[0]), methodHandleInfo.getDeclaredMethod("getName", new Class[0]), methodHandleInfo.getDeclaredMethod("getDeclaringClass", new Class[0]), methodHandleInfo.getDeclaredMethod("getReferenceKind", new Class[0]), methodHandleInfo.getDeclaredMethod("getMethodType", new Class[0]), methodType.getDeclaredMethod("returnType", new Class[0]), methodType.getDeclaredMethod("parameterArray", new Class[0]), methodHandleInfo.getDeclaredConstructor(JavaType.METHOD_HANDLE.load()));
                }
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Exception ignored) {
                dispatcher = Dispatcher.ForLegacyVm.INSTANCE;
            }
            DISPATCHER = dispatcher;
        }

        public static enum HandleType {
            INVOKE_VIRTUAL(5),
            INVOKE_STATIC(6),
            INVOKE_SPECIAL(7),
            INVOKE_INTERFACE(9),
            INVOKE_SPECIAL_CONSTRUCTOR(8),
            PUT_FIELD(3),
            GET_FIELD(1),
            PUT_STATIC_FIELD(4),
            GET_STATIC_FIELD(2);

            private final int identifier;

            private HandleType(int identifier) {
                this.identifier = identifier;
            }

            protected static HandleType of(MethodDescription methodDescription) {
                if (methodDescription.isStatic()) {
                    return INVOKE_STATIC;
                }
                if (methodDescription.isPrivate()) {
                    return INVOKE_SPECIAL;
                }
                if (methodDescription.isConstructor()) {
                    return INVOKE_SPECIAL_CONSTRUCTOR;
                }
                if (methodDescription.getDeclaringType().asErasure().isInterface()) {
                    return INVOKE_INTERFACE;
                }
                return INVOKE_VIRTUAL;
            }

            protected static HandleType of(int identifier) {
                for (HandleType handleType : HandleType.values()) {
                    if (handleType.getIdentifier() != identifier) continue;
                    return handleType;
                }
                throw new IllegalArgumentException("Unknown handle type: " + identifier);
            }

            protected static HandleType ofSpecial(MethodDescription methodDescription) {
                if (methodDescription.isStatic() || methodDescription.isAbstract()) {
                    throw new IllegalArgumentException("Cannot invoke " + methodDescription + " via invokespecial");
                }
                return methodDescription.isConstructor() ? INVOKE_SPECIAL_CONSTRUCTOR : INVOKE_SPECIAL;
            }

            protected static HandleType ofGetter(FieldDescription fieldDescription) {
                return fieldDescription.isStatic() ? GET_STATIC_FIELD : GET_FIELD;
            }

            protected static HandleType ofSetter(FieldDescription fieldDescription) {
                return fieldDescription.isStatic() ? PUT_STATIC_FIELD : PUT_FIELD;
            }

            public int getIdentifier() {
                return this.identifier;
            }

            public String toString() {
                return "JavaInstance.MethodHandle.HandleType." + this.name();
            }
        }

        protected static interface Dispatcher {
            public Object reveal(Object var1, Object var2);

            public Object getMethodType(Object var1);

            public int getReferenceKind(Object var1);

            public Class<?> getDeclaringClass(Object var1);

            public String getName(Object var1);

            public Class<?> returnType(Object var1);

            public List<? extends Class<?>> parameterArray(Object var1);

            public static enum ForLegacyVm implements Initializable
            {
                INSTANCE;


                @Override
                public Dispatcher initialize(AccessControlContext accessControlContext) {
                    throw new IllegalStateException("Unsupported type on current JVM: java.lang.invoke.MethodHandle");
                }

                @Override
                public Object publicLookup() {
                    throw new IllegalStateException("Unsupported type on current JVM: java.lang.invoke.MethodHandle");
                }

                public String toString() {
                    return "JavaInstance.MethodHandle.Dispatcher.ForLegacyVm." + this.name();
                }
            }

            public static class ForJava7CapableVm
            extends AbstractBase
            implements PrivilegedAction<Dispatcher> {
                private final Constructor<?> methodInfo;

                protected ForJava7CapableVm(Method publicLookup, Method getName, Method getDeclaringClass, Method getReferenceKind, Method getMethodType, Method returnType, Method parameterArray, Constructor<?> methodInfo) {
                    super(publicLookup, getName, getDeclaringClass, getReferenceKind, getMethodType, returnType, parameterArray);
                    this.methodInfo = methodInfo;
                }

                @Override
                public Dispatcher initialize(AccessControlContext accessControlContext) {
                    return AccessController.doPrivileged(this, accessControlContext);
                }

                @Override
                public Dispatcher run() {
                    this.methodInfo.setAccessible(true);
                    this.getName.setAccessible(true);
                    this.getDeclaringClass.setAccessible(true);
                    this.getReferenceKind.setAccessible(true);
                    this.getMethodType.setAccessible(true);
                    return this;
                }

                @Override
                public Object reveal(Object lookup, Object methodHandle) {
                    try {
                        return this.methodInfo.newInstance(methodHandle);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodInfo()", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodInfo()", exception.getCause());
                    }
                    catch (InstantiationException exception) {
                        throw new IllegalStateException("Error constructing java.lang.invoke.MethodInfo", exception);
                    }
                }

                @Override
                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    if (!super.equals(other)) {
                        return false;
                    }
                    ForJava7CapableVm that = (ForJava7CapableVm)other;
                    return this.methodInfo.equals(that.methodInfo);
                }

                @Override
                public int hashCode() {
                    int result = super.hashCode();
                    result = 31 * result + this.methodInfo.hashCode();
                    return result;
                }

                public String toString() {
                    return "JavaInstance.MethodHandle.Dispatcher.ForJava7CapableVm{publicLookup=" + this.publicLookup + ", getName=" + this.getName + ", getDeclaringClass=" + this.getDeclaringClass + ", getReferenceKind=" + this.getReferenceKind + ", getMethodType=" + this.getMethodType + ", returnType=" + this.returnType + ", parameterArray=" + this.parameterArray + ", methodInfo=" + this.methodInfo + '}';
                }
            }

            public static class ForJava8CapableVm
            extends AbstractBase {
                private final Method revealDirect;

                protected ForJava8CapableVm(Method publicLookup, Method getName, Method getDeclaringClass, Method getReferenceKind, Method getMethodType, Method returnType, Method parameterArray, Method revealDirect) {
                    super(publicLookup, getName, getDeclaringClass, getReferenceKind, getMethodType, returnType, parameterArray);
                    this.revealDirect = revealDirect;
                }

                @Override
                public Object reveal(Object lookup, Object methodHandle) {
                    try {
                        return this.revealDirect.invoke(lookup, methodHandle);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandles.Lookup#revealDirect", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandles.Lookup#revealDirect", exception.getCause());
                    }
                }

                @Override
                public Dispatcher initialize(AccessControlContext accessControlContext) {
                    return this;
                }

                @Override
                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    if (!super.equals(other)) {
                        return false;
                    }
                    ForJava8CapableVm that = (ForJava8CapableVm)other;
                    return this.revealDirect.equals(that.revealDirect);
                }

                @Override
                public int hashCode() {
                    int result = super.hashCode();
                    result = 31 * result + this.revealDirect.hashCode();
                    return result;
                }

                public String toString() {
                    return "JavaInstance.MethodHandle.Dispatcher.ForJava8CapableVm{publicLookup=" + this.publicLookup + ", getName=" + this.getName + ", getDeclaringClass=" + this.getDeclaringClass + ", getReferenceKind=" + this.getReferenceKind + ", getMethodType=" + this.getMethodType + ", returnType=" + this.returnType + ", parameterArray=" + this.parameterArray + ", revealDirect=" + this.revealDirect + '}';
                }
            }

            public static abstract class AbstractBase
            implements Dispatcher,
            Initializable {
                protected final Method publicLookup;
                protected final Method getName;
                protected final Method getDeclaringClass;
                protected final Method getReferenceKind;
                protected final Method getMethodType;
                protected final Method returnType;
                protected final Method parameterArray;

                protected AbstractBase(Method publicLookup, Method getName, Method getDeclaringClass, Method getReferenceKind, Method getMethodType, Method returnType, Method parameterArray) {
                    this.publicLookup = publicLookup;
                    this.getName = getName;
                    this.getDeclaringClass = getDeclaringClass;
                    this.getReferenceKind = getReferenceKind;
                    this.getMethodType = getMethodType;
                    this.returnType = returnType;
                    this.parameterArray = parameterArray;
                }

                @Override
                public Object publicLookup() {
                    try {
                        return this.publicLookup.invoke(null, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandles#publicLookup", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandles#publicLookup", exception.getCause());
                    }
                }

                @Override
                public Object getMethodType(Object methodHandleInfo) {
                    try {
                        return this.getMethodType.invoke(methodHandleInfo, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandleInfo#getMethodType", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandleInfo#getMethodType", exception.getCause());
                    }
                }

                @Override
                public int getReferenceKind(Object methodHandleInfo) {
                    try {
                        return (Integer)this.getReferenceKind.invoke(methodHandleInfo, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandleInfo#getReferenceKind", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandleInfo#getReferenceKind", exception.getCause());
                    }
                }

                @Override
                public Class<?> getDeclaringClass(Object methodHandleInfo) {
                    try {
                        return (Class)this.getDeclaringClass.invoke(methodHandleInfo, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandleInfo#getDeclaringClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandleInfo#getDeclaringClass", exception.getCause());
                    }
                }

                @Override
                public String getName(Object methodHandleInfo) {
                    try {
                        return (String)this.getName.invoke(methodHandleInfo, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandleInfo#getName", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandleInfo#getName", exception.getCause());
                    }
                }

                @Override
                public Class<?> returnType(Object methodType) {
                    try {
                        return (Class)this.returnType.invoke(methodType, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodType#returnType", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.MethodType#returnType", exception.getCause());
                    }
                }

                @Override
                public List<? extends Class<?>> parameterArray(Object methodType) {
                    try {
                        return Arrays.asList((Class[])this.parameterArray.invoke(methodType, new Object[0]));
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.MethodType#parameterArray", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.MethodType#parameterArray", exception.getCause());
                    }
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    AbstractBase that = (AbstractBase)other;
                    return this.publicLookup.equals(that.publicLookup) && this.getName.equals(that.getName) && this.getDeclaringClass.equals(that.getDeclaringClass) && this.getReferenceKind.equals(that.getReferenceKind) && this.getMethodType.equals(that.getMethodType) && this.returnType.equals(that.returnType) && this.parameterArray.equals(that.parameterArray);
                }

                public int hashCode() {
                    int result = this.publicLookup.hashCode();
                    result = 31 * result + this.getName.hashCode();
                    result = 31 * result + this.getDeclaringClass.hashCode();
                    result = 31 * result + this.getReferenceKind.hashCode();
                    result = 31 * result + this.getMethodType.hashCode();
                    result = 31 * result + this.returnType.hashCode();
                    result = 31 * result + this.parameterArray.hashCode();
                    return result;
                }
            }

            public static interface Initializable {
                public Dispatcher initialize(AccessControlContext var1);

                public Object publicLookup();
            }
        }
    }

    public static class MethodType
    implements JavaInstance {
        private static final Dispatcher DISPATCHER;
        private final TypeDescription returnType;
        private final List<? extends TypeDescription> parameterTypes;

        protected MethodType(TypeDescription returnType, List<? extends TypeDescription> parameterTypes) {
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
        }

        public static MethodType of(Object methodType) {
            if (!JavaType.METHOD_TYPE.getTypeStub().isInstance(methodType)) {
                throw new IllegalArgumentException("Expected method type object: " + methodType);
            }
            return MethodType.of(DISPATCHER.returnType(methodType), DISPATCHER.parameterArray(methodType));
        }

        public static MethodType of(Class<?> returnType, Class<?> ... parameterType) {
            return MethodType.of(new TypeDescription.ForLoadedType(returnType), new TypeList.ForLoadedTypes(parameterType));
        }

        public static MethodType of(TypeDescription returnType, List<? extends TypeDescription> parameterTypes) {
            return new MethodType(returnType, parameterTypes);
        }

        public static MethodType of(Method method) {
            return MethodType.of(new MethodDescription.ForLoadedMethod(method));
        }

        public static MethodType of(Constructor<?> constructor) {
            return MethodType.of(new MethodDescription.ForLoadedConstructor(constructor));
        }

        public static MethodType of(MethodDescription methodDescription) {
            return new MethodType(methodDescription.getReturnType().asErasure(), methodDescription.getParameters().asTypeList().asErasures());
        }

        public static MethodType ofSetter(Field field) {
            return MethodType.ofSetter(new FieldDescription.ForLoadedField(field));
        }

        public static MethodType ofSetter(FieldDescription fieldDescription) {
            return new MethodType(TypeDescription.VOID, Collections.singletonList(fieldDescription.getType().asErasure()));
        }

        public static MethodType ofGetter(Field field) {
            return MethodType.ofGetter(new FieldDescription.ForLoadedField(field));
        }

        public static MethodType ofGetter(FieldDescription fieldDescription) {
            return new MethodType(fieldDescription.getType().asErasure(), Collections.emptyList());
        }

        public static MethodType ofConstant(Object instance) {
            return MethodType.ofConstant(instance.getClass());
        }

        public static MethodType ofConstant(Class<?> type) {
            return MethodType.ofConstant(new TypeDescription.ForLoadedType(type));
        }

        public static MethodType ofConstant(TypeDescription typeDescription) {
            return new MethodType(typeDescription, Collections.emptyList());
        }

        public TypeDescription getReturnType() {
            return this.returnType;
        }

        public List<TypeDescription> getParameterTypes() {
            return new ArrayList<TypeDescription>(this.parameterTypes);
        }

        @Override
        public Object asConstantPoolValue() {
            StringBuilder stringBuilder = new StringBuilder("(");
            for (TypeDescription parameterType : this.getParameterTypes()) {
                stringBuilder.append(parameterType.getDescriptor());
            }
            return Type.getMethodType(stringBuilder.append(")").append(this.getReturnType().getDescriptor()).toString());
        }

        @Override
        public StackManipulation asStackManipulation() {
            return MethodTypeConstant.of(this);
        }

        @Override
        public TypeDescription getInstanceType() {
            return JavaType.METHOD_TYPE.getTypeStub();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            MethodType that = (MethodType)other;
            return this.parameterTypes.equals(that.parameterTypes) && this.returnType.equals(that.returnType);
        }

        public int hashCode() {
            int result = this.returnType.hashCode();
            result = 31 * result + this.parameterTypes.hashCode();
            return result;
        }

        public String toString() {
            return "JavaInstance.MethodType{returnType=" + this.returnType + ", parameterTypes=" + this.parameterTypes + '}';
        }

        static {
            Dispatcher dispatcher;
            try {
                Class<?> methodType = JavaType.METHOD_TYPE.load();
                dispatcher = new Dispatcher.ForJava7CapableVm(methodType.getDeclaredMethod("returnType", new Class[0]), methodType.getDeclaredMethod("parameterArray", new Class[0]));
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Exception ignored) {
                dispatcher = Dispatcher.ForLegacyVm.INSTANCE;
            }
            DISPATCHER = dispatcher;
        }

        protected static interface Dispatcher {
            public Class<?> returnType(Object var1);

            public Class<?>[] parameterArray(Object var1);

            public static enum ForLegacyVm implements Dispatcher
            {
                INSTANCE;


                @Override
                public Class<?> returnType(Object methodType) {
                    throw new IllegalStateException("Unsupported type for the current JVM: java.lang.invoke.MethodType");
                }

                @Override
                public Class<?>[] parameterArray(Object methodType) {
                    throw new IllegalStateException("Unsupported type for the current JVM: java.lang.invoke.MethodType");
                }

                public String toString() {
                    return "JavaInstance.MethodType.Dispatcher.ForLegacyVm." + this.name();
                }
            }

            public static class ForJava7CapableVm
            implements Dispatcher {
                private final Method returnType;
                private final Method parameterArray;

                protected ForJava7CapableVm(Method returnType, Method parameterArray) {
                    this.returnType = returnType;
                    this.parameterArray = parameterArray;
                }

                @Override
                public Class<?> returnType(Object methodType) {
                    try {
                        return (Class)this.returnType.invoke(methodType, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodType#returnType", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodType#returnType", exception.getCause());
                    }
                }

                @Override
                public Class<?>[] parameterArray(Object methodType) {
                    try {
                        return (Class[])this.parameterArray.invoke(methodType, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodType#parameterArray", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodType#parameterArray", exception.getCause());
                    }
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ForJava7CapableVm that = (ForJava7CapableVm)other;
                    return this.returnType.equals(that.returnType) && this.parameterArray.equals(that.parameterArray);
                }

                public int hashCode() {
                    int result = this.returnType.hashCode();
                    result = 31 * result + this.parameterArray.hashCode();
                    return result;
                }

                public String toString() {
                    return "JavaInstance.MethodType.Dispatcher.ForJava7CapableVm{returnType=" + this.returnType + ", parameterArray=" + this.parameterArray + '}';
                }
            }
        }
    }
}

