/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.security.AccessController;
import java.security.PrivilegedAction;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.utility.privilege.GetSystemPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenedClassReader {
    public static final String EXPERIMENTAL_PROPERTY = "net.bytebuddy.experimental";
    public static final boolean EXPERIMENTAL;
    public static final int ASM_API;

    private OpenedClassReader() {
        throw new UnsupportedOperationException("This class is a utility class and not supposed to be instantiated");
    }

    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return AccessController.doPrivileged(action);
    }

    public static ClassReader of(byte[] binaryRepresentation) {
        if (EXPERIMENTAL) {
            ClassFileVersion classFileVersion = ClassFileVersion.ofClassFile(binaryRepresentation);
            if (classFileVersion.isGreaterThan(ClassFileVersion.JAVA_V14)) {
                binaryRepresentation[6] = (byte)(ClassFileVersion.JAVA_V14.getMajorVersion() >>> 8);
                binaryRepresentation[7] = (byte)ClassFileVersion.JAVA_V14.getMajorVersion();
                ClassReader classReader = new ClassReader(binaryRepresentation);
                binaryRepresentation[6] = (byte)(classFileVersion.getMajorVersion() >>> 8);
                binaryRepresentation[7] = (byte)classFileVersion.getMajorVersion();
                return classReader;
            }
            return new ClassReader(binaryRepresentation);
        }
        return new ClassReader(binaryRepresentation);
    }

    static {
        boolean experimental;
        try {
            experimental = Boolean.parseBoolean(OpenedClassReader.doPrivileged(new GetSystemPropertyAction(EXPERIMENTAL_PROPERTY)));
        }
        catch (Exception ignored) {
            experimental = false;
        }
        EXPERIMENTAL = experimental;
        ASM_API = 589824;
    }
}

