/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility.visitor;

import javax.annotation.Nonnull;
import javax.annotation.meta.When;
import net.bytebuddy.jar.asm.AnnotationVisitor;
import net.bytebuddy.jar.asm.Attribute;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.RecordComponentVisitor;
import net.bytebuddy.jar.asm.TypePath;

public abstract class MetadataAwareClassVisitor
extends ClassVisitor {
    private boolean triggerNestHost = true;
    private boolean triggerOuterClass = true;
    private boolean triggerAttributes = true;

    protected MetadataAwareClassVisitor(int api, ClassVisitor classVisitor) {
        super(api, classVisitor);
    }

    protected void onNestHost() {
    }

    protected void onOuterType() {
    }

    protected void onAfterAttributes() {
    }

    private void considerTriggerNestHost() {
        if (this.triggerNestHost) {
            this.triggerNestHost = false;
            this.onNestHost();
        }
    }

    private void considerTriggerOuterClass() {
        if (this.triggerOuterClass) {
            this.triggerOuterClass = false;
            this.onOuterType();
        }
    }

    private void considerTriggerAfterAttributes() {
        if (this.triggerAttributes) {
            this.triggerAttributes = false;
            this.onAfterAttributes();
        }
    }

    public final void visitNestHost(String nestHost) {
        this.triggerNestHost = false;
        this.onVisitNestHost(nestHost);
    }

    protected void onVisitNestHost(String nestHost) {
        super.visitNestHost(nestHost);
    }

    public final void visitOuterClass(String owner, @Nonnull(when=When.MAYBE) String name, @Nonnull(when=When.MAYBE) String descriptor) {
        this.considerTriggerNestHost();
        this.triggerOuterClass = false;
        this.onVisitOuterClass(owner, name, descriptor);
    }

    protected void onVisitOuterClass(String owner, @Nonnull(when=When.MAYBE) String name, @Nonnull(when=When.MAYBE) String descriptor) {
        super.visitOuterClass(owner, name, descriptor);
    }

    public final void visitPermittedSubclass(String permittedSubclass) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        this.onVisitPermittedSubclass(permittedSubclass);
    }

    protected void onVisitPermittedSubclass(String permittedSubclass) {
        super.visitPermittedSubclass(permittedSubclass);
    }

    @Nonnull(when=When.MAYBE)
    public RecordComponentVisitor visitRecordComponent(String name, String descriptor, @Nonnull(when=When.MAYBE) String signature) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        return this.onVisitRecordComponent(name, descriptor, signature);
    }

    @Nonnull(when=When.MAYBE)
    protected RecordComponentVisitor onVisitRecordComponent(String name, String descriptor, @Nonnull(when=When.MAYBE) String signature) {
        return super.visitRecordComponent(name, descriptor, signature);
    }

    @Nonnull(when=When.MAYBE)
    public final AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        return this.onVisitAnnotation(descriptor, visible);
    }

    @Nonnull(when=When.MAYBE)
    protected AnnotationVisitor onVisitAnnotation(String descriptor, boolean visible) {
        return super.visitAnnotation(descriptor, visible);
    }

    @Nonnull(when=When.MAYBE)
    public final AnnotationVisitor visitTypeAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        return this.onVisitTypeAnnotation(typeReference, typePath, descriptor, visible);
    }

    @Nonnull(when=When.MAYBE)
    protected AnnotationVisitor onVisitTypeAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
        return super.visitTypeAnnotation(typeReference, typePath, descriptor, visible);
    }

    public final void visitAttribute(Attribute attribute) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.onVisitAttribute(attribute);
    }

    protected void onVisitAttribute(Attribute attribute) {
        super.visitAttribute(attribute);
    }

    public final void visitNestMember(String nestMember) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        this.onVisitNestMember(nestMember);
    }

    protected void onVisitNestMember(String nestMember) {
        super.visitNestMember(nestMember);
    }

    public final void visitInnerClass(String name, @Nonnull(when=When.MAYBE) String outerName, @Nonnull(when=When.MAYBE) String innerName, int modifiers) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        this.onVisitInnerClass(name, outerName, innerName, modifiers);
    }

    protected void onVisitInnerClass(String name, @Nonnull(when=When.MAYBE) String outerName, @Nonnull(when=When.MAYBE) String innerName, int modifiers) {
        super.visitInnerClass(name, outerName, innerName, modifiers);
    }

    @Nonnull(when=When.MAYBE)
    public final FieldVisitor visitField(int modifiers, String internalName, String descriptor, @Nonnull(when=When.MAYBE) String signature, @Nonnull(when=When.MAYBE) Object value) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        return this.onVisitField(modifiers, internalName, descriptor, signature, value);
    }

    @Nonnull(when=When.MAYBE)
    protected FieldVisitor onVisitField(int modifiers, String internalName, String descriptor, @Nonnull(when=When.MAYBE) String signature, @Nonnull(when=When.MAYBE) Object value) {
        return super.visitField(modifiers, internalName, descriptor, signature, value);
    }

    @Nonnull(when=When.MAYBE)
    public final MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, @Nonnull(when=When.MAYBE) String signature, @Nonnull(when=When.MAYBE) String[] exception) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        return this.onVisitMethod(modifiers, internalName, descriptor, signature, exception);
    }

    @Nonnull(when=When.MAYBE)
    protected MethodVisitor onVisitMethod(int modifiers, String internalName, String descriptor, @Nonnull(when=When.MAYBE) String signature, @Nonnull(when=When.MAYBE) String[] exception) {
        return super.visitMethod(modifiers, internalName, descriptor, signature, exception);
    }

    public final void visitEnd() {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        this.onVisitEnd();
    }

    protected void onVisitEnd() {
        super.visitEnd();
    }
}

