/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.dynamic.scaffold.TypeInitializer;
import net.bytebuddy.dynamic.scaffold.TypeWriter;
import net.bytebuddy.implementation.attribute.AnnotationValueFilter;
import net.bytebuddy.implementation.auxiliary.AuxiliaryType;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.utility.RandomString;

public interface Implementation
extends InstrumentedType.Prepareable {
    public ByteCodeAppender appender(Target var1);

    public static class Simple
    implements Implementation {
        private final ByteCodeAppender byteCodeAppender;

        public Simple(ByteCodeAppender ... byteCodeAppender) {
            this.byteCodeAppender = new ByteCodeAppender.Compound(byteCodeAppender);
        }

        public Simple(StackManipulation ... stackManipulation) {
            this.byteCodeAppender = new ByteCodeAppender.Simple(stackManipulation);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Target implementationTarget) {
            return this.byteCodeAppender;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.byteCodeAppender.equals(((Simple)other).byteCodeAppender);
        }

        public int hashCode() {
            return this.byteCodeAppender.hashCode();
        }

        public String toString() {
            return "Implementation.Simple{byteCodeAppender=" + this.byteCodeAppender + '}';
        }
    }

    public static class Compound
    implements Implementation {
        private final Implementation[] implementation;

        public Compound(Implementation ... implementation) {
            this.implementation = implementation;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            for (Implementation implementation : this.implementation) {
                instrumentedType = implementation.prepare(instrumentedType);
            }
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Target implementationTarget) {
            ByteCodeAppender[] byteCodeAppender = new ByteCodeAppender[this.implementation.length];
            int index = 0;
            for (Implementation implementation : this.implementation) {
                byteCodeAppender[index++] = implementation.appender(implementationTarget);
            }
            return new ByteCodeAppender.Compound(byteCodeAppender);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.implementation, ((Compound)other).implementation);
        }

        public int hashCode() {
            return Arrays.hashCode(this.implementation);
        }

        public String toString() {
            return "Implementation.Compound{implementation=" + Arrays.toString(this.implementation) + '}';
        }
    }

    public static interface Context {
        public TypeDescription register(AuxiliaryType var1);

        public FieldDescription.InDefinedShape cache(StackManipulation var1, TypeDescription var2);

        public static class Default
        implements ExtractableView,
        AuxiliaryType.MethodAccessorFactory {
            public static final String ACCESSOR_METHOD_SUFFIX = "accessor";
            public static final String FIELD_CACHE_PREFIX = "cachedValue";
            private final TypeDescription instrumentedType;
            private final TypeInitializer typeInitializer;
            private final ClassFileVersion classFileVersion;
            private final AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy;
            private final Map<SpecialMethodInvocation, MethodDescription.InDefinedShape> registeredAccessorMethods;
            private final Map<FieldDescription, MethodDescription.InDefinedShape> registeredGetters;
            private final Map<FieldDescription, MethodDescription.InDefinedShape> registeredSetters;
            private final List<TypeWriter.MethodPool.Record> accessorMethods;
            private final Map<AuxiliaryType, DynamicType> auxiliaryTypes;
            private final Map<FieldCacheEntry, FieldDescription.InDefinedShape> registeredFieldCacheEntries;
            private final String suffix;
            private boolean fieldCacheCanAppendEntries;
            private boolean prohibitTypeInitiailzer;

            protected Default(TypeDescription instrumentedType, AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy, TypeInitializer typeInitializer, ClassFileVersion classFileVersion) {
                this.instrumentedType = instrumentedType;
                this.auxiliaryTypeNamingStrategy = auxiliaryTypeNamingStrategy;
                this.typeInitializer = typeInitializer;
                this.classFileVersion = classFileVersion;
                this.registeredAccessorMethods = new HashMap<SpecialMethodInvocation, MethodDescription.InDefinedShape>();
                this.registeredGetters = new HashMap<FieldDescription, MethodDescription.InDefinedShape>();
                this.registeredSetters = new HashMap<FieldDescription, MethodDescription.InDefinedShape>();
                this.accessorMethods = new ArrayList<TypeWriter.MethodPool.Record>();
                this.auxiliaryTypes = new HashMap<AuxiliaryType, DynamicType>();
                this.registeredFieldCacheEntries = new HashMap<FieldCacheEntry, FieldDescription.InDefinedShape>();
                this.suffix = RandomString.make();
                this.fieldCacheCanAppendEntries = true;
                this.prohibitTypeInitiailzer = false;
            }

            @Override
            public MethodDescription.InDefinedShape registerAccessorFor(SpecialMethodInvocation specialMethodInvocation) {
                MethodDescription.InDefinedShape accessorMethod = this.registeredAccessorMethods.get(specialMethodInvocation);
                if (accessorMethod == null) {
                    accessorMethod = new AccessorMethod(this.instrumentedType, specialMethodInvocation.getMethodDescription(), this.suffix);
                    this.registeredAccessorMethods.put(specialMethodInvocation, accessorMethod);
                    this.accessorMethods.add(new AccessorMethodDelegation(accessorMethod, specialMethodInvocation));
                }
                return accessorMethod;
            }

            @Override
            public MethodDescription.InDefinedShape registerGetterFor(FieldDescription fieldDescription) {
                MethodDescription.InDefinedShape accessorMethod = this.registeredGetters.get(fieldDescription);
                if (accessorMethod == null) {
                    accessorMethod = new FieldGetter(this.instrumentedType, fieldDescription, this.suffix);
                    this.registeredGetters.put(fieldDescription, accessorMethod);
                    this.accessorMethods.add(new FieldGetterDelegation(accessorMethod, fieldDescription));
                }
                return accessorMethod;
            }

            @Override
            public MethodDescription.InDefinedShape registerSetterFor(FieldDescription fieldDescription) {
                MethodDescription.InDefinedShape accessorMethod = this.registeredSetters.get(fieldDescription);
                if (accessorMethod == null) {
                    accessorMethod = new FieldSetter(this.instrumentedType, fieldDescription, this.suffix);
                    this.registeredSetters.put(fieldDescription, accessorMethod);
                    this.accessorMethods.add(new FieldSetterDelegation(accessorMethod, fieldDescription));
                }
                return accessorMethod;
            }

            @Override
            public TypeDescription register(AuxiliaryType auxiliaryType) {
                DynamicType dynamicType = this.auxiliaryTypes.get(auxiliaryType);
                if (dynamicType == null) {
                    dynamicType = auxiliaryType.make(this.auxiliaryTypeNamingStrategy.name(this.instrumentedType), this.classFileVersion, this);
                    this.auxiliaryTypes.put(auxiliaryType, dynamicType);
                }
                return dynamicType.getTypeDescription();
            }

            @Override
            public boolean isRetainTypeInitializer() {
                return this.prohibitTypeInitiailzer;
            }

            @Override
            public List<DynamicType> getRegisteredAuxiliaryTypes() {
                return new ArrayList<DynamicType>(this.auxiliaryTypes.values());
            }

            @Override
            public FieldDescription.InDefinedShape cache(StackManipulation fieldValue, TypeDescription fieldType) {
                FieldCacheEntry fieldCacheEntry = new FieldCacheEntry(fieldValue, fieldType);
                FieldDescription.InDefinedShape fieldCache = this.registeredFieldCacheEntries.get(fieldCacheEntry);
                if (fieldCache != null) {
                    return fieldCache;
                }
                if (!this.fieldCacheCanAppendEntries) {
                    throw new IllegalStateException("Cached values cannot be registered after defining the type initializer for " + this.instrumentedType);
                }
                fieldCache = new CacheValueField(this.instrumentedType, fieldType.asGenericType(), this.suffix, fieldValue.hashCode());
                this.registeredFieldCacheEntries.put(fieldCacheEntry, fieldCache);
                return fieldCache;
            }

            @Override
            public void drain(ClassVisitor classVisitor, TypeWriter.MethodPool methodPool, ExtractableView.InjectedCode injectedCode, AnnotationValueFilter.Factory annotationValueFilterFactory) {
                MethodDescription.Latent.TypeInitializer typeInitializerMethod;
                TypeWriter.MethodPool.Record initializerRecord;
                this.fieldCacheCanAppendEntries = false;
                TypeInitializer typeInitializer = this.typeInitializer;
                for (Map.Entry<FieldCacheEntry, FieldDescription.InDefinedShape> entry : this.registeredFieldCacheEntries.entrySet()) {
                    classVisitor.visitField(entry.getValue().getModifiers(), entry.getValue().getInternalName(), entry.getValue().getDescriptor(), entry.getValue().getGenericSignature(), FieldDescription.NO_DEFAULT_VALUE).visitEnd();
                    typeInitializer = typeInitializer.expandWith(new ByteCodeAppender.Simple(entry.getKey().storeIn(entry.getValue())));
                }
                if (injectedCode.isDefined()) {
                    typeInitializer = typeInitializer.expandWith(injectedCode.getByteCodeAppender());
                }
                if ((initializerRecord = methodPool.target(typeInitializerMethod = new MethodDescription.Latent.TypeInitializer(this.instrumentedType))).getSort().isImplemented() && typeInitializer.isDefined()) {
                    initializerRecord = initializerRecord.prepend(typeInitializer);
                } else if (typeInitializer.isDefined()) {
                    initializerRecord = new TypeWriter.MethodPool.Record.ForDefinedMethod.WithBody(typeInitializerMethod, typeInitializer.withReturn());
                }
                if (this.prohibitTypeInitiailzer && initializerRecord.getSort().isDefined()) {
                    throw new IllegalStateException("It is impossible to define a class initializer or cached values for " + this.instrumentedType);
                }
                initializerRecord.apply(classVisitor, this, annotationValueFilterFactory);
                for (TypeWriter.MethodPool.Record record : this.accessorMethods) {
                    record.apply(classVisitor, this, annotationValueFilterFactory);
                }
            }

            @Override
            public void prohibitTypeInitializer() {
                this.prohibitTypeInitiailzer = true;
            }

            public String toString() {
                return "Implementation.Context.Default{instrumentedType=" + this.instrumentedType + ", typeInitializer=" + this.typeInitializer + ", classFileVersion=" + this.classFileVersion + ", auxiliaryTypeNamingStrategy=" + this.auxiliaryTypeNamingStrategy + ", registeredAccessorMethods=" + this.registeredAccessorMethods + ", registeredGetters=" + this.registeredGetters + ", registeredSetters=" + this.registeredSetters + ", accessorMethods=" + this.accessorMethods + ", auxiliaryTypes=" + this.auxiliaryTypes + ", registeredFieldCacheEntries=" + this.registeredFieldCacheEntries + ", suffix=" + this.suffix + ", fieldCacheCanAppendEntries=" + this.fieldCacheCanAppendEntries + ", prohibitTypeInitiailzer=" + this.prohibitTypeInitiailzer + '}';
            }

            public static enum Factory implements net.bytebuddy.implementation.Implementation$Context$Factory
            {
                INSTANCE;


                @Override
                public ExtractableView make(TypeDescription instrumentedType, AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy, TypeInitializer typeInitializer, ClassFileVersion classFileVersion) {
                    return new Default(instrumentedType, auxiliaryTypeNamingStrategy, typeInitializer, classFileVersion);
                }

                public String toString() {
                    return "Implementation.Context.Default.Factory." + this.name();
                }
            }

            protected static class FieldSetterDelegation
            extends AbstractDelegationRecord {
                private final FieldDescription fieldDescription;

                protected FieldSetterDelegation(MethodDescription methodDescription, FieldDescription fieldDescription) {
                    super(methodDescription);
                    this.fieldDescription = fieldDescription;
                }

                @Override
                public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Context implementationContext, MethodDescription instrumentedMethod) {
                    StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.allArgumentsOf(instrumentedMethod).prependThisReference(), FieldAccess.forField(this.fieldDescription).putter(), MethodReturn.VOID).apply(methodVisitor, implementationContext);
                    return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
                }

                @Override
                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.fieldDescription.equals(((FieldSetterDelegation)other).fieldDescription);
                }

                @Override
                public int hashCode() {
                    return this.fieldDescription.hashCode() + 31 * super.hashCode();
                }

                public String toString() {
                    return "Implementation.Context.Default.FieldSetterDelegation{fieldDescription=" + this.fieldDescription + ", methodDescription=" + this.methodDescription + '}';
                }
            }

            protected static class FieldGetterDelegation
            extends AbstractDelegationRecord {
                private final FieldDescription fieldDescription;

                protected FieldGetterDelegation(MethodDescription methodDescription, FieldDescription fieldDescription) {
                    super(methodDescription);
                    this.fieldDescription = fieldDescription;
                }

                @Override
                public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Context implementationContext, MethodDescription instrumentedMethod) {
                    StackManipulation.Size stackSize = new StackManipulation.Compound(this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.REFERENCE.loadOffset(0), FieldAccess.forField(this.fieldDescription).getter(), MethodReturn.returning(this.fieldDescription.getType().asErasure())).apply(methodVisitor, implementationContext);
                    return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
                }

                @Override
                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.fieldDescription.equals(((FieldGetterDelegation)other).fieldDescription);
                }

                @Override
                public int hashCode() {
                    return this.fieldDescription.hashCode() + 31 * super.hashCode();
                }

                public String toString() {
                    return "Implementation.Context.Default.FieldGetterDelegation{fieldDescription=" + this.fieldDescription + ", methodDescription=" + this.methodDescription + '}';
                }
            }

            protected static class AccessorMethodDelegation
            extends AbstractDelegationRecord {
                private final StackManipulation accessorMethodInvocation;

                protected AccessorMethodDelegation(MethodDescription methodDescription, StackManipulation accessorMethodInvocation) {
                    super(methodDescription);
                    this.accessorMethodInvocation = accessorMethodInvocation;
                }

                @Override
                public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Context implementationContext, MethodDescription instrumentedMethod) {
                    StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.allArgumentsOf(instrumentedMethod).prependThisReference(), this.accessorMethodInvocation, MethodReturn.returning(instrumentedMethod.getReturnType().asErasure())).apply(methodVisitor, implementationContext);
                    return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
                }

                @Override
                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.accessorMethodInvocation.equals(((AccessorMethodDelegation)other).accessorMethodInvocation);
                }

                @Override
                public int hashCode() {
                    return this.accessorMethodInvocation.hashCode() + 31 * super.hashCode();
                }

                public String toString() {
                    return "Implementation.Context.Default.AccessorMethodDelegation{accessorMethodInvocation=" + this.accessorMethodInvocation + ", methodDescription=" + this.methodDescription + '}';
                }
            }

            protected static abstract class AbstractDelegationRecord
            extends TypeWriter.MethodPool.Record.ForDefinedMethod
            implements ByteCodeAppender {
                protected final MethodDescription methodDescription;

                protected AbstractDelegationRecord(MethodDescription methodDescription) {
                    this.methodDescription = methodDescription;
                }

                @Override
                public MethodDescription getMethod() {
                    return this.methodDescription;
                }

                @Override
                public TypeWriter.MethodPool.Record.Sort getSort() {
                    return TypeWriter.MethodPool.Record.Sort.IMPLEMENTED;
                }

                @Override
                public void applyHead(MethodVisitor methodVisitor) {
                }

                @Override
                public void applyBody(MethodVisitor methodVisitor, Context implementationContext, AnnotationValueFilter.Factory annotationValueFilterFactory) {
                    methodVisitor.visitCode();
                    ByteCodeAppender.Size size = this.apply(methodVisitor, implementationContext, this.getMethod());
                    methodVisitor.visitMaxs(size.getOperandStackSize(), size.getLocalVariableSize());
                }

                @Override
                public TypeWriter.MethodPool.Record prepend(ByteCodeAppender byteCodeAppender) {
                    throw new UnsupportedOperationException("Cannot prepend code to a delegation");
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.methodDescription.equals(((AbstractDelegationRecord)other).methodDescription);
                }

                public int hashCode() {
                    return this.methodDescription.hashCode();
                }
            }

            protected static class FieldSetter
            extends AbstractPropertyAccessorMethod {
                private final TypeDescription instrumentedType;
                private final FieldDescription fieldDescription;
                private final String suffix;

                protected FieldSetter(TypeDescription instrumentedType, FieldDescription fieldDescription, String suffix) {
                    this.instrumentedType = instrumentedType;
                    this.fieldDescription = fieldDescription;
                    this.suffix = suffix;
                }

                @Override
                public TypeDescription.Generic getReturnType() {
                    return TypeDescription.Generic.VOID;
                }

                @Override
                public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
                    return new ParameterList.Explicit.ForTypes((MethodDescription.InDefinedShape)this, Collections.singletonList(this.fieldDescription.getType().asRawType()));
                }

                @Override
                public TypeList.Generic getExceptionTypes() {
                    return new TypeList.Generic.Empty();
                }

                @Override
                public Object getDefaultValue() {
                    return MethodDescription.NO_DEFAULT_VALUE;
                }

                @Override
                public TypeList.Generic getTypeVariables() {
                    return new TypeList.Generic.Empty();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return new AnnotationList.Empty();
                }

                @Override
                public TypeDescription getDeclaringType() {
                    return this.instrumentedType;
                }

                @Override
                protected int getBaseModifiers() {
                    return this.fieldDescription.isStatic() ? 8 : 0;
                }

                @Override
                public String getInternalName() {
                    return String.format("%s$%s$%s", this.fieldDescription.getName(), Default.ACCESSOR_METHOD_SUFFIX, this.suffix);
                }
            }

            protected static class FieldGetter
            extends AbstractPropertyAccessorMethod {
                private final TypeDescription instrumentedType;
                private final FieldDescription fieldDescription;
                private final String suffix;

                protected FieldGetter(TypeDescription instrumentedType, FieldDescription fieldDescription, String suffix) {
                    this.instrumentedType = instrumentedType;
                    this.fieldDescription = fieldDescription;
                    this.suffix = suffix;
                }

                @Override
                public TypeDescription.Generic getReturnType() {
                    return this.fieldDescription.getType().asRawType();
                }

                @Override
                public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
                    return new ParameterList.Empty<ParameterDescription.InDefinedShape>();
                }

                @Override
                public TypeList.Generic getExceptionTypes() {
                    return new TypeList.Generic.Empty();
                }

                @Override
                public Object getDefaultValue() {
                    return MethodDescription.NO_DEFAULT_VALUE;
                }

                @Override
                public TypeList.Generic getTypeVariables() {
                    return new TypeList.Generic.Empty();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return new AnnotationList.Empty();
                }

                @Override
                public TypeDescription getDeclaringType() {
                    return this.instrumentedType;
                }

                @Override
                protected int getBaseModifiers() {
                    return this.fieldDescription.isStatic() ? 8 : 0;
                }

                @Override
                public String getInternalName() {
                    return String.format("%s$%s$%s", this.fieldDescription.getName(), Default.ACCESSOR_METHOD_SUFFIX, this.suffix);
                }
            }

            protected static class AccessorMethod
            extends AbstractPropertyAccessorMethod {
                private final TypeDescription instrumentedType;
                private final MethodDescription methodDescription;
                private final String suffix;

                protected AccessorMethod(TypeDescription instrumentedType, MethodDescription methodDescription, String suffix) {
                    this.instrumentedType = instrumentedType;
                    this.methodDescription = methodDescription;
                    this.suffix = suffix;
                }

                @Override
                public TypeDescription.Generic getReturnType() {
                    return this.methodDescription.getReturnType().asRawType();
                }

                @Override
                public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
                    return new ParameterList.Explicit.ForTypes((MethodDescription.InDefinedShape)this, this.methodDescription.getParameters().asTypeList().asRawTypes());
                }

                @Override
                public TypeList.Generic getExceptionTypes() {
                    return this.methodDescription.getExceptionTypes().asRawTypes();
                }

                @Override
                public Object getDefaultValue() {
                    return MethodDescription.NO_DEFAULT_VALUE;
                }

                @Override
                public TypeList.Generic getTypeVariables() {
                    return new TypeList.Generic.Empty();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return new AnnotationList.Empty();
                }

                @Override
                public TypeDescription getDeclaringType() {
                    return this.instrumentedType;
                }

                @Override
                public int getBaseModifiers() {
                    return this.methodDescription.isStatic() ? 8 : 0;
                }

                @Override
                public String getInternalName() {
                    return String.format("%s$%s$%s", this.methodDescription.getInternalName(), Default.ACCESSOR_METHOD_SUFFIX, this.suffix);
                }
            }

            protected static abstract class AbstractPropertyAccessorMethod
            extends MethodDescription.InDefinedShape.AbstractBase {
                protected AbstractPropertyAccessorMethod() {
                }

                @Override
                public int getModifiers() {
                    return 0x1000 | this.getBaseModifiers() | (this.getDeclaringType().isInterface() ? 1 : 16);
                }

                protected abstract int getBaseModifiers();
            }

            protected static class FieldCacheEntry
            implements StackManipulation {
                private final StackManipulation fieldValue;
                private final TypeDescription fieldType;

                protected FieldCacheEntry(StackManipulation fieldValue, TypeDescription fieldType) {
                    this.fieldValue = fieldValue;
                    this.fieldType = fieldType;
                }

                public StackManipulation storeIn(FieldDescription fieldDescription) {
                    return new StackManipulation.Compound(this, FieldAccess.forField(fieldDescription).putter());
                }

                public TypeDescription getFieldType() {
                    return this.fieldType;
                }

                @Override
                public boolean isValid() {
                    return this.fieldValue.isValid();
                }

                @Override
                public StackManipulation.Size apply(MethodVisitor methodVisitor, Context implementationContext) {
                    return this.fieldValue.apply(methodVisitor, implementationContext);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.fieldType.equals(((FieldCacheEntry)other).fieldType) && this.fieldValue.equals(((FieldCacheEntry)other).fieldValue);
                }

                public int hashCode() {
                    return 31 * this.fieldValue.hashCode() + this.fieldType.hashCode();
                }

                public String toString() {
                    return "Implementation.Context.Default.FieldCacheEntry{fieldValue=" + this.fieldValue + ", fieldType=" + this.fieldType + '}';
                }
            }

            protected static class CacheValueField
            extends FieldDescription.InDefinedShape.AbstractBase {
                private final TypeDescription instrumentedType;
                private final TypeDescription.Generic fieldType;
                private final String suffix;
                private final int valueHashCode;

                protected CacheValueField(TypeDescription instrumentedType, TypeDescription.Generic fieldType, String suffix, int valueHashCode) {
                    this.instrumentedType = instrumentedType;
                    this.fieldType = fieldType;
                    this.suffix = suffix;
                    this.valueHashCode = valueHashCode;
                }

                @Override
                public TypeDescription.Generic getType() {
                    return this.fieldType;
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return new AnnotationList.Empty();
                }

                @Override
                public TypeDescription getDeclaringType() {
                    return this.instrumentedType;
                }

                @Override
                public int getModifiers() {
                    return 0x1018 | (this.instrumentedType.isInterface() ? 1 : 2);
                }

                @Override
                public String getName() {
                    return String.format("%s$%s$%d", Default.FIELD_CACHE_PREFIX, this.suffix, Math.abs(this.valueHashCode % Integer.MAX_VALUE));
                }
            }
        }

        public static class Disabled
        implements ExtractableView {
            private final TypeDescription instrumentedType;

            protected Disabled(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public boolean isRetainTypeInitializer() {
                return true;
            }

            @Override
            public List<DynamicType> getRegisteredAuxiliaryTypes() {
                return Collections.emptyList();
            }

            @Override
            public void drain(ClassVisitor classVisitor, TypeWriter.MethodPool methodPool, ExtractableView.InjectedCode injectedCode, AnnotationValueFilter.Factory annotationValueFilterFactory) {
                if (injectedCode.isDefined() || methodPool.target(new MethodDescription.Latent.TypeInitializer(this.instrumentedType)).getSort().isDefined()) {
                    throw new IllegalStateException("Type initializer interception is impossible or was disabled for " + this.instrumentedType);
                }
            }

            @Override
            public TypeDescription register(AuxiliaryType auxiliaryType) {
                throw new IllegalStateException("Registration of auxiliary types was disabled: " + auxiliaryType);
            }

            @Override
            public FieldDescription.InDefinedShape cache(StackManipulation fieldValue, TypeDescription fieldType) {
                throw new IllegalStateException("Field values caching was disabled: " + fieldType);
            }

            @Override
            public void prohibitTypeInitializer() {
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Disabled)other).instrumentedType);
            }

            public int hashCode() {
                return this.instrumentedType.hashCode();
            }

            public String toString() {
                return "Implementation.Context.Disabled{instrumentedType=" + this.instrumentedType + '}';
            }

            public static enum Factory implements net.bytebuddy.implementation.Implementation$Context$Factory
            {
                INSTANCE;


                @Override
                public ExtractableView make(TypeDescription instrumentedType, AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy, TypeInitializer typeInitializer, ClassFileVersion classFileVersion) {
                    if (typeInitializer.isDefined()) {
                        throw new IllegalStateException("Cannot define type initializer which was explicitly disabled: " + typeInitializer);
                    }
                    return new Disabled(instrumentedType);
                }

                public String toString() {
                    return "Implementation.Context.Disabled.Factory." + this.name();
                }
            }
        }

        public static interface Factory {
            public ExtractableView make(TypeDescription var1, AuxiliaryType.NamingStrategy var2, TypeInitializer var3, ClassFileVersion var4);
        }

        public static interface ExtractableView
        extends Context {
            public boolean isRetainTypeInitializer();

            public List<DynamicType> getRegisteredAuxiliaryTypes();

            public void drain(ClassVisitor var1, TypeWriter.MethodPool var2, InjectedCode var3, AnnotationValueFilter.Factory var4);

            public void prohibitTypeInitializer();

            public static interface InjectedCode {
                public ByteCodeAppender getByteCodeAppender();

                public boolean isDefined();

                public static enum None implements InjectedCode
                {
                    INSTANCE;


                    @Override
                    public ByteCodeAppender getByteCodeAppender() {
                        throw new IllegalStateException();
                    }

                    @Override
                    public boolean isDefined() {
                        return false;
                    }

                    public String toString() {
                        return "Implementation.Context.ExtractableView.InjectedCode.None." + this.name();
                    }
                }
            }
        }
    }

    public static interface Target {
        public TypeDescription getInstrumentedType();

        public TypeDefinition getOriginType();

        public SpecialMethodInvocation invokeSuper(MethodDescription.SignatureToken var1);

        public SpecialMethodInvocation invokeDefault(TypeDescription var1, MethodDescription.SignatureToken var2);

        public SpecialMethodInvocation invokeDominant(MethodDescription.SignatureToken var1);

        public static abstract class AbstractBase
        implements Target {
            protected final TypeDescription instrumentedType;
            protected final MethodGraph.Linked methodGraph;

            protected AbstractBase(TypeDescription instrumentedType, MethodGraph.Linked methodGraph) {
                this.instrumentedType = instrumentedType;
                this.methodGraph = methodGraph;
            }

            @Override
            public TypeDescription getInstrumentedType() {
                return this.instrumentedType;
            }

            @Override
            public SpecialMethodInvocation invokeDefault(TypeDescription targetType, MethodDescription.SignatureToken token) {
                MethodGraph.Node node = this.methodGraph.getInterfaceGraph(targetType).locate(token);
                return node.getSort().isUnique() ? SpecialMethodInvocation.Simple.of(node.getRepresentative(), targetType) : SpecialMethodInvocation.Illegal.INSTANCE;
            }

            @Override
            public SpecialMethodInvocation invokeDominant(MethodDescription.SignatureToken token) {
                SpecialMethodInvocation specialMethodInvocation = this.invokeSuper(token);
                if (!specialMethodInvocation.isValid()) {
                    Iterator iterator = this.instrumentedType.getInterfaces().asErasures().iterator();
                    while (!specialMethodInvocation.isValid() && iterator.hasNext()) {
                        specialMethodInvocation = this.invokeDefault((TypeDescription)iterator.next(), token);
                    }
                    while (iterator.hasNext()) {
                        if (!this.invokeDefault((TypeDescription)iterator.next(), token).isValid()) continue;
                        return SpecialMethodInvocation.Illegal.INSTANCE;
                    }
                }
                return specialMethodInvocation;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                AbstractBase that = (AbstractBase)other;
                return this.instrumentedType.equals(that.instrumentedType) && this.methodGraph.equals(that.methodGraph);
            }

            public int hashCode() {
                int result = this.instrumentedType.hashCode();
                result = 31 * result + this.methodGraph.hashCode();
                return result;
            }
        }

        public static interface Factory {
            public Target make(TypeDescription var1, MethodGraph.Linked var2);
        }
    }

    public static interface SpecialMethodInvocation
    extends StackManipulation {
        public MethodDescription getMethodDescription();

        public TypeDescription getTypeDescription();

        public static class Simple
        extends AbstractBase {
            private final MethodDescription methodDescription;
            private final TypeDescription typeDescription;
            private final StackManipulation stackManipulation;

            protected Simple(MethodDescription methodDescription, TypeDescription typeDescription, StackManipulation stackManipulation) {
                this.methodDescription = methodDescription;
                this.typeDescription = typeDescription;
                this.stackManipulation = stackManipulation;
            }

            public static SpecialMethodInvocation of(MethodDescription methodDescription, TypeDescription typeDescription) {
                StackManipulation stackManipulation = MethodInvocation.invoke(methodDescription).special(typeDescription);
                return stackManipulation.isValid() ? new Simple(methodDescription, typeDescription, stackManipulation) : Illegal.INSTANCE;
            }

            @Override
            public MethodDescription getMethodDescription() {
                return this.methodDescription;
            }

            @Override
            public TypeDescription getTypeDescription() {
                return this.typeDescription;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Context implementationContext) {
                return this.stackManipulation.apply(methodVisitor, implementationContext);
            }

            public String toString() {
                return "Implementation.SpecialMethodInvocation.Simple{typeDescription=" + this.typeDescription + ", methodDescription=" + this.methodDescription + ", stackManipulation=" + this.stackManipulation + '}';
            }
        }

        public static abstract class AbstractBase
        implements SpecialMethodInvocation {
            @Override
            public boolean isValid() {
                return true;
            }

            public int hashCode() {
                return 31 * this.getMethodDescription().asSignatureToken().hashCode() + this.getTypeDescription().hashCode();
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SpecialMethodInvocation)) {
                    return false;
                }
                SpecialMethodInvocation specialMethodInvocation = (SpecialMethodInvocation)other;
                return this.getMethodDescription().asSignatureToken().equals(specialMethodInvocation.getMethodDescription().asSignatureToken()) && this.getTypeDescription().equals(((SpecialMethodInvocation)other).getTypeDescription());
            }
        }

        public static enum Illegal implements SpecialMethodInvocation
        {
            INSTANCE;


            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Context implementationContext) {
                throw new IllegalStateException("Cannot implement an undefined method");
            }

            @Override
            public MethodDescription getMethodDescription() {
                throw new IllegalStateException("An illegal special method invocation must not be applied");
            }

            @Override
            public TypeDescription getTypeDescription() {
                throw new IllegalStateException("An illegal special method invocation must not be applied");
            }

            public String toString() {
                return "Implementation.SpecialMethodInvocation.Illegal." + this.name();
            }
        }
    }

    public static interface Composable
    extends Implementation {
        public Implementation andThen(Implementation var1);
    }
}

