/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.agent.builder;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.agent.builder.LambdaFactory;
import net.bytebuddy.agent.builder.Nexus;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.modifier.FieldManifestation;
import net.bytebuddy.description.modifier.MethodManifestation;
import net.bytebuddy.description.modifier.Ownership;
import net.bytebuddy.description.modifier.TypeManifestation;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.ClassReloadingStrategy;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.inline.MethodNameTransformer;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.ExceptionMethod;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.auxiliary.AuxiliaryType;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Opcodes;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.JavaConstant;
import net.bytebuddy.utility.JavaModule;
import net.bytebuddy.utility.JavaType;

public interface AgentBuilder {
    public AgentBuilder with(ByteBuddy var1);

    public AgentBuilder with(Listener var1);

    public AgentBuilder with(TypeLocator var1);

    public AgentBuilder with(TypeStrategy var1);

    public AgentBuilder with(AccessControlContext var1);

    public AgentBuilder with(InitializationStrategy var1);

    public AgentBuilder with(RedefinitionStrategy var1);

    public AgentBuilder with(LambdaInstrumentationStrategy var1);

    public AgentBuilder enableBootstrapInjection(File var1, Instrumentation var2);

    public AgentBuilder enableNativeMethodPrefix(String var1);

    public AgentBuilder disableNativeMethodPrefix();

    public AgentBuilder disableBootstrapInjection();

    public AgentBuilder disableClassFormatChanges();

    public Identified.Narrowable type(ElementMatcher<? super TypeDescription> var1);

    public Identified.Narrowable type(ElementMatcher<? super TypeDescription> var1, ElementMatcher<? super ClassLoader> var2);

    public Identified.Narrowable type(ElementMatcher<? super TypeDescription> var1, ElementMatcher<? super ClassLoader> var2, ElementMatcher<? super JavaModule> var3);

    public Identified.Narrowable type(RawMatcher var1);

    public Ignored ignore(ElementMatcher<? super TypeDescription> var1);

    public Ignored ignore(ElementMatcher<? super TypeDescription> var1, ElementMatcher<? super ClassLoader> var2);

    public Ignored ignore(ElementMatcher<? super TypeDescription> var1, ElementMatcher<? super ClassLoader> var2, ElementMatcher<? super JavaModule> var3);

    public Ignored ignore(RawMatcher var1);

    public ClassFileTransformer makeRaw();

    public ClassFileTransformer installOn(Instrumentation var1);

    public ClassFileTransformer installOnByteBuddyAgent();

    public static class Default
    implements AgentBuilder {
        private static final String INSTALLER_TYPE = "net.bytebuddy.agent.Installer";
        private static final String INSTRUMENTATION_FIELD = "instrumentation";
        private static final Object STATIC_FIELD = null;
        private static final byte[] NO_TRANSFORMATION = null;
        private final ByteBuddy byteBuddy;
        private final TypeLocator typeLocator;
        private final TypeStrategy typeStrategy;
        private final Listener listener;
        private final NativeMethodStrategy nativeMethodStrategy;
        private final AccessControlContext accessControlContext;
        private final InitializationStrategy initializationStrategy;
        private final RedefinitionStrategy redefinitionStrategy;
        private final BootstrapInjectionStrategy bootstrapInjectionStrategy;
        private final LambdaInstrumentationStrategy lambdaInstrumentationStrategy;
        private final RawMatcher ignoredTypeMatcher;
        private final Transformation transformation;

        public Default() {
            this(new ByteBuddy());
        }

        public Default(ByteBuddy byteBuddy) {
            this(byteBuddy, TypeLocator.Default.FAST, TypeStrategy.Default.REBASE, Listener.NoOp.INSTANCE, NativeMethodStrategy.Disabled.INSTANCE, AccessController.getContext(), InitializationStrategy.SelfInjection.SPLIT, RedefinitionStrategy.DISABLED, BootstrapInjectionStrategy.Disabled.INSTANCE, LambdaInstrumentationStrategy.DISABLED, new RawMatcher.ForElementMatchers(ElementMatchers.any(), ElementMatchers.isBootstrapClassLoader(), ElementMatchers.any()).or(new RawMatcher.ForElementMatchers(ElementMatchers.isSynthetic(), ElementMatchers.any(), ElementMatchers.any())), Transformation.Ignored.INSTANCE);
        }

        protected Default(ByteBuddy byteBuddy, TypeLocator typeLocator, TypeStrategy typeStrategy, Listener listener, NativeMethodStrategy nativeMethodStrategy, AccessControlContext accessControlContext, InitializationStrategy initializationStrategy, RedefinitionStrategy redefinitionStrategy, BootstrapInjectionStrategy bootstrapInjectionStrategy, LambdaInstrumentationStrategy lambdaInstrumentationStrategy, RawMatcher ignoredTypeMatcher, Transformation transformation) {
            this.byteBuddy = byteBuddy;
            this.typeLocator = typeLocator;
            this.typeStrategy = typeStrategy;
            this.listener = listener;
            this.nativeMethodStrategy = nativeMethodStrategy;
            this.accessControlContext = accessControlContext;
            this.initializationStrategy = initializationStrategy;
            this.redefinitionStrategy = redefinitionStrategy;
            this.bootstrapInjectionStrategy = bootstrapInjectionStrategy;
            this.lambdaInstrumentationStrategy = lambdaInstrumentationStrategy;
            this.ignoredTypeMatcher = ignoredTypeMatcher;
            this.transformation = transformation;
        }

        @Override
        public AgentBuilder with(ByteBuddy byteBuddy) {
            return new Default(byteBuddy, this.typeLocator, this.typeStrategy, this.listener, this.nativeMethodStrategy, this.accessControlContext, this.initializationStrategy, this.redefinitionStrategy, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder with(Listener listener) {
            return new Default(this.byteBuddy, this.typeLocator, this.typeStrategy, new Listener.Compound(this.listener, listener), this.nativeMethodStrategy, this.accessControlContext, this.initializationStrategy, this.redefinitionStrategy, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder with(TypeStrategy typeStrategy) {
            return new Default(this.byteBuddy, this.typeLocator, typeStrategy, this.listener, this.nativeMethodStrategy, this.accessControlContext, this.initializationStrategy, this.redefinitionStrategy, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder with(TypeLocator typeLocator) {
            return new Default(this.byteBuddy, typeLocator, this.typeStrategy, this.listener, this.nativeMethodStrategy, this.accessControlContext, this.initializationStrategy, this.redefinitionStrategy, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder enableNativeMethodPrefix(String prefix) {
            return new Default(this.byteBuddy, this.typeLocator, this.typeStrategy, this.listener, NativeMethodStrategy.ForPrefix.of(prefix), this.accessControlContext, this.initializationStrategy, this.redefinitionStrategy, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder disableNativeMethodPrefix() {
            return new Default(this.byteBuddy, this.typeLocator, this.typeStrategy, this.listener, NativeMethodStrategy.Disabled.INSTANCE, this.accessControlContext, this.initializationStrategy, this.redefinitionStrategy, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder with(AccessControlContext accessControlContext) {
            return new Default(this.byteBuddy, this.typeLocator, this.typeStrategy, this.listener, this.nativeMethodStrategy, accessControlContext, this.initializationStrategy, this.redefinitionStrategy, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder with(RedefinitionStrategy redefinitionStrategy) {
            return new Default(this.byteBuddy, this.typeLocator, this.typeStrategy, this.listener, this.nativeMethodStrategy, this.accessControlContext, this.initializationStrategy, redefinitionStrategy, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder with(InitializationStrategy initializationStrategy) {
            return new Default(this.byteBuddy, this.typeLocator, this.typeStrategy, this.listener, this.nativeMethodStrategy, this.accessControlContext, initializationStrategy, this.redefinitionStrategy, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder with(LambdaInstrumentationStrategy lambdaInstrumentationStrategy) {
            return new Default(this.byteBuddy, this.typeLocator, this.typeStrategy, this.listener, this.nativeMethodStrategy, this.accessControlContext, this.initializationStrategy, this.redefinitionStrategy, this.bootstrapInjectionStrategy, lambdaInstrumentationStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder enableBootstrapInjection(File folder, Instrumentation instrumentation) {
            return new Default(this.byteBuddy, this.typeLocator, this.typeStrategy, this.listener, this.nativeMethodStrategy, this.accessControlContext, this.initializationStrategy, this.redefinitionStrategy, new BootstrapInjectionStrategy.Enabled(folder, instrumentation), this.lambdaInstrumentationStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public AgentBuilder disableBootstrapInjection() {
            return new Default(this.byteBuddy, this.typeLocator, this.typeStrategy, this.listener, this.nativeMethodStrategy, this.accessControlContext, this.initializationStrategy, this.redefinitionStrategy, BootstrapInjectionStrategy.Disabled.INSTANCE, this.lambdaInstrumentationStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public Identified.Narrowable type(RawMatcher matcher) {
            return new Transforming(matcher, Transformer.NoOp.INSTANCE, false);
        }

        @Override
        public Identified.Narrowable type(ElementMatcher<? super TypeDescription> typeMatcher) {
            return this.type(typeMatcher, ElementMatchers.any());
        }

        @Override
        public Identified.Narrowable type(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher) {
            return this.type(typeMatcher, classLoaderMatcher, ElementMatchers.any());
        }

        @Override
        public Identified.Narrowable type(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher, ElementMatcher<? super JavaModule> moduleMatcher) {
            return this.type(new RawMatcher.ForElementMatchers(typeMatcher, classLoaderMatcher, ElementMatchers.not(ElementMatchers.supportsModules()).or(moduleMatcher)));
        }

        @Override
        public Ignored ignore(ElementMatcher<? super TypeDescription> typeMatcher) {
            return this.ignore(typeMatcher, ElementMatchers.any());
        }

        @Override
        public Ignored ignore(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher) {
            return this.ignore(typeMatcher, classLoaderMatcher, ElementMatchers.any());
        }

        @Override
        public Ignored ignore(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher, ElementMatcher<? super JavaModule> moduleMatcher) {
            return this.ignore(new RawMatcher.ForElementMatchers(typeMatcher, classLoaderMatcher, ElementMatchers.not(ElementMatchers.supportsModules()).or(moduleMatcher)));
        }

        @Override
        public Ignored ignore(RawMatcher rawMatcher) {
            return new Ignoring(rawMatcher);
        }

        @Override
        public AgentBuilder disableClassFormatChanges() {
            return new Default(this.byteBuddy.with(Implementation.Context.Disabled.Factory.INSTANCE), this.typeLocator, TypeStrategy.Default.REDEFINE_DECLARED_ONLY, this.listener, this.nativeMethodStrategy, this.accessControlContext, InitializationStrategy.NoOp.INSTANCE, this.redefinitionStrategy, this.bootstrapInjectionStrategy, this.lambdaInstrumentationStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        @Override
        public ClassFileTransformer makeRaw() {
            return ExecutingTransformer.FACTORY.make(this.byteBuddy, this.typeLocator, this.typeStrategy, this.listener, this.nativeMethodStrategy, this.accessControlContext, this.initializationStrategy, this.bootstrapInjectionStrategy, this.ignoredTypeMatcher, this.transformation);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClassFileTransformer installOn(Instrumentation instrumentation) {
            ClassFileTransformer classFileTransformer = this.makeRaw();
            instrumentation.addTransformer(classFileTransformer, this.redefinitionStrategy.isRetransforming(instrumentation));
            if (this.nativeMethodStrategy.isEnabled(instrumentation)) {
                instrumentation.setNativeMethodPrefix(classFileTransformer, this.nativeMethodStrategy.getPrefix());
            }
            this.lambdaInstrumentationStrategy.apply(this.byteBuddy, instrumentation, classFileTransformer);
            if (this.redefinitionStrategy.isEnabled()) {
                RedefinitionStrategy.Collector collector = this.redefinitionStrategy.makeCollector(this.transformation);
                for (Class type : instrumentation.getAllLoadedClasses()) {
                    TypeDescription.ForLoadedType typeDescription = new TypeDescription.ForLoadedType(type);
                    JavaModule module = JavaModule.ofType(type);
                    try {
                        if (instrumentation.isModifiableClass(type) && collector.consider(type, this.ignoredTypeMatcher)) continue;
                        try {
                            try {
                                this.listener.onIgnored(typeDescription, type.getClassLoader(), module);
                            }
                            finally {
                                this.listener.onComplete(typeDescription.getName(), type.getClassLoader(), module);
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                this.listener.onError(typeDescription.getName(), type.getClassLoader(), module, throwable);
                            }
                            finally {
                                this.listener.onComplete(typeDescription.getName(), type.getClassLoader(), module);
                            }
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                }
                try {
                    collector.apply(instrumentation, this.typeLocator, this.listener);
                }
                catch (UnmodifiableClassException exception) {
                    throw new IllegalStateException("Cannot modify at least one class: " + collector, exception);
                }
                catch (ClassNotFoundException exception) {
                    throw new IllegalStateException("Cannot find at least one class: " + collector, exception);
                }
            }
            return classFileTransformer;
        }

        @Override
        public ClassFileTransformer installOnByteBuddyAgent() {
            try {
                Instrumentation instrumentation = (Instrumentation)ClassLoader.getSystemClassLoader().loadClass(INSTALLER_TYPE).getDeclaredField(INSTRUMENTATION_FIELD).get(STATIC_FIELD);
                if (instrumentation == null) {
                    throw new IllegalStateException("The Byte Buddy agent is not installed");
                }
                return this.installOn(instrumentation);
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", exception);
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Default aDefault = (Default)other;
            return this.typeLocator.equals(aDefault.typeLocator) && this.byteBuddy.equals(aDefault.byteBuddy) && this.listener.equals(aDefault.listener) && this.nativeMethodStrategy.equals(aDefault.nativeMethodStrategy) && this.typeStrategy.equals(aDefault.typeStrategy) && this.accessControlContext.equals(aDefault.accessControlContext) && this.initializationStrategy == aDefault.initializationStrategy && this.redefinitionStrategy == aDefault.redefinitionStrategy && this.bootstrapInjectionStrategy.equals(aDefault.bootstrapInjectionStrategy) && this.lambdaInstrumentationStrategy.equals(aDefault.lambdaInstrumentationStrategy) && this.ignoredTypeMatcher.equals(aDefault.ignoredTypeMatcher) && this.transformation.equals(aDefault.transformation);
        }

        public int hashCode() {
            int result = this.byteBuddy.hashCode();
            result = 31 * result + this.typeLocator.hashCode();
            result = 31 * result + this.listener.hashCode();
            result = 31 * result + this.typeStrategy.hashCode();
            result = 31 * result + this.nativeMethodStrategy.hashCode();
            result = 31 * result + this.accessControlContext.hashCode();
            result = 31 * result + this.initializationStrategy.hashCode();
            result = 31 * result + this.redefinitionStrategy.hashCode();
            result = 31 * result + this.bootstrapInjectionStrategy.hashCode();
            result = 31 * result + this.lambdaInstrumentationStrategy.hashCode();
            result = 31 * result + this.ignoredTypeMatcher.hashCode();
            result = 31 * result + this.transformation.hashCode();
            return result;
        }

        public String toString() {
            return "AgentBuilder.Default{byteBuddy=" + this.byteBuddy + ", typeLocator=" + this.typeLocator + ", typeStrategy=" + this.typeStrategy + ", listener=" + this.listener + ", nativeMethodStrategy=" + this.nativeMethodStrategy + ", accessControlContext=" + this.accessControlContext + ", initializationStrategy=" + this.initializationStrategy + ", redefinitionStrategy=" + (Object)((Object)this.redefinitionStrategy) + ", bootstrapInjectionStrategy=" + this.bootstrapInjectionStrategy + ", lambdaInstrumentationStrategy=" + this.lambdaInstrumentationStrategy + ", ignoredTypeMatcher=" + this.ignoredTypeMatcher + ", transformation=" + this.transformation + '}';
        }

        protected class Transforming
        extends Delegator<Identified.Narrowable>
        implements Identified.Extendable,
        Identified.Narrowable {
            private final RawMatcher rawMatcher;
            private final Transformer transformer;
            private final boolean decorator;

            protected Transforming(RawMatcher rawMatcher, Transformer transformer, boolean decorator) {
                this.rawMatcher = rawMatcher;
                this.transformer = transformer;
                this.decorator = decorator;
            }

            @Override
            protected AgentBuilder materialize() {
                return new Default(Default.this.byteBuddy, Default.this.typeLocator, Default.this.typeStrategy, Default.this.listener, Default.this.nativeMethodStrategy, Default.this.accessControlContext, Default.this.initializationStrategy, Default.this.redefinitionStrategy, Default.this.bootstrapInjectionStrategy, Default.this.lambdaInstrumentationStrategy, Default.this.ignoredTypeMatcher, new Transformation.Compound(new Transformation.Simple(this.rawMatcher, this.transformer, this.decorator), Default.this.transformation));
            }

            @Override
            public Identified.Extendable transform(Transformer transformer) {
                return new Transforming(this.rawMatcher, new Transformer.Compound(this.transformer, transformer), this.decorator);
            }

            @Override
            public AgentBuilder asDecorator() {
                return new Transforming(this.rawMatcher, this.transformer, true);
            }

            @Override
            public Identified.Narrowable and(RawMatcher rawMatcher) {
                return new Transforming(new RawMatcher.Conjunction(this.rawMatcher, rawMatcher), this.transformer, this.decorator);
            }

            @Override
            public Identified.Narrowable or(RawMatcher rawMatcher) {
                return new Transforming(new RawMatcher.Disjunction(this.rawMatcher, rawMatcher), this.transformer, this.decorator);
            }

            private Default getOuter() {
                return Default.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.decorator == ((Transforming)other).decorator && this.rawMatcher.equals(((Transforming)other).rawMatcher) && this.transformer.equals(((Transforming)other).transformer) && Default.this.equals(((Transforming)other).getOuter());
            }

            public int hashCode() {
                int result = this.rawMatcher.hashCode();
                result = 31 * result + (this.decorator ? 1 : 0);
                result = 31 * result + this.transformer.hashCode();
                result = 31 * result + Default.this.hashCode();
                return result;
            }

            public String toString() {
                return "AgentBuilder.Default.Transforming{rawMatcher=" + this.rawMatcher + ", transformer=" + this.transformer + ", decorator=" + this.decorator + ", agentBuilder=" + Default.this + '}';
            }
        }

        protected class Ignoring
        extends Delegator<Ignored>
        implements Ignored {
            private final RawMatcher rawMatcher;

            protected Ignoring(RawMatcher rawMatcher) {
                this.rawMatcher = rawMatcher;
            }

            @Override
            protected AgentBuilder materialize() {
                return new Default(Default.this.byteBuddy, Default.this.typeLocator, Default.this.typeStrategy, Default.this.listener, Default.this.nativeMethodStrategy, Default.this.accessControlContext, Default.this.initializationStrategy, Default.this.redefinitionStrategy, Default.this.bootstrapInjectionStrategy, Default.this.lambdaInstrumentationStrategy, this.rawMatcher, Default.this.transformation);
            }

            @Override
            public Ignored and(RawMatcher rawMatcher) {
                return new Ignoring(new RawMatcher.Conjunction(this.rawMatcher, rawMatcher));
            }

            @Override
            public Ignored or(RawMatcher rawMatcher) {
                return new Ignoring(new RawMatcher.Disjunction(this.rawMatcher, rawMatcher));
            }

            private Default getOuter() {
                return Default.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.rawMatcher.equals(((Ignoring)other).rawMatcher) && Default.this.equals(((Ignoring)other).getOuter());
            }

            public int hashCode() {
                int result = this.rawMatcher.hashCode();
                result = 31 * result + Default.this.hashCode();
                return result;
            }

            public String toString() {
                return "AgentBuilder.Default.Ignoring{rawMatcher=" + this.rawMatcher + ", agentBuilder=" + Default.this + '}';
            }
        }

        protected abstract class Delegator<T extends Matchable<T>>
        extends Matchable.AbstractBase<T>
        implements AgentBuilder {
            protected Delegator() {
            }

            protected abstract AgentBuilder materialize();

            @Override
            public AgentBuilder with(ByteBuddy byteBuddy) {
                return this.materialize().with(byteBuddy);
            }

            @Override
            public AgentBuilder with(Listener listener) {
                return this.materialize().with(listener);
            }

            @Override
            public AgentBuilder with(TypeStrategy typeStrategy) {
                return this.materialize().with(typeStrategy);
            }

            @Override
            public AgentBuilder with(TypeLocator typeLocator) {
                return this.materialize().with(typeLocator);
            }

            @Override
            public AgentBuilder with(AccessControlContext accessControlContext) {
                return this.materialize().with(accessControlContext);
            }

            @Override
            public AgentBuilder with(InitializationStrategy initializationStrategy) {
                return this.materialize().with(initializationStrategy);
            }

            @Override
            public AgentBuilder with(RedefinitionStrategy redefinitionStrategy) {
                return this.materialize().with(redefinitionStrategy);
            }

            @Override
            public AgentBuilder with(LambdaInstrumentationStrategy lambdaInstrumentationStrategy) {
                return this.materialize().with(lambdaInstrumentationStrategy);
            }

            @Override
            public AgentBuilder enableBootstrapInjection(File folder, Instrumentation instrumentation) {
                return this.materialize().enableBootstrapInjection(folder, instrumentation);
            }

            @Override
            public AgentBuilder disableBootstrapInjection() {
                return this.materialize().disableBootstrapInjection();
            }

            @Override
            public AgentBuilder enableNativeMethodPrefix(String prefix) {
                return this.materialize().enableNativeMethodPrefix(prefix);
            }

            @Override
            public AgentBuilder disableNativeMethodPrefix() {
                return this.materialize().disableNativeMethodPrefix();
            }

            @Override
            public AgentBuilder disableClassFormatChanges() {
                return this.materialize().disableClassFormatChanges();
            }

            @Override
            public Identified.Narrowable type(ElementMatcher<? super TypeDescription> typeMatcher) {
                return this.materialize().type(typeMatcher);
            }

            @Override
            public Identified.Narrowable type(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher) {
                return this.materialize().type(typeMatcher, classLoaderMatcher);
            }

            @Override
            public Identified.Narrowable type(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher, ElementMatcher<? super JavaModule> moduleMatcher) {
                return this.materialize().type(typeMatcher, classLoaderMatcher, moduleMatcher);
            }

            @Override
            public Identified.Narrowable type(RawMatcher matcher) {
                return this.materialize().type(matcher);
            }

            @Override
            public Ignored ignore(ElementMatcher<? super TypeDescription> ignoredTypes) {
                return this.materialize().ignore(ignoredTypes);
            }

            @Override
            public Ignored ignore(ElementMatcher<? super TypeDescription> ignoredTypes, ElementMatcher<? super ClassLoader> ignoredClassLoaders) {
                return this.materialize().ignore(ignoredTypes, ignoredClassLoaders);
            }

            @Override
            public Ignored ignore(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher, ElementMatcher<? super JavaModule> moduleMatcher) {
                return this.materialize().ignore(typeMatcher, classLoaderMatcher, moduleMatcher);
            }

            @Override
            public Ignored ignore(RawMatcher rawMatcher) {
                return this.materialize().ignore(rawMatcher);
            }

            @Override
            public ClassFileTransformer makeRaw() {
                return this.materialize().makeRaw();
            }

            @Override
            public ClassFileTransformer installOn(Instrumentation instrumentation) {
                return this.materialize().installOn(instrumentation);
            }

            @Override
            public ClassFileTransformer installOnByteBuddyAgent() {
                return this.materialize().installOnByteBuddyAgent();
            }
        }

        protected static class ExecutingTransformer
        implements ClassFileTransformer {
            protected static final Factory FACTORY;
            private final ByteBuddy byteBuddy;
            private final TypeLocator typeLocator;
            private final TypeStrategy typeStrategy;
            private final Listener listener;
            private final NativeMethodStrategy nativeMethodStrategy;
            private final AccessControlContext accessControlContext;
            private final InitializationStrategy initializationStrategy;
            private final BootstrapInjectionStrategy bootstrapInjectionStrategy;
            private final RawMatcher ignoredTypeMatcher;
            private final Transformation transformation;

            public ExecutingTransformer(ByteBuddy byteBuddy, TypeLocator typeLocator, TypeStrategy typeStrategy, Listener listener, NativeMethodStrategy nativeMethodStrategy, AccessControlContext accessControlContext, InitializationStrategy initializationStrategy, BootstrapInjectionStrategy bootstrapInjectionStrategy, RawMatcher ignoredTypeMatcher, Transformation transformation) {
                this.byteBuddy = byteBuddy;
                this.typeLocator = typeLocator;
                this.typeStrategy = typeStrategy;
                this.listener = listener;
                this.nativeMethodStrategy = nativeMethodStrategy;
                this.accessControlContext = accessControlContext;
                this.initializationStrategy = initializationStrategy;
                this.bootstrapInjectionStrategy = bootstrapInjectionStrategy;
                this.ignoredTypeMatcher = ignoredTypeMatcher;
                this.transformation = transformation;
            }

            @Override
            public byte[] transform(ClassLoader classLoader, String internalTypeName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] binaryRepresentation) {
                return this.transform(JavaModule.UNSUPPORTED, classLoader, internalTypeName, classBeingRedefined, protectionDomain, binaryRepresentation);
            }

            protected byte[] transform(Object rawModule, String internalTypeName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] binaryRepresentation) {
                JavaModule module = JavaModule.of(rawModule);
                return this.transform(module, module.getClassLoader(this.accessControlContext), internalTypeName, classBeingRedefined, protectionDomain, binaryRepresentation);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private byte[] transform(JavaModule module, ClassLoader classLoader, String internalTypeName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] binaryRepresentation) {
                if (internalTypeName == null) {
                    return NO_TRANSFORMATION;
                }
                String binaryTypeName = internalTypeName.replace('/', '.');
                try {
                    ClassFileLocator classFileLocator = ClassFileLocator.Simple.of(binaryTypeName, binaryRepresentation, ClassFileLocator.ForClassLoader.of(classLoader));
                    byte[] byArray = this.transformation.resolve(classBeingRedefined == null ? this.typeLocator.typePool(classFileLocator, classLoader).describe(binaryTypeName).resolve() : new TypeDescription.ForLoadedType(classBeingRedefined), classLoader, module, classBeingRedefined, protectionDomain, this.ignoredTypeMatcher).apply(this.initializationStrategy, classFileLocator, this.typeStrategy, this.byteBuddy, this.nativeMethodStrategy, this.bootstrapInjectionStrategy, this.accessControlContext, this.listener);
                    return byArray;
                }
                catch (Throwable throwable) {
                    this.listener.onError(binaryTypeName, classLoader, module, throwable);
                    byte[] byArray = NO_TRANSFORMATION;
                    return byArray;
                }
                finally {
                    this.listener.onComplete(binaryTypeName, classLoader, module);
                }
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                ExecutingTransformer that = (ExecutingTransformer)other;
                return this.byteBuddy.equals(that.byteBuddy) && this.typeLocator.equals(that.typeLocator) && this.typeStrategy.equals(that.typeStrategy) && this.initializationStrategy.equals(that.initializationStrategy) && this.listener.equals(that.listener) && this.nativeMethodStrategy.equals(that.nativeMethodStrategy) && this.bootstrapInjectionStrategy.equals(that.bootstrapInjectionStrategy) && this.accessControlContext.equals(that.accessControlContext) && this.ignoredTypeMatcher.equals(that.ignoredTypeMatcher) && this.transformation.equals(that.transformation);
            }

            public int hashCode() {
                int result = this.byteBuddy.hashCode();
                result = 31 * result + this.typeLocator.hashCode();
                result = 31 * result + this.typeStrategy.hashCode();
                result = 31 * result + this.initializationStrategy.hashCode();
                result = 31 * result + this.listener.hashCode();
                result = 31 * result + this.nativeMethodStrategy.hashCode();
                result = 31 * result + this.bootstrapInjectionStrategy.hashCode();
                result = 31 * result + this.accessControlContext.hashCode();
                result = 31 * result + this.ignoredTypeMatcher.hashCode();
                result = 31 * result + this.transformation.hashCode();
                return result;
            }

            public String toString() {
                return "AgentBuilder.Default.ExecutingTransformer{byteBuddy=" + this.byteBuddy + ", typeLocator=" + this.typeLocator + ", typeStrategy=" + this.typeStrategy + ", initializationStrategy=" + this.initializationStrategy + ", listener=" + this.listener + ", nativeMethodStrategy=" + this.nativeMethodStrategy + ", bootstrapInjectionStrategy=" + this.bootstrapInjectionStrategy + ", accessControlContext=" + this.accessControlContext + ", ignoredTypeMatcher=" + this.ignoredTypeMatcher + ", transformation=" + this.transformation + '}';
            }

            static {
                Factory factory;
                try {
                    factory = new Factory.ForJava9CapableVm(new ByteBuddy().subclass(ExecutingTransformer.class).method(ElementMatchers.named("transform").and(ElementMatchers.takesArgument(0, JavaType.MODULE.getTypeStub()))).intercept(MethodCall.invoke(ExecutingTransformer.class.getDeclaredMethod("transform", Object.class, String.class, Class.class, ProtectionDomain.class, byte[].class)).onSuper().withAllArguments()).make().load(ExecutingTransformer.class.getClassLoader(), ClassLoadingStrategy.Default.WRAPPER).getLoaded().getDeclaredConstructor(ByteBuddy.class, TypeLocator.class, TypeStrategy.class, Listener.class, NativeMethodStrategy.class, AccessControlContext.class, InitializationStrategy.class, BootstrapInjectionStrategy.class, RawMatcher.class, Transformation.class));
                }
                catch (RuntimeException exception) {
                    throw exception;
                }
                catch (Exception ignored) {
                    factory = Factory.ForLegacyVm.INSTANCE;
                }
                FACTORY = factory;
            }

            protected static interface Factory {
                public ClassFileTransformer make(ByteBuddy var1, TypeLocator var2, TypeStrategy var3, Listener var4, NativeMethodStrategy var5, AccessControlContext var6, InitializationStrategy var7, BootstrapInjectionStrategy var8, RawMatcher var9, Transformation var10);

                public static enum ForLegacyVm implements Factory
                {
                    INSTANCE;


                    @Override
                    public ClassFileTransformer make(ByteBuddy byteBuddy, TypeLocator typeLocator, TypeStrategy typeStrategy, Listener listener, NativeMethodStrategy nativeMethodStrategy, AccessControlContext accessControlContext, InitializationStrategy initializationStrategy, BootstrapInjectionStrategy bootstrapInjectionStrategy, RawMatcher ignoredTypeMatcher, Transformation transformation) {
                        return new ExecutingTransformer(byteBuddy, typeLocator, typeStrategy, listener, nativeMethodStrategy, accessControlContext, initializationStrategy, bootstrapInjectionStrategy, ignoredTypeMatcher, transformation);
                    }

                    public String toString() {
                        return "AgentBuilder.Default.ExecutingTransformer.Factory.ForLegacyVm." + this.name();
                    }
                }

                public static class ForJava9CapableVm
                implements Factory {
                    private final Constructor<? extends ClassFileTransformer> executingTransformer;

                    protected ForJava9CapableVm(Constructor<? extends ClassFileTransformer> executingTransformer) {
                        this.executingTransformer = executingTransformer;
                    }

                    @Override
                    public ClassFileTransformer make(ByteBuddy byteBuddy, TypeLocator typeLocator, TypeStrategy typeStrategy, Listener listener, NativeMethodStrategy nativeMethodStrategy, AccessControlContext accessControlContext, InitializationStrategy initializationStrategy, BootstrapInjectionStrategy bootstrapInjectionStrategy, RawMatcher ignoredTypeMatcher, Transformation transformation) {
                        try {
                            return this.executingTransformer.newInstance(byteBuddy, typeLocator, typeStrategy, listener, nativeMethodStrategy, accessControlContext, initializationStrategy, bootstrapInjectionStrategy, ignoredTypeMatcher, transformation);
                        }
                        catch (IllegalAccessException exception) {
                            throw new IllegalStateException("Cannot access " + this.executingTransformer, exception);
                        }
                        catch (InstantiationException exception) {
                            throw new IllegalStateException("Cannot instantiate " + this.executingTransformer.getDeclaringClass(), exception);
                        }
                        catch (InvocationTargetException exception) {
                            throw new IllegalStateException("Cannot invoke " + this.executingTransformer, exception.getCause());
                        }
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        ForJava9CapableVm that = (ForJava9CapableVm)object;
                        return this.executingTransformer.equals(that.executingTransformer);
                    }

                    public int hashCode() {
                        return this.executingTransformer.hashCode();
                    }

                    public String toString() {
                        return "AgentBuilder.Default.ExecutingTransformer.Factory.ForJava9CapableVm{executingTransformer=" + this.executingTransformer + '}';
                    }
                }
            }
        }

        protected static interface Transformation {
            public Resolution resolve(TypeDescription var1, ClassLoader var2, JavaModule var3, Class<?> var4, ProtectionDomain var5, RawMatcher var6);

            public static class Compound
            implements Transformation {
                private final List<? extends Transformation> transformations;

                protected Compound(Transformation ... transformation) {
                    this(Arrays.asList(transformation));
                }

                protected Compound(List<? extends Transformation> transformations) {
                    this.transformations = transformations;
                }

                @Override
                public Resolution resolve(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, RawMatcher ignoredTypeMatcher) {
                    Resolution current = new Resolution.Unresolved(typeDescription, classLoader, module);
                    block5: for (Transformation transformation : this.transformations) {
                        Resolution resolution = transformation.resolve(typeDescription, classLoader, module, classBeingRedefined, protectionDomain, ignoredTypeMatcher);
                        switch (resolution.getSort()) {
                            case TERMINAL: {
                                return current.asDecoratorOf(resolution);
                            }
                            case DECORATOR: {
                                current = current.asDecoratorOf(resolution);
                                continue block5;
                            }
                            case UNDEFINED: {
                                continue block5;
                            }
                        }
                        throw new IllegalStateException("Unexpected resolution type: " + (Object)((Object)resolution.getSort()));
                    }
                    return current;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.transformations.equals(((Compound)other).transformations);
                }

                public int hashCode() {
                    return this.transformations.hashCode();
                }

                public String toString() {
                    return "AgentBuilder.Default.Transformation.Compound{transformations=" + this.transformations + '}';
                }
            }

            public static class Simple
            implements Transformation {
                private final RawMatcher rawMatcher;
                private final Transformer transformer;
                private final boolean decorator;

                protected Simple(RawMatcher rawMatcher, Transformer transformer, boolean decorator) {
                    this.rawMatcher = rawMatcher;
                    this.transformer = transformer;
                    this.decorator = decorator;
                }

                @Override
                public net.bytebuddy.agent.builder.AgentBuilder$Default$Transformation$Resolution resolve(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, RawMatcher ignoredTypeMatcher) {
                    return !ignoredTypeMatcher.matches(typeDescription, classLoader, module, classBeingRedefined, protectionDomain) && this.rawMatcher.matches(typeDescription, classLoader, module, classBeingRedefined, protectionDomain) ? new Resolution(typeDescription, classLoader, module, protectionDomain, this.transformer, this.decorator) : new Resolution.Unresolved(typeDescription, classLoader, module);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.decorator == ((Simple)other).decorator && this.rawMatcher.equals(((Simple)other).rawMatcher) && this.transformer.equals(((Simple)other).transformer);
                }

                public int hashCode() {
                    int result = this.rawMatcher.hashCode();
                    result = 31 * result + (this.decorator ? 1 : 0);
                    result = 31 * result + this.transformer.hashCode();
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.Default.Transformation.Simple{rawMatcher=" + this.rawMatcher + ", transformer=" + this.transformer + ", decorator=" + this.decorator + '}';
                }

                protected static class Resolution
                implements Resolution.Decoratable {
                    private final TypeDescription typeDescription;
                    private final ClassLoader classLoader;
                    private final JavaModule module;
                    private final ProtectionDomain protectionDomain;
                    private final Transformer transformer;
                    private final boolean decorator;

                    protected Resolution(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, ProtectionDomain protectionDomain, Transformer transformer, boolean decorator) {
                        this.typeDescription = typeDescription;
                        this.classLoader = classLoader;
                        this.module = module;
                        this.protectionDomain = protectionDomain;
                        this.transformer = transformer;
                        this.decorator = decorator;
                    }

                    @Override
                    public Resolution.Sort getSort() {
                        return this.decorator ? Resolution.Sort.DECORATOR : Resolution.Sort.TERMINAL;
                    }

                    @Override
                    public net.bytebuddy.agent.builder.AgentBuilder$Default$Transformation$Resolution asDecoratorOf(net.bytebuddy.agent.builder.AgentBuilder$Default$Transformation$Resolution resolution) {
                        return resolution.prepend(this);
                    }

                    @Override
                    public net.bytebuddy.agent.builder.AgentBuilder$Default$Transformation$Resolution prepend(Resolution.Decoratable resolution) {
                        return resolution.append(this.transformer);
                    }

                    @Override
                    public net.bytebuddy.agent.builder.AgentBuilder$Default$Transformation$Resolution append(Transformer transformer) {
                        return new Resolution(this.typeDescription, this.classLoader, this.module, this.protectionDomain, new Transformer.Compound(this.transformer, transformer), this.decorator);
                    }

                    @Override
                    public byte[] apply(InitializationStrategy initializationStrategy, ClassFileLocator classFileLocator, TypeStrategy typeStrategy, ByteBuddy byteBuddy, NativeMethodStrategy methodNameTransformer, BootstrapInjectionStrategy bootstrapInjectionStrategy, AccessControlContext accessControlContext, Listener listener) {
                        InitializationStrategy.Dispatcher dispatcher = initializationStrategy.dispatcher();
                        DynamicType.Unloaded<?> dynamicType = dispatcher.apply(this.transformer.transform(typeStrategy.builder(this.typeDescription, byteBuddy, classFileLocator, methodNameTransformer.resolve()), this.typeDescription, this.classLoader)).make();
                        dispatcher.register(dynamicType, this.classLoader, new BootstrapClassLoaderCapableInjectorFactory(bootstrapInjectionStrategy, this.classLoader, this.protectionDomain, accessControlContext));
                        listener.onTransformation(this.typeDescription, this.classLoader, this.module, dynamicType);
                        return dynamicType.getBytes();
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        Resolution that = (Resolution)other;
                        return !(!this.typeDescription.equals(that.typeDescription) || this.decorator != that.decorator || (this.classLoader == null ? that.classLoader != null : !this.classLoader.equals(that.classLoader)) || (this.module == null ? that.module != null : !this.module.equals(that.module)) || (this.protectionDomain == null ? that.protectionDomain != null : !this.protectionDomain.equals(that.protectionDomain)) || !this.transformer.equals(that.transformer));
                    }

                    public int hashCode() {
                        int result = this.typeDescription.hashCode();
                        result = 31 * result + (this.decorator ? 1 : 0);
                        result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
                        result = 31 * result + (this.module != null ? this.module.hashCode() : 0);
                        result = 31 * result + (this.protectionDomain != null ? this.protectionDomain.hashCode() : 0);
                        result = 31 * result + this.transformer.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "AgentBuilder.Default.Transformation.Simple.Resolution{typeDescription=" + this.typeDescription + ", classLoader=" + this.classLoader + ", module=" + this.module + ", protectionDomain=" + this.protectionDomain + ", transformer=" + this.transformer + ", decorator=" + this.decorator + '}';
                    }

                    protected static class BootstrapClassLoaderCapableInjectorFactory
                    implements InitializationStrategy.Dispatcher.InjectorFactory {
                        private final BootstrapInjectionStrategy bootstrapInjectionStrategy;
                        private final ClassLoader classLoader;
                        private final ProtectionDomain protectionDomain;
                        private final AccessControlContext accessControlContext;

                        protected BootstrapClassLoaderCapableInjectorFactory(BootstrapInjectionStrategy bootstrapInjectionStrategy, ClassLoader classLoader, ProtectionDomain protectionDomain, AccessControlContext accessControlContext) {
                            this.bootstrapInjectionStrategy = bootstrapInjectionStrategy;
                            this.classLoader = classLoader;
                            this.protectionDomain = protectionDomain;
                            this.accessControlContext = accessControlContext;
                        }

                        @Override
                        public ClassInjector resolve() {
                            return this.classLoader == null ? this.bootstrapInjectionStrategy.make(this.protectionDomain) : new ClassInjector.UsingReflection(this.classLoader, this.protectionDomain, this.accessControlContext);
                        }

                        public boolean equals(Object other) {
                            if (this == other) {
                                return true;
                            }
                            if (other == null || this.getClass() != other.getClass()) {
                                return false;
                            }
                            BootstrapClassLoaderCapableInjectorFactory that = (BootstrapClassLoaderCapableInjectorFactory)other;
                            return this.bootstrapInjectionStrategy.equals(that.bootstrapInjectionStrategy) && !(this.classLoader == null ? that.classLoader != null : !this.classLoader.equals(that.classLoader)) && !(this.protectionDomain == null ? that.protectionDomain != null : !this.protectionDomain.equals(that.protectionDomain)) && this.accessControlContext.equals(that.accessControlContext);
                        }

                        public int hashCode() {
                            int result = this.bootstrapInjectionStrategy.hashCode();
                            result = 31 * result + (this.protectionDomain != null ? this.protectionDomain.hashCode() : 0);
                            result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
                            result = 31 * result + this.accessControlContext.hashCode();
                            return result;
                        }

                        public String toString() {
                            return "AgentBuilder.Default.Transformation.Simple.Resolution.BootstrapClassLoaderCapableInjectorFactory{bootstrapInjectionStrategy=" + this.bootstrapInjectionStrategy + ", classLoader=" + this.classLoader + ", protectionDomain=" + this.protectionDomain + ", accessControlContext=" + this.accessControlContext + '}';
                        }
                    }
                }
            }

            public static enum Ignored implements Transformation
            {
                INSTANCE;


                @Override
                public Resolution resolve(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, RawMatcher ignoredTypeMatcher) {
                    return new Resolution.Unresolved(typeDescription, classLoader, module);
                }

                public String toString() {
                    return "AgentBuilder.Default.Transformation.Ignored." + this.name();
                }
            }

            public static interface Resolution {
                public Sort getSort();

                public Resolution asDecoratorOf(Resolution var1);

                public Resolution prepend(Decoratable var1);

                public byte[] apply(InitializationStrategy var1, ClassFileLocator var2, TypeStrategy var3, ByteBuddy var4, NativeMethodStrategy var5, BootstrapInjectionStrategy var6, AccessControlContext var7, Listener var8);

                public static class Unresolved
                implements Resolution {
                    private final TypeDescription typeDescription;
                    private final ClassLoader classLoader;
                    private final JavaModule module;

                    protected Unresolved(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                        this.typeDescription = typeDescription;
                        this.classLoader = classLoader;
                        this.module = module;
                    }

                    @Override
                    public Sort getSort() {
                        return Sort.UNDEFINED;
                    }

                    @Override
                    public Resolution asDecoratorOf(Resolution resolution) {
                        return resolution;
                    }

                    @Override
                    public Resolution prepend(Decoratable resolution) {
                        return resolution;
                    }

                    @Override
                    public byte[] apply(InitializationStrategy initializationStrategy, ClassFileLocator classFileLocator, TypeStrategy typeStrategy, ByteBuddy byteBuddy, NativeMethodStrategy methodNameTransformer, BootstrapInjectionStrategy bootstrapInjectionStrategy, AccessControlContext accessControlContext, Listener listener) {
                        listener.onIgnored(this.typeDescription, this.classLoader, this.module);
                        return NO_TRANSFORMATION;
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        Unresolved that = (Unresolved)object;
                        return this.typeDescription.equals(that.typeDescription) && (this.classLoader != null ? this.classLoader.equals(that.classLoader) : that.classLoader == null) && (this.module != null ? this.module.equals(that.module) : that.module == null);
                    }

                    public int hashCode() {
                        int result = this.typeDescription.hashCode();
                        result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
                        result = 31 * result + (this.module != null ? this.module.hashCode() : 0);
                        return result;
                    }

                    public String toString() {
                        return "AgentBuilder.Default.Transformation.Resolution.Unresolved{typeDescription=" + this.typeDescription + ", classLoader=" + this.classLoader + ", module=" + this.module + '}';
                    }
                }

                public static interface Decoratable
                extends Resolution {
                    public Resolution append(Transformer var1);
                }

                public static enum Sort {
                    TERMINAL(true),
                    DECORATOR(true),
                    UNDEFINED(false);

                    private final boolean alive;

                    private Sort(boolean alive) {
                        this.alive = alive;
                    }

                    protected boolean isAlive() {
                        return this.alive;
                    }

                    public String toString() {
                        return "AgentBuilder.Default.Transformation.Resolution.Sort." + this.name();
                    }
                }
            }
        }

        protected static interface NativeMethodStrategy {
            public boolean isEnabled(Instrumentation var1);

            public MethodNameTransformer resolve();

            public String getPrefix();

            public static class ForPrefix
            implements NativeMethodStrategy {
                private final String prefix;

                protected ForPrefix(String prefix) {
                    this.prefix = prefix;
                }

                protected static NativeMethodStrategy of(String prefix) {
                    if (prefix.length() == 0) {
                        throw new IllegalArgumentException("A method name prefix must not be the empty string");
                    }
                    return new ForPrefix(prefix);
                }

                @Override
                public MethodNameTransformer resolve() {
                    return new MethodNameTransformer.Prefixing(this.prefix);
                }

                @Override
                public boolean isEnabled(Instrumentation instrumentation) {
                    if (!instrumentation.isNativeMethodPrefixSupported()) {
                        throw new IllegalArgumentException("A prefix for native methods is not supported: " + instrumentation);
                    }
                    return true;
                }

                @Override
                public String getPrefix() {
                    return this.prefix;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.prefix.equals(((ForPrefix)other).prefix);
                }

                public int hashCode() {
                    return this.prefix.hashCode();
                }

                public String toString() {
                    return "AgentBuilder.Default.NativeMethodStrategy.ForPrefix{prefix='" + this.prefix + '\'' + '}';
                }
            }

            public static enum Disabled implements NativeMethodStrategy
            {
                INSTANCE;


                @Override
                public MethodNameTransformer resolve() {
                    return MethodNameTransformer.Suffixing.withRandomSuffix();
                }

                @Override
                public boolean isEnabled(Instrumentation instrumentation) {
                    return false;
                }

                @Override
                public String getPrefix() {
                    throw new IllegalStateException("A disabled native method strategy does not define a method name prefix");
                }

                public String toString() {
                    return "AgentBuilder.Default.NativeMethodStrategy.Disabled." + this.name();
                }
            }
        }

        protected static interface BootstrapInjectionStrategy {
            public ClassInjector make(ProtectionDomain var1);

            public static class Enabled
            implements BootstrapInjectionStrategy {
                private final File folder;
                private final Instrumentation instrumentation;

                public Enabled(File folder, Instrumentation instrumentation) {
                    this.folder = folder;
                    this.instrumentation = instrumentation;
                }

                @Override
                public ClassInjector make(ProtectionDomain protectionDomain) {
                    return ClassInjector.UsingInstrumentation.of(this.folder, ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, this.instrumentation);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Enabled enabled = (Enabled)other;
                    return this.folder.equals(enabled.folder) && this.instrumentation.equals(enabled.instrumentation);
                }

                public int hashCode() {
                    int result = this.folder.hashCode();
                    result = 31 * result + this.instrumentation.hashCode();
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.Default.BootstrapInjectionStrategy.Enabled{folder=" + this.folder + ", instrumentation=" + this.instrumentation + '}';
                }
            }

            public static enum Disabled implements BootstrapInjectionStrategy
            {
                INSTANCE;


                @Override
                public ClassInjector make(ProtectionDomain protectionDomain) {
                    throw new IllegalStateException("Injecting classes into the bootstrap class loader was not enabled");
                }

                public String toString() {
                    return "AgentBuilder.Default.BootstrapInjectionStrategy.Disabled." + this.name();
                }
            }
        }
    }

    public static enum LambdaInstrumentationStrategy implements Callable<Class<?>>
    {
        ENABLED{

            @Override
            protected void apply(ByteBuddy byteBuddy, Instrumentation instrumentation, ClassFileTransformer classFileTransformer) {
                if (LambdaFactory.register(classFileTransformer, new LambdaInstanceFactory(byteBuddy), this)) {
                    Class<?> lambdaMetaFactory;
                    try {
                        lambdaMetaFactory = Class.forName("java.lang.invoke.LambdaMetafactory");
                    }
                    catch (ClassNotFoundException ignored) {
                        return;
                    }
                    byteBuddy.with(Implementation.Context.Disabled.Factory.INSTANCE).redefine(lambdaMetaFactory).visit(new AsmVisitorWrapper.ForDeclaredMethods().method(ElementMatchers.named("metafactory"), MetaFactoryRedirection.INSTANCE).method(ElementMatchers.named("altMetafactory"), AlternativeMetaFactoryRedirection.INSTANCE)).make().load(lambdaMetaFactory.getClassLoader(), ClassReloadingStrategy.of(instrumentation));
                }
            }

            @Override
            public Class<?> call() throws Exception {
                TypeDescription.ForLoadedType lambdaFactory = new TypeDescription.ForLoadedType(LambdaFactory.class);
                return ClassInjector.UsingReflection.ofSystemClassLoader().inject(Collections.singletonMap(lambdaFactory, ClassFileLocator.ForClassLoader.read(LambdaFactory.class).resolve())).get(lambdaFactory);
            }
        }
        ,
        DISABLED{

            @Override
            protected void apply(ByteBuddy byteBuddy, Instrumentation instrumentation, ClassFileTransformer classFileTransformer) {
            }

            @Override
            public Class<?> call() throws Exception {
                throw new IllegalStateException("Cannot inject LambdaFactory from disabled instrumentation strategy");
            }
        };

        protected static final MethodVisitor IGNORE_ORIGINAL;

        public static void release(ClassFileTransformer classFileTransformer, Instrumentation instrumentation) {
            if (LambdaFactory.release(classFileTransformer)) {
                try {
                    ClassReloadingStrategy.of(instrumentation).reset(Class.forName("java.lang.invoke.LambdaMetafactory"));
                }
                catch (Exception exception) {
                    throw new IllegalStateException("Could not release lambda transformer", exception);
                }
            }
        }

        public static LambdaInstrumentationStrategy of(boolean enabled) {
            return enabled ? ENABLED : DISABLED;
        }

        protected abstract void apply(ByteBuddy var1, Instrumentation var2, ClassFileTransformer var3);

        public boolean isEnabled() {
            return this == ENABLED;
        }

        public String toString() {
            return "AgentBuilder.LambdaInstrumentationStrategy." + this.name();
        }

        static {
            IGNORE_ORIGINAL = null;
        }

        protected static enum AlternativeMetaFactoryRedirection implements AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper
        {
            INSTANCE;


            @Override
            public MethodVisitor wrap(TypeDescription instrumentedType, MethodDescription.InDefinedShape methodDescription, MethodVisitor methodVisitor, ClassFileVersion classFileVersion, int writerFlags, int readerFlags) {
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitInsn(6);
                methodVisitor.visitInsn(50);
                methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
                methodVisitor.visitVarInsn(54, 4);
                methodVisitor.visitInsn(7);
                methodVisitor.visitVarInsn(54, 5);
                methodVisitor.visitVarInsn(21, 4);
                methodVisitor.visitInsn(5);
                methodVisitor.visitInsn(126);
                Label markerInterfaceLoop = new Label();
                methodVisitor.visitJumpInsn(153, markerInterfaceLoop);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitVarInsn(21, 5);
                methodVisitor.visitIincInsn(5, 1);
                methodVisitor.visitInsn(50);
                methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
                methodVisitor.visitVarInsn(54, 7);
                methodVisitor.visitVarInsn(21, 7);
                methodVisitor.visitTypeInsn(189, "java/lang/Class");
                methodVisitor.visitVarInsn(58, 6);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitVarInsn(21, 5);
                methodVisitor.visitVarInsn(25, 6);
                methodVisitor.visitInsn(3);
                methodVisitor.visitVarInsn(21, 7);
                methodVisitor.visitMethodInsn(184, "java/lang/System", "arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)V", false);
                methodVisitor.visitVarInsn(21, 5);
                methodVisitor.visitVarInsn(21, 7);
                methodVisitor.visitInsn(96);
                methodVisitor.visitVarInsn(54, 5);
                Label markerInterfaceExit = new Label();
                methodVisitor.visitJumpInsn(167, markerInterfaceExit);
                methodVisitor.visitLabel(markerInterfaceLoop);
                methodVisitor.visitFrame(1, 2, new Object[]{Opcodes.INTEGER, Opcodes.INTEGER}, 0, null);
                methodVisitor.visitInsn(3);
                methodVisitor.visitTypeInsn(189, "java/lang/Class");
                methodVisitor.visitVarInsn(58, 6);
                methodVisitor.visitLabel(markerInterfaceExit);
                methodVisitor.visitFrame(1, 1, new Object[]{"[Ljava/lang/Class;"}, 0, null);
                methodVisitor.visitVarInsn(21, 4);
                methodVisitor.visitInsn(7);
                methodVisitor.visitInsn(126);
                Label additionalBridgesLoop = new Label();
                methodVisitor.visitJumpInsn(153, additionalBridgesLoop);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitVarInsn(21, 5);
                methodVisitor.visitIincInsn(5, 1);
                methodVisitor.visitInsn(50);
                methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
                methodVisitor.visitVarInsn(54, 8);
                methodVisitor.visitVarInsn(21, 8);
                methodVisitor.visitTypeInsn(189, "java/lang/invoke/MethodType");
                methodVisitor.visitVarInsn(58, 7);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitVarInsn(21, 5);
                methodVisitor.visitVarInsn(25, 7);
                methodVisitor.visitInsn(3);
                methodVisitor.visitVarInsn(21, 8);
                methodVisitor.visitMethodInsn(184, "java/lang/System", "arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)V", false);
                Label additionalBridgesExit = new Label();
                methodVisitor.visitJumpInsn(167, additionalBridgesExit);
                methodVisitor.visitLabel(additionalBridgesLoop);
                methodVisitor.visitFrame(3, 0, null, 0, null);
                methodVisitor.visitInsn(3);
                methodVisitor.visitTypeInsn(189, "java/lang/invoke/MethodType");
                methodVisitor.visitVarInsn(58, 7);
                methodVisitor.visitLabel(additionalBridgesExit);
                methodVisitor.visitFrame(1, 1, new Object[]{"[Ljava/lang/invoke/MethodType;"}, 0, null);
                methodVisitor.visitMethodInsn(184, "sun/misc/Unsafe", "getUnsafe", "()Lsun/misc/Unsafe;", false);
                methodVisitor.visitVarInsn(58, 8);
                methodVisitor.visitVarInsn(25, 8);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(182, "java/lang/invoke/MethodHandles$Lookup", "lookupClass", "()Ljava/lang/Class;", false);
                methodVisitor.visitMethodInsn(184, "java/lang/ClassLoader", "getSystemClassLoader", "()Ljava/lang/ClassLoader;", false);
                methodVisitor.visitLdcInsn("net.bytebuddy.agent.builder.LambdaFactory");
                methodVisitor.visitMethodInsn(182, "java/lang/ClassLoader", "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;", false);
                methodVisitor.visitLdcInsn("make");
                methodVisitor.visitIntInsn(16, 9);
                methodVisitor.visitTypeInsn(189, "java/lang/Class");
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(3);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(4);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/String;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(5);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(6);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(7);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(8);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 6);
                methodVisitor.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 7);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/util/List;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 8);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/util/List;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitMethodInsn(182, "java/lang/Class", "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", false);
                methodVisitor.visitInsn(1);
                methodVisitor.visitIntInsn(16, 9);
                methodVisitor.visitTypeInsn(189, "java/lang/Object");
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(3);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(4);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(5);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(6);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitInsn(3);
                methodVisitor.visitInsn(50);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(7);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitInsn(4);
                methodVisitor.visitInsn(50);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(8);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitInsn(5);
                methodVisitor.visitInsn(50);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 6);
                methodVisitor.visitVarInsn(21, 4);
                methodVisitor.visitInsn(4);
                methodVisitor.visitInsn(126);
                Label callSiteConditional = new Label();
                methodVisitor.visitJumpInsn(153, callSiteConditional);
                methodVisitor.visitInsn(4);
                Label callSiteAlternative = new Label();
                methodVisitor.visitJumpInsn(167, callSiteAlternative);
                methodVisitor.visitLabel(callSiteConditional);
                methodVisitor.visitFrame(0, 9, new Object[]{"java/lang/invoke/MethodHandles$Lookup", "java/lang/String", "java/lang/invoke/MethodType", "[Ljava/lang/Object;", Opcodes.INTEGER, Opcodes.INTEGER, "[Ljava/lang/Class;", "[Ljava/lang/invoke/MethodType;", "sun/misc/Unsafe"}, 7, new Object[]{"sun/misc/Unsafe", "java/lang/Class", "java/lang/reflect/Method", Opcodes.NULL, "[Ljava/lang/Object;", "[Ljava/lang/Object;", Opcodes.INTEGER});
                methodVisitor.visitInsn(3);
                methodVisitor.visitLabel(callSiteAlternative);
                methodVisitor.visitFrame(0, 9, new Object[]{"java/lang/invoke/MethodHandles$Lookup", "java/lang/String", "java/lang/invoke/MethodType", "[Ljava/lang/Object;", Opcodes.INTEGER, Opcodes.INTEGER, "[Ljava/lang/Class;", "[Ljava/lang/invoke/MethodType;", "sun/misc/Unsafe"}, 8, new Object[]{"sun/misc/Unsafe", "java/lang/Class", "java/lang/reflect/Method", Opcodes.NULL, "[Ljava/lang/Object;", "[Ljava/lang/Object;", Opcodes.INTEGER, Opcodes.INTEGER});
                methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 7);
                methodVisitor.visitVarInsn(25, 6);
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "asList", "([Ljava/lang/Object;)Ljava/util/List;", false);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 8);
                methodVisitor.visitVarInsn(25, 7);
                methodVisitor.visitMethodInsn(184, "java/util/Arrays", "asList", "([Ljava/lang/Object;)Ljava/util/List;", false);
                methodVisitor.visitInsn(83);
                methodVisitor.visitMethodInsn(182, "java/lang/reflect/Method", "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", false);
                methodVisitor.visitTypeInsn(192, "[B");
                methodVisitor.visitInsn(1);
                methodVisitor.visitMethodInsn(182, "sun/misc/Unsafe", "defineAnonymousClass", "(Ljava/lang/Class;[B[Ljava/lang/Object;)Ljava/lang/Class;", false);
                methodVisitor.visitVarInsn(58, 9);
                methodVisitor.visitVarInsn(25, 8);
                methodVisitor.visitVarInsn(25, 9);
                methodVisitor.visitMethodInsn(182, "sun/misc/Unsafe", "ensureClassInitialized", "(Ljava/lang/Class;)V", false);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(182, "java/lang/invoke/MethodType", "parameterCount", "()I", false);
                Label callSiteJump = new Label();
                methodVisitor.visitJumpInsn(154, callSiteJump);
                methodVisitor.visitTypeInsn(187, "java/lang/invoke/ConstantCallSite");
                methodVisitor.visitInsn(89);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(182, "java/lang/invoke/MethodType", "returnType", "()Ljava/lang/Class;", false);
                methodVisitor.visitVarInsn(25, 9);
                methodVisitor.visitMethodInsn(182, "java/lang/Class", "getDeclaredConstructors", "()[Ljava/lang/reflect/Constructor;", false);
                methodVisitor.visitInsn(3);
                methodVisitor.visitInsn(50);
                methodVisitor.visitInsn(3);
                methodVisitor.visitTypeInsn(189, "java/lang/Object");
                methodVisitor.visitMethodInsn(182, "java/lang/reflect/Constructor", "newInstance", "([Ljava/lang/Object;)Ljava/lang/Object;", false);
                methodVisitor.visitMethodInsn(184, "java/lang/invoke/MethodHandles", "constant", "(Ljava/lang/Class;Ljava/lang/Object;)Ljava/lang/invoke/MethodHandle;", false);
                methodVisitor.visitMethodInsn(183, "java/lang/invoke/ConstantCallSite", "<init>", "(Ljava/lang/invoke/MethodHandle;)V", false);
                Label callSiteExit = new Label();
                methodVisitor.visitJumpInsn(167, callSiteExit);
                methodVisitor.visitLabel(callSiteJump);
                methodVisitor.visitFrame(1, 1, new Object[]{"java/lang/Class"}, 0, null);
                methodVisitor.visitTypeInsn(187, "java/lang/invoke/ConstantCallSite");
                methodVisitor.visitInsn(89);
                methodVisitor.visitFieldInsn(178, "java/lang/invoke/MethodHandles$Lookup", "IMPL_LOOKUP", "Ljava/lang/invoke/MethodHandles$Lookup;");
                methodVisitor.visitVarInsn(25, 9);
                methodVisitor.visitLdcInsn("get$Lambda");
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(182, "java/lang/invoke/MethodHandles$Lookup", "findStatic", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/MethodHandle;", false);
                methodVisitor.visitMethodInsn(183, "java/lang/invoke/ConstantCallSite", "<init>", "(Ljava/lang/invoke/MethodHandle;)V", false);
                methodVisitor.visitLabel(callSiteExit);
                methodVisitor.visitFrame(4, 0, null, 1, new Object[]{"java/lang/invoke/CallSite"});
                methodVisitor.visitInsn(176);
                methodVisitor.visitMaxs(9, 10);
                methodVisitor.visitEnd();
                return IGNORE_ORIGINAL;
            }

            public String toString() {
                return "AgentBuilder.LambdaInstrumentationStrategy.AlternativeMetaFactoryRedirection." + this.name();
            }
        }

        protected static enum MetaFactoryRedirection implements AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper
        {
            INSTANCE;


            @Override
            public MethodVisitor wrap(TypeDescription instrumentedType, MethodDescription.InDefinedShape methodDescription, MethodVisitor methodVisitor, ClassFileVersion classFileVersion, int writerFlags, int readerFlags) {
                methodVisitor.visitCode();
                methodVisitor.visitMethodInsn(184, "sun/misc/Unsafe", "getUnsafe", "()Lsun/misc/Unsafe;", false);
                methodVisitor.visitVarInsn(58, 6);
                methodVisitor.visitVarInsn(25, 6);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(182, "java/lang/invoke/MethodHandles$Lookup", "lookupClass", "()Ljava/lang/Class;", false);
                methodVisitor.visitMethodInsn(184, "java/lang/ClassLoader", "getSystemClassLoader", "()Ljava/lang/ClassLoader;", false);
                methodVisitor.visitLdcInsn("net.bytebuddy.agent.builder.LambdaFactory");
                methodVisitor.visitMethodInsn(182, "java/lang/ClassLoader", "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;", false);
                methodVisitor.visitLdcInsn("make");
                methodVisitor.visitIntInsn(16, 9);
                methodVisitor.visitTypeInsn(189, "java/lang/Class");
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(3);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(4);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/String;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(5);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(6);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(7);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(8);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 6);
                methodVisitor.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 7);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/util/List;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 8);
                methodVisitor.visitLdcInsn(Type.getType("Ljava/util/List;"));
                methodVisitor.visitInsn(83);
                methodVisitor.visitMethodInsn(182, "java/lang/Class", "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", false);
                methodVisitor.visitInsn(1);
                methodVisitor.visitIntInsn(16, 9);
                methodVisitor.visitTypeInsn(189, "java/lang/Object");
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(3);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(4);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(5);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(6);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(7);
                methodVisitor.visitVarInsn(25, 4);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitInsn(8);
                methodVisitor.visitVarInsn(25, 5);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 6);
                methodVisitor.visitInsn(3);
                methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 7);
                methodVisitor.visitMethodInsn(184, "java/util/Collections", "emptyList", "()Ljava/util/List;", false);
                methodVisitor.visitInsn(83);
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, 8);
                methodVisitor.visitMethodInsn(184, "java/util/Collections", "emptyList", "()Ljava/util/List;", false);
                methodVisitor.visitInsn(83);
                methodVisitor.visitMethodInsn(182, "java/lang/reflect/Method", "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", false);
                methodVisitor.visitTypeInsn(192, "[B");
                methodVisitor.visitInsn(1);
                methodVisitor.visitMethodInsn(182, "sun/misc/Unsafe", "defineAnonymousClass", "(Ljava/lang/Class;[B[Ljava/lang/Object;)Ljava/lang/Class;", false);
                methodVisitor.visitVarInsn(58, 7);
                methodVisitor.visitVarInsn(25, 6);
                methodVisitor.visitVarInsn(25, 7);
                methodVisitor.visitMethodInsn(182, "sun/misc/Unsafe", "ensureClassInitialized", "(Ljava/lang/Class;)V", false);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(182, "java/lang/invoke/MethodType", "parameterCount", "()I", false);
                Label conditionalDefault = new Label();
                methodVisitor.visitJumpInsn(154, conditionalDefault);
                methodVisitor.visitTypeInsn(187, "java/lang/invoke/ConstantCallSite");
                methodVisitor.visitInsn(89);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(182, "java/lang/invoke/MethodType", "returnType", "()Ljava/lang/Class;", false);
                methodVisitor.visitVarInsn(25, 7);
                methodVisitor.visitMethodInsn(182, "java/lang/Class", "getDeclaredConstructors", "()[Ljava/lang/reflect/Constructor;", false);
                methodVisitor.visitInsn(3);
                methodVisitor.visitInsn(50);
                methodVisitor.visitInsn(3);
                methodVisitor.visitTypeInsn(189, "java/lang/Object");
                methodVisitor.visitMethodInsn(182, "java/lang/reflect/Constructor", "newInstance", "([Ljava/lang/Object;)Ljava/lang/Object;", false);
                methodVisitor.visitMethodInsn(184, "java/lang/invoke/MethodHandles", "constant", "(Ljava/lang/Class;Ljava/lang/Object;)Ljava/lang/invoke/MethodHandle;", false);
                methodVisitor.visitMethodInsn(183, "java/lang/invoke/ConstantCallSite", "<init>", "(Ljava/lang/invoke/MethodHandle;)V", false);
                Label conditionalAlternative = new Label();
                methodVisitor.visitJumpInsn(167, conditionalAlternative);
                methodVisitor.visitLabel(conditionalDefault);
                methodVisitor.visitFrame(1, 2, new Object[]{"sun/misc/Unsafe", "java/lang/Class"}, 0, null);
                methodVisitor.visitTypeInsn(187, "java/lang/invoke/ConstantCallSite");
                methodVisitor.visitInsn(89);
                methodVisitor.visitFieldInsn(178, "java/lang/invoke/MethodHandles$Lookup", "IMPL_LOOKUP", "Ljava/lang/invoke/MethodHandles$Lookup;");
                methodVisitor.visitVarInsn(25, 7);
                methodVisitor.visitLdcInsn("get$Lambda");
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(182, "java/lang/invoke/MethodHandles$Lookup", "findStatic", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/MethodHandle;", false);
                methodVisitor.visitMethodInsn(183, "java/lang/invoke/ConstantCallSite", "<init>", "(Ljava/lang/invoke/MethodHandle;)V", false);
                methodVisitor.visitLabel(conditionalAlternative);
                methodVisitor.visitFrame(4, 0, null, 1, new Object[]{"java/lang/invoke/CallSite"});
                methodVisitor.visitInsn(176);
                methodVisitor.visitMaxs(8, 8);
                methodVisitor.visitEnd();
                return IGNORE_ORIGINAL;
            }

            public String toString() {
                return "AgentBuilder.LambdaInstrumentationStrategy.MetaFactoryRedirection." + this.name();
            }
        }

        protected static class LambdaInstanceFactory {
            private static final String LAMBDA_FACTORY = "get$Lambda";
            private static final String FIELD_PREFIX = "arg$";
            private static final String LAMBDA_TYPE_INFIX = "$$Lambda$ByteBuddy$";
            private static final Class<?> NOT_PREVIOUSLY_DEFINED = null;
            private static final AtomicInteger LAMBDA_NAME_COUNTER = new AtomicInteger();
            private final ByteBuddy byteBuddy;

            protected LambdaInstanceFactory(ByteBuddy byteBuddy) {
                this.byteBuddy = byteBuddy;
            }

            public byte[] make(Object targetTypeLookup, String lambdaMethodName, Object factoryMethodType, Object lambdaMethodType, Object targetMethodHandle, Object specializedLambdaMethodType, boolean serializable, List<Class<?>> markerInterfaces, List<?> additionalBridges, Collection<? extends ClassFileTransformer> classFileTransformers) {
                JavaConstant.MethodType factoryMethod = JavaConstant.MethodType.ofLoaded(factoryMethodType);
                JavaConstant.MethodType lambdaMethod = JavaConstant.MethodType.ofLoaded(lambdaMethodType);
                JavaConstant.MethodHandle targetMethod = JavaConstant.MethodHandle.ofLoaded(targetMethodHandle, targetTypeLookup);
                JavaConstant.MethodType specializedLambdaMethod = JavaConstant.MethodType.ofLoaded(specializedLambdaMethodType);
                Class<?> targetType = JavaConstant.MethodHandle.lookupType(targetTypeLookup);
                String lambdaClassName = targetType.getName() + LAMBDA_TYPE_INFIX + LAMBDA_NAME_COUNTER.incrementAndGet();
                DynamicType.Builder<Object> builder = this.byteBuddy.subclass(factoryMethod.getReturnType(), (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).modifiers(TypeManifestation.FINAL, Visibility.PUBLIC).implement(markerInterfaces).name(lambdaClassName).defineConstructor(Visibility.PUBLIC).withParameters(factoryMethod.getParameterTypes()).intercept(ConstructorImplementation.INSTANCE).method(ElementMatchers.named(lambdaMethodName).and(ElementMatchers.takesArguments(lambdaMethod.getParameterTypes())).and(ElementMatchers.returns(lambdaMethod.getReturnType()))).intercept(new LambdaMethodImplementation(targetMethod, specializedLambdaMethod));
                int index = 0;
                for (TypeDescription capturedType : factoryMethod.getParameterTypes()) {
                    builder = builder.defineField(FIELD_PREFIX + ++index, (TypeDefinition)capturedType, Visibility.PRIVATE, FieldManifestation.FINAL);
                }
                if (!factoryMethod.getParameterTypes().isEmpty()) {
                    builder = builder.defineMethod(LAMBDA_FACTORY, (TypeDefinition)factoryMethod.getReturnType(), Visibility.PRIVATE, Ownership.STATIC).withParameters(factoryMethod.getParameterTypes()).intercept(FactoryImplementation.INSTANCE);
                }
                if (serializable) {
                    if (!markerInterfaces.contains(Serializable.class)) {
                        builder = builder.implement(new java.lang.reflect.Type[]{Serializable.class});
                    }
                    builder = builder.defineMethod("writeReplace", (java.lang.reflect.Type)((Object)Object.class), Visibility.PRIVATE).intercept(new SerializationImplementation(new TypeDescription.ForLoadedType(targetType), factoryMethod.getReturnType(), lambdaMethodName, lambdaMethod, targetMethod, JavaConstant.MethodType.ofLoaded(specializedLambdaMethodType)));
                } else if (factoryMethod.getReturnType().isAssignableTo(Serializable.class)) {
                    builder = builder.defineMethod("readObject", Void.TYPE, Visibility.PRIVATE).withParameters(new java.lang.reflect.Type[]{ObjectInputStream.class}).throwing(new java.lang.reflect.Type[]{NotSerializableException.class}).intercept(ExceptionMethod.throwing(NotSerializableException.class, "Non-serializable lambda")).defineMethod("writeObject", Void.TYPE, Visibility.PRIVATE).withParameters(new java.lang.reflect.Type[]{ObjectOutputStream.class}).throwing(new java.lang.reflect.Type[]{NotSerializableException.class}).intercept(ExceptionMethod.throwing(NotSerializableException.class, "Non-serializable lambda"));
                }
                for (Object additionalBridgeType : additionalBridges) {
                    JavaConstant.MethodType methodType = JavaConstant.MethodType.ofLoaded(additionalBridgeType);
                    builder = builder.defineMethod(lambdaMethodName, (TypeDefinition)methodType.getReturnType(), MethodManifestation.BRIDGE, Visibility.PUBLIC).withParameters(methodType.getParameterTypes()).intercept(new BridgeMethodImplementation(lambdaMethodName, lambdaMethod));
                }
                byte[] classFile = builder.make().getBytes();
                for (ClassFileTransformer classFileTransformer : classFileTransformers) {
                    try {
                        byte[] transformedClassFile = classFileTransformer.transform(targetType.getClassLoader(), lambdaClassName.replace('.', '/'), NOT_PREVIOUSLY_DEFINED, targetType.getProtectionDomain(), classFile);
                        classFile = transformedClassFile == null ? classFile : transformedClassFile;
                    }
                    catch (Throwable throwable) {}
                }
                return classFile;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.byteBuddy.equals(((LambdaInstanceFactory)other).byteBuddy);
            }

            public int hashCode() {
                return this.byteBuddy.hashCode();
            }

            public String toString() {
                return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory{byteBuddy=" + this.byteBuddy + '}';
            }

            protected static class BridgeMethodImplementation
            implements Implementation {
                private final String lambdaMethodName;
                private final JavaConstant.MethodType lambdaMethod;

                protected BridgeMethodImplementation(String lambdaMethodName, JavaConstant.MethodType lambdaMethod) {
                    this.lambdaMethodName = lambdaMethodName;
                    this.lambdaMethod = lambdaMethod;
                }

                @Override
                public ByteCodeAppender appender(Implementation.Target implementationTarget) {
                    return new Appender(implementationTarget.invokeSuper(new MethodDescription.SignatureToken(this.lambdaMethodName, this.lambdaMethod.getReturnType(), this.lambdaMethod.getParameterTypes())));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    BridgeMethodImplementation that = (BridgeMethodImplementation)other;
                    return this.lambdaMethodName.equals(that.lambdaMethodName) && this.lambdaMethod.equals(that.lambdaMethod);
                }

                public int hashCode() {
                    int result = this.lambdaMethodName.hashCode();
                    result = 31 * result + this.lambdaMethod.hashCode();
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory.BridgeMethodImplementation{lambdaMethodName='" + this.lambdaMethodName + '\'' + ", lambdaMethod=" + this.lambdaMethod + '}';
                }

                protected static class Appender
                implements ByteCodeAppender {
                    private final Implementation.SpecialMethodInvocation bridgeTargetInvocation;

                    protected Appender(Implementation.SpecialMethodInvocation bridgeTargetInvocation) {
                        this.bridgeTargetInvocation = bridgeTargetInvocation;
                    }

                    @Override
                    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                        return new ByteCodeAppender.Compound(new ByteCodeAppender.Simple(MethodVariableAccess.allArgumentsOf(instrumentedMethod).asBridgeOf(this.bridgeTargetInvocation.getMethodDescription()).prependThisReference(), this.bridgeTargetInvocation, this.bridgeTargetInvocation.getMethodDescription().getReturnType().asErasure().isAssignableTo(instrumentedMethod.getReturnType().asErasure()) ? StackManipulation.Trivial.INSTANCE : TypeCasting.to(instrumentedMethod.getReceiverType().asErasure()), MethodReturn.returning(instrumentedMethod.getReturnType().asErasure()))).apply(methodVisitor, implementationContext, instrumentedMethod);
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.bridgeTargetInvocation.equals(((Appender)other).bridgeTargetInvocation);
                    }

                    public int hashCode() {
                        return this.bridgeTargetInvocation.hashCode();
                    }

                    public String toString() {
                        return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory.BridgeMethodImplementation.Appender{bridgeTargetInvocation=" + this.bridgeTargetInvocation + '}';
                    }
                }
            }

            protected static class SerializationImplementation
            implements Implementation {
                private final TypeDescription targetType;
                private final TypeDescription lambdaType;
                private final String lambdaMethodName;
                private final JavaConstant.MethodType lambdaMethod;
                private final JavaConstant.MethodHandle targetMethod;
                private final JavaConstant.MethodType specializedMethod;

                protected SerializationImplementation(TypeDescription targetType, TypeDescription lambdaType, String lambdaMethodName, JavaConstant.MethodType lambdaMethod, JavaConstant.MethodHandle targetMethod, JavaConstant.MethodType specializedMethod) {
                    this.targetType = targetType;
                    this.lambdaType = lambdaType;
                    this.lambdaMethodName = lambdaMethodName;
                    this.lambdaMethod = lambdaMethod;
                    this.targetMethod = targetMethod;
                    this.specializedMethod = specializedMethod;
                }

                @Override
                public ByteCodeAppender appender(Implementation.Target implementationTarget) {
                    TypeDescription.ForLoadedType serializedLambda;
                    try {
                        serializedLambda = new TypeDescription.ForLoadedType(Class.forName("java.lang.invoke.SerializedLambda"));
                    }
                    catch (ClassNotFoundException exception) {
                        throw new IllegalStateException("Cannot find class for lambda serialization", exception);
                    }
                    ArrayList<StackManipulation> lambdaArguments = new ArrayList<StackManipulation>(implementationTarget.getInstrumentedType().getDeclaredFields().size());
                    for (FieldDescription.InDefinedShape fieldDescription : implementationTarget.getInstrumentedType().getDeclaredFields()) {
                        lambdaArguments.add(new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadOffset(0), FieldAccess.forField(fieldDescription).getter(), Assigner.DEFAULT.assign(fieldDescription.getType(), TypeDescription.Generic.OBJECT, Assigner.Typing.STATIC)));
                    }
                    return new ByteCodeAppender.Simple(new StackManipulation.Compound(TypeCreation.of(serializedLambda), Duplication.SINGLE, ClassConstant.of(this.targetType), new TextConstant(this.lambdaType.getInternalName()), new TextConstant(this.lambdaMethodName), new TextConstant(this.lambdaMethod.getDescriptor()), IntegerConstant.forValue(this.targetMethod.getHandleType().getIdentifier()), new TextConstant(this.targetMethod.getOwnerType().getInternalName()), new TextConstant(this.targetMethod.getName()), new TextConstant(this.targetMethod.getDescriptor()), new TextConstant(this.specializedMethod.getDescriptor()), ArrayFactory.forType(TypeDescription.Generic.OBJECT).withValues(lambdaArguments), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)serializedLambda.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly()), MethodReturn.REFERENCE));
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    SerializationImplementation that = (SerializationImplementation)other;
                    return this.targetType.equals(that.targetType) && this.lambdaType.equals(that.lambdaType) && this.lambdaMethodName.equals(that.lambdaMethodName) && this.lambdaMethod.equals(that.lambdaMethod) && this.targetMethod.equals(that.targetMethod) && this.specializedMethod.equals(that.specializedMethod);
                }

                public int hashCode() {
                    int result = this.targetType.hashCode();
                    result = 31 * result + this.lambdaType.hashCode();
                    result = 31 * result + this.lambdaMethodName.hashCode();
                    result = 31 * result + this.lambdaMethod.hashCode();
                    result = 31 * result + this.targetMethod.hashCode();
                    result = 31 * result + this.specializedMethod.hashCode();
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory.SerializationImplementation{targetType=" + this.targetType + ", lambdaType=" + this.lambdaType + ", lambdaMethodName='" + this.lambdaMethodName + '\'' + ", lambdaMethod=" + this.lambdaMethod + ", targetMethod=" + this.targetMethod + ", specializedMethod=" + this.specializedMethod + '}';
                }
            }

            protected static class LambdaMethodImplementation
            implements Implementation {
                private final JavaConstant.MethodHandle targetMethod;
                private final JavaConstant.MethodType specializedLambdaMethod;

                protected LambdaMethodImplementation(JavaConstant.MethodHandle targetMethod, JavaConstant.MethodType specializedLambdaMethod) {
                    this.targetMethod = targetMethod;
                    this.specializedLambdaMethod = specializedLambdaMethod;
                }

                @Override
                public ByteCodeAppender appender(Implementation.Target implementationTarget) {
                    return new Appender((MethodDescription)((MethodList)this.targetMethod.getOwnerType().getDeclaredMethods().filter(ElementMatchers.named(this.targetMethod.getName()).and(ElementMatchers.returns(this.targetMethod.getReturnType())).and(ElementMatchers.takesArguments(this.targetMethod.getParameterTypes())))).getOnly(), this.specializedLambdaMethod, implementationTarget.getInstrumentedType().getDeclaredFields());
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    LambdaMethodImplementation that = (LambdaMethodImplementation)other;
                    return this.targetMethod.equals(that.targetMethod) && this.specializedLambdaMethod.equals(that.specializedLambdaMethod);
                }

                public int hashCode() {
                    int result = this.targetMethod.hashCode();
                    result = 31 * result + this.specializedLambdaMethod.hashCode();
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory.LambdaMethodImplementation{targetMethod=" + this.targetMethod + ", specializedLambdaMethod=" + this.specializedLambdaMethod + '}';
                }

                protected static class Appender
                implements ByteCodeAppender {
                    private final MethodDescription targetMethod;
                    private final JavaConstant.MethodType specializedLambdaMethod;
                    private final List<FieldDescription.InDefinedShape> declaredFields;

                    protected Appender(MethodDescription targetMethod, JavaConstant.MethodType specializedLambdaMethod, List<FieldDescription.InDefinedShape> declaredFields) {
                        this.targetMethod = targetMethod;
                        this.specializedLambdaMethod = specializedLambdaMethod;
                        this.declaredFields = declaredFields;
                    }

                    @Override
                    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                        ArrayList<StackManipulation> fieldAccess = new ArrayList<StackManipulation>(this.declaredFields.size() * 2);
                        for (FieldDescription.InDefinedShape fieldDescription : this.declaredFields) {
                            fieldAccess.add(MethodVariableAccess.REFERENCE.loadOffset(0));
                            fieldAccess.add(FieldAccess.forField(fieldDescription).getter());
                        }
                        ArrayList<StackManipulation> parameterAccess = new ArrayList<StackManipulation>(instrumentedMethod.getParameters().size() * 2);
                        for (ParameterDescription parameterDescription : instrumentedMethod.getParameters()) {
                            parameterAccess.add(MethodVariableAccess.of(parameterDescription.getType()).loadOffset(parameterDescription.getOffset()));
                            parameterAccess.add(Assigner.DEFAULT.assign(parameterDescription.getType(), ((TypeDescription)this.specializedLambdaMethod.getParameterTypes().get(parameterDescription.getIndex())).asGenericType(), Assigner.Typing.DYNAMIC));
                        }
                        return new ByteCodeAppender.Size(new StackManipulation.Compound(new StackManipulation.Compound(fieldAccess), new StackManipulation.Compound(parameterAccess), MethodInvocation.invoke(this.targetMethod), MethodReturn.returning(this.targetMethod.getReturnType().asErasure())).apply(methodVisitor, implementationContext).getMaximalSize(), instrumentedMethod.getStackSize());
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        Appender appender = (Appender)other;
                        return this.targetMethod.equals(appender.targetMethod) && this.declaredFields.equals(appender.declaredFields) && this.specializedLambdaMethod.equals(appender.specializedLambdaMethod);
                    }

                    public int hashCode() {
                        int result = this.targetMethod.hashCode();
                        result = 31 * result + this.declaredFields.hashCode();
                        result = 31 * result + this.specializedLambdaMethod.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory.LambdaMethodImplementation.Appender{targetMethod=" + this.targetMethod + ", specializedLambdaMethod=" + this.specializedLambdaMethod + ", declaredFields=" + this.declaredFields + '}';
                    }
                }
            }

            protected static enum FactoryImplementation implements Implementation
            {
                INSTANCE;


                @Override
                public ByteCodeAppender appender(Implementation.Target implementationTarget) {
                    return new Appender(implementationTarget.getInstrumentedType());
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public String toString() {
                    return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory.FactoryImplementation." + this.name();
                }

                protected static class Appender
                implements ByteCodeAppender {
                    private final TypeDescription instrumentedType;

                    protected Appender(TypeDescription instrumentedType) {
                        this.instrumentedType = instrumentedType;
                    }

                    @Override
                    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                        return new ByteCodeAppender.Size(new StackManipulation.Compound(TypeCreation.of(this.instrumentedType), Duplication.SINGLE, MethodVariableAccess.allArgumentsOf(instrumentedMethod), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)this.instrumentedType.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly()), MethodReturn.REFERENCE).apply(methodVisitor, implementationContext).getMaximalSize(), instrumentedMethod.getStackSize());
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType);
                    }

                    public int hashCode() {
                        return this.instrumentedType.hashCode();
                    }

                    public String toString() {
                        return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory.FactoryImplementation.Appender{instrumentedType=" + this.instrumentedType + '}';
                    }
                }
            }

            @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="An enumeration does not serialize fields")
            protected static enum ConstructorImplementation implements Implementation
            {
                INSTANCE;

                private final MethodDescription.InDefinedShape objectConstructor = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.OBJECT.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly();

                @Override
                public ByteCodeAppender appender(Implementation.Target implementationTarget) {
                    return new Appender(implementationTarget.getInstrumentedType().getDeclaredFields());
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                public String toString() {
                    return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory.ConstructorImplementation." + this.name();
                }

                protected static class Appender
                implements ByteCodeAppender {
                    private final List<FieldDescription.InDefinedShape> declaredFields;

                    protected Appender(List<FieldDescription.InDefinedShape> declaredFields) {
                        this.declaredFields = declaredFields;
                    }

                    @Override
                    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                        ArrayList<StackManipulation> fieldAssignments = new ArrayList<StackManipulation>(this.declaredFields.size() * 3);
                        for (ParameterDescription parameterDescription : instrumentedMethod.getParameters()) {
                            fieldAssignments.add(MethodVariableAccess.REFERENCE.loadOffset(0));
                            fieldAssignments.add(MethodVariableAccess.of(parameterDescription.getType()).loadOffset(parameterDescription.getOffset()));
                            fieldAssignments.add(FieldAccess.forField(this.declaredFields.get(parameterDescription.getIndex())).putter());
                        }
                        return new ByteCodeAppender.Size(new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadOffset(0), MethodInvocation.invoke(INSTANCE.objectConstructor), new StackManipulation.Compound(fieldAssignments), MethodReturn.VOID).apply(methodVisitor, implementationContext).getMaximalSize(), instrumentedMethod.getStackSize());
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.declaredFields.equals(((Appender)other).declaredFields);
                    }

                    public int hashCode() {
                        return this.declaredFields.hashCode();
                    }

                    public String toString() {
                        return "AgentBuilder.LambdaInstrumentationStrategy.LambdaInstanceFactory.ConstructorImplementation.Appender{declaredFields=" + this.declaredFields + '}';
                    }
                }
            }
        }
    }

    public static enum RedefinitionStrategy {
        DISABLED{

            @Override
            protected boolean isRetransforming(Instrumentation instrumentation) {
                return false;
            }

            @Override
            protected Collector makeCollector(Default.Transformation transformation) {
                throw new IllegalStateException("A disabled redefinition strategy cannot create a collector");
            }
        }
        ,
        REDEFINITION{

            @Override
            protected boolean isRetransforming(Instrumentation instrumentation) {
                if (!instrumentation.isRedefineClassesSupported()) {
                    throw new IllegalArgumentException("Cannot redefine classes: " + instrumentation);
                }
                return false;
            }

            @Override
            protected Collector makeCollector(Default.Transformation transformation) {
                return new Collector.ForRedefinition(transformation);
            }
        }
        ,
        RETRANSFORMATION{

            @Override
            protected boolean isRetransforming(Instrumentation instrumentation) {
                if (!instrumentation.isRetransformClassesSupported()) {
                    throw new IllegalArgumentException("Cannot retransform classes: " + instrumentation);
                }
                return true;
            }

            @Override
            protected Collector makeCollector(Default.Transformation transformation) {
                return new Collector.ForRetransformation(transformation);
            }
        };


        protected abstract boolean isRetransforming(Instrumentation var1);

        protected boolean isEnabled() {
            return this != DISABLED;
        }

        protected abstract Collector makeCollector(Default.Transformation var1);

        public String toString() {
            return "AgentBuilder.RedefinitionStrategy." + this.name();
        }

        protected static interface Collector {
            public boolean consider(Class<?> var1, RawMatcher var2);

            public void apply(Instrumentation var1, TypeLocator var2, Listener var3) throws UnmodifiableClassException, ClassNotFoundException;

            public static class ForRetransformation
            implements Collector {
                private final Default.Transformation transformation;
                private final List<Class<?>> types;

                protected ForRetransformation(Default.Transformation transformation) {
                    this.transformation = transformation;
                    this.types = new ArrayList();
                }

                @Override
                public boolean consider(Class<?> type, RawMatcher ignoredTypeMatcher) {
                    return this.transformation.resolve(new TypeDescription.ForLoadedType(type), type.getClassLoader(), JavaModule.ofType(type), type, type.getProtectionDomain(), ignoredTypeMatcher).getSort().isAlive() && this.types.add(type);
                }

                @Override
                public void apply(Instrumentation instrumentation, TypeLocator typeLocator, Listener listener) throws UnmodifiableClassException {
                    if (!this.types.isEmpty()) {
                        instrumentation.retransformClasses(this.types.toArray(new Class[this.types.size()]));
                    }
                }

                public String toString() {
                    return "AgentBuilder.RedefinitionStrategy.Collector.ForRetransformation{transformation=" + this.transformation + ", types=" + this.types + '}';
                }
            }

            public static class ForRedefinition
            implements Collector {
                private final Default.Transformation transformation;
                private final List<Entry> entries;

                protected ForRedefinition(Default.Transformation transformation) {
                    this.transformation = transformation;
                    this.entries = new ArrayList<Entry>();
                }

                @Override
                public boolean consider(Class<?> type, RawMatcher ignoredTypeMatcher) {
                    return this.transformation.resolve(new TypeDescription.ForLoadedType(type), type.getClassLoader(), JavaModule.ofType(type), type, type.getProtectionDomain(), ignoredTypeMatcher).getSort().isAlive() && this.entries.add(new Entry(type));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void apply(Instrumentation instrumentation, TypeLocator typeLocator, Listener listener) throws UnmodifiableClassException, ClassNotFoundException {
                    ArrayList<ClassDefinition> classDefinitions = new ArrayList<ClassDefinition>(this.entries.size());
                    for (Entry entry : this.entries) {
                        TypeDescription.ForLoadedType typeDescription = new TypeDescription.ForLoadedType(entry.getType());
                        JavaModule module = JavaModule.ofType(entry.getType());
                        try {
                            classDefinitions.add(entry.resolve(ClassFileLocator.ForClassLoader.of(entry.getType().getClassLoader())));
                        }
                        catch (Throwable throwable) {
                            try {
                                listener.onError(typeDescription.getName(), entry.getType().getClassLoader(), module, throwable);
                            }
                            finally {
                                listener.onComplete(typeDescription.getName(), entry.getType().getClassLoader(), module);
                            }
                        }
                    }
                    if (!classDefinitions.isEmpty()) {
                        instrumentation.redefineClasses(classDefinitions.toArray(new ClassDefinition[classDefinitions.size()]));
                    }
                }

                public String toString() {
                    return "AgentBuilder.RedefinitionStrategy.Collector.ForRedefinition{transformation=" + this.transformation + ", entries=" + this.entries + '}';
                }

                protected static class Entry {
                    private final Class<?> type;

                    protected Entry(Class<?> type) {
                        this.type = type;
                    }

                    public Class<?> getType() {
                        return this.type;
                    }

                    protected ClassDefinition resolve(ClassFileLocator classFileLocator) throws IOException {
                        return new ClassDefinition(this.type, classFileLocator.locate(this.type.getName()).resolve());
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        Entry entry = (Entry)other;
                        return this.type.equals(entry.type);
                    }

                    public int hashCode() {
                        return this.type.hashCode();
                    }

                    public String toString() {
                        return "AgentBuilder.RedefinitionStrategy.Collector.ForRedefinition.Entry{type=" + this.type + '}';
                    }
                }
            }
        }
    }

    public static interface InitializationStrategy {
        public Dispatcher dispatcher();

        public static enum Minimal implements InitializationStrategy,
        Dispatcher
        {
            INSTANCE;


            @Override
            public Dispatcher dispatcher() {
                return this;
            }

            @Override
            public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder) {
                return builder;
            }

            @Override
            public void register(DynamicType dynamicType, ClassLoader classLoader, Dispatcher.InjectorFactory injectorFactory) {
                Map<TypeDescription, byte[]> auxiliaryTypes = dynamicType.getAuxiliaryTypes();
                LinkedHashMap<TypeDescription, byte[]> independentTypes = new LinkedHashMap<TypeDescription, byte[]>(auxiliaryTypes);
                for (TypeDescription auxiliaryType : auxiliaryTypes.keySet()) {
                    if (auxiliaryType.getDeclaredAnnotations().isAnnotationPresent(AuxiliaryType.SignatureRelevant.class)) continue;
                    independentTypes.remove(auxiliaryType);
                }
                if (!independentTypes.isEmpty()) {
                    ClassInjector classInjector = injectorFactory.resolve();
                    Map<TypeDescription, LoadedTypeInitializer> loadedTypeInitializers = dynamicType.getLoadedTypeInitializers();
                    for (Map.Entry<TypeDescription, Class<?>> entry : classInjector.inject(independentTypes).entrySet()) {
                        loadedTypeInitializers.get(entry.getKey()).onLoad(entry.getValue());
                    }
                }
            }

            public String toString() {
                return "AgentBuilder.InitializationStrategy.Minimal." + this.name();
            }
        }

        public static enum SelfInjection implements InitializationStrategy
        {
            SPLIT{

                @Override
                public net.bytebuddy.agent.builder.AgentBuilder$InitializationStrategy$Dispatcher dispatcher() {
                    return new Dispatcher.Split(this.random.nextInt());
                }
            }
            ,
            LAZY{

                @Override
                public net.bytebuddy.agent.builder.AgentBuilder$InitializationStrategy$Dispatcher dispatcher() {
                    return new Dispatcher.Lazy(this.random.nextInt());
                }
            }
            ,
            EAGER{

                @Override
                public net.bytebuddy.agent.builder.AgentBuilder$InitializationStrategy$Dispatcher dispatcher() {
                    return new Dispatcher.Eager(this.random.nextInt());
                }
            };

            protected final Random random = new Random();

            public String toString() {
                return "AgentBuilder.InitializationStrategy.SelfInjection." + this.name();
            }

            protected static enum NexusAccessor {
                INSTANCE;

                private final Dispatcher dispatcher;
                private final MethodDescription.InDefinedShape getSystemClassLoader;
                private final MethodDescription.InDefinedShape loadClass;
                private final MethodDescription.InDefinedShape valueOf;
                private final MethodDescription getDeclaredMethod;
                private final MethodDescription invokeMethod;

                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Explicit delegation of the exception")
                private NexusAccessor() {
                    Dispatcher dispatcher;
                    try {
                        TypeDescription.ForLoadedType nexusType = new TypeDescription.ForLoadedType(Nexus.class);
                        dispatcher = new Dispatcher.Available(ClassInjector.UsingReflection.ofSystemClassLoader().inject(Collections.singletonMap(nexusType, ClassFileLocator.ForClassLoader.read(Nexus.class).resolve())).get(nexusType).getDeclaredMethod("register", String.class, ClassLoader.class, Integer.TYPE, Object.class));
                    }
                    catch (Exception exception) {
                        try {
                            dispatcher = new Dispatcher.Available(ClassLoader.getSystemClassLoader().loadClass(Nexus.class.getName()).getDeclaredMethod("register", String.class, ClassLoader.class, Integer.TYPE, Object.class));
                        }
                        catch (Exception ignored) {
                            dispatcher = new Dispatcher.Unavailable(exception);
                        }
                    }
                    this.dispatcher = dispatcher;
                    this.getSystemClassLoader = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(ClassLoader.class).getDeclaredMethods().filter(ElementMatchers.named("getSystemClassLoader").and(ElementMatchers.takesArguments(0)))).getOnly();
                    this.loadClass = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(ClassLoader.class).getDeclaredMethods().filter(ElementMatchers.named("loadClass").and(ElementMatchers.takesArguments(String.class)))).getOnly();
                    this.getDeclaredMethod = (MethodDescription)((MethodList)new TypeDescription.ForLoadedType(Class.class).getDeclaredMethods().filter(ElementMatchers.named("getDeclaredMethod").and(ElementMatchers.takesArguments(String.class, Class[].class)))).getOnly();
                    this.invokeMethod = (MethodDescription)((MethodList)new TypeDescription.ForLoadedType(Method.class).getDeclaredMethods().filter(ElementMatchers.named("invoke").and(ElementMatchers.takesArguments(Object.class, Object[].class)))).getOnly();
                    this.valueOf = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(Integer.class).getDeclaredMethods().filter(ElementMatchers.named("valueOf").and(ElementMatchers.takesArguments(Integer.TYPE)))).getOnly();
                }

                public void register(String name, ClassLoader classLoader, int identification, LoadedTypeInitializer typeInitializer) {
                    this.dispatcher.register(name, classLoader, identification, typeInitializer);
                }

                public ByteCodeAppender identifiedBy(int identification) {
                    return new InitializationAppender(identification);
                }

                public String toString() {
                    return "AgentBuilder.InitializationStrategy.SelfInjection.NexusAccessor." + this.name();
                }

                protected static class InitializationAppender
                implements ByteCodeAppender {
                    private final int identification;

                    protected InitializationAppender(int identification) {
                        this.identification = identification;
                    }

                    @Override
                    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                        return new ByteCodeAppender.Simple(new StackManipulation.Compound(MethodInvocation.invoke(INSTANCE.getSystemClassLoader), new TextConstant(Nexus.class.getName()), MethodInvocation.invoke(INSTANCE.loadClass), new TextConstant("initialize"), ArrayFactory.forType(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Class.class)).withValues(Arrays.asList(ClassConstant.of(TypeDescription.CLASS), ClassConstant.of(new TypeDescription.ForLoadedType(Integer.TYPE)))), MethodInvocation.invoke(INSTANCE.getDeclaredMethod), NullConstant.INSTANCE, ArrayFactory.forType(TypeDescription.Generic.OBJECT).withValues(Arrays.asList(ClassConstant.of(instrumentedMethod.getDeclaringType().asErasure()), new StackManipulation.Compound(IntegerConstant.forValue(this.identification), MethodInvocation.invoke(INSTANCE.valueOf)))), MethodInvocation.invoke(INSTANCE.invokeMethod), Removal.SINGLE)).apply(methodVisitor, implementationContext, instrumentedMethod);
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        InitializationAppender that = (InitializationAppender)other;
                        return this.identification == that.identification;
                    }

                    public int hashCode() {
                        return this.identification;
                    }

                    public String toString() {
                        return "AgentBuilder.InitializationStrategy.SelfInjection.NexusAccessor.InitializationAppender{identification=" + this.identification + '}';
                    }
                }

                protected static interface Dispatcher {
                    public void register(String var1, ClassLoader var2, int var3, LoadedTypeInitializer var4);

                    public static class Unavailable
                    implements Dispatcher {
                        private final Exception exception;

                        protected Unavailable(Exception exception) {
                            this.exception = exception;
                        }

                        @Override
                        public void register(String name, ClassLoader classLoader, int identification, LoadedTypeInitializer typeInitializer) {
                            throw new IllegalStateException("Could not locate registration method", this.exception);
                        }

                        public boolean equals(Object other) {
                            return this == other || other != null && this.getClass() == other.getClass() && this.exception.equals(((Unavailable)other).exception);
                        }

                        public int hashCode() {
                            return this.exception.hashCode();
                        }

                        public String toString() {
                            return "AgentBuilder.InitializationStrategy.SelfInjection.NexusAccessor.Dispatcher.Unavailable{exception=" + this.exception + '}';
                        }
                    }

                    public static class Available
                    implements Dispatcher {
                        private static final Object STATIC_METHOD = null;
                        private final Method registration;

                        protected Available(Method registration) {
                            this.registration = registration;
                        }

                        @Override
                        public void register(String name, ClassLoader classLoader, int identification, LoadedTypeInitializer typeInitializer) {
                            try {
                                this.registration.invoke(STATIC_METHOD, name, classLoader, identification, typeInitializer);
                            }
                            catch (IllegalAccessException exception) {
                                throw new IllegalStateException("Cannot register type initializer for " + name, exception);
                            }
                            catch (InvocationTargetException exception) {
                                throw new IllegalStateException("Cannot register type initializer for " + name, exception.getCause());
                            }
                        }

                        public boolean equals(Object other) {
                            return this == other || other != null && this.getClass() == other.getClass() && this.registration.equals(((Available)other).registration);
                        }

                        public int hashCode() {
                            return this.registration.hashCode();
                        }

                        public String toString() {
                            return "AgentBuilder.InitializationStrategy.SelfInjection.NexusAccessor.Dispatcher.Available{registration=" + this.registration + '}';
                        }
                    }
                }
            }

            protected static abstract class Dispatcher
            implements net.bytebuddy.agent.builder.AgentBuilder$InitializationStrategy$Dispatcher {
                protected final int identification;

                protected Dispatcher(int identification) {
                    this.identification = identification;
                }

                @Override
                public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder) {
                    return builder.initializer(NexusAccessor.INSTANCE.identifiedBy(this.identification));
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.identification == ((Dispatcher)other).identification;
                }

                public int hashCode() {
                    return this.identification;
                }

                protected static class InjectingInitializer
                implements LoadedTypeInitializer {
                    private final TypeDescription instrumentedType;
                    private final Map<TypeDescription, byte[]> rawAuxiliaryTypes;
                    private final Map<TypeDescription, LoadedTypeInitializer> loadedTypeInitializers;
                    private final ClassInjector classInjector;

                    protected InjectingInitializer(TypeDescription instrumentedType, Map<TypeDescription, byte[]> rawAuxiliaryTypes, Map<TypeDescription, LoadedTypeInitializer> loadedTypeInitializers, ClassInjector classInjector) {
                        this.instrumentedType = instrumentedType;
                        this.rawAuxiliaryTypes = rawAuxiliaryTypes;
                        this.loadedTypeInitializers = loadedTypeInitializers;
                        this.classInjector = classInjector;
                    }

                    @Override
                    public void onLoad(Class<?> type) {
                        for (Map.Entry<TypeDescription, Class<?>> auxiliary : this.classInjector.inject(this.rawAuxiliaryTypes).entrySet()) {
                            this.loadedTypeInitializers.get(auxiliary.getKey()).onLoad(auxiliary.getValue());
                        }
                        this.loadedTypeInitializers.get(this.instrumentedType).onLoad(type);
                    }

                    @Override
                    public boolean isAlive() {
                        return true;
                    }

                    public boolean equals(Object o) {
                        if (this == o) {
                            return true;
                        }
                        if (o == null || this.getClass() != o.getClass()) {
                            return false;
                        }
                        InjectingInitializer that = (InjectingInitializer)o;
                        return this.classInjector.equals(that.classInjector) && this.instrumentedType.equals(that.instrumentedType) && this.rawAuxiliaryTypes.equals(that.rawAuxiliaryTypes) && this.loadedTypeInitializers.equals(that.loadedTypeInitializers);
                    }

                    public int hashCode() {
                        int result = this.instrumentedType.hashCode();
                        result = 31 * result + this.rawAuxiliaryTypes.hashCode();
                        result = 31 * result + this.loadedTypeInitializers.hashCode();
                        result = 31 * result + this.classInjector.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "AgentBuilder.InitializationStrategy.SelfInjection.Dispatcher.InjectingInitializer{instrumentedType=" + this.instrumentedType + ", rawAuxiliaryTypes=" + this.rawAuxiliaryTypes + ", loadedTypeInitializers=" + this.loadedTypeInitializers + ", classInjector=" + this.classInjector + '}';
                    }
                }

                protected static class Eager
                extends Dispatcher {
                    protected Eager(int identification) {
                        super(identification);
                    }

                    @Override
                    public void register(DynamicType dynamicType, ClassLoader classLoader, Dispatcher.InjectorFactory injectorFactory) {
                        LoadedTypeInitializer loadedTypeInitializer;
                        Map<TypeDescription, byte[]> auxiliaryTypes = dynamicType.getAuxiliaryTypes();
                        Map<TypeDescription, LoadedTypeInitializer> loadedTypeInitializers = dynamicType.getLoadedTypeInitializers();
                        if (!auxiliaryTypes.isEmpty()) {
                            for (Map.Entry<TypeDescription, Class<?>> entry : injectorFactory.resolve().inject(auxiliaryTypes).entrySet()) {
                                loadedTypeInitializers.get(entry.getKey()).onLoad(entry.getValue());
                            }
                        }
                        if ((loadedTypeInitializer = loadedTypeInitializers.get(dynamicType.getTypeDescription())).isAlive()) {
                            NexusAccessor.INSTANCE.register(dynamicType.getTypeDescription().getName(), classLoader, this.identification, loadedTypeInitializer);
                        }
                    }

                    public String toString() {
                        return "AgentBuilder.InitializationStrategy.SelfInjection.Dispatcher.Eager{identification=" + this.identification + "}";
                    }
                }

                protected static class Lazy
                extends Dispatcher {
                    protected Lazy(int identification) {
                        super(identification);
                    }

                    @Override
                    public void register(DynamicType dynamicType, ClassLoader classLoader, Dispatcher.InjectorFactory injectorFactory) {
                        LoadedTypeInitializer loadedTypeInitializer;
                        Map<TypeDescription, byte[]> auxiliaryTypes = dynamicType.getAuxiliaryTypes();
                        LoadedTypeInitializer loadedTypeInitializer2 = loadedTypeInitializer = auxiliaryTypes.isEmpty() ? dynamicType.getLoadedTypeInitializers().get(dynamicType.getTypeDescription()) : new InjectingInitializer(dynamicType.getTypeDescription(), auxiliaryTypes, dynamicType.getLoadedTypeInitializers(), injectorFactory.resolve());
                        if (loadedTypeInitializer.isAlive()) {
                            NexusAccessor.INSTANCE.register(dynamicType.getTypeDescription().getName(), classLoader, this.identification, loadedTypeInitializer);
                        }
                    }

                    public String toString() {
                        return "AgentBuilder.InitializationStrategy.SelfInjection.Dispatcher.Lazy{identification=" + this.identification + "}";
                    }
                }

                protected static class Split
                extends Dispatcher {
                    protected Split(int identification) {
                        super(identification);
                    }

                    @Override
                    public void register(DynamicType dynamicType, ClassLoader classLoader, Dispatcher.InjectorFactory injectorFactory) {
                        LoadedTypeInitializer loadedTypeInitializer;
                        Map<TypeDescription, byte[]> auxiliaryTypes = dynamicType.getAuxiliaryTypes();
                        if (!auxiliaryTypes.isEmpty()) {
                            TypeDescription instrumentedType = dynamicType.getTypeDescription();
                            ClassInjector classInjector = injectorFactory.resolve();
                            LinkedHashMap<TypeDescription, byte[]> independentTypes = new LinkedHashMap<TypeDescription, byte[]>(auxiliaryTypes);
                            LinkedHashMap<TypeDescription, byte[]> dependentTypes = new LinkedHashMap<TypeDescription, byte[]>(auxiliaryTypes);
                            for (TypeDescription typeDescription : auxiliaryTypes.keySet()) {
                                (typeDescription.getDeclaredAnnotations().isAnnotationPresent(AuxiliaryType.SignatureRelevant.class) ? dependentTypes : independentTypes).remove(typeDescription);
                            }
                            Map<TypeDescription, LoadedTypeInitializer> loadedTypeInitializers = dynamicType.getLoadedTypeInitializers();
                            if (!independentTypes.isEmpty()) {
                                for (Map.Entry<TypeDescription, Class<?>> entry : classInjector.inject(independentTypes).entrySet()) {
                                    loadedTypeInitializers.get(entry.getKey()).onLoad(entry.getValue());
                                }
                            }
                            HashMap<TypeDescription, LoadedTypeInitializer> hashMap = new HashMap<TypeDescription, LoadedTypeInitializer>(loadedTypeInitializers);
                            loadedTypeInitializers.keySet().removeAll(independentTypes.keySet());
                            loadedTypeInitializer = hashMap.size() > 1 ? new InjectingInitializer(instrumentedType, dependentTypes, hashMap, classInjector) : (LoadedTypeInitializer)hashMap.get(instrumentedType);
                        } else {
                            loadedTypeInitializer = dynamicType.getLoadedTypeInitializers().get(dynamicType.getTypeDescription());
                        }
                        if (loadedTypeInitializer.isAlive()) {
                            NexusAccessor.INSTANCE.register(dynamicType.getTypeDescription().getName(), classLoader, this.identification, loadedTypeInitializer);
                        }
                    }

                    public String toString() {
                        return "AgentBuilder.InitializationStrategy.SelfInjection.Dispatcher.Split{identification=" + this.identification + "}";
                    }
                }
            }
        }

        public static enum NoOp implements InitializationStrategy,
        Dispatcher
        {
            INSTANCE;


            @Override
            public Dispatcher dispatcher() {
                return this;
            }

            @Override
            public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder) {
                return builder;
            }

            @Override
            public void register(DynamicType dynamicType, ClassLoader classLoader, Dispatcher.InjectorFactory injectorFactory) {
            }

            public String toString() {
                return "AgentBuilder.InitializationStrategy.NoOp." + this.name();
            }
        }

        public static interface Dispatcher {
            public DynamicType.Builder<?> apply(DynamicType.Builder<?> var1);

            public void register(DynamicType var1, ClassLoader var2, InjectorFactory var3);

            public static interface InjectorFactory {
                public ClassInjector resolve();
            }
        }
    }

    public static interface Listener {
        public void onTransformation(TypeDescription var1, ClassLoader var2, JavaModule var3, DynamicType var4);

        public void onIgnored(TypeDescription var1, ClassLoader var2, JavaModule var3);

        public void onError(String var1, ClassLoader var2, JavaModule var3, Throwable var4);

        public void onComplete(String var1, ClassLoader var2, JavaModule var3);

        public static class Compound
        implements Listener {
            private final List<? extends Listener> listeners;

            public Compound(Listener ... listener) {
                this(Arrays.asList(listener));
            }

            public Compound(List<? extends Listener> listeners) {
                this.listeners = listeners;
            }

            @Override
            public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, DynamicType dynamicType) {
                for (Listener listener : this.listeners) {
                    listener.onTransformation(typeDescription, classLoader, module, dynamicType);
                }
            }

            @Override
            public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                for (Listener listener : this.listeners) {
                    listener.onIgnored(typeDescription, classLoader, module);
                }
            }

            @Override
            public void onError(String typeName, ClassLoader classLoader, JavaModule module, Throwable throwable) {
                for (Listener listener : this.listeners) {
                    listener.onError(typeName, classLoader, module, throwable);
                }
            }

            @Override
            public void onComplete(String typeName, ClassLoader classLoader, JavaModule module) {
                for (Listener listener : this.listeners) {
                    listener.onComplete(typeName, classLoader, module);
                }
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.listeners.equals(((Compound)other).listeners);
            }

            public int hashCode() {
                return this.listeners.hashCode();
            }

            public String toString() {
                return "AgentBuilder.Listener.Compound{listeners=" + this.listeners + '}';
            }
        }

        public static class StreamWriting
        implements Listener {
            protected static final String PREFIX = "[Byte Buddy]";
            private final PrintStream printStream;

            public StreamWriting(PrintStream printStream) {
                this.printStream = printStream;
            }

            public static Listener toSystemOut() {
                return new StreamWriting(System.out);
            }

            public static Listener toSystemError() {
                return new StreamWriting(System.err);
            }

            @Override
            public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, DynamicType dynamicType) {
                this.printStream.println("[Byte Buddy] TRANSFORM " + typeDescription.getName() + "[" + classLoader + ", " + module + "]");
            }

            @Override
            public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                this.printStream.println("[Byte Buddy] IGNORE " + typeDescription.getName() + "[" + classLoader + ", " + module + "]");
            }

            @Override
            public void onError(String typeName, ClassLoader classLoader, JavaModule module, Throwable throwable) {
                this.printStream.println("[Byte Buddy] ERROR " + typeName + "[" + classLoader + ", " + module + "]");
                throwable.printStackTrace(this.printStream);
            }

            @Override
            public void onComplete(String typeName, ClassLoader classLoader, JavaModule module) {
                this.printStream.println("[Byte Buddy] COMPLETE " + typeName + "[" + classLoader + ", " + module + "]");
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.printStream.equals(((StreamWriting)other).printStream);
            }

            public int hashCode() {
                return this.printStream.hashCode();
            }

            public String toString() {
                return "AgentBuilder.Listener.StreamWriting{printStream=" + this.printStream + '}';
            }
        }

        public static abstract class Adapter
        implements Listener {
            @Override
            public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, DynamicType dynamicType) {
            }

            @Override
            public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
            }

            @Override
            public void onError(String typeName, ClassLoader classLoader, JavaModule module, Throwable throwable) {
            }

            @Override
            public void onComplete(String typeName, ClassLoader classLoader, JavaModule module) {
            }
        }

        public static enum NoOp implements Listener
        {
            INSTANCE;


            @Override
            public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, DynamicType dynamicType) {
            }

            @Override
            public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
            }

            @Override
            public void onError(String typeName, ClassLoader classLoader, JavaModule module, Throwable throwable) {
            }

            @Override
            public void onComplete(String typeName, ClassLoader classLoader, JavaModule module) {
            }

            public String toString() {
                return "AgentBuilder.Listener.NoOp." + this.name();
            }
        }
    }

    public static interface TypeLocator {
        public TypePool typePool(ClassFileLocator var1, ClassLoader var2);

        public static abstract class WithTypePoolCache
        implements TypeLocator {
            protected final TypePool.Default.ReaderMode readerMode;

            protected WithTypePoolCache(TypePool.Default.ReaderMode readerMode) {
                this.readerMode = readerMode;
            }

            @Override
            public TypePool typePool(ClassFileLocator classFileLocator, ClassLoader classLoader) {
                return new TypePool.LazyFacade(TypePool.Default.Precomputed.withObjectType(this.locate(classLoader), classFileLocator, this.readerMode));
            }

            protected abstract TypePool.CacheProvider locate(ClassLoader var1);

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                WithTypePoolCache that = (WithTypePoolCache)object;
                return this.readerMode == that.readerMode;
            }

            public int hashCode() {
                return this.readerMode.hashCode();
            }

            public static class Simple
            extends WithTypePoolCache {
                private final ConcurrentMap<? super ClassLoader, TypePool.CacheProvider> cacheProviders;

                public Simple(ConcurrentMap<? super ClassLoader, TypePool.CacheProvider> cacheProviders) {
                    this(TypePool.Default.ReaderMode.FAST, cacheProviders);
                }

                public Simple(TypePool.Default.ReaderMode readerMode, ConcurrentMap<? super ClassLoader, TypePool.CacheProvider> cacheProviders) {
                    super(readerMode);
                    this.cacheProviders = cacheProviders;
                }

                @Override
                protected TypePool.CacheProvider locate(ClassLoader classLoader) {
                    classLoader = classLoader == null ? BootstrapClassLoaderMarker.INSTANCE : classLoader;
                    TypePool.CacheProvider cacheProvider = (TypePool.CacheProvider)this.cacheProviders.get(classLoader);
                    while (cacheProvider == null) {
                        this.cacheProviders.putIfAbsent(classLoader, new TypePool.CacheProvider.Simple());
                        cacheProvider = (TypePool.CacheProvider)this.cacheProviders.get(classLoader);
                    }
                    return cacheProvider;
                }

                @Override
                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!super.equals(object)) {
                        return false;
                    }
                    Simple simple = (Simple)object;
                    return this.cacheProviders.equals(simple.cacheProviders);
                }

                @Override
                public int hashCode() {
                    int result = super.hashCode();
                    result = 31 * result + this.cacheProviders.hashCode();
                    return result;
                }

                public String toString() {
                    return "AgentBuilder.TypeLocator.WithTypePoolCache.Simple{cacheProviders=" + this.cacheProviders + '}';
                }

                private static class BootstrapClassLoaderMarker
                extends ClassLoader {
                    protected static final ClassLoader INSTANCE = AccessController.doPrivileged(new CreationAction());

                    private BootstrapClassLoaderMarker() {
                    }

                    @Override
                    protected Class<?> loadClass(String name, boolean resolve) {
                        throw new UnsupportedOperationException("This loader is only a non-null marker and is not supposed to be used");
                    }

                    private static class CreationAction
                    implements PrivilegedAction<ClassLoader> {
                        private CreationAction() {
                        }

                        @Override
                        public ClassLoader run() {
                            return new BootstrapClassLoaderMarker();
                        }
                    }
                }
            }
        }

        public static enum ClassLoading implements TypeLocator
        {
            INSTANCE;


            @Override
            public TypePool typePool(ClassFileLocator classFileLocator, ClassLoader classLoader) {
                return new TypePool.LazyFacade(TypePool.Default.ClassLoading.of(classFileLocator, classLoader));
            }

            public String toString() {
                return "AgentBuilder.TypeLocator.ClassLoading." + this.name();
            }
        }

        public static enum Default implements TypeLocator
        {
            EXTENDED(TypePool.Default.ReaderMode.EXTENDED),
            FAST(TypePool.Default.ReaderMode.FAST);

            private final TypePool.Default.ReaderMode readerMode;

            private Default(TypePool.Default.ReaderMode readerMode) {
                this.readerMode = readerMode;
            }

            @Override
            public TypePool typePool(ClassFileLocator classFileLocator, ClassLoader classLoader) {
                return new TypePool.LazyFacade(TypePool.Default.Precomputed.withObjectType(new TypePool.CacheProvider.Simple(), classFileLocator, this.readerMode));
            }

            public String toString() {
                return "AgentBuilder.TypeLocator.Default." + this.name();
            }
        }
    }

    public static interface Transformer {
        public DynamicType.Builder<?> transform(DynamicType.Builder<?> var1, TypeDescription var2, ClassLoader var3);

        public static class Compound
        implements Transformer {
            private final Transformer[] transformer;

            public Compound(Transformer ... transformer) {
                this.transformer = transformer;
            }

            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader) {
                for (Transformer transformer : this.transformer) {
                    builder = transformer.transform(builder, typeDescription, classLoader);
                }
                return builder;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.transformer, ((Compound)other).transformer);
            }

            public int hashCode() {
                return Arrays.hashCode(this.transformer);
            }

            public String toString() {
                return "AgentBuilder.Transformer.Compound{transformer=" + Arrays.toString(this.transformer) + '}';
            }
        }

        public static enum NoOp implements Transformer
        {
            INSTANCE;


            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader) {
                return builder;
            }

            public String toString() {
                return "AgentBuilder.Transformer.NoOp." + this.name();
            }
        }
    }

    public static interface TypeStrategy {
        public DynamicType.Builder<?> builder(TypeDescription var1, ByteBuddy var2, ClassFileLocator var3, MethodNameTransformer var4);

        public static enum Default implements TypeStrategy
        {
            REBASE{

                @Override
                public DynamicType.Builder<?> builder(TypeDescription typeDescription, ByteBuddy byteBuddy, ClassFileLocator classFileLocator, MethodNameTransformer methodNameTransformer) {
                    return byteBuddy.rebase(typeDescription, classFileLocator, methodNameTransformer);
                }
            }
            ,
            REDEFINE{

                @Override
                public DynamicType.Builder<?> builder(TypeDescription typeDescription, ByteBuddy byteBuddy, ClassFileLocator classFileLocator, MethodNameTransformer methodNameTransformer) {
                    return byteBuddy.redefine(typeDescription, classFileLocator);
                }
            }
            ,
            REDEFINE_DECLARED_ONLY{

                @Override
                public DynamicType.Builder<?> builder(TypeDescription typeDescription, ByteBuddy byteBuddy, ClassFileLocator classFileLocator, MethodNameTransformer methodNameTransformer) {
                    return byteBuddy.redefine(typeDescription, classFileLocator).ignoreAlso(ElementMatchers.not(ElementMatchers.isDeclaredBy(typeDescription)));
                }
            };


            public String toString() {
                return "AgentBuilder.TypeStrategy.Default." + this.name();
            }
        }
    }

    public static interface RawMatcher {
        public boolean matches(TypeDescription var1, ClassLoader var2, JavaModule var3, Class<?> var4, ProtectionDomain var5);

        public static class ForElementMatchers
        implements RawMatcher {
            private final ElementMatcher<? super TypeDescription> typeMatcher;
            private final ElementMatcher<? super ClassLoader> classLoaderMatcher;
            private final ElementMatcher<? super JavaModule> moduleMatcher;

            public ForElementMatchers(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher, ElementMatcher<? super JavaModule> moduleMatcher) {
                this.typeMatcher = typeMatcher;
                this.classLoaderMatcher = classLoaderMatcher;
                this.moduleMatcher = moduleMatcher;
            }

            @Override
            public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                return this.moduleMatcher.matches(module) && this.classLoaderMatcher.matches(classLoader) && this.typeMatcher.matches(typeDescription);
            }

            protected RawMatcher or(RawMatcher other) {
                return new Conjunction(this, other);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.classLoaderMatcher.equals(((ForElementMatchers)other).classLoaderMatcher) && this.moduleMatcher.equals(((ForElementMatchers)other).moduleMatcher) && this.typeMatcher.equals(((ForElementMatchers)other).typeMatcher);
            }

            public int hashCode() {
                int result = this.typeMatcher.hashCode();
                result = 31 * result + this.classLoaderMatcher.hashCode();
                result = 31 * result + this.moduleMatcher.hashCode();
                return result;
            }

            public String toString() {
                return "AgentBuilder.RawMatcher.ForElementMatchers{typeMatcher=" + this.typeMatcher + ", classLoaderMatcher=" + this.classLoaderMatcher + ", moduleMatcher=" + this.moduleMatcher + '}';
            }
        }

        public static class Disjunction
        implements RawMatcher {
            private final RawMatcher left;
            private final RawMatcher right;

            protected Disjunction(RawMatcher left, RawMatcher right) {
                this.left = left;
                this.right = right;
            }

            @Override
            public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                return this.left.matches(typeDescription, classLoader, module, classBeingRedefined, protectionDomain) || this.right.matches(typeDescription, classLoader, module, classBeingRedefined, protectionDomain);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Disjunction that = (Disjunction)object;
                return this.left.equals(that.left) && this.right.equals(that.right);
            }

            public int hashCode() {
                int result = this.left.hashCode();
                result = 31 * result + this.right.hashCode();
                return result;
            }

            public String toString() {
                return "AgentBuilder.RawMatcher.Disjunction{left=" + this.left + ", right=" + this.right + '}';
            }
        }

        public static class Conjunction
        implements RawMatcher {
            private final RawMatcher left;
            private final RawMatcher right;

            protected Conjunction(RawMatcher left, RawMatcher right) {
                this.left = left;
                this.right = right;
            }

            @Override
            public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                return this.left.matches(typeDescription, classLoader, module, classBeingRedefined, protectionDomain) && this.right.matches(typeDescription, classLoader, module, classBeingRedefined, protectionDomain);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Conjunction that = (Conjunction)object;
                return this.left.equals(that.left) && this.right.equals(that.right);
            }

            public int hashCode() {
                int result = this.left.hashCode();
                result = 31 * result + this.right.hashCode();
                return result;
            }

            public String toString() {
                return "AgentBuilder.RawMatcher.Conjunction{left=" + this.left + ", right=" + this.right + '}';
            }
        }
    }

    public static interface Identified {
        public Extendable transform(Transformer var1);

        public static interface Extendable
        extends AgentBuilder,
        Identified {
            public AgentBuilder asDecorator();
        }

        public static interface Narrowable
        extends Matchable<Narrowable>,
        Identified {
        }
    }

    public static interface Ignored
    extends Matchable<Ignored>,
    AgentBuilder {
    }

    public static interface Matchable<T extends Matchable<T>> {
        public T and(ElementMatcher<? super TypeDescription> var1);

        public T and(ElementMatcher<? super TypeDescription> var1, ElementMatcher<? super ClassLoader> var2);

        public T and(ElementMatcher<? super TypeDescription> var1, ElementMatcher<? super ClassLoader> var2, ElementMatcher<? super JavaModule> var3);

        public T and(RawMatcher var1);

        public T or(ElementMatcher<? super TypeDescription> var1);

        public T or(ElementMatcher<? super TypeDescription> var1, ElementMatcher<? super ClassLoader> var2);

        public T or(ElementMatcher<? super TypeDescription> var1, ElementMatcher<? super ClassLoader> var2, ElementMatcher<? super JavaModule> var3);

        public T or(RawMatcher var1);

        public static abstract class AbstractBase<S extends Matchable<S>>
        implements Matchable<S> {
            @Override
            public S and(ElementMatcher<? super TypeDescription> typeMatcher) {
                return this.and(typeMatcher, ElementMatchers.any());
            }

            @Override
            public S and(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher) {
                return this.and(typeMatcher, classLoaderMatcher, ElementMatchers.any());
            }

            @Override
            public S and(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher, ElementMatcher<? super JavaModule> moduleMatcher) {
                return (S)this.and(new RawMatcher.ForElementMatchers(typeMatcher, classLoaderMatcher, moduleMatcher));
            }

            @Override
            public S or(ElementMatcher<? super TypeDescription> typeMatcher) {
                return this.or(typeMatcher, ElementMatchers.any());
            }

            @Override
            public S or(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher) {
                return this.or(typeMatcher, classLoaderMatcher, ElementMatchers.any());
            }

            @Override
            public S or(ElementMatcher<? super TypeDescription> typeMatcher, ElementMatcher<? super ClassLoader> classLoaderMatcher, ElementMatcher<? super JavaModule> moduleMatcher) {
                return (S)this.or(new RawMatcher.ForElementMatchers(typeMatcher, classLoaderMatcher, moduleMatcher));
            }
        }
    }
}

