/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.utility.JavaType;

public class JavaModule
implements NamedElement.WithOptionalName,
PrivilegedAction<ClassLoader> {
    public static final JavaModule UNSUPPORTED;
    private static final Dispatcher DISPATCHER;
    private final Object module;

    protected JavaModule(Object module) {
        this.module = module;
    }

    public static JavaModule ofType(Class<?> type) {
        return DISPATCHER.moduleOf(type);
    }

    public static JavaModule of(Object module) {
        if (!JavaType.MODULE.getTypeStub().isInstance(module)) {
            throw new IllegalArgumentException("Not a Java module: " + module);
        }
        return new JavaModule(module);
    }

    @Override
    public boolean isNamed() {
        return DISPATCHER.isNamed(this.module);
    }

    @Override
    public String getActualName() {
        return DISPATCHER.getName(this.module);
    }

    public ClassLoader getClassLoader(AccessControlContext accessControlContext) {
        return AccessController.doPrivileged(this, accessControlContext);
    }

    public Object unwrap() {
        return this.module;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JavaModule that = (JavaModule)object;
        return this.module.equals(that.module);
    }

    public int hashCode() {
        return this.module.hashCode();
    }

    public String toString() {
        return this.module.toString();
    }

    @Override
    public ClassLoader run() {
        return DISPATCHER.getClassLoader(this.module);
    }

    static {
        Dispatcher dispatcher;
        UNSUPPORTED = null;
        try {
            Class<?> module = Class.forName("java.lang.reflect.Module");
            dispatcher = new Dispatcher.Enabled(Class.class.getDeclaredMethod("getModule", new Class[0]), module.getDeclaredMethod("getClassLoader", new Class[0]), module.getDeclaredMethod("isNamed", new Class[0]), module.getDeclaredMethod("getName", new Class[0]));
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception ignored) {
            dispatcher = Dispatcher.Disabled.INSTANCE;
        }
        DISPATCHER = dispatcher;
    }

    protected static interface Dispatcher {
        public JavaModule moduleOf(Class<?> var1);

        public boolean isNamed(Object var1);

        public String getName(Object var1);

        public ClassLoader getClassLoader(Object var1);

        public static enum Disabled implements Dispatcher
        {
            INSTANCE;


            @Override
            public JavaModule moduleOf(Class<?> type) {
                return UNSUPPORTED;
            }

            @Override
            public ClassLoader getClassLoader(Object module) {
                throw new IllegalStateException("Current VM does not support modules");
            }

            @Override
            public boolean isNamed(Object module) {
                throw new IllegalStateException("Current VM does not support modules");
            }

            @Override
            public String getName(Object module) {
                throw new IllegalStateException("Current VM does not support modules");
            }

            public String toString() {
                return "JavaModule.Dispatcher.Disabled." + this.name();
            }
        }

        public static class Enabled
        implements Dispatcher {
            private final Method getModule;
            private final Method getClassLoader;
            private final Method isNamed;
            private final Method getName;

            protected Enabled(Method getModule, Method getClassLoader, Method isNamed, Method getName) {
                this.getModule = getModule;
                this.getClassLoader = getClassLoader;
                this.isNamed = isNamed;
                this.getName = getName;
            }

            @Override
            public JavaModule moduleOf(Class<?> type) {
                try {
                    return new JavaModule(this.getModule.invoke(type, new Object[0]));
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.getModule, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.getModule, exception.getCause());
                }
            }

            @Override
            public ClassLoader getClassLoader(Object module) {
                try {
                    return (ClassLoader)this.getClassLoader.invoke(module, new Object[0]);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.getClassLoader, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.getClassLoader, exception.getCause());
                }
            }

            @Override
            public boolean isNamed(Object module) {
                try {
                    return (Boolean)this.isNamed.invoke(module, new Object[0]);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.isNamed, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.isNamed, exception.getCause());
                }
            }

            @Override
            public String getName(Object module) {
                try {
                    return (String)this.getName.invoke(module, new Object[0]);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.getName, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.getName, exception.getCause());
                }
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Enabled enabled = (Enabled)object;
                if (!this.getModule.equals(enabled.getModule)) {
                    return false;
                }
                if (!this.getClassLoader.equals(enabled.getClassLoader)) {
                    return false;
                }
                if (!this.isNamed.equals(enabled.isNamed)) {
                    return false;
                }
                return this.getName.equals(enabled.getName);
            }

            public int hashCode() {
                int result = this.getModule.hashCode();
                result = 31 * result + this.getClassLoader.hashCode();
                result = 31 * result + this.isNamed.hashCode();
                result = 31 * result + this.getName.hashCode();
                return result;
            }

            public String toString() {
                return "JavaModule.Dispatcher.Enabled{getModule=" + this.getModule + ", getClassLoader=" + this.getClassLoader + ", isNamed=" + this.isNamed + ", getName=" + this.getName + '}';
            }
        }
    }
}

