/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.annotation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.annotation.AnnotationValue;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.PropertyDispatcher;
import net.bytebuddy.utility.privilege.SetAccessibleAction;

public interface AnnotationDescription {
    public static final Loadable<?> UNDEFINED = null;

    public AnnotationValue<?, ?> getValue(MethodDescription.InDefinedShape var1);

    public TypeDescription getAnnotationType();

    public <T extends Annotation> Loadable<T> prepare(Class<T> var1);

    public RetentionPolicy getRetention();

    public Set<ElementType> getElementTypes();

    public boolean isInherited();

    public boolean isDocumented();

    public static class Builder {
        private final TypeDescription annotationType;
        private final Map<String, AnnotationValue<?, ?>> annotationValues;

        protected Builder(TypeDescription annotationType, Map<String, AnnotationValue<?, ?>> annotationValues) {
            this.annotationType = annotationType;
            this.annotationValues = annotationValues;
        }

        public static Builder ofType(Class<? extends Annotation> annotationType) {
            return Builder.ofType(new TypeDescription.ForLoadedType(annotationType));
        }

        public static Builder ofType(TypeDescription annotationType) {
            if (!annotationType.isAnnotation()) {
                throw new IllegalArgumentException("Not an annotation type: " + annotationType);
            }
            return new Builder(annotationType, Collections.<String, AnnotationValue<?, ?>>emptyMap());
        }

        public Builder define(String property, AnnotationValue<?, ?> value) {
            MethodList methodDescriptions = (MethodList)this.annotationType.getDeclaredMethods().filter(ElementMatchers.named(property));
            if (methodDescriptions.isEmpty()) {
                throw new IllegalArgumentException(this.annotationType + " does not define a property named " + property);
            }
            if (!((MethodDescription)methodDescriptions.getOnly()).getReturnType().asErasure().isAnnotationValue(value.resolve())) {
                throw new IllegalArgumentException(value + " cannot be assigned to " + property);
            }
            HashMap annotationValues = new HashMap();
            annotationValues.putAll(this.annotationValues);
            if (annotationValues.put(((MethodDescription)methodDescriptions.getOnly()).getName(), value) != null) {
                throw new IllegalArgumentException("Property already defined: " + property);
            }
            return new Builder(this.annotationType, annotationValues);
        }

        public Builder define(String property, Enum<?> value) {
            return this.define(property, new EnumerationDescription.ForLoadedEnumeration(value));
        }

        public Builder define(String property, TypeDescription enumerationType, String value) {
            return this.define(property, new EnumerationDescription.Latent(enumerationType, value));
        }

        public Builder define(String property, EnumerationDescription value) {
            return this.define(property, AnnotationValue.ForEnumeration.of(value));
        }

        public Builder define(String property, Annotation annotation) {
            return this.define(property, new ForLoadedAnnotation<Annotation>(annotation));
        }

        public Builder define(String property, AnnotationDescription annotationDescription) {
            return this.define(property, new AnnotationValue.ForAnnotation(annotationDescription));
        }

        public Builder define(String property, Class<?> type) {
            return this.define(property, new TypeDescription.ForLoadedType(type));
        }

        public Builder define(String property, TypeDescription typeDescription) {
            return this.define(property, AnnotationValue.ForType.of(typeDescription));
        }

        public <T extends Enum<?>> Builder defineEnumerationArray(String property, Class<T> enumerationType, T ... value) {
            EnumerationDescription[] enumerationDescription = new EnumerationDescription[value.length];
            int index = 0;
            for (T aValue : value) {
                enumerationDescription[index++] = new EnumerationDescription.ForLoadedEnumeration((Enum<?>)aValue);
            }
            return this.defineEnumerationArray(property, (TypeDescription)new TypeDescription.ForLoadedType(enumerationType), enumerationDescription);
        }

        public Builder defineEnumerationArray(String property, TypeDescription enumerationType, String ... value) {
            if (!enumerationType.isEnum()) {
                throw new IllegalArgumentException("Not an enumeration type: " + enumerationType);
            }
            EnumerationDescription[] enumerationDescription = new EnumerationDescription[value.length];
            for (int i = 0; i < value.length; ++i) {
                enumerationDescription[i] = new EnumerationDescription.Latent(enumerationType, value[i]);
            }
            return this.defineEnumerationArray(property, enumerationType, enumerationDescription);
        }

        public Builder defineEnumerationArray(String property, TypeDescription enumerationType, EnumerationDescription ... value) {
            return this.define(property, AnnotationValue.ForComplexArray.of(enumerationType, value));
        }

        public <T extends Annotation> Builder defineAnnotationArray(String property, Class<T> annotationType, T ... annotation) {
            return this.defineAnnotationArray(property, new TypeDescription.ForLoadedType(annotationType), new AnnotationList.ForLoadedAnnotations((Annotation[])annotation).toArray(new AnnotationDescription[annotation.length]));
        }

        public Builder defineAnnotationArray(String property, TypeDescription annotationType, AnnotationDescription ... annotationDescription) {
            return this.define(property, AnnotationValue.ForComplexArray.of(annotationType, annotationDescription));
        }

        public Builder defineTypeArray(String property, Class<?> ... type) {
            return this.defineTypeArray(property, new TypeList.ForLoadedTypes(type).toArray(new TypeDescription[type.length]));
        }

        public Builder defineTypeArray(String property, TypeDescription ... typeDescription) {
            return this.define(property, AnnotationValue.ForComplexArray.of(typeDescription));
        }

        public Builder define(String property, boolean value) {
            return this.define(property, new AnnotationValue.ForConstant<Boolean>(value));
        }

        public Builder define(String property, byte value) {
            return this.define(property, new AnnotationValue.ForConstant<Byte>(value));
        }

        public Builder define(String property, char value) {
            return this.define(property, new AnnotationValue.ForConstant<Character>(Character.valueOf(value)));
        }

        public Builder define(String property, short value) {
            return this.define(property, new AnnotationValue.ForConstant<Short>(value));
        }

        public Builder define(String property, int value) {
            return this.define(property, new AnnotationValue.ForConstant<Integer>(value));
        }

        public Builder define(String property, long value) {
            return this.define(property, new AnnotationValue.ForConstant<Long>(value));
        }

        public Builder define(String property, float value) {
            return this.define(property, new AnnotationValue.ForConstant<Float>(Float.valueOf(value)));
        }

        public Builder define(String property, double value) {
            return this.define(property, new AnnotationValue.ForConstant<Double>(value));
        }

        public Builder define(String property, String value) {
            return this.define(property, new AnnotationValue.ForConstant<String>(value));
        }

        public Builder defineArray(String property, boolean ... value) {
            return this.define(property, new AnnotationValue.ForConstant<boolean[]>(value));
        }

        public Builder defineArray(String property, byte ... value) {
            return this.define(property, new AnnotationValue.ForConstant<byte[]>(value));
        }

        public Builder defineArray(String property, char ... value) {
            return this.define(property, new AnnotationValue.ForConstant<char[]>(value));
        }

        public Builder defineArray(String property, short ... value) {
            return this.define(property, new AnnotationValue.ForConstant<short[]>(value));
        }

        public Builder defineArray(String property, int ... value) {
            return this.define(property, new AnnotationValue.ForConstant<int[]>(value));
        }

        public Builder defineArray(String property, long ... value) {
            return this.define(property, new AnnotationValue.ForConstant<long[]>(value));
        }

        public Builder defineArray(String property, float ... value) {
            return this.define(property, new AnnotationValue.ForConstant<float[]>(value));
        }

        public Builder defineArray(String property, double ... value) {
            return this.define(property, new AnnotationValue.ForConstant<double[]>(value));
        }

        public Builder defineArray(String property, String ... value) {
            return this.define(property, new AnnotationValue.ForConstant<String[]>(value));
        }

        public AnnotationDescription build() {
            for (MethodDescription methodDescription : this.annotationType.getDeclaredMethods()) {
                if (this.annotationValues.get(methodDescription.getName()) != null || methodDescription.getDefaultValue() != null) continue;
                throw new IllegalStateException("No value or default value defined for " + methodDescription.getName());
            }
            return new Latent(this.annotationType, this.annotationValues);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.annotationType.equals(((Builder)other).annotationType) && this.annotationValues.equals(((Builder)other).annotationValues);
        }

        public int hashCode() {
            int result = this.annotationType.hashCode();
            result = 31 * result + this.annotationValues.hashCode();
            return result;
        }

        public String toString() {
            return "AnnotationDescription.Builder{annotationType=" + this.annotationType + ", annotationValues=" + this.annotationValues + '}';
        }
    }

    public static class Latent
    extends AbstractBase {
        private final TypeDescription annotationType;
        private final Map<String, AnnotationValue<?, ?>> annotationValues;

        protected Latent(TypeDescription annotationType, Map<String, AnnotationValue<?, ?>> annotationValues) {
            this.annotationType = annotationType;
            this.annotationValues = annotationValues;
        }

        @Override
        public AnnotationValue<?, ?> getValue(MethodDescription.InDefinedShape property) {
            AnnotationValue<?, ?> value = this.annotationValues.get(property.getName());
            if (value != null) {
                return value;
            }
            AnnotationValue<?, ?> defaultValue = property.getDefaultValue();
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new IllegalArgumentException("No value defined for: " + property);
        }

        @Override
        public TypeDescription getAnnotationType() {
            return this.annotationType;
        }

        public <T extends Annotation> Loadable<T> prepare(Class<T> annotationType) {
            if (!this.annotationType.represents(annotationType)) {
                throw new IllegalArgumentException(annotationType + " does not represent " + this.annotationType);
            }
            return new Loadable<T>(annotationType);
        }

        protected class Loadable<S extends Annotation>
        extends AbstractBase.ForPrepared<S> {
            private final Class<S> annotationType;

            protected Loadable(Class<S> annotationType) {
                this.annotationType = annotationType;
            }

            @Override
            public S load() throws ClassNotFoundException {
                return AnnotationInvocationHandler.of(this.annotationType.getClassLoader(), this.annotationType, Latent.this.annotationValues);
            }

            @Override
            public AnnotationValue<?, ?> getValue(MethodDescription.InDefinedShape property) {
                return Latent.this.getValue(property);
            }

            @Override
            public TypeDescription getAnnotationType() {
                return new TypeDescription.ForLoadedType(this.annotationType);
            }

            @Override
            public <T extends Annotation> net.bytebuddy.description.annotation.AnnotationDescription$Loadable<T> prepare(Class<T> annotationType) {
                return Latent.this.prepare((Class)annotationType);
            }
        }
    }

    public static class ForLoadedAnnotation<S extends Annotation>
    extends AbstractBase.ForPrepared<S> {
        private final S annotation;
        private final Class<S> annotationType;

        protected ForLoadedAnnotation(S annotation) {
            this((Annotation)annotation, annotation.annotationType());
        }

        private ForLoadedAnnotation(S annotation, Class<S> annotationType) {
            this.annotation = annotation;
            this.annotationType = annotationType;
        }

        public static <U extends Annotation> Loadable<U> of(U annotation) {
            return new ForLoadedAnnotation<U>(annotation);
        }

        @Override
        public S load() throws ClassNotFoundException {
            return this.annotationType == this.annotation.annotationType() ? this.annotation : AnnotationInvocationHandler.of(this.annotationType.getClassLoader(), this.annotationType, ForLoadedAnnotation.asValue(this.annotation));
        }

        private static Map<String, AnnotationValue<?, ?>> asValue(Annotation annotation) {
            HashMap annotationValues = new HashMap();
            for (Method property : annotation.annotationType().getDeclaredMethods()) {
                try {
                    annotationValues.put(property.getName(), ForLoadedAnnotation.asValue(property.invoke((Object)annotation, new Object[0]), property.getReturnType()));
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot read " + property, exception.getCause());
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + property, exception);
                }
            }
            return annotationValues;
        }

        public static AnnotationValue<?, ?> asValue(Object value, Class<?> type) {
            if (Enum.class.isAssignableFrom(type)) {
                return AnnotationValue.ForEnumeration.of(new EnumerationDescription.ForLoadedEnumeration((Enum)value));
            }
            if (Enum[].class.isAssignableFrom(type)) {
                Enum[] element = (Enum[])value;
                EnumerationDescription[] enumerationDescription = new EnumerationDescription[element.length];
                int index = 0;
                for (Enum anElement : element) {
                    enumerationDescription[index++] = new EnumerationDescription.ForLoadedEnumeration(anElement);
                }
                return AnnotationValue.ForComplexArray.of((TypeDescription)new TypeDescription.ForLoadedType(type.getComponentType()), enumerationDescription);
            }
            if (Annotation.class.isAssignableFrom(type)) {
                return AnnotationValue.ForAnnotation.of(new TypeDescription.ForLoadedType(type), ForLoadedAnnotation.asValue((Annotation)value));
            }
            if (Annotation[].class.isAssignableFrom(type)) {
                Annotation[] element = (Annotation[])value;
                AnnotationDescription[] annotationDescription = new AnnotationDescription[element.length];
                int index = 0;
                for (Annotation anElement : element) {
                    annotationDescription[index++] = new Latent(new TypeDescription.ForLoadedType(type.getComponentType()), ForLoadedAnnotation.asValue(anElement));
                }
                return AnnotationValue.ForComplexArray.of((TypeDescription)new TypeDescription.ForLoadedType(type.getComponentType()), annotationDescription);
            }
            if (Class.class.isAssignableFrom(type)) {
                return AnnotationValue.ForType.of(new TypeDescription.ForLoadedType((Class)value));
            }
            if (Class[].class.isAssignableFrom(type)) {
                Class[] element = (Class[])value;
                TypeDescription[] typeDescription = new TypeDescription[element.length];
                int index = 0;
                for (Class anElement : element) {
                    typeDescription[index++] = new TypeDescription.ForLoadedType(anElement);
                }
                return AnnotationValue.ForComplexArray.of(typeDescription);
            }
            return new AnnotationValue.ForConstant<Object>(value);
        }

        @Override
        @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should always be wrapped for clarity")
        public AnnotationValue<?, ?> getValue(MethodDescription.InDefinedShape property) {
            if (!property.getDeclaringType().represents(this.annotation.annotationType())) {
                throw new IllegalArgumentException(property + " does not represent " + this.annotation.annotationType());
            }
            try {
                Method method;
                boolean accessible = property.getDeclaringType().isPublic();
                Method method2 = method = property instanceof MethodDescription.ForLoadedMethod ? ((MethodDescription.ForLoadedMethod)property).getLoadedMethod() : null;
                if (method == null || method.getDeclaringClass() != this.annotation.annotationType() || !accessible && !method.isAccessible()) {
                    method = this.annotation.annotationType().getDeclaredMethod(property.getName(), new Class[0]);
                    if (!accessible) {
                        AccessController.doPrivileged(new SetAccessibleAction<Method>(method));
                    }
                }
                return ForLoadedAnnotation.asValue(method.invoke(this.annotation, new Object[0]), method.getReturnType());
            }
            catch (Exception exception) {
                throw new IllegalStateException("Cannot access annotation property " + property, exception.getCause());
            }
        }

        @Override
        public <T extends Annotation> Loadable<T> prepare(Class<T> annotationType) {
            if (!this.annotation.annotationType().getName().equals(annotationType.getName())) {
                throw new IllegalArgumentException(annotationType + " does not represent " + this.annotation.annotationType());
            }
            return annotationType == this.annotation.annotationType() ? this : new ForLoadedAnnotation<S>(this.annotation, annotationType);
        }

        @Override
        public TypeDescription getAnnotationType() {
            return new TypeDescription.ForLoadedType(this.annotation.annotationType());
        }
    }

    public static abstract class AbstractBase
    implements AnnotationDescription {
        private static final ElementType[] DEFAULT_TARGET = new ElementType[]{ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.FIELD, ElementType.LOCAL_VARIABLE, ElementType.METHOD, ElementType.PACKAGE, ElementType.PARAMETER, ElementType.TYPE};

        @Override
        public RetentionPolicy getRetention() {
            Loadable<Retention> retention = this.getAnnotationType().getDeclaredAnnotations().ofType(Retention.class);
            return retention == null ? RetentionPolicy.CLASS : retention.loadSilent().value();
        }

        @Override
        public Set<ElementType> getElementTypes() {
            Loadable<Target> target = this.getAnnotationType().getDeclaredAnnotations().ofType(Target.class);
            return new HashSet<ElementType>(Arrays.asList(target == null ? DEFAULT_TARGET : target.loadSilent().value()));
        }

        @Override
        public boolean isInherited() {
            return this.getAnnotationType().getDeclaredAnnotations().isAnnotationPresent(Inherited.class);
        }

        @Override
        public boolean isDocumented() {
            return this.getAnnotationType().getDeclaredAnnotations().isAnnotationPresent(Documented.class);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof AnnotationDescription)) {
                return false;
            }
            AnnotationDescription annotationDescription = (AnnotationDescription)other;
            if (!annotationDescription.getAnnotationType().equals(this.getAnnotationType())) {
                return false;
            }
            for (MethodDescription.InDefinedShape methodDescription : this.getAnnotationType().getDeclaredMethods()) {
                Object value = this.getValue(methodDescription).resolve();
                if (PropertyDispatcher.of(value.getClass()).equals(value, annotationDescription.getValue(methodDescription).resolve())) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hashCode = 0;
            for (MethodDescription.InDefinedShape methodDescription : this.getAnnotationType().getDeclaredMethods()) {
                Object value = this.getValue(methodDescription).resolve();
                hashCode += 31 * PropertyDispatcher.of(value.getClass()).hashCode(value);
            }
            return hashCode;
        }

        public String toString() {
            StringBuilder toString = new StringBuilder();
            toString.append('@');
            toString.append(this.getAnnotationType().getName());
            toString.append('(');
            boolean firstMember = true;
            for (MethodDescription.InDefinedShape methodDescription : this.getAnnotationType().getDeclaredMethods()) {
                if (firstMember) {
                    firstMember = false;
                } else {
                    toString.append(", ");
                }
                toString.append(methodDescription.getName());
                toString.append('=');
                Object value = this.getValue(methodDescription).resolve();
                toString.append(PropertyDispatcher.of(value.getClass()).toString(value));
            }
            toString.append(')');
            return toString.toString();
        }

        public static abstract class ForPrepared<S extends Annotation>
        extends AbstractBase
        implements Loadable<S> {
            @Override
            public S loadSilent() {
                try {
                    return this.load();
                }
                catch (ClassNotFoundException exception) {
                    throw new IllegalStateException("Could not load annotation type or referenced type", exception);
                }
            }
        }
    }

    public static class AnnotationInvocationHandler<T extends Annotation>
    implements InvocationHandler {
        private static final String HASH_CODE = "hashCode";
        private static final String EQUALS = "equals";
        private static final String TO_STRING = "toString";
        private final Class<? extends Annotation> annotationType;
        private final LinkedHashMap<Method, AnnotationValue.Loaded<?>> values;

        protected AnnotationInvocationHandler(Class<T> annotationType, LinkedHashMap<Method, AnnotationValue.Loaded<?>> values) {
            this.annotationType = annotationType;
            this.values = values;
        }

        public static <S extends Annotation> S of(ClassLoader classLoader, Class<S> annotationType, Map<String, AnnotationValue<?, ?>> values) throws ClassNotFoundException {
            Method[] declaredMethod = annotationType.getDeclaredMethods();
            LinkedHashMap loadedValues = new LinkedHashMap();
            Method[] methodArray = declaredMethod;
            int n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                Method method;
                AnnotationValue<?, ?> annotationValue = values.get((method = methodArray[i]).getName());
                loadedValues.put(method, annotationValue == null ? DefaultValue.of(method) : annotationValue.load(classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader));
            }
            return (S)((Annotation)Proxy.newProxyInstance(classLoader, new Class[]{annotationType}, new AnnotationInvocationHandler<S>(annotationType, loadedValues)));
        }

        private static Class<?> asWrapper(Class<?> type) {
            if (type.isPrimitive()) {
                if (type == Boolean.TYPE) {
                    return Boolean.class;
                }
                if (type == Byte.TYPE) {
                    return Byte.class;
                }
                if (type == Short.TYPE) {
                    return Short.class;
                }
                if (type == Character.TYPE) {
                    return Character.class;
                }
                if (type == Integer.TYPE) {
                    return Integer.class;
                }
                if (type == Long.TYPE) {
                    return Long.class;
                }
                if (type == Float.TYPE) {
                    return Float.class;
                }
                if (type == Double.TYPE) {
                    return Double.class;
                }
            }
            return type;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] argument) {
            if (method.getDeclaringClass() != this.annotationType) {
                if (method.getName().equals(HASH_CODE)) {
                    return this.hashCodeRepresentation();
                }
                if (method.getName().equals(EQUALS) && method.getParameterTypes().length == 1) {
                    return this.equalsRepresentation(proxy, argument[0]);
                }
                if (method.getName().equals(TO_STRING)) {
                    return this.toStringRepresentation();
                }
                return this.annotationType;
            }
            Object value = this.values.get(method).resolve();
            if (!AnnotationInvocationHandler.asWrapper(method.getReturnType()).isAssignableFrom(value.getClass())) {
                throw new AnnotationTypeMismatchException(method, value.getClass().toString());
            }
            return value;
        }

        protected String toStringRepresentation() {
            StringBuilder toString = new StringBuilder();
            toString.append('@');
            toString.append(this.annotationType.getName());
            toString.append('(');
            boolean firstMember = true;
            for (Map.Entry<Method, AnnotationValue.Loaded<?>> entry : this.values.entrySet()) {
                if (!entry.getValue().getState().isDefined()) continue;
                if (firstMember) {
                    firstMember = false;
                } else {
                    toString.append(", ");
                }
                toString.append(entry.getKey().getName()).append('=').append(entry.getValue().toString());
            }
            toString.append(')');
            return toString.toString();
        }

        private int hashCodeRepresentation() {
            int hashCode = 0;
            for (Map.Entry<Method, AnnotationValue.Loaded<?>> entry : this.values.entrySet()) {
                if (!entry.getValue().getState().isDefined()) continue;
                hashCode += 127 * entry.getKey().getName().hashCode() ^ entry.getValue().hashCode();
            }
            return hashCode;
        }

        private boolean equalsRepresentation(Object self, Object other) {
            Object invocationHandler;
            if (self == other) {
                return true;
            }
            if (!this.annotationType.isInstance(other)) {
                return false;
            }
            if (Proxy.isProxyClass(other.getClass()) && (invocationHandler = Proxy.getInvocationHandler(other)) instanceof AnnotationInvocationHandler) {
                return invocationHandler.equals(this);
            }
            try {
                for (Map.Entry entry : this.values.entrySet()) {
                    if (((AnnotationValue.Loaded)entry.getValue()).getState().isResolved()) {
                        try {
                            if (PropertyDispatcher.of(((Method)entry.getKey()).getReturnType()).equals(((AnnotationValue.Loaded)entry.getValue()).resolve(), ((Method)entry.getKey()).invoke(other, new Object[0]))) continue;
                            return false;
                        }
                        catch (RuntimeException exception) {
                            return false;
                        }
                    }
                    return false;
                }
            }
            catch (InvocationTargetException ignored) {
                return false;
            }
            catch (IllegalAccessException exception) {
                throw new AssertionError((Object)exception);
            }
            return true;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnnotationInvocationHandler)) {
                return false;
            }
            AnnotationInvocationHandler that = (AnnotationInvocationHandler)other;
            if (!this.annotationType.equals(that.annotationType)) {
                return false;
            }
            for (Map.Entry<Method, AnnotationValue.Loaded<?>> entry : this.values.entrySet()) {
                AnnotationValue.Loaded<?> value = that.values.get(entry.getKey());
                if (PropertyDispatcher.of(value.getClass()).equals(value, entry.getValue())) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = this.annotationType.hashCode();
            result = 31 * result + this.values.hashCode();
            for (Map.Entry<Method, AnnotationValue.Loaded<?>> entry : this.values.entrySet()) {
                result = 31 * result + PropertyDispatcher.of(entry.getValue().getClass()).hashCode(entry.getValue());
            }
            return result;
        }

        public String toString() {
            return "TypePool.LazyTypeDescription.AnnotationInvocationHandler{annotationType=" + this.annotationType + ", values=" + this.values + '}';
        }

        private static class Missing
        extends AnnotationValue.Loaded.AbstractBase<Void> {
            private final Class<? extends Annotation> annotationType;
            private final String property;

            private Missing(Class<? extends Annotation> annotationType, String property) {
                this.annotationType = annotationType;
                this.property = property;
            }

            @Override
            public AnnotationValue.Loaded.State getState() {
                return AnnotationValue.Loaded.State.NON_DEFINED;
            }

            @Override
            public Void resolve() {
                throw new IncompleteAnnotationException(this.annotationType, this.property);
            }
        }

        protected static class DefaultValue
        extends AnnotationValue.Loaded.AbstractBase<Object> {
            private final Object defaultValue;
            private final PropertyDispatcher propertyDispatcher;

            private DefaultValue(Object defaultValue) {
                this.defaultValue = defaultValue;
                this.propertyDispatcher = PropertyDispatcher.of(defaultValue.getClass());
            }

            protected static AnnotationValue.Loaded<?> of(Method method) {
                Object defaultValue = method.getDefaultValue();
                return defaultValue == null ? new Missing(method.getDeclaringClass(), method.getName()) : new DefaultValue(defaultValue);
            }

            @Override
            public AnnotationValue.Loaded.State getState() {
                return AnnotationValue.Loaded.State.RESOLVED;
            }

            @Override
            public Object resolve() {
                return this.propertyDispatcher.conditionalClone(this.defaultValue);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AnnotationValue.Loaded)) {
                    return false;
                }
                AnnotationValue.Loaded loaded = (AnnotationValue.Loaded)other;
                return loaded.getState().isResolved() && this.propertyDispatcher.equals(this.defaultValue, loaded.resolve());
            }

            public int hashCode() {
                return this.propertyDispatcher.hashCode(this.defaultValue);
            }

            public String toString() {
                return this.propertyDispatcher.toString(this.defaultValue);
            }
        }
    }

    public static interface Loadable<S extends Annotation>
    extends AnnotationDescription {
        public S load() throws ClassNotFoundException;

        public S loadSilent();
    }
}

