/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.util.Arrays;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.type.TypeDescription;

public enum PropertyDispatcher {
    BOOLEAN_ARRAY{

        @Override
        public String toString(Object value) {
            return Arrays.toString((boolean[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((boolean[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((boolean[])first, (boolean[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            boolean[] castValue = (boolean[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    BYTE_ARRAY{

        @Override
        public String toString(Object value) {
            return Arrays.toString((byte[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((byte[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((byte[])first, (byte[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            byte[] castValue = (byte[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    SHORT_ARRAY{

        @Override
        public String toString(Object value) {
            return Arrays.toString((short[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((short[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((short[])first, (short[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            short[] castValue = (short[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    CHARACTER_ARRAY{

        @Override
        public String toString(Object value) {
            return Arrays.toString((char[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((char[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((char[])first, (char[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            char[] castValue = (char[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    INTEGER_ARRAY{

        @Override
        public String toString(Object value) {
            return Arrays.toString((int[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((int[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((int[])first, (int[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            int[] castValue = (int[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    LONG_ARRAY{

        @Override
        public String toString(Object value) {
            return Arrays.toString((long[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((long[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((long[])first, (long[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            long[] castValue = (long[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    FLOAT_ARRAY{

        @Override
        public String toString(Object value) {
            return Arrays.toString((float[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((float[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((float[])first, (float[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            float[] castValue = (float[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    DOUBLE_ARRAY{

        @Override
        public String toString(Object value) {
            return Arrays.toString((double[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((double[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((double[])first, (double[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            double[] castValue = (double[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    TYPE_LOADED{

        @Override
        public String toString(Object value) {
            return TypeRenderer.CURRENT.render(value);
        }

        @Override
        public int hashCode(Object value) {
            return value.hashCode();
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return first.equals(second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            return value;
        }
    }
    ,
    TYPE_LOADED_ARRAY{

        @Override
        public String toString(Object value) {
            return TypeRenderer.CURRENT.render((Object[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((Object[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((Object[])first, (Object[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            Object[] castValue = (Object[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    TYPE_DESCRIBED{

        @Override
        public String toString(Object value) {
            return TypeRenderer.CURRENT.render(value);
        }

        @Override
        public int hashCode(Object value) {
            return value.hashCode();
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return first.equals(second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            return value;
        }
    }
    ,
    TYPE_DESCRIBED_ARRAY{

        @Override
        public String toString(Object value) {
            return TypeRenderer.CURRENT.render((Object[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((Object[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((Object[])first, (Object[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            Object[] castValue = (Object[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    REFERENCE_ARRAY{

        @Override
        public String toString(Object value) {
            return Arrays.toString((Object[])value);
        }

        @Override
        public int hashCode(Object value) {
            return Arrays.hashCode((Object[])value);
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return Arrays.equals((Object[])first, (Object[])second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            Object[] castValue = (Object[])value;
            return (T)(castValue.length == 0 ? value : castValue.clone());
        }
    }
    ,
    NON_ARRAY{

        @Override
        public String toString(Object value) {
            return value.toString();
        }

        @Override
        public int hashCode(Object value) {
            return value.hashCode();
        }

        @Override
        protected boolean doEquals(Object first, Object second) {
            return first.equals(second);
        }

        @Override
        public <T> T conditionalClone(T value) {
            return value;
        }
    };


    public static PropertyDispatcher of(Class<?> type) {
        if (type == boolean[].class) {
            return BOOLEAN_ARRAY;
        }
        if (type == byte[].class) {
            return BYTE_ARRAY;
        }
        if (type == short[].class) {
            return SHORT_ARRAY;
        }
        if (type == char[].class) {
            return CHARACTER_ARRAY;
        }
        if (type == int[].class) {
            return INTEGER_ARRAY;
        }
        if (type == long[].class) {
            return LONG_ARRAY;
        }
        if (type == float[].class) {
            return FLOAT_ARRAY;
        }
        if (type == double[].class) {
            return DOUBLE_ARRAY;
        }
        if (type == Class.class) {
            return TYPE_LOADED;
        }
        if (type == Class[].class) {
            return TYPE_LOADED_ARRAY;
        }
        if (TypeDescription.class.isAssignableFrom(type)) {
            return TYPE_DESCRIBED;
        }
        if (TypeDescription[].class.isAssignableFrom(type)) {
            return TYPE_DESCRIBED_ARRAY;
        }
        if (Object[].class.isAssignableFrom(type)) {
            return REFERENCE_ARRAY;
        }
        return NON_ARRAY;
    }

    public abstract String toString(Object var1);

    public abstract int hashCode(Object var1);

    public boolean equals(Object first, Object second) {
        return second != null && (first == second || PropertyDispatcher.of(second.getClass()) == this && this.doEquals(first, second));
    }

    protected abstract boolean doEquals(Object var1, Object var2);

    public abstract <T> T conditionalClone(T var1);

    public String toString() {
        return "PropertyDispatcher." + this.name();
    }

    public static enum TypeRenderer {
        FOR_LEGACY_VM('[', ']'){

            @Override
            public String render(Object type) {
                if (!(type instanceof Class) && !(type instanceof TypeDescription)) {
                    throw new IllegalArgumentException("Unexpected type description: " + type);
                }
                return type.toString();
            }
        }
        ,
        FOR_JAVA9_CAPABLE_VM('{', '}'){

            @Override
            public String render(Object type) {
                String name;
                if (type instanceof Class) {
                    name = ((Class)type).getName();
                } else if (type instanceof TypeDescription) {
                    name = ((TypeDescription)type).getName();
                } else {
                    throw new IllegalArgumentException("Unexpected type description: " + type);
                }
                return name + TypeRenderer.JAVA9_NAME_SUFFIX;
            }
        };

        private static final String JAVA9_NAME_SUFFIX = ".class";
        public static final TypeRenderer CURRENT;
        private final char open;
        private final char close;

        private static TypeRenderer make() {
            return ClassFileVersion.ofThisVm(ClassFileVersion.JAVA_V6).isAtLeast(ClassFileVersion.JAVA_V9) ? FOR_JAVA9_CAPABLE_VM : FOR_LEGACY_VM;
        }

        private TypeRenderer(char open, char close) {
            this.open = open;
            this.close = close;
        }

        public abstract String render(Object var1);

        public String render(Object[] type) {
            StringBuilder stringBuilder = new StringBuilder().append(this.open);
            boolean initial = true;
            for (Object aType : type) {
                stringBuilder.append(this.render(aType));
                if (initial) {
                    initial = false;
                    continue;
                }
                stringBuilder.append(", ");
            }
            return stringBuilder.append(this.close).toString();
        }

        public char getOpen() {
            return this.open;
        }

        public char getClose() {
            return this.close;
        }

        public String toString() {
            return "PropertyDispatcher.TypeRenderer." + this.name();
        }

        static {
            CURRENT = TypeRenderer.make();
        }
    }
}

