/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.FieldLocator;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.bind.MethodDelegationBinder;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.RandomString;

public class MethodDelegation
implements Implementation.Composable {
    private final ImplementationDelegate implementationDelegate;
    private final List<TargetMethodAnnotationDrivenBinder.ParameterBinder<?>> parameterBinders;
    private final TargetMethodAnnotationDrivenBinder.DefaultsProvider defaultsProvider;
    private final TargetMethodAnnotationDrivenBinder.TerminationHandler terminationHandler;
    private final MethodDelegationBinder.AmbiguityResolver ambiguityResolver;
    private final Assigner assigner;

    protected MethodDelegation(ImplementationDelegate implementationDelegate, List<TargetMethodAnnotationDrivenBinder.ParameterBinder<?>> parameterBinders, TargetMethodAnnotationDrivenBinder.DefaultsProvider defaultsProvider, TargetMethodAnnotationDrivenBinder.TerminationHandler terminationHandler, MethodDelegationBinder.AmbiguityResolver ambiguityResolver, Assigner assigner) {
        this.implementationDelegate = implementationDelegate;
        this.parameterBinders = parameterBinders;
        this.defaultsProvider = defaultsProvider;
        this.terminationHandler = terminationHandler;
        this.ambiguityResolver = ambiguityResolver;
        this.assigner = assigner;
    }

    public static MethodDelegation to(Class<?> type) {
        return MethodDelegation.to(new TypeDescription.ForLoadedType(type));
    }

    public static MethodDelegation to(TypeDescription typeDescription) {
        if (typeDescription.isArray()) {
            throw new IllegalArgumentException("Cannot delegate to array " + typeDescription);
        }
        if (typeDescription.isPrimitive()) {
            throw new IllegalArgumentException("Cannot delegate to primitive " + typeDescription);
        }
        return new MethodDelegation(ImplementationDelegate.ForStaticMethod.of(typeDescription), TargetMethodAnnotationDrivenBinder.ParameterBinder.DEFAULTS, Argument.NextUnboundAsDefaultsProvider.INSTANCE, TargetMethodAnnotationDrivenBinder.TerminationHandler.RETURNING, MethodDelegationBinder.AmbiguityResolver.DEFAULT, Assigner.DEFAULT);
    }

    public static MethodDelegation to(Object delegate) {
        return MethodDelegation.to(delegate, MethodGraph.Compiler.DEFAULT);
    }

    public static MethodDelegation to(Object delegate, MethodGraph.Compiler methodGraphCompiler) {
        return MethodDelegation.to(delegate, delegate.getClass(), methodGraphCompiler);
    }

    public static MethodDelegation to(Object delegate, String fieldName) {
        return MethodDelegation.to(delegate, fieldName, MethodGraph.Compiler.DEFAULT);
    }

    public static MethodDelegation to(Object delegate, String fieldName, MethodGraph.Compiler methodGraphCompiler) {
        return MethodDelegation.to(delegate, delegate.getClass(), fieldName, methodGraphCompiler);
    }

    public static MethodDelegation to(Object delegate, Type type) {
        return MethodDelegation.to(delegate, type, MethodGraph.Compiler.DEFAULT);
    }

    public static MethodDelegation to(Object delegate, Type type, MethodGraph.Compiler methodGraphCompiler) {
        return MethodDelegation.to(delegate, type, String.format("%s$%s", "delegate", RandomString.hashOf(delegate.hashCode())), methodGraphCompiler);
    }

    public static MethodDelegation to(Object delegate, Type type, String fieldName) {
        return MethodDelegation.to(delegate, type, fieldName, MethodGraph.Compiler.DEFAULT);
    }

    public static MethodDelegation to(Object delegate, Type type, String fieldName, MethodGraph.Compiler methodGraphCompiler) {
        TypeDescription.Generic typeDescription = TypeDefinition.Sort.describe(type);
        if (!typeDescription.asErasure().isInstance(delegate)) {
            throw new IllegalArgumentException(delegate + " is not an instance of " + type);
        }
        return new MethodDelegation(new ImplementationDelegate.ForInstance(delegate, fieldName, typeDescription, methodGraphCompiler), TargetMethodAnnotationDrivenBinder.ParameterBinder.DEFAULTS, Argument.NextUnboundAsDefaultsProvider.INSTANCE, TargetMethodAnnotationDrivenBinder.TerminationHandler.RETURNING, MethodDelegationBinder.AmbiguityResolver.DEFAULT, Assigner.DEFAULT);
    }

    public static MethodDelegation toConstructor(Class<?> type) {
        return MethodDelegation.toConstructor(new TypeDescription.ForLoadedType(type));
    }

    public static MethodDelegation toConstructor(TypeDescription typeDescription) {
        return new MethodDelegation(ImplementationDelegate.ForConstruction.of(typeDescription), TargetMethodAnnotationDrivenBinder.ParameterBinder.DEFAULTS, Argument.NextUnboundAsDefaultsProvider.INSTANCE, TargetMethodAnnotationDrivenBinder.TerminationHandler.RETURNING, MethodDelegationBinder.AmbiguityResolver.DEFAULT, Assigner.DEFAULT);
    }

    public static MethodDelegation toField(String name) {
        return MethodDelegation.toField(name, FieldLocator.ForClassHierarchy.Factory.INSTANCE);
    }

    public static MethodDelegation toField(String name, FieldLocator.Factory fieldLocatorFactory) {
        return MethodDelegation.toField(name, fieldLocatorFactory, MethodGraph.Compiler.DEFAULT);
    }

    public static MethodDelegation toField(String name, MethodGraph.Compiler methodGraphCompiler) {
        return MethodDelegation.toField(name, FieldLocator.ForClassHierarchy.Factory.INSTANCE, methodGraphCompiler);
    }

    public static MethodDelegation toField(String name, FieldLocator.Factory fieldLocatorFactory, MethodGraph.Compiler methodGraphCompiler) {
        return new MethodDelegation(new ImplementationDelegate.ForField(name, fieldLocatorFactory, methodGraphCompiler), TargetMethodAnnotationDrivenBinder.ParameterBinder.DEFAULTS, Argument.NextUnboundAsDefaultsProvider.INSTANCE, TargetMethodAnnotationDrivenBinder.TerminationHandler.RETURNING, MethodDelegationBinder.AmbiguityResolver.DEFAULT, Assigner.DEFAULT);
    }

    public MethodDelegation appendParameterBinder(TargetMethodAnnotationDrivenBinder.ParameterBinder<?> parameterBinder) {
        return new MethodDelegation(this.implementationDelegate, CompoundList.of(this.parameterBinders, parameterBinder), this.defaultsProvider, this.terminationHandler, this.ambiguityResolver, this.assigner);
    }

    public MethodDelegation defineParameterBinder(TargetMethodAnnotationDrivenBinder.ParameterBinder<?> ... parameterBinder) {
        return new MethodDelegation(this.implementationDelegate, Arrays.asList(parameterBinder), this.defaultsProvider, this.terminationHandler, this.ambiguityResolver, this.assigner);
    }

    public MethodDelegation withDefaultsProvider(TargetMethodAnnotationDrivenBinder.DefaultsProvider defaultsProvider) {
        return new MethodDelegation(this.implementationDelegate, this.parameterBinders, defaultsProvider, this.terminationHandler, this.ambiguityResolver, this.assigner);
    }

    public MethodDelegation appendAmbiguityResolver(MethodDelegationBinder.AmbiguityResolver ambiguityResolver) {
        return this.defineAmbiguityResolver(new MethodDelegationBinder.AmbiguityResolver.Chain(this.ambiguityResolver, ambiguityResolver));
    }

    public MethodDelegation defineAmbiguityResolver(MethodDelegationBinder.AmbiguityResolver ... ambiguityResolver) {
        return new MethodDelegation(this.implementationDelegate, this.parameterBinders, this.defaultsProvider, this.terminationHandler, new MethodDelegationBinder.AmbiguityResolver.Chain(ambiguityResolver), this.assigner);
    }

    public MethodDelegation withAssigner(Assigner assigner) {
        return new MethodDelegation(this.implementationDelegate, this.parameterBinders, this.defaultsProvider, this.terminationHandler, this.ambiguityResolver, assigner);
    }

    public MethodDelegation filter(ElementMatcher<? super MethodDescription> methodMatcher) {
        return new MethodDelegation(this.implementationDelegate.filter(methodMatcher), this.parameterBinders, this.defaultsProvider, this.terminationHandler, this.ambiguityResolver, this.assigner);
    }

    @Override
    public Implementation andThen(Implementation implementation) {
        return new Implementation.Compound(new MethodDelegation(this.implementationDelegate, this.parameterBinders, this.defaultsProvider, TargetMethodAnnotationDrivenBinder.TerminationHandler.DROPPING, this.ambiguityResolver, this.assigner), implementation);
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return this.implementationDelegate.prepare(instrumentedType);
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        ImplementationDelegate.Resolution resolution = this.implementationDelegate.resolve(implementationTarget.getInstrumentedType());
        return new Appender(resolution.getPreparation(), implementationTarget, resolution.getCandidates(), new MethodDelegationBinder.Processor(new TargetMethodAnnotationDrivenBinder(this.parameterBinders, this.defaultsProvider, this.terminationHandler, this.assigner, resolution.getMethodInvoker()), this.ambiguityResolver), resolution.isAllowStaticMethod());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MethodDelegation that = (MethodDelegation)other;
        return this.ambiguityResolver.equals(that.ambiguityResolver) && this.assigner.equals(that.assigner) && this.defaultsProvider.equals(that.defaultsProvider) && this.terminationHandler.equals((Object)that.terminationHandler) && this.implementationDelegate.equals(that.implementationDelegate) && this.parameterBinders.equals(that.parameterBinders);
    }

    public int hashCode() {
        int result = this.implementationDelegate.hashCode();
        result = 31 * result + this.parameterBinders.hashCode();
        result = 31 * result + this.defaultsProvider.hashCode();
        result = 31 * result + this.terminationHandler.hashCode();
        result = 31 * result + this.ambiguityResolver.hashCode();
        result = 31 * result + this.assigner.hashCode();
        return result;
    }

    public String toString() {
        return "MethodDelegation{implementationDelegate=" + this.implementationDelegate + ", parameterBinders=" + this.parameterBinders + ", defaultsProvider=" + this.defaultsProvider + ", terminationHandler=" + (Object)((Object)this.terminationHandler) + ", ambiguityResolver=" + this.ambiguityResolver + ", assigner=" + this.assigner + '}';
    }

    protected static class Appender
    implements ByteCodeAppender {
        private final StackManipulation preparingStackAssignment;
        private final Implementation.Target implementationTarget;
        private final MethodList targetCandidates;
        private final MethodDelegationBinder.Processor processor;
        private final boolean allowStaticMethods;

        protected Appender(StackManipulation preparingStackAssignment, Implementation.Target implementationTarget, MethodList targetCandidates, MethodDelegationBinder.Processor processor, boolean allowStaticMethods) {
            this.preparingStackAssignment = preparingStackAssignment;
            this.implementationTarget = implementationTarget;
            this.targetCandidates = targetCandidates;
            this.processor = processor;
            this.allowStaticMethods = allowStaticMethods;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            if (!this.allowStaticMethods && instrumentedMethod.isStatic()) {
                throw new IllegalStateException("Cannot read non-static delegation property from static method " + instrumentedMethod);
            }
            StackManipulation.Size stackSize = new StackManipulation.Compound(this.preparingStackAssignment, this.processor.process(this.implementationTarget, instrumentedMethod, this.targetCandidates)).apply(methodVisitor, implementationContext);
            return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Appender that = (Appender)other;
            return this.implementationTarget.equals(that.implementationTarget) && this.preparingStackAssignment.equals(that.preparingStackAssignment) && this.processor.equals(that.processor) && this.allowStaticMethods == that.allowStaticMethods && this.targetCandidates.equals(that.targetCandidates);
        }

        public int hashCode() {
            int result = this.preparingStackAssignment.hashCode();
            result = 31 * result + this.implementationTarget.hashCode();
            result = 31 * result + this.targetCandidates.hashCode();
            result = 31 * result + this.processor.hashCode();
            result = 31 * result + (this.allowStaticMethods ? 1 : 0);
            return result;
        }

        public String toString() {
            return "MethodDelegation.Appender{preparingStackAssignment=" + this.preparingStackAssignment + ", implementationTarget=" + this.implementationTarget + ", targetCandidates=" + this.targetCandidates + ", processor=" + this.processor + ", allowStaticMethods=" + this.allowStaticMethods + '}';
        }
    }

    protected static interface ImplementationDelegate
    extends InstrumentedType.Prepareable {
        public static final String FIELD_NAME_PREFIX = "delegate";

        public ImplementationDelegate filter(ElementMatcher<? super MethodDescription> var1);

        public Resolution resolve(TypeDescription var1);

        public static class ForConstruction
        implements ImplementationDelegate {
            private final TypeDescription typeDescription;
            private final MethodList<?> candidates;

            protected ForConstruction(TypeDescription typeDescription, MethodList<?> candidates) {
                this.typeDescription = typeDescription;
                this.candidates = candidates;
            }

            protected static ImplementationDelegate of(TypeDescription typeDescription) {
                return new ForConstruction(typeDescription, (MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.isConstructor()));
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public ImplementationDelegate filter(ElementMatcher<? super MethodDescription> matcher) {
                return new ForConstruction(this.typeDescription, (MethodList)this.candidates.filter(matcher));
            }

            @Override
            public Resolution resolve(TypeDescription instrumentedType) {
                return new Resolution((MethodList)this.candidates.filter(ElementMatchers.isVisibleTo(instrumentedType)), new StackManipulation.Compound(TypeCreation.of(this.typeDescription), Duplication.SINGLE), MethodDelegationBinder.MethodInvoker.Simple.INSTANCE);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForConstruction that = (ForConstruction)object;
                return this.typeDescription.equals(that.typeDescription) && this.candidates.equals(that.candidates);
            }

            public int hashCode() {
                int result = this.typeDescription.hashCode();
                result = 31 * result + this.candidates.hashCode();
                return result;
            }

            public String toString() {
                return "MethodDelegation.ImplementationDelegate.ForConstruction{typeDescription=" + this.typeDescription + ", candidates=" + this.candidates + '}';
            }
        }

        public static class ForInstance
        implements ImplementationDelegate {
            private final ElementMatcher<? super MethodDescription> matcher;
            private final Object delegate;
            private final String fieldName;
            private final TypeDescription.Generic fieldType;
            private final MethodGraph.Compiler methodGraphCompiler;

            protected ForInstance(Object delegate, String fieldName, TypeDescription.Generic fieldType, MethodGraph.Compiler methodGraphCompiler) {
                this(ElementMatchers.any(), delegate, fieldName, fieldType, methodGraphCompiler);
            }

            private ForInstance(ElementMatcher<? super MethodDescription> matcher, Object delegate, String fieldName, TypeDescription.Generic fieldType, MethodGraph.Compiler methodGraphCompiler) {
                this.matcher = matcher;
                this.delegate = delegate;
                this.fieldName = fieldName;
                this.fieldType = fieldType;
                this.methodGraphCompiler = methodGraphCompiler;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withField(new FieldDescription.Token(this.fieldName, 4105, this.fieldType)).withInitializer(new LoadedTypeInitializer.ForStaticField(this.fieldName, this.delegate));
            }

            @Override
            public ImplementationDelegate filter(ElementMatcher<? super MethodDescription> matcher) {
                return new ForInstance(new ElementMatcher.Junction.Conjunction<MethodDescription>(this.matcher, matcher), this.delegate, this.fieldName, this.fieldType, this.methodGraphCompiler);
            }

            @Override
            public Resolution resolve(TypeDescription instrumentedType) {
                if (!this.fieldType.asErasure().isVisibleTo(instrumentedType)) {
                    throw new IllegalStateException(this.fieldType + " is not visible to " + instrumentedType);
                }
                return new Resolution((MethodList)this.methodGraphCompiler.compile(this.fieldType, instrumentedType).listNodes().asMethodList().filter(this.matcher), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName).and(ElementMatchers.genericFieldType(this.fieldType)))).getOnly()).getter(), new MethodDelegationBinder.MethodInvoker.Virtual(this.fieldType.asErasure()));
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForInstance that = (ForInstance)object;
                return this.matcher.equals(that.matcher) && this.delegate.equals(that.delegate) && this.fieldName.equals(that.fieldName) && this.fieldType.equals(that.fieldType) && this.methodGraphCompiler.equals(that.methodGraphCompiler);
            }

            public int hashCode() {
                int result = this.matcher.hashCode();
                result = 31 * result + this.delegate.hashCode();
                result = 31 * result + this.fieldName.hashCode();
                result = 31 * result + this.fieldType.hashCode();
                result = 31 * result + this.methodGraphCompiler.hashCode();
                return result;
            }

            public String toString() {
                return "MethodDelegation.ImplementationDelegate.ForInstance{matcher=" + this.matcher + ", delegate=" + this.delegate + ", fieldName='" + this.fieldName + '\'' + ", fieldType=" + this.fieldType + ", methodGraphCompiler=" + this.methodGraphCompiler + '}';
            }
        }

        public static class ForField
        implements ImplementationDelegate {
            private final ElementMatcher<? super MethodDescription> matcher;
            private final String fieldName;
            private final FieldLocator.Factory fieldLocatorFactory;
            private final MethodGraph.Compiler methodGraphCompiler;

            protected ForField(String fieldName, FieldLocator.Factory fieldLocatorFactory, MethodGraph.Compiler methodGraphCompiler) {
                this(ElementMatchers.any(), fieldName, fieldLocatorFactory, methodGraphCompiler);
            }

            private ForField(ElementMatcher<? super MethodDescription> matcher, String fieldName, FieldLocator.Factory fieldLocatorFactory, MethodGraph.Compiler methodGraphCompiler) {
                this.matcher = matcher;
                this.fieldName = fieldName;
                this.fieldLocatorFactory = fieldLocatorFactory;
                this.methodGraphCompiler = methodGraphCompiler;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public ImplementationDelegate filter(ElementMatcher<? super MethodDescription> matcher) {
                return new ForField(new ElementMatcher.Junction.Conjunction<MethodDescription>(this.matcher, matcher), this.fieldName, this.fieldLocatorFactory, this.methodGraphCompiler);
            }

            @Override
            public Resolution resolve(TypeDescription instrumentedType) {
                FieldLocator.Resolution resolution = this.fieldLocatorFactory.make(instrumentedType).locate(this.fieldName);
                if (!resolution.isResolved()) {
                    throw new IllegalStateException("Could not locate field '" + this.fieldName + "' for " + instrumentedType);
                }
                if (!resolution.getField().getType().asErasure().isVisibleTo(instrumentedType)) {
                    throw new IllegalStateException(resolution.getField() + " is not visible to " + instrumentedType);
                }
                return new Resolution((MethodList)this.methodGraphCompiler.compile(resolution.getField().getType(), instrumentedType).listNodes().asMethodList().filter(this.matcher), new StackManipulation.Compound(resolution.getField().isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.REFERENCE.loadFrom(0), FieldAccess.forField(resolution.getField()).getter()), new MethodDelegationBinder.MethodInvoker.Virtual(resolution.getField().getType().asErasure()), resolution.getField().isStatic());
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForField forField = (ForField)object;
                return this.matcher.equals(forField.matcher) && this.fieldName.equals(forField.fieldName) && this.fieldLocatorFactory.equals(forField.fieldLocatorFactory) && this.methodGraphCompiler.equals(forField.methodGraphCompiler);
            }

            public int hashCode() {
                int result = this.matcher.hashCode();
                result = 31 * result + this.fieldName.hashCode();
                result = 31 * result + this.fieldLocatorFactory.hashCode();
                result = 31 * result + this.methodGraphCompiler.hashCode();
                return result;
            }

            public String toString() {
                return "MethodDelegation.ImplementationDelegate.ForField{matcher=" + this.matcher + ", fieldName='" + this.fieldName + '\'' + ", fieldLocatorFactory=" + this.fieldLocatorFactory + ", methodGraphCompiler=" + this.methodGraphCompiler + '}';
            }
        }

        public static class ForStaticMethod
        implements ImplementationDelegate {
            private final MethodList<?> candidates;

            protected ForStaticMethod(MethodList<?> candidates) {
                this.candidates = candidates;
            }

            protected static ImplementationDelegate of(TypeDescription typeDescription) {
                return new ForStaticMethod((MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.isStatic()));
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public ImplementationDelegate filter(ElementMatcher<? super MethodDescription> matcher) {
                return new ForStaticMethod((MethodList)this.candidates.filter(matcher));
            }

            @Override
            public Resolution resolve(TypeDescription instrumentedType) {
                return new Resolution((MethodList)this.candidates.filter(ElementMatchers.isVisibleTo(instrumentedType)));
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForStaticMethod that = (ForStaticMethod)object;
                return this.candidates.equals(that.candidates);
            }

            public int hashCode() {
                return this.candidates.hashCode();
            }

            public String toString() {
                return "MethodDelegation.ImplementationDelegate.ForStaticMethod{candidates=" + this.candidates + '}';
            }
        }

        public static class Resolution {
            private final MethodList<?> candidates;
            private final StackManipulation preparation;
            private final MethodDelegationBinder.MethodInvoker methodInvoker;
            private final boolean allowStaticMethods;

            protected Resolution(MethodList<?> candidates) {
                this(candidates, StackManipulation.Trivial.INSTANCE, MethodDelegationBinder.MethodInvoker.Simple.INSTANCE);
            }

            protected Resolution(MethodList<?> candidates, StackManipulation preparation, MethodDelegationBinder.MethodInvoker methodInvoker) {
                this(candidates, preparation, methodInvoker, true);
            }

            protected Resolution(MethodList<?> candidates, StackManipulation preparation, MethodDelegationBinder.MethodInvoker methodInvoker, boolean allowStaticMethods) {
                this.candidates = candidates;
                this.methodInvoker = methodInvoker;
                this.preparation = preparation;
                this.allowStaticMethods = allowStaticMethods;
            }

            protected MethodList<?> getCandidates() {
                return this.candidates;
            }

            protected StackManipulation getPreparation() {
                return this.preparation;
            }

            protected MethodDelegationBinder.MethodInvoker getMethodInvoker() {
                return this.methodInvoker;
            }

            protected boolean isAllowStaticMethod() {
                return this.allowStaticMethods;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Resolution that = (Resolution)object;
                return this.allowStaticMethods == that.allowStaticMethods && this.candidates.equals(that.candidates) && this.preparation.equals(that.preparation) && this.methodInvoker.equals(that.methodInvoker);
            }

            public int hashCode() {
                int result = this.candidates.hashCode();
                result = 31 * result + this.preparation.hashCode();
                result = 31 * result + this.methodInvoker.hashCode();
                result = 31 * result + (this.allowStaticMethods ? 1 : 0);
                return result;
            }

            public String toString() {
                return "MethodDelegation.ImplementationDelegate.Resolution{candidates=" + this.candidates + ", preparation=" + this.preparation + ", methodInvoker=" + this.methodInvoker + ", allowStaticMethods=" + this.allowStaticMethods + '}';
            }
        }
    }
}

