/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.scaffold.FieldLocator;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.implementation.bytecode.Addition;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.collection.ArrayAccess;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.DefaultValue;
import net.bytebuddy.implementation.bytecode.constant.DoubleConstant;
import net.bytebuddy.implementation.bytecode.constant.FloatConstant;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.LongConstant;
import net.bytebuddy.implementation.bytecode.constant.MethodConstant;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.AnnotationVisitor;
import net.bytebuddy.jar.asm.Attribute;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Opcodes;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.jar.asm.TypePath;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.JavaConstant;
import net.bytebuddy.utility.JavaType;
import net.bytebuddy.utility.visitor.ExceptionTableSensitiveMethodVisitor;
import net.bytebuddy.utility.visitor.LineNumberPrependingMethodVisitor;
import net.bytebuddy.utility.visitor.StackAwareMethodVisitor;

public class Advice
implements AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper,
Implementation {
    private static final ClassReader UNDEFINED = null;
    private static final MethodDescription.InDefinedShape INLINE_ENTER;
    private static final MethodDescription.InDefinedShape SUPPRESS_ENTER;
    private static final MethodDescription.InDefinedShape PREPEND_LINE_NUMBER;
    private static final MethodDescription.InDefinedShape SKIP_ON;
    private static final MethodDescription.InDefinedShape INLINE_EXIT;
    private static final MethodDescription.InDefinedShape SUPPRESS_EXIT;
    private static final MethodDescription.InDefinedShape ON_THROWABLE;
    private static final MethodDescription.InDefinedShape PRINT_STACK_TRACE;
    private final Dispatcher.Resolved.ForMethodEnter methodEnter;
    private final Dispatcher.Resolved.ForMethodExit methodExit;
    private final Assigner assigner;
    private final StackManipulation exceptionHandler;
    private final Implementation delegate;

    protected Advice(Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit) {
        this(methodEnter, methodExit, Assigner.DEFAULT, Removal.of(TypeDescription.THROWABLE), SuperMethodCall.INSTANCE);
    }

    private Advice(Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, Assigner assigner, StackManipulation exceptionHandler, Implementation delegate) {
        this.methodEnter = methodEnter;
        this.methodExit = methodExit;
        this.assigner = assigner;
        this.exceptionHandler = exceptionHandler;
        this.delegate = delegate;
    }

    public static Advice to(Class<?> advice) {
        return Advice.to(advice, ClassFileLocator.ForClassLoader.of(advice.getClassLoader()));
    }

    public static Advice to(Class<?> advice, ClassFileLocator classFileLocator) {
        return Advice.to((TypeDescription)new TypeDescription.ForLoadedType(advice), classFileLocator);
    }

    public static Advice to(TypeDescription advice) {
        return Advice.to(advice, (ClassFileLocator)ClassFileLocator.NoOp.INSTANCE);
    }

    public static Advice to(TypeDescription advice, ClassFileLocator classFileLocator) {
        return Advice.to(advice, classFileLocator, Collections.emptyList());
    }

    protected static Advice to(TypeDescription advice, ClassFileLocator classFileLocator, List<? extends Dispatcher.OffsetMapping.Factory> userFactories) {
        Dispatcher.Unresolved methodEnter = Dispatcher.Inactive.INSTANCE;
        Dispatcher.Unresolved methodExit = Dispatcher.Inactive.INSTANCE;
        for (MethodDescription.InDefinedShape methodDescription : advice.getDeclaredMethods()) {
            methodEnter = Advice.locate(OnMethodEnter.class, INLINE_ENTER, methodEnter, methodDescription);
            methodExit = Advice.locate(OnMethodExit.class, INLINE_EXIT, methodExit, methodDescription);
        }
        if (!methodEnter.isAlive() && !methodExit.isAlive()) {
            throw new IllegalArgumentException("No advice defined by " + advice);
        }
        try {
            ClassReader classReader = methodEnter.isBinary() || methodExit.isBinary() ? new ClassReader(classFileLocator.locate(advice.getName()).resolve()) : UNDEFINED;
            Dispatcher.Resolved.ForMethodEnter resolved = methodEnter.asMethodEnter(userFactories, classReader);
            return new Advice(resolved, methodExit.asMethodExitTo(userFactories, classReader, resolved));
        }
        catch (IOException exception) {
            throw new IllegalStateException("Error reading class file of " + advice, exception);
        }
    }

    public static Advice to(Class<?> enterAdvice, Class<?> exitAdvice) {
        ClassLoader exitLoader;
        ClassLoader enterLoader = enterAdvice.getClassLoader();
        return Advice.to(enterAdvice, exitAdvice, enterLoader == (exitLoader = exitAdvice.getClassLoader()) ? ClassFileLocator.ForClassLoader.of(enterLoader) : new ClassFileLocator.Compound(ClassFileLocator.ForClassLoader.of(enterLoader), ClassFileLocator.ForClassLoader.of(exitLoader)));
    }

    public static Advice to(Class<?> enterAdvice, Class<?> exitAdvice, ClassFileLocator classFileLocator) {
        return Advice.to((TypeDescription)new TypeDescription.ForLoadedType(enterAdvice), new TypeDescription.ForLoadedType(exitAdvice), classFileLocator);
    }

    public static Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice) {
        return Advice.to(enterAdvice, exitAdvice, (ClassFileLocator)ClassFileLocator.NoOp.INSTANCE);
    }

    public static Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice, ClassFileLocator classFileLocator) {
        return Advice.to(enterAdvice, exitAdvice, classFileLocator, Collections.emptyList());
    }

    protected static Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice, ClassFileLocator classFileLocator, List<? extends Dispatcher.OffsetMapping.Factory> userFactories) {
        Dispatcher.Unresolved methodEnter = Dispatcher.Inactive.INSTANCE;
        Dispatcher.Unresolved methodExit = Dispatcher.Inactive.INSTANCE;
        for (MethodDescription.InDefinedShape methodDescription : enterAdvice.getDeclaredMethods()) {
            methodEnter = Advice.locate(OnMethodEnter.class, INLINE_ENTER, methodEnter, methodDescription);
        }
        if (!methodEnter.isAlive()) {
            throw new IllegalArgumentException("No enter advice defined by " + enterAdvice);
        }
        for (MethodDescription.InDefinedShape methodDescription : exitAdvice.getDeclaredMethods()) {
            methodExit = Advice.locate(OnMethodExit.class, INLINE_EXIT, methodExit, methodDescription);
        }
        if (!methodExit.isAlive()) {
            throw new IllegalArgumentException("No enter advice defined by " + exitAdvice);
        }
        try {
            Dispatcher.Resolved.ForMethodEnter resolved = methodEnter.asMethodEnter(userFactories, methodEnter.isBinary() ? new ClassReader(classFileLocator.locate(enterAdvice.getName()).resolve()) : UNDEFINED);
            return new Advice(resolved, methodExit.asMethodExitTo(userFactories, methodExit.isBinary() ? new ClassReader(classFileLocator.locate(exitAdvice.getName()).resolve()) : UNDEFINED, resolved));
        }
        catch (IOException exception) {
            throw new IllegalStateException("Error reading class file of " + enterAdvice + " or " + exitAdvice, exception);
        }
    }

    private static Dispatcher.Unresolved locate(Class<? extends Annotation> type, MethodDescription.InDefinedShape property, Dispatcher.Unresolved dispatcher, MethodDescription.InDefinedShape methodDescription) {
        AnnotationDescription.Loadable<? extends Annotation> annotation = methodDescription.getDeclaredAnnotations().ofType(type);
        if (annotation == null) {
            return dispatcher;
        }
        if (dispatcher.isAlive()) {
            throw new IllegalStateException("Duplicate advice for " + dispatcher + " and " + methodDescription);
        }
        if (!methodDescription.isStatic()) {
            throw new IllegalStateException("Advice for " + methodDescription + " is not static");
        }
        return annotation.getValue(property).resolve(Boolean.class) != false ? new Dispatcher.Inlining(methodDescription) : new Dispatcher.Delegating(methodDescription);
    }

    public static WithCustomMapping withCustomMapping() {
        return new WithCustomMapping();
    }

    public AsmVisitorWrapper.ForDeclaredMethods on(ElementMatcher<? super MethodDescription.InDefinedShape> matcher) {
        return new AsmVisitorWrapper.ForDeclaredMethods().method(matcher, this);
    }

    @Override
    public MethodVisitor wrap(TypeDescription instrumentedType, MethodDescription.InDefinedShape instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, TypePool typePool, int writerFlags, int readerFlags) {
        return instrumentedMethod.isAbstract() || instrumentedMethod.isNative() ? methodVisitor : this.doWrap(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, writerFlags, readerFlags);
    }

    protected MethodVisitor doWrap(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, int writerFlags, int readerFlags) {
        MethodVisitor methodVisitor2 = methodVisitor = this.methodEnter.isPrependLineNumber() ? new LineNumberPrependingMethodVisitor(methodVisitor) : methodVisitor;
        if (!this.methodExit.isAlive()) {
            return new AdviceVisitor.WithoutExitAdvice(methodVisitor, implementationContext, this.assigner, this.exceptionHandler, instrumentedType, instrumentedMethod, this.methodEnter, writerFlags, readerFlags);
        }
        if (this.methodExit.getThrowable().represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class))) {
            return new AdviceVisitor.WithExitAdvice.WithoutExceptionHandling(methodVisitor, implementationContext, this.assigner, this.exceptionHandler, instrumentedType, instrumentedMethod, this.methodEnter, this.methodExit, writerFlags, readerFlags);
        }
        if (instrumentedMethod.isConstructor()) {
            throw new IllegalStateException("Cannot catch exception during constructor call for " + instrumentedMethod);
        }
        return new AdviceVisitor.WithExitAdvice.WithExceptionHandling(methodVisitor, implementationContext, this.assigner, this.exceptionHandler, instrumentedType, instrumentedMethod, this.methodEnter, this.methodExit, writerFlags, readerFlags, this.methodExit.getThrowable());
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return this.delegate.prepare(instrumentedType);
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new Appender(this, implementationTarget, this.delegate.appender(implementationTarget));
    }

    public Advice withAssigner(Assigner assigner) {
        return new Advice(this.methodEnter, this.methodExit, assigner, this.exceptionHandler, this.delegate);
    }

    public Advice withExceptionPrinting() {
        return this.withExceptionHandler(MethodInvocation.invoke(PRINT_STACK_TRACE));
    }

    public Advice withExceptionHandler(StackManipulation exceptionHandler) {
        return new Advice(this.methodEnter, this.methodExit, this.assigner, exceptionHandler, this.delegate);
    }

    public Implementation wrap(Implementation implementation) {
        return new Advice(this.methodEnter, this.methodExit, this.assigner, this.exceptionHandler, implementation);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Advice advice = (Advice)other;
        return this.methodEnter.equals(advice.methodEnter) && this.methodExit.equals(advice.methodExit) && this.assigner.equals(advice.assigner) && this.exceptionHandler.equals(advice.exceptionHandler) && this.delegate.equals(advice.delegate);
    }

    public int hashCode() {
        int result = this.methodEnter.hashCode();
        result = 31 * result + this.methodExit.hashCode();
        result = 31 * result + this.assigner.hashCode();
        result = 31 * result + this.exceptionHandler.hashCode();
        result = 31 * result + this.delegate.hashCode();
        return result;
    }

    public String toString() {
        return "Advice{methodEnter=" + this.methodEnter + ", methodExit=" + this.methodExit + ", assigner=" + this.assigner + ", exceptionHandler=" + this.exceptionHandler + ", delegate=" + this.delegate + '}';
    }

    static {
        MethodList<MethodDescription.InDefinedShape> enter = new TypeDescription.ForLoadedType(OnMethodEnter.class).getDeclaredMethods();
        INLINE_ENTER = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("inline"))).getOnly();
        SUPPRESS_ENTER = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("suppress"))).getOnly();
        SKIP_ON = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("skipOn"))).getOnly();
        PREPEND_LINE_NUMBER = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("prependLineNumber"))).getOnly();
        MethodList<MethodDescription.InDefinedShape> exit = new TypeDescription.ForLoadedType(OnMethodExit.class).getDeclaredMethods();
        INLINE_EXIT = (MethodDescription.InDefinedShape)((MethodList)exit.filter(ElementMatchers.named("inline"))).getOnly();
        SUPPRESS_EXIT = (MethodDescription.InDefinedShape)((MethodList)exit.filter(ElementMatchers.named("suppress"))).getOnly();
        ON_THROWABLE = (MethodDescription.InDefinedShape)((MethodList)exit.filter(ElementMatchers.named("onThrowable"))).getOnly();
        PRINT_STACK_TRACE = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(Throwable.class).getDeclaredMethods().filter(ElementMatchers.named("printStackTrace").and(ElementMatchers.takesArguments(0)))).getOnly();
    }

    public static final class OnNonDefaultValue {
        private OnNonDefaultValue() {
            throw new UnsupportedOperationException("This marker class is not supposed to be instantiated");
        }
    }

    public static final class OnDefaultValue {
        private OnDefaultValue() {
            throw new UnsupportedOperationException("This marker class is not supposed to be instantiated");
        }
    }

    private static class NoExceptionHandler
    extends Throwable {
        private static final TypeDescription DESCRIPTION = new TypeDescription.ForLoadedType(NoExceptionHandler.class);

        private NoExceptionHandler() {
            throw new UnsupportedOperationException("This marker class is not supposed to be instantiated");
        }
    }

    public static class WithCustomMapping {
        private final Map<Class<? extends Annotation>, DynamicValue<?>> dynamicValues;

        protected WithCustomMapping() {
            this(Collections.emptyMap());
        }

        protected WithCustomMapping(Map<Class<? extends Annotation>, DynamicValue<?>> dynamicValues) {
            this.dynamicValues = dynamicValues;
        }

        public <T extends Annotation> WithCustomMapping bind(Class<? extends T> type, Object value) {
            return this.bind(type, new DynamicValue.ForFixedValue.OfConstant(value));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<? extends T> type, Field field) {
            return this.bind(type, new FieldDescription.ForLoadedField(field));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<? extends T> type, FieldDescription fieldDescription) {
            return this.bind(type, new DynamicValue.ForFieldValue(fieldDescription));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<? extends T> type, Method method, int index) {
            if (index < 0) {
                throw new IllegalArgumentException("A parameter cannot be negative: " + index);
            }
            if (method.getParameterTypes().length <= index) {
                throw new IllegalArgumentException(method + " does not declare a parameter with index " + index);
            }
            return this.bind(type, (ParameterDescription)new MethodDescription.ForLoadedMethod(method).getParameters().get(index));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<? extends T> type, Constructor<?> constructor, int index) {
            if (index < 0) {
                throw new IllegalArgumentException("A parameter cannot be negative: " + index);
            }
            if (constructor.getParameterTypes().length <= index) {
                throw new IllegalArgumentException(constructor + " does not declare a parameter with index " + index);
            }
            return this.bind(type, (ParameterDescription)new MethodDescription.ForLoadedConstructor(constructor).getParameters().get(index));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<? extends T> type, ParameterDescription parameterDescription) {
            return this.bind(type, new DynamicValue.ForParameterValue(parameterDescription));
        }

        public <T extends Annotation> WithCustomMapping bindSerialized(Class<? extends T> type, Serializable value) {
            return this.bind(type, DynamicValue.ForSerializedValue.of(value));
        }

        public <T extends Annotation> WithCustomMapping bindProperty(Class<? extends T> type, String property) {
            return this.bind(type, DynamicValue.ForFixedValue.OfAnnotationProperty.of(type, property));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<? extends T> type, DynamicValue<T> dynamicValue) {
            HashMap dynamicValues = new HashMap(this.dynamicValues);
            if (!type.isAnnotation()) {
                throw new IllegalArgumentException("Not an annotation type: " + type);
            }
            if (dynamicValues.put(type, dynamicValue) != null) {
                throw new IllegalArgumentException("Annotation type already mapped: " + type);
            }
            return new WithCustomMapping(dynamicValues);
        }

        public Advice to(Class<?> advice) {
            return this.to(advice, ClassFileLocator.ForClassLoader.of(advice.getClassLoader()));
        }

        public Advice to(Class<?> advice, ClassFileLocator classFileLocator) {
            return this.to((TypeDescription)new TypeDescription.ForLoadedType(advice), classFileLocator);
        }

        public Advice to(TypeDescription advice, ClassFileLocator classFileLocator) {
            ArrayList<Dispatcher.OffsetMapping.Factory> userFactories = new ArrayList<Dispatcher.OffsetMapping.Factory>(this.dynamicValues.size());
            for (Map.Entry<Class<Annotation>, DynamicValue<?>> entry : this.dynamicValues.entrySet()) {
                userFactories.add(Dispatcher.OffsetMapping.ForUserValue.Factory.of(entry.getKey(), entry.getValue()));
            }
            return Advice.to(advice, classFileLocator, userFactories);
        }

        public Advice to(Class<?> enterAdvice, Class<?> exitAdvice) {
            ClassLoader exitLoader;
            ClassLoader enterLoader = enterAdvice.getClassLoader();
            return this.to(enterAdvice, exitAdvice, enterLoader == (exitLoader = exitAdvice.getClassLoader()) ? ClassFileLocator.ForClassLoader.of(enterLoader) : new ClassFileLocator.Compound(ClassFileLocator.ForClassLoader.of(enterLoader), ClassFileLocator.ForClassLoader.of(exitLoader)));
        }

        public Advice to(Class<?> enterAdvice, Class<?> exitAdvice, ClassFileLocator classFileLocator) {
            return this.to(new TypeDescription.ForLoadedType(enterAdvice), new TypeDescription.ForLoadedType(exitAdvice), classFileLocator);
        }

        public Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice) {
            return this.to(enterAdvice, exitAdvice, (ClassFileLocator)ClassFileLocator.NoOp.INSTANCE);
        }

        public Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice, ClassFileLocator classFileLocator) {
            ArrayList<Dispatcher.OffsetMapping.Factory> userFactories = new ArrayList<Dispatcher.OffsetMapping.Factory>(this.dynamicValues.size());
            for (Map.Entry<Class<Annotation>, DynamicValue<?>> entry : this.dynamicValues.entrySet()) {
                userFactories.add(Dispatcher.OffsetMapping.ForUserValue.Factory.of(entry.getKey(), entry.getValue()));
            }
            return Advice.to(enterAdvice, exitAdvice, classFileLocator, userFactories);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            WithCustomMapping that = (WithCustomMapping)other;
            return this.dynamicValues.equals(that.dynamicValues);
        }

        public int hashCode() {
            return this.dynamicValues.hashCode();
        }

        public String toString() {
            return "Advice.WithCustomMapping{dynamicValues=" + this.dynamicValues + '}';
        }
    }

    public static interface DynamicValue<T extends Annotation> {
        public StackManipulation resolve(TypeDescription var1, MethodDescription var2, ParameterDescription.InDefinedShape var3, AnnotationDescription.Loadable<T> var4, Assigner var5, boolean var6);

        public static class ForSerializedValue
        implements DynamicValue<Annotation> {
            private static final String CHARSET = "ISO-8859-1";
            private static final MethodDescription.InDefinedShape GET_BYTES = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(String.class).getDeclaredMethods().filter(ElementMatchers.named("getBytes").and(ElementMatchers.takesArguments(String.class)))).getOnly();
            private static final MethodDescription.InDefinedShape CREATE_BYTE_ARRAY_INPUT_STREAM = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(ByteArrayInputStream.class).getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(byte[].class)))).getOnly();
            private static final MethodDescription.InDefinedShape CREATE_OBJECT_INPUT_STREAM = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(ObjectInputStream.class).getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(InputStream.class)))).getOnly();
            private static final MethodDescription.InDefinedShape READ_OBJECT = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(ObjectInputStream.class).getDeclaredMethods().filter(ElementMatchers.named("readObject").and(ElementMatchers.takesArguments(0)))).getOnly();
            private final TypeDescription typeDescription;
            private final String value;

            protected ForSerializedValue(TypeDescription typeDescription, String value) {
                this.typeDescription = typeDescription;
                this.value = value;
            }

            protected static DynamicValue<Annotation> of(Serializable value) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    try {
                        objectOutputStream.writeObject(value);
                    }
                    finally {
                        objectOutputStream.close();
                    }
                    return new ForSerializedValue(new TypeDescription.ForLoadedType(value.getClass()), byteArrayOutputStream.toString(CHARSET));
                }
                catch (IOException exception) {
                    throw new IllegalStateException("Cannot serialize " + value, exception);
                }
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Annotation> annotation, Assigner assigner, boolean initialized) {
                StackManipulation assignment = assigner.assign(this.typeDescription.asGenericType(), target.getType(), Assigner.Typing.DYNAMIC);
                if (!assignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.typeDescription + " to " + target.getType());
                }
                return new StackManipulation.Compound(TypeCreation.of(new TypeDescription.ForLoadedType(ObjectInputStream.class)), Duplication.SINGLE, TypeCreation.of(new TypeDescription.ForLoadedType(ByteArrayInputStream.class)), Duplication.SINGLE, new TextConstant(this.value), new TextConstant(CHARSET), MethodInvocation.invoke(GET_BYTES), MethodInvocation.invoke(CREATE_BYTE_ARRAY_INPUT_STREAM), MethodInvocation.invoke(CREATE_OBJECT_INPUT_STREAM), MethodInvocation.invoke(READ_OBJECT), assignment);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForSerializedValue that = (ForSerializedValue)object;
                return this.typeDescription.equals(that.typeDescription) && this.value.equals(that.value);
            }

            public int hashCode() {
                int result = this.typeDescription.hashCode();
                result = 31 * result + this.value.hashCode();
                return result;
            }

            public String toString() {
                return "Advice.DynamicValue.ForSerializedValue{typeDescription=" + this.typeDescription + ", value='" + this.value + '\'' + '}';
            }
        }

        public static class ForParameterValue
        implements DynamicValue<Annotation> {
            private final ParameterDescription parameterDescription;

            protected ForParameterValue(ParameterDescription parameterDescription) {
                this.parameterDescription = parameterDescription;
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Annotation> annotation, Assigner assigner, boolean initialized) {
                if (!this.parameterDescription.getDeclaringMethod().equals(instrumentedMethod)) {
                    throw new IllegalStateException(this.parameterDescription + " is not declared by " + instrumentedMethod);
                }
                StackManipulation assignment = assigner.assign(this.parameterDescription.getType(), target.getType(), Assigner.Typing.STATIC);
                if (!assignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.parameterDescription + " to " + target.getType());
                }
                return new StackManipulation.Compound(MethodVariableAccess.load(this.parameterDescription), assignment);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForParameterValue that = (ForParameterValue)object;
                return this.parameterDescription.equals(that.parameterDescription);
            }

            public int hashCode() {
                return this.parameterDescription.hashCode();
            }

            public String toString() {
                return "Advice.DynamicValue.ForParameterValue{parameterDescription=" + this.parameterDescription + '}';
            }
        }

        public static class ForFieldValue
        implements DynamicValue<Annotation> {
            private final FieldDescription fieldDescription;

            protected ForFieldValue(FieldDescription fieldDescription) {
                this.fieldDescription = fieldDescription;
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Annotation> annotation, Assigner assigner, boolean initialized) {
                if (!this.fieldDescription.isStatic()) {
                    if (instrumentedMethod.isStatic()) {
                        throw new IllegalStateException("Cannot access " + instrumentedMethod + " from " + this.fieldDescription);
                    }
                    if (!instrumentedType.isAssignableTo(this.fieldDescription.getDeclaringType().asErasure())) {
                        throw new IllegalStateException(this.fieldDescription + " is not declared by " + instrumentedType);
                    }
                }
                if (!this.fieldDescription.isVisibleTo(instrumentedType)) {
                    throw new IllegalStateException("Cannot access " + this.fieldDescription + " from " + instrumentedType);
                }
                StackManipulation assignment = assigner.assign(this.fieldDescription.getType(), target.getType(), Assigner.Typing.STATIC);
                if (!assignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.fieldDescription + " to " + target.getType());
                }
                return new StackManipulation.Compound(this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), FieldAccess.forField(this.fieldDescription).read(), assignment);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForFieldValue that = (ForFieldValue)object;
                return this.fieldDescription.equals(that.fieldDescription);
            }

            public int hashCode() {
                return this.fieldDescription.hashCode();
            }

            public String toString() {
                return "Advice.DynamicValue.ForFieldValue{fieldDescription=" + this.fieldDescription + '}';
            }
        }

        public static abstract class ForFixedValue<S extends Annotation>
        implements DynamicValue<S> {
            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<S> annotation, Assigner assigner, boolean initialized) {
                TypeDescription typeDescription;
                StackManipulation stackManipulation;
                Object value = this.doResolve(instrumentedType, instrumentedMethod, target, annotation, assigner, initialized);
                if (value == null) {
                    if (target.getType().isPrimitive()) {
                        throw new IllegalStateException("Cannot assign null to the primitive type " + target);
                    }
                    return NullConstant.INSTANCE;
                }
                if (value instanceof Boolean) {
                    stackManipulation = IntegerConstant.forValue((Boolean)value);
                    typeDescription = new TypeDescription.ForLoadedType(Boolean.TYPE);
                } else if (value instanceof Byte) {
                    stackManipulation = IntegerConstant.forValue(((Byte)value).byteValue());
                    typeDescription = new TypeDescription.ForLoadedType(Byte.TYPE);
                } else if (value instanceof Short) {
                    stackManipulation = IntegerConstant.forValue(((Short)value).shortValue());
                    typeDescription = new TypeDescription.ForLoadedType(Short.TYPE);
                } else if (value instanceof Character) {
                    stackManipulation = IntegerConstant.forValue(((Character)value).charValue());
                    typeDescription = new TypeDescription.ForLoadedType(Character.TYPE);
                } else if (value instanceof Integer) {
                    stackManipulation = IntegerConstant.forValue((Integer)value);
                    typeDescription = new TypeDescription.ForLoadedType(Integer.TYPE);
                } else if (value instanceof Long) {
                    stackManipulation = LongConstant.forValue((Long)value);
                    typeDescription = new TypeDescription.ForLoadedType(Long.TYPE);
                } else if (value instanceof Float) {
                    stackManipulation = FloatConstant.forValue(((Float)value).floatValue());
                    typeDescription = new TypeDescription.ForLoadedType(Float.TYPE);
                } else if (value instanceof Double) {
                    stackManipulation = DoubleConstant.forValue((Double)value);
                    typeDescription = new TypeDescription.ForLoadedType(Double.TYPE);
                } else if (value instanceof TypeDescription) {
                    stackManipulation = ClassConstant.of((TypeDescription)value);
                    typeDescription = TypeDescription.CLASS;
                } else if (value instanceof String) {
                    stackManipulation = new TextConstant((String)value);
                    typeDescription = TypeDescription.STRING;
                } else if (value instanceof JavaConstant) {
                    stackManipulation = ((JavaConstant)value).asStackManipulation();
                    typeDescription = ((JavaConstant)value).getType();
                } else {
                    throw new IllegalStateException("Not a constant value: " + value);
                }
                StackManipulation assignment = assigner.assign(typeDescription.asGenericType(), target.getType(), Assigner.Typing.STATIC);
                if (!assignment.isValid()) {
                    throw new IllegalStateException("Cannot assign constant of type " + typeDescription + " to " + target.getType());
                }
                return new StackManipulation.Compound(stackManipulation, assignment);
            }

            protected abstract Object doResolve(TypeDescription var1, MethodDescription var2, ParameterDescription.InDefinedShape var3, AnnotationDescription.Loadable<S> var4, Assigner var5, boolean var6);

            protected static class OfAnnotationProperty
            extends ForFixedValue<Annotation> {
                private final MethodDescription.InDefinedShape property;

                protected OfAnnotationProperty(MethodDescription.InDefinedShape property) {
                    this.property = property;
                }

                protected static <T extends Annotation> DynamicValue<T> of(Class<? extends T> type, String property) {
                    return new OfAnnotationProperty((MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(type).getDeclaredMethods().filter(ElementMatchers.named(property))).getOnly());
                }

                @Override
                protected Object doResolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Annotation> annotation, Assigner assigner, boolean initialized) {
                    return annotation.getValue(this.property).resolve();
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    OfAnnotationProperty that = (OfAnnotationProperty)object;
                    return this.property.equals(that.property);
                }

                public int hashCode() {
                    return this.property.hashCode();
                }

                public String toString() {
                    return "Advice.DynamicValue.ForFixedValue.OfAnnotationProperty{property=" + this.property + '}';
                }
            }

            protected static class OfConstant
            extends ForFixedValue<Annotation> {
                private final Object value;

                protected OfConstant(Object value) {
                    this.value = value;
                }

                @Override
                protected Object doResolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Annotation> annotation, Assigner assigner, boolean initialized) {
                    if (this.value == null) {
                        return null;
                    }
                    if (this.value instanceof Class) {
                        return new TypeDescription.ForLoadedType((Class)this.value);
                    }
                    if (JavaType.METHOD_HANDLE.getTypeStub().isInstance(this.value)) {
                        return JavaConstant.MethodHandle.ofLoaded(this.value);
                    }
                    if (JavaType.METHOD_TYPE.getTypeStub().isInstance(this.value)) {
                        return JavaConstant.MethodType.ofLoaded(this.value);
                    }
                    return this.value;
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    OfConstant that = (OfConstant)object;
                    return this.value.equals(that.value);
                }

                public int hashCode() {
                    return this.value.hashCode();
                }

                public String toString() {
                    return "Advice.DynamicValue.ForFixedValue.OfConstant{value=" + this.value + '}';
                }
            }
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Unused {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface StubValue {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Enter {
        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Origin {
        public static final String DEFAULT = "";

        public String value() default "";
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface FieldValue {
        public String value();

        public Class<?> declaringType() default void.class;

        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Thrown {
        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.DYNAMIC;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Return {
        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface AllArguments {
        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Argument {
        public int value();

        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface This {
        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;

        public boolean optional() default false;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface OnMethodExit {
        public boolean inline() default true;

        public Class<? extends Throwable> suppress() default NoExceptionHandler.class;

        public Class<? extends Throwable> onThrowable() default NoExceptionHandler.class;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface OnMethodEnter {
        public boolean inline() default true;

        public Class<? extends Throwable> suppress() default NoExceptionHandler.class;

        public Class<?> skipOn() default void.class;

        public boolean prependLineNumber() default true;
    }

    protected static class Appender
    implements ByteCodeAppender {
        private final Advice advice;
        private final Implementation.Target implementationTarget;
        private final ByteCodeAppender delegate;

        protected Appender(Advice advice, Implementation.Target implementationTarget, ByteCodeAppender delegate) {
            this.advice = advice;
            this.implementationTarget = implementationTarget;
            this.delegate = delegate;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            EmulatingMethodVisitor emulatingMethodVisitor = new EmulatingMethodVisitor(methodVisitor, this.delegate);
            methodVisitor = this.advice.doWrap(this.implementationTarget.getInstrumentedType(), instrumentedMethod, emulatingMethodVisitor, implementationContext, 0, 0);
            return emulatingMethodVisitor.resolve(methodVisitor, implementationContext, instrumentedMethod);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Appender appender = (Appender)other;
            return this.advice.equals(appender.advice) && this.delegate.equals(appender.delegate) && this.implementationTarget.equals(appender.implementationTarget);
        }

        public int hashCode() {
            int result = this.advice.hashCode();
            result = 31 * result + this.implementationTarget.hashCode();
            result = 31 * result + this.delegate.hashCode();
            return result;
        }

        public String toString() {
            return "Advice.Appender{advice=" + this.advice + ", implementationTarget=" + this.implementationTarget + ", delegate=" + this.delegate + '}';
        }

        protected static class EmulatingMethodVisitor
        extends MethodVisitor {
            private final ByteCodeAppender delegate;
            private int stackSize;
            private int localVariableLength;

            protected EmulatingMethodVisitor(MethodVisitor methodVisitor, ByteCodeAppender delegate) {
                super(327680, methodVisitor);
                this.delegate = delegate;
            }

            protected ByteCodeAppender.Size resolve(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                methodVisitor.visitCode();
                ByteCodeAppender.Size size = this.delegate.apply(methodVisitor, implementationContext, instrumentedMethod);
                methodVisitor.visitMaxs(size.getOperandStackSize(), size.getLocalVariableSize());
                methodVisitor.visitEnd();
                return new ByteCodeAppender.Size(this.stackSize, this.localVariableLength);
            }

            @Override
            public void visitCode() {
            }

            @Override
            public void visitMaxs(int stackSize, int localVariableLength) {
                this.stackSize = stackSize;
                this.localVariableLength = localVariableLength;
            }

            @Override
            public void visitEnd() {
            }

            public String toString() {
                return "Advice.Appender.EmulatingMethodVisitor{delegate=" + this.delegate + ", stackSize=" + this.stackSize + ", localVariableLength=" + this.localVariableLength + '}';
            }
        }
    }

    protected static abstract class AdviceVisitor
    extends ExceptionTableSensitiveMethodVisitor
    implements Dispatcher.Bound.SkipHandler {
        private static final int NO_OFFSET = 0;
        protected final MethodVisitor methodVisitor;
        protected final MethodDescription instrumentedMethod;
        private final int padding;
        private final Dispatcher.Bound.ForMethodEnter methodEnter;
        protected final Dispatcher.Bound.ForMethodExit methodExit;
        protected final MethodSizeHandler.ForInstrumentedMethod methodSizeHandler;
        protected final StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler;

        protected AdviceVisitor(MethodVisitor methodVisitor, MethodVisitor delegate, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, List<? extends TypeDescription> yieldedTypes, int writerFlags, int readerFlags) {
            super(327680, delegate);
            this.methodVisitor = methodVisitor;
            this.instrumentedMethod = instrumentedMethod;
            this.padding = methodEnter.getEnterType().getStackSize().getSize();
            List requiredTypes = methodEnter.getEnterType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(methodEnter.getEnterType().asErasure());
            this.methodSizeHandler = MethodSizeHandler.Default.of(instrumentedMethod, requiredTypes, yieldedTypes, writerFlags);
            this.stackMapFrameHandler = StackMapFrameHandler.Default.of(instrumentedType, instrumentedMethod, requiredTypes, yieldedTypes, implementationContext.getClassFileVersion(), writerFlags, readerFlags);
            this.methodEnter = methodEnter.bind(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, this.methodSizeHandler, this.stackMapFrameHandler, exceptionHandler);
            this.methodExit = methodExit.bind(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, this.methodSizeHandler, this.stackMapFrameHandler, exceptionHandler);
        }

        @Override
        protected void onAfterExceptionTable() {
            this.methodEnter.prepare();
            this.onUserPrepare();
            this.methodExit.prepare();
            this.methodEnter.apply(this);
            this.onUserStart();
        }

        protected abstract void onUserPrepare();

        protected abstract void onUserStart();

        @Override
        protected void onVisitVarInsn(int opcode, int offset) {
            this.mv.visitVarInsn(opcode, this.resolve(offset));
        }

        @Override
        protected void onVisitIincInsn(int offset, int increment) {
            this.mv.visitIincInsn(this.resolve(offset), increment);
        }

        protected void variable(int opcode) {
            this.variable(opcode, 0);
        }

        protected void variable(int opcode, int offset) {
            this.methodVisitor.visitVarInsn(opcode, this.instrumentedMethod.getStackSize() + this.padding + offset);
        }

        @Override
        public void visitFrame(int frameType, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
            this.stackMapFrameHandler.translateFrame(this.methodVisitor, frameType, localVariableLength, localVariable, stackSize, stack);
        }

        @Override
        public void visitMaxs(int stackSize, int localVariableLength) {
            this.onUserEnd();
            this.methodVisitor.visitMaxs(this.methodSizeHandler.compoundStackSize(stackSize), this.methodSizeHandler.compoundLocalVariableLength(localVariableLength));
        }

        @Override
        public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
            this.mv.visitLocalVariable(name, descriptor, signature, start, end, this.resolve(index));
        }

        @Override
        public AnnotationVisitor visitLocalVariableAnnotation(int typeReference, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
            return this.mv.visitLocalVariableAnnotation(typeReference, typePath, start, end, this.resolve(index), descriptor, visible);
        }

        private int[] resolve(int[] index) {
            int[] resolved = new int[index.length];
            for (int anIndex = 0; anIndex < index.length; ++anIndex) {
                resolved[anIndex] = this.resolve(index[anIndex]);
            }
            return resolved;
        }

        private int resolve(int index) {
            return index < this.instrumentedMethod.getStackSize() ? index : this.padding + index;
        }

        protected abstract void onUserEnd();

        protected static abstract class WithExitAdvice
        extends AdviceVisitor {
            protected final Label returnHandler = new Label();
            protected boolean doesReturn = false;

            protected WithExitAdvice(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, List<? extends TypeDescription> yieldedTypes, int writerFlags, int readerFlags) {
                super(methodVisitor, new StackAwareMethodVisitor(methodVisitor, instrumentedMethod), implementationContext, assigner, exceptionHandler, instrumentedType, instrumentedMethod, methodEnter, methodExit, yieldedTypes, writerFlags, readerFlags);
            }

            @Override
            public void apply(MethodVisitor methodVisitor) {
                if (this.instrumentedMethod.getReturnType().represents(Boolean.TYPE) || this.instrumentedMethod.getReturnType().represents(Byte.TYPE) || this.instrumentedMethod.getReturnType().represents(Short.TYPE) || this.instrumentedMethod.getReturnType().represents(Character.TYPE) || this.instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                    methodVisitor.visitInsn(3);
                } else if (this.instrumentedMethod.getReturnType().represents(Long.TYPE)) {
                    methodVisitor.visitInsn(9);
                } else if (this.instrumentedMethod.getReturnType().represents(Float.TYPE)) {
                    methodVisitor.visitInsn(11);
                } else if (this.instrumentedMethod.getReturnType().represents(Double.TYPE)) {
                    methodVisitor.visitInsn(14);
                } else if (!this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                    methodVisitor.visitInsn(1);
                }
                methodVisitor.visitJumpInsn(167, this.returnHandler);
                this.doesReturn = true;
            }

            @Override
            protected void onVisitInsn(int opcode) {
                switch (opcode) {
                    case 177: {
                        ((StackAwareMethodVisitor)this.mv).drainStack();
                        break;
                    }
                    case 172: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(54, 21, StackSize.SINGLE));
                        break;
                    }
                    case 174: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(56, 23, StackSize.SINGLE));
                        break;
                    }
                    case 175: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(57, 24, StackSize.DOUBLE));
                        break;
                    }
                    case 173: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(55, 22, StackSize.DOUBLE));
                        break;
                    }
                    case 176: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(58, 25, StackSize.SINGLE));
                        break;
                    }
                    default: {
                        this.mv.visitInsn(opcode);
                        return;
                    }
                }
                this.mv.visitJumpInsn(167, this.returnHandler);
                this.doesReturn = true;
            }

            @Override
            protected void onUserEnd() {
                Type returnType = Type.getType(this.instrumentedMethod.getReturnType().asErasure().getDescriptor());
                this.methodVisitor.visitLabel(this.returnHandler);
                if (this.doesReturn) {
                    this.stackMapFrameHandler.injectReturnFrame(this.methodVisitor);
                    if (!returnType.equals(Type.VOID_TYPE)) {
                        this.variable(returnType.getOpcode(54));
                    }
                }
                this.onUserReturn();
                this.methodExit.apply();
                this.onExitAdviceReturn();
                if (returnType.equals(Type.VOID_TYPE)) {
                    this.methodVisitor.visitInsn(177);
                } else {
                    this.variable(returnType.getOpcode(21));
                    this.methodVisitor.visitInsn(returnType.getOpcode(172));
                }
            }

            protected abstract void onUserReturn();

            protected abstract void onExitAdviceReturn();

            protected static class WithExceptionHandling
            extends WithExitAdvice {
                private final TypeDescription throwable;
                private final Label userStart;
                private final Label exceptionHandler;

                protected WithExceptionHandling(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, int writerFlags, int readerFlags, TypeDescription throwable) {
                    super(methodVisitor, implementationContext, assigner, exceptionHandler, instrumentedType, instrumentedMethod, methodEnter, methodExit, instrumentedMethod.getReturnType().represents(Void.TYPE) ? Collections.singletonList(TypeDescription.THROWABLE) : Arrays.asList(instrumentedMethod.getReturnType().asErasure(), TypeDescription.THROWABLE), writerFlags, readerFlags);
                    this.throwable = throwable;
                    this.userStart = new Label();
                    this.exceptionHandler = new Label();
                }

                @Override
                protected void onUserPrepare() {
                    this.methodVisitor.visitTryCatchBlock(this.userStart, this.returnHandler, this.exceptionHandler, this.throwable.getInternalName());
                }

                @Override
                protected void onUserStart() {
                    this.methodVisitor.visitLabel(this.userStart);
                }

                @Override
                protected void onUserReturn() {
                    Label endOfHandler = new Label();
                    if (this.doesReturn) {
                        this.methodVisitor.visitInsn(1);
                        this.variable(58, this.instrumentedMethod.getReturnType().getStackSize().getSize());
                        this.methodVisitor.visitJumpInsn(167, endOfHandler);
                    }
                    this.methodVisitor.visitLabel(this.exceptionHandler);
                    this.stackMapFrameHandler.injectExceptionFrame(this.methodVisitor);
                    this.variable(58, this.instrumentedMethod.getReturnType().getStackSize().getSize());
                    this.storeDefaultReturn();
                    if (this.doesReturn) {
                        this.methodVisitor.visitLabel(endOfHandler);
                    }
                    this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, false);
                }

                @Override
                protected void onExitAdviceReturn() {
                    this.variable(25, this.instrumentedMethod.getReturnType().getStackSize().getSize());
                    Label endOfHandler = new Label();
                    this.methodVisitor.visitJumpInsn(198, endOfHandler);
                    this.variable(25, this.instrumentedMethod.getReturnType().getStackSize().getSize());
                    this.methodVisitor.visitInsn(191);
                    this.methodVisitor.visitLabel(endOfHandler);
                    this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, true);
                }

                private void storeDefaultReturn() {
                    if (this.instrumentedMethod.getReturnType().represents(Boolean.TYPE) || this.instrumentedMethod.getReturnType().represents(Byte.TYPE) || this.instrumentedMethod.getReturnType().represents(Short.TYPE) || this.instrumentedMethod.getReturnType().represents(Character.TYPE) || this.instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                        this.methodVisitor.visitInsn(3);
                        this.variable(54);
                    } else if (this.instrumentedMethod.getReturnType().represents(Long.TYPE)) {
                        this.methodVisitor.visitInsn(9);
                        this.variable(55);
                    } else if (this.instrumentedMethod.getReturnType().represents(Float.TYPE)) {
                        this.methodVisitor.visitInsn(11);
                        this.variable(56);
                    } else if (this.instrumentedMethod.getReturnType().represents(Double.TYPE)) {
                        this.methodVisitor.visitInsn(14);
                        this.variable(57);
                    } else if (!this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        this.methodVisitor.visitInsn(1);
                        this.variable(58);
                    }
                }

                public String toString() {
                    return "Advice.AdviceVisitor.WithExitAdvice.WithExceptionHandling{instrumentedMethod=" + this.instrumentedMethod + ", throwable=" + this.throwable + ", doesReturn=" + this.doesReturn + "}";
                }
            }

            protected static class WithoutExceptionHandling
            extends WithExitAdvice {
                protected WithoutExceptionHandling(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, int writerFlags, int readerFlags) {
                    super(methodVisitor, implementationContext, assigner, exceptionHandler, instrumentedType, instrumentedMethod, methodEnter, methodExit, instrumentedMethod.getReturnType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(instrumentedMethod.getReturnType().asErasure()), writerFlags, readerFlags);
                }

                @Override
                protected void onUserPrepare() {
                }

                @Override
                protected void onUserStart() {
                }

                @Override
                protected void onUserReturn() {
                    if (!this.doesReturn || !this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, false);
                    }
                }

                @Override
                protected void onExitAdviceReturn() {
                }

                public String toString() {
                    return "Advice.AdviceVisitor.WithExitAdvice.WithoutExceptionHandling{instrumentedMethod=" + this.instrumentedMethod + ", doesReturn=" + this.doesReturn + "}";
                }
            }
        }

        protected static class WithoutExitAdvice
        extends AdviceVisitor {
            protected WithoutExitAdvice(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, int writerFlags, int readerFlags) {
                super(methodVisitor, methodVisitor, implementationContext, assigner, exceptionHandler, instrumentedType, instrumentedMethod, methodEnter, Dispatcher.Inactive.INSTANCE, Collections.emptyList(), writerFlags, readerFlags);
            }

            @Override
            protected void onUserPrepare() {
            }

            @Override
            protected void onUserStart() {
            }

            @Override
            protected void onUserEnd() {
            }

            @Override
            public void apply(MethodVisitor methodVisitor) {
                if (this.instrumentedMethod.getReturnType().represents(Boolean.TYPE) || this.instrumentedMethod.getReturnType().represents(Byte.TYPE) || this.instrumentedMethod.getReturnType().represents(Short.TYPE) || this.instrumentedMethod.getReturnType().represents(Character.TYPE) || this.instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                    methodVisitor.visitInsn(3);
                    methodVisitor.visitInsn(172);
                } else if (this.instrumentedMethod.getReturnType().represents(Long.TYPE)) {
                    methodVisitor.visitInsn(9);
                    methodVisitor.visitInsn(173);
                } else if (this.instrumentedMethod.getReturnType().represents(Float.TYPE)) {
                    methodVisitor.visitInsn(11);
                    methodVisitor.visitInsn(174);
                } else if (this.instrumentedMethod.getReturnType().represents(Double.TYPE)) {
                    methodVisitor.visitInsn(14);
                    methodVisitor.visitInsn(175);
                } else if (this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                    methodVisitor.visitInsn(177);
                } else {
                    methodVisitor.visitInsn(1);
                    methodVisitor.visitInsn(176);
                }
            }

            public String toString() {
                return "Advice.AdviceVisitor.WithoutExitAdvice{, instrumentedMethod=" + this.instrumentedMethod + "}";
            }
        }
    }

    protected static interface Dispatcher {
        public static final MethodVisitor IGNORE_METHOD = null;
        public static final AnnotationVisitor IGNORE_ANNOTATION = null;

        public boolean isAlive();

        public static class Delegating
        implements Unresolved {
            protected final MethodDescription.InDefinedShape adviceMethod;

            protected Delegating(MethodDescription.InDefinedShape adviceMethod) {
                this.adviceMethod = adviceMethod;
            }

            @Override
            public boolean isAlive() {
                return true;
            }

            @Override
            public boolean isBinary() {
                return false;
            }

            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader) {
                return new Resolved.ForMethodEnter(this.adviceMethod, userFactories);
            }

            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit asMethodExitTo(List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader, net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter dispatcher) {
                return Resolved.ForMethodExit.of(this.adviceMethod, userFactories, dispatcher.getEnterType());
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.adviceMethod.equals(((Delegating)other).adviceMethod);
            }

            public int hashCode() {
                return this.adviceMethod.hashCode();
            }

            public String toString() {
                return "Advice.Dispatcher.Delegating{adviceMethod=" + this.adviceMethod + '}';
            }

            protected static abstract class Resolved<T extends Bound>
            implements net.bytebuddy.asm.Advice$Dispatcher$Resolved {
                private static final boolean READ_ONLY = true;
                protected final MethodDescription.InDefinedShape adviceMethod;
                protected final List<OffsetMapping> offsetMappings;
                protected final SuppressionHandler suppressionHandler;

                protected Resolved(MethodDescription.InDefinedShape adviceMethod, List<OffsetMapping.Factory> factories, TypeDescription throwableType) {
                    this.adviceMethod = adviceMethod;
                    this.offsetMappings = new ArrayList<OffsetMapping>(adviceMethod.getParameters().size());
                    for (ParameterDescription.InDefinedShape parameterDescription : adviceMethod.getParameters()) {
                        OffsetMapping offsetMapping = OffsetMapping.Factory.UNDEFINED;
                        for (OffsetMapping.Factory factory : factories) {
                            OffsetMapping possible = factory.make(parameterDescription);
                            if (possible == null) continue;
                            if (offsetMapping == null) {
                                offsetMapping = possible;
                                continue;
                            }
                            throw new IllegalStateException(parameterDescription + " is bound to both " + possible + " and " + offsetMapping);
                        }
                        this.offsetMappings.add(offsetMapping == null ? new OffsetMapping.ForArgument(parameterDescription, true, Assigner.Typing.STATIC) : offsetMapping);
                    }
                    this.suppressionHandler = SuppressionHandler.Suppressing.of(throwableType);
                }

                @Override
                public boolean isAlive() {
                    return true;
                }

                public T bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler) {
                    if (!this.adviceMethod.isVisibleTo(instrumentedType)) {
                        throw new IllegalStateException(this.adviceMethod + " is not visible to " + instrumentedMethod.getDeclaringType());
                    }
                    return this.resolve(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, methodSizeHandler, stackMapFrameHandler, exceptionHandler);
                }

                protected abstract T resolve(TypeDescription var1, MethodDescription var2, MethodVisitor var3, Implementation.Context var4, Assigner var5, MethodSizeHandler.ForInstrumentedMethod var6, StackMapFrameHandler.ForInstrumentedMethod var7, StackManipulation var8);

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Resolved resolved = (Resolved)other;
                    return this.adviceMethod.equals(resolved.adviceMethod) && this.offsetMappings.equals(resolved.offsetMappings);
                }

                public int hashCode() {
                    int result = this.adviceMethod.hashCode();
                    result = 31 * result + this.offsetMappings.hashCode();
                    return result;
                }

                protected static abstract class ForMethodExit
                extends Resolved<Bound.ForMethodExit>
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit {
                    private final TypeDefinition enterType;

                    protected ForMethodExit(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories, TypeDefinition enterType) {
                        super(adviceMethod, CompoundList.of(Arrays.asList(OffsetMapping.ForArgument.Factory.READ_ONLY, OffsetMapping.ForAllArguments.Factory.READ_ONLY, OffsetMapping.ForThisReference.Factory.READ_ONLY, OffsetMapping.ForField.Factory.READ_ONLY, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForUnusedValue.Factory.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, new OffsetMapping.ForEnterValue.Factory(enterType, true), OffsetMapping.ForReturnValue.Factory.READ_ONLY, OffsetMapping.ForThrowable.Factory.of(adviceMethod, true)), userFactories), adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(SUPPRESS_EXIT).resolve(TypeDescription.class));
                        this.enterType = enterType;
                    }

                    protected static net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit of(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories, TypeDefinition enterType) {
                        TypeDescription throwable = adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(ON_THROWABLE).resolve(TypeDescription.class);
                        return throwable.represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class)) ? new WithoutExceptionHandler(adviceMethod, userFactories, enterType) : new WithExceptionHandler(adviceMethod, userFactories, enterType, throwable);
                    }

                    @Override
                    protected Bound.ForMethodExit resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler) {
                        ArrayList<OffsetMapping.Target> offsetMappings = new ArrayList<OffsetMapping.Target>(this.offsetMappings.size());
                        for (OffsetMapping offsetMapping : this.offsetMappings) {
                            offsetMappings.add(offsetMapping.resolve(instrumentedType, instrumentedMethod, assigner, OffsetMapping.Context.ForMethodExit.of(this.enterType)));
                        }
                        return new AdviceMethodWriter.ForMethodExit(this.adviceMethod, instrumentedMethod, offsetMappings, methodVisitor, implementationContext, methodSizeHandler.bindExit(this.adviceMethod, this.getThrowable().represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class))), stackMapFrameHandler.bindExit(this.adviceMethod), this.suppressionHandler.bind(exceptionHandler));
                    }

                    @Override
                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.enterType == ((ForMethodExit)other).enterType;
                    }

                    @Override
                    public int hashCode() {
                        int result = super.hashCode();
                        result = 31 * result + this.enterType.hashCode();
                        return result;
                    }

                    protected static class WithoutExceptionHandler
                    extends ForMethodExit {
                        protected WithoutExceptionHandler(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories, TypeDefinition enterType) {
                            super(adviceMethod, userFactories, enterType);
                        }

                        @Override
                        public TypeDescription getThrowable() {
                            return NoExceptionHandler.DESCRIPTION;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Delegating.Resolved.ForMethodExit.WithoutExceptionHandler{adviceMethod=" + this.adviceMethod + ", offsetMappings=" + this.offsetMappings + '}';
                        }
                    }

                    protected static class WithExceptionHandler
                    extends ForMethodExit {
                        private final TypeDescription throwable;

                        protected WithExceptionHandler(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories, TypeDefinition enterType, TypeDescription throwable) {
                            super(adviceMethod, userFactories, enterType);
                            this.throwable = throwable;
                        }

                        @Override
                        public TypeDescription getThrowable() {
                            return this.throwable;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Delegating.Resolved.ForMethodExit.WithExceptionHandler{adviceMethod=" + this.adviceMethod + ", offsetMappings=" + this.offsetMappings + ", throwable=" + this.throwable + '}';
                        }
                    }
                }

                protected static class ForMethodEnter
                extends Resolved<Bound.ForMethodEnter>
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter {
                    private final Resolved.ForMethodEnter.SkipDispatcher skipDispatcher;
                    private final boolean prependLineNumber;

                    protected ForMethodEnter(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories) {
                        super(adviceMethod, CompoundList.of(Arrays.asList(OffsetMapping.ForArgument.Factory.READ_ONLY, OffsetMapping.ForAllArguments.Factory.READ_ONLY, OffsetMapping.ForThisReference.Factory.READ_ONLY, OffsetMapping.ForField.Factory.READ_ONLY, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForUnusedValue.Factory.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, new OffsetMapping.Illegal(Thrown.class, Enter.class, Return.class)), userFactories), adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SUPPRESS_ENTER).resolve(TypeDescription.class));
                        this.skipDispatcher = Resolved.ForMethodEnter.SkipDispatcher.ForType.of(adviceMethod);
                        this.prependLineNumber = adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(PREPEND_LINE_NUMBER).resolve(Boolean.class);
                    }

                    @Override
                    public TypeDefinition getEnterType() {
                        return this.adviceMethod.getReturnType();
                    }

                    @Override
                    public boolean isPrependLineNumber() {
                        return this.prependLineNumber;
                    }

                    @Override
                    protected Bound.ForMethodEnter resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler) {
                        ArrayList<OffsetMapping.Target> offsetMappings = new ArrayList<OffsetMapping.Target>(this.offsetMappings.size());
                        for (OffsetMapping offsetMapping : this.offsetMappings) {
                            offsetMappings.add(offsetMapping.resolve(instrumentedType, instrumentedMethod, assigner, OffsetMapping.Context.ForMethodEntry.of(instrumentedMethod)));
                        }
                        return new AdviceMethodWriter.ForMethodEnter(this.adviceMethod, instrumentedMethod, offsetMappings, methodVisitor, implementationContext, methodSizeHandler.bindEntry(this.adviceMethod), stackMapFrameHandler.bindEntry(this.adviceMethod), this.suppressionHandler.bind(exceptionHandler), this.skipDispatcher);
                    }

                    @Override
                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        if (!super.equals(other)) {
                            return false;
                        }
                        ForMethodEnter that = (ForMethodEnter)other;
                        return this.skipDispatcher == that.skipDispatcher && this.prependLineNumber == that.prependLineNumber;
                    }

                    @Override
                    public int hashCode() {
                        int result = super.hashCode();
                        result = 31 * result + this.skipDispatcher.hashCode();
                        result = 31 * result + (this.prependLineNumber ? 1 : 0);
                        return result;
                    }

                    public String toString() {
                        return "Advice.Dispatcher.Delegating.Resolved.ForMethodEnter{adviceMethod=" + this.adviceMethod + ", offsetMappings=" + this.offsetMappings + ", skipDispatcher=" + this.skipDispatcher + ", prependLineNumber=" + this.prependLineNumber + '}';
                    }
                }

                protected static abstract class AdviceMethodWriter
                implements Bound,
                SuppressionHandler.ReturnValueProducer {
                    private static final int EMPTY = 0;
                    protected final MethodDescription.InDefinedShape adviceMethod;
                    protected final MethodDescription instrumentedMethod;
                    private final List<OffsetMapping.Target> offsetMappings;
                    protected final MethodVisitor methodVisitor;
                    protected final Implementation.Context implementationContext;
                    protected final MethodSizeHandler.ForAdvice methodSizeHandler;
                    protected final StackMapFrameHandler.ForAdvice stackMapFrameHandler;
                    private final SuppressionHandler.Bound suppressionHandler;

                    protected AdviceMethodWriter(MethodDescription.InDefinedShape adviceMethod, MethodDescription instrumentedMethod, List<OffsetMapping.Target> offsetMappings, MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler) {
                        this.adviceMethod = adviceMethod;
                        this.instrumentedMethod = instrumentedMethod;
                        this.offsetMappings = offsetMappings;
                        this.methodVisitor = methodVisitor;
                        this.implementationContext = implementationContext;
                        this.methodSizeHandler = methodSizeHandler;
                        this.stackMapFrameHandler = stackMapFrameHandler;
                        this.suppressionHandler = suppressionHandler;
                    }

                    @Override
                    public void prepare() {
                        this.suppressionHandler.onPrepare(this.methodVisitor);
                    }

                    protected void doApply() {
                        this.suppressionHandler.onStart(this.methodVisitor);
                        int index = 0;
                        int currentStackSize = 0;
                        int maximumStackSize = 0;
                        for (OffsetMapping.Target offsetMapping : this.offsetMappings) {
                            maximumStackSize = Math.max(maximumStackSize, (currentStackSize += ((ParameterDescription.InDefinedShape)this.adviceMethod.getParameters().get(index++)).getType().getStackSize().getSize()) + offsetMapping.resolveRead().apply(this.methodVisitor, this.implementationContext).getMaximalSize());
                        }
                        this.methodVisitor.visitMethodInsn(184, this.adviceMethod.getDeclaringType().getInternalName(), this.adviceMethod.getInternalName(), this.adviceMethod.getDescriptor(), false);
                        this.onMethodReturn();
                        this.suppressionHandler.onEndSkipped(this.methodVisitor, this.implementationContext, this.methodSizeHandler, this.stackMapFrameHandler, this);
                        this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, false);
                        this.methodSizeHandler.recordMaxima(Math.max(maximumStackSize, this.adviceMethod.getReturnType().getStackSize().getSize()), 0);
                    }

                    protected abstract void onMethodReturn();

                    public String toString() {
                        return "Advice.Dispatcher.Delegating.Resolved.AdviceMethodWriter{instrumentedMethod=" + this.instrumentedMethod + ", methodVisitor=" + this.methodVisitor + ", methodSizeHandler=" + this.methodSizeHandler + ", stackMapFrameHandler=" + this.stackMapFrameHandler + ", suppressionHandler=" + this.suppressionHandler + '}';
                    }

                    protected static class ForMethodExit
                    extends AdviceMethodWriter
                    implements Bound.ForMethodExit {
                        protected ForMethodExit(MethodDescription.InDefinedShape adviceMethod, MethodDescription instrumentedMethod, List<OffsetMapping.Target> offsetMappings, MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler) {
                            super(adviceMethod, instrumentedMethod, offsetMappings, methodVisitor, implementationContext, methodSizeHandler, stackMapFrameHandler, suppressionHandler);
                        }

                        @Override
                        public void apply() {
                            this.doApply();
                        }

                        @Override
                        protected void onMethodReturn() {
                            switch (this.adviceMethod.getReturnType().getStackSize()) {
                                case ZERO: {
                                    return;
                                }
                                case SINGLE: {
                                    this.methodVisitor.visitInsn(87);
                                    return;
                                }
                                case DOUBLE: {
                                    this.methodVisitor.visitInsn(88);
                                    return;
                                }
                            }
                            throw new IllegalStateException("Unexpected size: " + (Object)((Object)this.adviceMethod.getReturnType().getStackSize()));
                        }

                        @Override
                        public void onDefaultValue(MethodVisitor methodVisitor) {
                        }

                        @Override
                        public String toString() {
                            return "Advice.Dispatcher.Delegating.Resolved.AdviceMethodWriter.ForMethodExit{instrumentedMethod=" + this.instrumentedMethod + ", adviceMethod=" + this.adviceMethod + "}";
                        }
                    }

                    protected static class ForMethodEnter
                    extends AdviceMethodWriter
                    implements Bound.ForMethodEnter {
                        private final Resolved.ForMethodEnter.SkipDispatcher skipDispatcher;

                        protected ForMethodEnter(MethodDescription.InDefinedShape adviceMethod, MethodDescription instrumentedMethod, List<OffsetMapping.Target> offsetMappings, MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, Resolved.ForMethodEnter.SkipDispatcher skipDispatcher) {
                            super(adviceMethod, instrumentedMethod, offsetMappings, methodVisitor, implementationContext, methodSizeHandler, stackMapFrameHandler, suppressionHandler);
                            this.skipDispatcher = skipDispatcher;
                        }

                        @Override
                        protected void onMethodReturn() {
                            if (this.adviceMethod.getReturnType().represents(Boolean.TYPE) || this.adviceMethod.getReturnType().represents(Byte.TYPE) || this.adviceMethod.getReturnType().represents(Short.TYPE) || this.adviceMethod.getReturnType().represents(Character.TYPE) || this.adviceMethod.getReturnType().represents(Integer.TYPE)) {
                                this.methodVisitor.visitVarInsn(54, this.instrumentedMethod.getStackSize());
                            } else if (this.adviceMethod.getReturnType().represents(Long.TYPE)) {
                                this.methodVisitor.visitVarInsn(55, this.instrumentedMethod.getStackSize());
                            } else if (this.adviceMethod.getReturnType().represents(Float.TYPE)) {
                                this.methodVisitor.visitVarInsn(56, this.instrumentedMethod.getStackSize());
                            } else if (this.adviceMethod.getReturnType().represents(Double.TYPE)) {
                                this.methodVisitor.visitVarInsn(57, this.instrumentedMethod.getStackSize());
                            } else if (!this.adviceMethod.getReturnType().represents(Void.TYPE)) {
                                this.methodVisitor.visitVarInsn(58, this.instrumentedMethod.getStackSize());
                            }
                        }

                        @Override
                        public void apply(Bound.SkipHandler skipHandler) {
                            this.doApply();
                            this.skipDispatcher.apply(this.methodVisitor, this.methodSizeHandler, this.stackMapFrameHandler, this.instrumentedMethod, skipHandler);
                        }

                        @Override
                        public void onDefaultValue(MethodVisitor methodVisitor) {
                            if (this.adviceMethod.getReturnType().represents(Boolean.TYPE) || this.adviceMethod.getReturnType().represents(Byte.TYPE) || this.adviceMethod.getReturnType().represents(Short.TYPE) || this.adviceMethod.getReturnType().represents(Character.TYPE) || this.adviceMethod.getReturnType().represents(Integer.TYPE)) {
                                methodVisitor.visitInsn(3);
                                methodVisitor.visitVarInsn(54, this.instrumentedMethod.getStackSize());
                            } else if (this.adviceMethod.getReturnType().represents(Long.TYPE)) {
                                methodVisitor.visitInsn(9);
                                methodVisitor.visitVarInsn(55, this.instrumentedMethod.getStackSize());
                            } else if (this.adviceMethod.getReturnType().represents(Float.TYPE)) {
                                methodVisitor.visitInsn(11);
                                methodVisitor.visitVarInsn(56, this.instrumentedMethod.getStackSize());
                            } else if (this.adviceMethod.getReturnType().represents(Double.TYPE)) {
                                methodVisitor.visitInsn(14);
                                methodVisitor.visitVarInsn(57, this.instrumentedMethod.getStackSize());
                            } else if (!this.adviceMethod.getReturnType().represents(Void.TYPE)) {
                                methodVisitor.visitInsn(1);
                                methodVisitor.visitVarInsn(58, this.instrumentedMethod.getStackSize());
                            }
                        }

                        @Override
                        public String toString() {
                            return "Advice.Dispatcher.Delegating.Resolved.AdviceMethodWriter.ForMethodEnter{instrumentedMethod=" + this.instrumentedMethod + ", adviceMethod=" + this.adviceMethod + "}";
                        }
                    }
                }
            }
        }

        public static class Inlining
        implements Unresolved {
            protected final MethodDescription.InDefinedShape adviceMethod;

            protected Inlining(MethodDescription.InDefinedShape adviceMethod) {
                this.adviceMethod = adviceMethod;
            }

            @Override
            public boolean isAlive() {
                return true;
            }

            @Override
            public boolean isBinary() {
                return true;
            }

            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader) {
                return new Resolved.ForMethodEnter(this.adviceMethod, userFactories, classReader);
            }

            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit asMethodExitTo(List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader, net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter dispatcher) {
                return Resolved.ForMethodExit.of(this.adviceMethod, userFactories, classReader, dispatcher.getEnterType());
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.adviceMethod.equals(((Inlining)other).adviceMethod);
            }

            public int hashCode() {
                return this.adviceMethod.hashCode();
            }

            public String toString() {
                return "Advice.Dispatcher.Inlining{adviceMethod=" + this.adviceMethod + '}';
            }

            protected static abstract class CodeTranslationVisitor
            extends MethodVisitor
            implements SuppressionHandler.ReturnValueProducer {
                protected final MethodVisitor methodVisitor;
                protected final Implementation.Context implementationContext;
                protected final MethodSizeHandler.ForAdvice methodSizeHandler;
                protected final StackMapFrameHandler.ForAdvice stackMapFrameHandler;
                protected final MethodDescription instrumentedMethod;
                protected final MethodDescription.InDefinedShape adviceMethod;
                private final Map<Integer, OffsetMapping.Target> offsetMappings;
                private final SuppressionHandler.Bound suppressionHandler;
                protected final Label endOfMethod;

                protected CodeTranslationVisitor(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, MethodDescription.InDefinedShape adviceMethod, Map<Integer, OffsetMapping.Target> offsetMappings, SuppressionHandler.Bound suppressionHandler) {
                    super(327680, new StackAwareMethodVisitor(methodVisitor, instrumentedMethod));
                    this.methodVisitor = methodVisitor;
                    this.implementationContext = implementationContext;
                    this.methodSizeHandler = methodSizeHandler;
                    this.stackMapFrameHandler = stackMapFrameHandler;
                    this.instrumentedMethod = instrumentedMethod;
                    this.adviceMethod = adviceMethod;
                    this.offsetMappings = offsetMappings;
                    this.suppressionHandler = suppressionHandler;
                    this.endOfMethod = new Label();
                }

                protected void propagateHandler(Label label) {
                    ((StackAwareMethodVisitor)this.mv).register(label, Collections.singletonList(StackSize.SINGLE));
                }

                @Override
                public void visitParameter(String name, int modifiers) {
                }

                @Override
                public AnnotationVisitor visitAnnotationDefault() {
                    return IGNORE_ANNOTATION;
                }

                @Override
                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    return IGNORE_ANNOTATION;
                }

                @Override
                public AnnotationVisitor visitTypeAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                    return IGNORE_ANNOTATION;
                }

                @Override
                public AnnotationVisitor visitParameterAnnotation(int index, String descriptor, boolean visible) {
                    return IGNORE_ANNOTATION;
                }

                @Override
                public void visitAttribute(Attribute attribute) {
                }

                @Override
                public void visitCode() {
                    this.suppressionHandler.onStart(this.methodVisitor);
                }

                @Override
                public void visitFrame(int frameType, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
                    this.stackMapFrameHandler.translateFrame(this.methodVisitor, frameType, localVariableLength, localVariable, stackSize, stack);
                }

                @Override
                public void visitEnd() {
                    this.suppressionHandler.onEnd(this.methodVisitor, this.implementationContext, this.methodSizeHandler, this.stackMapFrameHandler, this);
                    this.methodVisitor.visitLabel(this.endOfMethod);
                    this.onMethodReturn();
                    this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, false);
                }

                @Override
                public void visitMaxs(int stackSize, int localVariableLength) {
                    this.methodSizeHandler.recordMaxima(stackSize, localVariableLength);
                }

                @Override
                public void visitVarInsn(int opcode, int offset) {
                    OffsetMapping.Target target = this.offsetMappings.get(offset);
                    if (target != null) {
                        StackSize expectedGrowth;
                        StackManipulation stackManipulation;
                        switch (opcode) {
                            case 21: 
                            case 23: 
                            case 25: {
                                stackManipulation = target.resolveRead();
                                expectedGrowth = StackSize.SINGLE;
                                break;
                            }
                            case 22: 
                            case 24: {
                                stackManipulation = target.resolveRead();
                                expectedGrowth = StackSize.DOUBLE;
                                break;
                            }
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: {
                                stackManipulation = target.resolveWrite();
                                expectedGrowth = StackSize.ZERO;
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected opcode: " + opcode);
                            }
                        }
                        this.methodSizeHandler.recordPadding(stackManipulation.apply(this.mv, this.implementationContext).getMaximalSize() - expectedGrowth.getSize());
                    } else {
                        this.mv.visitVarInsn(opcode, this.adjust(offset + this.instrumentedMethod.getStackSize() - this.adviceMethod.getStackSize()));
                    }
                }

                @Override
                public void visitIincInsn(int offset, int value) {
                    OffsetMapping.Target target = this.offsetMappings.get(offset);
                    if (target != null) {
                        this.methodSizeHandler.recordPadding(target.resolveIncrement(value).apply(this.mv, this.implementationContext).getMaximalSize());
                    } else {
                        this.mv.visitIincInsn(this.adjust(offset + this.instrumentedMethod.getStackSize() - this.adviceMethod.getStackSize()), value);
                    }
                }

                protected abstract int adjust(int var1);

                @Override
                public abstract void visitInsn(int var1);

                protected abstract void onMethodReturn();

                protected static class ForMethodExit
                extends CodeTranslationVisitor {
                    private final int padding;

                    protected ForMethodExit(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, MethodDescription.InDefinedShape adviceMethod, Map<Integer, OffsetMapping.Target> offsetMappings, SuppressionHandler.Bound suppressionHandler, int padding) {
                        super(methodVisitor, implementationContext, methodSizeHandler, stackMapFrameHandler, instrumentedMethod, adviceMethod, offsetMappings, suppressionHandler);
                        this.padding = padding;
                    }

                    @Override
                    public void visitInsn(int opcode) {
                        switch (opcode) {
                            case 177: {
                                break;
                            }
                            case 172: 
                            case 174: 
                            case 176: {
                                this.mv.visitInsn(87);
                                break;
                            }
                            case 173: 
                            case 175: {
                                this.mv.visitInsn(88);
                                break;
                            }
                            default: {
                                this.mv.visitInsn(opcode);
                                return;
                            }
                        }
                        ((StackAwareMethodVisitor)this.mv).drainStack();
                        this.mv.visitJumpInsn(167, this.endOfMethod);
                    }

                    @Override
                    protected int adjust(int offset) {
                        return this.instrumentedMethod.getReturnType().getStackSize().getSize() + this.padding + offset;
                    }

                    @Override
                    public void onDefaultValue(MethodVisitor methodVisitor) {
                    }

                    @Override
                    protected void onMethodReturn() {
                    }

                    public String toString() {
                        return "Advice.Dispatcher.Inlining.CodeTranslationVisitor.ForMethodExit{instrumentedMethod=" + this.instrumentedMethod + ", adviceMethod=" + this.adviceMethod + ", padding=" + this.padding + '}';
                    }
                }

                protected static class ForMethodEnter
                extends CodeTranslationVisitor {
                    private boolean doesReturn = false;

                    protected ForMethodEnter(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, MethodDescription.InDefinedShape adviceMethod, Map<Integer, OffsetMapping.Target> offsetMappings, SuppressionHandler.Bound suppressionHandler) {
                        super(methodVisitor, implementationContext, methodSizeHandler, stackMapFrameHandler, instrumentedMethod, adviceMethod, offsetMappings, suppressionHandler);
                    }

                    @Override
                    public void visitInsn(int opcode) {
                        switch (opcode) {
                            case 177: {
                                ((StackAwareMethodVisitor)this.mv).drainStack();
                                break;
                            }
                            case 172: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(54, 21, StackSize.SINGLE));
                                break;
                            }
                            case 176: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(58, 25, StackSize.SINGLE));
                                break;
                            }
                            case 174: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(56, 23, StackSize.SINGLE));
                                break;
                            }
                            case 173: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(55, 22, StackSize.DOUBLE));
                                break;
                            }
                            case 175: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(57, 24, StackSize.DOUBLE));
                                break;
                            }
                            default: {
                                this.mv.visitInsn(opcode);
                                return;
                            }
                        }
                        this.mv.visitJumpInsn(167, this.endOfMethod);
                        this.doesReturn = true;
                    }

                    @Override
                    protected int adjust(int offset) {
                        return offset;
                    }

                    @Override
                    public void onDefaultValue(MethodVisitor methodVisitor) {
                        if (this.adviceMethod.getReturnType().represents(Boolean.TYPE) || this.adviceMethod.getReturnType().represents(Byte.TYPE) || this.adviceMethod.getReturnType().represents(Short.TYPE) || this.adviceMethod.getReturnType().represents(Character.TYPE) || this.adviceMethod.getReturnType().represents(Integer.TYPE)) {
                            methodVisitor.visitInsn(3);
                        } else if (this.adviceMethod.getReturnType().represents(Long.TYPE)) {
                            methodVisitor.visitInsn(9);
                        } else if (this.adviceMethod.getReturnType().represents(Float.TYPE)) {
                            methodVisitor.visitInsn(11);
                        } else if (this.adviceMethod.getReturnType().represents(Double.TYPE)) {
                            methodVisitor.visitInsn(14);
                        } else if (!this.adviceMethod.getReturnType().represents(Void.TYPE)) {
                            methodVisitor.visitInsn(1);
                        }
                        this.doesReturn = true;
                    }

                    @Override
                    protected void onMethodReturn() {
                        Type returnType = Type.getType(this.adviceMethod.getReturnType().asErasure().getDescriptor());
                        if (this.doesReturn && !returnType.equals(Type.VOID_TYPE)) {
                            this.stackMapFrameHandler.injectReturnFrame(this.methodVisitor);
                            this.methodVisitor.visitVarInsn(returnType.getOpcode(54), this.instrumentedMethod.getStackSize());
                        }
                    }

                    public String toString() {
                        return "Advice.Dispatcher.Inlining.CodeTranslationVisitor.ForMethodEnter{instrumentedMethod=" + this.instrumentedMethod + ", adviceMethod=" + this.adviceMethod + ", doesReturn=" + this.doesReturn + '}';
                    }
                }
            }

            protected static abstract class Resolved
            implements net.bytebuddy.asm.Advice$Dispatcher$Resolved {
                private static final boolean READ_ONLY = true;
                protected final MethodDescription.InDefinedShape adviceMethod;
                protected final ClassReader classReader;
                protected final Map<Integer, OffsetMapping> offsetMappings;
                protected final SuppressionHandler suppressionHandler;

                protected Resolved(MethodDescription.InDefinedShape adviceMethod, List<OffsetMapping.Factory> factories, ClassReader classReader, TypeDescription throwableType) {
                    this.adviceMethod = adviceMethod;
                    this.offsetMappings = new HashMap<Integer, OffsetMapping>();
                    for (ParameterDescription.InDefinedShape parameterDescription : adviceMethod.getParameters()) {
                        OffsetMapping offsetMapping = OffsetMapping.Factory.UNDEFINED;
                        for (OffsetMapping.Factory factory : factories) {
                            OffsetMapping possible = factory.make(parameterDescription);
                            if (possible == null) continue;
                            if (offsetMapping == null) {
                                offsetMapping = possible;
                                continue;
                            }
                            throw new IllegalStateException(parameterDescription + " is bound to both " + possible + " and " + offsetMapping);
                        }
                        this.offsetMappings.put(parameterDescription.getOffset(), offsetMapping == null ? new OffsetMapping.ForArgument(parameterDescription, true, Assigner.Typing.STATIC) : offsetMapping);
                    }
                    this.classReader = classReader;
                    this.suppressionHandler = SuppressionHandler.Suppressing.of(throwableType);
                }

                @Override
                public boolean isAlive() {
                    return true;
                }

                protected abstract MethodVisitor apply(MethodVisitor var1, Implementation.Context var2, Assigner var3, MethodSizeHandler.ForInstrumentedMethod var4, StackMapFrameHandler.ForInstrumentedMethod var5, TypeDescription var6, MethodDescription var7, SuppressionHandler.Bound var8);

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Resolved resolved = (Resolved)other;
                    return this.adviceMethod.equals(resolved.adviceMethod) && this.offsetMappings.equals(resolved.offsetMappings);
                }

                public int hashCode() {
                    int result = this.adviceMethod.hashCode();
                    result = 31 * result + this.offsetMappings.hashCode();
                    return result;
                }

                protected static abstract class ForMethodExit
                extends Resolved
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit {
                    private final TypeDefinition enterType;

                    protected ForMethodExit(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader, TypeDefinition enterType) {
                        super(adviceMethod, CompoundList.of(Arrays.asList(OffsetMapping.ForArgument.Factory.READ_WRITE, OffsetMapping.ForAllArguments.Factory.READ_WRITE, OffsetMapping.ForThisReference.Factory.READ_WRITE, OffsetMapping.ForField.Factory.READ_WRITE, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForUnusedValue.Factory.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, new OffsetMapping.ForEnterValue.Factory(enterType, false), OffsetMapping.ForReturnValue.Factory.READ_WRITE, OffsetMapping.ForThrowable.Factory.of(adviceMethod, false)), userFactories), classReader, adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(SUPPRESS_EXIT).resolve(TypeDescription.class));
                        this.enterType = enterType;
                    }

                    protected static net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit of(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader, TypeDefinition enterType) {
                        TypeDescription throwable = adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(ON_THROWABLE).resolve(TypeDescription.class);
                        return throwable.represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class)) ? new WithoutExceptionHandler(adviceMethod, userFactories, classReader, enterType) : new WithExceptionHandler(adviceMethod, userFactories, classReader, enterType, throwable);
                    }

                    @Override
                    protected MethodVisitor apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, SuppressionHandler.Bound suppressionHandler) {
                        HashMap<Integer, OffsetMapping.Target> offsetMappings = new HashMap<Integer, OffsetMapping.Target>();
                        for (Map.Entry entry : this.offsetMappings.entrySet()) {
                            offsetMappings.put((Integer)entry.getKey(), ((OffsetMapping)entry.getValue()).resolve(instrumentedType, instrumentedMethod, assigner, OffsetMapping.Context.ForMethodExit.of(this.enterType)));
                        }
                        return new CodeTranslationVisitor.ForMethodExit(methodVisitor, implementationContext, methodSizeHandler.bindExit(this.adviceMethod, this.getThrowable().represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class))), stackMapFrameHandler.bindExit(this.adviceMethod), instrumentedMethod, this.adviceMethod, offsetMappings, suppressionHandler, this.enterType.getStackSize().getSize() + this.getPadding().getSize());
                    }

                    @Override
                    public Bound.ForMethodExit bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler) {
                        return new AdviceMethodInliner(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, methodSizeHandler, stackMapFrameHandler, this.suppressionHandler.bind(exceptionHandler), this.classReader);
                    }

                    protected abstract StackSize getPadding();

                    @Override
                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.enterType == ((ForMethodExit)other).enterType;
                    }

                    @Override
                    public int hashCode() {
                        int result = super.hashCode();
                        result = 31 * result + this.enterType.hashCode();
                        return result;
                    }

                    protected static class WithoutExceptionHandler
                    extends ForMethodExit {
                        protected WithoutExceptionHandler(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader, TypeDefinition enterType) {
                            super(adviceMethod, userFactories, classReader, enterType);
                        }

                        @Override
                        protected StackSize getPadding() {
                            return StackSize.ZERO;
                        }

                        @Override
                        public TypeDescription getThrowable() {
                            return NoExceptionHandler.DESCRIPTION;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Inlining.Resolved.ForMethodExit.WithoutExceptionHandler{adviceMethod=" + this.adviceMethod + ", offsetMappings=" + this.offsetMappings + '}';
                        }
                    }

                    protected static class WithExceptionHandler
                    extends ForMethodExit {
                        private final TypeDescription throwable;

                        protected WithExceptionHandler(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader, TypeDefinition enterType, TypeDescription throwable) {
                            super(adviceMethod, userFactories, classReader, enterType);
                            this.throwable = throwable;
                        }

                        @Override
                        protected StackSize getPadding() {
                            return this.throwable.getStackSize();
                        }

                        @Override
                        public TypeDescription getThrowable() {
                            return this.throwable;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Inlining.Resolved.ForMethodExit.WithExceptionHandler{adviceMethod=" + this.adviceMethod + ", offsetMappings=" + this.offsetMappings + ", throwable=" + this.throwable + '}';
                        }
                    }

                    protected class AdviceMethodInliner
                    extends net.bytebuddy.asm.Advice$Dispatcher$Inlining$Resolved$AdviceMethodInliner
                    implements Bound.ForMethodExit {
                        public AdviceMethodInliner(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, ClassReader classReader) {
                            super(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, methodSizeHandler, stackMapFrameHandler, suppressionHandler, classReader);
                        }

                        @Override
                        public void apply() {
                            this.doApply();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Inlining.Resolved.ForMethodExit.AdviceMethodInliner{instrumentedType=" + this.instrumentedType + ", instrumentedMethod=" + this.instrumentedMethod + ", methodVisitor=" + this.methodVisitor + ", methodSizeHandler=" + this.methodSizeHandler + ", stackMapFrameHandler=" + this.stackMapFrameHandler + ", suppressionHandler=" + this.suppressionHandler + ", classReader=" + this.classReader + ", labels=" + this.labels + '}';
                        }
                    }
                }

                protected static class ForMethodEnter
                extends Resolved
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter {
                    private final Resolved.ForMethodEnter.SkipDispatcher skipDispatcher;
                    private final boolean prependLineNumber;

                    protected ForMethodEnter(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader) {
                        super(adviceMethod, CompoundList.of(Arrays.asList(OffsetMapping.ForArgument.Factory.READ_WRITE, OffsetMapping.ForAllArguments.Factory.READ_WRITE, OffsetMapping.ForThisReference.Factory.READ_WRITE, OffsetMapping.ForField.Factory.READ_WRITE, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForUnusedValue.Factory.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, new OffsetMapping.Illegal(Thrown.class, Enter.class, Return.class)), userFactories), classReader, adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SUPPRESS_ENTER).resolve(TypeDescription.class));
                        this.skipDispatcher = Resolved.ForMethodEnter.SkipDispatcher.ForType.of(adviceMethod);
                        this.prependLineNumber = adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(PREPEND_LINE_NUMBER).resolve(Boolean.class);
                    }

                    @Override
                    public Bound.ForMethodEnter bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler) {
                        return new AdviceMethodInliner(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, methodSizeHandler, stackMapFrameHandler, this.suppressionHandler.bind(exceptionHandler), this.classReader, this.skipDispatcher);
                    }

                    @Override
                    public TypeDefinition getEnterType() {
                        return this.adviceMethod.getReturnType();
                    }

                    @Override
                    public boolean isPrependLineNumber() {
                        return this.prependLineNumber;
                    }

                    @Override
                    protected MethodVisitor apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, SuppressionHandler.Bound suppressionHandler) {
                        HashMap<Integer, OffsetMapping.Target> offsetMappings = new HashMap<Integer, OffsetMapping.Target>();
                        for (Map.Entry entry : this.offsetMappings.entrySet()) {
                            offsetMappings.put((Integer)entry.getKey(), ((OffsetMapping)entry.getValue()).resolve(instrumentedType, instrumentedMethod, assigner, OffsetMapping.Context.ForMethodEntry.of(instrumentedMethod)));
                        }
                        return new CodeTranslationVisitor.ForMethodEnter(methodVisitor, implementationContext, methodSizeHandler.bindEntry(this.adviceMethod), stackMapFrameHandler.bindEntry(this.adviceMethod), instrumentedMethod, this.adviceMethod, offsetMappings, suppressionHandler);
                    }

                    @Override
                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        if (!super.equals(other)) {
                            return false;
                        }
                        ForMethodEnter that = (ForMethodEnter)other;
                        return this.skipDispatcher == that.skipDispatcher && this.prependLineNumber == that.prependLineNumber;
                    }

                    @Override
                    public int hashCode() {
                        int result = super.hashCode();
                        result = 31 * result + this.skipDispatcher.hashCode();
                        result = 31 * result + (this.prependLineNumber ? 1 : 0);
                        return result;
                    }

                    public String toString() {
                        return "Advice.Dispatcher.Inlining.Resolved.ForMethodEnter{adviceMethod=" + this.adviceMethod + ", offsetMappings=" + this.offsetMappings + ", skipDispatcher=" + this.skipDispatcher + ", prependLineNumber=" + this.prependLineNumber + '}';
                    }

                    protected class AdviceMethodInliner
                    extends net.bytebuddy.asm.Advice$Dispatcher$Inlining$Resolved$AdviceMethodInliner
                    implements Bound.ForMethodEnter {
                        private final Resolved.ForMethodEnter.SkipDispatcher skipDispatcher;

                        protected AdviceMethodInliner(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, ClassReader classReader, Resolved.ForMethodEnter.SkipDispatcher skipDispatcher) {
                            super(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, methodSizeHandler, stackMapFrameHandler, suppressionHandler, classReader);
                            this.skipDispatcher = skipDispatcher;
                        }

                        @Override
                        public void apply(Bound.SkipHandler skipHandler) {
                            this.doApply();
                            this.skipDispatcher.apply(this.methodVisitor, this.methodSizeHandler.bindEntry(ForMethodEnter.this.adviceMethod), this.stackMapFrameHandler.bindEntry(ForMethodEnter.this.adviceMethod), this.instrumentedMethod, skipHandler);
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Inlining.Resolved.ForMethodEnter.AdviceMethodInliner{instrumentedType=" + this.instrumentedType + ", instrumentedMethod=" + this.instrumentedMethod + ", methodVisitor=" + this.methodVisitor + ", methodSizeHandler=" + this.methodSizeHandler + ", stackMapFrameHandler=" + this.stackMapFrameHandler + ", suppressionHandler=" + this.suppressionHandler + ", classReader=" + this.classReader + ", labels=" + this.labels + ", skipDispatcher=" + this.skipDispatcher + '}';
                        }
                    }
                }

                protected abstract class AdviceMethodInliner
                extends ClassVisitor
                implements Bound {
                    protected final TypeDescription instrumentedType;
                    protected final MethodDescription instrumentedMethod;
                    protected final MethodVisitor methodVisitor;
                    protected final Implementation.Context implementationContext;
                    protected final Assigner assigner;
                    protected final MethodSizeHandler.ForInstrumentedMethod methodSizeHandler;
                    protected final StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler;
                    protected final SuppressionHandler.Bound suppressionHandler;
                    protected final ClassReader classReader;
                    protected List<Label> labels;

                    protected AdviceMethodInliner(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, ClassReader classReader) {
                        super(327680);
                        this.instrumentedType = instrumentedType;
                        this.instrumentedMethod = instrumentedMethod;
                        this.methodVisitor = methodVisitor;
                        this.implementationContext = implementationContext;
                        this.assigner = assigner;
                        this.methodSizeHandler = methodSizeHandler;
                        this.stackMapFrameHandler = stackMapFrameHandler;
                        this.suppressionHandler = suppressionHandler;
                        this.classReader = classReader;
                        this.labels = new ArrayList<Label>();
                    }

                    @Override
                    public void prepare() {
                        this.classReader.accept(new ExceptionTableExtractor(), 6);
                        this.suppressionHandler.onPrepare(this.methodVisitor);
                    }

                    protected void doApply() {
                        this.classReader.accept(this, 2 | this.stackMapFrameHandler.getReaderHint());
                    }

                    @Override
                    public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String signature, String[] exception) {
                        return Resolved.this.adviceMethod.getInternalName().equals(internalName) && Resolved.this.adviceMethod.getDescriptor().equals(descriptor) ? new ExceptionTableSubstitutor(Resolved.this.apply(this.methodVisitor, this.implementationContext, this.assigner, this.methodSizeHandler, this.stackMapFrameHandler, this.instrumentedType, this.instrumentedMethod, this.suppressionHandler)) : IGNORE_METHOD;
                    }

                    protected class ExceptionTableSubstitutor
                    extends MethodVisitor {
                        private final Map<Label, Label> substitutions;
                        private int index;

                        protected ExceptionTableSubstitutor(MethodVisitor methodVisitor) {
                            super(327680, methodVisitor);
                            this.substitutions = new IdentityHashMap<Label, Label>();
                        }

                        @Override
                        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                            this.substitutions.put(start, AdviceMethodInliner.this.labels.get(this.index++));
                            this.substitutions.put(end, AdviceMethodInliner.this.labels.get(this.index++));
                            Label actualHandler = AdviceMethodInliner.this.labels.get(this.index++);
                            this.substitutions.put(handler, actualHandler);
                            ((CodeTranslationVisitor)this.mv).propagateHandler(actualHandler);
                        }

                        @Override
                        public AnnotationVisitor visitTryCatchAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                            return IGNORE_ANNOTATION;
                        }

                        @Override
                        public void visitLabel(Label label) {
                            super.visitLabel(this.resolve(label));
                        }

                        @Override
                        public void visitJumpInsn(int opcode, Label label) {
                            super.visitJumpInsn(opcode, this.resolve(label));
                        }

                        @Override
                        public void visitTableSwitchInsn(int minimum, int maximum, Label defaultOption, Label ... label) {
                            super.visitTableSwitchInsn(minimum, maximum, defaultOption, this.resolve(label));
                        }

                        @Override
                        public void visitLookupSwitchInsn(Label defaultOption, int[] keys, Label[] label) {
                            super.visitLookupSwitchInsn(this.resolve(defaultOption), keys, this.resolve(label));
                        }

                        private Label[] resolve(Label[] label) {
                            Label[] resolved = new Label[label.length];
                            int index = 0;
                            for (Label aLabel : label) {
                                resolved[index++] = this.resolve(aLabel);
                            }
                            return resolved;
                        }

                        private Label resolve(Label label) {
                            Label substitution = this.substitutions.get(label);
                            return substitution == null ? label : substitution;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Inlining.Resolved.AdviceMethodInliner.ExceptionTableSubstitutor{methodVisitor=" + AdviceMethodInliner.this.methodVisitor + ", substitutions=" + this.substitutions + ", index=" + this.index + '}';
                        }
                    }

                    protected class ExceptionTableCollector
                    extends MethodVisitor {
                        private final MethodVisitor methodVisitor;

                        protected ExceptionTableCollector(MethodVisitor methodVisitor) {
                            super(327680);
                            this.methodVisitor = methodVisitor;
                        }

                        @Override
                        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                            this.methodVisitor.visitTryCatchBlock(start, end, handler, type);
                            AdviceMethodInliner.this.labels.addAll(Arrays.asList(start, end, handler));
                        }

                        @Override
                        public AnnotationVisitor visitTryCatchAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                            return this.methodVisitor.visitTryCatchAnnotation(typeReference, typePath, descriptor, visible);
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Inlining.Resolved.AdviceMethodInliner.ExceptionTableCollector{methodVisitor=" + this.methodVisitor + '}';
                        }
                    }

                    protected class ExceptionTableExtractor
                    extends ClassVisitor {
                        protected ExceptionTableExtractor() {
                            super(327680);
                        }

                        @Override
                        public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String signature, String[] exception) {
                            return Resolved.this.adviceMethod.getInternalName().equals(internalName) && Resolved.this.adviceMethod.getDescriptor().equals(descriptor) ? new ExceptionTableCollector(AdviceMethodInliner.this.methodVisitor) : IGNORE_METHOD;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Inlining.Resolved.AdviceMethodInliner.ExceptionTableExtractor{methodVisitor=" + AdviceMethodInliner.this.methodVisitor + '}';
                        }
                    }
                }
            }
        }

        public static enum Inactive implements Unresolved,
        Resolved.ForMethodEnter,
        Resolved.ForMethodExit,
        Bound.ForMethodEnter,
        Bound.ForMethodExit
        {
            INSTANCE;


            @Override
            public boolean isAlive() {
                return false;
            }

            @Override
            public boolean isBinary() {
                return false;
            }

            @Override
            public TypeDescription getThrowable() {
                return NoExceptionHandler.DESCRIPTION;
            }

            @Override
            public TypeDefinition getEnterType() {
                return TypeDescription.VOID;
            }

            @Override
            public boolean isPrependLineNumber() {
                return false;
            }

            @Override
            public Resolved.ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader) {
                return this;
            }

            @Override
            public Resolved.ForMethodExit asMethodExitTo(List<? extends OffsetMapping.Factory> userFactories, ClassReader classReader, Resolved.ForMethodEnter dispatcher) {
                return this;
            }

            @Override
            public void prepare() {
            }

            @Override
            public void apply() {
            }

            @Override
            public void apply(Bound.SkipHandler skipHandler) {
            }

            @Override
            public Inactive bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler) {
                return this;
            }

            public String toString() {
                return "Advice.Dispatcher.Inactive." + this.name();
            }
        }

        public static interface Bound {
            public void prepare();

            public static interface ForMethodExit
            extends Bound {
                public void apply();
            }

            public static interface ForMethodEnter
            extends Bound {
                public void apply(SkipHandler var1);
            }

            public static interface SkipHandler {
                public void apply(MethodVisitor var1);
            }
        }

        public static interface Resolved
        extends Dispatcher {
            public Bound bind(TypeDescription var1, MethodDescription var2, MethodVisitor var3, Implementation.Context var4, Assigner var5, MethodSizeHandler.ForInstrumentedMethod var6, StackMapFrameHandler.ForInstrumentedMethod var7, StackManipulation var8);

            public static interface ForMethodExit
            extends Resolved {
                public TypeDescription getThrowable();

                @Override
                public Bound.ForMethodExit bind(TypeDescription var1, MethodDescription var2, MethodVisitor var3, Implementation.Context var4, Assigner var5, MethodSizeHandler.ForInstrumentedMethod var6, StackMapFrameHandler.ForInstrumentedMethod var7, StackManipulation var8);
            }

            public static interface ForMethodEnter
            extends Resolved {
                public TypeDefinition getEnterType();

                public boolean isPrependLineNumber();

                @Override
                public Bound.ForMethodEnter bind(TypeDescription var1, MethodDescription var2, MethodVisitor var3, Implementation.Context var4, Assigner var5, MethodSizeHandler.ForInstrumentedMethod var6, StackMapFrameHandler.ForInstrumentedMethod var7, StackManipulation var8);

                public static interface SkipDispatcher {
                    public void apply(MethodVisitor var1, MethodSizeHandler.ForAdvice var2, StackMapFrameHandler.ForAdvice var3, MethodDescription var4, Bound.SkipHandler var5);

                    public static class ForType
                    implements SkipDispatcher {
                        private final TypeDescription typeDescription;

                        protected ForType(TypeDescription typeDescription) {
                            this.typeDescription = typeDescription;
                        }

                        public static SkipDispatcher of(MethodDescription adviceMethod) {
                            return ForType.of(adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SKIP_ON).resolve(TypeDescription.class), adviceMethod);
                        }

                        protected static SkipDispatcher of(TypeDescription typeDescription, MethodDescription adviceMethod) {
                            if (typeDescription.represents(Void.TYPE)) {
                                return Disabled.INSTANCE;
                            }
                            if (typeDescription.represents((java.lang.reflect.Type)((Object)OnDefaultValue.class))) {
                                return ForValue.of(adviceMethod.getReturnType(), false);
                            }
                            if (typeDescription.represents((java.lang.reflect.Type)((Object)OnNonDefaultValue.class))) {
                                return ForValue.of(adviceMethod.getReturnType(), true);
                            }
                            if (typeDescription.isPrimitive() || adviceMethod.getReturnType().isPrimitive()) {
                                throw new IllegalStateException("Cannot skip method by instance type for primitive return value on " + adviceMethod);
                            }
                            return new ForType(typeDescription);
                        }

                        @Override
                        public void apply(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, Bound.SkipHandler skipHandler) {
                            methodVisitor.visitVarInsn(25, instrumentedMethod.getStackSize());
                            methodVisitor.visitTypeInsn(193, this.typeDescription.getInternalName());
                            Label noSkip = new Label();
                            methodVisitor.visitJumpInsn(153, noSkip);
                            skipHandler.apply(methodVisitor);
                            methodVisitor.visitLabel(noSkip);
                            stackMapFrameHandler.injectCompletionFrame(methodVisitor, true);
                        }

                        public boolean equals(Object other) {
                            if (this == other) {
                                return true;
                            }
                            if (other == null || this.getClass() != other.getClass()) {
                                return false;
                            }
                            ForType forType = (ForType)other;
                            return this.typeDescription.equals(forType.typeDescription);
                        }

                        public int hashCode() {
                            return this.typeDescription.hashCode();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Resolved.ForMethodEnter.SkipDispatcher.ForType{typeDescription=" + this.typeDescription + '}';
                        }
                    }

                    public static enum ForValue implements SkipDispatcher
                    {
                        FOR_INTEGER(21, 154, 153){

                            @Override
                            protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                            }
                        }
                        ,
                        FOR_LONG(22, 154, 153){

                            @Override
                            protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                                methodVisitor.visitInsn(136);
                            }
                        }
                        ,
                        FOR_FLOAT(23, 154, 153){

                            @Override
                            protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                                methodVisitor.visitInsn(11);
                                methodVisitor.visitInsn(149);
                                methodSizeHandler.requireStackSize(2);
                            }
                        }
                        ,
                        FOR_DOUBLE(24, 154, 153){

                            @Override
                            protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                                methodVisitor.visitInsn(14);
                                methodVisitor.visitInsn(151);
                                methodSizeHandler.requireStackSize(4);
                            }
                        }
                        ,
                        FOR_REFERENCE(25, 199, 198){

                            @Override
                            protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                            }
                        };

                        private final int load;
                        private final int defaultJump;
                        private final int nonDefaultJump;

                        private ForValue(int load, int defaultJump, int nonDefaultJump) {
                            this.load = load;
                            this.defaultJump = defaultJump;
                            this.nonDefaultJump = nonDefaultJump;
                        }

                        protected static SkipDispatcher of(TypeDefinition typeDefinition, boolean inverted) {
                            ForValue skipDispatcher;
                            if (typeDefinition.represents(Long.TYPE)) {
                                skipDispatcher = FOR_LONG;
                            } else if (typeDefinition.represents(Float.TYPE)) {
                                skipDispatcher = FOR_FLOAT;
                            } else if (typeDefinition.represents(Double.TYPE)) {
                                skipDispatcher = FOR_DOUBLE;
                            } else {
                                if (typeDefinition.represents(Void.TYPE)) {
                                    throw new IllegalStateException("Cannot skip on default value for void return type");
                                }
                                skipDispatcher = typeDefinition.isPrimitive() ? FOR_INTEGER : FOR_REFERENCE;
                            }
                            return inverted ? skipDispatcher.inverted() : skipDispatcher;
                        }

                        @Override
                        public void apply(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, Bound.SkipHandler skipHandler) {
                            this.doApply(methodVisitor, methodSizeHandler, stackMapFrameHandler, instrumentedMethod, skipHandler, false);
                        }

                        protected void doApply(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, Bound.SkipHandler skipHandler, boolean inverted) {
                            methodVisitor.visitVarInsn(this.load, instrumentedMethod.getStackSize());
                            this.convertValue(methodVisitor, methodSizeHandler);
                            Label noSkip = new Label();
                            methodVisitor.visitJumpInsn(inverted ? this.nonDefaultJump : this.defaultJump, noSkip);
                            skipHandler.apply(methodVisitor);
                            methodVisitor.visitLabel(noSkip);
                            stackMapFrameHandler.injectCompletionFrame(methodVisitor, true);
                        }

                        protected abstract void convertValue(MethodVisitor var1, MethodSizeHandler.ForAdvice var2);

                        private SkipDispatcher inverted() {
                            return new Inverted();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Resolved.ForMethodEnter.SkipDispatcher.ForValue." + this.name();
                        }

                        protected class Inverted
                        implements SkipDispatcher {
                            protected Inverted() {
                            }

                            @Override
                            public void apply(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, Bound.SkipHandler skipHandler) {
                                ForValue.this.doApply(methodVisitor, methodSizeHandler, stackMapFrameHandler, instrumentedMethod, skipHandler, true);
                            }

                            private SkipDispatcher getOuter() {
                                return ForValue.this;
                            }

                            public int hashCode() {
                                return ForValue.this.hashCode();
                            }

                            public boolean equals(Object other) {
                                if (other == this) {
                                    return true;
                                }
                                if (!(other instanceof Inverted)) {
                                    return false;
                                }
                                Inverted inverted = (Inverted)other;
                                return inverted.getOuter().equals(ForValue.this);
                            }

                            public String toString() {
                                return "Advice.Dispatcher.Resolved.ForMethodEnter.SkipDispatcher.ForValue.Inverted{outer=" + ForValue.this + "}";
                            }
                        }
                    }

                    public static enum Disabled implements SkipDispatcher
                    {
                        INSTANCE;


                        @Override
                        public void apply(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, Bound.SkipHandler skipHandler) {
                        }

                        public String toString() {
                            return "Advice.Dispatcher.Resolved.ForMethodEnter.SkipDispatcher.Disabled." + this.name();
                        }
                    }
                }
            }
        }

        public static interface SuppressionHandler {
            public Bound bind(StackManipulation var1);

            public static class Suppressing
            implements SuppressionHandler {
                private final TypeDescription suppressedType;

                protected Suppressing(TypeDescription suppressedType) {
                    this.suppressedType = suppressedType;
                }

                protected static SuppressionHandler of(TypeDescription suppressedType) {
                    return suppressedType.represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class)) ? NoOp.INSTANCE : new Suppressing(suppressedType);
                }

                @Override
                public net.bytebuddy.asm.Advice$Dispatcher$SuppressionHandler$Bound bind(StackManipulation exceptionHandler) {
                    return new Bound(this.suppressedType, exceptionHandler);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Suppressing that = (Suppressing)other;
                    return this.suppressedType.equals(that.suppressedType);
                }

                public int hashCode() {
                    return this.suppressedType.hashCode();
                }

                public String toString() {
                    return "Advice.Dispatcher.SuppressionHandler.Suppressing{suppressedType=" + this.suppressedType + '}';
                }

                protected static class Bound
                implements net.bytebuddy.asm.Advice$Dispatcher$SuppressionHandler$Bound {
                    private final TypeDescription suppressedType;
                    private final StackManipulation exceptionHandler;
                    private final Label startOfMethod;
                    private final Label endOfMethod;

                    protected Bound(TypeDescription suppressedType, StackManipulation exceptionHandler) {
                        this.suppressedType = suppressedType;
                        this.exceptionHandler = exceptionHandler;
                        this.startOfMethod = new Label();
                        this.endOfMethod = new Label();
                    }

                    @Override
                    public void onPrepare(MethodVisitor methodVisitor) {
                        methodVisitor.visitTryCatchBlock(this.startOfMethod, this.endOfMethod, this.endOfMethod, this.suppressedType.getInternalName());
                    }

                    @Override
                    public void onStart(MethodVisitor methodVisitor) {
                        methodVisitor.visitLabel(this.startOfMethod);
                    }

                    @Override
                    public void onEnd(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, ReturnValueProducer returnValueProducer) {
                        methodVisitor.visitLabel(this.endOfMethod);
                        stackMapFrameHandler.injectExceptionFrame(methodVisitor);
                        methodSizeHandler.requireStackSize(1 + this.exceptionHandler.apply(methodVisitor, implementationContext).getMaximalSize());
                        returnValueProducer.onDefaultValue(methodVisitor);
                    }

                    @Override
                    public void onEndSkipped(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, ReturnValueProducer returnValueProducer) {
                        Label endOfHandler = new Label();
                        methodVisitor.visitJumpInsn(167, endOfHandler);
                        this.onEnd(methodVisitor, implementationContext, methodSizeHandler, stackMapFrameHandler, returnValueProducer);
                        methodVisitor.visitLabel(endOfHandler);
                    }

                    public String toString() {
                        return "Advice.Dispatcher.SuppressionHandler.Suppressing.Bound{suppressedType=" + this.suppressedType + "exceptionHandler=" + this.exceptionHandler + ", startOfMethod=" + this.startOfMethod + ", endOfMethod=" + this.endOfMethod + '}';
                    }
                }
            }

            public static enum NoOp implements SuppressionHandler,
            Bound
            {
                INSTANCE;


                @Override
                public Bound bind(StackManipulation exceptionHandler) {
                    return this;
                }

                @Override
                public void onPrepare(MethodVisitor methodVisitor) {
                }

                @Override
                public void onStart(MethodVisitor methodVisitor) {
                }

                @Override
                public void onEnd(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, ReturnValueProducer returnValueProducer) {
                }

                @Override
                public void onEndSkipped(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, ReturnValueProducer returnValueProducer) {
                }

                public String toString() {
                    return "Advice.Dispatcher.SuppressionHandler.NoOp." + this.name();
                }
            }

            public static interface Bound {
                public void onPrepare(MethodVisitor var1);

                public void onStart(MethodVisitor var1);

                public void onEnd(MethodVisitor var1, Implementation.Context var2, MethodSizeHandler.ForAdvice var3, StackMapFrameHandler.ForAdvice var4, ReturnValueProducer var5);

                public void onEndSkipped(MethodVisitor var1, Implementation.Context var2, MethodSizeHandler.ForAdvice var3, StackMapFrameHandler.ForAdvice var4, ReturnValueProducer var5);
            }

            public static interface ReturnValueProducer {
                public void onDefaultValue(MethodVisitor var1);
            }
        }

        public static interface OffsetMapping {
            public Target resolve(TypeDescription var1, MethodDescription var2, Assigner var3, Context var4);

            public static class Illegal
            implements Factory {
                private final List<? extends Class<? extends Annotation>> annotations;

                protected Illegal(Class<? extends Annotation> ... annotation) {
                    this(Arrays.asList(annotation));
                }

                protected Illegal(List<? extends Class<? extends Annotation>> annotations) {
                    this.annotations = annotations;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                    for (Class<? extends Annotation> clazz : this.annotations) {
                        if (!parameterDescription.getDeclaredAnnotations().isAnnotationPresent(clazz)) continue;
                        throw new IllegalStateException("Illegal annotation " + clazz + " for " + parameterDescription);
                    }
                    return UNDEFINED;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Illegal illegal = (Illegal)other;
                    return this.annotations.equals(illegal.annotations);
                }

                public int hashCode() {
                    return this.annotations.hashCode();
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.Illegal{annotations=" + this.annotations + '}';
                }
            }

            public static class ForUserValue<T extends Annotation>
            implements OffsetMapping {
                private final ParameterDescription.InDefinedShape target;
                private final AnnotationDescription.Loadable<T> annotation;
                private final DynamicValue<T> dynamicValue;

                protected ForUserValue(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, DynamicValue<T> dynamicValue) {
                    this.target = target;
                    this.annotation = annotation;
                    this.dynamicValue = dynamicValue;
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                    return new Target.ForStackManipulation(this.dynamicValue.resolve(instrumentedType, instrumentedMethod, this.target, this.annotation, assigner, context.isInitialized()));
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ForUserValue that = (ForUserValue)other;
                    return this.target.equals(that.target) && this.annotation.equals(that.annotation) && this.dynamicValue.equals(that.dynamicValue);
                }

                public int hashCode() {
                    int result = this.target.hashCode();
                    result = 31 * result + this.annotation.hashCode();
                    result = 31 * result + this.dynamicValue.hashCode();
                    return result;
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForUserValue{target=" + this.target + ", annotation=" + this.annotation + ", dynamicValue=" + this.dynamicValue + '}';
                }

                protected static class Factory<S extends Annotation>
                implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory {
                    private final Class<S> type;
                    private final DynamicValue<S> dynamicValue;

                    protected Factory(Class<S> type, DynamicValue<S> dynamicValue) {
                        this.type = type;
                        this.dynamicValue = dynamicValue;
                    }

                    protected static net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory of(Class<? extends Annotation> type, DynamicValue<?> dynamicValue) {
                        return new Factory<Annotation>(type, dynamicValue);
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        AnnotationDescription.Loadable<S> annotation = parameterDescription.getDeclaredAnnotations().ofType(this.type);
                        return annotation == null ? UNDEFINED : new ForUserValue<S>(parameterDescription, annotation, this.dynamicValue);
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        Factory factory = (Factory)other;
                        return this.type.equals(factory.type) && this.dynamicValue.equals(factory.dynamicValue);
                    }

                    public int hashCode() {
                        int result = this.type.hashCode();
                        result = 31 * result + this.dynamicValue.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForUserValue.Factory{type=" + this.type + ", dynamicValue=" + this.dynamicValue + '}';
                    }
                }
            }

            public static class ForThrowable
            implements OffsetMapping {
                private final TypeDescription.Generic target;
                private final boolean readOnly;
                private final Assigner.Typing typing;

                protected ForThrowable(TypeDescription.Generic target, Thrown annotation) {
                    this(target, annotation.readOnly(), annotation.typing());
                }

                protected ForThrowable(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing) {
                    this.target = target;
                    this.readOnly = readOnly;
                    this.typing = typing;
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                    int offset = instrumentedMethod.getStackSize() + context.getPadding() + instrumentedMethod.getReturnType().getStackSize().getSize();
                    StackManipulation readAssignment = assigner.assign(TypeDescription.THROWABLE.asGenericType(), this.target, this.typing);
                    if (!readAssignment.isValid()) {
                        throw new IllegalStateException("Cannot assign Throwable to " + this.target);
                    }
                    if (this.readOnly) {
                        return new Target.ForVariable.ReadOnly(TypeDescription.THROWABLE, offset, readAssignment);
                    }
                    StackManipulation writeAssignment = assigner.assign(this.target, TypeDescription.THROWABLE.asGenericType(), this.typing);
                    if (!writeAssignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + this.target + " to Throwable");
                    }
                    return new Target.ForVariable.ReadWrite(TypeDescription.THROWABLE, offset, readAssignment, writeAssignment);
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    ForThrowable that = (ForThrowable)object;
                    return this.readOnly == that.readOnly && this.target.equals(that.target) && this.typing == that.typing;
                }

                public int hashCode() {
                    int result = this.target.hashCode();
                    result = 31 * result + (this.readOnly ? 1 : 0);
                    result = 31 * result + this.typing.hashCode();
                    return result;
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForThrowable{target=" + this.target + ", readOnly=" + this.readOnly + ", typing=" + (Object)((Object)this.typing) + '}';
                }

                protected static class Factory
                implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory {
                    private final boolean readOnly;

                    protected Factory(boolean readOnly) {
                        this.readOnly = readOnly;
                    }

                    protected static net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory of(MethodDescription.InDefinedShape adviceMethod, boolean readOnly) {
                        return adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(ON_THROWABLE).resolve(TypeDescription.class).represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class)) ? new Illegal(Thrown.class) : new Factory(readOnly);
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        AnnotationDescription.Loadable<Thrown> annotation = parameterDescription.getDeclaredAnnotations().ofType(Thrown.class);
                        if (annotation == null) {
                            return UNDEFINED;
                        }
                        if (this.readOnly && !annotation.loadSilent().readOnly()) {
                            throw new IllegalStateException("Cannot use writable " + parameterDescription + " on read-only parameter");
                        }
                        return new ForThrowable(parameterDescription.getType(), annotation.loadSilent());
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        Factory factory = (Factory)object;
                        return this.readOnly == factory.readOnly;
                    }

                    public int hashCode() {
                        return this.readOnly ? 1 : 0;
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForThrowable.Factory{readOnly=" + this.readOnly + '}';
                    }
                }
            }

            public static class ForReturnValue
            implements OffsetMapping {
                private final TypeDescription.Generic target;
                private final boolean readOnly;
                private final Assigner.Typing typing;

                protected ForReturnValue(TypeDescription.Generic target, Return annotation) {
                    this(target, annotation.readOnly(), annotation.typing());
                }

                protected ForReturnValue(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing) {
                    this.target = target;
                    this.readOnly = readOnly;
                    this.typing = typing;
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                    int offset = instrumentedMethod.getStackSize() + context.getPadding();
                    StackManipulation readAssignment = assigner.assign(instrumentedMethod.getReturnType(), this.target, this.typing);
                    if (!readAssignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + instrumentedMethod.getReturnType() + " to " + this.target);
                    }
                    if (this.readOnly) {
                        return instrumentedMethod.getReturnType().represents(Void.TYPE) ? new Target.ForDefaultValue.ReadOnly(this.target) : new Target.ForVariable.ReadOnly(instrumentedMethod.getReturnType(), offset, readAssignment);
                    }
                    StackManipulation writeAssignment = assigner.assign(this.target, instrumentedMethod.getReturnType(), this.typing);
                    if (!writeAssignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + this.target + " to " + instrumentedMethod.getReturnType());
                    }
                    return instrumentedMethod.getReturnType().represents(Void.TYPE) ? new Target.ForDefaultValue.ReadWrite(this.target) : new Target.ForVariable.ReadWrite(instrumentedMethod.getReturnType(), offset, readAssignment, writeAssignment);
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    ForReturnValue that = (ForReturnValue)object;
                    return this.readOnly == that.readOnly && this.target.equals(that.target) && this.typing == that.typing;
                }

                public int hashCode() {
                    int result = this.target.hashCode();
                    result = 31 * result + (this.readOnly ? 1 : 0);
                    result = 31 * result + this.typing.hashCode();
                    return result;
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForReturnValue{target=" + this.target + ", readOnly=" + this.readOnly + ", typing=" + (Object)((Object)this.typing) + '}';
                }

                protected static enum Factory implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory
                {
                    READ_ONLY(true),
                    READ_WRITE(false);

                    private final boolean readOnly;

                    private Factory(boolean readOnly) {
                        this.readOnly = readOnly;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        AnnotationDescription.Loadable<Return> annotation = parameterDescription.getDeclaredAnnotations().ofType(Return.class);
                        if (annotation == null) {
                            return UNDEFINED;
                        }
                        if (this.readOnly && !annotation.loadSilent().readOnly()) {
                            throw new IllegalStateException("Cannot write return value for " + parameterDescription + " in read-only context");
                        }
                        return new ForReturnValue(parameterDescription.getType(), annotation.loadSilent());
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForReturnValue.Factory." + this.name();
                    }
                }
            }

            public static class ForEnterValue
            implements OffsetMapping {
                private final TypeDescription.Generic target;
                private final TypeDescription.Generic enterType;
                private final boolean readOnly;
                private final Assigner.Typing typing;

                protected ForEnterValue(TypeDescription.Generic target, TypeDescription.Generic enterType, Enter enter) {
                    this(target, enterType, enter.readOnly(), enter.typing());
                }

                protected ForEnterValue(TypeDescription.Generic target, TypeDescription.Generic enterType, boolean readOnly, Assigner.Typing typing) {
                    this.target = target;
                    this.enterType = enterType;
                    this.readOnly = readOnly;
                    this.typing = typing;
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                    StackManipulation readAssignment = assigner.assign(this.enterType, this.target, this.typing);
                    if (!readAssignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + this.enterType + " to " + this.target);
                    }
                    if (this.readOnly) {
                        return new Target.ForVariable.ReadOnly(this.target, instrumentedMethod.getStackSize(), readAssignment);
                    }
                    StackManipulation writeAssignment = assigner.assign(this.target, this.enterType, this.typing);
                    if (!writeAssignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + this.target + " to " + this.enterType);
                    }
                    return new Target.ForVariable.ReadWrite(this.target, instrumentedMethod.getStackSize(), readAssignment, writeAssignment);
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    ForEnterValue that = (ForEnterValue)object;
                    return this.readOnly == that.readOnly && this.target.equals(that.target) && this.enterType.equals(that.enterType) && this.typing == that.typing;
                }

                public int hashCode() {
                    int result = this.target.hashCode();
                    result = 31 * result + this.enterType.hashCode();
                    result = 31 * result + (this.readOnly ? 1 : 0);
                    result = 31 * result + this.typing.hashCode();
                    return result;
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForEnterValue{target=" + this.target + ", enterType=" + this.enterType + ", readOnly=" + this.readOnly + ", typing=" + (Object)((Object)this.typing) + '}';
                }

                protected static class Factory
                implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory {
                    private final TypeDefinition enterType;
                    private final boolean readOnly;

                    protected Factory(TypeDefinition enterType, boolean readOnly) {
                        this.enterType = enterType;
                        this.readOnly = readOnly;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        AnnotationDescription.Loadable<Enter> annotation = parameterDescription.getDeclaredAnnotations().ofType(Enter.class);
                        if (annotation != null) {
                            return new ForEnterValue(parameterDescription.getType(), this.enterType.asGenericType(), annotation.loadSilent());
                        }
                        return UNDEFINED;
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        Factory factory = (Factory)other;
                        return this.readOnly == factory.readOnly && this.enterType.equals(factory.enterType);
                    }

                    public int hashCode() {
                        int result = this.enterType.hashCode();
                        result = 31 * result + (this.readOnly ? 1 : 0);
                        return result;
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForEnterValue.Factory{enterType=" + this.enterType + "m readOnly=" + this.readOnly + '}';
                    }
                }
            }

            public static enum ForStubValue implements OffsetMapping,
            Factory
            {
                INSTANCE;


                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                    return new Target.ForDefaultValue.ReadOnly(instrumentedMethod.getReturnType(), assigner.assign(instrumentedMethod.getReturnType(), TypeDescription.Generic.OBJECT, Assigner.Typing.DYNAMIC));
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                    if (!parameterDescription.getDeclaredAnnotations().isAnnotationPresent(StubValue.class)) {
                        return UNDEFINED;
                    }
                    if (!parameterDescription.getType().represents((java.lang.reflect.Type)((Object)Object.class))) {
                        throw new IllegalStateException("Cannot use StubValue on non-Object parameter type " + parameterDescription);
                    }
                    return this;
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForStubValue." + this.name();
                }
            }

            public static class ForUnusedValue
            implements OffsetMapping {
                private final TypeDefinition target;

                protected ForUnusedValue(TypeDefinition target) {
                    this.target = target;
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                    return new Target.ForDefaultValue.ReadWrite(this.target);
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    ForUnusedValue that = (ForUnusedValue)object;
                    return this.target.equals(that.target);
                }

                public int hashCode() {
                    return this.target.hashCode();
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForUnusedValue{target=" + this.target + '}';
                }

                static enum Factory implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory
                {
                    INSTANCE;


                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        return parameterDescription.getDeclaredAnnotations().isAnnotationPresent(Unused.class) ? new ForUnusedValue(parameterDescription.getType()) : UNDEFINED;
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForUnusedValue.Factory." + this.name();
                    }
                }
            }

            public static class ForOrigin
            implements OffsetMapping {
                private static final char DELIMITER = '#';
                private static final char ESCAPE = '\\';
                private final List<Renderer> renderers;

                protected ForOrigin(List<Renderer> renderers) {
                    this.renderers = renderers;
                }

                protected static OffsetMapping parse(String pattern) {
                    if (pattern.equals("")) {
                        return new ForOrigin(Collections.singletonList(Renderer.ForStringRepresentation.INSTANCE));
                    }
                    ArrayList<Renderer> renderers = new ArrayList<Renderer>(pattern.length());
                    int from = 0;
                    int to = pattern.indexOf(35);
                    while (to != -1) {
                        if (to != 0 && pattern.charAt(to - 1) == '\\' && (to == 1 || pattern.charAt(to - 2) != '\\')) {
                            renderers.add(new Renderer.ForConstantValue(pattern.substring(from, Math.max(0, to - 1)) + '#'));
                            from = to + 1;
                        } else {
                            if (pattern.length() == to + 1) {
                                throw new IllegalStateException("Missing sort descriptor for " + pattern + " at index " + to);
                            }
                            renderers.add(new Renderer.ForConstantValue(pattern.substring(from, to).replace("\\\\", "\\")));
                            switch (pattern.charAt(to + 1)) {
                                case 'm': {
                                    renderers.add(Renderer.ForMethodName.INSTANCE);
                                    break;
                                }
                                case 't': {
                                    renderers.add(Renderer.ForTypeName.INSTANCE);
                                    break;
                                }
                                case 'd': {
                                    renderers.add(Renderer.ForDescriptor.INSTANCE);
                                    break;
                                }
                                case 'r': {
                                    renderers.add(Renderer.ForReturnTypeName.INSTANCE);
                                    break;
                                }
                                case 's': {
                                    renderers.add(Renderer.ForJavaSignature.INSTANCE);
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException("Illegal sort descriptor " + pattern.charAt(to + 1) + " for " + pattern);
                                }
                            }
                            from = to + 2;
                        }
                        to = pattern.indexOf(35, from);
                    }
                    renderers.add(new Renderer.ForConstantValue(pattern.substring(from)));
                    return new ForOrigin(renderers);
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Renderer renderer : this.renderers) {
                        stringBuilder.append(renderer.apply(instrumentedType, instrumentedMethod));
                    }
                    return Target.ForStackManipulation.of(stringBuilder.toString());
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ForOrigin forOrigin = (ForOrigin)other;
                    return this.renderers.equals(forOrigin.renderers);
                }

                public int hashCode() {
                    return this.renderers.hashCode();
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForOrigin{renderers=" + this.renderers + '}';
                }

                protected static enum Factory implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory
                {
                    INSTANCE;


                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        AnnotationDescription.Loadable<Origin> origin = parameterDescription.getDeclaredAnnotations().ofType(Origin.class);
                        if (origin == null) {
                            return UNDEFINED;
                        }
                        if (parameterDescription.getType().asErasure().represents((java.lang.reflect.Type)((Object)Class.class))) {
                            return ForInstrumentedType.INSTANCE;
                        }
                        if (parameterDescription.getType().asErasure().represents((java.lang.reflect.Type)((Object)Method.class))) {
                            return ForInstrumentedMethod.METHOD;
                        }
                        if (parameterDescription.getType().asErasure().represents((java.lang.reflect.Type)((Object)Constructor.class))) {
                            return ForInstrumentedMethod.CONSTRUCTOR;
                        }
                        if (JavaType.EXECUTABLE.getTypeStub().equals(parameterDescription.getType().asErasure())) {
                            return ForInstrumentedMethod.EXECUTABLE;
                        }
                        if (parameterDescription.getType().asErasure().isAssignableFrom(String.class)) {
                            return ForOrigin.parse(origin.loadSilent().value());
                        }
                        throw new IllegalStateException("Non-supported type " + parameterDescription.getType() + " for @Origin annotation");
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForOrigin.Factory." + this.name();
                    }
                }

                protected static interface Renderer {
                    public String apply(TypeDescription var1, MethodDescription var2);

                    public static class ForConstantValue
                    implements Renderer {
                        private final String value;

                        protected ForConstantValue(String value) {
                            this.value = value;
                        }

                        @Override
                        public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                            return this.value;
                        }

                        public boolean equals(Object other) {
                            if (this == other) {
                                return true;
                            }
                            if (other == null || this.getClass() != other.getClass()) {
                                return false;
                            }
                            ForConstantValue that = (ForConstantValue)other;
                            return this.value.equals(that.value);
                        }

                        public int hashCode() {
                            return this.value.hashCode();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.ForOrigin.Renderer.ForConstantValue{value='" + this.value + '\'' + '}';
                        }
                    }

                    public static enum ForStringRepresentation implements Renderer
                    {
                        INSTANCE;


                        @Override
                        public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                            return instrumentedMethod.toString();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.ForOrigin.Renderer.ForStringRepresentation." + this.name();
                        }
                    }

                    public static enum ForReturnTypeName implements Renderer
                    {
                        INSTANCE;

                        public static final char SYMBOL = 'r';

                        @Override
                        public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                            return instrumentedMethod.getReturnType().asErasure().getName();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.ForOrigin.Renderer.ForReturnTypeName." + this.name();
                        }
                    }

                    public static enum ForJavaSignature implements Renderer
                    {
                        INSTANCE;

                        public static final char SYMBOL = 's';

                        @Override
                        public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                            StringBuilder stringBuilder = new StringBuilder("(");
                            boolean comma = false;
                            for (TypeDescription typeDescription : instrumentedMethod.getParameters().asTypeList().asErasures()) {
                                if (comma) {
                                    stringBuilder.append(',');
                                } else {
                                    comma = true;
                                }
                                stringBuilder.append(typeDescription.getName());
                            }
                            return stringBuilder.append(')').toString();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.ForOrigin.Renderer.ForJavaSignature." + this.name();
                        }
                    }

                    public static enum ForDescriptor implements Renderer
                    {
                        INSTANCE;

                        public static final char SYMBOL = 'd';

                        @Override
                        public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                            return instrumentedMethod.getDescriptor();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.ForOrigin.Renderer.ForDescriptor." + this.name();
                        }
                    }

                    public static enum ForTypeName implements Renderer
                    {
                        INSTANCE;

                        public static final char SYMBOL = 't';

                        @Override
                        public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                            return instrumentedType.getName();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.ForOrigin.Renderer.ForTypeName." + this.name();
                        }
                    }

                    public static enum ForMethodName implements Renderer
                    {
                        INSTANCE;

                        public static final char SYMBOL = 'm';

                        @Override
                        public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                            return instrumentedMethod.getInternalName();
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.ForOrigin.Renderer.ForMethodName." + this.name();
                        }
                    }
                }
            }

            public static abstract class ForField
            implements OffsetMapping {
                private static final MethodDescription.InDefinedShape VALUE;
                private static final MethodDescription.InDefinedShape DECLARING_TYPE;
                private static final MethodDescription.InDefinedShape READ_ONLY;
                private static final MethodDescription.InDefinedShape TYPING;
                protected final TypeDescription.Generic target;
                protected final String name;
                protected final boolean readOnly;
                protected final Assigner.Typing typing;

                protected ForField(TypeDescription.Generic target, String name, boolean readOnly, Assigner.Typing typing) {
                    this.target = target;
                    this.name = name;
                    this.readOnly = readOnly;
                    this.typing = typing;
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                    FieldLocator.Resolution resolution = this.fieldLocator(instrumentedType).locate(this.name);
                    if (!resolution.isResolved()) {
                        throw new IllegalStateException("Cannot locate field named " + this.name + " for " + instrumentedMethod);
                    }
                    if (!resolution.getField().isStatic() && instrumentedMethod.isStatic()) {
                        throw new IllegalStateException("Cannot read non-static field " + resolution.getField() + " from static method " + instrumentedMethod);
                    }
                    if (!context.isInitialized() && !resolution.getField().isStatic()) {
                        throw new IllegalStateException("Cannot access non-static field before calling constructor: " + instrumentedMethod);
                    }
                    StackManipulation readAssignment = assigner.assign(resolution.getField().getType(), this.target, this.typing);
                    if (!readAssignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + resolution.getField() + " to " + this.target);
                    }
                    if (this.readOnly) {
                        return new Target.ForField.ReadOnly(resolution.getField(), readAssignment);
                    }
                    StackManipulation writeAssignment = assigner.assign(this.target, resolution.getField().getType(), this.typing);
                    if (!writeAssignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + this.target + " to " + resolution.getField());
                    }
                    return new Target.ForField.ReadWrite((FieldDescription)resolution.getField().asDefined(), readAssignment, writeAssignment);
                }

                protected abstract FieldLocator fieldLocator(TypeDescription var1);

                static {
                    MethodList<MethodDescription.InDefinedShape> methods = new TypeDescription.ForLoadedType(FieldValue.class).getDeclaredMethods();
                    VALUE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("value"))).getOnly();
                    DECLARING_TYPE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("declaringType"))).getOnly();
                    READ_ONLY = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("readOnly"))).getOnly();
                    TYPING = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("typing"))).getOnly();
                }

                protected static enum Factory implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory
                {
                    READ_ONLY(true),
                    READ_WRITE(false);

                    private final boolean readOnly;

                    private Factory(boolean readOnly) {
                        this.readOnly = readOnly;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        AnnotationDescription.Loadable<FieldValue> annotation = parameterDescription.getDeclaredAnnotations().ofType(FieldValue.class);
                        if (annotation == null) {
                            return UNDEFINED;
                        }
                        if (this.readOnly && !annotation.getValue(READ_ONLY).resolve(Boolean.class).booleanValue()) {
                            throw new IllegalStateException("Cannot write to field for " + parameterDescription + " in read-only context");
                        }
                        TypeDescription declaringType = annotation.getValue(DECLARING_TYPE).resolve(TypeDescription.class);
                        return declaringType.represents(Void.TYPE) ? new WithImplicitType(parameterDescription.getType(), annotation) : new WithExplicitType(parameterDescription.getType(), annotation, declaringType);
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForField.Factory." + this.name();
                    }
                }

                protected static class WithExplicitType
                extends ForField {
                    private final TypeDescription declaringType;

                    protected WithExplicitType(TypeDescription.Generic target, AnnotationDescription.Loadable<FieldValue> annotation, TypeDescription declaringType) {
                        this(target, annotation.getValue(VALUE).resolve(String.class), annotation.getValue(READ_ONLY).resolve(Boolean.class), annotation.getValue(TYPING).loadSilent(Assigner.Typing.class.getClassLoader()).resolve(Assigner.Typing.class), declaringType);
                    }

                    protected WithExplicitType(TypeDescription.Generic target, String name, boolean readOnly, Assigner.Typing typing, TypeDescription declaringType) {
                        super(target, name, readOnly, typing);
                        this.declaringType = declaringType;
                    }

                    @Override
                    protected FieldLocator fieldLocator(TypeDescription instrumentedType) {
                        if (!instrumentedType.isAssignableTo(this.declaringType)) {
                            throw new IllegalStateException(this.declaringType + " is no super type of " + instrumentedType);
                        }
                        return new FieldLocator.ForExactType(this.declaringType);
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        WithExplicitType that = (WithExplicitType)object;
                        return this.declaringType.equals(that.declaringType);
                    }

                    public int hashCode() {
                        return this.declaringType.hashCode();
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForField.WithExplicitType{target=" + this.target + ", name=" + this.name + ", readOnly=" + this.readOnly + ", typing=" + (Object)((Object)this.typing) + ", declaringType=" + this.declaringType + '}';
                    }
                }

                protected static class WithImplicitType
                extends ForField {
                    protected WithImplicitType(TypeDescription.Generic target, AnnotationDescription.Loadable<FieldValue> annotation) {
                        this(target, annotation.getValue(VALUE).resolve(String.class), annotation.getValue(READ_ONLY).resolve(Boolean.class), annotation.getValue(TYPING).loadSilent(Assigner.Typing.class.getClassLoader()).resolve(Assigner.Typing.class));
                    }

                    protected WithImplicitType(TypeDescription.Generic target, String name, boolean readOnly, Assigner.Typing typing) {
                        super(target, name, readOnly, typing);
                    }

                    @Override
                    protected FieldLocator fieldLocator(TypeDescription instrumentedType) {
                        return new FieldLocator.ForClassHierarchy(instrumentedType);
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForField.WithImplicitType{target=" + this.target + ", name=" + this.name + ", readOnly=" + this.readOnly + ", typing=" + (Object)((Object)this.typing) + '}';
                    }
                }
            }

            public static enum ForInstrumentedMethod implements OffsetMapping
            {
                METHOD{

                    @Override
                    protected boolean isRepresentable(MethodDescription instrumentedMethod) {
                        return instrumentedMethod.isMethod();
                    }
                }
                ,
                CONSTRUCTOR{

                    @Override
                    protected boolean isRepresentable(MethodDescription instrumentedMethod) {
                        return instrumentedMethod.isConstructor();
                    }
                }
                ,
                EXECUTABLE{

                    @Override
                    protected boolean isRepresentable(MethodDescription instrumentedMethod) {
                        return true;
                    }
                };


                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                    if (!this.isRepresentable(instrumentedMethod)) {
                        throw new IllegalStateException("Cannot represent " + instrumentedMethod + " as given method constant");
                    }
                    return Target.ForStackManipulation.of((MethodDescription.InDefinedShape)instrumentedMethod.asDefined());
                }

                protected abstract boolean isRepresentable(MethodDescription var1);

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForInstrumentedMethod." + this.name();
                }
            }

            public static enum ForInstrumentedType implements OffsetMapping
            {
                INSTANCE;


                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                    return Target.ForStackManipulation.of(instrumentedType);
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForInstrumentedType." + this.name();
                }
            }

            public static class ForAllArguments
            implements OffsetMapping {
                private final TypeDescription.Generic target;
                private final boolean readOnly;
                private final Assigner.Typing typing;

                protected ForAllArguments(TypeDescription.Generic target, AllArguments annotation) {
                    this(target, annotation.readOnly(), annotation.typing());
                }

                protected ForAllArguments(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing) {
                    this.target = target;
                    this.readOnly = readOnly;
                    this.typing = typing;
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                    ArrayList<StackManipulation.Compound> valueReads = new ArrayList<StackManipulation.Compound>(instrumentedMethod.getParameters().size());
                    for (ParameterDescription parameterDescription : instrumentedMethod.getParameters()) {
                        StackManipulation readAssignment = assigner.assign(parameterDescription.getType(), this.target, this.typing);
                        if (!readAssignment.isValid()) {
                            throw new IllegalStateException("Cannot assign " + parameterDescription + " to " + this.target);
                        }
                        valueReads.add(new StackManipulation.Compound(MethodVariableAccess.load(parameterDescription), readAssignment));
                    }
                    if (this.readOnly) {
                        return new Target.ForArray.ReadOnly(this.target, valueReads);
                    }
                    ArrayList<StackManipulation.Compound> valueWrites = new ArrayList<StackManipulation.Compound>(instrumentedMethod.getParameters().size());
                    for (ParameterDescription parameterDescription : instrumentedMethod.getParameters()) {
                        StackManipulation writeAssignment = assigner.assign(this.target, parameterDescription.getType(), this.typing);
                        if (!writeAssignment.isValid()) {
                            throw new IllegalStateException("Cannot assign " + this.target + " to " + parameterDescription);
                        }
                        valueWrites.add(new StackManipulation.Compound(writeAssignment, MethodVariableAccess.store(parameterDescription)));
                    }
                    return new Target.ForArray.ReadWrite(this.target, valueReads, valueWrites);
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    ForAllArguments that = (ForAllArguments)object;
                    return this.readOnly == that.readOnly && this.target.equals(that.target) && this.typing == that.typing;
                }

                public int hashCode() {
                    int result = this.target.hashCode();
                    result = 31 * result + (this.readOnly ? 1 : 0);
                    result = 31 * result + this.typing.hashCode();
                    return result;
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForAllArguments{target=" + this.target + ", readOnly=" + this.readOnly + ", typing=" + (Object)((Object)this.typing) + '}';
                }

                protected static enum Factory implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory
                {
                    READ_ONLY(true),
                    READ_WRITE(false);

                    private final boolean readOnly;

                    private Factory(boolean readOnly) {
                        this.readOnly = readOnly;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        AnnotationDescription.Loadable<AllArguments> annotation = parameterDescription.getDeclaredAnnotations().ofType(AllArguments.class);
                        if (annotation == null) {
                            return UNDEFINED;
                        }
                        if (!parameterDescription.getType().isArray()) {
                            throw new IllegalStateException("Cannot use AllArguments annotation on a non-array type");
                        }
                        if (this.readOnly && !annotation.loadSilent().readOnly()) {
                            throw new IllegalStateException("Cannot define writable field access for " + parameterDescription);
                        }
                        return new ForAllArguments(parameterDescription.getType().getComponentType(), annotation.loadSilent());
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForAllArguments.Factory." + this.name();
                    }
                }
            }

            public static class ForThisReference
            implements OffsetMapping {
                private static final int THIS_REFERENCE = 0;
                private final TypeDescription.Generic target;
                private final boolean readOnly;
                private final Assigner.Typing typing;
                private final boolean optional;

                protected ForThisReference(TypeDescription.Generic target, This annotation) {
                    this(target, annotation.readOnly(), annotation.typing(), annotation.optional());
                }

                protected ForThisReference(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, boolean optional) {
                    this.target = target;
                    this.readOnly = readOnly;
                    this.typing = typing;
                    this.optional = optional;
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                    if (instrumentedMethod.isStatic() || !context.isInitialized()) {
                        if (this.optional) {
                            return this.readOnly ? new Target.ForDefaultValue.ReadOnly(instrumentedType.getDeclaringType()) : new Target.ForDefaultValue.ReadWrite(instrumentedType.getDeclaringType());
                        }
                        throw new IllegalStateException("Cannot map this reference for static method or constructor start: " + instrumentedMethod);
                    }
                    StackManipulation readAssignment = assigner.assign(instrumentedType.asGenericType(), this.target, this.typing);
                    if (!readAssignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + instrumentedType + " to " + this.target);
                    }
                    if (this.readOnly) {
                        return new Target.ForVariable.ReadOnly(instrumentedType.asGenericType(), 0, readAssignment);
                    }
                    StackManipulation writeAssignment = assigner.assign(this.target, instrumentedType.asGenericType(), this.typing);
                    if (!writeAssignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + this.target + " to " + instrumentedType);
                    }
                    return new Target.ForVariable.ReadWrite(instrumentedType.asGenericType(), 0, readAssignment, writeAssignment);
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    ForThisReference that = (ForThisReference)object;
                    return this.readOnly == that.readOnly && this.optional == that.optional && this.target.equals(that.target) && this.typing == that.typing;
                }

                public int hashCode() {
                    int result = this.target.hashCode();
                    result = 31 * result + (this.readOnly ? 1 : 0);
                    result = 31 * result + this.typing.hashCode();
                    result = 31 * result + (this.optional ? 1 : 0);
                    return result;
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForThisReference{target=" + this.target + ", readOnly=" + this.readOnly + ", typing=" + (Object)((Object)this.typing) + ", optional=" + this.optional + '}';
                }

                protected static enum Factory implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory
                {
                    READ_ONLY(true),
                    READ_WRITE(false);

                    private final boolean readOnly;

                    private Factory(boolean readOnly) {
                        this.readOnly = readOnly;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        AnnotationDescription.Loadable<This> annotation = parameterDescription.getDeclaredAnnotations().ofType(This.class);
                        if (annotation == null) {
                            return UNDEFINED;
                        }
                        if (this.readOnly && !annotation.loadSilent().readOnly()) {
                            throw new IllegalStateException("Cannot write to this reference for " + parameterDescription + " in read-only context");
                        }
                        return new ForThisReference(parameterDescription.getType(), annotation.loadSilent());
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForThisReference.Factory." + this.name();
                    }
                }
            }

            public static class ForArgument
            implements OffsetMapping {
                private final TypeDescription.Generic target;
                private final int index;
                private final boolean readOnly;
                private final Assigner.Typing typing;

                protected ForArgument(TypeDescription.Generic target, Argument argument) {
                    this(target, argument.value(), argument.readOnly(), argument.typing());
                }

                protected ForArgument(ParameterDescription parameterDescription, boolean readOnly, Assigner.Typing typing) {
                    this(parameterDescription.getType(), parameterDescription.getIndex(), readOnly, typing);
                }

                protected ForArgument(TypeDescription.Generic target, int index, boolean readOnly, Assigner.Typing typing) {
                    this.target = target;
                    this.index = index;
                    this.readOnly = readOnly;
                    this.typing = typing;
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Context context) {
                    ParameterList<?> parameters = instrumentedMethod.getParameters();
                    if (parameters.size() <= this.index) {
                        throw new IllegalStateException(instrumentedMethod + " does not define an index " + this.index);
                    }
                    StackManipulation readAssignment = assigner.assign(((ParameterDescription)parameters.get(this.index)).getType(), this.target, this.typing);
                    if (!readAssignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + parameters.get(this.index) + " to " + this.target);
                    }
                    if (this.readOnly) {
                        return new Target.ForVariable.ReadOnly((ParameterDescription)parameters.get(this.index), readAssignment);
                    }
                    StackManipulation writeAssignment = assigner.assign(this.target, ((ParameterDescription)parameters.get(this.index)).getType(), this.typing);
                    if (!writeAssignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + parameters.get(this.index) + " to " + this.target);
                    }
                    return new Target.ForVariable.ReadWrite((ParameterDescription)parameters.get(this.index), readAssignment, writeAssignment);
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    ForArgument that = (ForArgument)object;
                    return this.index == that.index && this.readOnly == that.readOnly && this.target.equals(that.target) && this.typing == that.typing;
                }

                public int hashCode() {
                    int result = this.target.hashCode();
                    result = 31 * result + this.index;
                    result = 31 * result + (this.readOnly ? 1 : 0);
                    result = 31 * result + this.typing.hashCode();
                    return result;
                }

                public String toString() {
                    return "Advice.Dispatcher.OffsetMapping.ForArgument{target=" + this.target + ", index=" + this.index + ", readOnly=" + this.readOnly + ", typing=" + (Object)((Object)this.typing) + '}';
                }

                protected static enum Factory implements net.bytebuddy.asm.Advice$Dispatcher$OffsetMapping$Factory
                {
                    READ_ONLY(true),
                    READ_WRITE(false);

                    private final boolean readOnly;

                    private Factory(boolean readOnly) {
                        this.readOnly = readOnly;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape parameterDescription) {
                        AnnotationDescription.Loadable<Argument> annotation = parameterDescription.getDeclaredAnnotations().ofType(Argument.class);
                        if (annotation == null) {
                            return UNDEFINED;
                        }
                        if (this.readOnly && !annotation.loadSilent().readOnly()) {
                            throw new IllegalStateException("Cannot define writable field access for " + parameterDescription);
                        }
                        return new ForArgument(parameterDescription.getType(), annotation.loadSilent());
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.ForArgument.Factory." + this.name();
                    }
                }
            }

            public static interface Factory {
                public static final OffsetMapping UNDEFINED = null;

                public OffsetMapping make(ParameterDescription.InDefinedShape var1);
            }

            public static interface Target {
                public StackManipulation resolveRead();

                public StackManipulation resolveWrite();

                public StackManipulation resolveIncrement(int var1);

                public static class ForStackManipulation
                implements Target {
                    private final StackManipulation stackManipulation;

                    protected ForStackManipulation(StackManipulation stackManipulation) {
                        this.stackManipulation = stackManipulation;
                    }

                    protected static Target of(MethodDescription.InDefinedShape methodDescription) {
                        return new ForStackManipulation(MethodConstant.forMethod(methodDescription));
                    }

                    protected static Target of(TypeDescription typeDescription) {
                        return new ForStackManipulation(ClassConstant.of(typeDescription));
                    }

                    protected static Target of(String value) {
                        return new ForStackManipulation(new TextConstant(value));
                    }

                    protected static Target of(Object value) {
                        if (value instanceof Boolean) {
                            return new ForStackManipulation(IntegerConstant.forValue((Boolean)value));
                        }
                        if (value instanceof Byte) {
                            return new ForStackManipulation(IntegerConstant.forValue(((Byte)value).byteValue()));
                        }
                        if (value instanceof Short) {
                            return new ForStackManipulation(IntegerConstant.forValue(((Short)value).shortValue()));
                        }
                        if (value instanceof Character) {
                            return new ForStackManipulation(IntegerConstant.forValue(((Character)value).charValue()));
                        }
                        if (value instanceof Integer) {
                            return new ForStackManipulation(IntegerConstant.forValue((Integer)value));
                        }
                        if (value instanceof Long) {
                            return new ForStackManipulation(LongConstant.forValue((Long)value));
                        }
                        if (value instanceof Float) {
                            return new ForStackManipulation(FloatConstant.forValue(((Float)value).floatValue()));
                        }
                        if (value instanceof Double) {
                            return new ForStackManipulation(DoubleConstant.forValue((Double)value));
                        }
                        if (value instanceof String) {
                            return new ForStackManipulation(new TextConstant((String)value));
                        }
                        throw new IllegalArgumentException("Not a constant value: " + value);
                    }

                    @Override
                    public StackManipulation resolveRead() {
                        return this.stackManipulation;
                    }

                    @Override
                    public StackManipulation resolveWrite() {
                        throw new IllegalStateException("Cannot write to constant value: " + this.stackManipulation);
                    }

                    @Override
                    public StackManipulation resolveIncrement(int value) {
                        throw new IllegalStateException("Cannot write to constant value: " + this.stackManipulation);
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        ForStackManipulation that = (ForStackManipulation)object;
                        return this.stackManipulation.equals(that.stackManipulation);
                    }

                    public int hashCode() {
                        return this.stackManipulation.hashCode();
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.Target.ForStackManipulation{stackManipulation=" + this.stackManipulation + '}';
                    }
                }

                public static abstract class ForField
                implements Target {
                    protected final FieldDescription fieldDescription;
                    protected final StackManipulation readAssignment;

                    protected ForField(FieldDescription fieldDescription, StackManipulation readAssignment) {
                        this.fieldDescription = fieldDescription;
                        this.readAssignment = readAssignment;
                    }

                    @Override
                    public StackManipulation resolveRead() {
                        return new StackManipulation.Compound(this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), FieldAccess.forField(this.fieldDescription).read(), this.readAssignment);
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        ForField forField = (ForField)object;
                        return this.fieldDescription.equals(forField.fieldDescription) && this.readAssignment.equals(forField.readAssignment);
                    }

                    public int hashCode() {
                        int result = this.fieldDescription.hashCode();
                        result = 31 * result + this.readAssignment.hashCode();
                        return result;
                    }

                    static class ReadWrite
                    extends ForField {
                        private final StackManipulation writeAssignment;

                        protected ReadWrite(FieldDescription fieldDescription, StackManipulation readAssignment, StackManipulation writeAssignment) {
                            super(fieldDescription, readAssignment);
                            this.writeAssignment = writeAssignment;
                        }

                        @Override
                        public StackManipulation resolveWrite() {
                            StackManipulation preparation = this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : new StackManipulation.Compound(MethodVariableAccess.loadThis(), Duplication.SINGLE.flipOver(this.fieldDescription.getType()), Removal.SINGLE);
                            return new StackManipulation.Compound(preparation, FieldAccess.forField(this.fieldDescription).write());
                        }

                        @Override
                        public StackManipulation resolveIncrement(int value) {
                            return new StackManipulation.Compound(this.resolveRead(), IntegerConstant.forValue(value), Addition.INTEGER, this.resolveWrite());
                        }

                        @Override
                        public boolean equals(Object object) {
                            if (this == object) {
                                return true;
                            }
                            if (object == null || this.getClass() != object.getClass()) {
                                return false;
                            }
                            if (!super.equals(object)) {
                                return false;
                            }
                            ReadWrite readWrite = (ReadWrite)object;
                            return this.writeAssignment.equals(readWrite.writeAssignment);
                        }

                        @Override
                        public int hashCode() {
                            int result = super.hashCode();
                            result = 31 * result + this.writeAssignment.hashCode();
                            return result;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.Target.ForField.ReadWrite{fieldDescription=" + this.fieldDescription + ", readAssignment=" + this.readAssignment + ", writeAssignment=" + this.writeAssignment + '}';
                        }
                    }

                    static class ReadOnly
                    extends ForField {
                        protected ReadOnly(FieldDescription fieldDescription, StackManipulation readAssignment) {
                            super(fieldDescription, readAssignment);
                        }

                        @Override
                        public StackManipulation resolveWrite() {
                            throw new IllegalStateException("Cannot write to read-only field value");
                        }

                        @Override
                        public StackManipulation resolveIncrement(int value) {
                            throw new IllegalStateException("Cannot write to read-only field value");
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.Target.ForField.ReadOnly{fieldDescription=" + this.fieldDescription + ", readAssignment=" + this.readAssignment + '}';
                        }
                    }
                }

                public static abstract class ForArray
                implements Target {
                    protected final TypeDescription.Generic target;
                    protected final List<? extends StackManipulation> valueReads;

                    protected ForArray(TypeDescription.Generic target, List<? extends StackManipulation> valueReads) {
                        this.target = target;
                        this.valueReads = valueReads;
                    }

                    @Override
                    public StackManipulation resolveRead() {
                        return ArrayFactory.forType(this.target).withValues(this.valueReads);
                    }

                    @Override
                    public StackManipulation resolveIncrement(int value) {
                        throw new IllegalStateException("Cannot increment read-only array value");
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        ForArray forArray = (ForArray)object;
                        return this.target.equals(forArray.target) && this.valueReads.equals(forArray.valueReads);
                    }

                    public int hashCode() {
                        int result = this.target.hashCode();
                        result = 31 * result + this.valueReads.hashCode();
                        return result;
                    }

                    protected static class ReadWrite
                    extends ForArray {
                        private final List<? extends StackManipulation> valueWrites;

                        protected ReadWrite(TypeDescription.Generic target, List<? extends StackManipulation> valueReads, List<? extends StackManipulation> valueWrites) {
                            super(target, valueReads);
                            this.valueWrites = valueWrites;
                        }

                        @Override
                        public StackManipulation resolveWrite() {
                            return ArrayAccess.of(this.target).forEach(this.valueWrites);
                        }

                        @Override
                        public boolean equals(Object object) {
                            if (this == object) {
                                return true;
                            }
                            if (object == null || this.getClass() != object.getClass()) {
                                return false;
                            }
                            if (!super.equals(object)) {
                                return false;
                            }
                            ReadWrite readWrite = (ReadWrite)object;
                            return this.valueWrites.equals(readWrite.valueWrites);
                        }

                        @Override
                        public int hashCode() {
                            int result = super.hashCode();
                            result = 31 * result + this.valueWrites.hashCode();
                            return result;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.Target.ForArray.ReadWrite{target=" + this.target + ", valueReads=" + this.valueReads + ", valueWrites=" + this.valueWrites + '}';
                        }
                    }

                    protected static class ReadOnly
                    extends ForArray {
                        protected ReadOnly(TypeDescription.Generic target, List<? extends StackManipulation> valueReads) {
                            super(target, valueReads);
                        }

                        @Override
                        public StackManipulation resolveWrite() {
                            throw new IllegalStateException("Cannot write to read-only array value");
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.Target.ForArray.ReadOnly{target=" + this.target + ", valueReads=" + this.valueReads + '}';
                        }
                    }
                }

                public static abstract class ForVariable
                implements Target {
                    protected final TypeDefinition typeDefinition;
                    protected final int offset;
                    protected final StackManipulation readAssignment;

                    protected ForVariable(TypeDefinition typeDefinition, int offset, StackManipulation readAssignment) {
                        this.typeDefinition = typeDefinition;
                        this.offset = offset;
                        this.readAssignment = readAssignment;
                    }

                    @Override
                    public StackManipulation resolveRead() {
                        return new StackManipulation.Compound(MethodVariableAccess.of(this.typeDefinition).loadFrom(this.offset), this.readAssignment);
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        ForVariable that = (ForVariable)object;
                        return this.offset == that.offset && this.typeDefinition.equals(that.typeDefinition) && this.readAssignment.equals(that.readAssignment);
                    }

                    public int hashCode() {
                        int result = this.typeDefinition.hashCode();
                        result = 31 * result + this.offset;
                        result = 31 * result + this.readAssignment.hashCode();
                        return result;
                    }

                    protected static class ReadWrite
                    extends ForVariable {
                        private final StackManipulation writeAssignment;

                        protected ReadWrite(ParameterDescription parameterDescription, StackManipulation readAssignment, StackManipulation writeAssignment) {
                            this(parameterDescription.getType(), parameterDescription.getOffset(), readAssignment, writeAssignment);
                        }

                        protected ReadWrite(TypeDefinition typeDefinition, int offset, StackManipulation readAssignment, StackManipulation writeAssignment) {
                            super(typeDefinition, offset, readAssignment);
                            this.writeAssignment = writeAssignment;
                        }

                        @Override
                        public StackManipulation resolveWrite() {
                            return new StackManipulation.Compound(this.writeAssignment, MethodVariableAccess.of(this.typeDefinition).storeAt(this.offset));
                        }

                        @Override
                        public StackManipulation resolveIncrement(int value) {
                            return this.typeDefinition.represents(Integer.TYPE) ? MethodVariableAccess.of(this.typeDefinition).increment(this.offset, value) : new StackManipulation.Compound(this.resolveRead(), IntegerConstant.forValue(1), Addition.INTEGER, this.resolveWrite());
                        }

                        @Override
                        public boolean equals(Object object) {
                            if (this == object) {
                                return true;
                            }
                            if (object == null || this.getClass() != object.getClass()) {
                                return false;
                            }
                            if (!super.equals(object)) {
                                return false;
                            }
                            ReadWrite readWrite = (ReadWrite)object;
                            return this.writeAssignment.equals(readWrite.writeAssignment);
                        }

                        @Override
                        public int hashCode() {
                            int result = super.hashCode();
                            result = 31 * result + this.writeAssignment.hashCode();
                            return result;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.Target.ForVariable.ReadWrite{typeDefinition=" + this.typeDefinition + ", offset=" + this.offset + ", readAssignment=" + this.readAssignment + ", writeAssignment=" + this.writeAssignment + "}";
                        }
                    }

                    protected static class ReadOnly
                    extends ForVariable {
                        protected ReadOnly(ParameterDescription parameterDescription, StackManipulation readAssignment) {
                            this(parameterDescription.getType(), parameterDescription.getOffset(), readAssignment);
                        }

                        protected ReadOnly(TypeDefinition typeDefinition, int offset, StackManipulation readAssignment) {
                            super(typeDefinition, offset, readAssignment);
                        }

                        @Override
                        public StackManipulation resolveWrite() {
                            throw new IllegalStateException("Cannot write to read-only parameter " + this.typeDefinition + " at " + this.offset);
                        }

                        @Override
                        public StackManipulation resolveIncrement(int value) {
                            throw new IllegalStateException("Cannot write to read-only variable " + this.typeDefinition + " at " + this.offset);
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.Target.ForVariable.ReadOnly{typeDefinition=" + this.typeDefinition + ", offset=" + this.offset + ", readAssignment=" + this.readAssignment + "}";
                        }
                    }
                }

                public static abstract class ForDefaultValue
                implements Target {
                    protected final TypeDefinition typeDefinition;
                    protected final StackManipulation readAssignment;

                    protected ForDefaultValue(TypeDefinition typeDefinition, StackManipulation readAssignment) {
                        this.typeDefinition = typeDefinition;
                        this.readAssignment = readAssignment;
                    }

                    @Override
                    public StackManipulation resolveRead() {
                        return new StackManipulation.Compound(DefaultValue.of(this.typeDefinition), this.readAssignment);
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        ForDefaultValue that = (ForDefaultValue)object;
                        return this.typeDefinition.equals(that.typeDefinition) && this.readAssignment.equals(that.readAssignment);
                    }

                    public int hashCode() {
                        int result = this.typeDefinition.hashCode();
                        result = 31 * result + this.readAssignment.hashCode();
                        return result;
                    }

                    protected static class ReadWrite
                    extends ForDefaultValue {
                        protected ReadWrite(TypeDefinition typeDefinition) {
                            this(typeDefinition, StackManipulation.Trivial.INSTANCE);
                        }

                        protected ReadWrite(TypeDefinition typeDefinition, StackManipulation readAssignment) {
                            super(typeDefinition, readAssignment);
                        }

                        @Override
                        public StackManipulation resolveWrite() {
                            return Removal.of(this.typeDefinition);
                        }

                        @Override
                        public StackManipulation resolveIncrement(int value) {
                            return StackManipulation.Trivial.INSTANCE;
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.Target.ForDefaultValue.ReadWrite{typeDefinition=" + this.typeDefinition + ", readAssignment=" + this.readAssignment + "}";
                        }
                    }

                    protected static class ReadOnly
                    extends ForDefaultValue {
                        protected ReadOnly(TypeDefinition typeDefinition) {
                            this(typeDefinition, StackManipulation.Trivial.INSTANCE);
                        }

                        protected ReadOnly(TypeDefinition typeDefinition, StackManipulation readAssignment) {
                            super(typeDefinition, readAssignment);
                        }

                        @Override
                        public StackManipulation resolveWrite() {
                            throw new IllegalStateException("Cannot write to read-only default value");
                        }

                        @Override
                        public StackManipulation resolveIncrement(int value) {
                            throw new IllegalStateException("Cannot write to read-only default value");
                        }

                        public String toString() {
                            return "Advice.Dispatcher.OffsetMapping.Target.ForDefaultValue.ReadOnly{typeDefinition=" + this.typeDefinition + ", readAssignment=" + this.readAssignment + "}";
                        }
                    }
                }
            }

            public static interface Context {
                public boolean isInitialized();

                public int getPadding();

                public static enum ForMethodExit implements Context
                {
                    ZERO(StackSize.ZERO),
                    SINGLE(StackSize.SINGLE),
                    DOUBLE(StackSize.DOUBLE);

                    private final StackSize stackSize;

                    private ForMethodExit(StackSize stackSize) {
                        this.stackSize = stackSize;
                    }

                    protected static Context of(TypeDefinition typeDescription) {
                        switch (typeDescription.getStackSize()) {
                            case ZERO: {
                                return ZERO;
                            }
                            case SINGLE: {
                                return SINGLE;
                            }
                            case DOUBLE: {
                                return DOUBLE;
                            }
                        }
                        throw new IllegalStateException("Unknown stack size: " + typeDescription);
                    }

                    @Override
                    public boolean isInitialized() {
                        return true;
                    }

                    @Override
                    public int getPadding() {
                        return this.stackSize.getSize();
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.Context.ForMethodExit." + this.name();
                    }
                }

                public static enum ForMethodEntry implements Context
                {
                    INITIALIZED(true),
                    NON_INITIALIZED(false);

                    private final boolean initialized;

                    protected static Context of(MethodDescription instrumentedMethod) {
                        return instrumentedMethod.isConstructor() ? NON_INITIALIZED : INITIALIZED;
                    }

                    private ForMethodEntry(boolean initialized) {
                        this.initialized = initialized;
                    }

                    @Override
                    public boolean isInitialized() {
                        return this.initialized;
                    }

                    @Override
                    public int getPadding() {
                        return StackSize.ZERO.getSize();
                    }

                    public String toString() {
                        return "Advice.Dispatcher.OffsetMapping.Context.ForMethodEntry." + this.name();
                    }
                }
            }
        }

        public static interface Unresolved
        extends Dispatcher {
            public boolean isBinary();

            public Resolved.ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory> var1, ClassReader var2);

            public Resolved.ForMethodExit asMethodExitTo(List<? extends OffsetMapping.Factory> var1, ClassReader var2, Resolved.ForMethodEnter var3);
        }
    }

    protected static interface StackMapFrameHandler {
        public void translateFrame(MethodVisitor var1, int var2, int var3, Object[] var4, int var5, Object[] var6);

        public void injectReturnFrame(MethodVisitor var1);

        public void injectExceptionFrame(MethodVisitor var1);

        public void injectCompletionFrame(MethodVisitor var1, boolean var2);

        public static class Default
        implements ForInstrumentedMethod {
            private static final Object[] EMPTY = new Object[0];
            private final TypeDescription instrumentedType;
            protected final MethodDescription instrumentedMethod;
            protected final TypeList requiredTypes;
            protected final TypeList yieldedTypes;
            private final boolean expandFrames;
            private int currentFrameDivergence;

            protected Default(TypeDescription instrumentedType, MethodDescription instrumentedMethod, TypeList requiredTypes, TypeList yieldedTypes, boolean expandFrames) {
                this.instrumentedType = instrumentedType;
                this.instrumentedMethod = instrumentedMethod;
                this.requiredTypes = requiredTypes;
                this.yieldedTypes = yieldedTypes;
                this.expandFrames = expandFrames;
            }

            protected static ForInstrumentedMethod of(TypeDescription instrumentedType, MethodDescription instrumentedMethod, List<? extends TypeDescription> requiredTypes, List<? extends TypeDescription> yieldedTypes, ClassFileVersion classFileVersion, int writerFlags, int readerFlags) {
                return (writerFlags & 2) != 0 || classFileVersion.isLessThan(ClassFileVersion.JAVA_V6) ? NoOp.INSTANCE : new Default(instrumentedType, instrumentedMethod, new TypeList.Explicit(requiredTypes), new TypeList.Explicit(yieldedTypes), (readerFlags & 8) != 0);
            }

            protected static Object toFrame(TypeDescription typeDescription) {
                if (typeDescription.represents(Boolean.TYPE) || typeDescription.represents(Byte.TYPE) || typeDescription.represents(Short.TYPE) || typeDescription.represents(Character.TYPE) || typeDescription.represents(Integer.TYPE)) {
                    return Opcodes.INTEGER;
                }
                if (typeDescription.represents(Long.TYPE)) {
                    return Opcodes.LONG;
                }
                if (typeDescription.represents(Float.TYPE)) {
                    return Opcodes.FLOAT;
                }
                if (typeDescription.represents(Double.TYPE)) {
                    return Opcodes.DOUBLE;
                }
                return typeDescription.getInternalName();
            }

            @Override
            public net.bytebuddy.asm.Advice$StackMapFrameHandler$ForAdvice bindEntry(MethodDescription.InDefinedShape adviceMethod) {
                return new ForAdvice(adviceMethod, new TypeList.Empty(), this.requiredTypes, TranslationMode.ENTRY);
            }

            @Override
            public net.bytebuddy.asm.Advice$StackMapFrameHandler$ForAdvice bindExit(MethodDescription.InDefinedShape adviceMethod) {
                return new ForAdvice(adviceMethod, new TypeList.Explicit(CompoundList.of(this.requiredTypes, this.yieldedTypes)), new TypeList.Empty(), TranslationMode.EXIT);
            }

            @Override
            public int getReaderHint() {
                return this.expandFrames ? 8 : 0;
            }

            @Override
            public void translateFrame(MethodVisitor methodVisitor, int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
                this.translateFrame(methodVisitor, TranslationMode.COPY, this.instrumentedMethod, this.requiredTypes, type, localVariableLength, localVariable, stackSize, stack);
            }

            protected void translateFrame(MethodVisitor methodVisitor, TranslationMode translationMode, MethodDescription methodDescription, TypeList additionalTypes, int frameType, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
                switch (frameType) {
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 1: {
                        this.currentFrameDivergence += localVariableLength;
                        break;
                    }
                    case 2: {
                        this.currentFrameDivergence -= localVariableLength;
                        break;
                    }
                    case -1: 
                    case 0: {
                        Object[] translated = new Object[localVariableLength - methodDescription.getParameters().size() - (methodDescription.isStatic() ? 0 : 1) + this.instrumentedMethod.getParameters().size() + (this.instrumentedMethod.isStatic() ? 0 : 1) + additionalTypes.size()];
                        int index = translationMode.copy(this.instrumentedType, this.instrumentedMethod, methodDescription, localVariable, translated);
                        for (TypeDescription typeDescription : additionalTypes) {
                            translated[index++] = Default.toFrame(typeDescription);
                        }
                        System.arraycopy(localVariable, methodDescription.getParameters().size() + (methodDescription.isStatic() ? 0 : 1), translated, index, translated.length - index);
                        localVariableLength = translated.length;
                        localVariable = translated;
                        this.currentFrameDivergence = translated.length - index;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected frame type: " + frameType);
                    }
                }
                methodVisitor.visitFrame(frameType, localVariableLength, localVariable, stackSize, stack);
            }

            @Override
            public void injectReturnFrame(MethodVisitor methodVisitor) {
                if (!this.expandFrames && this.currentFrameDivergence == 0 && !this.instrumentedMethod.isConstructor()) {
                    if (this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        methodVisitor.visitFrame(3, 0, EMPTY, 0, EMPTY);
                    } else {
                        methodVisitor.visitFrame(4, 0, EMPTY, 1, new Object[]{Default.toFrame(this.instrumentedMethod.getReturnType().asErasure())});
                    }
                } else {
                    this.injectFullFrame(methodVisitor, this.requiredTypes, this.instrumentedMethod.getReturnType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(this.instrumentedMethod.getReturnType().asErasure()));
                }
            }

            @Override
            public void injectExceptionFrame(MethodVisitor methodVisitor) {
                if (!this.expandFrames && this.currentFrameDivergence == 0) {
                    methodVisitor.visitFrame(4, 0, EMPTY, 1, new Object[]{Type.getInternalName(Throwable.class)});
                } else {
                    this.injectFullFrame(methodVisitor, this.requiredTypes, Collections.singletonList(TypeDescription.THROWABLE));
                }
            }

            @Override
            public void injectCompletionFrame(MethodVisitor methodVisitor, boolean secondary) {
                if (!(this.expandFrames || this.currentFrameDivergence != 0 || !secondary && this.instrumentedMethod.isConstructor())) {
                    if (secondary) {
                        methodVisitor.visitFrame(3, 0, EMPTY, 0, EMPTY);
                    } else {
                        Object[] local = new Object[this.yieldedTypes.size()];
                        int index = 0;
                        for (TypeDescription typeDescription : this.yieldedTypes) {
                            local[index++] = Default.toFrame(typeDescription);
                        }
                        methodVisitor.visitFrame(1, local.length, local, 0, EMPTY);
                    }
                } else {
                    this.injectFullFrame(methodVisitor, CompoundList.of(this.requiredTypes, this.yieldedTypes), Collections.emptyList());
                }
            }

            protected void injectFullFrame(MethodVisitor methodVisitor, List<? extends TypeDescription> typesInArray, List<? extends TypeDescription> typesOnStack) {
                Object[] localVariable = new Object[this.instrumentedMethod.getParameters().size() + (this.instrumentedMethod.isStatic() ? 0 : 1) + typesInArray.size()];
                int index = 0;
                if (!this.instrumentedMethod.isStatic()) {
                    localVariable[index++] = Default.toFrame(this.instrumentedType);
                }
                for (TypeDescription typeDescription : this.instrumentedMethod.getParameters().asTypeList().asErasures()) {
                    localVariable[index++] = Default.toFrame(typeDescription);
                }
                for (TypeDescription typeDescription : typesInArray) {
                    localVariable[index++] = Default.toFrame(typeDescription);
                }
                index = 0;
                Object[] stackType = new Object[typesOnStack.size()];
                for (TypeDescription typeDescription : typesOnStack) {
                    stackType[index++] = Default.toFrame(typeDescription);
                }
                methodVisitor.visitFrame(this.expandFrames ? -1 : 0, localVariable.length, localVariable, stackType.length, stackType);
                this.currentFrameDivergence = 0;
            }

            public String toString() {
                return "Advice.StackMapFrameHandler.Default{instrumentedType=" + this.instrumentedType + ", instrumentedMethod=" + this.instrumentedMethod + ", requiredTypes=" + this.requiredTypes + ", yieldedTypes=" + this.yieldedTypes + ", expandFrames=" + this.expandFrames + ", currentFrameDivergence=" + this.currentFrameDivergence + '}';
            }

            protected class ForAdvice
            implements net.bytebuddy.asm.Advice$StackMapFrameHandler$ForAdvice {
                protected final MethodDescription.InDefinedShape adviceMethod;
                protected final TypeList requiredTypes;
                private final TypeList yieldedTypes;
                protected final TranslationMode translationMode;

                protected ForAdvice(MethodDescription.InDefinedShape adviceMethod, TypeList requiredTypes, TypeList yieldedTypes, TranslationMode translationMode) {
                    this.adviceMethod = adviceMethod;
                    this.requiredTypes = requiredTypes;
                    this.yieldedTypes = yieldedTypes;
                    this.translationMode = translationMode;
                }

                @Override
                public void translateFrame(MethodVisitor methodVisitor, int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
                    Default.this.translateFrame(methodVisitor, this.translationMode, this.adviceMethod, this.requiredTypes, type, localVariableLength, localVariable, stackSize, stack);
                }

                @Override
                public void injectReturnFrame(MethodVisitor methodVisitor) {
                    if (!Default.this.expandFrames && Default.this.currentFrameDivergence == 0) {
                        if (this.yieldedTypes.isEmpty() || this.adviceMethod.getReturnType().represents(Void.TYPE)) {
                            methodVisitor.visitFrame(3, 0, EMPTY, 0, EMPTY);
                        } else {
                            methodVisitor.visitFrame(4, 0, EMPTY, 1, new Object[]{Default.toFrame(this.adviceMethod.getReturnType().asErasure())});
                        }
                    } else {
                        Default.this.injectFullFrame(methodVisitor, this.requiredTypes, this.yieldedTypes.isEmpty() || this.adviceMethod.getReturnType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(this.adviceMethod.getReturnType().asErasure()));
                    }
                }

                @Override
                public void injectExceptionFrame(MethodVisitor methodVisitor) {
                    if (!Default.this.expandFrames && Default.this.currentFrameDivergence == 0) {
                        methodVisitor.visitFrame(4, 0, EMPTY, 1, new Object[]{Type.getInternalName(Throwable.class)});
                    } else {
                        Default.this.injectFullFrame(methodVisitor, this.requiredTypes, Collections.singletonList(TypeDescription.THROWABLE));
                    }
                }

                @Override
                public void injectCompletionFrame(MethodVisitor methodVisitor, boolean secondary) {
                    if (!Default.this.expandFrames && Default.this.currentFrameDivergence == 0 && this.yieldedTypes.size() < 4) {
                        if (secondary || this.yieldedTypes.isEmpty()) {
                            methodVisitor.visitFrame(3, 0, EMPTY, 0, EMPTY);
                        } else {
                            Object[] local = new Object[this.yieldedTypes.size()];
                            int index = 0;
                            for (TypeDescription typeDescription : this.yieldedTypes) {
                                local[index++] = Default.toFrame(typeDescription);
                            }
                            methodVisitor.visitFrame(1, local.length, local, 0, EMPTY);
                        }
                    } else {
                        Default.this.injectFullFrame(methodVisitor, CompoundList.of(this.requiredTypes, this.yieldedTypes), Collections.emptyList());
                    }
                }

                public String toString() {
                    return "Advice.StackMapFrameHandler.Default.ForAdvice{adviceMethod=" + this.adviceMethod + ", requiredTypes=" + this.requiredTypes + ", yieldedTypes=" + this.yieldedTypes + ", translationMode=" + (Object)((Object)this.translationMode) + '}';
                }
            }

            protected static enum TranslationMode {
                COPY{

                    @Override
                    protected int copy(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription methodDescription, Object[] localVariable, Object[] translated) {
                        int length = instrumentedMethod.getParameters().size() + (instrumentedMethod.isStatic() ? 0 : 1);
                        System.arraycopy(localVariable, 0, translated, 0, length);
                        return length;
                    }
                }
                ,
                ENTRY{

                    @Override
                    protected int copy(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription methodDescription, Object[] localVariable, Object[] translated) {
                        int index = 0;
                        if (!instrumentedMethod.isStatic()) {
                            translated[index++] = instrumentedMethod.isConstructor() ? Opcodes.UNINITIALIZED_THIS : Default.toFrame(instrumentedType);
                        }
                        for (TypeDescription typeDescription : instrumentedMethod.getParameters().asTypeList().asErasures()) {
                            translated[index++] = Default.toFrame(typeDescription);
                        }
                        return index;
                    }
                }
                ,
                EXIT{

                    @Override
                    protected int copy(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription methodDescription, Object[] localVariable, Object[] translated) {
                        int index = 0;
                        if (!instrumentedMethod.isStatic()) {
                            translated[index++] = Default.toFrame(instrumentedType);
                        }
                        for (TypeDescription typeDescription : instrumentedMethod.getParameters().asTypeList().asErasures()) {
                            translated[index++] = Default.toFrame(typeDescription);
                        }
                        return index;
                    }
                };


                protected abstract int copy(TypeDescription var1, MethodDescription var2, MethodDescription var3, Object[] var4, Object[] var5);

                public String toString() {
                    return "Advice.StackMapFrameHandler.Default.TranslationMode." + this.name();
                }
            }
        }

        public static enum NoOp implements ForInstrumentedMethod,
        ForAdvice
        {
            INSTANCE;


            @Override
            public ForAdvice bindEntry(MethodDescription.InDefinedShape adviceMethod) {
                return this;
            }

            @Override
            public ForAdvice bindExit(MethodDescription.InDefinedShape adviceMethod) {
                return this;
            }

            @Override
            public int getReaderHint() {
                return 4;
            }

            @Override
            public void translateFrame(MethodVisitor methodVisitor, int frameType, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
            }

            @Override
            public void injectReturnFrame(MethodVisitor methodVisitor) {
            }

            @Override
            public void injectExceptionFrame(MethodVisitor methodVisitor) {
            }

            @Override
            public void injectCompletionFrame(MethodVisitor methodVisitor, boolean secondary) {
            }

            public String toString() {
                return "Advice.StackMapFrameHandler.NoOp." + this.name();
            }
        }

        public static interface ForAdvice
        extends StackMapFrameHandler {
        }

        public static interface ForInstrumentedMethod
        extends StackMapFrameHandler {
            public ForAdvice bindEntry(MethodDescription.InDefinedShape var1);

            public ForAdvice bindExit(MethodDescription.InDefinedShape var1);

            public int getReaderHint();
        }
    }

    protected static interface MethodSizeHandler {
        public static final int UNDEFINED_SIZE = Short.MAX_VALUE;

        public void requireLocalVariableLength(int var1);

        public static class Default
        implements ForInstrumentedMethod {
            private final MethodDescription instrumentedMethod;
            private final TypeList requiredTypes;
            private final TypeList yieldedTypes;
            private int stackSize;
            private int localVariableLength;

            protected Default(MethodDescription instrumentedMethod, TypeList requiredTypes, TypeList yieldedTypes) {
                this.instrumentedMethod = instrumentedMethod;
                this.requiredTypes = requiredTypes;
                this.yieldedTypes = yieldedTypes;
            }

            protected static ForInstrumentedMethod of(MethodDescription instrumentedMethod, List<? extends TypeDescription> requiredTypes, List<? extends TypeDescription> yieldedTypes, int writerFlags) {
                return (writerFlags & 3) != 0 ? NoOp.INSTANCE : new Default(instrumentedMethod, new TypeList.Explicit(requiredTypes), new TypeList.Explicit(yieldedTypes));
            }

            @Override
            public net.bytebuddy.asm.Advice$MethodSizeHandler$ForAdvice bindEntry(MethodDescription.InDefinedShape adviceMethod) {
                this.stackSize = Math.max(this.stackSize, adviceMethod.getReturnType().getStackSize().getSize());
                return new ForAdvice(adviceMethod, new TypeList.Empty(), new TypeList.Explicit(this.requiredTypes));
            }

            @Override
            public net.bytebuddy.asm.Advice$MethodSizeHandler$ForAdvice bindExit(MethodDescription.InDefinedShape adviceMethod, boolean skipThrowable) {
                this.stackSize = Math.max(this.stackSize, adviceMethod.getReturnType().getStackSize().maximum(skipThrowable ? StackSize.ZERO : StackSize.SINGLE).getSize());
                return new ForAdvice(adviceMethod, new TypeList.Explicit(CompoundList.of(this.requiredTypes, this.yieldedTypes)), new TypeList.Empty());
            }

            @Override
            public int compoundStackSize(int stackSize) {
                return Math.max(this.stackSize, stackSize);
            }

            @Override
            public int compoundLocalVariableLength(int localVariableLength) {
                return Math.max(this.localVariableLength, localVariableLength + this.requiredTypes.getStackSize() + this.yieldedTypes.getStackSize());
            }

            @Override
            public void requireLocalVariableLength(int localVariableLength) {
                this.localVariableLength = Math.max(this.localVariableLength, localVariableLength);
            }

            public String toString() {
                return "Advice.MethodSizeHandler.Default{instrumentedMethod=" + this.instrumentedMethod + ", requiredTypes=" + this.requiredTypes + ", yieldedTypes=" + this.yieldedTypes + ", stackSize=" + this.stackSize + ", localVariableLength=" + this.localVariableLength + '}';
            }

            protected class ForAdvice
            implements net.bytebuddy.asm.Advice$MethodSizeHandler$ForAdvice {
                private final MethodDescription.InDefinedShape adviceMethod;
                private final TypeList requiredTypes;
                private final TypeList yieldedTypes;
                private int padding;

                protected ForAdvice(MethodDescription.InDefinedShape adviceMethod, TypeList requiredTypes, TypeList yieldedTypes) {
                    this.adviceMethod = adviceMethod;
                    this.requiredTypes = requiredTypes;
                    this.yieldedTypes = yieldedTypes;
                    Default.this.stackSize = Math.max(Default.this.stackSize, adviceMethod.getReturnType().getStackSize().getSize());
                }

                @Override
                public void requireLocalVariableLength(int localVariableLength) {
                    Default.this.requireLocalVariableLength(localVariableLength);
                }

                @Override
                public void requireStackSize(int stackSize) {
                    Default.this.stackSize = Math.max(Default.this.stackSize, stackSize);
                }

                @Override
                public void recordMaxima(int stackSize, int localVariableLength) {
                    Default.this.stackSize = Math.max(Default.this.stackSize, stackSize) + this.padding;
                    Default.this.localVariableLength = Math.max(Default.this.localVariableLength, localVariableLength - this.adviceMethod.getStackSize() + Default.this.instrumentedMethod.getStackSize() + this.requiredTypes.getStackSize() + this.yieldedTypes.getStackSize());
                }

                @Override
                public void recordPadding(int padding) {
                    this.padding = Math.max(this.padding, padding);
                }

                public String toString() {
                    return "Advice.MethodSizeHandler.Default.ForAdvice{adviceMethod=" + this.adviceMethod + ", requiredTypes=" + this.requiredTypes + ", yieldedTypes=" + this.yieldedTypes + ", padding=" + this.padding + '}';
                }
            }
        }

        public static enum NoOp implements ForInstrumentedMethod,
        ForAdvice
        {
            INSTANCE;


            @Override
            public ForAdvice bindEntry(MethodDescription.InDefinedShape adviceMethod) {
                return this;
            }

            @Override
            public ForAdvice bindExit(MethodDescription.InDefinedShape adviceMethod, boolean skipThrowable) {
                return this;
            }

            @Override
            public int compoundStackSize(int stackSize) {
                return Short.MAX_VALUE;
            }

            @Override
            public int compoundLocalVariableLength(int localVariableLength) {
                return Short.MAX_VALUE;
            }

            @Override
            public void requireLocalVariableLength(int localVariableLength) {
            }

            @Override
            public void requireStackSize(int stackSize) {
            }

            @Override
            public void recordMaxima(int stackSize, int localVariableLength) {
            }

            @Override
            public void recordPadding(int padding) {
            }

            public String toString() {
                return "Advice.MethodSizeHandler.NoOp." + this.name();
            }
        }

        public static interface ForAdvice
        extends MethodSizeHandler {
            public void requireStackSize(int var1);

            public void recordMaxima(int var1, int var2);

            public void recordPadding(int var1);
        }

        public static interface ForInstrumentedMethod
        extends MethodSizeHandler {
            public ForAdvice bindEntry(MethodDescription.InDefinedShape var1);

            public ForAdvice bindExit(MethodDescription.InDefinedShape var1, boolean var2);

            public int compoundStackSize(int var1);

            public int compoundLocalVariableLength(int var1);
        }
    }
}

