/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.FieldLocator;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;

public abstract class FieldAccessor
implements Implementation {
    protected final FieldNameExtractor fieldNameExtractor;
    protected final FieldLocator.Factory fieldLocatorFactory;
    protected final Assigner assigner;
    protected final Assigner.Typing typing;

    protected FieldAccessor(FieldNameExtractor fieldNameExtractor, FieldLocator.Factory fieldLocatorFactory, Assigner assigner, Assigner.Typing typing) {
        this.fieldNameExtractor = fieldNameExtractor;
        this.fieldLocatorFactory = fieldLocatorFactory;
        this.assigner = assigner;
        this.typing = typing;
    }

    public static OwnerTypeLocatable ofField(String name) {
        return FieldAccessor.of(new FieldNameExtractor.ForFixedValue(name));
    }

    public static OwnerTypeLocatable ofBeanProperty() {
        return FieldAccessor.of(FieldNameExtractor.ForBeanProperty.INSTANCE);
    }

    public static OwnerTypeLocatable of(FieldNameExtractor fieldNameExtractor) {
        return new ForImplicitProperty(fieldNameExtractor, FieldLocator.ForClassHierarchy.Factory.INSTANCE);
    }

    protected StackManipulation getter(FieldDescription fieldDescription, MethodDescription instrumentedMethod) {
        return this.access(fieldDescription, instrumentedMethod, new StackManipulation.Compound(FieldAccess.forField(fieldDescription).read(), this.assigner.assign(fieldDescription.getType(), instrumentedMethod.getReturnType(), this.typing)));
    }

    protected StackManipulation setter(FieldDescription fieldDescription, ParameterDescription parameterDescription) {
        if (fieldDescription.isFinal() && parameterDescription.getDeclaringMethod().isMethod()) {
            throw new IllegalArgumentException("Cannot set final field " + fieldDescription + " from " + parameterDescription.getDeclaringMethod());
        }
        return this.access(fieldDescription, parameterDescription.getDeclaringMethod(), new StackManipulation.Compound(MethodVariableAccess.load(parameterDescription), this.assigner.assign(parameterDescription.getType(), fieldDescription.getType(), this.typing), FieldAccess.forField(fieldDescription).write()));
    }

    private StackManipulation access(FieldDescription fieldDescription, MethodDescription instrumentedMethod, StackManipulation fieldAccess) {
        if (!fieldAccess.isValid()) {
            throw new IllegalStateException("Incompatible type of " + fieldDescription + " and " + instrumentedMethod);
        }
        if (instrumentedMethod.isStatic() && !fieldDescription.isStatic()) {
            throw new IllegalArgumentException("Cannot call instance field " + fieldDescription + " from static method " + instrumentedMethod);
        }
        return new StackManipulation.Compound(fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), fieldAccess);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FieldAccessor that = (FieldAccessor)object;
        return this.fieldNameExtractor.equals(that.fieldNameExtractor) && this.fieldLocatorFactory.equals(that.fieldLocatorFactory) && this.assigner.equals(that.assigner) && this.typing == that.typing;
    }

    public int hashCode() {
        int result = this.fieldNameExtractor.hashCode();
        result = 31 * result + this.fieldLocatorFactory.hashCode();
        result = 31 * result + this.assigner.hashCode();
        result = 31 * result + this.typing.hashCode();
        return result;
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    protected static class ForParameterSetter
    extends FieldAccessor
    implements Implementation.Composable {
        private final int index;
        private final TerminationHandler terminationHandler;

        protected ForParameterSetter(FieldNameExtractor fieldNameExtractor, FieldLocator.Factory fieldLocatorFactory, Assigner assigner, Assigner.Typing typing, int index) {
            this(fieldNameExtractor, fieldLocatorFactory, assigner, typing, index, TerminationHandler.RETURNING);
        }

        private ForParameterSetter(FieldNameExtractor fieldNameExtractor, FieldLocator.Factory fieldLocatorFactory, Assigner assigner, Assigner.Typing typing, int index, TerminationHandler terminationHandler) {
            super(fieldNameExtractor, fieldLocatorFactory, assigner, typing);
            this.index = index;
            this.terminationHandler = terminationHandler;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(this.fieldLocatorFactory.make(implementationTarget.getInstrumentedType()));
        }

        @Override
        public Implementation andThen(Implementation implementation) {
            return new Implementation.Compound(new ForParameterSetter(this.fieldNameExtractor, this.fieldLocatorFactory, this.assigner, this.typing, this.index, TerminationHandler.NON_OPERATIONAL), implementation);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ForParameterSetter that = (ForParameterSetter)object;
            return this.index == that.index && this.terminationHandler == that.terminationHandler;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.index;
            result = 31 * result + this.terminationHandler.hashCode();
            return result;
        }

        public String toString() {
            return "FieldAccessor.ForParameterSetter{fieldNameExtractor=" + this.fieldNameExtractor + ", fieldLocatorFactory=" + this.fieldLocatorFactory + ", assigner=" + this.assigner + ", typing=" + (Object)((Object)this.typing) + ", index=" + this.index + ", terminationHandler=" + (Object)((Object)this.terminationHandler) + "}";
        }

        protected class Appender
        implements ByteCodeAppender {
            private final FieldLocator fieldLocator;

            protected Appender(FieldLocator fieldLocator) {
                this.fieldLocator = fieldLocator;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                FieldLocator.Resolution resolution = this.fieldLocator.locate(ForParameterSetter.this.fieldNameExtractor.resolve(instrumentedMethod));
                if (!resolution.isResolved()) {
                    throw new IllegalStateException("Cannot locate accessible field for " + instrumentedMethod + " with " + this.fieldLocator);
                }
                if (instrumentedMethod.getParameters().size() <= ForParameterSetter.this.index) {
                    throw new IllegalStateException(instrumentedMethod + " does not define a parameter with index " + ForParameterSetter.this.index);
                }
                return new ByteCodeAppender.Size(new StackManipulation.Compound(ForParameterSetter.this.setter(resolution.getField(), (ParameterDescription)instrumentedMethod.getParameters().get(ForParameterSetter.this.index)), ForParameterSetter.this.terminationHandler.resolve(instrumentedMethod)).apply(methodVisitor, implementationContext).getMaximalSize(), instrumentedMethod.getStackSize());
            }

            private ForParameterSetter getOuter() {
                return ForParameterSetter.this;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Appender appender = (Appender)object;
                return this.fieldLocator.equals(appender.fieldLocator) && ForParameterSetter.this.equals(appender.getOuter());
            }

            public int hashCode() {
                return this.fieldLocator.hashCode() + 31 * ForParameterSetter.this.hashCode();
            }

            public String toString() {
                return "FieldAccessor.ForParameterSetter.Appender{outer=" + ForParameterSetter.this + ", fieldLocator=" + this.fieldLocator + '}';
            }
        }

        protected static enum TerminationHandler {
            RETURNING{

                @Override
                protected StackManipulation resolve(MethodDescription instrumentedMethod) {
                    if (!instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        throw new IllegalStateException("Cannot implement setter with return value for " + instrumentedMethod);
                    }
                    return MethodReturn.VOID;
                }
            }
            ,
            NON_OPERATIONAL{

                @Override
                protected StackManipulation resolve(MethodDescription instrumentedMethod) {
                    return StackManipulation.Trivial.INSTANCE;
                }
            };


            protected abstract StackManipulation resolve(MethodDescription var1);

            public String toString() {
                return "FieldAccessor.ForParameterSetter.TerminationHandler." + this.name();
            }
        }
    }

    protected static class ForImplicitProperty
    extends FieldAccessor
    implements OwnerTypeLocatable {
        protected ForImplicitProperty(FieldNameExtractor fieldNameExtractor, FieldLocator.Factory fieldLocatorFactory) {
            this(fieldNameExtractor, fieldLocatorFactory, Assigner.DEFAULT, Assigner.Typing.STATIC);
        }

        private ForImplicitProperty(FieldNameExtractor fieldNameExtractor, FieldLocator.Factory fieldLocatorFactory, Assigner assigner, Assigner.Typing typing) {
            super(fieldNameExtractor, fieldLocatorFactory, assigner, typing);
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(this.fieldLocatorFactory.make(implementationTarget.getInstrumentedType()));
        }

        @Override
        public Implementation.Composable setsArgumentAt(int index) {
            if (index < 0) {
                throw new IllegalArgumentException("A parameter index cannot be negative: " + index);
            }
            return new ForParameterSetter(this.fieldNameExtractor, this.fieldLocatorFactory, this.assigner, this.typing, index);
        }

        @Override
        public PropertyConfigurable withAssigner(Assigner assigner, Assigner.Typing typing) {
            return new ForImplicitProperty(this.fieldNameExtractor, this.fieldLocatorFactory, assigner, typing);
        }

        @Override
        public AssignerConfigurable in(Class<?> type) {
            return this.in(new TypeDescription.ForLoadedType(type));
        }

        @Override
        public AssignerConfigurable in(TypeDescription typeDescription) {
            return this.in(new FieldLocator.ForExactType.Factory(typeDescription));
        }

        @Override
        public AssignerConfigurable in(FieldLocator.Factory fieldLocatorFactory) {
            return new ForImplicitProperty(this.fieldNameExtractor, fieldLocatorFactory, this.assigner, this.typing);
        }

        public String toString() {
            return "FieldAccessor.ForImplicitProperty{fieldNameExtractor=" + this.fieldNameExtractor + ", fieldLocatorFactory=" + this.fieldLocatorFactory + ", assigner=" + this.assigner + ", typing=" + (Object)((Object)this.typing) + "}";
        }

        protected class Appender
        implements ByteCodeAppender {
            private final FieldLocator fieldLocator;

            protected Appender(FieldLocator fieldLocator) {
                this.fieldLocator = fieldLocator;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                StackManipulation.Compound implementation;
                if (!instrumentedMethod.isMethod()) {
                    throw new IllegalArgumentException(instrumentedMethod + " does not describe a field getter or setter");
                }
                FieldLocator.Resolution resolution = this.fieldLocator.locate(ForImplicitProperty.this.fieldNameExtractor.resolve(instrumentedMethod));
                if (!resolution.isResolved()) {
                    throw new IllegalStateException("Cannot locate accessible field for " + instrumentedMethod);
                }
                if (!instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                    implementation = new StackManipulation.Compound(ForImplicitProperty.this.getter(resolution.getField(), instrumentedMethod), MethodReturn.of(instrumentedMethod.getReturnType()));
                } else if (instrumentedMethod.getReturnType().represents(Void.TYPE) && instrumentedMethod.getParameters().size() == 1) {
                    implementation = new StackManipulation.Compound(ForImplicitProperty.this.setter(resolution.getField(), (ParameterDescription)instrumentedMethod.getParameters().get(0)), MethodReturn.VOID);
                } else {
                    throw new IllegalArgumentException("Method " + implementationContext + " is no bean property");
                }
                return new ByteCodeAppender.Size(implementation.apply(methodVisitor, implementationContext).getMaximalSize(), instrumentedMethod.getStackSize());
            }

            private ForImplicitProperty getOuter() {
                return ForImplicitProperty.this;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Appender appender = (Appender)object;
                return this.fieldLocator.equals(appender.fieldLocator) && ForImplicitProperty.this.equals(appender.getOuter());
            }

            public int hashCode() {
                return this.fieldLocator.hashCode() + 31 * ForImplicitProperty.this.hashCode();
            }

            public String toString() {
                return "FieldAccessor.ForImplicitProperty.Appender{outer=" + ForImplicitProperty.this + ", fieldLocator=" + this.fieldLocator + '}';
            }
        }
    }

    public static interface OwnerTypeLocatable
    extends AssignerConfigurable {
        public AssignerConfigurable in(Class<?> var1);

        public AssignerConfigurable in(TypeDescription var1);

        public AssignerConfigurable in(FieldLocator.Factory var1);
    }

    public static interface AssignerConfigurable
    extends PropertyConfigurable {
        public PropertyConfigurable withAssigner(Assigner var1, Assigner.Typing var2);
    }

    public static interface PropertyConfigurable
    extends Implementation {
        public Implementation.Composable setsArgumentAt(int var1);
    }

    public static interface FieldNameExtractor {
        public String resolve(MethodDescription var1);

        public static class ForFixedValue
        implements FieldNameExtractor {
            private final String name;

            protected ForFixedValue(String name) {
                this.name = name;
            }

            @Override
            public String resolve(MethodDescription methodDescription) {
                return this.name;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForFixedValue that = (ForFixedValue)object;
                return this.name.equals(that.name);
            }

            public int hashCode() {
                return this.name.hashCode();
            }

            public String toString() {
                return "FieldAccessor.FieldNameExtractor.ForFixedValue{name='" + this.name + '\'' + '}';
            }
        }

        public static enum ForBeanProperty implements FieldNameExtractor
        {
            INSTANCE;


            @Override
            public String resolve(MethodDescription methodDescription) {
                int crop;
                String name = methodDescription.getInternalName();
                if (name.startsWith("get") || name.startsWith("set")) {
                    crop = 3;
                } else if (name.startsWith("is")) {
                    crop = 2;
                } else {
                    throw new IllegalArgumentException(methodDescription + " does not follow Java bean naming conventions");
                }
                name = name.substring(crop);
                if (name.length() == 0) {
                    throw new IllegalArgumentException(methodDescription + " does not specify a bean name");
                }
                return Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }

            public String toString() {
                return "FieldAccessor.FieldNameExtractor.ForBeanProperty." + this.name();
            }
        }
    }
}

