/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import java.lang.reflect.Type;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.FieldLocator;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.RandomString;

public class Forwarding
implements Implementation.Composable {
    private static final String FIELD_PREFIX = "forwarding";
    protected final PreparationHandler preparationHandler;
    protected final TerminationHandler terminationHandler;

    protected Forwarding(PreparationHandler preparationHandler, TerminationHandler terminationHandler) {
        this.preparationHandler = preparationHandler;
        this.terminationHandler = terminationHandler;
    }

    public static Implementation.Composable to(Object delegate) {
        return Forwarding.to(delegate, delegate.getClass());
    }

    public static Implementation.Composable to(Object delegate, String fieldName) {
        return Forwarding.to(delegate, fieldName, delegate.getClass());
    }

    public static Implementation.Composable to(Object delegate, Type type) {
        return Forwarding.to(delegate, String.format("%s$%s", FIELD_PREFIX, RandomString.hashOf(delegate.hashCode())), type);
    }

    public static Implementation.Composable to(Object delegate, String fieldName, Type type) {
        TypeDescription.Generic typeDescription = TypeDefinition.Sort.describe(type);
        if (!typeDescription.asErasure().isInstance(delegate)) {
            throw new IllegalArgumentException(delegate + " is not of type " + type);
        }
        return new Forwarding(new PreparationHandler.ForInstance(fieldName, typeDescription, delegate), TerminationHandler.RETURNING);
    }

    public static Implementation.Composable toField(String name) {
        return Forwarding.toField(name, FieldLocator.ForClassHierarchy.Factory.INSTANCE);
    }

    public static Implementation.Composable toField(String name, FieldLocator.Factory fieldLocatorFactory) {
        return new Forwarding(new PreparationHandler.ForField(name, fieldLocatorFactory), TerminationHandler.RETURNING);
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new Appender(implementationTarget.getInstrumentedType(), this.preparationHandler.resolve(implementationTarget.getInstrumentedType()), this.terminationHandler);
    }

    @Override
    public Implementation andThen(Implementation implementation) {
        return new Implementation.Compound(new Forwarding(this.preparationHandler, TerminationHandler.DROPPING), implementation);
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return this.preparationHandler.prepare(instrumentedType);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Forwarding that = (Forwarding)object;
        return this.preparationHandler.equals(that.preparationHandler) && this.terminationHandler == that.terminationHandler;
    }

    public int hashCode() {
        int result = this.preparationHandler.hashCode();
        result = 31 * result + this.terminationHandler.hashCode();
        return result;
    }

    public String toString() {
        return "Forwarding{preparationHandler=" + this.preparationHandler + ", terminationHandler=" + (Object)((Object)this.terminationHandler) + '}';
    }

    protected static class Appender
    implements ByteCodeAppender {
        private final TypeDescription instrumentedType;
        private final FieldDescription fieldDescription;
        private final TerminationHandler terminationHandler;

        protected Appender(TypeDescription instrumentedType, FieldDescription fieldDescription, TerminationHandler terminationHandler) {
            this.instrumentedType = instrumentedType;
            this.fieldDescription = fieldDescription;
            this.terminationHandler = terminationHandler;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            if (instrumentedMethod.isStatic()) {
                throw new IllegalStateException("Cannot forward the static method " + instrumentedMethod);
            }
            if (!instrumentedMethod.isInvokableOn(this.fieldDescription.getType().asErasure())) {
                throw new IllegalStateException("Cannot forward " + instrumentedMethod + " to " + this.fieldDescription.getType());
            }
            if (!instrumentedMethod.isAccessibleTo(this.instrumentedType)) {
                throw new IllegalStateException("Cannot forward to " + instrumentedMethod + " which is inaccessible for " + this.instrumentedType);
            }
            StackManipulation.Size stackSize = new StackManipulation.Compound(this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), FieldAccess.forField(this.fieldDescription).read(), MethodVariableAccess.allArgumentsOf(instrumentedMethod), MethodInvocation.invoke(instrumentedMethod).virtual(this.fieldDescription.getType().asErasure()), this.terminationHandler.resolve(instrumentedMethod.getReturnType())).apply(methodVisitor, implementationContext);
            return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Appender appender = (Appender)object;
            return this.fieldDescription.equals(appender.fieldDescription) && this.instrumentedType.equals(appender.instrumentedType) && this.terminationHandler == appender.terminationHandler;
        }

        public int hashCode() {
            int result = this.fieldDescription.hashCode();
            result = 31 * result + this.terminationHandler.hashCode();
            result = 31 * result + this.instrumentedType.hashCode();
            return result;
        }

        public String toString() {
            return "Forwarding.Appender{instrumentedType=" + this.instrumentedType + ", fieldDescription=" + this.fieldDescription + ", terminationHandler=" + (Object)((Object)this.terminationHandler) + '}';
        }
    }

    protected static enum TerminationHandler {
        DROPPING{

            @Override
            protected StackManipulation resolve(TypeDefinition returnType) {
                return Removal.of(returnType);
            }
        }
        ,
        RETURNING{

            @Override
            protected StackManipulation resolve(TypeDefinition returnType) {
                return MethodReturn.of(returnType);
            }
        };


        protected abstract StackManipulation resolve(TypeDefinition var1);

        public String toString() {
            return "Forwarding.TerminationHandler." + this.name();
        }
    }

    protected static interface PreparationHandler
    extends InstrumentedType.Prepareable {
        public FieldDescription resolve(TypeDescription var1);

        public static class ForField
        implements PreparationHandler {
            private final String fieldName;
            private final FieldLocator.Factory fieldLocatorFactory;

            protected ForField(String fieldName, FieldLocator.Factory fieldLocatorFactory) {
                this.fieldName = fieldName;
                this.fieldLocatorFactory = fieldLocatorFactory;
            }

            @Override
            public FieldDescription resolve(TypeDescription instrumentedType) {
                FieldLocator.Resolution resolution = this.fieldLocatorFactory.make(instrumentedType).locate(this.fieldName);
                if (!resolution.isResolved()) {
                    throw new IllegalStateException("Could not resolve a field for " + this.fieldName + " on " + instrumentedType);
                }
                return resolution.getField();
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForField forField = (ForField)object;
                return this.fieldName.equals(forField.fieldName) && this.fieldLocatorFactory.equals(forField.fieldLocatorFactory);
            }

            public int hashCode() {
                int result = this.fieldName.hashCode();
                result = 31 * result + this.fieldLocatorFactory.hashCode();
                return result;
            }

            public String toString() {
                return "Forwarding.PreparationHandler.ForField{fieldName='" + this.fieldName + '\'' + ", fieldLocatorFactory=" + this.fieldLocatorFactory + '}';
            }
        }

        public static class ForInstance
        implements PreparationHandler {
            private final String fieldName;
            private final TypeDescription.Generic typeDescription;
            private final Object delegate;

            protected ForInstance(String fieldName, TypeDescription.Generic typeDescription, Object delegate) {
                this.fieldName = fieldName;
                this.typeDescription = typeDescription;
                this.delegate = delegate;
            }

            @Override
            public FieldDescription resolve(TypeDescription instrumentedType) {
                return (FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName).and(ElementMatchers.genericFieldType(this.typeDescription)))).getOnly();
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withField(new FieldDescription.Token(this.fieldName, 4105, this.typeDescription)).withInitializer(new LoadedTypeInitializer.ForStaticField(this.fieldName, this.delegate));
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForInstance that = (ForInstance)object;
                return this.fieldName.equals(that.fieldName) && this.typeDescription.equals(that.typeDescription) && this.delegate.equals(that.delegate);
            }

            public int hashCode() {
                int result = this.fieldName.hashCode();
                result = 31 * result + this.typeDescription.hashCode();
                result = 31 * result + this.delegate.hashCode();
                return result;
            }

            public String toString() {
                return "Forwarding.PreparationHandler.ForInstance{fieldName='" + this.fieldName + '\'' + ", typeDescription=" + this.typeDescription + ", delegate=" + this.delegate + '}';
            }
        }
    }
}

