/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Map;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ByteArrayClassLoader;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.PackageDefinitionStrategy;

public interface ClassLoadingStrategy<T extends ClassLoader> {
    public static final ClassLoader BOOTSTRAP_LOADER = null;

    public Map<TypeDescription, Class<?>> load(T var1, Map<TypeDescription, byte[]> var2);

    public static class ForBootstrapInjection
    implements ClassLoadingStrategy<ClassLoader> {
        private final Instrumentation instrumentation;
        private final File folder;

        public ForBootstrapInjection(Instrumentation instrumentation, File folder) {
            this.instrumentation = instrumentation;
            this.folder = folder;
        }

        @Override
        public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            ClassInjector.UsingReflection classInjector = classLoader == null ? ClassInjector.UsingInstrumentation.of(this.folder, ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, this.instrumentation) : new ClassInjector.UsingReflection(classLoader);
            return classInjector.inject(types);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ForBootstrapInjection that = (ForBootstrapInjection)other;
            return this.folder.equals(that.folder) && this.instrumentation.equals(that.instrumentation);
        }

        public int hashCode() {
            int result = this.instrumentation.hashCode();
            result = 31 * result + this.folder.hashCode();
            return result;
        }

        public String toString() {
            return "ClassLoadingStrategy.ForBootstrapInjection{instrumentation=" + this.instrumentation + ", folder=" + this.folder + '}';
        }
    }

    public static interface Configurable<S extends ClassLoader>
    extends ClassLoadingStrategy<S> {
        public Configurable<S> with(ProtectionDomain var1);

        public Configurable<S> with(PackageDefinitionStrategy var1);

        public Configurable<S> allowExistingTypes();
    }

    public static enum Default implements Configurable<ClassLoader>
    {
        WRAPPER(new WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler.LATENT, false)),
        WRAPPER_PERSISTENT(new WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler.MANIFEST, false)),
        CHILD_FIRST(new WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler.LATENT, true)),
        CHILD_FIRST_PERSISTENT(new WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler.MANIFEST, true)),
        INJECTION(new InjectionDispatcher());

        private static final ProtectionDomain DEFAULT_PROTECTION_DOMAIN;
        private static final boolean DEFAULT_FORBID_EXISTING = true;
        private final Configurable<ClassLoader> dispatcher;

        private Default(Configurable<ClassLoader> dispatcher) {
            this.dispatcher = dispatcher;
        }

        @Override
        public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            return this.dispatcher.load(classLoader, types);
        }

        @Override
        public Configurable<ClassLoader> with(ProtectionDomain protectionDomain) {
            return this.dispatcher.with(protectionDomain);
        }

        @Override
        public Configurable<ClassLoader> with(PackageDefinitionStrategy packageDefinitionStrategy) {
            return this.dispatcher.with(packageDefinitionStrategy);
        }

        @Override
        public Configurable<ClassLoader> allowExistingTypes() {
            return this.dispatcher.allowExistingTypes();
        }

        public String toString() {
            return "ClassLoadingStrategy.Default." + this.name();
        }

        static {
            DEFAULT_PROTECTION_DOMAIN = null;
        }

        protected static class WrappingDispatcher
        implements Configurable<ClassLoader> {
            private static final boolean CHILD_FIRST = true;
            private static final boolean PARENT_FIRST = false;
            private final ProtectionDomain protectionDomain;
            private final ByteArrayClassLoader.PersistenceHandler persistenceHandler;
            private final PackageDefinitionStrategy packageDefinitionStrategy;
            private final boolean childFirst;
            private final boolean forbidExisting;

            protected WrappingDispatcher(ByteArrayClassLoader.PersistenceHandler persistenceHandler, boolean childFirst) {
                this(DEFAULT_PROTECTION_DOMAIN, PackageDefinitionStrategy.Trivial.INSTANCE, persistenceHandler, childFirst, true);
            }

            private WrappingDispatcher(ProtectionDomain protectionDomain, PackageDefinitionStrategy packageDefinitionStrategy, ByteArrayClassLoader.PersistenceHandler persistenceHandler, boolean childFirst, boolean forbidExisting) {
                this.protectionDomain = protectionDomain;
                this.packageDefinitionStrategy = packageDefinitionStrategy;
                this.persistenceHandler = persistenceHandler;
                this.childFirst = childFirst;
                this.forbidExisting = forbidExisting;
            }

            @Override
            public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
                return ByteArrayClassLoader.load(classLoader, types, this.protectionDomain, this.persistenceHandler, this.packageDefinitionStrategy, this.childFirst, this.forbidExisting);
            }

            @Override
            public Configurable<ClassLoader> with(ProtectionDomain protectionDomain) {
                return new WrappingDispatcher(protectionDomain, this.packageDefinitionStrategy, this.persistenceHandler, this.childFirst, this.forbidExisting);
            }

            @Override
            public Configurable<ClassLoader> with(PackageDefinitionStrategy packageDefinitionStrategy) {
                return new WrappingDispatcher(this.protectionDomain, packageDefinitionStrategy, this.persistenceHandler, this.childFirst, this.forbidExisting);
            }

            @Override
            public Configurable<ClassLoader> allowExistingTypes() {
                return new InjectionDispatcher(this.protectionDomain, this.packageDefinitionStrategy, false);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null) return false;
                if (this.getClass() != other.getClass()) {
                    return false;
                }
                WrappingDispatcher that = (WrappingDispatcher)other;
                if (this.childFirst != that.childFirst) return false;
                if (this.forbidExisting != that.forbidExisting) return false;
                if (this.protectionDomain != null) {
                    if (!this.protectionDomain.equals(that.protectionDomain)) {
                        return false;
                    }
                } else if (that.protectionDomain != null) return false;
                if (this.persistenceHandler != that.persistenceHandler) return false;
                if (!this.packageDefinitionStrategy.equals(that.packageDefinitionStrategy)) return false;
                return true;
            }

            public int hashCode() {
                int result = this.protectionDomain != null ? this.protectionDomain.hashCode() : 0;
                result = 31 * result + this.persistenceHandler.hashCode();
                result = 31 * result + this.packageDefinitionStrategy.hashCode();
                result = 31 * result + (this.childFirst ? 1 : 0);
                result = 31 * result + (this.forbidExisting ? 1 : 0);
                return result;
            }

            public String toString() {
                return "ClassLoadingStrategy.Default.WrappingDispatcher{packageDefinitionStrategy=" + this.packageDefinitionStrategy + ", protectionDomain=" + this.protectionDomain + ", childFirst=" + this.childFirst + ", persistenceHandler=" + (Object)((Object)this.persistenceHandler) + ", forbidExisting=" + this.forbidExisting + '}';
            }
        }

        protected static class InjectionDispatcher
        implements Configurable<ClassLoader> {
            private final ProtectionDomain protectionDomain;
            private final PackageDefinitionStrategy packageDefinitionStrategy;
            private final boolean forbidExisting;

            protected InjectionDispatcher() {
                this(DEFAULT_PROTECTION_DOMAIN, PackageDefinitionStrategy.NoOp.INSTANCE, true);
            }

            private InjectionDispatcher(ProtectionDomain protectionDomain, PackageDefinitionStrategy packageDefinitionStrategy, boolean forbidExisting) {
                this.protectionDomain = protectionDomain;
                this.packageDefinitionStrategy = packageDefinitionStrategy;
                this.forbidExisting = forbidExisting;
            }

            @Override
            public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
                return new ClassInjector.UsingReflection(classLoader, this.protectionDomain, this.packageDefinitionStrategy, this.forbidExisting).inject(types);
            }

            @Override
            public Configurable<ClassLoader> with(ProtectionDomain protectionDomain) {
                return new InjectionDispatcher(protectionDomain, this.packageDefinitionStrategy, this.forbidExisting);
            }

            @Override
            public Configurable<ClassLoader> with(PackageDefinitionStrategy packageDefinitionStrategy) {
                return new InjectionDispatcher(this.protectionDomain, packageDefinitionStrategy, this.forbidExisting);
            }

            @Override
            public Configurable<ClassLoader> allowExistingTypes() {
                return new InjectionDispatcher(this.protectionDomain, this.packageDefinitionStrategy, false);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null) return false;
                if (this.getClass() != other.getClass()) {
                    return false;
                }
                InjectionDispatcher that = (InjectionDispatcher)other;
                if (this.protectionDomain != null) {
                    if (!this.protectionDomain.equals(that.protectionDomain)) {
                        return false;
                    }
                } else if (that.protectionDomain != null) return false;
                if (this.forbidExisting != that.forbidExisting) return false;
                if (!this.packageDefinitionStrategy.equals(that.packageDefinitionStrategy)) return false;
                return true;
            }

            public int hashCode() {
                int result = this.protectionDomain != null ? this.protectionDomain.hashCode() : 0;
                result = 31 * result + this.packageDefinitionStrategy.hashCode();
                result = 31 * result + (this.forbidExisting ? 1 : 0);
                return result;
            }

            public String toString() {
                return "ClassLoadingStrategy.Default.InjectionDispatcher{protectionDomain=" + this.protectionDomain + ", packageDefinitionStrategy=" + this.packageDefinitionStrategy + ", forbidExisting=" + this.forbidExisting + '}';
            }
        }
    }
}

