/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.attribute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.implementation.attribute.AnnotationAppender;
import net.bytebuddy.implementation.attribute.AnnotationValueFilter;
import net.bytebuddy.jar.asm.ClassVisitor;

public interface TypeAttributeAppender {
    public void apply(ClassVisitor var1, TypeDescription var2, AnnotationValueFilter var3);

    public static class Compound
    implements TypeAttributeAppender {
        private final List<TypeAttributeAppender> typeAttributeAppenders = new ArrayList<TypeAttributeAppender>();

        public Compound(TypeAttributeAppender ... typeAttributeAppender) {
            this(Arrays.asList(typeAttributeAppender));
        }

        public Compound(List<? extends TypeAttributeAppender> typeAttributeAppenders) {
            for (TypeAttributeAppender typeAttributeAppender : typeAttributeAppenders) {
                if (typeAttributeAppender instanceof Compound) {
                    this.typeAttributeAppenders.addAll(((Compound)typeAttributeAppender).typeAttributeAppenders);
                    continue;
                }
                if (typeAttributeAppender instanceof NoOp) continue;
                this.typeAttributeAppenders.add(typeAttributeAppender);
            }
        }

        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, AnnotationValueFilter annotationValueFilter) {
            for (TypeAttributeAppender typeAttributeAppender : this.typeAttributeAppenders) {
                typeAttributeAppender.apply(classVisitor, instrumentedType, annotationValueFilter);
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.typeAttributeAppenders.equals(((Compound)other).typeAttributeAppenders);
        }

        public int hashCode() {
            return this.typeAttributeAppenders.hashCode();
        }

        public String toString() {
            return "TypeAttributeAppender.Compound{typeAttributeAppenders=" + this.typeAttributeAppenders + '}';
        }
    }

    public static class Explicit
    implements TypeAttributeAppender {
        private final List<? extends AnnotationDescription> annotations;

        public Explicit(List<? extends AnnotationDescription> annotations) {
            this.annotations = annotations;
        }

        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, AnnotationValueFilter annotationValueFilter) {
            AnnotationAppender appender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnType(classVisitor));
            for (AnnotationDescription annotationDescription : this.annotations) {
                appender = appender.append(annotationDescription, annotationValueFilter);
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.annotations.equals(((Explicit)other).annotations);
        }

        public int hashCode() {
            return this.annotations.hashCode();
        }

        public String toString() {
            return "TypeAttributeAppender.Explicit{annotations=" + this.annotations + '}';
        }
    }

    public static enum ForInstrumentedType implements TypeAttributeAppender
    {
        INSTANCE;


        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, AnnotationValueFilter annotationValueFilter) {
            AnnotationAppender annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnType(classVisitor));
            annotationAppender = AnnotationAppender.ForTypeAnnotations.ofTypeVariable(annotationAppender, annotationValueFilter, true, instrumentedType.getTypeVariables());
            TypeDescription.Generic superClass = instrumentedType.getSuperClass();
            if (superClass != null) {
                annotationAppender = superClass.accept(AnnotationAppender.ForTypeAnnotations.ofSuperClass(annotationAppender, annotationValueFilter));
            }
            int interfaceIndex = 0;
            for (TypeDescription.Generic interfaceType : instrumentedType.getInterfaces()) {
                annotationAppender = interfaceType.accept(AnnotationAppender.ForTypeAnnotations.ofInterfaceType(annotationAppender, annotationValueFilter, interfaceIndex++));
            }
            for (AnnotationDescription annotation : instrumentedType.getDeclaredAnnotations()) {
                annotationAppender = annotationAppender.append(annotation, annotationValueFilter);
            }
        }

        public String toString() {
            return "TypeAttributeAppender.ForInstrumentedType." + this.name();
        }

        public static class Differentiating
        implements TypeAttributeAppender {
            private final int annotationIndex;
            private final int typeVariableIndex;
            private final int interfaceTypeIndex;

            public Differentiating(TypeDescription typeDescription) {
                this(typeDescription.getDeclaredAnnotations().size(), typeDescription.getTypeVariables().size(), typeDescription.getInterfaces().size());
            }

            protected Differentiating(int annotationIndex, int typeVariableIndex, int interfaceTypeIndex) {
                this.annotationIndex = annotationIndex;
                this.typeVariableIndex = typeVariableIndex;
                this.interfaceTypeIndex = interfaceTypeIndex;
            }

            @Override
            public void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, AnnotationValueFilter annotationValueFilter) {
                AnnotationAppender annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnType(classVisitor));
                AnnotationAppender.ForTypeAnnotations.ofTypeVariable(annotationAppender, annotationValueFilter, true, this.typeVariableIndex, instrumentedType.getTypeVariables());
                TypeList.Generic interfaceTypes = instrumentedType.getInterfaces();
                int interfaceTypeIndex = this.interfaceTypeIndex;
                for (TypeDescription.Generic interfaceType : (TypeList.Generic)interfaceTypes.subList(this.interfaceTypeIndex, interfaceTypes.size())) {
                    annotationAppender = interfaceType.accept(AnnotationAppender.ForTypeAnnotations.ofInterfaceType(annotationAppender, annotationValueFilter, interfaceTypeIndex++));
                }
                AnnotationList declaredAnnotations = instrumentedType.getDeclaredAnnotations();
                for (AnnotationDescription annotationDescription : (AnnotationList)declaredAnnotations.subList(this.annotationIndex, declaredAnnotations.size())) {
                    annotationAppender = annotationAppender.append(annotationDescription, annotationValueFilter);
                }
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Differentiating differentiating = (Differentiating)other;
                return this.annotationIndex == differentiating.annotationIndex && this.typeVariableIndex == differentiating.typeVariableIndex && this.interfaceTypeIndex == differentiating.interfaceTypeIndex;
            }

            public int hashCode() {
                int result = this.annotationIndex;
                result = 31 * result + this.typeVariableIndex;
                result = 31 * result + this.interfaceTypeIndex;
                return result;
            }

            public String toString() {
                return "TypeAttributeAppender.ForInstrumentedType.Differentiating{annotationIndex=" + this.annotationIndex + ", typeVariableIndex=" + this.typeVariableIndex + ", interfaceTypeIndex=" + this.interfaceTypeIndex + '}';
            }
        }
    }

    public static enum NoOp implements TypeAttributeAppender
    {
        INSTANCE;


        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription instrumentedType, AnnotationValueFilter annotationValueFilter) {
        }

        public String toString() {
            return "TypeAttributeAppender.NoOp." + this.name();
        }
    }
}

