/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bind.annotation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.FieldLocator;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bind.MethodDelegationBinder;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.Default;
import net.bytebuddy.implementation.bind.annotation.DefaultCall;
import net.bytebuddy.implementation.bind.annotation.DefaultMethod;
import net.bytebuddy.implementation.bind.annotation.Empty;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.implementation.bind.annotation.IgnoreForBinding;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.StubValue;
import net.bytebuddy.implementation.bind.annotation.Super;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.SuperMethod;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.DefaultValue;
import net.bytebuddy.implementation.bytecode.constant.DoubleConstant;
import net.bytebuddy.implementation.bytecode.constant.FloatConstant;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.JavaConstantValue;
import net.bytebuddy.implementation.bytecode.constant.LongConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaConstant;
import net.bytebuddy.utility.JavaType;

public class TargetMethodAnnotationDrivenBinder
implements MethodDelegationBinder {
    private final DelegationProcessor delegationProcessor;

    protected TargetMethodAnnotationDrivenBinder(DelegationProcessor delegationProcessor) {
        this.delegationProcessor = delegationProcessor;
    }

    public static MethodDelegationBinder of(List<? extends ParameterBinder<?>> parameterBinders) {
        return new TargetMethodAnnotationDrivenBinder(DelegationProcessor.of(parameterBinders));
    }

    @Override
    public MethodDelegationBinder.Record compile(MethodDescription candidate) {
        if (IgnoreForBinding.Verifier.check(candidate)) {
            return MethodDelegationBinder.Record.Illegal.INSTANCE;
        }
        ArrayList<DelegationProcessor.Handler> handlers = new ArrayList<DelegationProcessor.Handler>(candidate.getParameters().size());
        for (ParameterDescription parameterDescription : candidate.getParameters()) {
            handlers.add(this.delegationProcessor.prepare(parameterDescription));
        }
        return new Record(candidate, handlers, RuntimeType.Verifier.check(candidate));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TargetMethodAnnotationDrivenBinder that = (TargetMethodAnnotationDrivenBinder)other;
        return this.delegationProcessor.equals(that.delegationProcessor);
    }

    public int hashCode() {
        return this.delegationProcessor.hashCode();
    }

    public String toString() {
        return "TargetMethodAnnotationDrivenBinder{delegationProcessor=" + this.delegationProcessor + '}';
    }

    protected static class DelegationProcessor {
        private final Map<? extends TypeDescription, ? extends ParameterBinder<?>> parameterBinders;

        protected DelegationProcessor(Map<? extends TypeDescription, ? extends ParameterBinder<?>> parameterBinders) {
            this.parameterBinders = parameterBinders;
        }

        protected static DelegationProcessor of(List<? extends ParameterBinder<?>> parameterBinders) {
            HashMap parameterBinderMap = new HashMap();
            for (ParameterBinder<?> parameterBinder : parameterBinders) {
                if (parameterBinderMap.put(new TypeDescription.ForLoadedType(parameterBinder.getHandledType()), parameterBinder) == null) continue;
                throw new IllegalArgumentException("Attempt to bind two handlers to " + parameterBinder.getHandledType());
            }
            return new DelegationProcessor(parameterBinderMap);
        }

        protected Handler prepare(ParameterDescription target) {
            Assigner.Typing typing = RuntimeType.Verifier.check(target);
            Handler handler = new Handler.Unbound(target, typing);
            for (AnnotationDescription annotation : target.getDeclaredAnnotations()) {
                ParameterBinder<?> parameterBinder = this.parameterBinders.get(annotation.getAnnotationType());
                if (parameterBinder != null && handler.isBound()) {
                    throw new IllegalStateException("Ambiguous binding for parameter annotated with two handled annotation types");
                }
                if (parameterBinder == null) continue;
                handler = Handler.Bound.of(target, parameterBinder, annotation, typing);
            }
            return handler;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.parameterBinders.equals(((DelegationProcessor)other).parameterBinders);
        }

        public int hashCode() {
            return this.parameterBinders.hashCode();
        }

        public String toString() {
            return "TargetMethodAnnotationDrivenBinder.DelegationProcessor{parameterBinders=" + this.parameterBinders + '}';
        }

        protected static interface Handler {
            public boolean isBound();

            public MethodDelegationBinder.ParameterBinding<?> bind(MethodDescription var1, Implementation.Target var2, Assigner var3);

            public static class Bound<T extends Annotation>
            implements Handler {
                private final ParameterDescription target;
                private final ParameterBinder<T> parameterBinder;
                private final AnnotationDescription.Loadable<T> annotation;
                private final Assigner.Typing typing;

                protected Bound(ParameterDescription target, ParameterBinder<T> parameterBinder, AnnotationDescription.Loadable<T> annotation, Assigner.Typing typing) {
                    this.target = target;
                    this.parameterBinder = parameterBinder;
                    this.annotation = annotation;
                    this.typing = typing;
                }

                protected static Handler of(ParameterDescription target, ParameterBinder<?> parameterBinder, AnnotationDescription annotation, Assigner.Typing typing) {
                    return new Bound(target, parameterBinder, annotation.prepare(parameterBinder.getHandledType()), typing);
                }

                @Override
                public boolean isBound() {
                    return true;
                }

                @Override
                public MethodDelegationBinder.ParameterBinding<?> bind(MethodDescription source, Implementation.Target implementationTarget, Assigner assigner) {
                    return this.parameterBinder.bind(this.annotation, source, this.target, implementationTarget, assigner, this.typing);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.parameterBinder.equals(((Bound)other).parameterBinder) && this.annotation.equals(((Bound)other).annotation) && this.target.equals(((Bound)other).target) && this.typing.equals((Object)((Bound)other).typing);
                }

                public int hashCode() {
                    int result = this.parameterBinder.hashCode();
                    result = 31 * result + this.target.hashCode();
                    result = 31 * result + this.annotation.hashCode();
                    result = 31 * result + this.typing.hashCode();
                    return result;
                }

                public String toString() {
                    return "TargetMethodAnnotationDrivenBinder.DelegationProcessor.Handler.Bound{parameterBinder=" + this.parameterBinder + ", annotation=" + this.annotation + ", target=" + this.target + ", typing=" + (Object)((Object)this.typing) + '}';
                }
            }

            public static class Unbound
            implements Handler {
                private final ParameterDescription target;
                private final Assigner.Typing typing;

                protected Unbound(ParameterDescription target, Assigner.Typing typing) {
                    this.target = target;
                    this.typing = typing;
                }

                @Override
                public boolean isBound() {
                    return false;
                }

                @Override
                public MethodDelegationBinder.ParameterBinding<?> bind(MethodDescription source, Implementation.Target implementationTarget, Assigner assigner) {
                    return Argument.Binder.INSTANCE.bind(AnnotationDescription.ForLoadedAnnotation.of(new DefaultArgument(this.target.getIndex())), source, this.target, implementationTarget, assigner, this.typing);
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    Unbound unbound = (Unbound)object;
                    return this.target.equals(unbound.target) && this.typing.equals((Object)unbound.typing);
                }

                public int hashCode() {
                    return this.target.hashCode() + 31 * this.typing.hashCode();
                }

                public String toString() {
                    return "TargetMethodAnnotationDrivenBinder.DelegationProcessor.Handler.Unbound{target=" + this.target + ", typing=" + (Object)((Object)this.typing) + '}';
                }

                protected static class DefaultArgument
                implements Argument {
                    private static final String VALUE = "value";
                    private static final String BINDING_MECHANIC = "bindingMechanic";
                    private final int parameterIndex;

                    protected DefaultArgument(int parameterIndex) {
                        this.parameterIndex = parameterIndex;
                    }

                    @Override
                    public int value() {
                        return this.parameterIndex;
                    }

                    @Override
                    public Argument.BindingMechanic bindingMechanic() {
                        return Argument.BindingMechanic.UNIQUE;
                    }

                    public Class<Argument> annotationType() {
                        return Argument.class;
                    }

                    @Override
                    public boolean equals(Object other) {
                        return this == other || other instanceof Argument && this.parameterIndex == ((Argument)other).value();
                    }

                    @Override
                    public int hashCode() {
                        return (127 * BINDING_MECHANIC.hashCode() ^ Argument.BindingMechanic.UNIQUE.hashCode()) + (127 * VALUE.hashCode() ^ this.parameterIndex);
                    }

                    @Override
                    public String toString() {
                        return "@" + Argument.class.getName() + "(bindingMechanic=" + Argument.BindingMechanic.UNIQUE.toString() + ", value=" + this.parameterIndex + ")";
                    }
                }
            }
        }
    }

    @SuppressFBWarnings(value={"IC_SUPERCLASS_USES_SUBCLASS_DURING_INITIALIZATION"}, justification="Safe initialization is implied")
    public static interface ParameterBinder<T extends Annotation> {
        public static final List<ParameterBinder<?>> DEFAULTS = Collections.unmodifiableList(Arrays.asList(Argument.Binder.INSTANCE, AllArguments.Binder.INSTANCE, Origin.Binder.INSTANCE, This.Binder.INSTANCE, Super.Binder.INSTANCE, Default.Binder.INSTANCE, SuperCall.Binder.INSTANCE, DefaultCall.Binder.INSTANCE, SuperMethod.Binder.INSTANCE, DefaultMethod.Binder.INSTANCE, FieldValue.Binder.INSTANCE, StubValue.Binder.INSTANCE, Empty.Binder.INSTANCE));

        public Class<T> getHandledType();

        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<T> var1, MethodDescription var2, ParameterDescription var3, Implementation.Target var4, Assigner var5, Assigner.Typing var6);

        public static abstract class ForFieldBinding<S extends Annotation>
        implements ParameterBinder<S> {
            protected static final String BEAN_PROPERTY = "";

            private static FieldLocator.Resolution resolveAccessor(FieldLocator fieldLocator, MethodDescription methodDescription) {
                String fieldName;
                if (ElementMatchers.isSetter().matches(methodDescription)) {
                    fieldName = methodDescription.getInternalName().substring(3);
                } else if (ElementMatchers.isGetter().matches(methodDescription)) {
                    fieldName = methodDescription.getInternalName().substring(methodDescription.getInternalName().startsWith("is") ? 2 : 3);
                } else {
                    return FieldLocator.Resolution.Illegal.INSTANCE;
                }
                return fieldLocator.locate(Character.toLowerCase(fieldName.charAt(0)) + fieldName.substring(1));
            }

            @Override
            public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<S> annotation, MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner, Assigner.Typing typing) {
                if (!this.declaringType(annotation).represents(Void.TYPE)) {
                    if (this.declaringType(annotation).isPrimitive() || this.declaringType(annotation).isArray()) {
                        throw new IllegalStateException("A primitive type or array type cannot declare a field: " + source);
                    }
                    if (!implementationTarget.getInstrumentedType().isAssignableTo(this.declaringType(annotation))) {
                        return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
                    }
                }
                FieldLocator.AbstractBase fieldLocator = this.declaringType(annotation).represents(Void.TYPE) ? new FieldLocator.ForClassHierarchy(implementationTarget.getInstrumentedType()) : new FieldLocator.ForExactType(this.declaringType(annotation), implementationTarget.getInstrumentedType());
                FieldLocator.Resolution resolution = this.fieldName(annotation).equals(BEAN_PROPERTY) ? ForFieldBinding.resolveAccessor(fieldLocator, source) : fieldLocator.locate(this.fieldName(annotation));
                return resolution.isResolved() && (!source.isStatic() || resolution.getField().isStatic()) ? this.bind(resolution.getField(), annotation, source, target, implementationTarget, assigner) : MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }

            protected abstract String fieldName(AnnotationDescription.Loadable<S> var1);

            protected abstract TypeDescription declaringType(AnnotationDescription.Loadable<S> var1);

            protected abstract MethodDelegationBinder.ParameterBinding<?> bind(FieldDescription var1, AnnotationDescription.Loadable<S> var2, MethodDescription var3, ParameterDescription var4, Implementation.Target var5, Assigner var6);
        }

        public static abstract class ForFixedValue<S extends Annotation>
        implements ParameterBinder<S> {
            @Override
            public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<S> annotation, MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner, Assigner.Typing typing) {
                TypeDescription suppliedType;
                StackManipulation stackManipulation;
                Object value = this.bind(annotation, source, target);
                if (value == null) {
                    return new MethodDelegationBinder.ParameterBinding.Anonymous(DefaultValue.of(target.getType()));
                }
                if (value instanceof Boolean) {
                    stackManipulation = IntegerConstant.forValue((Boolean)value);
                    suppliedType = new TypeDescription.ForLoadedType(Boolean.TYPE);
                } else if (value instanceof Byte) {
                    stackManipulation = IntegerConstant.forValue(((Byte)value).byteValue());
                    suppliedType = new TypeDescription.ForLoadedType(Byte.TYPE);
                } else if (value instanceof Short) {
                    stackManipulation = IntegerConstant.forValue(((Short)value).shortValue());
                    suppliedType = new TypeDescription.ForLoadedType(Short.TYPE);
                } else if (value instanceof Character) {
                    stackManipulation = IntegerConstant.forValue(((Character)value).charValue());
                    suppliedType = new TypeDescription.ForLoadedType(Character.TYPE);
                } else if (value instanceof Integer) {
                    stackManipulation = IntegerConstant.forValue((Integer)value);
                    suppliedType = new TypeDescription.ForLoadedType(Integer.TYPE);
                } else if (value instanceof Long) {
                    stackManipulation = LongConstant.forValue((Long)value);
                    suppliedType = new TypeDescription.ForLoadedType(Long.TYPE);
                } else if (value instanceof Float) {
                    stackManipulation = FloatConstant.forValue(((Float)value).floatValue());
                    suppliedType = new TypeDescription.ForLoadedType(Float.TYPE);
                } else if (value instanceof Double) {
                    stackManipulation = DoubleConstant.forValue((Double)value);
                    suppliedType = new TypeDescription.ForLoadedType(Double.TYPE);
                } else if (value instanceof String) {
                    stackManipulation = new TextConstant((String)value);
                    suppliedType = TypeDescription.STRING;
                } else if (value instanceof Class) {
                    stackManipulation = ClassConstant.of(new TypeDescription.ForLoadedType((Class)value));
                    suppliedType = TypeDescription.CLASS;
                } else if (value instanceof TypeDescription) {
                    stackManipulation = ClassConstant.of((TypeDescription)value);
                    suppliedType = TypeDescription.CLASS;
                } else if (JavaType.METHOD_HANDLE.getTypeStub().isInstance(value)) {
                    stackManipulation = JavaConstant.MethodHandle.ofLoaded(value).asStackManipulation();
                    suppliedType = JavaType.METHOD_HANDLE.getTypeStub();
                } else if (value instanceof JavaConstant.MethodHandle) {
                    stackManipulation = new JavaConstantValue((JavaConstant.MethodHandle)value);
                    suppliedType = JavaType.METHOD_HANDLE.getTypeStub();
                } else if (JavaType.METHOD_TYPE.getTypeStub().isInstance(value)) {
                    stackManipulation = new JavaConstantValue(JavaConstant.MethodType.ofLoaded(value));
                    suppliedType = JavaType.METHOD_HANDLE.getTypeStub();
                } else if (value instanceof JavaConstant.MethodType) {
                    stackManipulation = new JavaConstantValue((JavaConstant.MethodType)value);
                    suppliedType = JavaType.METHOD_HANDLE.getTypeStub();
                } else {
                    throw new IllegalStateException("Not able to save in class's constant pool: " + value);
                }
                return new MethodDelegationBinder.ParameterBinding.Anonymous(new StackManipulation.Compound(stackManipulation, assigner.assign(suppliedType.asGenericType(), target.getType(), typing)));
            }

            protected abstract Object bind(AnnotationDescription.Loadable<S> var1, MethodDescription var2, ParameterDescription var3);

            public static class OfConstant<U extends Annotation>
            extends ForFixedValue<U> {
                private final Class<U> type;
                private final Object value;

                protected OfConstant(Class<U> type, Object value) {
                    this.type = type;
                    this.value = value;
                }

                public static <V extends Annotation> ParameterBinder<V> of(Class<V> type, Object value) {
                    return new OfConstant<V>(type, value);
                }

                @Override
                public Class<U> getHandledType() {
                    return this.type;
                }

                @Override
                protected Object bind(AnnotationDescription.Loadable<U> annotation, MethodDescription source, ParameterDescription target) {
                    return this.value;
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    OfConstant that = (OfConstant)object;
                    return this.type.equals(that.type) && (this.value != null ? this.value.equals(that.value) : that.value == null);
                }

                public int hashCode() {
                    int result = this.type.hashCode();
                    result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                    return result;
                }

                public String toString() {
                    return "TargetMethodAnnotationDrivenBinder.ParameterBinder.ForFixedValue.OfConstant{type=" + this.type + ", value=" + this.value + '}';
                }
            }
        }
    }

    protected static class Record
    implements MethodDelegationBinder.Record {
        private final MethodDescription candidate;
        private final List<DelegationProcessor.Handler> handlers;
        private final Assigner.Typing typing;

        protected Record(MethodDescription candidate, List<DelegationProcessor.Handler> handlers, Assigner.Typing typing) {
            this.candidate = candidate;
            this.handlers = handlers;
            this.typing = typing;
        }

        @Override
        public MethodDelegationBinder.MethodBinding bind(Implementation.Target implementationTarget, MethodDescription source, MethodDelegationBinder.TerminationHandler terminationHandler, MethodDelegationBinder.MethodInvoker methodInvoker, Assigner assigner) {
            if (!this.candidate.isAccessibleTo(implementationTarget.getInstrumentedType())) {
                return MethodDelegationBinder.MethodBinding.Illegal.INSTANCE;
            }
            StackManipulation methodTermination = terminationHandler.resolve(assigner, this.typing, source, this.candidate);
            if (!methodTermination.isValid()) {
                return MethodDelegationBinder.MethodBinding.Illegal.INSTANCE;
            }
            MethodDelegationBinder.MethodBinding.Builder methodDelegationBindingBuilder = new MethodDelegationBinder.MethodBinding.Builder(methodInvoker, this.candidate);
            for (DelegationProcessor.Handler handler : this.handlers) {
                MethodDelegationBinder.ParameterBinding<?> parameterBinding = handler.bind(source, implementationTarget, assigner);
                if (parameterBinding.isValid() && methodDelegationBindingBuilder.append(parameterBinding)) continue;
                return MethodDelegationBinder.MethodBinding.Illegal.INSTANCE;
            }
            return methodDelegationBindingBuilder.build(methodTermination);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Record record = (Record)object;
            return this.candidate.equals(record.candidate) && this.handlers.equals(record.handlers) && this.typing.equals((Object)record.typing);
        }

        public int hashCode() {
            int result = this.candidate.hashCode();
            result = 31 * result + this.handlers.hashCode();
            result = 31 * result + this.typing.hashCode();
            return result;
        }

        public String toString() {
            return "TargetMethodAnnotationDrivenBinder.Record{, candidate=" + this.candidate + ", handlers=" + this.handlers + ", typing=" + (Object)((Object)this.typing) + '}';
        }
    }
}

