/*
 * Decompiled with CFR 0.152.
 */
package net.cassite.captcha;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class CaptchaGen {
    public static final String ALL_ENGLISH_CHARS_AND_NUMBERS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final CaptchaGen DEFAULT = new CaptchaGen("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", 150, 50, 30, 4, 0.2, 8, 30, 50, 10, 2);
    private final String str;
    private final int x;
    private final int y;
    private final int size;
    private final int n;
    private final double p;
    private final int v;
    private final int d;
    private final int m;
    private final int l;
    private final int nSize;

    public CaptchaGen(String str, int x, int y, int size, int n, double p, int v, int d, int m, int l, int nSize) {
        this.str = str;
        this.x = x;
        this.y = y;
        this.size = size;
        this.n = n;
        this.p = p;
        this.v = v;
        this.d = d;
        this.m = m;
        this.l = l;
        this.nSize = nSize;
    }

    public BufferedImage generate(StringBuilder sb) {
        int i;
        int inc;
        BufferedImage img = new BufferedImage(this.x, this.y, 1);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setColor(Color.white);
        g.fillRect(1, 1, this.x - 2, this.y - 2);
        g.setFont(new Font("Arial", 1, this.size));
        int currentX = inc = this.x / (this.n + 2);
        int Y = (this.y + this.size / 2) / 2;
        for (i = 0; i < this.n; ++i) {
            g.setColor(this.randColor());
            String s = this.randStr();
            sb.append(s);
            int wX = currentX + (int)((double)(inc / 2) * (Math.random() * this.p * 2.0 - this.p));
            int wY = Y + (int)(Math.random() * (double)this.v * 2.0 - (double)this.v);
            g.translate(wX, wY);
            double rotate = (Math.random() * 2.0 - 1.0) * (double)this.d * Math.PI / 180.0;
            g.rotate(rotate);
            g.drawString(s, 0, 0);
            currentX += inc;
            g.rotate(-rotate);
            g.translate(-wX, -wY);
        }
        g.setFont(new Font("Arial", 1, this.nSize));
        for (i = 0; i < this.m; ++i) {
            g.setColor(this.randColor());
            int nX = (int)(Math.random() * (double)this.x);
            int nY = (int)(Math.random() * (double)this.y);
            g.drawLine(nX, nY, nX + (int)(Math.random() * (double)this.l * 2.0 - (double)this.l), nY + (int)(Math.random() * (double)this.l * 2.0 - (double)this.l));
        }
        g.setColor(Color.black);
        g.drawRect(0, 0, this.x, this.y);
        return img;
    }

    private String randStr() {
        int index = (int)(Math.random() * (double)this.str.length());
        return Character.toString(this.str.charAt(index));
    }

    private int rand255() {
        return (int)(Math.random() * 255.0);
    }

    private Color randColor() {
        return new Color(this.rand255(), this.rand255(), this.rand255());
    }
}

