/*
 * Decompiled with CFR 0.152.
 */
package net.christophermerrill.testfx;

import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Labeled;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import net.christophermerrill.testfx.OperatingSystem;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Assertions;
import org.testfx.api.FxRobotInterface;
import org.testfx.framework.junit5.ApplicationTest;
import org.testfx.service.query.EmptyNodeQueryException;
import org.testfx.service.query.PointQuery;
import org.testfx.service.query.impl.PointQueryBase;
import org.testfx.util.WaitForAsyncUtils;

public abstract class ComponentTest
extends ApplicationTest {
    private static final String TOOLTIP_PROP_ID = "javafx.scene.control.Tooltip";

    public void waitForUiEvents() {
        WaitForAsyncUtils.waitForFxEvents();
    }

    public void start(Stage stage) throws Exception {
        GridPane root;
        Node component = this.createComponentNode();
        if (this.fillToWidthAndHeight()) {
            BorderPane bordered = new BorderPane();
            bordered.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.ORANGE, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(5.0))}));
            bordered.setCenter(component);
            root = bordered;
        } else {
            GridPane grid = new GridPane();
            grid.add(component, 0, 0);
            root = grid;
        }
        Scene scene = new Scene((Parent)root);
        stage.setScene(scene);
        stage.setWidth(this.getDefaultWidth());
        stage.setHeight(this.getDefaultHeight());
        stage.show();
    }

    public void stop() throws Exception {
        super.stop();
    }

    public void init() throws Exception {
        super.init();
    }

    public double getDefaultWidth() {
        return 600.0;
    }

    public double getDefaultHeight() {
        return 200.0;
    }

    public boolean fillToWidthAndHeight() {
        return true;
    }

    public abstract Node createComponentNode() throws Exception;

    public void fillFieldAndTabAway(String locator, String text) {
        FxRobotInterface robot = this.clickOn(locator, new MouseButton[0]);
        this.clearText(locator);
        robot.write(text).push(new KeyCode[]{KeyCode.TAB});
    }

    public void fillFieldAndPressEnter(String locator, String text) {
        FxRobotInterface robot = this.clickOn(locator, new MouseButton[0]);
        this.clearText(locator);
        robot.write(text).push(new KeyCode[]{KeyCode.ENTER});
    }

    public void fillField(String locator, String text) {
        FxRobotInterface robot = this.clickOn(locator, new MouseButton[0]);
        this.clearText(locator);
        robot.write(text);
    }

    public void fillFieldAndTabAway(Node node, String text) {
        FxRobotInterface robot = this.clickOn(node, new MouseButton[0]);
        ((TextInputControl)node).setText("");
        robot.write(text).push(new KeyCode[]{KeyCode.TAB});
    }

    public void fillComboAndTabAway(String locator, String text) {
        ComboBox combo = this.lookup(locator).queryComboBox();
        this.clickOn((Node)combo, new MouseButton[0]).push(new KeyCode[]{KeyCode.CONTROL, KeyCode.A}).push(new KeyCode[]{KeyCode.DELETE}).write(text).push(new KeyCode[]{KeyCode.TAB});
    }

    public void clearText(String locator) {
        this.lookup(locator).queryTextInputControl().setText("");
    }

    public void clearFieldAndTabAway(String locator) {
        FxRobotInterface robot = this.clickOn(locator, new MouseButton[0]);
        this.clearText(locator);
        robot.push(new KeyCode[]{KeyCode.TAB});
    }

    public void tabAway() {
        this.push(new KeyCode[]{KeyCode.TAB});
    }

    public void pressUndoKey(String locator) {
        if (OperatingSystem.macOS.equals((Object)OperatingSystem.get())) {
            this.clickOn(locator, new MouseButton[0]).push(new KeyCode[]{KeyCode.COMMAND, KeyCode.Z});
        } else {
            this.clickOn(locator, new MouseButton[0]).push(new KeyCode[]{KeyCode.CONTROL, KeyCode.Z});
        }
    }

    public void pressEscape(String locator) {
        this.clickOn(locator, new MouseButton[0]).push(new KeyCode[]{KeyCode.ESCAPE});
    }

    public String quoted(Object value) {
        return "\"" + value.toString() + "\"";
    }

    public String getTooltipText(Node node) {
        return ((Tooltip)node.getProperties().get((Object)TOOLTIP_PROP_ID)).getText();
    }

    public String textOf(Node node) {
        if (node instanceof TextInputControl) {
            return ((TextInputControl)node).getText();
        }
        if (node instanceof Labeled) {
            return ((Labeled)node).getText();
        }
        if (node instanceof ComboBox) {
            return ((ComboBox)node).getSelectionModel().getSelectedItem().toString();
        }
        Assertions.fail((String)"Expected a Label, TextInputControl or ComboBox");
        return null;
    }

    public String textOf(String query) {
        Node node = this.lookup(query).query();
        Assertions.assertNotNull((Object)node, (String)("node not found: " + query));
        return this.textOf(node);
    }

    public boolean isChecked(String query) {
        Node node = this.lookup(query).query();
        Assertions.assertNotNull((Object)node, (String)("node not found: " + query));
        return this.isChecked(node);
    }

    public boolean isChecked(Node node) {
        if (node instanceof CheckBox) {
            return ((CheckBox)node).isSelected();
        }
        Assertions.fail((String)"Expected a CheckBox");
        return false;
    }

    public boolean isDisabled(String query) {
        Node node = this.lookup(query).query();
        Assertions.assertNotNull((Object)node, (String)("node not found: " + query));
        return this.isDisabled(node);
    }

    public boolean isDisabled(Node node) {
        return node.isDisable();
    }

    public boolean exists(String query) {
        try {
            this.lookup(query).query();
            return true;
        }
        catch (EmptyNodeQueryException e) {
            return false;
        }
    }

    public int numberOf(String query) {
        return this.lookup(query).queryAll().size();
    }

    public String id(String id_value) {
        return "#" + id_value;
    }

    public String withStyle(String style_name) {
        return "." + style_name;
    }

    public TableCell tableCell(String table_query, int row, int column) {
        return (TableCell)this.lookup(table_query).lookup(".table-row-cell").nth(row).lookup(".table-cell").nth(column).query();
    }

    public <T extends Node> T nodeOfClass(final Class<T> node_class, Node root) {
        return (T)this.from(new Node[]{root}).lookup((Matcher)new BaseMatcher<T>(){

            public boolean matches(Object item) {
                return node_class.isAssignableFrom(item.getClass());
            }

            public void describeTo(Description description) {
            }
        }).query();
    }

    public String byClass(String class_name) {
        return "." + class_name;
    }

    public PointQuery inside(final Node query_node, final long x, final long y) {
        return new PointQueryBase(){

            public Point2D query() {
                Bounds bounds = ComponentTest.this.bounds(query_node).query();
                return new Point2D(bounds.getMinX() + (double)x, bounds.getMinY() + (double)y);
            }
        };
    }
}

