/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cilib.simulator;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MeasurementCombiner {
    private final File file;

    MeasurementCombiner(File file) {
        this.file = file;
    }

    public void combine(List<String> list, List<File> list2) {
        Preconditions.checkArgument((list.size() >= 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((list2.size() >= 1 ? 1 : 0) != 0);
        try {
            if (this.file.getParent() != null) {
                this.file.getParentFile().mkdirs();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.file));
            int n = 0;
            bufferedWriter.write("# " + n++ + " - Iterations\n");
            for (String string : list) {
                for (int i = 0; i < list2.size(); ++i) {
                    bufferedWriter.write("# " + n + " - " + string + " (" + i + ")\n");
                    ++n;
                }
            }
            this.combineData(bufferedWriter, list2);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long countLines(File file) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new LineNumberReader(new FileReader(file));
            String string = "";
            while ((string = ((LineNumberReader)bufferedReader).readLine()) != null) {
            }
            long l = ((LineNumberReader)bufferedReader).getLineNumber();
            return l;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    private void combineData(BufferedWriter bufferedWriter, List<File> list) {
        Object object;
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        Collections.sort(list, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return Long.compare(MeasurementCombiner.this.countLines(file2), MeasurementCombiner.this.countLines(file));
            }
        });
        for (File object2 : list) {
            try {
                object = new InputStreamReader((InputStream)new FileInputStream(object2), Charset.forName("UTF-8"));
                arrayList.add(new BufferedReader((Reader)object));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException(fileNotFoundException);
            }
        }
        try {
            void var5_8;
            BufferedReader bufferedReader = (BufferedReader)arrayList.get(0);
            String string = bufferedReader.readLine();
            object = string.split(" ");
            int n = ((String[])object).length;
            Entry entry = new Entry(object[0], ((String[])object).length - 1);
            for (int i = 1; i < ((String[])object).length; ++i) {
                entry.add(i - 1, object[i]);
            }
            List list2 = arrayList.subList(1, arrayList.size());
            while (var5_8 != null) {
                for (BufferedReader bufferedReader2 : list2) {
                    try {
                        String string2 = bufferedReader2.readLine();
                        String[] stringArray = string2.split(" ");
                        for (int i = 1; i < stringArray.length; ++i) {
                            entry.add(i - 1, stringArray[i]);
                        }
                    }
                    catch (Exception exception) {
                        for (int i = 1; i < n; ++i) {
                            entry.add(i - 1, "-");
                        }
                    }
                }
                bufferedWriter.write(entry.toString());
                bufferedWriter.newLine();
                String string3 = bufferedReader.readLine();
                if (string3 == null) continue;
                object = string3.split(" ");
                entry = new Entry(object[0], ((String[])object).length - 1);
                for (int i = 1; i < ((String[])object).length; ++i) {
                    entry.add(i - 1, object[i]);
                }
            }
            for (BufferedReader bufferedReader3 : arrayList) {
                bufferedReader3.close();
            }
            for (File file : list) {
                file.delete();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static class Entry {
        private final Multimap<Integer, String> map;
        private final String iteration;

        Entry(String string, int n) {
            this.map = LinkedListMultimap.create((int)n);
            this.iteration = string;
        }

        void add(Integer n, String string) {
            this.map.put((Object)n, (Object)string);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.iteration);
            for (Integer n : this.map.keySet()) {
                for (String string : this.map.get((Object)n)) {
                    stringBuilder.append(" ").append(string);
                }
            }
            return stringBuilder.toString();
        }
    }
}

