/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cilib.simulator;

import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.cilib.algorithm.Algorithm;
import net.sourceforge.cilib.measurement.Measurement;
import net.sourceforge.cilib.measurement.MeasurementStateManager;
import net.sourceforge.cilib.measurement.StateAwareMeasurement;
import net.sourceforge.cilib.type.types.Type;

public class MeasurementSuite {
    private static final long serialVersionUID = 8021290553229945841L;
    private File file;
    private BufferedWriter writer;
    private int resolution = 1;
    private List<Measurement<?>> measurements = new ArrayList();
    private MeasurementStateManager measurementStateManager = new MeasurementStateManager();

    public void initialise() {
        try {
            this.file = File.createTempFile("cilib_data", ".tmp");
            this.writer = new BufferedWriter(new FileWriter(this.file));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setResolution(int n) {
        this.resolution = n;
    }

    public int getResolution() {
        return this.resolution;
    }

    public void addMeasurement(Measurement<?> measurement) {
        this.measurements.add(measurement);
    }

    public void measure(Algorithm algorithm) {
        Type[] typeArray = new Type[this.measurements.size()];
        int n = 0;
        for (Measurement<?> typeArray2 : this.measurements) {
            Type type = null;
            if (typeArray2 instanceof StateAwareMeasurement) {
                StateAwareMeasurement stateAwareMeasurement = (StateAwareMeasurement)typeArray2;
                this.measurementStateManager.setState(algorithm, stateAwareMeasurement);
                type = typeArray2.getValue(algorithm);
                this.measurementStateManager.getState(algorithm, stateAwareMeasurement);
            } else {
                type = typeArray2.getValue(algorithm);
            }
            typeArray[n++] = type;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(algorithm.getIterations());
        for (Type type : typeArray) {
            stringBuilder.append(" ").append(type);
        }
        try {
            this.writer.write(stringBuilder.toString());
            this.writer.newLine();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void add(Measurement<?> measurement) {
        this.measurements.add(measurement);
    }

    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    public List<String> getDescriptions() {
        ArrayList arrayList = Lists.newArrayList();
        for (Measurement<?> measurement : this.measurements) {
            arrayList.add(measurement.getClass().getSimpleName());
        }
        return arrayList;
    }
}

