/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cilib.simulator;

import com.google.common.base.Strings;
import net.sourceforge.cilib.algorithm.ProgressEvent;
import net.sourceforge.cilib.algorithm.ProgressListener;

final class ProgressText
implements ProgressListener {
    private boolean printedDone;
    private final int simulations;

    ProgressText(int n) {
        this.simulations = n;
        this.printedDone = false;
    }

    public void handleProgressEvent(ProgressEvent progressEvent) {
        if (this.printedDone) {
            return;
        }
        double d = (double)((int)(1000.0 * progressEvent.getPercentage())) / 10.0;
        int n = (int)(50.0 * progressEvent.getPercentage());
        String string = Strings.repeat((String)" ", (int)(d < 10.0 ? 2 : (d < 100.0 ? 1 : 0)));
        StringBuilder stringBuilder = new StringBuilder(String.format("\rProgress (%3.1f) %s|", d, string));
        stringBuilder.append(Strings.repeat((String)"=", (int)n));
        stringBuilder.append(Strings.repeat((String)" ", (int)(50 - n)));
        stringBuilder.append("|");
        if (n == 50) {
            this.printedDone = true;
            stringBuilder.append(" done.\n");
        }
        System.out.print(stringBuilder.toString());
    }

    public void setSimulation(int n) {
        System.out.println("Starting simulation " + (n + 1) + " of " + this.simulations + ".");
        this.printedDone = false;
    }
}

