/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cilib.simulator;

import java.io.IOException;
import net.sourceforge.cilib.algorithm.AbstractAlgorithm;
import net.sourceforge.cilib.algorithm.Algorithm;
import net.sourceforge.cilib.algorithm.AlgorithmEvent;
import net.sourceforge.cilib.algorithm.AlgorithmListener;
import net.sourceforge.cilib.math.random.generator.Rand;
import net.sourceforge.cilib.problem.Problem;
import net.sourceforge.cilib.simulator.MeasurementSuite;
import net.sourceforge.cilib.simulator.Simulator;

public class Simulation
implements AlgorithmListener,
Runnable {
    private static final long serialVersionUID = -3733724215662398762L;
    private final Simulator simulator;
    private final Algorithm algorithm;
    private final Problem problem;
    private final MeasurementSuite measurementSuite;

    public Simulation(Simulator simulator, Algorithm algorithm, Problem problem, MeasurementSuite measurementSuite) {
        this.simulator = simulator;
        this.algorithm = algorithm;
        this.problem = problem;
        this.measurementSuite = measurementSuite;
    }

    public void init() {
        AbstractAlgorithm abstractAlgorithm = (AbstractAlgorithm)this.algorithm;
        abstractAlgorithm.addAlgorithmListener((AlgorithmListener)this);
        abstractAlgorithm.setOptimisationProblem(this.problem);
        abstractAlgorithm.performInitialisation();
    }

    @Override
    public void run() {
        Rand.reset();
        this.init();
        this.algorithm.run();
    }

    public void terminate() {
        ((AbstractAlgorithm)this.algorithm).terminate();
    }

    public void algorithmStarted(AlgorithmEvent algorithmEvent) {
        this.measurementSuite.initialise();
    }

    public void algorithmFinished(AlgorithmEvent algorithmEvent) {
        this.measurementSuite.measure(algorithmEvent.getSource());
        this.simulator.updateProgress(this, ((AbstractAlgorithm)algorithmEvent.getSource()).getPercentageComplete());
        try {
            this.measurementSuite.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void iterationCompleted(AlgorithmEvent algorithmEvent) {
        Algorithm algorithm = algorithmEvent.getSource();
        if (algorithm.getIterations() % this.measurementSuite.getResolution() == 0) {
            this.measurementSuite.measure(algorithm);
            this.simulator.updateProgress(this, ((AbstractAlgorithm)algorithm).getPercentageComplete());
        }
    }

    public AlgorithmListener getClone() {
        return this;
    }

    public MeasurementSuite getMeasurementSuite() {
        return this.measurementSuite;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }
}

