/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cilib.simulator;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.cilib.algorithm.Algorithm;
import net.sourceforge.cilib.algorithm.ProgressEvent;
import net.sourceforge.cilib.algorithm.ProgressListener;
import net.sourceforge.cilib.math.random.generator.seeder.SeedSelectionStrategy;
import net.sourceforge.cilib.math.random.generator.seeder.Seeder;
import net.sourceforge.cilib.problem.Problem;
import net.sourceforge.cilib.simulator.MeasurementCombiner;
import net.sourceforge.cilib.simulator.MeasurementSuite;
import net.sourceforge.cilib.simulator.Simulation;
import net.sourceforge.cilib.simulator.XMLObjectFactory;

public class Simulator {
    private static final long serialVersionUID = 8987667794610802908L;
    private final Simulation[] simulations;
    private final CopyOnWriteArrayList<ProgressListener> progressListeners;
    private final Map<Simulation, Double> progress;
    private final XMLObjectFactory algorithmFactory;
    private final XMLObjectFactory problemFactory;
    private final XMLObjectFactory measurementFactory;
    private final MeasurementCombiner combiner;
    private final int samples;
    private final SeedSelectionStrategy seeder;

    public Simulator(XMLObjectFactory xMLObjectFactory, XMLObjectFactory xMLObjectFactory2, XMLObjectFactory xMLObjectFactory3, MeasurementCombiner measurementCombiner, int n, SeedSelectionStrategy seedSelectionStrategy) {
        this.algorithmFactory = xMLObjectFactory;
        this.problemFactory = xMLObjectFactory2;
        this.measurementFactory = xMLObjectFactory3;
        this.combiner = measurementCombiner;
        this.samples = n;
        this.progressListeners = new CopyOnWriteArrayList();
        this.progress = new ConcurrentHashMap<Simulation, Double>();
        this.simulations = new Simulation[n];
        this.seeder = seedSelectionStrategy;
    }

    public void init() {
        Seeder.setSeederStrategy((SeedSelectionStrategy)this.seeder);
        for (int i = 0; i < this.samples; ++i) {
            this.simulations[i] = this.createSimulation();
            this.progress.put(this.simulations[i], 0.0);
        }
    }

    public Simulation createSimulation() {
        return new Simulation(this, (Algorithm)this.algorithmFactory.newObject(), (Problem)this.problemFactory.newObject(), (MeasurementSuite)this.measurementFactory.newObject());
    }

    public void execute() {
        Object object;
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ExecutorCompletionService<Simulation> executorCompletionService = new ExecutorCompletionService<Simulation>(executorService);
        for (int i = 0; i < this.samples; ++i) {
            executorCompletionService.submit(this.simulations[i], this.simulations[i]);
        }
        Simulation[] simulationArray = new Simulation[this.samples];
        try {
            for (int i = 0; i < this.samples; ++i) {
                object = executorCompletionService.take();
                simulationArray[i] = (Simulation)object.get();
            }
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(Simulator.class.getName()).log(Level.SEVERE, null, interruptedException);
        }
        catch (ExecutionException executionException) {
            executorService.shutdownNow();
            throw new RuntimeException(executionException);
        }
        List<String> list = this.simulations[0].getMeasurementSuite().getDescriptions();
        object = Lists.newArrayList();
        for (Simulation simulation : simulationArray) {
            object.add(simulation.getMeasurementSuite().getFile());
        }
        executorService.shutdown();
        this.combiner.combine(list, (List<File>)object);
    }

    public void terminate() {
        for (int i = 0; i < this.samples; ++i) {
            this.simulations[i].terminate();
        }
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.progressListeners.add(progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.progressListeners.remove(progressListener);
    }

    private void notifyProgress() {
        double d = 0.0;
        for (Double d2 : this.progress.values()) {
            d += d2.doubleValue();
        }
        d /= (double)this.progress.size();
        for (ProgressListener progressListener : this.progressListeners) {
            progressListener.handleProgressEvent(new ProgressEvent(d));
        }
    }

    void updateProgress(Simulation simulation, double d) {
        this.progress.put(simulation, d);
        this.notifyProgress();
    }

    public int getSamples() {
        return this.samples;
    }
}

