/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cilib.simulator;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sourceforge.cilib.math.random.generator.seeder.NetworkBasedSeedSelectionStrategy;
import net.sourceforge.cilib.math.random.generator.seeder.SeedSelectionStrategy;
import net.sourceforge.cilib.simulator.MeasurementCombiner;
import net.sourceforge.cilib.simulator.ProgressText;
import net.sourceforge.cilib.simulator.Simulator;
import net.sourceforge.cilib.simulator.XMLObjectFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SimulatorShell {
    private SimulatorShell() {
    }

    public static List<Simulator> prepare(File file) {
        try {
            ArrayList arrayList = Lists.newArrayList();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            NodeList nodeList = document.getElementsByTagName("simulation");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NetworkBasedSeedSelectionStrategy networkBasedSeedSelectionStrategy;
                Object object;
                Element element = (Element)nodeList.item(i);
                XMLObjectFactory xMLObjectFactory = new XMLObjectFactory(document, (Element)element.getElementsByTagName("algorithm").item(0));
                XMLObjectFactory xMLObjectFactory2 = new XMLObjectFactory(document, (Element)element.getElementsByTagName("problem").item(0));
                XMLObjectFactory xMLObjectFactory3 = new XMLObjectFactory(document, (Element)element.getElementsByTagName("measurements").item(0));
                MeasurementCombiner measurementCombiner = SimulatorShell.createCombiner((Element)element.getElementsByTagName("output").item(0));
                int n = element.hasAttribute("samples") ? Integer.valueOf(element.getAttribute("samples")) : 1;
                NodeList nodeList2 = element.getElementsByTagName("seeder");
                if (nodeList2.getLength() >= 1) {
                    object = new XMLObjectFactory(document, (Element)nodeList2.item(0));
                    networkBasedSeedSelectionStrategy = (SeedSelectionStrategy)((XMLObjectFactory)object).newObject();
                } else {
                    networkBasedSeedSelectionStrategy = new NetworkBasedSeedSelectionStrategy();
                }
                object = new Simulator(xMLObjectFactory, xMLObjectFactory2, xMLObjectFactory3, measurementCombiner, n, (SeedSelectionStrategy)networkBasedSeedSelectionStrategy);
                arrayList.add(object);
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error preparing: " + file.getAbsolutePath(), exception);
        }
    }

    public static void execute(Iterable<Simulator> iterable, ProgressText progressText) {
        int n = 0;
        for (Simulator simulator : iterable) {
            simulator.init();
            simulator.addProgressListener(progressText);
            progressText.setSimulation(n++);
            simulator.execute();
        }
    }

    private static MeasurementCombiner createCombiner(Element element) {
        return new MeasurementCombiner(new File(element.getAttribute("file")));
    }
}

