/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cilib.simulator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLObjectFactory {
    private final Document xmlDocument;
    private final Element xmlObjectDescription;

    public XMLObjectFactory(Document document, Element element) {
        this.xmlDocument = document;
        this.xmlObjectDescription = element;
    }

    public Object newObject() {
        return this.newObject(this.xmlObjectDescription);
    }

    private Object newObject(Element element) {
        Class<?> clazz = this.getClass(element);
        Object object = this.instanciate(element, clazz);
        this.setup(object, element);
        return object;
    }

    private Element getReferencedElement(Element element) {
        Element element2;
        if (this.xmlDocument == null) {
            this.error(element, "Can't search for idref without Document");
        }
        if ((element2 = this.xmlDocument.getElementById(element.getAttribute("idref"))) == null) {
            this.error(element, "Invalid idref " + element.getAttribute("idref") + ", no matching id found");
        }
        return element2;
    }

    private Class<?> getClass(Element element) {
        String string = "";
        if (element.hasAttribute("idref")) {
            string = this.getReferencedElement(element).getAttribute("class");
        }
        if (element.hasAttribute("class")) {
            string = element.getAttribute("class");
        }
        if (string.length() == 0) {
            this.error(element, "No class specified");
        }
        try {
            return Class.forName("net.sourceforge.cilib." + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Class not found: net.sourceforge.cilib." + string);
            classNotFoundException.printStackTrace();
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                System.out.println("Class not found: " + string);
                classNotFoundException2.printStackTrace();
                this.error(element, "Class not found: " + string);
                return null;
            }
        }
    }

    private Object instanciate(Element element, Class<?> clazz) {
        Object var3_3 = null;
        try {
            var3_3 = clazz.newInstance();
        }
        catch (Exception exception) {
            this.error(element, "Could not instanciate " + clazz.getName());
        }
        return var3_3;
    }

    private void setup(Object object, Element element) {
        Object object2;
        if (element.hasAttribute("idref")) {
            this.setup(object, this.getReferencedElement(element));
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object2 = (Attr)namedNodeMap.item(i);
            if (object2.getName().equals("id") || object2.getName().equals("idref") || object2.getName().equals("class") || object2.getName().equals("value")) continue;
            this.invokeSetMethod(element, object, object2.getName(), this.newObject(object2.getValue()));
        }
        Element element2 = this.getFirstChildElement(element);
        while (element2 != null) {
            if (element2.hasAttribute("value")) {
                this.invokeAnyMethod(element2, object, element2.getTagName(), this.newObject(element2.getAttribute("value")));
            } else if (element2.hasAttribute("class") || element2.hasAttribute("idref")) {
                this.invokeAnyMethod(element2, object, element2.getTagName(), this.newObject(element2));
            } else if (this.getFirstChildElement(element2) == null) {
                object2 = this.getFirstChildText(element2);
                if (object2 == null) {
                    this.error(element2, "Can't create object from null text");
                }
                this.invokeAnyMethod(element2, object, element2.getTagName(), this.newObject(object2.getNodeValue()));
            } else {
                object2 = new ArrayList();
                Element element3 = this.getFirstChildElement(element2);
                while (element3 != null) {
                    if (element3.hasAttribute("value")) {
                        ((ArrayList)object2).add(this.newObject(element3.getAttribute("value")));
                    } else if (element3.hasAttribute("class") || element3.hasAttribute("idref")) {
                        ((ArrayList)object2).add(this.newObject(element3));
                    } else {
                        Text text = this.getFirstChildText(element3);
                        if (text == null) {
                            this.error(element3, "Can't create object from null text");
                        }
                        ((ArrayList)object2).add(this.newObject(text.getNodeValue()));
                    }
                    element3 = this.getNextSiblingElement(element3);
                }
                this.invokeMethod(element2, object, element2.getTagName(), ((ArrayList)object2).toArray());
            }
            element2 = this.getNextSiblingElement(element2);
        }
    }

    private Element getNextSiblingElement(Node node) {
        for (node = node.getNextSibling(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    private Element getFirstChildElement(Node node) {
        for (node = node.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    private Text getFirstChildText(Node node) {
        for (node = node.getFirstChild(); node != null && node.getNodeType() != 3; node = node.getNextSibling()) {
        }
        return (Text)node;
    }

    private Object newObject(String string) {
        try {
            return Integer.valueOf(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Long.valueOf(string.trim());
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return Double.valueOf(string.trim());
                }
                catch (NumberFormatException numberFormatException3) {
                    if (string.trim().compareToIgnoreCase("true") == 0 || string.trim().compareToIgnoreCase("false") == 0) {
                        return Boolean.valueOf(string);
                    }
                    return string;
                }
            }
        }
    }

    private void invokeAnyMethod(Element element, Object object, String string, Object object2) {
        try {
            this.invokeSetMethod(element, object, string, object2);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{object2};
            this.invokeMethod(element, object, string, objectArray);
        }
    }

    private void invokeSetMethod(Element element, Object object, String string, Object object2) {
        if (string.equals("instance")) {
            System.out.println("we have found an instance request for the value of: " + object2.toString());
            throw new Error("instance");
        }
        String string2 = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
        Object[] objectArray = new Object[]{object2};
        this.invokeMethod(element, object, string2, objectArray);
    }

    private String getParameterString(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(objectArray[i].getClass().getName());
            bl = true;
        }
        return stringBuilder.toString();
    }

    private void invokeMethod(Element element, Object object, String string, Object[] objectArray) {
        Method method = null;
        Method[] methodArray = object.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string) || objectArray.length != methodArray[i].getParameterTypes().length) continue;
            boolean bl = true;
            for (int j = 0; j < objectArray.length; ++j) {
                if (methodArray[i].getParameterTypes()[j].isPrimitive()) {
                    Class<?> clazz = methodArray[i].getParameterTypes()[j];
                    if (objectArray[j] instanceof Integer && !clazz.equals(Integer.TYPE) && !clazz.equals(Long.TYPE) && !clazz.equals(Double.TYPE)) {
                        bl = false;
                        continue;
                    }
                    if (objectArray[j] instanceof Long && !clazz.equals(Long.TYPE) && !clazz.equals(Double.TYPE)) {
                        bl = false;
                        continue;
                    }
                    if (objectArray[j] instanceof Double && !clazz.equals(Double.TYPE)) {
                        bl = false;
                        continue;
                    }
                    if (!(objectArray[j] instanceof Boolean) || clazz.equals(Boolean.TYPE)) continue;
                    bl = false;
                    continue;
                }
                if (methodArray[i].getParameterTypes()[j].isInstance(objectArray[j])) continue;
                bl = false;
            }
            if (!bl) continue;
            method = methodArray[i];
            break;
        }
        if (method == null) {
            this.error(element, object.getClass().getName() + " does not expose a " + string + "(" + this.getParameterString(objectArray) + ") method");
        }
        try {
            method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            this.error(element, "Invoking " + object.getClass().getName() + "." + method.getName() + "(" + this.getParameterString(objectArray) + ") caused: " + invocationTargetException.getTargetException().toString());
        }
        catch (Exception exception) {
            this.error(element, "Could not invoke " + object.getClass().getName() + "." + method.getName() + "(" + this.getParameterString(objectArray) + ")");
        }
    }

    protected void error(Element element, String string) {
        throw new RuntimeException("In <" + element.getTagName() + "> : " + string);
    }
}

