/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.onehilltech.promises.Promise;
import io.reactivex.Observable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.polkadot.api.SubmittableExtrinsic;
import org.polkadot.api.Types;
import org.polkadot.api.derive.Index;
import org.polkadot.api.derive.Types;
import org.polkadot.api.rx.ApiRx;
import org.polkadot.common.EventEmitter;
import org.polkadot.common.ExecutorsManager;
import org.polkadot.direct.IRpcFunction;
import org.polkadot.rpc.core.IRpc;
import org.polkadot.rpc.core.RpcCore;
import org.polkadot.rpc.provider.IProvider;
import org.polkadot.rpc.rx.RpcRx;
import org.polkadot.type.storage.FromMetadata;
import org.polkadot.type.storage.Types;
import org.polkadot.types.Codec;
import org.polkadot.types.Types;
import org.polkadot.types.TypesUtils;
import org.polkadot.types.codec.CodecUtils;
import org.polkadot.types.codec.Linkage;
import org.polkadot.types.codec.TypeRegistry;
import org.polkadot.types.metadata.Metadata;
import org.polkadot.types.primitive.Method;
import org.polkadot.types.primitive.Null;
import org.polkadot.types.primitive.StorageKey;
import org.polkadot.types.rpc.RuntimeVersion;
import org.polkadot.types.type.Event;
import org.polkadot.types.type.Hash;
import org.polkadot.utils.Utils;

public abstract class ApiBase<ApplyResult>
implements Types.ApiBaseInterface<ApplyResult> {
    public static final int KEEPALIVE_INTERVAL = 15000;
    private Types.Derive derive;
    private EventEmitter eventemitter;
    private boolean isReady;
    public Types.Signer signer;
    public RpcCore rpcBase;
    public RpcRx rpcRx;
    protected Types.DecoratedRpc<ApplyResult> decoratedRpc;
    protected Types.ApiOptions options = new Types.ApiOptions();
    private ApiInterfacePromiseDefault promisApi = new ApiInterfacePromiseDefault();
    private ApiType type;
    public Hash genesisHash;
    private Metadata runtimeMetadata;
    public RuntimeVersion runtimeVersion;
    private Types.Storage oriStorage;
    private Types.QueryableStorage<ApplyResult> storage;
    private Method.ModulesWithMethods oriExtrinsics;
    private Types.SubmittableExtrinsics extrinsics;
    private Types.OnCallDefinition<Observable> rxOnCall = new Types.OnCallDefinition<Observable>(){

        @Override
        public Observable apply(Types.OnCallFunction method, List<Object> params, boolean needCallback, IRpcFunction.SubscribeCallback callback) {
            throw new UnsupportedOperationException();
        }
    };
    private Types.OnCallDefinition<Promise> promiseOnCall = new Types.OnCallDefinition<Promise>(){

        @Override
        public Promise apply(Types.OnCallFunction method, List<Object> params, boolean needCallback, IRpcFunction.SubscribeCallback callback) {
            ArrayList args = Lists.newArrayList();
            if (params != null) {
                args.addAll(params);
            }
            if (callback != null) {
                args.add(callback);
            }
            return method.apply(args.toArray(new Object[0]));
        }
    };
    ScheduledFuture<?> healthTimer = null;

    public ApiBase(IProvider provider, ApiType apiType) {
        this(new Types.ApiOptions(), provider, apiType);
    }

    public ApiBase(Types.ApiOptions options, ApiType apiType) {
        this(options, null, apiType);
    }

    private ApiBase(Types.ApiOptions options, IProvider provider, ApiType apiType) {
        IProvider thisProvider = provider;
        if (options.getSource() != null) {
            thisProvider = options.getSource().rpcBase.getProvider().clone();
        } else if (options.getProvider() != null) {
            thisProvider = options.getProvider();
        }
        this.options = options;
        this.type = apiType;
        this.rpcBase = new RpcCore(thisProvider);
        this.rpcRx = new RpcRx(thisProvider);
        this.eventemitter = new EventEmitter();
        this.decoratedRpc = this.decorateRpc(this.rpcBase, this::onCall);
        this.promisApi.rpc = this.decorateRpc(this.rpcBase, this.promiseOnCall);
        this.promisApi.signer = options.getSigner();
        if (options.getSource() != null) {
            this.registerTypes(options.types);
        }
        this.init();
    }

    void registerTypes(Map<String, Types.ConstructorCodec> types) {
        if (types != null) {
            TypeRegistry.registerTypes(types);
        }
    }

    protected <ApplyResult> Types.DecoratedRpc<ApplyResult> decorateRpc(RpcCore rpcCore, final Types.OnCallDefinition<ApplyResult> onCall) {
        Types.DecoratedRpc ret = new Types.DecoratedRpc();
        for (String sectionName : rpcCore.sectionNames()) {
            Types.DecoratedRpcSection decoratedRpcSection = new Types.DecoratedRpcSection();
            IRpc.RpcInterfaceSection section = rpcCore.section(sectionName);
            for (String functionName : section.functionNames()) {
                final IRpcFunction function = (IRpcFunction)section.function(functionName);
                Types.DecoratedRpcMethod decoratedRpcMethod = new Types.DecoratedRpcMethod<ApplyResult>(){

                    @Override
                    public ApplyResult invoke(Object ... params) {
                        Object o;
                        IRpcFunction.SubscribeCallback cb = null;
                        ArrayList values = Lists.newArrayList((Object[])params);
                        if (function.isSubscribe() && CollectionUtils.isNotEmpty((Collection)values) && (o = values.get(values.size() - 1)) instanceof IRpcFunction.SubscribeCallback) {
                            Object remove = values.remove(values.size() - 1);
                            cb = (IRpcFunction.SubscribeCallback)remove;
                        }
                        return onCall.apply(function::invoke, values, function.isSubscribe(), cb);
                    }
                };
                decoratedRpcSection.addFunction(functionName, decoratedRpcMethod);
            }
            ret.addSection(sectionName, decoratedRpcSection);
        }
        return ret;
    }

    protected void emit(IProvider.ProviderInterfaceEmitted type, Object ... args) {
        this.eventemitter.emit(type, args);
    }

    private void init() {
        this.rpcBase.getProvider().on(IProvider.ProviderInterfaceEmitted.disconnected, v -> {
            this.emit(IProvider.ProviderInterfaceEmitted.disconnected, new Object[0]);
            if (this.healthTimer != null && !this.healthTimer.isCancelled() && !this.healthTimer.isDone()) {
                this.healthTimer.cancel(false);
                this.healthTimer = null;
            }
        });
        this.rpcBase.getProvider().on(IProvider.ProviderInterfaceEmitted.error, error -> this.emit(IProvider.ProviderInterfaceEmitted.error, error));
        this.rpcBase.getProvider().on(IProvider.ProviderInterfaceEmitted.connected, args -> this.emit(IProvider.ProviderInterfaceEmitted.connected, new Object[0]));
        this.loadMeta().then(result -> {
            if (result.booleanValue() && !this.isReady) {
                this.isReady = true;
                this.emit(IProvider.ProviderInterfaceEmitted.ready, this);
            }
            this.healthTimer = ExecutorsManager.schedule(() -> ((IRpcFunction)this.rpcBase.system().function("health")).invoke(new Object[0]), 15000L, TimeUnit.MILLISECONDS);
            return null;
        })._catch(err -> {
            err.printStackTrace();
            return null;
        });
    }

    private Promise<Boolean> loadMeta() {
        Promise[] promiseArray;
        if (this.options.source == null || !this.options.source.isReady) {
            Promise[] promiseArray2 = new Promise[3];
            promiseArray2[0] = ((IRpcFunction)this.rpcBase.state().function("getMetadata")).invoke(new Object[0]);
            promiseArray2[1] = ((IRpcFunction)this.rpcBase.chain().function("getRuntimeVersion")).invoke(new Object[0]);
            promiseArray = promiseArray2;
            promiseArray2[2] = ((IRpcFunction)this.rpcBase.chain().function("getBlockHash")).invoke(0);
        } else {
            Promise[] promiseArray3 = new Promise[3];
            promiseArray3[0] = Promise.value((Object)this.options.source.runtimeMetadata);
            promiseArray3[1] = Promise.value((Object)this.options.source.runtimeVersion);
            promiseArray = promiseArray3;
            promiseArray3[2] = Promise.value((Object)this.options.source.genesisHash);
        }
        return Promise.all((Promise[])promiseArray).then(results -> {
            Types.Storage storage;
            this.runtimeMetadata = (Metadata)results.get(0);
            this.runtimeVersion = (RuntimeVersion)results.get(1);
            this.genesisHash = (Hash)results.get(2);
            Method.ModulesWithMethods modulesWithMethods = org.polkadot.type.extrinsics.FromMetadata.fromMetadata(this.runtimeMetadata.asV0());
            this.oriStorage = storage = FromMetadata.fromMetadata(this.runtimeMetadata.asV0());
            this.storage = this.decorateStorage(storage, this::onCall);
            this.oriExtrinsics = modulesWithMethods;
            this.extrinsics = this.decorateExtrinsics(modulesWithMethods, this::onCall);
            this.derive = this.decorateDerive(this.promisApi, this::onCall);
            this.promisApi.genesisHash = this.genesisHash;
            this.promisApi.runtimeVersion = this.runtimeVersion;
            this.promisApi.query = this.decorateStorage(storage, this.promiseOnCall);
            this.promisApi.tx = this.decorateExtrinsics(modulesWithMethods, this.promiseOnCall);
            this.promisApi.derive = this.decorateDerive(this.promisApi, this.promiseOnCall);
            Event.injectMetadata(this.runtimeMetadata.asV0());
            Method.injectMethods(modulesWithMethods);
            return Promise.value((Object)true);
        })._catch(err -> {
            err.printStackTrace();
            return Promise.value((Object)false);
        });
    }

    private Pair<IRpcFunction.SubscribeCallback, Object[]> parseArgs(Object ... _args) {
        IRpcFunction.SubscribeCallback callback = null;
        Object[] args = null;
        if (ArrayUtils.isNotEmpty((Object[])_args) && _args[_args.length - 1] instanceof IRpcFunction.SubscribeCallback) {
            callback = (IRpcFunction.SubscribeCallback)_args[_args.length - 1];
            args = _args.length == 1 ? new Object[]{} : ArrayUtils.subarray((Object[])_args, (int)0, (int)(_args.length - 1));
        } else {
            args = _args;
        }
        return Pair.of(callback, (Object)args);
    }

    private <ApplyResult> Types.Derive<ApplyResult> decorateDerive(Types.ApiInterfacePromise apiInterfacePromise, final Types.OnCallDefinition<ApplyResult> onCallDefinition) {
        Index.Derive derive = Index.decorateDerive(apiInterfacePromise, this.options.derives);
        Types.Derive apiDerive = new Types.Derive();
        for (String sectionName : derive.sectionNames()) {
            Index.DeriveRealSection section = derive.section(sectionName);
            Types.DeriveSection deriveSection = new Types.DeriveSection();
            for (String functionName : section.functionNames()) {
                final Types.DeriveRealFunction function = (Types.DeriveRealFunction)section.function(functionName);
                Types.DeriveMethod deriveMethod = new Types.DeriveMethod<ApplyResult>(){

                    @Override
                    public ApplyResult call(Object ... _args) {
                        Pair subscribeCallbackPair = ApiBase.this.parseArgs(_args);
                        IRpcFunction.SubscribeCallback callback = (IRpcFunction.SubscribeCallback)subscribeCallbackPair.getLeft();
                        Object[] args = (Object[])subscribeCallbackPair.getRight();
                        final IRpcFunction.SubscribeCallback finalCallback = callback;
                        return onCallDefinition.apply(new Types.OnCallFunction(){

                            @Override
                            public Promise apply(Object ... params) {
                                Promise call = function.call(params);
                                return call.then(result -> {
                                    finalCallback.callback(result);
                                    return Promise.value((Object)result);
                                });
                            }
                        }, Lists.newArrayList((Object[])args), callback != null, callback);
                    }
                };
                deriveSection.addFunction(functionName, deriveMethod);
            }
            apiDerive.addSection(sectionName, deriveSection);
        }
        return apiDerive;
    }

    private <ApplyResult> Types.SubmittableExtrinsics<ApplyResult> decorateExtrinsics(Method.ModulesWithMethods extrinsics, Types.OnCallDefinition<ApplyResult> onCallDefinition) {
        Types.SubmittableExtrinsics ret = new Types.SubmittableExtrinsics();
        for (String sectionName : extrinsics.keySet()) {
            Method.Methods section = (Method.Methods)extrinsics.get(sectionName);
            Types.SubmittableModuleExtrinsics submittableModuleExtrinsics = new Types.SubmittableModuleExtrinsics();
            for (String methodName : section.keySet()) {
                Method.MethodFunction methodFunction = (Method.MethodFunction)section.get(methodName);
                Types.SubmittableExtrinsicFunction<ApplyResult> submittableExtrinsicFunction = this.decorateExtrinsicEntry(methodFunction, onCallDefinition);
                submittableModuleExtrinsics.addFunction(methodName, submittableExtrinsicFunction);
            }
            ret.addSection(sectionName, submittableModuleExtrinsics);
        }
        return ret;
    }

    private <ApplyResult> Types.SubmittableExtrinsicFunction<ApplyResult> decorateExtrinsicEntry(final Method.MethodFunction method, final Types.OnCallDefinition<ApplyResult> onCallDefinition) {
        Types.SubmittableExtrinsicFunction ret = new Types.SubmittableExtrinsicFunction(){

            @Override
            public Method apply(Object ... args) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object toJson() {
                throw new UnsupportedOperationException();
            }

            public SubmittableExtrinsic call(Object ... params) {
                return SubmittableExtrinsic.createSubmittableExtrinsic(ApiBase.this.type, ApiBase.this.promisApi, method.apply(params), null, onCallDefinition);
            }
        };
        return ret;
    }

    protected abstract ApplyResult onCall(Types.OnCallFunction var1, List<Object> var2, boolean var3, IRpcFunction.SubscribeCallback var4);

    @Override
    public Types.Derive<ApplyResult> derive() {
        return this.derive;
    }

    @Override
    public Types.QueryableStorage<ApplyResult> query() {
        return this.storage;
    }

    @Override
    public Types.DecoratedRpc<ApplyResult> rpc() {
        return this.decoratedRpc;
    }

    @Override
    public Types.SubmittableExtrinsics tx() {
        return this.extrinsics;
    }

    @Override
    public ApiType getType() {
        return this.type;
    }

    @Override
    public EventEmitter on(IProvider.ProviderInterfaceEmitted type, EventEmitter.EventListener handler) {
        return this.eventemitter.on(type, handler);
    }

    @Override
    public EventEmitter once(IProvider.ProviderInterfaceEmitted type, EventEmitter.EventListener handler) {
        return this.eventemitter.once(type, handler);
    }

    private <ApplyResult> Types.QueryableStorage<ApplyResult> decorateStorage(Types.Storage storage, Types.OnCallDefinition<ApplyResult> onCallDefinition) {
        Types.QueryableStorage queryableStorage = new Types.QueryableStorage();
        for (String sectionName : storage.sectionNames()) {
            Types.QueryableModuleStorage moduleStorage = new Types.QueryableModuleStorage();
            Types.ModuleStorage section = (Types.ModuleStorage)storage.section(sectionName);
            for (String functionName : section.functionNames()) {
                StorageKey.StorageFunction function = (StorageKey.StorageFunction)section.function(functionName);
                Types.QueryableStorageFunction<ApplyResult> storageFunction = this.decorateStorageEntry(function, onCallDefinition);
                moduleStorage.addFunction(functionName, storageFunction);
            }
            queryableStorage.addSection(sectionName, moduleStorage);
        }
        return queryableStorage;
    }

    private <ApplyResult> Types.QueryableStorageFunction<ApplyResult> decorateStorageEntry(final StorageKey.StorageFunction storageMethod, final Types.OnCallDefinition<ApplyResult> onCallDefinition) {
        Types.QueryableStorageFunction queryableStorageFunction = new Types.QueryableStorageFunction<ApplyResult>(){

            @Override
            public byte[] apply(Object ... args) {
                return new byte[0];
            }

            @Override
            public Object toJson() {
                return null;
            }

            @Override
            public ApplyResult call(Object ... _args) {
                Pair subscribeCallbackPair = ApiBase.this.parseArgs(_args);
                IRpcFunction.SubscribeCallback callback = (IRpcFunction.SubscribeCallback)subscribeCallbackPair.getLeft();
                Object[] args = (Object[])subscribeCallbackPair.getRight();
                if (storageMethod.getHeadKey() != null && args.length == 0) {
                    return ApiBase.this.decorateStorageEntryLinked(storageMethod, callback, onCallDefinition);
                }
                RpcCore rpc = ApiBase.this.rpcBase;
                IRpc.RpcInterfaceSection state = rpc.state();
                final IRpcFunction subscribeStorage = (IRpcFunction)state.function("subscribeStorage");
                final IRpcFunction.SubscribeCallback finalCallback = callback;
                IRpcFunction.SubscribeCallback packCallback = callback;
                if (callback != null) {
                    packCallback = new IRpcFunction.SubscribeCallback(){
                        IRpcFunction.SubscribeCallback realCallback;
                        {
                            this.realCallback = finalCallback;
                        }

                        public void callback(Object o) {
                            Object result = ((List)o).get(0);
                            this.realCallback.callback(result);
                        }
                    };
                }
                return onCallDefinition.apply(new StorageOnCallFunction(){

                    @Override
                    public Promise apply(Object ... params) {
                        return subscribeStorage.invoke(params).then(result -> {
                            if (finalCallback == null && result instanceof List) {
                                return Promise.value(((List)result).get(0));
                            }
                            IRpcFunction.Unsubscribe result1 = (IRpcFunction.Unsubscribe)result;
                            return Promise.value((Object)result1);
                        })._catch(err -> {
                            err.printStackTrace();
                            return null;
                        });
                    }
                }, Lists.newArrayList((Object[])new Object[]{new Object[]{new Object[]{storageMethod, args}}}), ApiBase.this instanceof ApiRx, packCallback);
            }

            @Override
            public ApplyResult at(final Object hash, Object arg) {
                RpcCore rpc = ApiBase.this.rpcBase;
                IRpc.RpcInterfaceSection state = rpc.state();
                final IRpcFunction getStorage = (IRpcFunction)state.function("getStorage");
                return onCallDefinition.apply(new Types.OnCallFunction(){

                    @Override
                    public Promise apply(Object ... params) {
                        return getStorage.invoke(new Object[]{storageMethod, params}, hash);
                    }
                }, Lists.newArrayList((Object[])new Object[]{arg}), false, null);
            }

            @Override
            public ApplyResult hash(Object arg) {
                RpcCore rpc = ApiBase.this.rpcBase;
                IRpc.RpcInterfaceSection state = rpc.state();
                final IRpcFunction getStorageHash = (IRpcFunction)state.function("getStorageHash");
                return onCallDefinition.apply(new Types.OnCallFunction(){

                    @Override
                    public Promise apply(Object ... params) {
                        return getStorageHash.invoke(storageMethod, params);
                    }
                }, Lists.newArrayList((Object[])new Object[]{arg}), false, null);
            }

            @Override
            public String key(Object arg) {
                return Utils.u8aToHex((byte[])Utils.compactStripLength(storageMethod.apply(arg)).getRight());
            }

            @Override
            public ApplyResult size(Object arg) {
                RpcCore rpc = ApiBase.this.rpcBase;
                IRpc.RpcInterfaceSection state = rpc.state();
                final IRpcFunction getStorageSize = (IRpcFunction)state.function("getStorageSize");
                return onCallDefinition.apply(new Types.OnCallFunction(){

                    @Override
                    public Promise apply(Object ... params) {
                        return getStorageSize.invoke(storageMethod, params);
                    }
                }, Lists.newArrayList((Object[])new Object[]{arg}), false, null);
            }
        };
        return queryableStorageFunction;
    }

    private Promise getNext(Codec head, Codec key, StorageKey.StorageFunction storageMethod) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        Promise[] subject = new Promise[]{null};
        RpcCore rpc = this.rpcBase;
        IRpc.RpcInterfaceSection state = rpc.state();
        IRpcFunction subscribeStorage = (IRpcFunction)state.function("subscribeStorage");
        return subscribeStorage.invoke(new Object[]{new Object[]{new Object[]{storageMethod, new Object[]{key}}}}).then(data -> {
            Linkage.LinkageResult nextResult;
            Pair entry;
            List<Object> objects = CodecUtils.arrayLikeToList(data);
            objects = CodecUtils.arrayLikeToList(objects.get(0));
            Linkage linkage = (Linkage)objects.get(1);
            result.put(key, Pair.of((Object)((Codec)objects.get(0)), (Object)((Linkage)objects.get(1))));
            if (linkage.getNext().isSome()) {
                return this.getNext(head, (Codec)linkage.getNext().unwrap(), storageMethod);
            }
            ArrayList keys = Lists.newArrayList();
            ArrayList values = Lists.newArrayList();
            Codec nextKey = head;
            while (nextKey != null && (entry = (Pair)result.get(nextKey)) != null) {
                Codec item = (Codec)entry.getLeft();
                Linkage linka = (Linkage)entry.getRight();
                keys.add(nextKey);
                values.add(item);
                if (linka.getNext() == null) continue;
                nextKey = (Codec)linka.getNext().unwrapOr(null);
            }
            Linkage.LinkageResult linkageResult = nextResult = values.isEmpty() ? new Linkage.LinkageResult(TypesUtils.getConstructorCodec(Null.class), Lists.newArrayList(), TypesUtils.getConstructorCodec(Null.class), Lists.newArrayList()) : new Linkage.LinkageResult(TypesUtils.getConstructorCodec(((Codec)keys.get(0)).getClass()), Lists.newArrayList((Iterable)keys), TypesUtils.getConstructorCodec(((Codec)values.get(0)).getClass()), Lists.newArrayList((Iterable)values));
            if (subject[0] != null) {
                subject[0].then(r -> Promise.value((Object)nextResult));
            } else {
                subject[0] = Promise.value((Object)nextResult);
            }
            return subject[0];
        });
    }

    private <ApplyResult> ApplyResult decorateStorageEntryLinked(final StorageKey.StorageFunction storageMethod, final IRpcFunction.SubscribeCallback callback, Types.OnCallDefinition<ApplyResult> onCallDefinition) {
        RpcCore rpc = this.rpcBase;
        IRpc.RpcInterfaceSection state = rpc.state();
        final IRpcFunction subscribeStorage = (IRpcFunction)state.function("subscribeStorage");
        final AtomicReference head = new AtomicReference();
        return onCallDefinition.apply(new Types.OnCallFunction(){

            @Override
            public Promise apply(Object ... params) {
                return subscribeStorage.invoke(params).then(result -> {
                    List<Object> list = CodecUtils.arrayLikeToList(result);
                    if (!list.isEmpty()) {
                        head.set((Codec)list.get(0));
                    }
                    Promise next = ApiBase.this.getNext((Codec)head.get(), (Codec)head.get(), storageMethod);
                    if (callback != null) {
                        return next.then(ret -> {
                            callback.callback(ret);
                            return Promise.value((Object)ret);
                        });
                    }
                    return next;
                });
            }
        }, Lists.newArrayList((Object[])new Object[]{new Object[]{storageMethod.getHeadKey()}}), this instanceof ApiRx, null);
    }

    @Override
    public Hash getGenesisHash() {
        return this.genesisHash;
    }

    @Override
    public RuntimeVersion getRuntimeVersion() {
        return this.runtimeVersion;
    }

    @Override
    public Types.Signer getSigner() {
        return this.signer;
    }

    public boolean hasSubscriptions() {
        return this.rpcBase.getProvider().isHasSubscriptions();
    }

    public Metadata runtimeMetadata() {
        return this.runtimeMetadata;
    }

    public void setSigner(Types.Signer signer) {
        this.promisApi.signer = signer;
    }

    public void disconnect() {
        this.rpcBase.disconnect();
    }

    protected static abstract class StorageOnCallFunction
    implements Types.OnCallFunction {
        protected StorageOnCallFunction() {
        }
    }

    static class ApiInterfacePromiseDefault
    implements Types.ApiInterfacePromise {
        Types.Derive<Promise> derive;
        Types.QueryableStorage<Promise> query;
        Types.DecoratedRpc<Promise> rpc;
        Types.SubmittableExtrinsics<Promise> tx;
        Hash genesisHash;
        Metadata runtimeMetadata;
        RuntimeVersion runtimeVersion;
        Types.Signer signer;

        ApiInterfacePromiseDefault() {
        }

        @Override
        public Hash getGenesisHash() {
            return this.genesisHash;
        }

        @Override
        public RuntimeVersion getRuntimeVersion() {
            return this.runtimeVersion;
        }

        @Override
        public Types.Derive<Promise> derive() {
            return this.derive;
        }

        @Override
        public Types.QueryableStorage<Promise> query() {
            return this.query;
        }

        @Override
        public Types.DecoratedRpc<Promise> rpc() {
            return this.rpc;
        }

        @Override
        public Types.SubmittableExtrinsics<Promise> tx() {
            return this.tx;
        }

        @Override
        public Types.Signer getSigner() {
            return this.signer;
        }
    }

    public static enum ApiType {
        RX,
        PROMISE;

    }
}

