/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.api;

import java.util.List;
import java.util.stream.Collectors;
import org.polkadot.types.rpc.SignedBlock;
import org.polkadot.types.type.EventRecord;
import org.polkadot.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiUtils {
    private static final Logger logger = LoggerFactory.getLogger(ApiUtils.class);

    public static List<EventRecord> filterEvents(byte[] extHash, SignedBlock signedBlock, List<EventRecord> allEvents) {
        String myHash = Utils.u8aToHex(extHash);
        List allHashes = signedBlock.getBlock().getExtrinsics().stream().map(ext -> ext.getHash().toHex()).collect(Collectors.toList());
        int index = allHashes.indexOf(myHash);
        if (index < 0) {
            logger.warn("block {} Unable to find extrinsic {} inside {}", new Object[]{signedBlock.getBlock().getHeader().getHash(), myHash, allHashes});
            return null;
        }
        return allEvents.stream().filter(eventRecord -> eventRecord.getPhase().isApplyExtrinsic() && eventRecord.getPhase().asApplyExtrinsic().intValue() == index).collect(Collectors.toList());
    }
}

