/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.api;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.onehilltech.promises.Promise;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.polkadot.api.ApiBase;
import org.polkadot.api.SubmittableExtrinsic;
import org.polkadot.api.derive.Index;
import org.polkadot.common.EventEmitter;
import org.polkadot.direct.IApi;
import org.polkadot.direct.IFunction;
import org.polkadot.direct.IModule;
import org.polkadot.direct.IRpcFunction;
import org.polkadot.direct.ISection;
import org.polkadot.rpc.provider.IProvider;
import org.polkadot.types.Types;
import org.polkadot.types.primitive.Method;
import org.polkadot.types.primitive.StorageKey;

public interface Types {

    public static abstract class DecoratedRpcMethod<ApplyResult>
    implements IFunction {
        public abstract ApplyResult invoke(Object ... var1);
    }

    public static class DecoratedRpcSection<ApplyResult>
    extends ISection<DecoratedRpcMethod<ApplyResult>> {
        Map<String, DecoratedRpcMethod> methodMap = new HashMap<String, DecoratedRpcMethod>();

        public DecoratedRpcMethod getMethod(String methodName) {
            return this.methodMap.get(methodName);
        }
    }

    public static class DecoratedRpc<ApplyResult>
    implements IModule<DecoratedRpcSection<ApplyResult>> {
        Map<String, DecoratedRpcSection> sectionMap = Maps.newLinkedHashMap();

        @Override
        public DecoratedRpcSection section(String section) {
            return this.sectionMap.get(section);
        }

        @Override
        public Set<String> sectionNames() {
            return Sets.newHashSet((Object[])new String[]{"author", "chain", "state", "system"});
        }

        @Override
        public void addSection(String sectionName, DecoratedRpcSection section) {
            this.sectionMap.put(sectionName, section);
        }

        public DecoratedRpcSection<ApplyResult> author() {
            return this.section("author");
        }

        public DecoratedRpcSection<ApplyResult> chain() {
            return this.section("chain");
        }

        public DecoratedRpcSection<ApplyResult> state() {
            return this.section("state");
        }

        public DecoratedRpcSection<ApplyResult> system() {
            return this.section("system");
        }
    }

    public static interface OnCallFunction {
        public Promise apply(Object ... var1);
    }

    public static interface OnCallDefinition<ApplyResult> {
        public ApplyResult apply(OnCallFunction var1, List<Object> var2, boolean var3, IRpcFunction.SubscribeCallback var4);
    }

    public static class ApiOptions {
        Index.DeriveCustom derives;
        IProvider provider;
        Signer signer;
        ApiBase<?> source;
        Map<String, Types.ConstructorCodec> types;

        public Index.DeriveCustom getDerives() {
            return this.derives;
        }

        public void setDerives(Index.DeriveCustom derives) {
            this.derives = derives;
        }

        public IProvider getProvider() {
            return this.provider;
        }

        public void setProvider(IProvider provider) {
            this.provider = provider;
        }

        public Signer getSigner() {
            return this.signer;
        }

        public void setSigner(Signer signer) {
            this.signer = signer;
        }

        public ApiBase<?> getSource() {
            return this.source;
        }

        public void setSource(ApiBase<?> source) {
            this.source = source;
        }

        public Map<String, Types.ConstructorCodec> getTypes() {
            return this.types;
        }

        public void setTypes(Map<String, Types.ConstructorCodec> types) {
            this.types = types;
        }
    }

    public static interface ApiInterfacePromise
    extends IApi<Promise> {
    }

    public static interface ApiBaseInterface<ApplyResult>
    extends IApi<ApplyResult> {
        public ApiBase.ApiType getType();

        public EventEmitter on(IProvider.ProviderInterfaceEmitted var1, EventEmitter.EventListener var2);

        public EventEmitter once(IProvider.ProviderInterfaceEmitted var1, EventEmitter.EventListener var2);
    }

    public static class Derive<ApplyResult>
    implements IModule<DeriveSection> {
        Map<String, DeriveSection<ApplyResult>> sectionMap = new HashMap<String, DeriveSection<ApplyResult>>();

        @Override
        public DeriveSection<ApplyResult> section(String section) {
            return this.sectionMap.get(section);
        }

        @Override
        public Set<String> sectionNames() {
            return this.sectionMap.keySet();
        }

        @Override
        public void addSection(String sectionName, DeriveSection section) {
            this.sectionMap.put(sectionName, section);
        }
    }

    public static class DeriveSection<ApplyResult>
    extends ISection<DeriveMethod<ApplyResult>> {
    }

    public static abstract class DeriveMethod<ApplyResult>
    implements IFunction {
        public abstract ApplyResult call(Object ... var1);
    }

    public static interface Signer {
        public Promise<Integer> sign(Types.IExtrinsic var1, String var2, Types.SignatureOptions var3);

        public void update(int var1, Object var2);
    }

    public static class SubmittableExtrinsics<ApplyResult>
    implements IModule<SubmittableModuleExtrinsics> {
        Map<String, SubmittableModuleExtrinsics> sections = new LinkedHashMap<String, SubmittableModuleExtrinsics>();

        @Override
        public SubmittableModuleExtrinsics section(String section) {
            return this.sections.get(section);
        }

        @Override
        public Set<String> sectionNames() {
            return this.sections.keySet();
        }

        @Override
        public void addSection(String sectionName, SubmittableModuleExtrinsics section) {
            this.sections.put(sectionName, section);
        }
    }

    public static class SubmittableModuleExtrinsics
    extends ISection<SubmittableExtrinsicFunction> {
    }

    public static abstract class SubmittableExtrinsicFunction<ApplyResult>
    extends Method.MethodFunction {
        public abstract SubmittableExtrinsic<ApplyResult> call(Object ... var1);
    }

    public static class QueryableStorage<ApplyResult>
    implements IModule<QueryableModuleStorage<ApplyResult>> {
        Map<String, QueryableModuleStorage<ApplyResult>> sections = Maps.newLinkedHashMap();

        @Override
        public QueryableModuleStorage<ApplyResult> section(String section) {
            return this.sections.get(section);
        }

        @Override
        public Set<String> sectionNames() {
            return this.sections.keySet();
        }

        @Override
        public void addSection(String name, QueryableModuleStorage<ApplyResult> section) {
            this.sections.put(name, section);
        }
    }

    public static class QueryableModuleStorage<ApplyResult>
    extends ISection<QueryableStorageFunction<ApplyResult>> {
    }

    public static abstract class QueryableStorageFunction<ApplyResult>
    extends StorageKey.StorageFunction {
        public abstract ApplyResult call(Object ... var1);

        public abstract ApplyResult at(Object var1, Object var2);

        public abstract ApplyResult hash(Object var1);

        public abstract String key(Object var1);

        public abstract ApplyResult size(Object var1);
    }
}

