/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.api.derive.balances;

import com.google.common.collect.Lists;
import com.onehilltech.promises.Promise;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.polkadot.api.Types;
import org.polkadot.api.derive.Types;
import org.polkadot.api.derive.accounts.AccountFunctions;
import org.polkadot.direct.ISection;
import org.polkadot.types.type.AccountId;
import org.polkadot.types.type.Balance;

public class BalancesFunctions {
    public static AccountId EMPTY_ACCOUNT = new AccountId(new byte[32]);

    public static Types.DeriveRealFunction fees(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                ISection feesSection = api.query().section("fees");
                return Promise.all((Promise[])new Promise[]{(Promise)((Types.QueryableStorageFunction)api.query().section("balances").function("creationFee")).call(new Object[0]), (Promise)((Types.QueryableStorageFunction)api.query().section("balances").function("existentialDeposit")).call(new Object[0]), feesSection != null ? (Promise)((Types.QueryableStorageFunction)feesSection.function("transactionBaseFee")).call(new Object[0]) : (Promise)((Types.QueryableStorageFunction)api.query().section("balances").function("transactionBaseFee")).call(new Object[0]), feesSection != null ? (Promise)((Types.QueryableStorageFunction)feesSection.function("transactionByteFee")).call(new Object[0]) : (Promise)((Types.QueryableStorageFunction)api.query().section("balances").function("transactionByteFee")).call(new Object[0]), (Promise)((Types.QueryableStorageFunction)api.query().section("balances").function("transferFee")).call(new Object[0])}).then(results -> {
                    BigInteger creationFee = (BigInteger)results.get(0);
                    BigInteger existentialDeposit = (BigInteger)results.get(1);
                    BigInteger transactionBaseFee = (BigInteger)results.get(2);
                    BigInteger transactionByteFee = (BigInteger)results.get(3);
                    BigInteger transferFee = (BigInteger)results.get(4);
                    return Promise.value((Object)new Types.DerivedFees(creationFee, existentialDeposit, transactionBaseFee, transactionByteFee, transferFee));
                });
            }
        };
    }

    public static Types.DeriveRealFunction votingBalance(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                Object adress = args[0];
                return AccountFunctions.idAndIndex(api).call(adress).then(result -> {
                    AccountFunctions.AccountIdAndIndex idAndIndex = (AccountFunctions.AccountIdAndIndex)result;
                    if (idAndIndex.accountId != null) {
                        return Promise.all((Promise[])new Promise[]{Promise.value((Object)idAndIndex.accountId), (Promise)((Types.QueryableStorageFunction)api.query().section("balances").function("freeBalance")).call(idAndIndex.accountId), (Promise)((Types.QueryableStorageFunction)api.query().section("balances").function("reservedBalance")).call(idAndIndex.accountId)});
                    }
                    return Promise.all((Promise[])new Promise[]{Promise.value(null), Promise.value(null), Promise.value(null)});
                }).then(results -> {
                    List resultList = (List)results;
                    AccountId accountId = resultList.get(0) == null ? EMPTY_ACCOUNT : (AccountId)resultList.get(0);
                    Balance freeBalance = resultList.get(1) == null ? new Balance(0) : (Balance)resultList.get(1);
                    Balance reservedBalance = resultList.get(2) == null ? new Balance(0) : (Balance)resultList.get(2);
                    Types.DerivedBalances derivedBalances = new Types.DerivedBalances(accountId, freeBalance, new Balance(0), reservedBalance, new Balance(0), new Balance(freeBalance.add(reservedBalance)), null);
                    return Promise.value((Object)derivedBalances);
                });
            }
        };
    }

    public static Types.DeriveRealFunction votingBalances(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                List addresses = (List)args[0];
                if (CollectionUtils.isNotEmpty((Collection)addresses)) {
                    List<Promise> promiseList = addresses.stream().map(address -> BalancesFunctions.votingBalance(api).call(address)).collect(Collectors.toList());
                    return Promise.all((Promise[])promiseList.toArray(new Promise[0]));
                }
                return Promise.value((Object)Lists.newArrayList());
            }
        };
    }

    public static Types.DeriveRealFunction votingBalancesNominatorsFor(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                Object address = args[0];
                return AccountFunctions.idAndIndex(api).call(address).then(result -> {
                    AccountFunctions.AccountIdAndIndex accountIdAndIndex = (AccountFunctions.AccountIdAndIndex)result;
                    if (accountIdAndIndex.accountId != null) {
                        return (Promise)((Types.QueryableStorageFunction)api.query().section("staking").function("nominatorsFor")).call(accountIdAndIndex.accountId);
                    }
                    return Promise.value((Object)Lists.newArrayList());
                }).then(results -> BalancesFunctions.votingBalances(api).call(results));
            }
        };
    }

    public static Types.DeriveRealFunction validatingBalance(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                Object address = args[0];
                return Promise.all((Promise[])new Promise[]{BalancesFunctions.votingBalance(api).call(address), BalancesFunctions.votingBalancesNominatorsFor(api).call(address)}).then(results -> {
                    Types.DerivedBalances balances = (Types.DerivedBalances)results.get(0);
                    List nominators = (List)results.get(1);
                    BigInteger nominatedBalance = BigInteger.valueOf(0L);
                    for (Types.DerivedBalances nominator : nominators) {
                        nominatedBalance.add(nominator.votingBalance);
                    }
                    Types.DerivedBalances ret = new Types.DerivedBalances(balances.accountId, balances.freeBalance, new Balance(nominatedBalance), balances.reservedBalance, balances.votingBalance, new Balance(nominatedBalance.add(balances.votingBalance)), nominators);
                    return Promise.value((Object)ret);
                });
            }
        };
    }

    public static Types.DeriveRealFunction validatingBalances(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                List accountIds = (List)args[0];
                if (CollectionUtils.isEmpty((Collection)accountIds)) {
                    return Promise.value((Object)new Types.DerivedBalancesMap());
                }
                List<Promise> collect = accountIds.stream().map(accountId -> BalancesFunctions.validatingBalance(api).call(accountId)).collect(Collectors.toList());
                return Promise.all((Promise[])collect.toArray(new Promise[0])).then(results -> {
                    Types.DerivedBalancesMap balances = new Types.DerivedBalancesMap();
                    for (Object result : results) {
                        Types.DerivedBalances derivedBalances = (Types.DerivedBalances)result;
                        balances.put(derivedBalances.accountId.toString(), derivedBalances);
                    }
                    return Promise.value((Object)balances);
                });
            }
        };
    }
}

