/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.api.derive.chain;

import com.google.common.collect.Lists;
import com.onehilltech.promises.Promise;
import java.math.BigInteger;
import java.util.List;
import org.polkadot.api.Types;
import org.polkadot.api.derive.Types;
import org.polkadot.direct.ISection;
import org.polkadot.types.type.AccountId;
import org.polkadot.types.type.BlockNumber;
import org.polkadot.types.type.Header;

public class ChainFunctions {
    public static Types.DeriveRealFunction bestNumber(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                return ((Promise)((Types.DecoratedRpcMethod)api.rpc().chain().function("subscribeNewHead")).invoke(new Object[0])).then(result -> {
                    Header header = (Header)result;
                    if (header != null && header.getBlockNumber() != null) {
                        return Promise.value((Object)header.getBlockNumber());
                    }
                    throw new UnsupportedOperationException();
                });
            }
        };
    }

    public static Types.DeriveRealFunction bestNumberFinalized(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                return ((Promise)((Types.DecoratedRpcMethod)api.rpc().chain().function("subscribeFinalizedHeads")).invoke(new Object[0])).then(result -> {
                    Header header = (Header)result;
                    if (header != null && header.getBlockNumber() != null) {
                        return Promise.value((Object)header.getBlockNumber());
                    }
                    throw new UnsupportedOperationException();
                });
            }
        };
    }

    public static Types.DeriveRealFunction bestNumberLag(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                return Promise.all((Promise[])new Promise[]{ChainFunctions.bestNumber(api).call(new Object[0]), ChainFunctions.bestNumberFinalized(api).call(new Object[0])}).then(results -> {
                    BlockNumber bestNumber = (BlockNumber)results.get(0);
                    BlockNumber bestNumberFinalized = (BlockNumber)results.get(1);
                    BigInteger subtract = bestNumber.subtract(bestNumberFinalized);
                    BlockNumber ret = new BlockNumber(subtract);
                    return Promise.value((Object)ret);
                });
            }
        };
    }

    public static Types.DeriveRealFunction getHeader(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                Object hash = args[0];
                ISection session = api.query().section("session");
                return Promise.all((Promise[])new Promise[]{(Promise)((Types.DecoratedRpcMethod)api.rpc().chain().function("getHeader")).invoke(hash), session == null ? (Promise)((Types.QueryableStorageFunction)session.function("validators")).at(hash, null) : Promise.value((Object)Lists.newArrayList())}).then(results -> {
                    Header header = (Header)results.get(0);
                    List validators = (List)results.get(1);
                    Header.HeaderExtended headerExtended = new Header.HeaderExtended(header, validators);
                    return Promise.value((Object)headerExtended);
                })._catch(err -> Promise.value(null));
            }
        };
    }

    public static Types.DeriveRealFunction subscribeNewHead(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                return ((Promise)((Types.DecoratedRpcMethod)api.rpc().chain().function("subscribeNewHead")).invoke(new Object[0])).then(result -> {
                    Header header = (Header)result;
                    ISection session = api.query().section("session");
                    return Promise.all((Promise[])new Promise[]{Promise.value((Object)header), session == null ? (Promise)((Types.QueryableStorageFunction)session.function("validators")).at(header.getHash(), null) : Promise.value((Object)Lists.newArrayList())}).then(results -> {
                        Header header2 = (Header)results.get(0);
                        List validators = (List)results.get(1);
                        Header.HeaderExtended headerExtended = new Header.HeaderExtended(header2, validators);
                        return Promise.value((Object)headerExtended);
                    });
                });
            }
        };
    }

    public static class HeaderAndValidators {
        Header header;
        List<AccountId> accountIds;
    }
}

