/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.api.derive.democracy;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.onehilltech.promises.Promise;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.polkadot.api.Types;
import org.polkadot.api.derive.Types;
import org.polkadot.api.derive.balances.BalancesFunctions;
import org.polkadot.direct.ISection;
import org.polkadot.types.TypesUtils;
import org.polkadot.types.codec.CodecUtils;
import org.polkadot.types.codec.Option;
import org.polkadot.types.codec.Vector;
import org.polkadot.types.type.AccountId;
import org.polkadot.types.type.Balance;
import org.polkadot.types.type.ReferendumIndex;
import org.polkadot.types.type.ReferendumInfo;
import org.polkadot.types.type.Vote;

public class DemocracyFunctions {
    public static Types.DeriveRealFunction votes(final Types.ApiInterfacePromise api) {
        Types.DeriveRealFunction ret = new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                BigInteger referendumId = new BigInteger(args[0].toString());
                List accountIds = (List)args[1];
                if (CollectionUtils.isEmpty((Collection)accountIds)) {
                    return Promise.value((Object)Lists.newArrayList());
                }
                ISection democracy = api.query().section("democracy");
                Types.QueryableStorageFunction voteOf = (Types.QueryableStorageFunction)democracy.function("voteOf");
                List<Promise> collect = accountIds.stream().map(accountId -> (Promise)voteOf.call(Lists.newArrayList((Object[])new Object[]{referendumId, accountId}))).collect(Collectors.toList());
                return Promise.all((Promise[])collect.toArray(new Promise[0]));
            }
        };
        return ret;
    }

    public static Types.DeriveRealFunction referendumInfo(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                Number index = (Number)args[0];
                Types.QueryableStorageFunction referendumInfoOf = (Types.QueryableStorageFunction)api.query().section("democracy").function("referendumInfoOf");
                return ((Promise)referendumInfoOf.call(index.intValue())).then(result -> {
                    Option optionInfo = (Option)result;
                    ReferendumInfo info = (ReferendumInfo)optionInfo.unwrapOr(null);
                    return Promise.value(new Option(TypesUtils.getConstructorCodec(ReferendumInfoExtended.class), info == null ? null : new ReferendumInfoExtended(info, index.intValue())));
                });
            }
        };
    }

    public static Types.DeriveRealFunction referendumInfos(Types.ApiInterfacePromise api) {
        final Types.DeriveRealFunction referendumInfoOf = DemocracyFunctions.referendumInfo(api);
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                List ids = (List)args[0];
                if (CollectionUtils.isEmpty((Collection)ids)) {
                    return Promise.value((Object)Lists.newArrayList());
                }
                List<Promise> collect = ids.stream().map(xva$0 -> referendumInfoOf.call(xva$0)).collect(Collectors.toList());
                return Promise.all((Promise[])collect.toArray(new Promise[0]));
            }
        };
    }

    public static Types.DeriveRealFunction referendums(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                return Promise.all((Promise[])new Promise[]{(Promise)((Types.QueryableStorageFunction)api.query().section("democracy").function("nextTally")).call(new Object[0]), (Promise)((Types.QueryableStorageFunction)api.query().section("democracy").function("referendumCount")).call(new Object[0])}).then(results -> {
                    ReferendumIndex nextTally = (ReferendumIndex)results.get(0);
                    ReferendumIndex referendumCount = (ReferendumIndex)results.get(1);
                    if (referendumCount != null && nextTally != null && referendumCount.compareTo(nextTally) > 0 && referendumCount.compareTo(BigInteger.ZERO) >= 0) {
                        int arrayLength = referendumCount.subtract(nextTally).intValue();
                        ArrayList list = Lists.newArrayList();
                        for (int i = 0; i < arrayLength; ++i) {
                            nextTally.add(BigInteger.valueOf(i));
                            list.add(nextTally.intValue());
                        }
                        return DemocracyFunctions.referendumInfos(api).call(list);
                    }
                    return Promise.value((Object)Lists.newArrayList());
                });
            }
        };
    }

    public static Types.DeriveRealFunction referendumVotesFor(final Types.ApiInterfacePromise api) {
        Types.DeriveRealFunction ret = new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                Object referendumId = args[0];
                return ((Promise)((Types.QueryableStorageFunction)api.query().section("democracy").function("votersFor")).call(referendumId)).then(result -> {
                    Vector votersFor = (Vector)result;
                    return Promise.all((Promise[])new Promise[]{Promise.value((Object)votersFor), DemocracyFunctions.votes(api).call(referendumId, votersFor), BalancesFunctions.votingBalances(api).call(votersFor)});
                }).then(results -> {
                    List<Object> resultList = CodecUtils.arrayLikeToList(results);
                    Vector votersFor = (Vector)resultList.get(0);
                    List votes = (List)resultList.get(1);
                    List balances = (List)resultList.get(2);
                    ArrayList ret = Lists.newArrayList();
                    for (int index = 0; index < votersFor.size(); ++index) {
                        AccountId accountId = (AccountId)votersFor.get(index);
                        Balance balance = balances.size() > index ? ((Types.DerivedBalances)balances.get((int)index)).votingBalance : new Balance(0);
                        Vote vote = votes.size() > index ? (Vote)votes.get(index) : new Vote(0);
                        Types.DerivedReferendumVote derivedReferendumVote = new Types.DerivedReferendumVote(accountId, balance, vote);
                        ret.add(derivedReferendumVote);
                    }
                    return Promise.value((Object)ret);
                });
            }
        };
        return ret;
    }

    public static class ReferendumInfoExtended
    extends ReferendumInfo {
        private ReferendumIndex index;

        public ReferendumInfoExtended(ReferendumInfo value, int index) {
            super((Object)value);
            this.index = value instanceof ReferendumInfoExtended ? ((ReferendumInfoExtended)value).index : new ReferendumIndex(index);
        }

        public ReferendumIndex getIndex() {
            return this.index;
        }

        @Override
        public Object toJson() {
            JSONObject jsonObject = (JSONObject)super.toJson();
            jsonObject.put("index", this.index.toJson());
            return jsonObject;
        }
    }
}

